(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Wolfram 14.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       154,          7]
NotebookDataLength[   1304496,      26300]
NotebookOptionsPosition[   1274180,      25891]
NotebookOutlinePosition[   1274573,      25907]
CellTagsIndexPosition[   1274530,      25904]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{"<<", "VilTeX`"}]], "Input",
 CellChangeTimes->{{3.966968271457609*^9, 3.9669682779533978`*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"6539cd85-e3fb-42f9-9b8d-ed2b2aa96ee7"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[GridBox[{
    {
     StyleBox["\<\"\|01f680 VilTeX cargado\"\>",
      StripOnInput->False,
      LineColor->RGBColor[0, 0, 1],
      FrontFaceColor->RGBColor[0, 0, 1],
      BackFaceColor->RGBColor[0, 0, 1],
      GraphicsColor->RGBColor[0, 0, 1],
      FontSize->16,
      FontWeight->Bold,
      FontColor->RGBColor[0, 0, 1]]},
    {
     StyleBox["\<\"\:2705 Listo para usar. Versi\[OAcute]n del \
01/10/2025.\"\>",
      StripOnInput->False,
      LineColor->GrayLevel[0],
      FrontFaceColor->GrayLevel[0],
      BackFaceColor->GrayLevel[0],
      GraphicsColor->GrayLevel[0],
      FontWeight->Bold,
      FontColor->GrayLevel[0]]}
   },
   DefaultBaseStyle->"Column",
   GridBoxAlignment->{"Columns" -> {{Left}}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Column"]], "Print",
 CellChangeTimes->{3.9669682799375896`*^9, 3.967286901838539*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[1]:=",ExpressionUUID->"afb2451c-0e7d-4392-9a1e-8679bfb45022"],

Cell[BoxData["\<\"Mostrando editores ya detectados...\"\>"], "Print",
 CellChangeTimes->{3.9669682799375896`*^9, 3.967286928068612*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[1]:=",ExpressionUUID->"7de04e0a-7889-44de-a1c1-65d3404c0d73"],

Cell[BoxData["\<\"=== EDITORES LaTeX DETECTADOS ===\"\>"], "Print",
 CellChangeTimes->{3.9669682799375896`*^9, 3.967286928069524*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[1]:=",ExpressionUUID->"1af58c78-5aa4-410a-be9b-c882f505abba"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Checkmark] \"\>", "\[InvisibleSpace]", "\<\"TeXShop\"\>", 
   "\[InvisibleSpace]", "\<\" \[RightArrow] \"\>", 
   "\[InvisibleSpace]", "\<\"TeXShop\"\>"}],
  SequenceForm["\[Checkmark] ", "TeXShop", " \[RightArrow] ", "TeXShop"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9669682799375896`*^9, 3.967286928069991*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[1]:=",ExpressionUUID->"e38c4321-d374-411c-abd1-89d5dbd01d2c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Checkmark] \"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\" \[RightArrow] \"\>", 
   "\[InvisibleSpace]", "\<\"texstudio-4.8.8-osx-m1\"\>"}],
  SequenceForm[
  "\[Checkmark] ", "TeXstudio", " \[RightArrow] ", "texstudio-4.8.8-osx-m1"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9669682799375896`*^9, 3.967286928070458*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[1]:=",ExpressionUUID->"f4e8fa54-6fb4-4028-8793-e4b2fd84f7c4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Checkmark] \"\>", "\[InvisibleSpace]", "\<\"Texifier\"\>", 
   "\[InvisibleSpace]", "\<\" \[RightArrow] \"\>", 
   "\[InvisibleSpace]", "\<\"Texifier\"\>"}],
  SequenceForm["\[Checkmark] ", "Texifier", " \[RightArrow] ", "Texifier"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9669682799375896`*^9, 3.967286928070887*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[1]:=",ExpressionUUID->"a4a95122-9fcf-4892-96c1-97164b7ab234"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Checkmark] \"\>", "\[InvisibleSpace]", "\<\"LaTeXiT\"\>", 
   "\[InvisibleSpace]", "\<\" \[RightArrow] \"\>", 
   "\[InvisibleSpace]", "\<\"LaTeXiT\"\>"}],
  SequenceForm["\[Checkmark] ", "LaTeXiT", " \[RightArrow] ", "LaTeXiT"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9669682799375896`*^9, 3.967286928071301*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[1]:=",ExpressionUUID->"998a2b48-a357-460b-9bff-4eaf36261d2c"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["10. ExportToTikZGraphics3D", "Subtitle",
 CellChangeTimes->{{3.964711967446312*^9, 3.9647120331966953`*^9}, {
   3.965828746741377*^9, 3.965828772379876*^9}, {3.966422117997758*^9, 
   3.966422160573628*^9}, {3.9664222257197533`*^9, 3.966422232684371*^9}, 
   3.9664306609167547`*^9, {3.966530370457416*^9, 3.966530387294182*^9}, {
   3.967219136269286*^9, 3.967219136772613*^9}},
 Background->RGBColor[
  0.4, 0.6, 1, 0.33],ExpressionUUID->"e620c90a-a47e-4279-8a06-c63909917048"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "ExportToTikZGraphics3D"}]], "Input",
 CellChangeTimes->{{3.967212059920351*^9, 3.9672120690149555`*^9}},
 CellLabel->"In[2]:=",ExpressionUUID->"454c0d59-ae84-6242-a536-9bde44f91856"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = False, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox[
             TagBox[
              TooltipBox[
               StyleBox["\<\" Symbol\"\>", "InformationRowLabel",
                StripOnInput->False],
               "\"Symbol\"",
               TooltipStyle->"TextStyling"],
              Annotation[#, "Symbol", "Tooltip"]& ], "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"ExportToTikZGraphics3D[graphics, filename, grid, \
axisType, axisExtension, resolution, textAnnotations, maxPolygons] exporta \
objetos Graphics3D de Mathematica a c\[OAcute]digo TikZ/LaTeX para su uso en \
documentos acad\[EAcute]micos y \
publicaciones.\\n\\nPAR\[CapitalAAcute]METROS:\\n\\ngraphics - Objeto \
Graphics3D, lista de primitivas 3D, o primitiva individual v\[AAcute]lida\\n  \
  \[Bullet] Graphics3D[primitivas] - Objeto gr\[AAcute]fico 3D completo\\n    \
\[Bullet] {Point[...], Line[...], Polygon[...]} - Lista de primitivas\\n    \
\[Bullet] Point[{x,y,z}] - Primitiva individual\\n    \[Bullet] Primitivas \
soportadas: Point, Line, Polygon, Sphere, Cylinder, Cone, Cuboid, Ellipsoid, \
Arrow, Tube, Text, Style\\n\\nfilename - Cadena de texto con el nombre del \
archivo de salida\\n    \[Bullet] Debe terminar en '.tex'\\n    \[Bullet] No \
debe contener caracteres especiales: <, >, :, \\\", /, \\\\, |, ?, *\\n    \
\[Bullet] Ejemplo: \\\"migrafico.tex\\\"\\n\\ngrid (por defecto: True) - \
Controla la visualizaci\[OAcute]n de la grilla\\n    \[Bullet] True - Muestra \
grilla mayor en el gr\[AAcute]fico\\n    \[Bullet] False - Sin \
grilla\\n\\naxisType (por defecto: \\\"box\\\") - Estilo de los ejes del gr\
\[AAcute]fico\\n    \[Bullet] \\\"box\\\" - Ejes tipo caja (6 caras)\\n    \
\[Bullet] \\\"center\\\" - Ejes centrados con flechas\\n    \[Bullet] \
\\\"none\\\" - Sin ejes visibles\\n\\naxisExtension (por defecto: 0.0) - \
Extensi\[OAcute]n adicional de los ejes (solo para \
axisType=\\\"center\\\")\\n    \[Bullet] Valor \[GreaterEqual] 0.0\\n    \
\[Bullet] Se expresa como fracci\[OAcute]n del rango de datos\\n    \[Bullet] \
Ejemplo: 0.1 extiende ejes 10% m\[AAcute]s all\[AAcute] de los \
datos\\n\\nresolution (por defecto: 50) - Resoluci\[OAcute]n para superficies \
y objetos curvos\\n    \[Bullet] Entero positivo\\n    \[Bullet] Valores t\
\[IAcute]picos: 20-100\\n    \[Bullet] Advertencia si > 200 (archivos muy \
grandes)\\n\\ntextAnnotations (por defecto: {}) - Anotaciones de texto \
adicionales\\n    \[Bullet] Formato: {{\\\"texto\\\", {x,y,z}}, {\\\"texto2\\\
\", {x2,y2,z2}, opciones}, ...}\\n    \[Bullet] Coordenadas {x,y,z} deben ser \
num\[EAcute]ricas\\n    \[Bullet] Opciones (tercer elemento, opcional): \\n   \
     - {{\\\"color\\\", \\\"red\\\"}} - Color del texto\\n        - \
{{\\\"size\\\", \\\"\\\\Large\\\"}} - Tama\[NTilde]o del texto LaTeX\\n       \
 - {{\\\"anchor\\\", \\\"center\\\"}} - Anclaje del texto\\n        - \
{{\\\"rotate\\\", \\\"45\\\"}} - Rotaci\[OAcute]n en grados\\n    \[Bullet] \
Ejemplo: {{\\\"Punto A\\\", {1,2,3}}, {\\\"Origen\\\", {0,0,0}, {{\\\"color\\\
\", \\\"red\\\"}, {\\\"size\\\", \\\"\\\\large\\\"}}}}\\n\\nmaxPolygons (por \
defecto: 500) - L\[IAcute]mite m\[AAcute]ximo de pol\[IAcute]gonos a exportar\
\\n    \[Bullet] Entero positivo\\n    \[Bullet] Previene archivos \
excesivamente grandes\\n    \[Bullet] Advertencia si > 10000 (problemas de \
rendimiento)\\n    \[Bullet] Los pol\[IAcute]gonos que excedan el \
l\[IAcute]mite se omiten\\n\\nCONFIGURACIONES FIJAS:\\n    \[Bullet] Color \
por defecto: azul (\\\"blue\\\") para elementos sin color \
espec\[IAcute]fico\\n    \[Bullet] Mapa de colores: viridis (esquema de \
colores perceptualmente uniforme)\\n\\nVALORES DE RETORNO:\\n\[Bullet] Ruta \
completa del archivo .tex generado si la exportaci\[OAcute]n es exitosa\\n\
\[Bullet] $Failed si hay errores en los argumentos\\n\\nCARACTER\
\[CapitalIAcute]STICAS ESPECIALES:\\n\\nPrimitivas 3D soportadas:\\n\[Bullet] \
Point[{x,y,z}] o Point[{{x1,y1,z1}, {x2,y2,z2}, ...}] - Puntos individuales o \
m\[UAcute]ltiples\\n\[Bullet] Line[{{x1,y1,z1}, {x2,y2,z2}, ...}] - \
L\[IAcute]neas conectadas\\n\[Bullet] Polygon[{{x1,y1,z1}, {x2,y2,z2}, ...}] \
- Pol\[IAcute]gonos cerrados\\n\[Bullet] Sphere[{x,y,z}, radio] - Esferas \
representadas como malla de l\[IAcute]neas\\n\[Bullet] Cylinder[{{x1,y1,z1}, \
{x2,y2,z2}}, radio] - Cilindros como malla\\n\[Bullet] \
Cone[{{base_x,base_y,base_z}, {apex_x,apex_y,apex_z}}, radio] - Conos como \
malla\\n\[Bullet] Cuboid[{xmin,ymin,zmin}, {xmax,ymax,zmax}] - Paralelep\
\[IAcute]pedos como esqueleto\\n\[Bullet] Ellipsoid[{x,y,z}, {a,b,c}] - \
Elipsoides como malla de l\[IAcute]neas\\n\[Bullet] Arrow[{{x1,y1,z1}, \
{x2,y2,z2}}] - Flechas 3D\\n\[Bullet] Tube[Line[puntos], radio] - Tubos \
convertidos a l\[IAcute]neas\\n\[Bullet] Text[\\\"texto\\\", {x,y,z}] - \
Etiquetas de texto\\n\[Bullet] Style[primitiva, color, PointSize[tam], \
Thickness[esp], Dashed] - Estilos aplicados\\n\\nEstilos soportados:\\n\
\[Bullet] Colores: Red, Blue, Green, Black, Orange, Gray, White, Yellow, \
Purple, Brown, Pink, Cyan, Magenta (colores de Mathematica), cadenas \
equivalentes (\\\"red\\\", \\\"blue\\\", etc.), RGBColor[r,g,b], \
GrayLevel[nivel], Hue[matiz]\\n\[Bullet] PointSize[tama\[NTilde]o] - Tama\
\[NTilde]o de puntos (Tiny, Small, Medium, Large, o valor \
num\[EAcute]rico)\\n\[Bullet] Thickness[grosor] - Grosor de l\[IAcute]neas \
(Tiny, Small, Medium, Large, Thick, o valor num\[EAcute]rico)\\n\[Bullet] \
Dashed o Dashing[patr\[OAcute]n] - L\[IAcute]neas \
discontinuas\\n\\nSalida:\\n\[Bullet] Genera archivo .tex standalone completo \
con tikz y pgfplots\\n\[Bullet] Incluye paquetes necesarios: tikz, pgfplots, \
amsmath, amssymb\\n\[Bullet] Compatible con compiladores LaTeX \
est\[AAcute]ndar\\n\[Bullet] Se guarda en \
$HomeDirectory/Downloads/[nombre_archivo]/\\n\\nEJEMPLOS DE USO:\\n\\nEjemplo \
b\[AAcute]sico (solo par\[AAcute]metros \
obligatorios):\\nExportToTikZGraphics3D[Graphics3D[{Red, Sphere[{0,0,0}, \
1]}], \\\"esfera.tex\\\"]\\n\\nCon grid \
desactivado:\\nExportToTikZGraphics3D[\\n  Graphics3D[{Blue, Sphere[{0,0,0}, \
1], Green, Line[{{-2,0,0}, {2,0,0}}]}],\\n  \\\"grafico.tex\\\",\\n  \
False\\n]\\n\\nEspecificando todos los \
par\[AAcute]metros:\\nExportToTikZGraphics3D[\\n  Graphics3D[{Blue, \
Sphere[{0,0,0}, 1], Green, Line[{{-2,0,0}, {2,0,0}}]}],\\n  \
\\\"grafico_completo.tex\\\",\\n  True,                    (* grid *)\\n  \
\\\"center\\\",              (* axisType *)\\n  0.2,                     (* \
axisExtension *)\\n  30,                      (* resolution *)\\n  \
{{\\\"Centro\\\", {0,0,0}, {{\\\"color\\\", \\\"black\\\"}}}}, (* \
textAnnotations *)\\n  1000                     (* maxPolygons *)\\n]\\n\\nM\
\[UAcute]ltiples primitivas con estilos:\\nExportToTikZGraphics3D[\\n  {\\n   \
 Style[Sphere[{0,0,0}, 1], Red],\\n    Style[Cuboid[{-2,-2,-2}, {-1,-1,-1}], \
Blue, Thickness[2]],\\n    Style[Line[{{1,1,1}, {2,2,2}}], Green, Dashed]\\n  \
},\\n  \\\"complejo.tex\\\",\\n  True,                    (* grid *)\\n  \
\\\"box\\\",                 (* axisType *)\\n  0.0,                     (* \
axisExtension *)\\n  30,                      (* resolution *)\\n  {},        \
              (* textAnnotations *)\\n  1000                     (* \
maxPolygons *)\\n]\\n\\nUso m\[IAcute]nimo con algunos \
par\[AAcute]metros:\\nExportToTikZGraphics3D[\\n  Graphics3D[Point[{{0,0,0}, \
{1,1,1}, {2,0,1}}]],\\n  \\\"puntos.tex\\\",\\n  False,                   (* \
sin grid *)\\n  \\\"none\\\"                 (* sin ejes *)\\n]\\n\\nNOTAS \
IMPORTANTES:\\n\[Bullet] Los archivos generados requieren LaTeX con tikz y \
pgfplots instalados\\n\[Bullet] Para gr\[AAcute]ficos complejos, considere \
reducir resolution y aumentar maxPolygons\\n\[Bullet] Los colores se mapean a \
los colores b\[AAcute]sicos de TikZ m\[AAcute]s cercanos\\n\[Bullet] Las \
coordenadas se formatean a 3 decimales para optimizar el archivo\\n\[Bullet] \
Se a\[NTilde]ade padding autom\[AAcute]tico del 10% alrededor de los datos\\n\
\[Bullet] El colormap viridis y el color azul por defecto est\[AAcute]n \
optimizados para publicaciones acad\[EAcute]micas\\n\[Bullet] Todos los par\
\[AAcute]metros opcionales pueden omitirse desde la derecha (ej: solo \
graphics y filename para caso m\[AAcute]s simple)\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[
           TagBox[GridBox[{
              {
               StyleBox[
                TagBox[
                 TooltipBox[
                  StyleBox["\<\" Definitions\"\>", "InformationRowLabel",
                   StripOnInput->False],
                  "\"Definitions\"",
                  TooltipStyle->"TextStyling"],
                 Annotation[#, "Definitions", "Tooltip"]& ], "DialogStyle",
                StripOnInput->False]},
              {
               TemplateBox[{"\"\[ThinSpace]\"", 
                 GridBox[{{
                    RowBox[{
                    RowBox[{"ExportToTikZGraphics3D", "[", 
                    
                    RowBox[{
                    "VilTeX`Private`graphics3DArgs_", ",", 
                    "VilTeX`Private`filename_", ",", 
                    RowBox[{"VilTeX`Private`grid_", ":", "True"}], ",", 
                    RowBox[{"VilTeX`Private`axisType_", ":", "\"box\""}], ",", 
                    RowBox[{"VilTeX`Private`axisExtension_", ":", "0.`"}], 
                    ",", 
                    RowBox[{"VilTeX`Private`resolution_", ":", "50"}], ",", 
                    RowBox[{"VilTeX`Private`textAnnotations_", ":", 
                    RowBox[{"{", "}"}]}], ",", 
                    RowBox[{"VilTeX`Private`maxPolygons_", ":", "500"}]}], 
                    "]"}], ":=", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`tikzCode", ",", 
                    "VilTeX`Private`fullDocument", ",", 
                    "VilTeX`Private`downloadPath", ",", 
                    "VilTeX`Private`folderName", ",", 
                    "VilTeX`Private`folderPath", ",", 
                    "VilTeX`Private`formatNumber", ",", 
                    "VilTeX`Private`validNumber", ",", 
                    "VilTeX`Private`allPrimitives", ",", 
                    "VilTeX`Private`globalLimits", ",", 
                    "VilTeX`Private`allValidData", ",", 
                    "VilTeX`Private`combinedTikzCode", ",", 
                    "VilTeX`Private`textTikzCode", ",", 
                    "VilTeX`Private`axisConfiguration", ",", 
                    "VilTeX`Private`colormapStyle", ",", 
                    "VilTeX`Private`opacityStyle", ",", 
                    "VilTeX`Private`flatElements", ",", 
                    RowBox[{"VilTeX`Private`polygonCount", "=", "0"}], ",", 
                    "VilTeX`Private`validColormaps", ",", 
                    RowBox[{"VilTeX`Private`errors", "=", 
                    RowBox[{"{", "}"}]}], ",", "VilTeX`Private`validateColor",
                     ",", "VilTeX`Private`validateGraphics3D", ",", 
                    "VilTeX`Private`validateTextAnnotations"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"Clear", "[", 
                    
                    RowBox[{"VilTeX`Private`pointSizeToNumber", ",", 
                    "VilTeX`Private`thicknessToNumber", ",", 
                    "VilTeX`Private`colorToTikZ", ",", 
                    "VilTeX`Private`detectBasicColor", ",", 
                    "VilTeX`Private`coneToLines", ",", 
                    "VilTeX`Private`ellipsoidToLines", ",", 
                    "VilTeX`Private`sphereToLines", ",", 
                    "VilTeX`Private`cylinderToLines", ",", 
                    "VilTeX`Private`cuboidToLines", ",", 
                    "VilTeX`Private`polygonToLines", ",", 
                    "VilTeX`Private`flattenElements", ",", 
                    "VilTeX`Private`addValidCoords"}], "]"}], ";", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`validateColor", "[", 
                    "VilTeX`Private`color_", "]"}], ":=", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`validNamedColors", ",", 
                    "VilTeX`Private`validColor"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`validNamedColors", "=", 
                    RowBox[{"{", 
                    
                    RowBox[{"Red", ",", "Blue", ",", "Green", ",", "Black", 
                    ",", "Orange", ",", "Gray", ",", "White", ",", "Yellow", 
                    ",", "Purple", ",", "Brown", ",", "Pink", ",", "Cyan", 
                    ",", "Magenta"}], "}"}]}], ";", 
                    RowBox[{"VilTeX`Private`validColor", "=", 
                    RowBox[{"Which", "[", 
                    RowBox[{
                    RowBox[{"MemberQ", "[", 
                    
                    RowBox[{"VilTeX`Private`validNamedColors", ",", 
                    "VilTeX`Private`color"}], "]"}], ",", "True", ",", 
                    RowBox[{
                    RowBox[{"StringQ", "[", "VilTeX`Private`color", "]"}], 
                    "&&", 
                    RowBox[{"MemberQ", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"\"red\"", ",", "\"blue\"", ",", "\"green\"", ",",
                     "\"black\"", ",", "\"orange\"", ",", "\"gray\"", ",", 
                    "\"white\"", ",", "\"yellow\"", ",", "\"purple\"", ",", 
                    "\"brown\"", ",", "\"pink\"", ",", "\"cyan\"", ",", 
                    "\"magenta\""}], "}"}], ",", 
                    
                    RowBox[{"ToLowerCase", "[", "VilTeX`Private`color", 
                    "]"}]}], "]"}]}], ",", "True", ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Head", "[", "VilTeX`Private`color", "]"}], "===",
                     "RGBColor"}], "&&", 
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`color", "]"}], 
                    "\[GreaterEqual]", "3"}], "&&", 
                    RowBox[{"AllTrue", "[", 
                    RowBox[{
                    RowBox[{"Take", "[", 
                    RowBox[{"VilTeX`Private`color", ",", "3"}], "]"}], ",", 
                    "NumericQ"}], "]"}], "&&", 
                    RowBox[{"AllTrue", "[", 
                    RowBox[{
                    RowBox[{"Take", "[", 
                    RowBox[{"VilTeX`Private`color", ",", "3"}], "]"}], ",", 
                    RowBox[{
                    RowBox[{"0", "\[LessEqual]", "#1", "\[LessEqual]", "1"}], 
                    "&"}]}], "]"}]}], ",", "True", ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Head", "[", "VilTeX`Private`color", "]"}], "===",
                     "GrayLevel"}], "&&", 
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`color", "]"}], 
                    "\[Equal]", "1"}], "&&", 
                    RowBox[{"NumericQ", "[", 
                    
                    RowBox[{"VilTeX`Private`color", "\[LeftDoubleBracket]", 
                    "1", "\[RightDoubleBracket]"}], "]"}], "&&", 
                    RowBox[{"0", "\[LessEqual]", 
                    
                    RowBox[{"VilTeX`Private`color", "\[LeftDoubleBracket]", 
                    "1", "\[RightDoubleBracket]"}], "\[LessEqual]", "1"}]}], 
                    ",", "True", ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Head", "[", "VilTeX`Private`color", "]"}], "===",
                     "Hue"}], "&&", 
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`color", "]"}], 
                    "\[GreaterEqual]", "1"}], "&&", 
                    RowBox[{"NumericQ", "[", 
                    
                    RowBox[{"VilTeX`Private`color", "\[LeftDoubleBracket]", 
                    "1", "\[RightDoubleBracket]"}], "]"}]}], ",", "True", ",",
                     "True", ",", "False"}], "]"}]}], ";", 
                    "VilTeX`Private`validColor"}]}], "]"}]}], ";", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`validateGraphics3D", "[", 
                    "VilTeX`Private`graphics_", "]"}], ":=", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`valid3DPrimitives", ",", 
                    "VilTeX`Private`isValid"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`valid3DPrimitives", "=", 
                    RowBox[{"{", 
                    
                    RowBox[{"Point", ",", "Line", ",", "Polygon", ",", 
                    "Sphere", ",", "Cylinder", ",", "Cone", ",", "Cuboid", 
                    ",", "Ellipsoid", ",", "Arrow", ",", "Tube", ",", "Text", 
                    ",", "Style"}], "}"}]}], ";", 
                    RowBox[{"VilTeX`Private`isValid", "=", 
                    RowBox[{"Which", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Head", "[", "VilTeX`Private`graphics", "]"}], 
                    "===", "Graphics3D"}], ",", "True", ",", 
                    RowBox[{"ListQ", "[", "VilTeX`Private`graphics", "]"}], 
                    ",", 
                    RowBox[{"AllTrue", "[", 
                    RowBox[{
                    RowBox[{"Flatten", "[", "VilTeX`Private`graphics", "]"}], 
                    ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"Head", "[", "#1", "]"}], "===", "Style"}], "||", 
                    
                    RowBox[{"MemberQ", "[", 
                    RowBox[{"VilTeX`Private`valid3DPrimitives", ",", 
                    RowBox[{"Head", "[", "#1", "]"}]}], "]"}], "||", 
                    RowBox[{"MemberQ", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"Red", ",", "Blue", ",", "Green", ",", "Black", 
                    ",", "Orange", ",", "Gray", ",", "White", ",", "Yellow", 
                    ",", "Purple", ",", "Brown", ",", "Pink", ",", "Cyan", 
                    ",", "Magenta"}], "}"}], ",", "#1"}], "]"}], "||", 
                    RowBox[{
                    RowBox[{"Head", "[", "#1", "]"}], "===", "RGBColor"}], 
                    "||", 
                    RowBox[{
                    RowBox[{"Head", "[", "#1", "]"}], "===", "GrayLevel"}], 
                    "||", 
                    RowBox[{
                    RowBox[{"Head", "[", "#1", "]"}], "===", "Hue"}], "||", 
                    RowBox[{
                    RowBox[{"Head", "[", "#1", "]"}], "===", "PointSize"}], 
                    "||", 
                    RowBox[{
                    RowBox[{"Head", "[", "#1", "]"}], "===", "Thickness"}], 
                    "||", 
                    RowBox[{"#1", "===", "Dashed"}], "||", 
                    RowBox[{
                    RowBox[{"Head", "[", "#1", "]"}], "===", "Dashing"}]}], 
                    "&"}]}], "]"}], ",", 
                    RowBox[{"MemberQ", "[", 
                    RowBox[{"VilTeX`Private`valid3DPrimitives", ",", 
                    RowBox[{"Head", "[", "VilTeX`Private`graphics", "]"}]}], 
                    "]"}], ",", "True", ",", "True", ",", "False"}], "]"}]}], 
                    ";", "VilTeX`Private`isValid"}]}], "]"}]}], ";", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`validateTextAnnotations", "[", 
                    "VilTeX`Private`annotations_", "]"}], ":=", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", "VilTeX`Private`isValid", "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`isValid", "=", 
                    RowBox[{"Which", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`annotations", "===", 
                    RowBox[{"{", "}"}]}], ",", "True", ",", 
                    RowBox[{"!", 
                    
                    RowBox[{"ListQ", "[", "VilTeX`Private`annotations", 
                    "]"}]}], ",", "False", ",", "True", ",", 
                    RowBox[{"AllTrue", "[", 
                    RowBox[{"VilTeX`Private`annotations", ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ListQ", "[", "#1", "]"}], "&&", 
                    RowBox[{
                    RowBox[{"Length", "[", "#1", "]"}], "\[GreaterEqual]", 
                    "2"}], "&&", 
                    RowBox[{"StringQ", "[", 
                    
                    RowBox[{"#1", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], "]"}], "&&", 
                    RowBox[{"ListQ", "[", 
                    
                    RowBox[{"#1", "\[LeftDoubleBracket]", "2", 
                    "\[RightDoubleBracket]"}], "]"}], "&&", 
                    RowBox[{
                    RowBox[{"Length", "[", 
                    
                    RowBox[{"#1", "\[LeftDoubleBracket]", "2", 
                    "\[RightDoubleBracket]"}], "]"}], "\[Equal]", "3"}], "&&", 
                    RowBox[{"AllTrue", "[", 
                    RowBox[{
                    
                    RowBox[{"#1", "\[LeftDoubleBracket]", "2", 
                    "\[RightDoubleBracket]"}], ",", "NumericQ"}], "]"}], "&&", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "#1", "]"}], "\[LessEqual]", "2"}],
                     "||", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "#1", "]"}], "\[Equal]", "3"}], 
                    "&&", 
                    RowBox[{"ListQ", "[", 
                    
                    RowBox[{"#1", "\[LeftDoubleBracket]", "3", 
                    "\[RightDoubleBracket]"}], "]"}]}], ")"}]}], ")"}]}], 
                    "&"}]}], "]"}]}], "]"}]}], ";", 
                    "VilTeX`Private`isValid"}]}], "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"!", 
                    
                    RowBox[{"VilTeX`Private`validateGraphics3D", "[", 
                    "VilTeX`Private`graphics3DArgs", "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"AppendTo", "[", 
                    
                    RowBox[{"VilTeX`Private`errors", ",", 
                    "\"Error: graphics3DArgs debe ser un objeto Graphics3D o \
una lista de primitivas 3D v\[AAcute]lidas\""}], "]"}], ";"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"!", 
                    
                    RowBox[{"StringQ", "[", "VilTeX`Private`filename", 
                    "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"AppendTo", "[", 
                    
                    RowBox[{"VilTeX`Private`errors", ",", 
                    "\"Error: filename debe ser una cadena de texto\""}], 
                    "]"}], ";"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"StringQ", "[", "VilTeX`Private`filename", "]"}], 
                    "&&", 
                    RowBox[{"!", 
                    RowBox[{"StringEndsQ", "[", 
                    RowBox[{"VilTeX`Private`filename", ",", "\".tex\""}], 
                    "]"}]}]}], ",", 
                    RowBox[{
                    RowBox[{"AppendTo", "[", 
                    
                    RowBox[{"VilTeX`Private`errors", ",", 
                    "\"Error: filename debe terminar con la extensi\[OAcute]n \
'.tex'\""}], "]"}], ";"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"StringQ", "[", "VilTeX`Private`filename", "]"}], 
                    "&&", 
                    RowBox[{"StringContainsQ", "[", 
                    RowBox[{"VilTeX`Private`filename", ",", 
                    
                    RowBox[{"RegularExpression", "[", 
                    "\"[<>:\\\"/\\\\\\\\|?*]\"", "]"}]}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"AppendTo", "[", 
                    
                    RowBox[{"VilTeX`Private`errors", ",", 
                    "\"Error: filename contiene caracteres no v\[AAcute]lidos \
para nombres de archivo\""}], "]"}], ";"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"BooleanQ", "[", "VilTeX`Private`grid", "]"}]}], 
                    ",", 
                    RowBox[{
                    RowBox[{"AppendTo", "[", 
                    
                    RowBox[{"VilTeX`Private`errors", ",", 
                    "\"Error: grid debe ser True o False\""}], "]"}], ";"}]}],
                     "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"MemberQ", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"\"box\"", ",", "\"center\"", ",", "\"none\""}], 
                    "}"}], ",", "VilTeX`Private`axisType"}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"AppendTo", "[", 
                    
                    RowBox[{"VilTeX`Private`errors", ",", 
                    "\"Error: axisType debe ser \\\"box\\\", \\\"center\\\" o \
\\\"none\\\"\""}], "]"}], ";"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"!", 
                    
                    RowBox[{"NumericQ", "[", "VilTeX`Private`axisExtension", 
                    "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"AppendTo", "[", 
                    
                    RowBox[{"VilTeX`Private`errors", ",", 
                    "\"Error: axisExtension debe ser un n\[UAcute]mero\""}], 
                    "]"}], ";"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"NumericQ", "[", "VilTeX`Private`axisExtension", 
                    "]"}], "&&", 
                    RowBox[{"VilTeX`Private`axisExtension", "<", "0"}]}], ",", 
                    RowBox[{
                    RowBox[{"AppendTo", "[", 
                    
                    RowBox[{"VilTeX`Private`errors", ",", 
                    "\"Error: axisExtension debe ser mayor o igual a 0\""}], 
                    "]"}], ";"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"!", 
                    
                    RowBox[{"IntegerQ", "[", "VilTeX`Private`resolution", 
                    "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"AppendTo", "[", 
                    
                    RowBox[{"VilTeX`Private`errors", ",", 
                    "\"Error: resolution debe ser un n\[UAcute]mero \
entero\""}], "]"}], ";"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"IntegerQ", "[", "VilTeX`Private`resolution", 
                    "]"}], "&&", 
                    
                    RowBox[{"VilTeX`Private`resolution", "\[LessEqual]", 
                    "0"}]}], ",", 
                    RowBox[{
                    RowBox[{"AppendTo", "[", 
                    
                    RowBox[{"VilTeX`Private`errors", ",", 
                    "\"Error: resolution debe ser mayor que 0\""}], "]"}], 
                    ";"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"IntegerQ", "[", "VilTeX`Private`resolution", 
                    "]"}], "&&", 
                    RowBox[{"VilTeX`Private`resolution", ">", "200"}]}], ",", 
                    
                    RowBox[{
                    RowBox[{"AppendTo", "[", 
                    
                    RowBox[{"VilTeX`Private`errors", ",", 
                    "\"Error: resolution muy alto (>200) puede generar \
archivos muy grandes\""}], "]"}], ";"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"!", 
                    
                    RowBox[{"VilTeX`Private`validateTextAnnotations", "[", 
                    "VilTeX`Private`textAnnotations", "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"AppendTo", "[", 
                    
                    RowBox[{"VilTeX`Private`errors", ",", 
                    "\"Error: textAnnotations debe ser una lista con formato: \
{{\\\"texto\\\", {x,y,z}}, ...}\""}], "]"}], ";"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"!", 
                    
                    RowBox[{"IntegerQ", "[", "VilTeX`Private`maxPolygons", 
                    "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"AppendTo", "[", 
                    
                    RowBox[{"VilTeX`Private`errors", ",", 
                    "\"Error: maxPolygons debe ser un n\[UAcute]mero \
entero\""}], "]"}], ";"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"IntegerQ", "[", "VilTeX`Private`maxPolygons", 
                    "]"}], "&&", 
                    
                    RowBox[{"VilTeX`Private`maxPolygons", "\[LessEqual]", 
                    "0"}]}], ",", 
                    RowBox[{
                    RowBox[{"AppendTo", "[", 
                    
                    RowBox[{"VilTeX`Private`errors", ",", 
                    "\"Error: maxPolygons debe ser mayor que 0\""}], "]"}], 
                    ";"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"IntegerQ", "[", "VilTeX`Private`maxPolygons", 
                    "]"}], "&&", 
                    RowBox[{"VilTeX`Private`maxPolygons", ">", "10000"}]}], 
                    ",", 
                    RowBox[{
                    RowBox[{"AppendTo", "[", 
                    
                    RowBox[{"VilTeX`Private`errors", ",", 
                    "\"Error: maxPolygons muy alto (>10000) puede causar \
problemas de rendimiento\""}], "]"}], ";"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`errors", "]"}], 
                    ">", "0"}], ",", 
                    RowBox[{
                    RowBox[{"Do", "[", 
                    RowBox[{
                    RowBox[{"Print", "[", 
                    RowBox[{"\"  \"", "<>", 
                    
                    RowBox[{"VilTeX`Private`errors", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`i", "\[RightDoubleBracket]"}]}], "]"}], 
                    ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`i", ",", 
                    RowBox[{"Length", "[", "VilTeX`Private`errors", "]"}]}], 
                    "}"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", 
                    RowBox[{"Select", "[", 
                    RowBox[{"VilTeX`Private`errors", ",", 
                    RowBox[{
                    RowBox[{"StringStartsQ", "[", 
                    RowBox[{"#1", ",", "\"Error:\""}], "]"}], "&"}]}], "]"}], 
                    "]"}], ">", "0"}], ",", 
                    RowBox[{
                    RowBox[{"Return", "[", "$Failed", "]"}], ";"}]}], "]"}], 
                    ";"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"!", 
                    
                    RowBox[{"StringQ", "[", "VilTeX`Private`filename", 
                    "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"Return", "[", "$Failed", "]"}], ";"}]}], "]"}], 
                    ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"StringEndsQ", "[", 
                    RowBox[{"VilTeX`Private`filename", ",", "\".tex\""}], 
                    "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"Return", "[", "$Failed", "]"}], ";"}]}], "]"}], 
                    ";", 
                    RowBox[{"VilTeX`Private`axisConfiguration", "=", 
                    RowBox[{"Which", "[", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`axisType", "\[Equal]", 
                    "\"box\""}], ",", "\"axis lines=box\"", ",", 
                    
                    RowBox[{"VilTeX`Private`axisType", "\[Equal]", 
                    "\"center\""}], ",", 
                    "\"axis lines=center, axis line style={->}\"", ",", 
                    
                    RowBox[{"VilTeX`Private`axisType", "\[Equal]", 
                    "\"none\""}], ",", "\"axis lines=none\"", ",", "True", 
                    ",", "\"axis lines=box\""}], "]"}]}], ";", 
                    
                    RowBox[{"VilTeX`Private`colormapStyle", "=", 
                    "\"colormap/viridis\""}], ";", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    "VilTeX`Private`x_", "]"}], ":=", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`num", "=", 
                    RowBox[{"N", "[", "VilTeX`Private`x", "]"}]}], "}"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"NumericQ", "[", "VilTeX`Private`num", "]"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", "VilTeX`Private`num", "]"}], "<", 
                    "0.001`"}], ",", "\"0.000\"", ",", 
                    RowBox[{"ToString", "[", 
                    RowBox[{
                    RowBox[{"Round", "[", 
                    RowBox[{"VilTeX`Private`num", ",", "0.001`"}], "]"}], ",",
                     "FortranForm"}], "]"}]}], "]"}], ",", "\"0.000\""}], 
                    "]"}]}], "]"}]}], ";", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`pointSizeToNumber", "[", 
                    "VilTeX`Private`size_", "]"}], ":=", 
                    RowBox[{"Which", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`size", "===", "Tiny"}], ",", 
                    "0.5`", ",", 
                    RowBox[{"VilTeX`Private`size", "===", "Small"}], ",", 
                    "1.`", ",", 
                    RowBox[{"VilTeX`Private`size", "===", "Medium"}], ",", 
                    "1.5`", ",", 
                    RowBox[{"VilTeX`Private`size", "===", "Large"}], ",", 
                    "2.5`", ",", 
                    RowBox[{"NumericQ", "[", "VilTeX`Private`size", "]"}], 
                    ",", 
                    RowBox[{
                    RowBox[{"N", "[", "VilTeX`Private`size", "]"}], " ", 
                    "50"}], ",", "True", ",", "1.`"}], "]"}]}], ";", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`thicknessToNumber", "[", 
                    "VilTeX`Private`thickness_", "]"}], ":=", 
                    RowBox[{"Which", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`thickness", "===", "Tiny"}], ",", 
                    "0.5`", ",", 
                    RowBox[{"VilTeX`Private`thickness", "===", "Small"}], ",",
                     "1.`", ",", 
                    RowBox[{"VilTeX`Private`thickness", "===", "Medium"}], 
                    ",", "1.5`", ",", 
                    RowBox[{"VilTeX`Private`thickness", "===", "Large"}], ",",
                     "3.`", ",", 
                    RowBox[{"VilTeX`Private`thickness", "===", "Thick"}], ",",
                     "2.`", ",", 
                    
                    RowBox[{"NumericQ", "[", "VilTeX`Private`thickness", 
                    "]"}], ",", 
                    RowBox[{
                    RowBox[{"N", "[", "VilTeX`Private`thickness", "]"}], " ", 
                    "10"}], ",", "True", ",", "1.`"}], "]"}]}], ";", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`colorToTikZ", "[", 
                    "VilTeX`Private`color_", "]"}], ":=", 
                    RowBox[{"Which", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`color", "===", "Red"}], ",", 
                    "\"red\"", ",", 
                    RowBox[{"VilTeX`Private`color", "===", "Blue"}], ",", 
                    "\"blue\"", ",", 
                    RowBox[{"VilTeX`Private`color", "===", "Green"}], ",", 
                    "\"green\"", ",", 
                    RowBox[{"VilTeX`Private`color", "===", "Black"}], ",", 
                    "\"black\"", ",", 
                    RowBox[{"VilTeX`Private`color", "===", "White"}], ",", 
                    "\"white\"", ",", 
                    RowBox[{"VilTeX`Private`color", "===", "Yellow"}], ",", 
                    "\"yellow\"", ",", 
                    RowBox[{"VilTeX`Private`color", "===", "Orange"}], ",", 
                    "\"orange\"", ",", 
                    RowBox[{"VilTeX`Private`color", "===", "Purple"}], ",", 
                    "\"purple\"", ",", 
                    RowBox[{"VilTeX`Private`color", "===", "Brown"}], ",", 
                    "\"brown\"", ",", 
                    RowBox[{"VilTeX`Private`color", "===", "Pink"}], ",", 
                    "\"pink\"", ",", 
                    RowBox[{"VilTeX`Private`color", "===", "Gray"}], ",", 
                    "\"gray\"", ",", 
                    RowBox[{"VilTeX`Private`color", "===", "Cyan"}], ",", 
                    "\"cyan\"", ",", 
                    RowBox[{"VilTeX`Private`color", "===", "Magenta"}], ",", 
                    "\"magenta\"", ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Head", "[", "VilTeX`Private`color", "]"}], "===",
                     "RGBColor"}], "&&", 
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`color", "]"}], 
                    "\[GreaterEqual]", "3"}]}], ",", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`r", ",", "VilTeX`Private`g", ",", 
                    "VilTeX`Private`b"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`r", ",", "VilTeX`Private`g", ",", 
                    "VilTeX`Private`b"}], "}"}], "=", 
                    RowBox[{"N", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`color", "\[LeftDoubleBracket]", 
                    "1", "\[RightDoubleBracket]"}], ",", 
                    
                    RowBox[{"VilTeX`Private`color", "\[LeftDoubleBracket]", 
                    "2", "\[RightDoubleBracket]"}], ",", 
                    
                    RowBox[{"VilTeX`Private`color", "\[LeftDoubleBracket]", 
                    "3", "\[RightDoubleBracket]"}]}], "}"}], "]"}]}], ";", 
                    RowBox[{"Which", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"VilTeX`Private`r", ">", "0.8`"}], "&&", 
                    RowBox[{"VilTeX`Private`g", "<", "0.3`"}], "&&", 
                    RowBox[{"VilTeX`Private`b", "<", "0.3`"}]}], ",", 
                    "\"red\"", ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`r", "<", "0.3`"}], "&&", 
                    RowBox[{"VilTeX`Private`g", "<", "0.3`"}], "&&", 
                    RowBox[{"VilTeX`Private`b", ">", "0.8`"}]}], ",", 
                    "\"blue\"", ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`r", "<", "0.3`"}], "&&", 
                    RowBox[{"VilTeX`Private`g", ">", "0.8`"}], "&&", 
                    RowBox[{"VilTeX`Private`b", "<", "0.3`"}]}], ",", 
                    "\"green\"", ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`r", "<", "0.2`"}], "&&", 
                    RowBox[{"VilTeX`Private`g", "<", "0.2`"}], "&&", 
                    RowBox[{"VilTeX`Private`b", "<", "0.2`"}]}], ",", 
                    "\"black\"", ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`r", ">", "0.9`"}], "&&", 
                    RowBox[{"VilTeX`Private`g", ">", "0.9`"}], "&&", 
                    RowBox[{"VilTeX`Private`b", ">", "0.9`"}]}], ",", 
                    "\"white\"", ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`r", ">", "0.8`"}], "&&", 
                    RowBox[{"VilTeX`Private`g", ">", "0.8`"}], "&&", 
                    RowBox[{"VilTeX`Private`b", "<", "0.3`"}]}], ",", 
                    "\"yellow\"", ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`r", ">", "0.8`"}], "&&", 
                    RowBox[{"VilTeX`Private`g", ">", "0.4`"}], "&&", 
                    RowBox[{"VilTeX`Private`b", "<", "0.3`"}]}], ",", 
                    "\"orange\"", ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`r", ">", "0.5`"}], "&&", 
                    RowBox[{"VilTeX`Private`g", "<", "0.3`"}], "&&", 
                    RowBox[{"VilTeX`Private`b", ">", "0.5`"}]}], ",", 
                    "\"purple\"", ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`r", ">", "0.4`"}], "&&", 
                    RowBox[{"VilTeX`Private`r", "<", "0.7`"}], "&&", 
                    RowBox[{"VilTeX`Private`g", "<", "0.3`"}], "&&", 
                    RowBox[{"VilTeX`Private`b", "<", "0.3`"}]}], ",", 
                    "\"brown\"", ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`r", ">", "0.8`"}], "&&", 
                    RowBox[{"VilTeX`Private`g", ">", "0.6`"}], "&&", 
                    RowBox[{"VilTeX`Private`b", ">", "0.6`"}]}], ",", 
                    "\"pink\"", ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`r", "<", "0.3`"}], "&&", 
                    RowBox[{"VilTeX`Private`g", ">", "0.8`"}], "&&", 
                    RowBox[{"VilTeX`Private`b", ">", "0.8`"}]}], ",", 
                    "\"cyan\"", ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`r", ">", "0.8`"}], "&&", 
                    RowBox[{"VilTeX`Private`g", "<", "0.3`"}], "&&", 
                    RowBox[{"VilTeX`Private`b", ">", "0.8`"}]}], ",", 
                    "\"magenta\"", ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`r", ">", "0.4`"}], "&&", 
                    RowBox[{"VilTeX`Private`g", ">", "0.4`"}], "&&", 
                    RowBox[{"VilTeX`Private`b", ">", "0.4`"}]}], ",", 
                    "\"gray\"", ",", "True", ",", "\"black\""}], "]"}]}]}], 
                    "]"}], ",", 
                    RowBox[{
                    RowBox[{"Head", "[", "VilTeX`Private`color", "]"}], "===",
                     "Hue"}], ",", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`rgb", "=", 
                    RowBox[{"ColorConvert", "[", 
                    RowBox[{"VilTeX`Private`color", ",", "\"RGB\""}], "]"}]}],
                     ",", "VilTeX`Private`r", ",", "VilTeX`Private`g", ",", 
                    "VilTeX`Private`b"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`r", ",", "VilTeX`Private`g", ",", 
                    "VilTeX`Private`b"}], "}"}], "=", 
                    RowBox[{"N", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`rgb", "\[LeftDoubleBracket]", "1",
                     "\[RightDoubleBracket]"}], ",", 
                    
                    RowBox[{"VilTeX`Private`rgb", "\[LeftDoubleBracket]", "2",
                     "\[RightDoubleBracket]"}], ",", 
                    
                    RowBox[{"VilTeX`Private`rgb", "\[LeftDoubleBracket]", "3",
                     "\[RightDoubleBracket]"}]}], "}"}], "]"}]}], ";", 
                    RowBox[{"Which", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"VilTeX`Private`r", ">", "0.8`"}], "&&", 
                    RowBox[{"VilTeX`Private`g", "<", "0.3`"}], "&&", 
                    RowBox[{"VilTeX`Private`b", "<", "0.3`"}]}], ",", 
                    "\"red\"", ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`r", "<", "0.3`"}], "&&", 
                    RowBox[{"VilTeX`Private`g", "<", "0.3`"}], "&&", 
                    RowBox[{"VilTeX`Private`b", ">", "0.8`"}]}], ",", 
                    "\"blue\"", ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`r", "<", "0.3`"}], "&&", 
                    RowBox[{"VilTeX`Private`g", ">", "0.8`"}], "&&", 
                    RowBox[{"VilTeX`Private`b", "<", "0.3`"}]}], ",", 
                    "\"green\"", ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`r", ">", "0.8`"}], "&&", 
                    RowBox[{"VilTeX`Private`g", ">", "0.8`"}], "&&", 
                    RowBox[{"VilTeX`Private`b", "<", "0.3`"}]}], ",", 
                    "\"yellow\"", ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`r", ">", "0.8`"}], "&&", 
                    RowBox[{"VilTeX`Private`g", ">", "0.4`"}], "&&", 
                    RowBox[{"VilTeX`Private`b", "<", "0.3`"}]}], ",", 
                    "\"orange\"", ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`r", ">", "0.5`"}], "&&", 
                    RowBox[{"VilTeX`Private`g", "<", "0.3`"}], "&&", 
                    RowBox[{"VilTeX`Private`b", ">", "0.5`"}]}], ",", 
                    "\"purple\"", ",", "True", ",", "\"black\""}], "]"}]}]}], 
                    "]"}], ",", "True", ",", "\"blue\""}], "]"}]}], ";", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`detectBasicColor", "[", 
                    "VilTeX`Private`color_", "]"}], ":=", 
                    RowBox[{"Which", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`color", "===", "Red"}], ",", 
                    "\"red\"", ",", 
                    RowBox[{"VilTeX`Private`color", "===", "Blue"}], ",", 
                    "\"blue\"", ",", 
                    RowBox[{"VilTeX`Private`color", "===", "Green"}], ",", 
                    "\"green\"", ",", 
                    RowBox[{"VilTeX`Private`color", "===", "Black"}], ",", 
                    "\"black\"", ",", 
                    RowBox[{"VilTeX`Private`color", "===", "Orange"}], ",", 
                    "\"orange\"", ",", 
                    RowBox[{"VilTeX`Private`color", "===", "Gray"}], ",", 
                    "\"gray\"", ",", 
                    RowBox[{"VilTeX`Private`color", "===", "White"}], ",", 
                    "\"white\"", ",", 
                    RowBox[{"VilTeX`Private`color", "===", "Yellow"}], ",", 
                    "\"yellow\"", ",", 
                    RowBox[{"VilTeX`Private`color", "===", "Purple"}], ",", 
                    "\"purple\"", ",", 
                    RowBox[{"VilTeX`Private`color", "===", "Brown"}], ",", 
                    "\"brown\"", ",", 
                    RowBox[{"VilTeX`Private`color", "===", "Pink"}], ",", 
                    "\"pink\"", ",", 
                    RowBox[{"VilTeX`Private`color", "===", "Cyan"}], ",", 
                    "\"cyan\"", ",", 
                    RowBox[{"VilTeX`Private`color", "===", "Magenta"}], ",", 
                    "\"magenta\"", ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Head", "[", "VilTeX`Private`color", "]"}], "===",
                     "RGBColor"}], "&&", 
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`color", "]"}], 
                    "\[GreaterEqual]", "3"}]}], ",", 
                    RowBox[{"Which", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"N", "[", "VilTeX`Private`color", "]"}], 
                    "\[Equal]", 
                    RowBox[{"N", "[", 
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"1", ",", "0", ",", "0"}], "]"}], "]"}]}], ",", 
                    "\"red\"", ",", 
                    RowBox[{
                    RowBox[{"N", "[", "VilTeX`Private`color", "]"}], 
                    "\[Equal]", 
                    RowBox[{"N", "[", 
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0", ",", "0", ",", "1"}], "]"}], "]"}]}], ",", 
                    "\"blue\"", ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"N", "[", "VilTeX`Private`color", "]"}], 
                    "\[Equal]", 
                    RowBox[{"N", "[", 
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0", ",", "1", ",", "0"}], "]"}], "]"}]}], "||", 
                    RowBox[{
                    RowBox[{"N", "[", "VilTeX`Private`color", "]"}], 
                    "\[Equal]", 
                    RowBox[{"N", "[", 
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0", ",", "0.5019607843137255`", ",", "0"}], 
                    "]"}], "]"}]}]}], ",", "\"green\"", ",", 
                    RowBox[{
                    RowBox[{"N", "[", "VilTeX`Private`color", "]"}], 
                    "\[Equal]", 
                    RowBox[{"N", "[", 
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0", ",", "0", ",", "0"}], "]"}], "]"}]}], ",", 
                    "\"black\"", ",", 
                    RowBox[{
                    RowBox[{"N", "[", "VilTeX`Private`color", "]"}], 
                    "\[Equal]", 
                    RowBox[{"N", "[", 
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"1", ",", "0.5`", ",", "0"}], "]"}], "]"}]}], ",",
                     "\"orange\"", ",", 
                    RowBox[{
                    RowBox[{"N", "[", "VilTeX`Private`color", "]"}], 
                    "\[Equal]", 
                    RowBox[{"N", "[", 
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.5`", ",", "0.5`", ",", "0.5`"}], "]"}], 
                    "]"}]}], ",", "\"gray\"", ",", 
                    RowBox[{
                    RowBox[{"N", "[", "VilTeX`Private`color", "]"}], 
                    "\[Equal]", 
                    RowBox[{"N", "[", 
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"1", ",", "1", ",", "1"}], "]"}], "]"}]}], ",", 
                    "\"white\"", ",", 
                    RowBox[{
                    RowBox[{"N", "[", "VilTeX`Private`color", "]"}], 
                    "\[Equal]", 
                    RowBox[{"N", "[", 
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"1", ",", "1", ",", "0"}], "]"}], "]"}]}], ",", 
                    "\"yellow\"", ",", 
                    RowBox[{
                    RowBox[{"N", "[", "VilTeX`Private`color", "]"}], 
                    "\[Equal]", 
                    RowBox[{"N", "[", 
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.5`", ",", "0", ",", "0.5`"}], "]"}], "]"}]}], 
                    ",", "\"purple\"", ",", 
                    RowBox[{
                    RowBox[{"N", "[", "VilTeX`Private`color", "]"}], 
                    "\[Equal]", 
                    RowBox[{"N", "[", 
                    RowBox[{"RGBColor", "[", 
                    
                    RowBox[{"0.6470588235294118`", ",", 
                    "0.16470588235294117`", ",", "0.16470588235294117`"}], 
                    "]"}], "]"}]}], ",", "\"brown\"", ",", 
                    RowBox[{
                    RowBox[{"N", "[", "VilTeX`Private`color", "]"}], 
                    "\[Equal]", 
                    RowBox[{"N", "[", 
                    RowBox[{"RGBColor", "[", 
                    
                    RowBox[{"1", ",", "0.7529411764705882`", ",", 
                    "0.796078431372549`"}], "]"}], "]"}]}], ",", "\"pink\"", 
                    ",", 
                    RowBox[{
                    RowBox[{"N", "[", "VilTeX`Private`color", "]"}], 
                    "\[Equal]", 
                    RowBox[{"N", "[", 
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0", ",", "1", ",", "1"}], "]"}], "]"}]}], ",", 
                    "\"cyan\"", ",", 
                    RowBox[{
                    RowBox[{"N", "[", "VilTeX`Private`color", "]"}], 
                    "\[Equal]", 
                    RowBox[{"N", "[", 
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"1", ",", "0", ",", "1"}], "]"}], "]"}]}], ",", 
                    "\"magenta\"", ",", "True", ",", 
                    
                    RowBox[{"VilTeX`Private`colorToTikZ", "[", 
                    "VilTeX`Private`color", "]"}]}], "]"}], ",", 
                    RowBox[{
                    RowBox[{"Head", "[", "VilTeX`Private`color", "]"}], "===",
                     "GrayLevel"}], ",", 
                    RowBox[{"Which", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"N", "[", 
                    
                    RowBox[{"VilTeX`Private`color", "\[LeftDoubleBracket]", 
                    "1", "\[RightDoubleBracket]"}], "]"}], "\[Equal]", "0"}], 
                    ",", "\"black\"", ",", 
                    RowBox[{
                    RowBox[{"N", "[", 
                    
                    RowBox[{"VilTeX`Private`color", "\[LeftDoubleBracket]", 
                    "1", "\[RightDoubleBracket]"}], "]"}], "\[Equal]", 
                    "0.5`"}], ",", "\"gray\"", ",", 
                    RowBox[{
                    RowBox[{"N", "[", 
                    
                    RowBox[{"VilTeX`Private`color", "\[LeftDoubleBracket]", 
                    "1", "\[RightDoubleBracket]"}], "]"}], "\[Equal]", "1"}], 
                    ",", "\"white\"", ",", "True", ",", "\"gray\""}], "]"}], 
                    ",", 
                    RowBox[{
                    RowBox[{"Head", "[", "VilTeX`Private`color", "]"}], "===",
                     "Hue"}], ",", 
                    
                    RowBox[{"VilTeX`Private`colorToTikZ", "[", 
                    "VilTeX`Private`color", "]"}], ",", "True", ",", 
                    "\"black\""}], "]"}]}], ";", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`coneToLines", "[", 
                    
                    RowBox[{"VilTeX`Private`apex_", ",", 
                    "VilTeX`Private`base_", ",", "VilTeX`Private`radius_"}], 
                    "]"}], ":=", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`lines", "=", 
                    RowBox[{"{", "}"}]}], ",", "VilTeX`Private`theta", ",", 
                    RowBox[{"VilTeX`Private`nLines", "=", "12"}], ",", 
                    "VilTeX`Private`baseCenter"}], "}"}], ",", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`baseCenter", "=", 
                    "VilTeX`Private`base"}], ";", 
                    RowBox[{"VilTeX`Private`lines", "=", 
                    RowBox[{"Append", "[", 
                    RowBox[{"VilTeX`Private`lines", ",", 
                    RowBox[{"Line", "[", 
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`baseCenter", "+", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`radius", " ", 
                    RowBox[{"Cos", "[", "VilTeX`Private`theta", "]"}]}], ",", 
                    
                    RowBox[{"VilTeX`Private`radius", " ", 
                    RowBox[{"Sin", "[", "VilTeX`Private`theta", "]"}]}], ",", 
                    "0"}], "}"}]}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`theta", ",", "0", ",", 
                    RowBox[{"2", " ", "\[Pi]"}], ",", 
                    FractionBox[
                    RowBox[{"2", " ", "\[Pi]"}], "20"]}], "}"}]}], "]"}], 
                    "]"}]}], "]"}]}], ";", 
                    RowBox[{"Do", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`lines", "=", 
                    RowBox[{"Append", "[", 
                    RowBox[{"VilTeX`Private`lines", ",", 
                    RowBox[{"Line", "[", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`apex", ",", 
                    RowBox[{"VilTeX`Private`baseCenter", "+", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`radius", " ", 
                    RowBox[{"Cos", "[", "VilTeX`Private`theta", "]"}]}], ",", 
                    
                    RowBox[{"VilTeX`Private`radius", " ", 
                    RowBox[{"Sin", "[", "VilTeX`Private`theta", "]"}]}], ",", 
                    "0"}], "}"}]}]}], "}"}], "]"}]}], "]"}]}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`theta", ",", "0", ",", 
                    RowBox[{
                    RowBox[{"2", " ", "\[Pi]"}], "-", 
                    FractionBox["\[Pi]", "6"]}], ",", 
                    FractionBox[
                    RowBox[{"2", " ", "\[Pi]"}], "VilTeX`Private`nLines"]}], 
                    "}"}]}], "]"}], ";", "VilTeX`Private`lines"}]}], "]"}]}], 
                    ";", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`ellipsoidToLines", "[", 
                    
                    RowBox[{"VilTeX`Private`center_", ",", 
                    "VilTeX`Private`semiAxes_", ",", 
                    "VilTeX`Private`ellipsoidRes_"}], "]"}], ":=", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`lines", "=", 
                    RowBox[{"{", "}"}]}], ",", "VilTeX`Private`phi", ",", 
                    "VilTeX`Private`theta", ",", "VilTeX`Private`a", ",", 
                    "VilTeX`Private`b", ",", "VilTeX`Private`c", ",", 
                    RowBox[{"VilTeX`Private`nMeridians", "=", "8"}], ",", 
                    RowBox[{"VilTeX`Private`nParallels", "=", "6"}]}], "}"}], 
                    ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`a", ",", "VilTeX`Private`b", ",", 
                    "VilTeX`Private`c"}], "}"}], "=", 
                    "VilTeX`Private`semiAxes"}], ";", 
                    RowBox[{"Do", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`lines", "=", 
                    RowBox[{"Append", "[", 
                    RowBox[{"VilTeX`Private`lines", ",", 
                    RowBox[{"Line", "[", 
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`center", "+", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`a", " ", 
                    RowBox[{"Sin", "[", "VilTeX`Private`phi", "]"}], " ", 
                    RowBox[{"Cos", "[", "VilTeX`Private`theta", "]"}]}], ",", 
                    
                    RowBox[{"VilTeX`Private`b", " ", 
                    RowBox[{"Sin", "[", "VilTeX`Private`phi", "]"}], " ", 
                    RowBox[{"Sin", "[", "VilTeX`Private`theta", "]"}]}], ",", 
                    
                    RowBox[{"VilTeX`Private`c", " ", 
                    RowBox[{"Cos", "[", "VilTeX`Private`phi", "]"}]}]}], 
                    "}"}]}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`phi", ",", "0", ",", "\[Pi]", ",", 
                    FractionBox["\[Pi]", "VilTeX`Private`ellipsoidRes"]}], 
                    "}"}]}], "]"}], "]"}]}], "]"}]}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`theta", ",", "0", ",", 
                    RowBox[{
                    RowBox[{"2", " ", "\[Pi]"}], "-", 
                    FractionBox["\[Pi]", "VilTeX`Private`nMeridians"]}], ",", 
                    
                    FractionBox[
                    RowBox[{"2", " ", "\[Pi]"}], 
                    "VilTeX`Private`nMeridians"]}], "}"}]}], "]"}], ";", 
                    RowBox[{"Do", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`lines", "=", 
                    RowBox[{"Append", "[", 
                    RowBox[{"VilTeX`Private`lines", ",", 
                    RowBox[{"Line", "[", 
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`center", "+", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`a", " ", 
                    RowBox[{"Sin", "[", "VilTeX`Private`phi", "]"}], " ", 
                    RowBox[{"Cos", "[", "VilTeX`Private`theta", "]"}]}], ",", 
                    
                    RowBox[{"VilTeX`Private`b", " ", 
                    RowBox[{"Sin", "[", "VilTeX`Private`phi", "]"}], " ", 
                    RowBox[{"Sin", "[", "VilTeX`Private`theta", "]"}]}], ",", 
                    
                    RowBox[{"VilTeX`Private`c", " ", 
                    RowBox[{"Cos", "[", "VilTeX`Private`phi", "]"}]}]}], 
                    "}"}]}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`theta", ",", "0", ",", 
                    RowBox[{"2", " ", "\[Pi]"}], ",", 
                    FractionBox[
                    RowBox[{"2", " ", "\[Pi]"}], 
                    "VilTeX`Private`ellipsoidRes"]}], "}"}]}], "]"}], "]"}]}],
                     "]"}]}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`phi", ",", 
                    FractionBox["\[Pi]", "VilTeX`Private`nParallels"], ",", 
                    RowBox[{"\[Pi]", "-", 
                    FractionBox["\[Pi]", "VilTeX`Private`nParallels"]}], ",", 
                    
                    FractionBox["\[Pi]", "VilTeX`Private`nParallels"]}], 
                    "}"}]}], "]"}], ";", "VilTeX`Private`lines"}]}], "]"}]}], 
                    ";", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`sphereToLines", "[", 
                    
                    RowBox[{"VilTeX`Private`center_", ",", 
                    "VilTeX`Private`radius_", ",", 
                    "VilTeX`Private`sphereRes_"}], "]"}], ":=", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`lines", "=", 
                    RowBox[{"{", "}"}]}], ",", "VilTeX`Private`phi", ",", 
                    "VilTeX`Private`theta", ",", 
                    RowBox[{"VilTeX`Private`nMeridians", "=", "8"}], ",", 
                    RowBox[{"VilTeX`Private`nParallels", "=", "6"}]}], "}"}], 
                    ",", 
                    RowBox[{
                    RowBox[{"Do", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`lines", "=", 
                    RowBox[{"Append", "[", 
                    RowBox[{"VilTeX`Private`lines", ",", 
                    RowBox[{"Line", "[", 
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`center", "+", 
                    RowBox[{"VilTeX`Private`radius", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Sin", "[", "VilTeX`Private`phi", "]"}], " ", 
                    RowBox[{"Cos", "[", "VilTeX`Private`theta", "]"}]}], ",", 
                    
                    RowBox[{
                    RowBox[{"Sin", "[", "VilTeX`Private`phi", "]"}], " ", 
                    RowBox[{"Sin", "[", "VilTeX`Private`theta", "]"}]}], ",", 
                    
                    RowBox[{"Cos", "[", "VilTeX`Private`phi", "]"}]}], 
                    "}"}]}]}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`phi", ",", "0", ",", "\[Pi]", ",", 
                    FractionBox["\[Pi]", "VilTeX`Private`sphereRes"]}], 
                    "}"}]}], "]"}], "]"}]}], "]"}]}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`theta", ",", "0", ",", 
                    RowBox[{
                    RowBox[{"2", " ", "\[Pi]"}], "-", 
                    FractionBox["\[Pi]", "VilTeX`Private`nMeridians"]}], ",", 
                    
                    FractionBox[
                    RowBox[{"2", " ", "\[Pi]"}], 
                    "VilTeX`Private`nMeridians"]}], "}"}]}], "]"}], ";", 
                    RowBox[{"Do", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`lines", "=", 
                    RowBox[{"Append", "[", 
                    RowBox[{"VilTeX`Private`lines", ",", 
                    RowBox[{"Line", "[", 
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`center", "+", 
                    RowBox[{"VilTeX`Private`radius", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Sin", "[", "VilTeX`Private`phi", "]"}], " ", 
                    RowBox[{"Cos", "[", "VilTeX`Private`theta", "]"}]}], ",", 
                    
                    RowBox[{
                    RowBox[{"Sin", "[", "VilTeX`Private`phi", "]"}], " ", 
                    RowBox[{"Sin", "[", "VilTeX`Private`theta", "]"}]}], ",", 
                    
                    RowBox[{"Cos", "[", "VilTeX`Private`phi", "]"}]}], 
                    "}"}]}]}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`theta", ",", "0", ",", 
                    RowBox[{"2", " ", "\[Pi]"}], ",", 
                    FractionBox[
                    RowBox[{"2", " ", "\[Pi]"}], 
                    "VilTeX`Private`sphereRes"]}], "}"}]}], "]"}], "]"}]}], 
                    "]"}]}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`phi", ",", 
                    FractionBox["\[Pi]", "VilTeX`Private`nParallels"], ",", 
                    RowBox[{"\[Pi]", "-", 
                    FractionBox["\[Pi]", "VilTeX`Private`nParallels"]}], ",", 
                    
                    FractionBox["\[Pi]", "VilTeX`Private`nParallels"]}], 
                    "}"}]}], "]"}], ";", "VilTeX`Private`lines"}]}], "]"}]}], 
                    ";", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`cylinderToLines", "[", 
                    
                    RowBox[{"VilTeX`Private`center_", ",", 
                    "VilTeX`Private`radius_", ",", "VilTeX`Private`height_", 
                    ",", 
                    RowBox[{"VilTeX`Private`axis_", ":", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "0", ",", "1"}], "}"}]}]}], "]"}], ":=", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`lines", "=", 
                    RowBox[{"{", "}"}]}], ",", "VilTeX`Private`theta", ",", 
                    RowBox[{"VilTeX`Private`nLines", "=", "12"}]}], "}"}], 
                    ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`lines", "=", 
                    RowBox[{"Append", "[", 
                    RowBox[{"VilTeX`Private`lines", ",", 
                    RowBox[{"Line", "[", 
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`center", "+", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`radius", " ", 
                    RowBox[{"Cos", "[", "VilTeX`Private`theta", "]"}]}], ",", 
                    
                    RowBox[{"VilTeX`Private`radius", " ", 
                    RowBox[{"Sin", "[", "VilTeX`Private`theta", "]"}]}], ",", 
                    "0"}], "}"}]}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`theta", ",", "0", ",", 
                    RowBox[{"2", " ", "\[Pi]"}], ",", 
                    FractionBox[
                    RowBox[{"2", " ", "\[Pi]"}], "20"]}], "}"}]}], "]"}], 
                    "]"}]}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`lines", "=", 
                    RowBox[{"Append", "[", 
                    RowBox[{"VilTeX`Private`lines", ",", 
                    RowBox[{"Line", "[", 
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`center", "+", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`radius", " ", 
                    RowBox[{"Cos", "[", "VilTeX`Private`theta", "]"}]}], ",", 
                    
                    RowBox[{"VilTeX`Private`radius", " ", 
                    RowBox[{"Sin", "[", "VilTeX`Private`theta", "]"}]}], ",", 
                    "VilTeX`Private`height"}], "}"}]}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`theta", ",", "0", ",", 
                    RowBox[{"2", " ", "\[Pi]"}], ",", 
                    FractionBox[
                    RowBox[{"2", " ", "\[Pi]"}], "20"]}], "}"}]}], "]"}], 
                    "]"}]}], "]"}]}], ";", 
                    RowBox[{"Do", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`lines", "=", 
                    RowBox[{"Append", "[", 
                    RowBox[{"VilTeX`Private`lines", ",", 
                    RowBox[{"Line", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`center", "+", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`radius", " ", 
                    RowBox[{"Cos", "[", "VilTeX`Private`theta", "]"}]}], ",", 
                    
                    RowBox[{"VilTeX`Private`radius", " ", 
                    RowBox[{"Sin", "[", "VilTeX`Private`theta", "]"}]}], ",", 
                    "0"}], "}"}]}], ",", 
                    RowBox[{"VilTeX`Private`center", "+", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`radius", " ", 
                    RowBox[{"Cos", "[", "VilTeX`Private`theta", "]"}]}], ",", 
                    
                    RowBox[{"VilTeX`Private`radius", " ", 
                    RowBox[{"Sin", "[", "VilTeX`Private`theta", "]"}]}], ",", 
                    "VilTeX`Private`height"}], "}"}]}]}], "}"}], "]"}]}], 
                    "]"}]}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`theta", ",", "0", ",", 
                    RowBox[{
                    RowBox[{"2", " ", "\[Pi]"}], "-", 
                    FractionBox["\[Pi]", "6"]}], ",", 
                    FractionBox[
                    RowBox[{"2", " ", "\[Pi]"}], "VilTeX`Private`nLines"]}], 
                    "}"}]}], "]"}], ";", "VilTeX`Private`lines"}]}], "]"}]}], 
                    ";", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`cuboidToLines", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`xmin_", ",", 
                    "VilTeX`Private`ymin_", ",", "VilTeX`Private`zmin_"}], 
                    "}"}], ",", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`xmax_", ",", 
                    "VilTeX`Private`ymax_", ",", "VilTeX`Private`zmax_"}], 
                    "}"}]}], "]"}], ":=", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`lines", "=", 
                    RowBox[{"{", "}"}]}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`lines", "=", 
                    RowBox[{"Append", "[", 
                    RowBox[{"VilTeX`Private`lines", ",", 
                    RowBox[{"Line", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`xmin", ",", "VilTeX`Private`ymin",
                     ",", "VilTeX`Private`zmin"}], "}"}], ",", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`xmax", ",", "VilTeX`Private`ymin",
                     ",", "VilTeX`Private`zmin"}], "}"}]}], "}"}], "]"}]}], 
                    "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`lines", "=", 
                    RowBox[{"Append", "[", 
                    RowBox[{"VilTeX`Private`lines", ",", 
                    RowBox[{"Line", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`xmax", ",", "VilTeX`Private`ymin",
                     ",", "VilTeX`Private`zmin"}], "}"}], ",", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`xmax", ",", "VilTeX`Private`ymax",
                     ",", "VilTeX`Private`zmin"}], "}"}]}], "}"}], "]"}]}], 
                    "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`lines", "=", 
                    RowBox[{"Append", "[", 
                    RowBox[{"VilTeX`Private`lines", ",", 
                    RowBox[{"Line", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`xmax", ",", "VilTeX`Private`ymax",
                     ",", "VilTeX`Private`zmin"}], "}"}], ",", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`xmin", ",", "VilTeX`Private`ymax",
                     ",", "VilTeX`Private`zmin"}], "}"}]}], "}"}], "]"}]}], 
                    "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`lines", "=", 
                    RowBox[{"Append", "[", 
                    RowBox[{"VilTeX`Private`lines", ",", 
                    RowBox[{"Line", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`xmin", ",", "VilTeX`Private`ymax",
                     ",", "VilTeX`Private`zmin"}], "}"}], ",", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`xmin", ",", "VilTeX`Private`ymin",
                     ",", "VilTeX`Private`zmin"}], "}"}]}], "}"}], "]"}]}], 
                    "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`lines", "=", 
                    RowBox[{"Append", "[", 
                    RowBox[{"VilTeX`Private`lines", ",", 
                    RowBox[{"Line", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`xmin", ",", "VilTeX`Private`ymin",
                     ",", "VilTeX`Private`zmax"}], "}"}], ",", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`xmax", ",", "VilTeX`Private`ymin",
                     ",", "VilTeX`Private`zmax"}], "}"}]}], "}"}], "]"}]}], 
                    "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`lines", "=", 
                    RowBox[{"Append", "[", 
                    RowBox[{"VilTeX`Private`lines", ",", 
                    RowBox[{"Line", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`xmax", ",", "VilTeX`Private`ymin",
                     ",", "VilTeX`Private`zmax"}], "}"}], ",", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`xmax", ",", "VilTeX`Private`ymax",
                     ",", "VilTeX`Private`zmax"}], "}"}]}], "}"}], "]"}]}], 
                    "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`lines", "=", 
                    RowBox[{"Append", "[", 
                    RowBox[{"VilTeX`Private`lines", ",", 
                    RowBox[{"Line", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`xmax", ",", "VilTeX`Private`ymax",
                     ",", "VilTeX`Private`zmax"}], "}"}], ",", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`xmin", ",", "VilTeX`Private`ymax",
                     ",", "VilTeX`Private`zmax"}], "}"}]}], "}"}], "]"}]}], 
                    "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`lines", "=", 
                    RowBox[{"Append", "[", 
                    RowBox[{"VilTeX`Private`lines", ",", 
                    RowBox[{"Line", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`xmin", ",", "VilTeX`Private`ymax",
                     ",", "VilTeX`Private`zmax"}], "}"}], ",", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`xmin", ",", "VilTeX`Private`ymin",
                     ",", "VilTeX`Private`zmax"}], "}"}]}], "}"}], "]"}]}], 
                    "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`lines", "=", 
                    RowBox[{"Append", "[", 
                    RowBox[{"VilTeX`Private`lines", ",", 
                    RowBox[{"Line", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`xmin", ",", "VilTeX`Private`ymin",
                     ",", "VilTeX`Private`zmin"}], "}"}], ",", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`xmin", ",", "VilTeX`Private`ymin",
                     ",", "VilTeX`Private`zmax"}], "}"}]}], "}"}], "]"}]}], 
                    "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`lines", "=", 
                    RowBox[{"Append", "[", 
                    RowBox[{"VilTeX`Private`lines", ",", 
                    RowBox[{"Line", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`xmax", ",", "VilTeX`Private`ymin",
                     ",", "VilTeX`Private`zmin"}], "}"}], ",", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`xmax", ",", "VilTeX`Private`ymin",
                     ",", "VilTeX`Private`zmax"}], "}"}]}], "}"}], "]"}]}], 
                    "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`lines", "=", 
                    RowBox[{"Append", "[", 
                    RowBox[{"VilTeX`Private`lines", ",", 
                    RowBox[{"Line", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`xmax", ",", "VilTeX`Private`ymax",
                     ",", "VilTeX`Private`zmin"}], "}"}], ",", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`xmax", ",", "VilTeX`Private`ymax",
                     ",", "VilTeX`Private`zmax"}], "}"}]}], "}"}], "]"}]}], 
                    "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`lines", "=", 
                    RowBox[{"Append", "[", 
                    RowBox[{"VilTeX`Private`lines", ",", 
                    RowBox[{"Line", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`xmin", ",", "VilTeX`Private`ymax",
                     ",", "VilTeX`Private`zmin"}], "}"}], ",", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`xmin", ",", "VilTeX`Private`ymax",
                     ",", "VilTeX`Private`zmax"}], "}"}]}], "}"}], "]"}]}], 
                    "]"}]}], ";", "VilTeX`Private`lines"}]}], "]"}]}], ";", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`polygonToLines", "[", 
                    "VilTeX`Private`vertices_", "]"}], ":=", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`lines", "=", 
                    RowBox[{"{", "}"}]}], ",", 
                    "VilTeX`Private`simplifiedVertices", ",", 
                    "VilTeX`Private`closedVertices"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`vertices", "]"}], 
                    "\[GreaterEqual]", "3"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`simplifiedVertices", "=", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`vertices", "]"}], 
                    ">", "12"}], ",", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`step", "=", 
                    RowBox[{"Ceiling", "[", 
                    FractionBox[
                    RowBox[{"Length", "[", "VilTeX`Private`vertices", "]"}], 
                    "8"], "]"}]}], ",", "VilTeX`Private`selected"}], "}"}], 
                    ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`selected", "=", 
                    RowBox[{"VilTeX`Private`vertices", "\[LeftDoubleBracket]", 
                    RowBox[{"1", ";;", 
                    RowBox[{"Length", "[", "VilTeX`Private`vertices", "]"}], 
                    ";;", "VilTeX`Private`step"}], 
                    "\[RightDoubleBracket]"}]}], ";", 
                    "VilTeX`Private`selected"}]}], "]"}], ",", 
                    "VilTeX`Private`vertices"}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`closedVertices", "=", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"Length", "[", 
                    "VilTeX`Private`simplifiedVertices", "]"}], 
                    "\[GreaterEqual]", "3"}], "&&", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`simplifiedVertices", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"-", "1"}], "\[RightDoubleBracket]"}], 
                    "\[NotEqual]", 
                    
                    RowBox[{"VilTeX`Private`simplifiedVertices", 
                    "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}]}]}], ",", 
                    RowBox[{"Append", "[", 
                    RowBox[{"VilTeX`Private`simplifiedVertices", ",", 
                    
                    RowBox[{"VilTeX`Private`simplifiedVertices", 
                    "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}], 
                    "]"}], ",", "VilTeX`Private`simplifiedVertices"}], 
                    "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`lines", "=", 
                    RowBox[{"{", 
                    
                    RowBox[{"Line", "[", "VilTeX`Private`closedVertices", 
                    "]"}], "}"}]}], ";"}]}], "]"}], ";", 
                    "VilTeX`Private`lines"}]}], "]"}]}], ";", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`flattenElements", "[", 
                    "VilTeX`Private`elementList_", "]"}], ":=", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`flattened", "=", 
                    RowBox[{"{", "}"}]}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"Do", "[", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`element", "=", 
                    
                    RowBox[{"VilTeX`Private`elementList", 
                    "\[LeftDoubleBracket]", "VilTeX`Private`i", 
                    "\[RightDoubleBracket]"}]}], "}"}], ",", 
                    RowBox[{"Which", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Head", "[", "VilTeX`Private`element", "]"}], 
                    "===", "Style"}], ",", 
                    RowBox[{"VilTeX`Private`flattened", "=", 
                    RowBox[{"Append", "[", 
                    
                    RowBox[{"VilTeX`Private`flattened", ",", 
                    "VilTeX`Private`element"}], "]"}]}], ",", 
                    RowBox[{"ListQ", "[", "VilTeX`Private`element", "]"}], 
                    ",", 
                    RowBox[{"VilTeX`Private`flattened", "=", 
                    RowBox[{"Join", "[", 
                    RowBox[{"VilTeX`Private`flattened", ",", 
                    
                    RowBox[{"VilTeX`Private`flattenElements", "[", 
                    "VilTeX`Private`element", "]"}]}], "]"}]}], ",", "True", 
                    ",", 
                    RowBox[{"VilTeX`Private`flattened", "=", 
                    RowBox[{"Append", "[", 
                    
                    RowBox[{"VilTeX`Private`flattened", ",", 
                    "VilTeX`Private`element"}], "]"}]}]}], "]"}]}], "]"}], 
                    ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`i", ",", 
                    
                    RowBox[{"Length", "[", "VilTeX`Private`elementList", 
                    "]"}]}], "}"}]}], "]"}], ";", 
                    "VilTeX`Private`flattened"}]}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`allPrimitives", "=", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"Head", "[", "VilTeX`Private`graphics3DArgs", 
                    "]"}], "===", "Graphics3D"}], ",", 
                    
                    RowBox[{"VilTeX`Private`graphics3DArgs", 
                    "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
                    ",", 
                    RowBox[{"{", "VilTeX`Private`graphics3DArgs", "}"}]}], 
                    "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`flatElements", "=", 
                    
                    RowBox[{"VilTeX`Private`flattenElements", "[", 
                    "VilTeX`Private`allPrimitives", "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`allValidData", "=", 
                    RowBox[{"{", "}"}]}], ";", 
                    RowBox[{"VilTeX`Private`combinedTikzCode", "=", "\"\""}], 
                    ";", 
                    RowBox[{"VilTeX`Private`textTikzCode", "=", "\"\""}], ";", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`addValidCoords", "[", 
                    "VilTeX`Private`coords_", "]"}], ":=", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ListQ", "[", "VilTeX`Private`coords", "]"}], 
                    "&&", 
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`coords", "]"}], 
                    ">", "0"}]}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`coords", "]"}], 
                    ">", "0"}], "&&", 
                    RowBox[{"ListQ", "[", 
                    
                    RowBox[{"VilTeX`Private`coords", "\[LeftDoubleBracket]", 
                    "1", "\[RightDoubleBracket]"}], "]"}], "&&", 
                    RowBox[{
                    RowBox[{"Length", "[", 
                    
                    RowBox[{"VilTeX`Private`coords", "\[LeftDoubleBracket]", 
                    "1", "\[RightDoubleBracket]"}], "]"}], "\[Equal]", 
                    "3"}]}], ",", 
                    RowBox[{"Do", "[", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ListQ", "[", 
                    
                    RowBox[{"VilTeX`Private`coords", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`i", "\[RightDoubleBracket]"}], "]"}], 
                    "&&", 
                    RowBox[{
                    RowBox[{"Length", "[", 
                    
                    RowBox[{"VilTeX`Private`coords", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`i", "\[RightDoubleBracket]"}], "]"}], 
                    "\[Equal]", "3"}], "&&", 
                    RowBox[{"AllTrue", "[", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`coords", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`i", "\[RightDoubleBracket]"}], ",", 
                    "NumericQ"}], "]"}]}], ",", 
                    RowBox[{"VilTeX`Private`allValidData", "=", 
                    RowBox[{"Append", "[", 
                    RowBox[{"VilTeX`Private`allValidData", ",", 
                    
                    RowBox[{"VilTeX`Private`coords", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`i", "\[RightDoubleBracket]"}]}], 
                    "]"}]}]}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`i", ",", 
                    RowBox[{"Length", "[", "VilTeX`Private`coords", "]"}]}], 
                    "}"}]}], "]"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`coords", "]"}], 
                    "\[Equal]", "3"}], "&&", 
                    RowBox[{"AllTrue", "[", 
                    RowBox[{"VilTeX`Private`coords", ",", "NumericQ"}], 
                    "]"}]}], ",", 
                    RowBox[{"VilTeX`Private`allValidData", "=", 
                    RowBox[{"Append", "[", 
                    
                    RowBox[{"VilTeX`Private`allValidData", ",", 
                    "VilTeX`Private`coords"}], "]"}]}]}], "]"}]}], "]"}]}], 
                    "]"}]}], ";", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`currentColor", "=", "\"blue\""}], 
                    ",", 
                    
                    RowBox[{"VilTeX`Private`currentPointSize", "=", 
                    "\"1.0\""}], ",", 
                    
                    RowBox[{"VilTeX`Private`currentThickness", "=", 
                    "\"1.0\""}], ",", 
                    RowBox[{"VilTeX`Private`currentDashing", "=", "False"}]}],
                     "}"}], ",", 
                    RowBox[{
                    RowBox[{"Do", "[", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`element", "=", 
                    
                    RowBox[{"VilTeX`Private`flatElements", 
                    "\[LeftDoubleBracket]", "VilTeX`Private`i", 
                    "\[RightDoubleBracket]"}]}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"Which", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"Head", "[", "VilTeX`Private`element", "]"}], 
                    "===", "RGBColor"}], "||", 
                    RowBox[{
                    RowBox[{"Head", "[", "VilTeX`Private`element", "]"}], 
                    "===", "GrayLevel"}], "||", 
                    RowBox[{
                    RowBox[{"Head", "[", "VilTeX`Private`element", "]"}], 
                    "===", "Hue"}], "||", 
                    RowBox[{"MemberQ", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"Red", ",", "Blue", ",", "Green", ",", "Black", 
                    ",", "Orange", ",", "Gray", ",", "White", ",", "Yellow", 
                    ",", "Purple", ",", "Brown", ",", "Pink", ",", "Cyan", 
                    ",", "Magenta"}], "}"}], ",", "VilTeX`Private`element"}], 
                    "]"}]}], ",", 
                    RowBox[{"VilTeX`Private`currentColor", "=", 
                    
                    RowBox[{"VilTeX`Private`detectBasicColor", "[", 
                    "VilTeX`Private`element", "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"Head", "[", "VilTeX`Private`element", "]"}], 
                    "===", "PointSize"}], ",", 
                    RowBox[{"VilTeX`Private`currentPointSize", "=", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"VilTeX`Private`pointSizeToNumber", "[", 
                    RowBox[{"VilTeX`Private`element", "\[LeftDoubleBracket]", 
                    "1", "\[RightDoubleBracket]"}], "]"}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"Head", "[", "VilTeX`Private`element", "]"}], 
                    "===", "Thickness"}], ",", 
                    RowBox[{"VilTeX`Private`currentThickness", "=", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"VilTeX`Private`thicknessToNumber", "[", 
                    
                    RowBox[{"VilTeX`Private`element", "\[LeftDoubleBracket]", 
                    "1", "\[RightDoubleBracket]"}], "]"}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`element", "===", "Dashed"}], "||", 
                    RowBox[{
                    RowBox[{"Head", "[", "VilTeX`Private`element", "]"}], 
                    "===", "Dashing"}]}], ",", 
                    RowBox[{"VilTeX`Private`currentDashing", "=", "True"}], 
                    ",", 
                    RowBox[{
                    RowBox[{"Head", "[", "VilTeX`Private`element", "]"}], 
                    "===", "Line"}], ",", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`linePoints", "=", 
                    
                    RowBox[{"VilTeX`Private`element", "\[LeftDoubleBracket]", 
                    "1", "\[RightDoubleBracket]"}]}], ",", 
                    "VilTeX`Private`styleString"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`styleString", "=", 
                    
                    RowBox[{"VilTeX`Private`currentColor", "<>", 
                    "\", no marks, mark=none, line width=\"", "<>", 
                    "VilTeX`Private`currentThickness", "<>", "\"pt\""}]}], 
                    ";", 
                    RowBox[{"If", "[", 
                    RowBox[{"VilTeX`Private`currentDashing", ",", 
                    RowBox[{"VilTeX`Private`styleString", "=", 
                    
                    RowBox[{"VilTeX`Private`styleString", "<>", 
                    "\", densely dashed\""}]}]}], "]"}], ";", 
                    RowBox[{"VilTeX`Private`combinedTikzCode", "=", 
                    
                    RowBox[{"VilTeX`Private`combinedTikzCode", "<>", 
                    "\"\\\\addplot3[\"", "<>", "VilTeX`Private`styleString", 
                    "<>", "\"] coordinates {\\n\"", "<>", 
                    RowBox[{"StringRiffle", "[", 
                    RowBox[{
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"\"  (\"", "<>", 
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    
                    RowBox[{"VilTeX`Private`linePoints", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`k", ",", "1"}], 
                    "\[RightDoubleBracket]"}], "]"}], "<>", "\",\"", "<>", 
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    
                    RowBox[{"VilTeX`Private`linePoints", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`k", ",", "2"}], 
                    "\[RightDoubleBracket]"}], "]"}], "<>", "\",\"", "<>", 
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    
                    RowBox[{"VilTeX`Private`linePoints", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`k", ",", "3"}], 
                    "\[RightDoubleBracket]"}], "]"}], "<>", "\")\""}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`k", ",", 
                    
                    RowBox[{"Length", "[", "VilTeX`Private`linePoints", 
                    "]"}]}], "}"}]}], "]"}], ",", "\"\\n\""}], "]"}], "<>", 
                    "\"\\n};\\n\""}]}], ";", 
                    
                    RowBox[{"VilTeX`Private`addValidCoords", "[", 
                    "VilTeX`Private`linePoints", "]"}], ";"}]}], "]"}], ",", 
                    RowBox[{
                    RowBox[{"Head", "[", "VilTeX`Private`element", "]"}], 
                    "===", "Point"}], ",", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`pointData", "=", 
                    RowBox[{"VilTeX`Private`element", "\[LeftDoubleBracket]", 
                    "1", "\[RightDoubleBracket]"}]}], ",", 
                    "VilTeX`Private`styleString"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`styleString", "=", 
                    
                    RowBox[{"VilTeX`Private`currentColor", "<>", 
                    "\", only marks, mark=*, mark size=\"", "<>", 
                    "VilTeX`Private`currentPointSize", "<>", "\"pt\""}]}], 
                    ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"NumericQ", "[", 
                    
                    RowBox[{"VilTeX`Private`pointData", 
                    "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
                    "]"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`combinedTikzCode", "=", 
                    
                    RowBox[{"VilTeX`Private`combinedTikzCode", "<>", 
                    "\"\\\\addplot3[\"", "<>", "VilTeX`Private`styleString", 
                    "<>", "\"] coordinates {\\n\"", "<>", "\"  (\"", "<>", 
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    
                    RowBox[{"VilTeX`Private`pointData", 
                    "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
                    "]"}], "<>", "\",\"", "<>", 
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    
                    RowBox[{"VilTeX`Private`pointData", 
                    "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], 
                    "]"}], "<>", "\",\"", "<>", 
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    
                    RowBox[{"VilTeX`Private`pointData", 
                    "\[LeftDoubleBracket]", "3", "\[RightDoubleBracket]"}], 
                    "]"}], "<>", "\")\\n};\\n\""}]}], ";", 
                    
                    RowBox[{"VilTeX`Private`addValidCoords", "[", 
                    "VilTeX`Private`pointData", "]"}], ";"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`combinedTikzCode", "=", 
                    
                    RowBox[{"VilTeX`Private`combinedTikzCode", "<>", 
                    "\"\\\\addplot3[\"", "<>", "VilTeX`Private`styleString", 
                    "<>", "\"] coordinates {\\n\"", "<>", 
                    RowBox[{"StringRiffle", "[", 
                    RowBox[{
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"\"  (\"", "<>", 
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    
                    RowBox[{"VilTeX`Private`pointData", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`k", ",", "1"}], 
                    "\[RightDoubleBracket]"}], "]"}], "<>", "\",\"", "<>", 
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    
                    RowBox[{"VilTeX`Private`pointData", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`k", ",", "2"}], 
                    "\[RightDoubleBracket]"}], "]"}], "<>", "\",\"", "<>", 
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    
                    RowBox[{"VilTeX`Private`pointData", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`k", ",", "3"}], 
                    "\[RightDoubleBracket]"}], "]"}], "<>", "\")\""}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`k", ",", 
                    
                    RowBox[{"Length", "[", "VilTeX`Private`pointData", 
                    "]"}]}], "}"}]}], "]"}], ",", "\"\\n\""}], "]"}], "<>", 
                    "\"\\n};\\n\""}]}], ";", 
                    
                    RowBox[{"VilTeX`Private`addValidCoords", "[", 
                    "VilTeX`Private`pointData", "]"}], ";"}]}], "]"}], 
                    ";"}]}], "]"}], ",", 
                    RowBox[{
                    RowBox[{"Head", "[", "VilTeX`Private`element", "]"}], 
                    "===", "Arrow"}], ",", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`arrowPoints", "=", 
                    
                    RowBox[{"VilTeX`Private`element", "\[LeftDoubleBracket]", 
                    "1", "\[RightDoubleBracket]"}]}], ",", 
                    "VilTeX`Private`styleString"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`styleString", "=", 
                    RowBox[{"VilTeX`Private`currentColor", "<>", 
                    "\", -{Stealth}, line width=\"", "<>", 
                    "VilTeX`Private`currentThickness", "<>", 
                    "\"pt, no marks, mark=none\""}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{"VilTeX`Private`currentDashing", ",", 
                    RowBox[{"VilTeX`Private`styleString", "=", 
                    
                    RowBox[{"VilTeX`Private`styleString", "<>", 
                    "\", densely dashed\""}]}]}], "]"}], ";", 
                    RowBox[{"VilTeX`Private`combinedTikzCode", "=", 
                    
                    RowBox[{"VilTeX`Private`combinedTikzCode", "<>", 
                    "\"\\\\addplot3[\"", "<>", "VilTeX`Private`styleString", 
                    "<>", "\"] coordinates {\\n\"", "<>", 
                    RowBox[{"StringRiffle", "[", 
                    RowBox[{
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"\"  (\"", "<>", 
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    
                    RowBox[{"VilTeX`Private`arrowPoints", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`k", ",", "1"}], 
                    "\[RightDoubleBracket]"}], "]"}], "<>", "\",\"", "<>", 
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    
                    RowBox[{"VilTeX`Private`arrowPoints", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`k", ",", "2"}], 
                    "\[RightDoubleBracket]"}], "]"}], "<>", "\",\"", "<>", 
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    
                    RowBox[{"VilTeX`Private`arrowPoints", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`k", ",", "3"}], 
                    "\[RightDoubleBracket]"}], "]"}], "<>", "\")\""}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`k", ",", 
                    
                    RowBox[{"Length", "[", "VilTeX`Private`arrowPoints", 
                    "]"}]}], "}"}]}], "]"}], ",", "\"\\n\""}], "]"}], "<>", 
                    "\"\\n};\\n\""}]}], ";", 
                    
                    RowBox[{"VilTeX`Private`addValidCoords", "[", 
                    "VilTeX`Private`arrowPoints", "]"}], ";"}]}], "]"}], ",", 
                    
                    RowBox[{
                    RowBox[{
                    RowBox[{"Head", "[", "VilTeX`Private`element", "]"}], 
                    "===", "Sphere"}], "&&", 
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`element", "]"}], 
                    "\[GreaterEqual]", "1"}]}], ",", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`center", ",", 
                    "VilTeX`Private`radius", ",", 
                    "VilTeX`Private`sphereLines"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`center", "=", 
                    
                    RowBox[{"VilTeX`Private`element", "\[LeftDoubleBracket]", 
                    "1", "\[RightDoubleBracket]"}]}], ";", 
                    RowBox[{"VilTeX`Private`radius", "=", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`element", "]"}], 
                    "\[GreaterEqual]", "2"}], ",", 
                    
                    RowBox[{"VilTeX`Private`element", "\[LeftDoubleBracket]", 
                    "2", "\[RightDoubleBracket]"}], ",", "1"}], "]"}]}], ";", 
                    
                    RowBox[{"VilTeX`Private`sphereLines", "=", 
                    RowBox[{"VilTeX`Private`sphereToLines", "[", 
                    
                    RowBox[{"VilTeX`Private`center", ",", 
                    "VilTeX`Private`radius", ",", "15"}], "]"}]}], ";", 
                    RowBox[{"Do", "[", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`linePoints", "=", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`sphereLines", 
                    "\[LeftDoubleBracket]", "VilTeX`Private`j", 
                    "\[RightDoubleBracket]"}], "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}]}], ",", 
                    "VilTeX`Private`styleString"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`styleString", "=", 
                    
                    RowBox[{"VilTeX`Private`currentColor", "<>", 
                    "\", no marks, mark=none, line width=\"", "<>", 
                    "VilTeX`Private`currentThickness", "<>", "\"pt\""}]}], 
                    ";", 
                    RowBox[{"If", "[", 
                    RowBox[{"VilTeX`Private`currentDashing", ",", 
                    RowBox[{"VilTeX`Private`styleString", "=", 
                    
                    RowBox[{"VilTeX`Private`styleString", "<>", 
                    "\", densely dashed\""}]}]}], "]"}], ";", 
                    RowBox[{"VilTeX`Private`combinedTikzCode", "=", 
                    
                    RowBox[{"VilTeX`Private`combinedTikzCode", "<>", 
                    "\"\\\\addplot3[\"", "<>", "VilTeX`Private`styleString", 
                    "<>", "\"] coordinates {\\n\"", "<>", 
                    RowBox[{"StringRiffle", "[", 
                    RowBox[{
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"\"  (\"", "<>", 
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    
                    RowBox[{"VilTeX`Private`linePoints", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`k", ",", "1"}], 
                    "\[RightDoubleBracket]"}], "]"}], "<>", "\",\"", "<>", 
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    
                    RowBox[{"VilTeX`Private`linePoints", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`k", ",", "2"}], 
                    "\[RightDoubleBracket]"}], "]"}], "<>", "\",\"", "<>", 
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    
                    RowBox[{"VilTeX`Private`linePoints", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`k", ",", "3"}], 
                    "\[RightDoubleBracket]"}], "]"}], "<>", "\")\""}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`k", ",", 
                    
                    RowBox[{"Length", "[", "VilTeX`Private`linePoints", 
                    "]"}]}], "}"}]}], "]"}], ",", "\"\\n\""}], "]"}], "<>", 
                    "\"\\n};\\n\""}]}], ";", 
                    
                    RowBox[{"VilTeX`Private`addValidCoords", "[", 
                    "VilTeX`Private`linePoints", "]"}], ";"}]}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`j", ",", 
                    
                    RowBox[{"Length", "[", "VilTeX`Private`sphereLines", 
                    "]"}]}], "}"}]}], "]"}], ";"}]}], "]"}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Head", "[", "VilTeX`Private`element", "]"}], 
                    "===", "Ellipsoid"}], "&&", 
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`element", "]"}], 
                    "\[GreaterEqual]", "2"}]}], ",", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`center", ",", 
                    "VilTeX`Private`semiAxes", ",", 
                    "VilTeX`Private`ellipsoidLines"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`center", "=", 
                    
                    RowBox[{"VilTeX`Private`element", "\[LeftDoubleBracket]", 
                    "1", "\[RightDoubleBracket]"}]}], ";", 
                    RowBox[{"VilTeX`Private`semiAxes", "=", 
                    
                    RowBox[{"VilTeX`Private`element", "\[LeftDoubleBracket]", 
                    "2", "\[RightDoubleBracket]"}]}], ";", 
                    RowBox[{"VilTeX`Private`ellipsoidLines", "=", 
                    RowBox[{"VilTeX`Private`ellipsoidToLines", "[", 
                    
                    RowBox[{"VilTeX`Private`center", ",", 
                    "VilTeX`Private`semiAxes", ",", "15"}], "]"}]}], ";", 
                    RowBox[{"Do", "[", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`linePoints", "=", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`ellipsoidLines", 
                    "\[LeftDoubleBracket]", "VilTeX`Private`j", 
                    "\[RightDoubleBracket]"}], "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}]}], ",", 
                    "VilTeX`Private`styleString"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`styleString", "=", 
                    
                    RowBox[{"VilTeX`Private`currentColor", "<>", 
                    "\", no marks, mark=none, line width=\"", "<>", 
                    "VilTeX`Private`currentThickness", "<>", "\"pt\""}]}], 
                    ";", 
                    RowBox[{"If", "[", 
                    RowBox[{"VilTeX`Private`currentDashing", ",", 
                    RowBox[{"VilTeX`Private`styleString", "=", 
                    
                    RowBox[{"VilTeX`Private`styleString", "<>", 
                    "\", densely dashed\""}]}]}], "]"}], ";", 
                    RowBox[{"VilTeX`Private`combinedTikzCode", "=", 
                    
                    RowBox[{"VilTeX`Private`combinedTikzCode", "<>", 
                    "\"\\\\addplot3[\"", "<>", "VilTeX`Private`styleString", 
                    "<>", "\"] coordinates {\\n\"", "<>", 
                    RowBox[{"StringRiffle", "[", 
                    RowBox[{
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"\"  (\"", "<>", 
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    
                    RowBox[{"VilTeX`Private`linePoints", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`k", ",", "1"}], 
                    "\[RightDoubleBracket]"}], "]"}], "<>", "\",\"", "<>", 
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    
                    RowBox[{"VilTeX`Private`linePoints", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`k", ",", "2"}], 
                    "\[RightDoubleBracket]"}], "]"}], "<>", "\",\"", "<>", 
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    
                    RowBox[{"VilTeX`Private`linePoints", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`k", ",", "3"}], 
                    "\[RightDoubleBracket]"}], "]"}], "<>", "\")\""}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`k", ",", 
                    
                    RowBox[{"Length", "[", "VilTeX`Private`linePoints", 
                    "]"}]}], "}"}]}], "]"}], ",", "\"\\n\""}], "]"}], "<>", 
                    "\"\\n};\\n\""}]}], ";", 
                    
                    RowBox[{"VilTeX`Private`addValidCoords", "[", 
                    "VilTeX`Private`linePoints", "]"}], ";"}]}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`j", ",", 
                    
                    RowBox[{"Length", "[", "VilTeX`Private`ellipsoidLines", 
                    "]"}]}], "}"}]}], "]"}], ";"}]}], "]"}], ",", 
                    RowBox[{
                    RowBox[{"Head", "[", "VilTeX`Private`element", "]"}], 
                    "===", "Cylinder"}], ",", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`center", ",", 
                    "VilTeX`Private`radius", ",", "VilTeX`Private`height", 
                    ",", "VilTeX`Private`cylinderLines"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`center", "=", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`element", "]"}], 
                    "\[GreaterEqual]", "1"}], "&&", 
                    RowBox[{"ListQ", "[", 
                    
                    RowBox[{"VilTeX`Private`element", "\[LeftDoubleBracket]", 
                    "1", "\[RightDoubleBracket]"}], "]"}], "&&", 
                    RowBox[{
                    RowBox[{"Length", "[", 
                    
                    RowBox[{"VilTeX`Private`element", "\[LeftDoubleBracket]", 
                    "1", "\[RightDoubleBracket]"}], "]"}], "\[GreaterEqual]", 
                    "2"}]}], ",", 
                    RowBox[{
                    FractionBox["1", "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`element", "\[LeftDoubleBracket]", 
                    "1", "\[RightDoubleBracket]"}], "\[LeftDoubleBracket]", 
                    "1", "\[RightDoubleBracket]"}], "+", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`element", "\[LeftDoubleBracket]", 
                    "1", "\[RightDoubleBracket]"}], "\[LeftDoubleBracket]", 
                    "2", "\[RightDoubleBracket]"}]}], ")"}]}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "]"}]}], ";", 
                    
                    RowBox[{"VilTeX`Private`radius", "=", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`element", "]"}], 
                    "\[GreaterEqual]", "2"}], ",", 
                    
                    RowBox[{"VilTeX`Private`element", "\[LeftDoubleBracket]", 
                    "2", "\[RightDoubleBracket]"}], ",", "1"}], "]"}]}], ";", 
                    
                    RowBox[{"VilTeX`Private`height", "=", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`element", "]"}], 
                    "\[GreaterEqual]", "1"}], "&&", 
                    RowBox[{"ListQ", "[", 
                    
                    RowBox[{"VilTeX`Private`element", "\[LeftDoubleBracket]", 
                    "1", "\[RightDoubleBracket]"}], "]"}], "&&", 
                    RowBox[{
                    RowBox[{"Length", "[", 
                    
                    RowBox[{"VilTeX`Private`element", "\[LeftDoubleBracket]", 
                    "1", "\[RightDoubleBracket]"}], "]"}], "\[GreaterEqual]", 
                    "2"}]}], ",", 
                    TemplateBox[{
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`element", "\[LeftDoubleBracket]", 
                    "1", "\[RightDoubleBracket]"}], "\[LeftDoubleBracket]", 
                    "2", "\[RightDoubleBracket]"}], "-", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`element", "\[LeftDoubleBracket]", 
                    "1", "\[RightDoubleBracket]"}], "\[LeftDoubleBracket]", 
                    "1", "\[RightDoubleBracket]"}]}]}, "Norm"], ",", "2"}], 
                    "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`cylinderLines", "=", 
                    RowBox[{"VilTeX`Private`cylinderToLines", "[", 
                    
                    RowBox[{"VilTeX`Private`center", ",", 
                    "VilTeX`Private`radius", ",", "VilTeX`Private`height"}], 
                    "]"}]}], ";", 
                    RowBox[{"Do", "[", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`linePoints", "=", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`cylinderLines", 
                    "\[LeftDoubleBracket]", "VilTeX`Private`j", 
                    "\[RightDoubleBracket]"}], "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}]}], ",", 
                    "VilTeX`Private`styleString"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`styleString", "=", 
                    
                    RowBox[{"VilTeX`Private`currentColor", "<>", 
                    "\", no marks, mark=none, line width=\"", "<>", 
                    "VilTeX`Private`currentThickness", "<>", "\"pt\""}]}], 
                    ";", 
                    RowBox[{"If", "[", 
                    RowBox[{"VilTeX`Private`currentDashing", ",", 
                    RowBox[{"VilTeX`Private`styleString", "=", 
                    
                    RowBox[{"VilTeX`Private`styleString", "<>", 
                    "\", densely dashed\""}]}]}], "]"}], ";", 
                    RowBox[{"VilTeX`Private`combinedTikzCode", "=", 
                    
                    RowBox[{"VilTeX`Private`combinedTikzCode", "<>", 
                    "\"\\\\addplot3[\"", "<>", "VilTeX`Private`styleString", 
                    "<>", "\"] coordinates {\\n\"", "<>", 
                    RowBox[{"StringRiffle", "[", 
                    RowBox[{
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"\"  (\"", "<>", 
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    
                    RowBox[{"VilTeX`Private`linePoints", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`k", ",", "1"}], 
                    "\[RightDoubleBracket]"}], "]"}], "<>", "\",\"", "<>", 
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    
                    RowBox[{"VilTeX`Private`linePoints", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`k", ",", "2"}], 
                    "\[RightDoubleBracket]"}], "]"}], "<>", "\",\"", "<>", 
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    
                    RowBox[{"VilTeX`Private`linePoints", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`k", ",", "3"}], 
                    "\[RightDoubleBracket]"}], "]"}], "<>", "\")\""}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`k", ",", 
                    
                    RowBox[{"Length", "[", "VilTeX`Private`linePoints", 
                    "]"}]}], "}"}]}], "]"}], ",", "\"\\n\""}], "]"}], "<>", 
                    "\"\\n};\\n\""}]}], ";", 
                    
                    RowBox[{"VilTeX`Private`addValidCoords", "[", 
                    "VilTeX`Private`linePoints", "]"}], ";"}]}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`j", ",", 
                    
                    RowBox[{"Length", "[", "VilTeX`Private`cylinderLines", 
                    "]"}]}], "}"}]}], "]"}], ";"}]}], "]"}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Head", "[", "VilTeX`Private`element", "]"}], 
                    "===", "Cone"}], "&&", 
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`element", "]"}], 
                    "\[GreaterEqual]", "1"}]}], ",", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`apex", ",", "VilTeX`Private`base",
                     ",", "VilTeX`Private`radius", ",", 
                    "VilTeX`Private`coneLines"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`element", "]"}], 
                    "\[GreaterEqual]", "1"}], "&&", 
                    RowBox[{"ListQ", "[", 
                    
                    RowBox[{"VilTeX`Private`element", "\[LeftDoubleBracket]", 
                    "1", "\[RightDoubleBracket]"}], "]"}], "&&", 
                    RowBox[{
                    RowBox[{"Length", "[", 
                    
                    RowBox[{"VilTeX`Private`element", "\[LeftDoubleBracket]", 
                    "1", "\[RightDoubleBracket]"}], "]"}], "\[GreaterEqual]", 
                    "2"}]}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`apex", "=", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`element", "\[LeftDoubleBracket]", 
                    "1", "\[RightDoubleBracket]"}], "\[LeftDoubleBracket]", 
                    "2", "\[RightDoubleBracket]"}]}], ";", 
                    RowBox[{"VilTeX`Private`base", "=", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`element", "\[LeftDoubleBracket]", 
                    "1", "\[RightDoubleBracket]"}], "\[LeftDoubleBracket]", 
                    "1", "\[RightDoubleBracket]"}]}], ";", 
                    RowBox[{"VilTeX`Private`radius", "=", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`element", "]"}], 
                    "\[GreaterEqual]", "2"}], ",", 
                    
                    RowBox[{"VilTeX`Private`element", "\[LeftDoubleBracket]", 
                    "2", "\[RightDoubleBracket]"}], ",", "1"}], "]"}]}], ";", 
                    
                    RowBox[{"VilTeX`Private`coneLines", "=", 
                    RowBox[{"VilTeX`Private`coneToLines", "[", 
                    
                    RowBox[{"VilTeX`Private`apex", ",", "VilTeX`Private`base",
                     ",", "VilTeX`Private`radius"}], "]"}]}], ";", 
                    RowBox[{"Do", "[", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`linePoints", "=", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`coneLines", 
                    "\[LeftDoubleBracket]", "VilTeX`Private`j", 
                    "\[RightDoubleBracket]"}], "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}]}], ",", 
                    "VilTeX`Private`styleString"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`styleString", "=", 
                    
                    RowBox[{"VilTeX`Private`currentColor", "<>", 
                    "\", no marks, mark=none, line width=\"", "<>", 
                    "VilTeX`Private`currentThickness", "<>", "\"pt\""}]}], 
                    ";", 
                    RowBox[{"If", "[", 
                    RowBox[{"VilTeX`Private`currentDashing", ",", 
                    RowBox[{"VilTeX`Private`styleString", "=", 
                    
                    RowBox[{"VilTeX`Private`styleString", "<>", 
                    "\", densely dashed\""}]}]}], "]"}], ";", 
                    RowBox[{"VilTeX`Private`combinedTikzCode", "=", 
                    
                    RowBox[{"VilTeX`Private`combinedTikzCode", "<>", 
                    "\"\\\\addplot3[\"", "<>", "VilTeX`Private`styleString", 
                    "<>", "\"] coordinates {\\n\"", "<>", 
                    RowBox[{"StringRiffle", "[", 
                    RowBox[{
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"\"  (\"", "<>", 
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    
                    RowBox[{"VilTeX`Private`linePoints", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`k", ",", "1"}], 
                    "\[RightDoubleBracket]"}], "]"}], "<>", "\",\"", "<>", 
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    
                    RowBox[{"VilTeX`Private`linePoints", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`k", ",", "2"}], 
                    "\[RightDoubleBracket]"}], "]"}], "<>", "\",\"", "<>", 
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    
                    RowBox[{"VilTeX`Private`linePoints", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`k", ",", "3"}], 
                    "\[RightDoubleBracket]"}], "]"}], "<>", "\")\""}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`k", ",", 
                    
                    RowBox[{"Length", "[", "VilTeX`Private`linePoints", 
                    "]"}]}], "}"}]}], "]"}], ",", "\"\\n\""}], "]"}], "<>", 
                    "\"\\n};\\n\""}]}], ";", 
                    RowBox[{
                    "VilTeX`Private`addValidCoords", "[", 
                    "VilTeX`Private`linePoints", "]"}], ";"}]}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`j", ",", 
                    
                    RowBox[{"Length", "[", "VilTeX`Private`coneLines", 
                    "]"}]}], "}"}]}], "]"}], ";"}]}], "]"}], ";"}]}], "]"}], 
                    ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Head", "[", "VilTeX`Private`element", "]"}], 
                    "===", "Cuboid"}], "&&", 
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`element", "]"}], 
                    "\[GreaterEqual]", "2"}]}], ",", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`min", ",", "VilTeX`Private`max", 
                    ",", "VilTeX`Private`cuboidLines"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`min", "=", 
                    
                    RowBox[{"VilTeX`Private`element", "\[LeftDoubleBracket]", 
                    "1", "\[RightDoubleBracket]"}]}], ";", 
                    RowBox[{"VilTeX`Private`max", "=", 
                    
                    RowBox[{"VilTeX`Private`element", "\[LeftDoubleBracket]", 
                    "2", "\[RightDoubleBracket]"}]}], ";", 
                    RowBox[{"VilTeX`Private`cuboidLines", "=", 
                    RowBox[{"VilTeX`Private`cuboidToLines", "[", 
                    RowBox[{"VilTeX`Private`min", ",", "VilTeX`Private`max"}],
                     "]"}]}], ";", 
                    RowBox[{"Do", "[", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`linePoints", "=", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`cuboidLines", 
                    "\[LeftDoubleBracket]", "VilTeX`Private`j", 
                    "\[RightDoubleBracket]"}], "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}]}], ",", 
                    "VilTeX`Private`styleString"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`styleString", "=", 
                    
                    RowBox[{"VilTeX`Private`currentColor", "<>", 
                    "\", no marks, mark=none, line width=\"", "<>", 
                    "VilTeX`Private`currentThickness", "<>", "\"pt\""}]}], 
                    ";", 
                    RowBox[{"If", "[", 
                    RowBox[{"VilTeX`Private`currentDashing", ",", 
                    RowBox[{"VilTeX`Private`styleString", "=", 
                    
                    RowBox[{"VilTeX`Private`styleString", "<>", 
                    "\", densely dashed\""}]}]}], "]"}], ";", 
                    RowBox[{"VilTeX`Private`combinedTikzCode", "=", 
                    
                    RowBox[{"VilTeX`Private`combinedTikzCode", "<>", 
                    "\"\\\\addplot3[\"", "<>", "VilTeX`Private`styleString", 
                    "<>", "\"] coordinates {\\n\"", "<>", 
                    RowBox[{"StringRiffle", "[", 
                    RowBox[{
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"\"  (\"", "<>", 
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    
                    RowBox[{"VilTeX`Private`linePoints", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`k", ",", "1"}], 
                    "\[RightDoubleBracket]"}], "]"}], "<>", "\",\"", "<>", 
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    
                    RowBox[{"VilTeX`Private`linePoints", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`k", ",", "2"}], 
                    "\[RightDoubleBracket]"}], "]"}], "<>", "\",\"", "<>", 
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    
                    RowBox[{"VilTeX`Private`linePoints", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`k", ",", "3"}], 
                    "\[RightDoubleBracket]"}], "]"}], "<>", "\")\""}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`k", ",", 
                    
                    RowBox[{"Length", "[", "VilTeX`Private`linePoints", 
                    "]"}]}], "}"}]}], "]"}], ",", "\"\\n\""}], "]"}], "<>", 
                    "\"\\n};\\n\""}]}], ";", 
                    
                    RowBox[{"VilTeX`Private`addValidCoords", "[", 
                    "VilTeX`Private`linePoints", "]"}], ";"}]}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`j", ",", 
                    
                    RowBox[{"Length", "[", "VilTeX`Private`cuboidLines", 
                    "]"}]}], "}"}]}], "]"}], ";"}]}], "]"}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Head", "[", "VilTeX`Private`element", "]"}], 
                    "===", "Text"}], "&&", 
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`element", "]"}], 
                    "\[GreaterEqual]", "2"}]}], ",", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`text", ",", 
                    "VilTeX`Private`pos"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`text", "=", 
                    RowBox[{"ToString", "[", 
                    
                    RowBox[{"VilTeX`Private`element", "\[LeftDoubleBracket]", 
                    "1", "\[RightDoubleBracket]"}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`pos", "=", 
                    RowBox[{"VilTeX`Private`element", "\[LeftDoubleBracket]", 
                    "2", "\[RightDoubleBracket]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ListQ", "[", "VilTeX`Private`pos", "]"}], "&&", 
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`pos", "]"}], 
                    "\[Equal]", "3"}], "&&", 
                    RowBox[{"AllTrue", "[", 
                    RowBox[{"VilTeX`Private`pos", ",", "NumericQ"}], "]"}]}], 
                    ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`textTikzCode", "=", 
                    
                    RowBox[{"VilTeX`Private`textTikzCode", "<>", 
                    "\"\\\\node[text=\"", "<>", "VilTeX`Private`currentColor",
                     "<>", "\"] at (axis cs:\"", "<>", 
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    
                    RowBox[{"VilTeX`Private`pos", "\[LeftDoubleBracket]", "1",
                     "\[RightDoubleBracket]"}], "]"}], "<>", "\",\"", "<>", 
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    
                    RowBox[{"VilTeX`Private`pos", "\[LeftDoubleBracket]", "2",
                     "\[RightDoubleBracket]"}], "]"}], "<>", "\",\"", "<>", 
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    
                    RowBox[{"VilTeX`Private`pos", "\[LeftDoubleBracket]", "3",
                     "\[RightDoubleBracket]"}], "]"}], "<>", "\") {\"", "<>", 
                    "VilTeX`Private`text", "<>", "\"};\\n\""}]}], ";", 
                    
                    RowBox[{"VilTeX`Private`addValidCoords", "[", 
                    "VilTeX`Private`pos", "]"}], ";"}]}], "]"}], ";"}]}], 
                    "]"}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Head", "[", "VilTeX`Private`element", "]"}], 
                    "===", "Tube"}], "&&", 
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`element", "]"}], 
                    "\[GreaterEqual]", "1"}]}], ",", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`curve", ",", 
                    "VilTeX`Private`linePoints", ",", 
                    "VilTeX`Private`styleString"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`curve", "=", 
                    
                    RowBox[{"VilTeX`Private`element", "\[LeftDoubleBracket]", 
                    "1", "\[RightDoubleBracket]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"Head", "[", "VilTeX`Private`curve", "]"}], "===",
                     "Line"}], "&&", 
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`curve", "]"}], 
                    "\[GreaterEqual]", "1"}]}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`linePoints", "=", 
                    
                    RowBox[{"VilTeX`Private`curve", "\[LeftDoubleBracket]", 
                    "1", "\[RightDoubleBracket]"}]}], ";", 
                    RowBox[{"VilTeX`Private`styleString", "=", 
                    
                    RowBox[{"VilTeX`Private`currentColor", "<>", 
                    "\", no marks, mark=none, line width=\"", "<>", 
                    "VilTeX`Private`currentThickness", "<>", "\"pt\""}]}], 
                    ";", 
                    RowBox[{"If", "[", 
                    RowBox[{"VilTeX`Private`currentDashing", ",", 
                    RowBox[{"VilTeX`Private`styleString", "=", 
                    
                    RowBox[{"VilTeX`Private`styleString", "<>", 
                    "\", densely dashed\""}]}]}], "]"}], ";", 
                    RowBox[{"VilTeX`Private`combinedTikzCode", "=", 
                    
                    RowBox[{"VilTeX`Private`combinedTikzCode", "<>", 
                    "\"\\\\addplot3[\"", "<>", "VilTeX`Private`styleString", 
                    "<>", "\"] coordinates {\\n\"", "<>", 
                    RowBox[{"StringRiffle", "[", 
                    RowBox[{
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"\"  (\"", "<>", 
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    
                    RowBox[{"VilTeX`Private`linePoints", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`k", ",", "1"}], 
                    "\[RightDoubleBracket]"}], "]"}], "<>", "\",\"", "<>", 
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    
                    RowBox[{"VilTeX`Private`linePoints", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`k", ",", "2"}], 
                    "\[RightDoubleBracket]"}], "]"}], "<>", "\",\"", "<>", 
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    
                    RowBox[{"VilTeX`Private`linePoints", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`k", ",", "3"}], 
                    "\[RightDoubleBracket]"}], "]"}], "<>", "\")\""}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`k", ",", 
                    
                    RowBox[{"Length", "[", "VilTeX`Private`linePoints", 
                    "]"}]}], "}"}]}], "]"}], ",", "\"\\n\""}], "]"}], "<>", 
                    "\"\\n};\\n\""}]}], ";", 
                    
                    RowBox[{"VilTeX`Private`addValidCoords", "[", 
                    "VilTeX`Private`linePoints", "]"}], ";"}]}], "]"}], 
                    ";"}]}], "]"}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Head", "[", "VilTeX`Private`element", "]"}], 
                    "===", "Polygon"}], "&&", 
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`element", "]"}], 
                    "\[GreaterEqual]", "1"}]}], ",", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`vertices", ",", 
                    "VilTeX`Private`polygonLines"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`polygonCount", "<", 
                    "VilTeX`Private`maxPolygons"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`vertices", "=", 
                    
                    RowBox[{"VilTeX`Private`element", "\[LeftDoubleBracket]", 
                    "1", "\[RightDoubleBracket]"}]}], ";", 
                    RowBox[{"VilTeX`Private`polygonLines", "=", 
                    
                    RowBox[{"VilTeX`Private`polygonToLines", "[", 
                    "VilTeX`Private`vertices", "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`polygonCount", "++"}], ";", 
                    RowBox[{"Do", "[", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`linePoints", "=", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`polygonLines", 
                    "\[LeftDoubleBracket]", "VilTeX`Private`j", 
                    "\[RightDoubleBracket]"}], "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}]}], ",", 
                    "VilTeX`Private`styleString"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`styleString", "=", 
                    
                    RowBox[{"VilTeX`Private`currentColor", "<>", 
                    "\", no marks, mark=none, line width=\"", "<>", 
                    "VilTeX`Private`currentThickness", "<>", "\"pt\""}]}], 
                    ";", 
                    RowBox[{"If", "[", 
                    RowBox[{"VilTeX`Private`currentDashing", ",", 
                    RowBox[{"VilTeX`Private`styleString", "=", 
                    
                    RowBox[{"VilTeX`Private`styleString", "<>", 
                    "\", densely dashed\""}]}]}], "]"}], ";", 
                    RowBox[{"VilTeX`Private`combinedTikzCode", "=", 
                    
                    RowBox[{"VilTeX`Private`combinedTikzCode", "<>", 
                    "\"\\\\addplot3[\"", "<>", "VilTeX`Private`styleString", 
                    "<>", "\"] coordinates {\\n\"", "<>", 
                    RowBox[{"StringRiffle", "[", 
                    RowBox[{
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"\"  (\"", "<>", 
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    RowBox[{
                    "VilTeX`Private`linePoints", "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`k", ",", "1"}], 
                    "\[RightDoubleBracket]"}], "]"}], "<>", "\",\"", "<>", 
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    
                    RowBox[{"VilTeX`Private`linePoints", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`k", ",", "2"}], 
                    "\[RightDoubleBracket]"}], "]"}], "<>", "\",\"", "<>", 
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    
                    RowBox[{"VilTeX`Private`linePoints", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`k", ",", "3"}], 
                    "\[RightDoubleBracket]"}], "]"}], "<>", "\")\""}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`k", ",", 
                    
                    RowBox[{"Length", "[", "VilTeX`Private`linePoints", 
                    "]"}]}], "}"}]}], "]"}], ",", "\"\\n\""}], "]"}], "<>", 
                    "\"\\n};\\n\""}]}], ";", 
                    RowBox[{
                    "VilTeX`Private`addValidCoords", "[", 
                    "VilTeX`Private`linePoints", "]"}], ";"}]}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`j", ",", 
                    
                    RowBox[{"Length", "[", "VilTeX`Private`polygonLines", 
                    "]"}]}], "}"}]}], "]"}], ";"}]}], "]"}], ";"}]}], "]"}], 
                    ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Head", "[", "VilTeX`Private`element", "]"}], 
                    "===", "Style"}], "&&", 
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`element", "]"}], 
                    "\[GreaterEqual]", "2"}]}], ",", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`content", ",", 
                    "VilTeX`Private`styles", ",", 
                    
                    RowBox[{"VilTeX`Private`tempColor", "=", 
                    "VilTeX`Private`currentColor"}], ",", 
                    
                    RowBox[{"VilTeX`Private`tempPointSize", "=", 
                    "VilTeX`Private`currentPointSize"}], ",", 
                    
                    RowBox[{"VilTeX`Private`tempThickness", "=", 
                    "VilTeX`Private`currentThickness"}], ",", 
                    
                    RowBox[{"VilTeX`Private`tempDashing", "=", 
                    "VilTeX`Private`currentDashing"}]}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`content", "=", 
                    
                    RowBox[{"VilTeX`Private`element", "\[LeftDoubleBracket]", 
                    "1", "\[RightDoubleBracket]"}]}], ";", 
                    RowBox[{"VilTeX`Private`styles", "=", 
                    RowBox[{"Drop", "[", 
                    RowBox[{"VilTeX`Private`element", ",", "1"}], "]"}]}], 
                    ";", 
                    RowBox[{"Do", "[", 
                    RowBox[{
                    RowBox[{"Which", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"Head", "[", 
                    
                    RowBox[{"VilTeX`Private`styles", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`j", "\[RightDoubleBracket]"}], "]"}], 
                    "===", "RGBColor"}], "||", 
                    RowBox[{
                    RowBox[{"Head", "[", 
                    
                    RowBox[{"VilTeX`Private`styles", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`j", "\[RightDoubleBracket]"}], "]"}], 
                    "===", "GrayLevel"}], "||", 
                    RowBox[{
                    RowBox[{"Head", "[", 
                    
                    RowBox[{"VilTeX`Private`styles", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`j", "\[RightDoubleBracket]"}], "]"}], 
                    "===", "Hue"}], "||", 
                    RowBox[{"MemberQ", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"Red", ",", "Blue", ",", "Green", ",", "Black", 
                    ",", "Orange", ",", "Gray", ",", "White", ",", "Yellow", 
                    ",", "Purple", ",", "Brown", ",", "Pink", ",", "Cyan", 
                    ",", "Magenta"}], "}"}], ",", 
                    RowBox[{"VilTeX`Private`styles", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`j", "\[RightDoubleBracket]"}]}], "]"}]}], 
                    ",", 
                    RowBox[{"VilTeX`Private`tempColor", "=", 
                    RowBox[{"VilTeX`Private`detectBasicColor", "[", 
                    
                    RowBox[{"VilTeX`Private`styles", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`j", "\[RightDoubleBracket]"}], "]"}]}], 
                    ",", 
                    RowBox[{
                    RowBox[{"Head", "[", 
                    
                    RowBox[{"VilTeX`Private`styles", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`j", "\[RightDoubleBracket]"}], "]"}], 
                    "===", "PointSize"}], ",", 
                    RowBox[{"VilTeX`Private`tempPointSize", "=", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"VilTeX`Private`pointSizeToNumber", "[", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`styles", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`j", "\[RightDoubleBracket]"}], 
                    "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
                    "]"}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"Head", "[", 
                    
                    RowBox[{"VilTeX`Private`styles", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`j", "\[RightDoubleBracket]"}], "]"}], 
                    "===", "Thickness"}], ",", 
                    RowBox[{"VilTeX`Private`tempThickness", "=", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"VilTeX`Private`thicknessToNumber", "[", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`styles", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`j", "\[RightDoubleBracket]"}], 
                    "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
                    "]"}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`styles", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`j", "\[RightDoubleBracket]"}], "===", 
                    "Dashed"}], "||", 
                    RowBox[{
                    RowBox[{"Head", "[", 
                    
                    RowBox[{"VilTeX`Private`styles", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`j", "\[RightDoubleBracket]"}], "]"}], 
                    "===", "Dashing"}]}], ",", 
                    RowBox[{"VilTeX`Private`tempDashing", "=", "True"}]}], 
                    "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`j", ",", 
                    RowBox[{"Length", "[", "VilTeX`Private`styles", "]"}]}], 
                    "}"}]}], "]"}], ";", 
                    RowBox[{"Which", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"Head", "[", "VilTeX`Private`content", "]"}], 
                    "===", "Cuboid"}], "&&", 
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`content", "]"}], 
                    "\[GreaterEqual]", "2"}]}], ",", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`min", ",", "VilTeX`Private`max", 
                    ",", "VilTeX`Private`cuboidLines"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`min", "=", 
                    
                    RowBox[{"VilTeX`Private`content", "\[LeftDoubleBracket]", 
                    "1", "\[RightDoubleBracket]"}]}], ";", 
                    RowBox[{"VilTeX`Private`max", "=", 
                    
                    RowBox[{"VilTeX`Private`content", "\[LeftDoubleBracket]", 
                    "2", "\[RightDoubleBracket]"}]}], ";", 
                    RowBox[{"VilTeX`Private`cuboidLines", "=", 
                    RowBox[{"VilTeX`Private`cuboidToLines", "[", 
                    RowBox[{"VilTeX`Private`min", ",", "VilTeX`Private`max"}],
                     "]"}]}], ";", 
                    RowBox[{"Do", "[", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`linePoints", "=", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`cuboidLines", 
                    "\[LeftDoubleBracket]", "VilTeX`Private`k", 
                    "\[RightDoubleBracket]"}], "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}]}], ",", 
                    "VilTeX`Private`styleString"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`styleString", "=", 
                    
                    RowBox[{"VilTeX`Private`tempColor", "<>", 
                    "\", no marks, mark=none, line width=\"", "<>", 
                    "VilTeX`Private`tempThickness", "<>", "\"pt\""}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{"VilTeX`Private`tempDashing", ",", 
                    RowBox[{"VilTeX`Private`styleString", "=", 
                    
                    RowBox[{"VilTeX`Private`styleString", "<>", 
                    "\", densely dashed\""}]}]}], "]"}], ";", 
                    RowBox[{"VilTeX`Private`combinedTikzCode", "=", 
                    
                    RowBox[{"VilTeX`Private`combinedTikzCode", "<>", 
                    "\"\\\\addplot3[\"", "<>", "VilTeX`Private`styleString", 
                    "<>", "\"] coordinates {\\n\"", "<>", 
                    RowBox[{"StringRiffle", "[", 
                    RowBox[{
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"\"  (\"", "<>", 
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    
                    RowBox[{"VilTeX`Private`linePoints", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`l", ",", "1"}], 
                    "\[RightDoubleBracket]"}], "]"}], "<>", "\",\"", "<>", 
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    
                    RowBox[{"VilTeX`Private`linePoints", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`l", ",", "2"}], 
                    "\[RightDoubleBracket]"}], "]"}], "<>", "\",\"", "<>", 
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    
                    RowBox[{"VilTeX`Private`linePoints", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`l", ",", "3"}], 
                    "\[RightDoubleBracket]"}], "]"}], "<>", "\")\""}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`l", ",", 
                    
                    RowBox[{"Length", "[", "VilTeX`Private`linePoints", 
                    "]"}]}], "}"}]}], "]"}], ",", "\"\\n\""}], "]"}], "<>", 
                    "\"\\n};\\n\""}]}], ";", 
                    RowBox[{"VilTeX`Private`addValidCoords", "[", 
                    "VilTeX`Private`linePoints", "]"}], ";"}]}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`k", ",", 
                    
                    RowBox[{"Length", "[", "VilTeX`Private`cuboidLines", 
                    "]"}]}], "}"}]}], "]"}], ";"}]}], "]"}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Head", "[", "VilTeX`Private`content", "]"}], 
                    "===", "Sphere"}], "&&", 
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`content", "]"}], 
                    "\[GreaterEqual]", "1"}]}], ",", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`center", ",", 
                    "VilTeX`Private`radius", ",", 
                    "VilTeX`Private`sphereLines"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`center", "=", 
                    
                    RowBox[{"VilTeX`Private`content", "\[LeftDoubleBracket]", 
                    "1", "\[RightDoubleBracket]"}]}], ";", 
                    RowBox[{"VilTeX`Private`radius", "=", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`content", "]"}], 
                    "\[GreaterEqual]", "2"}], ",", 
                    
                    RowBox[{"VilTeX`Private`content", "\[LeftDoubleBracket]", 
                    "2", "\[RightDoubleBracket]"}], ",", "1"}], "]"}]}], ";", 
                    
                    RowBox[{"VilTeX`Private`sphereLines", "=", 
                    RowBox[{"VilTeX`Private`sphereToLines", "[", 
                    RowBox[{"VilTeX`Private`center", ",", 
                    "VilTeX`Private`radius", ",", "15"}], "]"}]}], ";", 
                    RowBox[{"Do", "[", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`linePoints", "=", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`sphereLines", 
                    "\[LeftDoubleBracket]", "VilTeX`Private`k", 
                    "\[RightDoubleBracket]"}], "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}]}], ",", 
                    "VilTeX`Private`styleString"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`styleString", "=", 
                    
                    RowBox[{"VilTeX`Private`tempColor", "<>", 
                    "\", no marks, mark=none, line width=\"", "<>", 
                    "VilTeX`Private`tempThickness", "<>", "\"pt\""}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{"VilTeX`Private`tempDashing", ",", 
                    RowBox[{"VilTeX`Private`styleString", "=", 
                    
                    RowBox[{"VilTeX`Private`styleString", "<>", 
                    "\", densely dashed\""}]}]}], "]"}], ";", 
                    RowBox[{"VilTeX`Private`combinedTikzCode", "=", 
                    
                    RowBox[{"VilTeX`Private`combinedTikzCode", "<>", 
                    "\"\\\\addplot3[\"", "<>", "VilTeX`Private`styleString", 
                    "<>", "\"] coordinates {\\n\"", "<>", 
                    RowBox[{"StringRiffle", "[", 
                    RowBox[{
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"\"  (\"", "<>", 
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    
                    RowBox[{"VilTeX`Private`linePoints", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`l", ",", "1"}], 
                    "\[RightDoubleBracket]"}], "]"}], "<>", "\",\"", "<>", 
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    
                    RowBox[{"VilTeX`Private`linePoints", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`l", ",", "2"}], 
                    "\[RightDoubleBracket]"}], "]"}], "<>", "\",\"", "<>", 
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    
                    RowBox[{"VilTeX`Private`linePoints", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`l", ",", "3"}], 
                    "\[RightDoubleBracket]"}], "]"}], "<>", "\")\""}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`l", ",", 
                    
                    RowBox[{"Length", "[", "VilTeX`Private`linePoints", 
                    "]"}]}], "}"}]}], "]"}], ",", "\"\\n\""}], "]"}], "<>", 
                    "\"\\n};\\n\""}]}], ";", 
                    RowBox[{"VilTeX`Private`addValidCoords", "[", 
                    "VilTeX`Private`linePoints", "]"}], ";"}]}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`k", ",", 
                    
                    RowBox[{"Length", "[", "VilTeX`Private`sphereLines", 
                    "]"}]}], "}"}]}], "]"}], ";"}]}], "]"}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Head", "[", "VilTeX`Private`content", "]"}], 
                    "===", "Ellipsoid"}], "&&", 
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`content", "]"}], 
                    "\[GreaterEqual]", "2"}]}], ",", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`center", ",", 
                    "VilTeX`Private`semiAxes", ",", 
                    "VilTeX`Private`ellipsoidLines"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`center", "=", 
                    
                    RowBox[{"VilTeX`Private`content", "\[LeftDoubleBracket]", 
                    "1", "\[RightDoubleBracket]"}]}], ";", 
                    RowBox[{"VilTeX`Private`semiAxes", "=", 
                    
                    RowBox[{"VilTeX`Private`content", "\[LeftDoubleBracket]", 
                    "2", "\[RightDoubleBracket]"}]}], ";", 
                    RowBox[{"VilTeX`Private`ellipsoidLines", "=", 
                    RowBox[{"VilTeX`Private`ellipsoidToLines", "[", 
                    
                    RowBox[{"VilTeX`Private`center", ",", 
                    "VilTeX`Private`semiAxes", ",", "15"}], "]"}]}], ";", 
                    RowBox[{"Do", "[", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`linePoints", "=", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`ellipsoidLines", 
                    "\[LeftDoubleBracket]", "VilTeX`Private`k", 
                    "\[RightDoubleBracket]"}], "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}]}], ",", 
                    "VilTeX`Private`styleString"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`styleString", "=", 
                    
                    RowBox[{"VilTeX`Private`tempColor", "<>", 
                    "\", no marks, mark=none, line width=\"", "<>", 
                    "VilTeX`Private`tempThickness", "<>", "\"pt\""}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{"VilTeX`Private`tempDashing", ",", 
                    RowBox[{"VilTeX`Private`styleString", "=", 
                    
                    RowBox[{"VilTeX`Private`styleString", "<>", 
                    "\", densely dashed\""}]}]}], "]"}], ";", 
                    RowBox[{"VilTeX`Private`combinedTikzCode", "=", 
                    
                    RowBox[{"VilTeX`Private`combinedTikzCode", "<>", 
                    "\"\\\\addplot3[\"", "<>", "VilTeX`Private`styleString", 
                    "<>", "\"] coordinates {\\n\"", "<>", 
                    RowBox[{"StringRiffle", "[", 
                    RowBox[{
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"\"  (\"", "<>", 
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    
                    RowBox[{"VilTeX`Private`linePoints", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`l", ",", "1"}], 
                    "\[RightDoubleBracket]"}], "]"}], "<>", "\",\"", "<>", 
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    
                    RowBox[{"VilTeX`Private`linePoints", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`l", ",", "2"}], 
                    "\[RightDoubleBracket]"}], "]"}], "<>", "\",\"", "<>", 
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    
                    RowBox[{"VilTeX`Private`linePoints", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`l", ",", "3"}], 
                    "\[RightDoubleBracket]"}], "]"}], "<>", "\")\""}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`l", ",", 
                    
                    RowBox[{"Length", "[", "VilTeX`Private`linePoints", 
                    "]"}]}], "}"}]}], "]"}], ",", "\"\\n\""}], "]"}], "<>", 
                    "\"\\n};\\n\""}]}], ";", 
                    RowBox[{"VilTeX`Private`addValidCoords", "[", 
                    "VilTeX`Private`linePoints", "]"}], ";"}]}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`k", ",", 
                    
                    RowBox[{"Length", "[", "VilTeX`Private`ellipsoidLines", 
                    "]"}]}], "}"}]}], "]"}], ";"}]}], "]"}], ",", 
                    RowBox[{
                    RowBox[{"Head", "[", "VilTeX`Private`content", "]"}], 
                    "===", "Cylinder"}], ",", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`center", ",", 
                    "VilTeX`Private`radius", ",", "VilTeX`Private`height", 
                    ",", "VilTeX`Private`cylinderLines"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`center", "=", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`content", "]"}], 
                    "\[GreaterEqual]", "1"}], "&&", 
                    RowBox[{"ListQ", "[", 
                    RowBox[{"VilTeX`Private`content", "\[LeftDoubleBracket]", 
                    "1", "\[RightDoubleBracket]"}], "]"}], "&&", 
                    RowBox[{
                    RowBox[{"Length", "[", 
                    
                    RowBox[{"VilTeX`Private`content", "\[LeftDoubleBracket]", 
                    "1", "\[RightDoubleBracket]"}], "]"}], "\[GreaterEqual]", 
                    "2"}]}], ",", 
                    RowBox[{
                    FractionBox["1", "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`content", "\[LeftDoubleBracket]", 
                    "1", "\[RightDoubleBracket]"}], "\[LeftDoubleBracket]", 
                    "1", "\[RightDoubleBracket]"}], "+", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`content", "\[LeftDoubleBracket]", 
                    "1", "\[RightDoubleBracket]"}], "\[LeftDoubleBracket]", 
                    "2", "\[RightDoubleBracket]"}]}], ")"}]}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "]"}]}], ";", 
                    
                    RowBox[{"VilTeX`Private`radius", "=", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`content", "]"}], 
                    "\[GreaterEqual]", "2"}], ",", 
                    
                    RowBox[{"VilTeX`Private`content", "\[LeftDoubleBracket]", 
                    "2", "\[RightDoubleBracket]"}], ",", "1"}], "]"}]}], ";", 
                    
                    RowBox[{"VilTeX`Private`height", "=", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`content", "]"}], 
                    "\[GreaterEqual]", "1"}], "&&", 
                    RowBox[{"ListQ", "[", 
                    
                    RowBox[{"VilTeX`Private`content", "\[LeftDoubleBracket]", 
                    "1", "\[RightDoubleBracket]"}], "]"}], "&&", 
                    RowBox[{
                    RowBox[{"Length", "[", 
                    
                    RowBox[{"VilTeX`Private`content", "\[LeftDoubleBracket]", 
                    "1", "\[RightDoubleBracket]"}], "]"}], "\[GreaterEqual]", 
                    "2"}]}], ",", 
                    TemplateBox[{
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`content", "\[LeftDoubleBracket]", 
                    "1", "\[RightDoubleBracket]"}], "\[LeftDoubleBracket]", 
                    "2", "\[RightDoubleBracket]"}], "-", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`content", "\[LeftDoubleBracket]", 
                    "1", "\[RightDoubleBracket]"}], "\[LeftDoubleBracket]", 
                    "1", "\[RightDoubleBracket]"}]}]}, "Norm"], ",", "2"}], 
                    "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`cylinderLines", "=", 
                    RowBox[{"VilTeX`Private`cylinderToLines", "[", 
                    
                    RowBox[{"VilTeX`Private`center", ",", 
                    "VilTeX`Private`radius", ",", "VilTeX`Private`height"}], 
                    "]"}]}], ";", 
                    RowBox[{"Do", "[", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`linePoints", "=", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`cylinderLines", 
                    "\[LeftDoubleBracket]", "VilTeX`Private`k", 
                    "\[RightDoubleBracket]"}], "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}]}], ",", 
                    "VilTeX`Private`styleString"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`styleString", "=", 
                    
                    RowBox[{"VilTeX`Private`tempColor", "<>", 
                    "\", no marks, mark=none, line width=\"", "<>", 
                    "VilTeX`Private`tempThickness", "<>", "\"pt\""}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{"VilTeX`Private`tempDashing", ",", 
                    RowBox[{"VilTeX`Private`styleString", "=", 
                    RowBox[{"VilTeX`Private`styleString", "<>", 
                    "\", densely dashed\""}]}]}], "]"}], ";", 
                    RowBox[{"VilTeX`Private`combinedTikzCode", "=", 
                    
                    RowBox[{"VilTeX`Private`combinedTikzCode", "<>", 
                    "\"\\\\addplot3[\"", "<>", "VilTeX`Private`styleString", 
                    "<>", "\"] coordinates {\\n\"", "<>", 
                    RowBox[{"StringRiffle", "[", 
                    RowBox[{
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"\"  (\"", "<>", 
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    
                    RowBox[{"VilTeX`Private`linePoints", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`l", ",", "1"}], 
                    "\[RightDoubleBracket]"}], "]"}], "<>", "\",\"", "<>", 
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    
                    RowBox[{"VilTeX`Private`linePoints", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`l", ",", "2"}], 
                    "\[RightDoubleBracket]"}], "]"}], "<>", "\",\"", "<>", 
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    
                    RowBox[{"VilTeX`Private`linePoints", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`l", ",", "3"}], 
                    "\[RightDoubleBracket]"}], "]"}], "<>", "\")\""}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`l", ",", 
                    
                    RowBox[{"Length", "[", "VilTeX`Private`linePoints", 
                    "]"}]}], "}"}]}], "]"}], ",", "\"\\n\""}], "]"}], "<>", 
                    "\"\\n};\\n\""}]}], ";", 
                    RowBox[{"VilTeX`Private`addValidCoords", "[", 
                    "VilTeX`Private`linePoints", "]"}], ";"}]}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`k", ",", 
                    
                    RowBox[{"Length", "[", "VilTeX`Private`cylinderLines", 
                    "]"}]}], "}"}]}], "]"}], ";"}]}], "]"}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Head", "[", "VilTeX`Private`content", "]"}], 
                    "===", "Cone"}], "&&", 
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`content", "]"}], 
                    "\[GreaterEqual]", "1"}]}], ",", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`apex", ",", "VilTeX`Private`base",
                     ",", "VilTeX`Private`radius", ",", 
                    "VilTeX`Private`coneLines"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`content", "]"}], 
                    "\[GreaterEqual]", "1"}], "&&", 
                    RowBox[{"ListQ", "[", 
                    
                    RowBox[{"VilTeX`Private`content", "\[LeftDoubleBracket]", 
                    "1", "\[RightDoubleBracket]"}], "]"}], "&&", 
                    RowBox[{
                    RowBox[{"Length", "[", 
                    
                    RowBox[{"VilTeX`Private`content", "\[LeftDoubleBracket]", 
                    "1", "\[RightDoubleBracket]"}], "]"}], "\[GreaterEqual]", 
                    "2"}]}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`apex", "=", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`content", "\[LeftDoubleBracket]", 
                    "1", "\[RightDoubleBracket]"}], "\[LeftDoubleBracket]", 
                    "2", "\[RightDoubleBracket]"}]}], ";", 
                    RowBox[{"VilTeX`Private`base", "=", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`content", "\[LeftDoubleBracket]", 
                    "1", "\[RightDoubleBracket]"}], "\[LeftDoubleBracket]", 
                    "1", "\[RightDoubleBracket]"}]}], ";", 
                    RowBox[{"VilTeX`Private`radius", "=", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`content", "]"}], 
                    "\[GreaterEqual]", "2"}], ",", 
                    RowBox[{
                    "VilTeX`Private`content", "\[LeftDoubleBracket]", "2", 
                    "\[RightDoubleBracket]"}], ",", "1"}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`coneLines", "=", 
                    RowBox[{"VilTeX`Private`coneToLines", "[", 
                    
                    RowBox[{"VilTeX`Private`apex", ",", "VilTeX`Private`base",
                     ",", "VilTeX`Private`radius"}], "]"}]}], ";", 
                    RowBox[{"Do", "[", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`linePoints", "=", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`coneLines", 
                    "\[LeftDoubleBracket]", "VilTeX`Private`k", 
                    "\[RightDoubleBracket]"}], "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}]}], ",", 
                    "VilTeX`Private`styleString"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`styleString", "=", 
                    
                    RowBox[{"VilTeX`Private`tempColor", "<>", 
                    "\", no marks, mark=none, line width=\"", "<>", 
                    "VilTeX`Private`tempThickness", "<>", "\"pt\""}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{"VilTeX`Private`tempDashing", ",", 
                    RowBox[{"VilTeX`Private`styleString", "=", 
                    
                    RowBox[{"VilTeX`Private`styleString", "<>", 
                    "\", densely dashed\""}]}]}], "]"}], ";", 
                    RowBox[{"VilTeX`Private`combinedTikzCode", "=", 
                    
                    RowBox[{"VilTeX`Private`combinedTikzCode", "<>", 
                    "\"\\\\addplot3[\"", "<>", "VilTeX`Private`styleString", 
                    "<>", "\"] coordinates {\\n\"", "<>", 
                    RowBox[{"StringRiffle", "[", 
                    RowBox[{
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"\"  (\"", "<>", 
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    
                    RowBox[{"VilTeX`Private`linePoints", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`l", ",", "1"}], 
                    "\[RightDoubleBracket]"}], "]"}], "<>", "\",\"", "<>", 
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    
                    RowBox[{"VilTeX`Private`linePoints", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`l", ",", "2"}], 
                    "\[RightDoubleBracket]"}], "]"}], "<>", "\",\"", "<>", 
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    
                    RowBox[{"VilTeX`Private`linePoints", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`l", ",", "3"}], 
                    "\[RightDoubleBracket]"}], "]"}], "<>", "\")\""}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`l", ",", 
                    
                    RowBox[{"Length", "[", "VilTeX`Private`linePoints", 
                    "]"}]}], "}"}]}], "]"}], ",", "\"\\n\""}], "]"}], "<>", 
                    "\"\\n};\\n\""}]}], ";", 
                    RowBox[{"VilTeX`Private`addValidCoords", "[", 
                    "VilTeX`Private`linePoints", "]"}], ";"}]}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`k", ",", 
                    
                    RowBox[{"Length", "[", "VilTeX`Private`coneLines", 
                    "]"}]}], "}"}]}], "]"}], ";"}]}], "]"}], ";"}]}], "]"}], 
                    ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Head", "[", "VilTeX`Private`content", "]"}], 
                    "===", "Polygon"}], "&&", 
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`content", "]"}], 
                    "\[GreaterEqual]", "1"}]}], ",", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`vertices", ",", 
                    "VilTeX`Private`polygonLines"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`polygonCount", "<", 
                    "VilTeX`Private`maxPolygons"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`vertices", "=", 
                    
                    RowBox[{"VilTeX`Private`content", "\[LeftDoubleBracket]", 
                    "1", "\[RightDoubleBracket]"}]}], ";", 
                    RowBox[{"VilTeX`Private`polygonLines", "=", 
                    
                    RowBox[{"VilTeX`Private`polygonToLines", "[", 
                    "VilTeX`Private`vertices", "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`polygonCount", "++"}], ";", 
                    RowBox[{"Do", "[", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`linePoints", "=", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`polygonLines", 
                    "\[LeftDoubleBracket]", "VilTeX`Private`k", 
                    "\[RightDoubleBracket]"}], "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}]}], ",", 
                    "VilTeX`Private`styleString"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`styleString", "=", 
                    
                    RowBox[{"VilTeX`Private`tempColor", "<>", 
                    "\", no marks, mark=none, line width=\"", "<>", 
                    "VilTeX`Private`tempThickness", "<>", "\"pt\""}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{"VilTeX`Private`tempDashing", ",", 
                    RowBox[{"VilTeX`Private`styleString", "=", 
                    
                    RowBox[{"VilTeX`Private`styleString", "<>", 
                    "\", densely dashed\""}]}]}], "]"}], ";", 
                    RowBox[{"VilTeX`Private`combinedTikzCode", "=", 
                    
                    RowBox[{"VilTeX`Private`combinedTikzCode", "<>", 
                    "\"\\\\addplot3[\"", "<>", "VilTeX`Private`styleString", 
                    "<>", "\"] coordinates {\\n\"", "<>", 
                    RowBox[{"StringRiffle", "[", 
                    RowBox[{
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"\"  (\"", "<>", 
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    
                    RowBox[{"VilTeX`Private`linePoints", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`l", ",", "1"}], 
                    "\[RightDoubleBracket]"}], "]"}], "<>", "\",\"", "<>", 
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    
                    RowBox[{"VilTeX`Private`linePoints", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`l", ",", "2"}], 
                    "\[RightDoubleBracket]"}], "]"}], "<>", "\",\"", "<>", 
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    
                    RowBox[{"VilTeX`Private`linePoints", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`l", ",", "3"}], 
                    "\[RightDoubleBracket]"}], "]"}], "<>", "\")\""}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`l", ",", 
                    
                    RowBox[{"Length", "[", "VilTeX`Private`linePoints", 
                    "]"}]}], "}"}]}], "]"}], ",", "\"\\n\""}], "]"}], "<>", 
                    "\"\\n};\\n\""}]}], ";", 
                    RowBox[{"VilTeX`Private`addValidCoords", "[", 
                    "VilTeX`Private`linePoints", "]"}], ";"}]}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`k", ",", 
                    
                    RowBox[{"Length", "[", "VilTeX`Private`polygonLines", 
                    "]"}]}], "}"}]}], "]"}], ";"}]}], "]"}], ";"}]}], "]"}]}],
                     "]"}], ";"}]}], "]"}]}], "]"}], ";"}]}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`i", ",", 
                    
                    RowBox[{"Length", "[", "VilTeX`Private`flatElements", 
                    "]"}]}], "}"}]}], "]"}], ";"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`polygonCount", "\[GreaterEqual]", 
                    "VilTeX`Private`maxPolygons"}], ",", 
                    RowBox[{
                    RowBox[{"Print", "[", 
                    
                    RowBox[{"\"Se alcanz\[OAcute] el l\[IAcute]mite de \"", 
                    ",", "VilTeX`Private`maxPolygons", ",", 
                    "\" pol\[IAcute]gonos. Algunos elementos no se \
exportaron.\""}], "]"}], ";", 
                    
                    RowBox[{"Print", "[", 
                    "\"   Para exportar todos los elementos, aumente el par\
\[AAcute]metro maxPolygons o reduzca la resoluci\[OAcute]n del \
gr\[AAcute]fico.\"", "]"}], ";"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"Length", "[", "VilTeX`Private`allValidData", 
                    "]"}], "\[Equal]", "0"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`allValidData", "=", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], "}"}]}], 
                    ";"}]}], "]"}], ";", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`xDataMin", ",", 
                    "VilTeX`Private`xDataMax", ",", "VilTeX`Private`yDataMin",
                     ",", "VilTeX`Private`yDataMax", ",", 
                    "VilTeX`Private`zDataMin", ",", 
                    "VilTeX`Private`zDataMax"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"Length", "[", "VilTeX`Private`allValidData", 
                    "]"}], ">", "0"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`xDataMin", "=", 
                    RowBox[{"Min", "[", 
                    
                    RowBox[{"VilTeX`Private`allValidData", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"All", ",", "1"}], "\[RightDoubleBracket]"}], 
                    "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`xDataMax", "=", 
                    RowBox[{"Max", "[", 
                    
                    RowBox[{"VilTeX`Private`allValidData", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"All", ",", "1"}], "\[RightDoubleBracket]"}], 
                    "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`yDataMin", "=", 
                    RowBox[{"Min", "[", 
                    
                    RowBox[{"VilTeX`Private`allValidData", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"All", ",", "2"}], "\[RightDoubleBracket]"}], 
                    "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`yDataMax", "=", 
                    RowBox[{"Max", "[", 
                    
                    RowBox[{"VilTeX`Private`allValidData", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"All", ",", "2"}], "\[RightDoubleBracket]"}], 
                    "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`zDataMin", "=", 
                    RowBox[{"Min", "[", 
                    
                    RowBox[{"VilTeX`Private`allValidData", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"All", ",", "3"}], "\[RightDoubleBracket]"}], 
                    "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`zDataMax", "=", 
                    RowBox[{"Max", "[", 
                    
                    RowBox[{"VilTeX`Private`allValidData", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"All", ",", "3"}], "\[RightDoubleBracket]"}], 
                    "]"}]}], ";", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`xRange", ",", 
                    "VilTeX`Private`yRange", ",", "VilTeX`Private`zRange", 
                    ",", 
                    RowBox[{"VilTeX`Private`padding", "=", "0.1`"}]}], "}"}], 
                    ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`xRange", "=", 
                    RowBox[{"Max", "[", 
                    RowBox[{
                    RowBox[{
                    "VilTeX`Private`xDataMax", "-", 
                    "VilTeX`Private`xDataMin"}], ",", "0.1`"}], "]"}]}], ";", 
                    
                    RowBox[{"VilTeX`Private`yRange", "=", 
                    RowBox[{"Max", "[", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`yDataMax", "-", 
                    "VilTeX`Private`yDataMin"}], ",", "0.1`"}], "]"}]}], ";", 
                    
                    RowBox[{"VilTeX`Private`zRange", "=", 
                    RowBox[{"Max", "[", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`zDataMax", "-", 
                    "VilTeX`Private`zDataMin"}], ",", "0.1`"}], "]"}]}], ";", 
                    
                    RowBox[{"VilTeX`Private`xDataMin", "=", 
                    RowBox[{"VilTeX`Private`xDataMin", "-", 
                    
                    RowBox[{"VilTeX`Private`padding", " ", 
                    "VilTeX`Private`xRange"}]}]}], ";", 
                    RowBox[{"VilTeX`Private`xDataMax", "=", 
                    RowBox[{"VilTeX`Private`xDataMax", "+", 
                    
                    RowBox[{"VilTeX`Private`padding", " ", 
                    "VilTeX`Private`xRange"}]}]}], ";", 
                    RowBox[{"VilTeX`Private`yDataMin", "=", 
                    RowBox[{"VilTeX`Private`yDataMin", "-", 
                    
                    RowBox[{"VilTeX`Private`padding", " ", 
                    "VilTeX`Private`yRange"}]}]}], ";", 
                    RowBox[{"VilTeX`Private`yDataMax", "=", 
                    RowBox[{"VilTeX`Private`yDataMax", "+", 
                    
                    RowBox[{"VilTeX`Private`padding", " ", 
                    "VilTeX`Private`yRange"}]}]}], ";", 
                    RowBox[{"VilTeX`Private`zDataMin", "=", 
                    RowBox[{"VilTeX`Private`zDataMin", "-", 
                    
                    RowBox[{"VilTeX`Private`padding", " ", 
                    "VilTeX`Private`zRange"}]}]}], ";", 
                    RowBox[{"VilTeX`Private`zDataMax", "=", 
                    RowBox[{"VilTeX`Private`zDataMax", "+", 
                    
                    RowBox[{"VilTeX`Private`padding", " ", 
                    "VilTeX`Private`zRange"}]}]}], ";"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`axisType", "\[Equal]", 
                    "\"center\""}], "&&", 
                    RowBox[{"VilTeX`Private`axisExtension", ">", "0"}]}], ",", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`xRange", ",", 
                    "VilTeX`Private`yRange", ",", "VilTeX`Private`zRange"}], 
                    "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`xRange", "=", 
                    
                    RowBox[{"VilTeX`Private`xDataMax", "-", 
                    "VilTeX`Private`xDataMin"}]}], ";", 
                    RowBox[{"VilTeX`Private`yRange", "=", 
                    
                    RowBox[{"VilTeX`Private`yDataMax", "-", 
                    "VilTeX`Private`yDataMin"}]}], ";", 
                    RowBox[{"VilTeX`Private`zRange", "=", 
                    
                    RowBox[{"VilTeX`Private`zDataMax", "-", 
                    "VilTeX`Private`zDataMin"}]}], ";", 
                    RowBox[{"VilTeX`Private`xDataMin", "=", 
                    RowBox[{"VilTeX`Private`xDataMin", "-", 
                    
                    RowBox[{"VilTeX`Private`axisExtension", " ", 
                    "VilTeX`Private`xRange"}]}]}], ";", 
                    RowBox[{"VilTeX`Private`xDataMax", "=", 
                    RowBox[{"VilTeX`Private`xDataMax", "+", 
                    
                    RowBox[{"VilTeX`Private`axisExtension", " ", 
                    "VilTeX`Private`xRange"}]}]}], ";", 
                    RowBox[{"VilTeX`Private`yDataMin", "=", 
                    RowBox[{"VilTeX`Private`yDataMin", "-", 
                    
                    RowBox[{"VilTeX`Private`axisExtension", " ", 
                    "VilTeX`Private`yRange"}]}]}], ";", 
                    RowBox[{"VilTeX`Private`yDataMax", "=", 
                    RowBox[{"VilTeX`Private`yDataMax", "+", 
                    
                    RowBox[{"VilTeX`Private`axisExtension", " ", 
                    "VilTeX`Private`yRange"}]}]}], ";", 
                    RowBox[{"VilTeX`Private`zDataMin", "=", 
                    RowBox[{"VilTeX`Private`zDataMin", "-", 
                    
                    RowBox[{"VilTeX`Private`axisExtension", " ", 
                    "VilTeX`Private`zRange"}]}]}], ";", 
                    RowBox[{"VilTeX`Private`zDataMax", "=", 
                    RowBox[{"VilTeX`Private`zDataMax", "+", 
                    
                    RowBox[{"VilTeX`Private`axisExtension", " ", 
                    "VilTeX`Private`zRange"}]}]}], ";"}]}], "]"}], ";"}]}], 
                    "]"}], ";", 
                    RowBox[{"VilTeX`Private`globalLimits", "=", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`xDataMin", ",", 
                    "VilTeX`Private`xDataMax", ",", "VilTeX`Private`yDataMin",
                     ",", "VilTeX`Private`yDataMax", ",", 
                    "VilTeX`Private`zDataMin", ",", 
                    "VilTeX`Private`zDataMax"}], "}"}]}], ";"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`globalLimits", "=", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "2"}], ",", "2", ",", 
                    RowBox[{"-", "2"}], ",", "2", ",", 
                    RowBox[{"-", "2"}], ",", "2"}], "}"}]}], ";"}]}], "]"}], 
                    ";"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"Length", "[", "VilTeX`Private`textAnnotations", 
                    "]"}], ">", "0"}], ",", 
                    RowBox[{
                    RowBox[{"Do", "[", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`annotation", ",", 
                    "VilTeX`Private`text", ",", "VilTeX`Private`coords", ",", 
                    "VilTeX`Private`options", ",", "VilTeX`Private`xPos", ",",
                     "VilTeX`Private`yPos", ",", "VilTeX`Private`zPos", ",", 
                    "VilTeX`Private`textOptions", ",", 
                    "VilTeX`Private`validCoords"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`annotation", "=", 
                    
                    RowBox[{"VilTeX`Private`textAnnotations", 
                    "\[LeftDoubleBracket]", "VilTeX`Private`i", 
                    "\[RightDoubleBracket]"}]}], ";", 
                    RowBox[{"VilTeX`Private`text", "=", "\"\""}], ";", 
                    RowBox[{"VilTeX`Private`textOptions", "=", "\"\""}], ";", 
                    
                    RowBox[{"VilTeX`Private`validCoords", "=", "False"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ListQ", "[", "VilTeX`Private`annotation", "]"}], 
                    "&&", 
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`annotation", "]"}],
                     "\[GreaterEqual]", "2"}]}], ",", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"StringQ", "[", 
                    
                    RowBox[{"VilTeX`Private`annotation", 
                    "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
                    "]"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`text", "=", 
                    
                    RowBox[{"VilTeX`Private`annotation", 
                    "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}], 
                    ";"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ListQ", "[", 
                    
                    RowBox[{"VilTeX`Private`annotation", 
                    "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], 
                    "]"}], "&&", 
                    RowBox[{
                    RowBox[{"Length", "[", 
                    
                    RowBox[{"VilTeX`Private`annotation", 
                    "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], 
                    "]"}], "\[Equal]", "3"}]}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`coords", "=", 
                    
                    RowBox[{"VilTeX`Private`annotation", 
                    "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}]}], 
                    ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"AllTrue", "[", 
                    RowBox[{"VilTeX`Private`coords", ",", "NumericQ"}], "]"}],
                     ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`xPos", ",", "VilTeX`Private`yPos",
                     ",", "VilTeX`Private`zPos"}], "}"}], "=", 
                    RowBox[{"N", "[", "VilTeX`Private`coords", "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`validCoords", "=", "True"}], 
                    ";"}]}], "]"}], ";"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`annotation", "]"}],
                     "\[GreaterEqual]", "3"}], "&&", 
                    RowBox[{"ListQ", "[", 
                    
                    RowBox[{"VilTeX`Private`annotation", 
                    "\[LeftDoubleBracket]", "3", "\[RightDoubleBracket]"}], 
                    "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`options", "=", 
                    
                    RowBox[{"VilTeX`Private`annotation", 
                    "\[LeftDoubleBracket]", "3", "\[RightDoubleBracket]"}]}], 
                    ";", 
                    RowBox[{"Do", "[", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ListQ", "[", 
                    
                    RowBox[{"VilTeX`Private`options", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`j", "\[RightDoubleBracket]"}], "]"}], 
                    "&&", 
                    RowBox[{
                    RowBox[{"Length", "[", 
                    
                    RowBox[{"VilTeX`Private`options", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`j", "\[RightDoubleBracket]"}], "]"}], 
                    "\[GreaterEqual]", "2"}]}], ",", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`key", ",", "VilTeX`Private`val"}],
                     "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`key", "=", 
                    RowBox[{"ToString", "[", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`options", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`j", "\[RightDoubleBracket]"}], 
                    "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
                    "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`val", "=", 
                    RowBox[{"ToString", "[", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`options", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`j", "\[RightDoubleBracket]"}], 
                    "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], 
                    "]"}]}], ";", 
                    RowBox[{"Which", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`key", "\[Equal]", "\"color\""}], 
                    ",", 
                    RowBox[{"VilTeX`Private`textOptions", "=", 
                    
                    RowBox[{"VilTeX`Private`textOptions", "<>", "\"text=\"", 
                    "<>", "VilTeX`Private`val", "<>", "\",\""}]}], ",", 
                    RowBox[{"VilTeX`Private`key", "\[Equal]", "\"size\""}], 
                    ",", 
                    RowBox[{"VilTeX`Private`textOptions", "=", 
                    
                    RowBox[{"VilTeX`Private`textOptions", "<>", "\"font=\"", 
                    "<>", "VilTeX`Private`val", "<>", "\",\""}]}], ",", 
                    RowBox[{"VilTeX`Private`key", "\[Equal]", "\"anchor\""}], 
                    ",", 
                    RowBox[{"VilTeX`Private`textOptions", "=", 
                    
                    RowBox[{"VilTeX`Private`textOptions", "<>", 
                    "\"anchor=\"", "<>", "VilTeX`Private`val", "<>", 
                    "\",\""}]}], ",", 
                    RowBox[{"VilTeX`Private`key", "\[Equal]", "\"rotate\""}], 
                    ",", 
                    RowBox[{"VilTeX`Private`textOptions", "=", 
                    RowBox[{"VilTeX`Private`textOptions", "<>", 
                    "\"rotate=\"", "<>", "VilTeX`Private`val", "<>", 
                    "\",\""}]}], ",", "True", ",", 
                    RowBox[{"VilTeX`Private`textOptions", "=", 
                    
                    RowBox[{"VilTeX`Private`textOptions", "<>", 
                    "VilTeX`Private`key", "<>", "\"=\"", "<>", 
                    "VilTeX`Private`val", "<>", "\",\""}]}]}], "]"}], ";"}]}],
                     "]"}], ";"}]}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`j", ",", 
                    RowBox[{"Length", "[", "VilTeX`Private`options", "]"}]}], 
                    "}"}]}], "]"}], ";"}]}], "]"}], ";"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"StringQ", "[", "VilTeX`Private`text", "]"}], 
                    "&&", 
                    RowBox[{"VilTeX`Private`text", "\[NotEqual]", "\"\""}], 
                    "&&", "VilTeX`Private`validCoords", "&&", 
                    RowBox[{"AllTrue", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`xPos", ",", "VilTeX`Private`yPos",
                     ",", "VilTeX`Private`zPos"}], "}"}], ",", "NumericQ"}], 
                    "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"StringLength", "[", "VilTeX`Private`textOptions",
                     "]"}], ">", "0"}], "&&", 
                    RowBox[{
                    RowBox[{"StringTake", "[", 
                    RowBox[{"VilTeX`Private`textOptions", ",", 
                    RowBox[{"-", "1"}]}], "]"}], "\[Equal]", "\",\""}]}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`textOptions", "=", 
                    RowBox[{"StringDrop", "[", 
                    RowBox[{"VilTeX`Private`textOptions", ",", 
                    RowBox[{"-", "1"}]}], "]"}]}], ";"}]}], "]"}], ";", 
                    RowBox[{"VilTeX`Private`textTikzCode", "=", 
                    
                    RowBox[{"VilTeX`Private`textTikzCode", "<>", 
                    "\"\\\\node[\"", "<>", "VilTeX`Private`textOptions", "<>",
                     "\"] at (axis cs:\"", "<>", 
                    
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    "VilTeX`Private`xPos", "]"}], "<>", "\",\"", "<>", 
                    
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    "VilTeX`Private`yPos", "]"}], "<>", "\",\"", "<>", 
                    
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    "VilTeX`Private`zPos", "]"}], "<>", "\") {\"", "<>", 
                    "VilTeX`Private`text", "<>", "\"};\\n\""}]}], ";"}]}], 
                    "]"}], ";"}]}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`i", ",", 
                    
                    RowBox[{"Length", "[", "VilTeX`Private`textAnnotations", 
                    "]"}]}], "}"}]}], "]"}], ";"}]}], "]"}], ";", 
                    RowBox[{"VilTeX`Private`folderName", "=", 
                    
                    RowBox[{"FileBaseName", "[", "VilTeX`Private`filename", 
                    "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`folderPath", "=", 
                    RowBox[{"FileNameJoin", "[", 
                    RowBox[{"{", 
                    
                    RowBox[{"$HomeDirectory", ",", "\"Downloads\"", ",", 
                    "VilTeX`Private`folderName"}], "}"}], "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"!", 
                    
                    RowBox[{"DirectoryQ", "[", "VilTeX`Private`folderPath", 
                    "]"}]}], ",", 
                    
                    RowBox[{"CreateDirectory", "[", 
                    "VilTeX`Private`folderPath", "]"}]}], "]"}], ";", 
                    RowBox[{"VilTeX`Private`downloadPath", "=", 
                    RowBox[{"FileNameJoin", "[", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`folderPath", ",", 
                    "VilTeX`Private`filename"}], "}"}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`tikzCode", "=", 
                    RowBox[{
                    "\"\\\\begin{tikzpicture}\\n\\\\begin{axis}[\\n\"", "<>", 
                    "\"  xlabel={$x$},\\n  ylabel={$y$},\\n  zlabel={$z$},\\n\
\"", "<>", "\"  xmin=\"", "<>", 
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    
                    RowBox[{"VilTeX`Private`globalLimits", 
                    "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
                    "]"}], "<>", "\", xmax=\"", "<>", 
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    
                    RowBox[{"VilTeX`Private`globalLimits", 
                    "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], 
                    "]"}], "<>", "\",\\n\"", "<>", "\"  ymin=\"", "<>", 
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    
                    RowBox[{"VilTeX`Private`globalLimits", 
                    "\[LeftDoubleBracket]", "3", "\[RightDoubleBracket]"}], 
                    "]"}], "<>", "\", ymax=\"", "<>", 
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    
                    RowBox[{"VilTeX`Private`globalLimits", 
                    "\[LeftDoubleBracket]", "4", "\[RightDoubleBracket]"}], 
                    "]"}], "<>", "\",\\n\"", "<>", "\"  zmin=\"", "<>", 
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    
                    RowBox[{"VilTeX`Private`globalLimits", 
                    "\[LeftDoubleBracket]", "5", "\[RightDoubleBracket]"}], 
                    "]"}], "<>", "\", zmax=\"", "<>", 
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    
                    RowBox[{"VilTeX`Private`globalLimits", 
                    "\[LeftDoubleBracket]", "6", "\[RightDoubleBracket]"}], 
                    "]"}], "<>", "\",\\n\"", "<>", 
                    RowBox[{"If", "[", 
                    
                    RowBox[{"VilTeX`Private`grid", ",", 
                    "\"  grid=major,\\n\"", ",", "\"\""}], "]"}], "<>", 
                    "\"  view={60}{30},\\n\"", "<>", "\"  \"", "<>", 
                    "VilTeX`Private`axisConfiguration", "<>", "\",\\n\"", 
                    "<>", "\"  axis equal=false,\\n\"", "<>", 
                    "\"  samples=50,\\n\"", "<>", "\"  point meta=z,\\n\"", 
                    "<>", "\"  \"", "<>", "VilTeX`Private`colormapStyle", 
                    "<>", "\"\\n\"", "<>", "\"]\\n\"", "<>", 
                    "VilTeX`Private`combinedTikzCode", "<>", 
                    "VilTeX`Private`textTikzCode", "<>", 
                    "\"\\\\end{axis}\\n\\\\end{tikzpicture}\""}]}], ";", 
                    RowBox[{"VilTeX`Private`fullDocument", "=", 
                    
                    RowBox[{
                    "\"\\\\documentclass[border=5mm]{standalone}\\n\"", "<>", 
                    "\"\\\\usepackage{tikz}\\n\\\\usepackage{pgfplots}\\n\"", 
                    "<>", "\"\\\\usepackage{amsmath}\\n\\\\usepackage{amssymb}\
\\n\"", "<>", 
                    "\"\\\\usetikzlibrary{arrows.meta}\\n\\\\pgfplotsset{\
compat=1.18}\\n\"", "<>", 
                    "\"\\\\usepgfplotslibrary{colorbrewer}\\n\\\\\
usepgfplotslibrary{colormaps}\\n\\n\"", "<>", "\"\\\\begin{document}\\n\"", 
                    "<>", "VilTeX`Private`tikzCode", "<>", 
                    "\"\\n\\\\end{document}\""}]}], ";", 
                    RowBox[{"Export", "[", 
                    
                    RowBox[{"VilTeX`Private`downloadPath", ",", 
                    "VilTeX`Private`fullDocument", ",", "\"Text\""}], "]"}], 
                    ";", "VilTeX`Private`downloadPath"}]}], "]"}]}]}, {" "}}, 
                  GridBoxAlignment -> {"Columns" -> {{Left}}}, 
                  DefaultBaseStyle -> "Column", 
                  GridBoxItemSize -> {
                   "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}]},
                "RowDefault"]}
             },
             DefaultBaseStyle->"Column",
             GridBoxAlignment->{"Columns" -> {{Left}}},
             
             GridBoxItemSize->{
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
            "Column"],
           FrameMargins->{{6, 0}, {3, 6}}], "\<\"\"\>"},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Attributes\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"Attributes\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "Attributes", "Tooltip"]& ], 
                   RowBox[{"{", "Protected", "}"}]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"VilTeX`ExportToTikZGraphics3D\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->{{6, 6}, {6, 3}}], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          LightDarkSwitched[
           GrayLevel[0.8]], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox[
             TagBox[
              TooltipBox[
               StyleBox["\<\" Symbol\"\>", "InformationRowLabel",
                StripOnInput->False],
               "\"Symbol\"",
               TooltipStyle->"TextStyling"],
              Annotation[#, "Symbol", "Tooltip"]& ], "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"ExportToTikZGraphics3D[graphics, filename, grid, \
axisType, axisExtension, resolution, textAnnotations, maxPolygons] exporta \
objetos Graphics3D de Mathematica a c\[OAcute]digo TikZ/LaTeX para su uso en \
documentos acad\[EAcute]micos y \
publicaciones.\\n\\nPAR\[CapitalAAcute]METROS:\\n\\ngraphics - Objeto \
Graphics3D, lista de primitivas 3D, o primitiva individual v\[AAcute]lida\\n  \
  \[Bullet] Graphics3D[primitivas] - Objeto gr\[AAcute]fico 3D completo\\n    \
\[Bullet] {Point[...], Line[...], Polygon[...]} - Lista de primitivas\\n    \
\[Bullet] Point[{x,y,z}] - Primitiva individual\\n    \[Bullet] Primitivas \
soportadas: Point, Line, Polygon, Sphere, Cylinder, Cone, Cuboid, Ellipsoid, \
Arrow, Tube, Text, Style\\n\\nfilename - Cadena de texto con el nombre del \
archivo de salida\\n    \[Bullet] Debe terminar en '.tex'\\n    \[Bullet] No \
debe contener caracteres especiales: <, >, :, \\\", /, \\\\, |, ?, *\\n    \
\[Bullet] Ejemplo: \\\"migrafico.tex\\\"\\n\\ngrid (por defecto: True) - \
Controla la visualizaci\[OAcute]n de la grilla\\n    \[Bullet] True - Muestra \
grilla mayor en el gr\[AAcute]fico\\n    \[Bullet] False - Sin \
grilla\\n\\naxisType (por defecto: \\\"box\\\") - Estilo de los ejes del gr\
\[AAcute]fico\\n    \[Bullet] \\\"box\\\" - Ejes tipo caja (6 caras)\\n    \
\[Bullet] \\\"center\\\" - Ejes centrados con flechas\\n    \[Bullet] \
\\\"none\\\" - Sin ejes visibles\\n\\naxisExtension (por defecto: 0.0) - \
Extensi\[OAcute]n adicional de los ejes (solo para \
axisType=\\\"center\\\")\\n    \[Bullet] Valor \[GreaterEqual] 0.0\\n    \
\[Bullet] Se expresa como fracci\[OAcute]n del rango de datos\\n    \[Bullet] \
Ejemplo: 0.1 extiende ejes 10% m\[AAcute]s all\[AAcute] de los \
datos\\n\\nresolution (por defecto: 50) - Resoluci\[OAcute]n para superficies \
y objetos curvos\\n    \[Bullet] Entero positivo\\n    \[Bullet] Valores t\
\[IAcute]picos: 20-100\\n    \[Bullet] Advertencia si > 200 (archivos muy \
grandes)\\n\\ntextAnnotations (por defecto: {}) - Anotaciones de texto \
adicionales\\n    \[Bullet] Formato: {{\\\"texto\\\", {x,y,z}}, {\\\"texto2\\\
\", {x2,y2,z2}, opciones}, ...}\\n    \[Bullet] Coordenadas {x,y,z} deben ser \
num\[EAcute]ricas\\n    \[Bullet] Opciones (tercer elemento, opcional): \\n   \
     - {{\\\"color\\\", \\\"red\\\"}} - Color del texto\\n        - \
{{\\\"size\\\", \\\"\\\\Large\\\"}} - Tama\[NTilde]o del texto LaTeX\\n       \
 - {{\\\"anchor\\\", \\\"center\\\"}} - Anclaje del texto\\n        - \
{{\\\"rotate\\\", \\\"45\\\"}} - Rotaci\[OAcute]n en grados\\n    \[Bullet] \
Ejemplo: {{\\\"Punto A\\\", {1,2,3}}, {\\\"Origen\\\", {0,0,0}, {{\\\"color\\\
\", \\\"red\\\"}, {\\\"size\\\", \\\"\\\\large\\\"}}}}\\n\\nmaxPolygons (por \
defecto: 500) - L\[IAcute]mite m\[AAcute]ximo de pol\[IAcute]gonos a exportar\
\\n    \[Bullet] Entero positivo\\n    \[Bullet] Previene archivos \
excesivamente grandes\\n    \[Bullet] Advertencia si > 10000 (problemas de \
rendimiento)\\n    \[Bullet] Los pol\[IAcute]gonos que excedan el \
l\[IAcute]mite se omiten\\n\\nCONFIGURACIONES FIJAS:\\n    \[Bullet] Color \
por defecto: azul (\\\"blue\\\") para elementos sin color \
espec\[IAcute]fico\\n    \[Bullet] Mapa de colores: viridis (esquema de \
colores perceptualmente uniforme)\\n\\nVALORES DE RETORNO:\\n\[Bullet] Ruta \
completa del archivo .tex generado si la exportaci\[OAcute]n es exitosa\\n\
\[Bullet] $Failed si hay errores en los argumentos\\n\\nCARACTER\
\[CapitalIAcute]STICAS ESPECIALES:\\n\\nPrimitivas 3D soportadas:\\n\[Bullet] \
Point[{x,y,z}] o Point[{{x1,y1,z1}, {x2,y2,z2}, ...}] - Puntos individuales o \
m\[UAcute]ltiples\\n\[Bullet] Line[{{x1,y1,z1}, {x2,y2,z2}, ...}] - \
L\[IAcute]neas conectadas\\n\[Bullet] Polygon[{{x1,y1,z1}, {x2,y2,z2}, ...}] \
- Pol\[IAcute]gonos cerrados\\n\[Bullet] Sphere[{x,y,z}, radio] - Esferas \
representadas como malla de l\[IAcute]neas\\n\[Bullet] Cylinder[{{x1,y1,z1}, \
{x2,y2,z2}}, radio] - Cilindros como malla\\n\[Bullet] \
Cone[{{base_x,base_y,base_z}, {apex_x,apex_y,apex_z}}, radio] - Conos como \
malla\\n\[Bullet] Cuboid[{xmin,ymin,zmin}, {xmax,ymax,zmax}] - Paralelep\
\[IAcute]pedos como esqueleto\\n\[Bullet] Ellipsoid[{x,y,z}, {a,b,c}] - \
Elipsoides como malla de l\[IAcute]neas\\n\[Bullet] Arrow[{{x1,y1,z1}, \
{x2,y2,z2}}] - Flechas 3D\\n\[Bullet] Tube[Line[puntos], radio] - Tubos \
convertidos a l\[IAcute]neas\\n\[Bullet] Text[\\\"texto\\\", {x,y,z}] - \
Etiquetas de texto\\n\[Bullet] Style[primitiva, color, PointSize[tam], \
Thickness[esp], Dashed] - Estilos aplicados\\n\\nEstilos soportados:\\n\
\[Bullet] Colores: Red, Blue, Green, Black, Orange, Gray, White, Yellow, \
Purple, Brown, Pink, Cyan, Magenta (colores de Mathematica), cadenas \
equivalentes (\\\"red\\\", \\\"blue\\\", etc.), RGBColor[r,g,b], \
GrayLevel[nivel], Hue[matiz]\\n\[Bullet] PointSize[tama\[NTilde]o] - Tama\
\[NTilde]o de puntos (Tiny, Small, Medium, Large, o valor \
num\[EAcute]rico)\\n\[Bullet] Thickness[grosor] - Grosor de l\[IAcute]neas \
(Tiny, Small, Medium, Large, Thick, o valor num\[EAcute]rico)\\n\[Bullet] \
Dashed o Dashing[patr\[OAcute]n] - L\[IAcute]neas \
discontinuas\\n\\nSalida:\\n\[Bullet] Genera archivo .tex standalone completo \
con tikz y pgfplots\\n\[Bullet] Incluye paquetes necesarios: tikz, pgfplots, \
amsmath, amssymb\\n\[Bullet] Compatible con compiladores LaTeX \
est\[AAcute]ndar\\n\[Bullet] Se guarda en \
$HomeDirectory/Downloads/[nombre_archivo]/\\n\\nEJEMPLOS DE USO:\\n\\nEjemplo \
b\[AAcute]sico (solo par\[AAcute]metros \
obligatorios):\\nExportToTikZGraphics3D[Graphics3D[{Red, Sphere[{0,0,0}, \
1]}], \\\"esfera.tex\\\"]\\n\\nCon grid \
desactivado:\\nExportToTikZGraphics3D[\\n  Graphics3D[{Blue, Sphere[{0,0,0}, \
1], Green, Line[{{-2,0,0}, {2,0,0}}]}],\\n  \\\"grafico.tex\\\",\\n  \
False\\n]\\n\\nEspecificando todos los \
par\[AAcute]metros:\\nExportToTikZGraphics3D[\\n  Graphics3D[{Blue, \
Sphere[{0,0,0}, 1], Green, Line[{{-2,0,0}, {2,0,0}}]}],\\n  \
\\\"grafico_completo.tex\\\",\\n  True,                    (* grid *)\\n  \
\\\"center\\\",              (* axisType *)\\n  0.2,                     (* \
axisExtension *)\\n  30,                      (* resolution *)\\n  \
{{\\\"Centro\\\", {0,0,0}, {{\\\"color\\\", \\\"black\\\"}}}}, (* \
textAnnotations *)\\n  1000                     (* maxPolygons *)\\n]\\n\\nM\
\[UAcute]ltiples primitivas con estilos:\\nExportToTikZGraphics3D[\\n  {\\n   \
 Style[Sphere[{0,0,0}, 1], Red],\\n    Style[Cuboid[{-2,-2,-2}, {-1,-1,-1}], \
Blue, Thickness[2]],\\n    Style[Line[{{1,1,1}, {2,2,2}}], Green, Dashed]\\n  \
},\\n  \\\"complejo.tex\\\",\\n  True,                    (* grid *)\\n  \
\\\"box\\\",                 (* axisType *)\\n  0.0,                     (* \
axisExtension *)\\n  30,                      (* resolution *)\\n  {},        \
              (* textAnnotations *)\\n  1000                     (* \
maxPolygons *)\\n]\\n\\nUso m\[IAcute]nimo con algunos \
par\[AAcute]metros:\\nExportToTikZGraphics3D[\\n  Graphics3D[Point[{{0,0,0}, \
{1,1,1}, {2,0,1}}]],\\n  \\\"puntos.tex\\\",\\n  False,                   (* \
sin grid *)\\n  \\\"none\\\"                 (* sin ejes *)\\n]\\n\\nNOTAS \
IMPORTANTES:\\n\[Bullet] Los archivos generados requieren LaTeX con tikz y \
pgfplots instalados\\n\[Bullet] Para gr\[AAcute]ficos complejos, considere \
reducir resolution y aumentar maxPolygons\\n\[Bullet] Los colores se mapean a \
los colores b\[AAcute]sicos de TikZ m\[AAcute]s cercanos\\n\[Bullet] Las \
coordenadas se formatean a 3 decimales para optimizar el archivo\\n\[Bullet] \
Se a\[NTilde]ade padding autom\[AAcute]tico del 10% alrededor de los datos\\n\
\[Bullet] El colormap viridis y el color azul por defecto est\[AAcute]n \
optimizados para publicaciones acad\[EAcute]micas\\n\[Bullet] Todos los par\
\[AAcute]metros opcionales pueden omitirse desde la derecha (ej: solo \
graphics y filename para caso m\[AAcute]s simple)\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}},
            ScrollPosition->{0., 0.}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"],
               ImageSizeCache->{20., {2.8017578125, 17.1982421875}}], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"],
               ImageSizeCache->{20., {2.8017578125, 17.1982421875}}]}, 
              Dynamic[System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          LightDarkSwitched[
           GrayLevel[0.8]], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[<|
   "ObjectType" -> "Symbol", "Usage" -> 
    "ExportToTikZGraphics3D[graphics, filename, grid, axisType, \
axisExtension, resolution, textAnnotations, maxPolygons] exporta objetos \
Graphics3D de Mathematica a c\[OAcute]digo TikZ/LaTeX para su uso en \
documentos acad\[EAcute]micos y publicaciones.\n\nPAR\[CapitalAAcute]METROS:\n\
\ngraphics - Objeto Graphics3D, lista de primitivas 3D, o primitiva \
individual v\[AAcute]lida\n    \[Bullet] Graphics3D[primitivas] - Objeto gr\
\[AAcute]fico 3D completo\n    \[Bullet] {Point[...], Line[...], \
Polygon[...]} - Lista de primitivas\n    \[Bullet] Point[{x,y,z}] - Primitiva \
individual\n    \[Bullet] Primitivas soportadas: Point, Line, Polygon, \
Sphere, Cylinder, Cone, Cuboid, Ellipsoid, Arrow, Tube, Text, Style\n\n\
filename - Cadena de texto con el nombre del archivo de salida\n    \[Bullet] \
Debe terminar en '.tex'\n    \[Bullet] No debe contener caracteres \
especiales: <, >, :, \", /, \\, |, ?, *\n    \[Bullet] Ejemplo: \
\"migrafico.tex\"\n\ngrid (por defecto: True) - Controla la visualizaci\
\[OAcute]n de la grilla\n    \[Bullet] True - Muestra grilla mayor en el gr\
\[AAcute]fico\n    \[Bullet] False - Sin grilla\n\naxisType (por defecto: \
\"box\") - Estilo de los ejes del gr\[AAcute]fico\n    \[Bullet] \"box\" - \
Ejes tipo caja (6 caras)\n    \[Bullet] \"center\" - Ejes centrados con \
flechas\n    \[Bullet] \"none\" - Sin ejes visibles\n\naxisExtension (por \
defecto: 0.0) - Extensi\[OAcute]n adicional de los ejes (solo para \
axisType=\"center\")\n    \[Bullet] Valor \[GreaterEqual] 0.0\n    \[Bullet] \
Se expresa como fracci\[OAcute]n del rango de datos\n    \[Bullet] Ejemplo: \
0.1 extiende ejes 10% m\[AAcute]s all\[AAcute] de los datos\n\nresolution \
(por defecto: 50) - Resoluci\[OAcute]n para superficies y objetos curvos\n    \
\[Bullet] Entero positivo\n    \[Bullet] Valores t\[IAcute]picos: 20-100\n    \
\[Bullet] Advertencia si > 200 (archivos muy grandes)\n\ntextAnnotations (por \
defecto: {}) - Anotaciones de texto adicionales\n    \[Bullet] Formato: \
{{\"texto\", {x,y,z}}, {\"texto2\", {x2,y2,z2}, opciones}, ...}\n    \
\[Bullet] Coordenadas {x,y,z} deben ser num\[EAcute]ricas\n    \[Bullet] \
Opciones (tercer elemento, opcional): \n        - {{\"color\", \"red\"}} - \
Color del texto\n        - {{\"size\", \"\\Large\"}} - Tama\[NTilde]o del \
texto LaTeX\n        - {{\"anchor\", \"center\"}} - Anclaje del texto\n       \
 - {{\"rotate\", \"45\"}} - Rotaci\[OAcute]n en grados\n    \[Bullet] \
Ejemplo: {{\"Punto A\", {1,2,3}}, {\"Origen\", {0,0,0}, {{\"color\", \
\"red\"}, {\"size\", \"\\large\"}}}}\n\nmaxPolygons (por defecto: 500) - L\
\[IAcute]mite m\[AAcute]ximo de pol\[IAcute]gonos a exportar\n    \[Bullet] \
Entero positivo\n    \[Bullet] Previene archivos excesivamente grandes\n    \
\[Bullet] Advertencia si > 10000 (problemas de rendimiento)\n    \[Bullet] \
Los pol\[IAcute]gonos que excedan el l\[IAcute]mite se omiten\n\n\
CONFIGURACIONES FIJAS:\n    \[Bullet] Color por defecto: azul (\"blue\") para \
elementos sin color espec\[IAcute]fico\n    \[Bullet] Mapa de colores: \
viridis (esquema de colores perceptualmente uniforme)\n\nVALORES DE RETORNO:\n\
\[Bullet] Ruta completa del archivo .tex generado si la exportaci\[OAcute]n \
es exitosa\n\[Bullet] $Failed si hay errores en los argumentos\n\nCARACTER\
\[CapitalIAcute]STICAS ESPECIALES:\n\nPrimitivas 3D soportadas:\n\[Bullet] \
Point[{x,y,z}] o Point[{{x1,y1,z1}, {x2,y2,z2}, ...}] - Puntos individuales o \
m\[UAcute]ltiples\n\[Bullet] Line[{{x1,y1,z1}, {x2,y2,z2}, ...}] - \
L\[IAcute]neas conectadas\n\[Bullet] Polygon[{{x1,y1,z1}, {x2,y2,z2}, ...}] - \
Pol\[IAcute]gonos cerrados\n\[Bullet] Sphere[{x,y,z}, radio] - Esferas \
representadas como malla de l\[IAcute]neas\n\[Bullet] Cylinder[{{x1,y1,z1}, \
{x2,y2,z2}}, radio] - Cilindros como malla\n\[Bullet] \
Cone[{{base_x,base_y,base_z}, {apex_x,apex_y,apex_z}}, radio] - Conos como \
malla\n\[Bullet] Cuboid[{xmin,ymin,zmin}, {xmax,ymax,zmax}] - Paralelep\
\[IAcute]pedos como esqueleto\n\[Bullet] Ellipsoid[{x,y,z}, {a,b,c}] - \
Elipsoides como malla de l\[IAcute]neas\n\[Bullet] Arrow[{{x1,y1,z1}, \
{x2,y2,z2}}] - Flechas 3D\n\[Bullet] Tube[Line[puntos], radio] - Tubos \
convertidos a l\[IAcute]neas\n\[Bullet] Text[\"texto\", {x,y,z}] - Etiquetas \
de texto\n\[Bullet] Style[primitiva, color, PointSize[tam], Thickness[esp], \
Dashed] - Estilos aplicados\n\nEstilos soportados:\n\[Bullet] Colores: Red, \
Blue, Green, Black, Orange, Gray, White, Yellow, Purple, Brown, Pink, Cyan, \
Magenta (colores de Mathematica), cadenas equivalentes (\"red\", \"blue\", \
etc.), RGBColor[r,g,b], GrayLevel[nivel], Hue[matiz]\n\[Bullet] \
PointSize[tama\[NTilde]o] - Tama\[NTilde]o de puntos (Tiny, Small, Medium, \
Large, o valor num\[EAcute]rico)\n\[Bullet] Thickness[grosor] - Grosor de l\
\[IAcute]neas (Tiny, Small, Medium, Large, Thick, o valor num\[EAcute]rico)\n\
\[Bullet] Dashed o Dashing[patr\[OAcute]n] - L\[IAcute]neas discontinuas\n\n\
Salida:\n\[Bullet] Genera archivo .tex standalone completo con tikz y \
pgfplots\n\[Bullet] Incluye paquetes necesarios: tikz, pgfplots, amsmath, \
amssymb\n\[Bullet] Compatible con compiladores LaTeX est\[AAcute]ndar\n\
\[Bullet] Se guarda en $HomeDirectory/Downloads/[nombre_archivo]/\n\nEJEMPLOS \
DE USO:\n\nEjemplo b\[AAcute]sico (solo par\[AAcute]metros obligatorios):\n\
ExportToTikZGraphics3D[Graphics3D[{Red, Sphere[{0,0,0}, 1]}], \"esfera.tex\"]\
\n\nCon grid desactivado:\nExportToTikZGraphics3D[\n  Graphics3D[{Blue, \
Sphere[{0,0,0}, 1], Green, Line[{{-2,0,0}, {2,0,0}}]}],\n  \"grafico.tex\",\n \
 False\n]\n\nEspecificando todos los par\[AAcute]metros:\n\
ExportToTikZGraphics3D[\n  Graphics3D[{Blue, Sphere[{0,0,0}, 1], Green, \
Line[{{-2,0,0}, {2,0,0}}]}],\n  \"grafico_completo.tex\",\n  True,            \
        (* grid *)\n  \"center\",              (* axisType *)\n  0.2,         \
            (* axisExtension *)\n  30,                      (* resolution *)\n\
  {{\"Centro\", {0,0,0}, {{\"color\", \"black\"}}}}, (* textAnnotations *)\n  \
1000                     (* maxPolygons *)\n]\n\nM\[UAcute]ltiples primitivas \
con estilos:\nExportToTikZGraphics3D[\n  {\n    Style[Sphere[{0,0,0}, 1], \
Red],\n    Style[Cuboid[{-2,-2,-2}, {-1,-1,-1}], Blue, Thickness[2]],\n    \
Style[Line[{{1,1,1}, {2,2,2}}], Green, Dashed]\n  },\n  \"complejo.tex\",\n  \
True,                    (* grid *)\n  \"box\",                 (* axisType \
*)\n  0.0,                     (* axisExtension *)\n  30,                     \
 (* resolution *)\n  {},                      (* textAnnotations *)\n  1000   \
                  (* maxPolygons *)\n]\n\nUso m\[IAcute]nimo con algunos par\
\[AAcute]metros:\nExportToTikZGraphics3D[\n  Graphics3D[Point[{{0,0,0}, \
{1,1,1}, {2,0,1}}]],\n  \"puntos.tex\",\n  False,                   (* sin \
grid *)\n  \"none\"                 (* sin ejes *)\n]\n\nNOTAS IMPORTANTES:\n\
\[Bullet] Los archivos generados requieren LaTeX con tikz y pgfplots \
instalados\n\[Bullet] Para gr\[AAcute]ficos complejos, considere reducir \
resolution y aumentar maxPolygons\n\[Bullet] Los colores se mapean a los \
colores b\[AAcute]sicos de TikZ m\[AAcute]s cercanos\n\[Bullet] Las \
coordenadas se formatean a 3 decimales para optimizar el archivo\n\[Bullet] \
Se a\[NTilde]ade padding autom\[AAcute]tico del 10% alrededor de los datos\n\
\[Bullet] El colormap viridis y el color azul por defecto est\[AAcute]n \
optimizados para publicaciones acad\[EAcute]micas\n\[Bullet] Todos los par\
\[AAcute]metros opcionales pueden omitirse desde la derecha (ej: solo \
graphics y filename para caso m\[AAcute]s simple)", "Documentation" -> None, 
    "OwnValues" -> None, "UpValues" -> None, "DownValues" -> 
    Information`InformationValueForm[
     DownValues, VilTeX`ExportToTikZGraphics3D, {VilTeX`ExportToTikZGraphics3D[
         Pattern[VilTeX`Private`graphics3DArgs, 
          Blank[]], 
         Pattern[VilTeX`Private`filename, 
          Blank[]], 
         Optional[
          Pattern[VilTeX`Private`grid, 
           Blank[]], True], 
         Optional[
          Pattern[VilTeX`Private`axisType, 
           Blank[]], "box"], 
         Optional[
          Pattern[VilTeX`Private`axisExtension, 
           Blank[]], 0.], 
         Optional[
          Pattern[VilTeX`Private`resolution, 
           Blank[]], 50], 
         Optional[
          Pattern[VilTeX`Private`textAnnotations, 
           Blank[]], {}], 
         Optional[
          Pattern[VilTeX`Private`maxPolygons, 
           Blank[]], 500]] :> 
       Module[{VilTeX`Private`tikzCode, VilTeX`Private`fullDocument, 
          VilTeX`Private`downloadPath, VilTeX`Private`folderName, 
          VilTeX`Private`folderPath, VilTeX`Private`formatNumber, 
          VilTeX`Private`validNumber, VilTeX`Private`allPrimitives, 
          VilTeX`Private`globalLimits, VilTeX`Private`allValidData, 
          VilTeX`Private`combinedTikzCode, VilTeX`Private`textTikzCode, 
          VilTeX`Private`axisConfiguration, VilTeX`Private`colormapStyle, 
          VilTeX`Private`opacityStyle, VilTeX`Private`flatElements, 
          VilTeX`Private`polygonCount = 0, VilTeX`Private`validColormaps, 
          VilTeX`Private`errors = {}, VilTeX`Private`validateColor, 
          VilTeX`Private`validateGraphics3D, 
          VilTeX`Private`validateTextAnnotations}, 
         Clear[VilTeX`Private`pointSizeToNumber, 
           VilTeX`Private`thicknessToNumber, VilTeX`Private`colorToTikZ, 
           VilTeX`Private`detectBasicColor, VilTeX`Private`coneToLines, 
           VilTeX`Private`ellipsoidToLines, VilTeX`Private`sphereToLines, 
           VilTeX`Private`cylinderToLines, VilTeX`Private`cuboidToLines, 
           VilTeX`Private`polygonToLines, VilTeX`Private`flattenElements, 
           VilTeX`Private`addValidCoords]; VilTeX`Private`validateColor[
            Pattern[VilTeX`Private`color, 
             Blank[]]] := 
          Module[{VilTeX`Private`validNamedColors, VilTeX`Private`validColor},
             VilTeX`Private`validNamedColors = {
              Red, Blue, Green, Black, Orange, Gray, White, Yellow, Purple, 
               Brown, Pink, Cyan, Magenta}; 
            VilTeX`Private`validColor = Which[
               MemberQ[VilTeX`Private`validNamedColors, VilTeX`Private`color],
                True, 
               And[
                StringQ[VilTeX`Private`color], 
                
                MemberQ[{
                 "red", "blue", "green", "black", "orange", "gray", "white", 
                  "yellow", "purple", "brown", "pink", "cyan", "magenta"}, 
                 ToLowerCase[VilTeX`Private`color]]], True, 
               And[
               Head[VilTeX`Private`color] === RGBColor, 
                Length[VilTeX`Private`color] >= 3, 
                AllTrue[
                 Take[VilTeX`Private`color, 3], NumericQ], 
                AllTrue[
                 Take[VilTeX`Private`color, 3], 0 <= # <= 1& ]], True, 
               And[
               Head[VilTeX`Private`color] === GrayLevel, 
                Length[VilTeX`Private`color] == 1, 
                NumericQ[
                 Part[VilTeX`Private`color, 1]], 0 <= 
                Part[VilTeX`Private`color, 1] <= 1], True, 
               And[
               Head[VilTeX`Private`color] === Hue, 
                Length[VilTeX`Private`color] >= 1, 
                NumericQ[
                 Part[VilTeX`Private`color, 1]]], True, True, False]; 
            VilTeX`Private`validColor]; VilTeX`Private`validateGraphics3D[
            Pattern[VilTeX`Private`graphics, 
             Blank[]]] := 
          Module[{VilTeX`Private`valid3DPrimitives, VilTeX`Private`isValid}, 
            VilTeX`Private`valid3DPrimitives = {
              Point, Line, Polygon, Sphere, Cylinder, Cone, Cuboid, Ellipsoid,
                Arrow, Tube, Text, Style}; 
            VilTeX`Private`isValid = 
             Which[Head[VilTeX`Private`graphics] === Graphics3D, True, 
               ListQ[VilTeX`Private`graphics], 
               AllTrue[
                Flatten[VilTeX`Private`graphics], Or[Head[#] === Style, 
                 MemberQ[VilTeX`Private`valid3DPrimitives, 
                  Head[#]], 
                 
                 MemberQ[{
                  Red, Blue, Green, Black, Orange, Gray, White, Yellow, 
                   Purple, Brown, Pink, Cyan, Magenta}, #], Head[#] === 
                 RGBColor, Head[#] === GrayLevel, Head[#] === Hue, Head[#] === 
                 PointSize, Head[#] === Thickness, # === Dashed, Head[#] === 
                 Dashing]& ], 
               MemberQ[VilTeX`Private`valid3DPrimitives, 
                Head[VilTeX`Private`graphics]], True, True, False]; 
            VilTeX`Private`isValid]; VilTeX`Private`validateTextAnnotations[
            Pattern[VilTeX`Private`annotations, 
             Blank[]]] := 
          Module[{VilTeX`Private`isValid}, 
            VilTeX`Private`isValid = 
             Which[VilTeX`Private`annotations === {}, True, 
               Not[
                ListQ[VilTeX`Private`annotations]], False, True, 
               AllTrue[VilTeX`Private`annotations, And[
                 ListQ[#], Length[#] >= 2, 
                 StringQ[
                  Part[#, 1]], 
                 ListQ[
                  Part[#, 2]], Length[
                   Part[#, 2]] == 3, 
                 AllTrue[
                  Part[#, 2], NumericQ], 
                 Or[Length[#] <= 2, 
                  And[Length[#] == 3, 
                   ListQ[
                    Part[#, 3]]]]]& ]]; VilTeX`Private`isValid]; If[
           Not[
            VilTeX`Private`validateGraphics3D[VilTeX`Private`graphics3DArgs]],
            AppendTo[
            VilTeX`Private`errors, 
             "Error: graphics3DArgs debe ser un objeto Graphics3D o una lista \
de primitivas 3D v\[AAcute]lidas"]; Null]; If[
           Not[
            StringQ[VilTeX`Private`filename]], 
           AppendTo[
            VilTeX`Private`errors, 
             "Error: filename debe ser una cadena de texto"]; Null]; If[
           And[
            StringQ[VilTeX`Private`filename], 
            Not[
             StringEndsQ[VilTeX`Private`filename, ".tex"]]], 
           AppendTo[
            VilTeX`Private`errors, 
             "Error: filename debe terminar con la extensi\[OAcute]n '.tex'"]; 
           Null]; If[
           And[
            StringQ[VilTeX`Private`filename], 
            StringContainsQ[VilTeX`Private`filename, 
             RegularExpression["[<>:\"/\\\\|?*]"]]], 
           AppendTo[
            VilTeX`Private`errors, 
             "Error: filename contiene caracteres no v\[AAcute]lidos para \
nombres de archivo"]; Null]; If[
           Not[
            BooleanQ[VilTeX`Private`grid]], 
           AppendTo[
            VilTeX`Private`errors, "Error: grid debe ser True o False"]; 
           Null]; If[
           Not[
            MemberQ[{"box", "center", "none"}, VilTeX`Private`axisType]], 
           AppendTo[
            VilTeX`Private`errors, 
             "Error: axisType debe ser \"box\", \"center\" o \"none\""]; 
           Null]; If[
           Not[
            NumericQ[VilTeX`Private`axisExtension]], 
           AppendTo[
            VilTeX`Private`errors, 
             "Error: axisExtension debe ser un n\[UAcute]mero"]; Null]; If[
           And[
            NumericQ[VilTeX`Private`axisExtension], 
            VilTeX`Private`axisExtension < 0], 
           AppendTo[
            VilTeX`Private`errors, 
             "Error: axisExtension debe ser mayor o igual a 0"]; Null]; If[
           Not[
            IntegerQ[VilTeX`Private`resolution]], 
           AppendTo[
            VilTeX`Private`errors, 
             "Error: resolution debe ser un n\[UAcute]mero entero"]; Null]; If[
           And[
            IntegerQ[VilTeX`Private`resolution], VilTeX`Private`resolution <= 
            0], AppendTo[
            VilTeX`Private`errors, "Error: resolution debe ser mayor que 0"]; 
           Null]; If[
           And[
            IntegerQ[VilTeX`Private`resolution], VilTeX`Private`resolution > 
            200], AppendTo[
            VilTeX`Private`errors, 
             "Error: resolution muy alto (>200) puede generar archivos muy \
grandes"]; Null]; If[
           Not[
            VilTeX`Private`validateTextAnnotations[
            VilTeX`Private`textAnnotations]], 
           AppendTo[
            VilTeX`Private`errors, 
             "Error: textAnnotations debe ser una lista con formato: \
{{\"texto\", {x,y,z}}, ...}"]; Null]; If[
           Not[
            IntegerQ[VilTeX`Private`maxPolygons]], 
           AppendTo[
            VilTeX`Private`errors, 
             "Error: maxPolygons debe ser un n\[UAcute]mero entero"]; Null]; 
         If[
           And[
            IntegerQ[VilTeX`Private`maxPolygons], VilTeX`Private`maxPolygons <= 
            0], AppendTo[
            VilTeX`Private`errors, "Error: maxPolygons debe ser mayor que 0"]; 
           Null]; If[
           And[
            IntegerQ[VilTeX`Private`maxPolygons], VilTeX`Private`maxPolygons > 
            10000], AppendTo[
            VilTeX`Private`errors, 
             "Error: maxPolygons muy alto (>10000) puede causar problemas de \
rendimiento"]; Null]; If[Length[VilTeX`Private`errors] > 0, Do[
             Print["  " <> Part[VilTeX`Private`errors, VilTeX`Private`i]], {
             VilTeX`Private`i, 
              Length[VilTeX`Private`errors]}]; If[Length[
               Select[VilTeX`Private`errors, StringStartsQ[#, "Error:"]& ]] > 
             0, Return[$Failed]; Null]; Null]; If[
           Not[
            StringQ[VilTeX`Private`filename]], Return[$Failed]; Null]; If[
           Not[
            StringEndsQ[VilTeX`Private`filename, ".tex"]], Return[$Failed]; 
           Null]; VilTeX`Private`axisConfiguration = 
          Which[VilTeX`Private`axisType == "box", "axis lines=box", 
            VilTeX`Private`axisType == "center", 
            "axis lines=center, axis line style={->}", 
            VilTeX`Private`axisType == "none", "axis lines=none", True, 
            "axis lines=box"]; 
         VilTeX`Private`colormapStyle = "colormap/viridis"; 
         VilTeX`Private`formatNumber[
            Pattern[VilTeX`Private`x, 
             Blank[]]] := Module[{VilTeX`Private`num = N[VilTeX`Private`x]}, 
            If[
             NumericQ[VilTeX`Private`num], 
             If[Abs[VilTeX`Private`num] < 0.001, "0.000", 
              ToString[
               Round[VilTeX`Private`num, 0.001], FortranForm]], "0.000"]]; 
         VilTeX`Private`pointSizeToNumber[
            Pattern[VilTeX`Private`size, 
             Blank[]]] := 
          Which[VilTeX`Private`size === Tiny, 0.5, VilTeX`Private`size === 
            Small, 1., VilTeX`Private`size === Medium, 1.5, 
            VilTeX`Private`size === Large, 2.5, 
            NumericQ[VilTeX`Private`size], N[VilTeX`Private`size] 50, True, 
            1.]; VilTeX`Private`thicknessToNumber[
            Pattern[VilTeX`Private`thickness, 
             Blank[]]] := 
          Which[VilTeX`Private`thickness === Tiny, 0.5, 
            VilTeX`Private`thickness === Small, 1., VilTeX`Private`thickness === 
            Medium, 1.5, VilTeX`Private`thickness === Large, 3., 
            VilTeX`Private`thickness === Thick, 2., 
            NumericQ[VilTeX`Private`thickness], N[VilTeX`Private`thickness] 
            10, True, 1.]; VilTeX`Private`colorToTikZ[
            Pattern[VilTeX`Private`color, 
             Blank[]]] := 
          Which[VilTeX`Private`color === Red, "red", VilTeX`Private`color === 
            Blue, "blue", VilTeX`Private`color === Green, "green", 
            VilTeX`Private`color === Black, "black", VilTeX`Private`color === 
            White, "white", VilTeX`Private`color === Yellow, "yellow", 
            VilTeX`Private`color === Orange, "orange", VilTeX`Private`color === 
            Purple, "purple", VilTeX`Private`color === Brown, "brown", 
            VilTeX`Private`color === Pink, "pink", VilTeX`Private`color === 
            Gray, "gray", VilTeX`Private`color === Cyan, "cyan", 
            VilTeX`Private`color === Magenta, "magenta", 
            And[
            Head[VilTeX`Private`color] === RGBColor, 
             Length[VilTeX`Private`color] >= 3], 
            
            Module[{VilTeX`Private`r, VilTeX`Private`g, 
              VilTeX`Private`b}, {
               VilTeX`Private`r, VilTeX`Private`g, VilTeX`Private`b} = N[{
                 Part[VilTeX`Private`color, 1], 
                 Part[VilTeX`Private`color, 2], 
                 Part[VilTeX`Private`color, 3]}]; Which[
               And[
               VilTeX`Private`r > 0.8, VilTeX`Private`g < 0.3, 
                VilTeX`Private`b < 0.3], "red", 
               And[
               VilTeX`Private`r < 0.3, VilTeX`Private`g < 0.3, 
                VilTeX`Private`b > 0.8], "blue", 
               And[
               VilTeX`Private`r < 0.3, VilTeX`Private`g > 0.8, 
                VilTeX`Private`b < 0.3], "green", 
               And[
               VilTeX`Private`r < 0.2, VilTeX`Private`g < 0.2, 
                VilTeX`Private`b < 0.2], "black", 
               And[
               VilTeX`Private`r > 0.9, VilTeX`Private`g > 0.9, 
                VilTeX`Private`b > 0.9], "white", 
               And[
               VilTeX`Private`r > 0.8, VilTeX`Private`g > 0.8, 
                VilTeX`Private`b < 0.3], "yellow", 
               And[
               VilTeX`Private`r > 0.8, VilTeX`Private`g > 0.4, 
                VilTeX`Private`b < 0.3], "orange", 
               And[
               VilTeX`Private`r > 0.5, VilTeX`Private`g < 0.3, 
                VilTeX`Private`b > 0.5], "purple", 
               And[
               VilTeX`Private`r > 0.4, VilTeX`Private`r < 0.7, 
                VilTeX`Private`g < 0.3, VilTeX`Private`b < 0.3], "brown", 
               And[
               VilTeX`Private`r > 0.8, VilTeX`Private`g > 0.6, 
                VilTeX`Private`b > 0.6], "pink", 
               And[
               VilTeX`Private`r < 0.3, VilTeX`Private`g > 0.8, 
                VilTeX`Private`b > 0.8], "cyan", 
               And[
               VilTeX`Private`r > 0.8, VilTeX`Private`g < 0.3, 
                VilTeX`Private`b > 0.8], "magenta", 
               And[
               VilTeX`Private`r > 0.4, VilTeX`Private`g > 0.4, 
                VilTeX`Private`b > 0.4], "gray", True, "black"]], 
            Head[VilTeX`Private`color] === Hue, 
            
            Module[{VilTeX`Private`rgb = 
              ColorConvert[VilTeX`Private`color, "RGB"], VilTeX`Private`r, 
              VilTeX`Private`g, 
              VilTeX`Private`b}, {
               VilTeX`Private`r, VilTeX`Private`g, VilTeX`Private`b} = N[{
                 Part[VilTeX`Private`rgb, 1], 
                 Part[VilTeX`Private`rgb, 2], 
                 Part[VilTeX`Private`rgb, 3]}]; Which[
               And[
               VilTeX`Private`r > 0.8, VilTeX`Private`g < 0.3, 
                VilTeX`Private`b < 0.3], "red", 
               And[
               VilTeX`Private`r < 0.3, VilTeX`Private`g < 0.3, 
                VilTeX`Private`b > 0.8], "blue", 
               And[
               VilTeX`Private`r < 0.3, VilTeX`Private`g > 0.8, 
                VilTeX`Private`b < 0.3], "green", 
               And[
               VilTeX`Private`r > 0.8, VilTeX`Private`g > 0.8, 
                VilTeX`Private`b < 0.3], "yellow", 
               And[
               VilTeX`Private`r > 0.8, VilTeX`Private`g > 0.4, 
                VilTeX`Private`b < 0.3], "orange", 
               And[
               VilTeX`Private`r > 0.5, VilTeX`Private`g < 0.3, 
                VilTeX`Private`b > 0.5], "purple", True, "black"]], True, 
            "blue"]; VilTeX`Private`detectBasicColor[
            Pattern[VilTeX`Private`color, 
             Blank[]]] := 
          Which[VilTeX`Private`color === Red, "red", VilTeX`Private`color === 
            Blue, "blue", VilTeX`Private`color === Green, "green", 
            VilTeX`Private`color === Black, "black", VilTeX`Private`color === 
            Orange, "orange", VilTeX`Private`color === Gray, "gray", 
            VilTeX`Private`color === White, "white", VilTeX`Private`color === 
            Yellow, "yellow", VilTeX`Private`color === Purple, "purple", 
            VilTeX`Private`color === Brown, "brown", VilTeX`Private`color === 
            Pink, "pink", VilTeX`Private`color === Cyan, "cyan", 
            VilTeX`Private`color === Magenta, "magenta", 
            And[
            Head[VilTeX`Private`color] === RGBColor, 
             Length[VilTeX`Private`color] >= 3], 
            Which[N[VilTeX`Private`color] == N[
               RGBColor[1, 0, 0]], "red", N[VilTeX`Private`color] == N[
               RGBColor[0, 0, 1]], "blue", 
             Or[N[VilTeX`Private`color] == N[
                RGBColor[0, 1, 0]], N[VilTeX`Private`color] == N[
                RGBColor[0, 0.5019607843137255, 0]]], "green", 
             N[VilTeX`Private`color] == N[
               RGBColor[0, 0, 0]], "black", N[VilTeX`Private`color] == N[
               RGBColor[1, 0.5, 0]], "orange", N[VilTeX`Private`color] == N[
               RGBColor[0.5, 0.5, 0.5]], "gray", N[VilTeX`Private`color] == 
             N[
               RGBColor[1, 1, 1]], "white", N[VilTeX`Private`color] == N[
               RGBColor[1, 1, 0]], "yellow", N[VilTeX`Private`color] == N[
               RGBColor[0.5, 0, 0.5]], "purple", N[VilTeX`Private`color] == 
             N[
               RGBColor[
               0.6470588235294118, 0.16470588235294117`, 
                0.16470588235294117`]], "brown", N[VilTeX`Private`color] == 
             N[
               RGBColor[1, 0.7529411764705882, 0.796078431372549]], "pink", 
             N[VilTeX`Private`color] == N[
               RGBColor[0, 1, 1]], "cyan", N[VilTeX`Private`color] == N[
               RGBColor[1, 0, 1]], "magenta", True, 
             VilTeX`Private`colorToTikZ[VilTeX`Private`color]], 
            Head[VilTeX`Private`color] === GrayLevel, 
            Which[N[
               Part[VilTeX`Private`color, 1]] == 0, "black", N[
               Part[VilTeX`Private`color, 1]] == 0.5, "gray", N[
               Part[VilTeX`Private`color, 1]] == 1, "white", True, "gray"], 
            Head[VilTeX`Private`color] === Hue, 
            VilTeX`Private`colorToTikZ[VilTeX`Private`color], True, "black"]; 
         VilTeX`Private`coneToLines[
            Pattern[VilTeX`Private`apex, 
             Blank[]], 
            Pattern[VilTeX`Private`base, 
             Blank[]], 
            Pattern[VilTeX`Private`radius, 
             Blank[]]] := 
          Module[{VilTeX`Private`lines = {}, VilTeX`Private`theta, 
             VilTeX`Private`nLines = 12, VilTeX`Private`baseCenter}, 
            VilTeX`Private`baseCenter = VilTeX`Private`base; 
            VilTeX`Private`lines = Append[VilTeX`Private`lines, 
               Line[
                Table[
                VilTeX`Private`baseCenter + {
                  VilTeX`Private`radius Cos[VilTeX`Private`theta], 
                   VilTeX`Private`radius Sin[VilTeX`Private`theta], 0}, {
                 VilTeX`Private`theta, 0, 2 Pi, 2 (Pi/20)}]]]; 
            Do[VilTeX`Private`lines = Append[VilTeX`Private`lines, 
                
                Line[{VilTeX`Private`apex, 
                  VilTeX`Private`baseCenter + {
                   VilTeX`Private`radius Cos[VilTeX`Private`theta], 
                    VilTeX`Private`radius Sin[VilTeX`Private`theta], 0}}]], {
              VilTeX`Private`theta, 0, 2 Pi - Pi/6, 
               2 (Pi/VilTeX`Private`nLines)}]; VilTeX`Private`lines]; 
         VilTeX`Private`ellipsoidToLines[
            Pattern[VilTeX`Private`center, 
             Blank[]], 
            Pattern[VilTeX`Private`semiAxes, 
             Blank[]], 
            Pattern[VilTeX`Private`ellipsoidRes, 
             Blank[]]] := 
          Module[{VilTeX`Private`lines = {}, VilTeX`Private`phi, 
             VilTeX`Private`theta, VilTeX`Private`a, VilTeX`Private`b, 
             VilTeX`Private`c, VilTeX`Private`nMeridians = 8, 
             VilTeX`Private`nParallels = 
             6}, {VilTeX`Private`a, VilTeX`Private`b, VilTeX`Private`c} = 
             VilTeX`Private`semiAxes; 
            Do[VilTeX`Private`lines = Append[VilTeX`Private`lines, 
                Line[
                 Table[
                 VilTeX`Private`center + {
                   VilTeX`Private`a Sin[VilTeX`Private`phi] 
                    Cos[VilTeX`Private`theta], VilTeX`Private`b 
                    Sin[VilTeX`Private`phi] Sin[VilTeX`Private`theta], 
                    VilTeX`Private`c Cos[VilTeX`Private`phi]}, {
                  VilTeX`Private`phi, 0, Pi, Pi/
                   VilTeX`Private`ellipsoidRes}]]], {
              VilTeX`Private`theta, 0, 2 Pi - Pi/VilTeX`Private`nMeridians, 
               2 (Pi/VilTeX`Private`nMeridians)}]; 
            Do[VilTeX`Private`lines = Append[VilTeX`Private`lines, 
                Line[
                 Table[
                 VilTeX`Private`center + {
                   VilTeX`Private`a Sin[VilTeX`Private`phi] 
                    Cos[VilTeX`Private`theta], VilTeX`Private`b 
                    Sin[VilTeX`Private`phi] Sin[VilTeX`Private`theta], 
                    VilTeX`Private`c Cos[VilTeX`Private`phi]}, {
                  VilTeX`Private`theta, 0, 2 Pi, 
                   2 (Pi/VilTeX`Private`ellipsoidRes)}]]], {
              VilTeX`Private`phi, Pi/VilTeX`Private`nParallels, Pi - Pi/
               VilTeX`Private`nParallels, Pi/VilTeX`Private`nParallels}]; 
            VilTeX`Private`lines]; VilTeX`Private`sphereToLines[
            Pattern[VilTeX`Private`center, 
             Blank[]], 
            Pattern[VilTeX`Private`radius, 
             Blank[]], 
            Pattern[VilTeX`Private`sphereRes, 
             Blank[]]] := 
          Module[{VilTeX`Private`lines = {}, VilTeX`Private`phi, 
             VilTeX`Private`theta, VilTeX`Private`nMeridians = 8, 
             VilTeX`Private`nParallels = 6}, 
            Do[VilTeX`Private`lines = Append[VilTeX`Private`lines, 
                Line[
                 Table[
                 VilTeX`Private`center + 
                  VilTeX`Private`radius {
                    Sin[VilTeX`Private`phi] Cos[VilTeX`Private`theta], 
                    Sin[VilTeX`Private`phi] Sin[VilTeX`Private`theta], 
                    Cos[VilTeX`Private`phi]}, {
                  VilTeX`Private`phi, 0, Pi, Pi/
                   VilTeX`Private`sphereRes}]]], {
              VilTeX`Private`theta, 0, 2 Pi - Pi/VilTeX`Private`nMeridians, 
               2 (Pi/VilTeX`Private`nMeridians)}]; 
            Do[VilTeX`Private`lines = Append[VilTeX`Private`lines, 
                Line[
                 Table[
                 VilTeX`Private`center + 
                  VilTeX`Private`radius {
                    Sin[VilTeX`Private`phi] Cos[VilTeX`Private`theta], 
                    Sin[VilTeX`Private`phi] Sin[VilTeX`Private`theta], 
                    Cos[VilTeX`Private`phi]}, {
                  VilTeX`Private`theta, 0, 2 Pi, 
                   2 (Pi/VilTeX`Private`sphereRes)}]]], {
              VilTeX`Private`phi, Pi/VilTeX`Private`nParallels, Pi - Pi/
               VilTeX`Private`nParallels, Pi/VilTeX`Private`nParallels}]; 
            VilTeX`Private`lines]; VilTeX`Private`cylinderToLines[
            Pattern[VilTeX`Private`center, 
             Blank[]], 
            Pattern[VilTeX`Private`radius, 
             Blank[]], 
            Pattern[VilTeX`Private`height, 
             Blank[]], 
            Optional[
             Pattern[VilTeX`Private`axis, 
              Blank[]], {0, 0, 1}]] := 
          Module[{VilTeX`Private`lines = {}, VilTeX`Private`theta, 
             VilTeX`Private`nLines = 12}, 
            VilTeX`Private`lines = Append[VilTeX`Private`lines, 
               Line[
                Table[
                VilTeX`Private`center + {
                  VilTeX`Private`radius Cos[VilTeX`Private`theta], 
                   VilTeX`Private`radius Sin[VilTeX`Private`theta], 0}, {
                 VilTeX`Private`theta, 0, 2 Pi, 2 (Pi/20)}]]]; 
            VilTeX`Private`lines = Append[VilTeX`Private`lines, 
               Line[
                Table[
                VilTeX`Private`center + {
                  VilTeX`Private`radius Cos[VilTeX`Private`theta], 
                   VilTeX`Private`radius Sin[VilTeX`Private`theta], 
                   VilTeX`Private`height}, {
                 VilTeX`Private`theta, 0, 2 Pi, 2 (Pi/20)}]]]; 
            Do[VilTeX`Private`lines = Append[VilTeX`Private`lines, 
                
                Line[{VilTeX`Private`center + {
                   VilTeX`Private`radius Cos[VilTeX`Private`theta], 
                    VilTeX`Private`radius Sin[VilTeX`Private`theta], 0}, 
                  VilTeX`Private`center + {
                   VilTeX`Private`radius Cos[VilTeX`Private`theta], 
                    VilTeX`Private`radius Sin[VilTeX`Private`theta], 
                    VilTeX`Private`height}}]], {
              VilTeX`Private`theta, 0, 2 Pi - Pi/6, 
               2 (Pi/VilTeX`Private`nLines)}]; VilTeX`Private`lines]; 
         VilTeX`Private`cuboidToLines[{
             Pattern[VilTeX`Private`xmin, 
              Blank[]], 
             Pattern[VilTeX`Private`ymin, 
              Blank[]], 
             Pattern[VilTeX`Private`zmin, 
              Blank[]]}, {
             Pattern[VilTeX`Private`xmax, 
              Blank[]], 
             Pattern[VilTeX`Private`ymax, 
              Blank[]], 
             Pattern[VilTeX`Private`zmax, 
              Blank[]]}] := 
          Module[{VilTeX`Private`lines = {}}, 
            VilTeX`Private`lines = Append[VilTeX`Private`lines, 
               
               Line[{{VilTeX`Private`xmin, VilTeX`Private`ymin, 
                  VilTeX`Private`zmin}, {
                 VilTeX`Private`xmax, VilTeX`Private`ymin, 
                  VilTeX`Private`zmin}}]]; 
            VilTeX`Private`lines = Append[VilTeX`Private`lines, 
               
               Line[{{VilTeX`Private`xmax, VilTeX`Private`ymin, 
                  VilTeX`Private`zmin}, {
                 VilTeX`Private`xmax, VilTeX`Private`ymax, 
                  VilTeX`Private`zmin}}]]; 
            VilTeX`Private`lines = Append[VilTeX`Private`lines, 
               
               Line[{{VilTeX`Private`xmax, VilTeX`Private`ymax, 
                  VilTeX`Private`zmin}, {
                 VilTeX`Private`xmin, VilTeX`Private`ymax, 
                  VilTeX`Private`zmin}}]]; 
            VilTeX`Private`lines = Append[VilTeX`Private`lines, 
               
               Line[{{VilTeX`Private`xmin, VilTeX`Private`ymax, 
                  VilTeX`Private`zmin}, {
                 VilTeX`Private`xmin, VilTeX`Private`ymin, 
                  VilTeX`Private`zmin}}]]; 
            VilTeX`Private`lines = Append[VilTeX`Private`lines, 
               
               Line[{{VilTeX`Private`xmin, VilTeX`Private`ymin, 
                  VilTeX`Private`zmax}, {
                 VilTeX`Private`xmax, VilTeX`Private`ymin, 
                  VilTeX`Private`zmax}}]]; 
            VilTeX`Private`lines = Append[VilTeX`Private`lines, 
               
               Line[{{VilTeX`Private`xmax, VilTeX`Private`ymin, 
                  VilTeX`Private`zmax}, {
                 VilTeX`Private`xmax, VilTeX`Private`ymax, 
                  VilTeX`Private`zmax}}]]; 
            VilTeX`Private`lines = Append[VilTeX`Private`lines, 
               
               Line[{{VilTeX`Private`xmax, VilTeX`Private`ymax, 
                  VilTeX`Private`zmax}, {
                 VilTeX`Private`xmin, VilTeX`Private`ymax, 
                  VilTeX`Private`zmax}}]]; 
            VilTeX`Private`lines = Append[VilTeX`Private`lines, 
               
               Line[{{VilTeX`Private`xmin, VilTeX`Private`ymax, 
                  VilTeX`Private`zmax}, {
                 VilTeX`Private`xmin, VilTeX`Private`ymin, 
                  VilTeX`Private`zmax}}]]; 
            VilTeX`Private`lines = Append[VilTeX`Private`lines, 
               
               Line[{{VilTeX`Private`xmin, VilTeX`Private`ymin, 
                  VilTeX`Private`zmin}, {
                 VilTeX`Private`xmin, VilTeX`Private`ymin, 
                  VilTeX`Private`zmax}}]]; 
            VilTeX`Private`lines = Append[VilTeX`Private`lines, 
               
               Line[{{VilTeX`Private`xmax, VilTeX`Private`ymin, 
                  VilTeX`Private`zmin}, {
                 VilTeX`Private`xmax, VilTeX`Private`ymin, 
                  VilTeX`Private`zmax}}]]; 
            VilTeX`Private`lines = Append[VilTeX`Private`lines, 
               
               Line[{{VilTeX`Private`xmax, VilTeX`Private`ymax, 
                  VilTeX`Private`zmin}, {
                 VilTeX`Private`xmax, VilTeX`Private`ymax, 
                  VilTeX`Private`zmax}}]]; 
            VilTeX`Private`lines = Append[VilTeX`Private`lines, 
               
               Line[{{VilTeX`Private`xmin, VilTeX`Private`ymax, 
                  VilTeX`Private`zmin}, {
                 VilTeX`Private`xmin, VilTeX`Private`ymax, 
                  VilTeX`Private`zmax}}]]; VilTeX`Private`lines]; 
         VilTeX`Private`polygonToLines[
            Pattern[VilTeX`Private`vertices, 
             Blank[]]] := 
          Module[{VilTeX`Private`lines = {}, 
             VilTeX`Private`simplifiedVertices, 
             VilTeX`Private`closedVertices}, 
            If[Length[VilTeX`Private`vertices] >= 3, 
              VilTeX`Private`simplifiedVertices = 
               If[Length[VilTeX`Private`vertices] > 12, 
                 
                 Module[{
                  VilTeX`Private`step = 
                   Ceiling[Length[VilTeX`Private`vertices]/8], 
                   VilTeX`Private`selected}, 
                  VilTeX`Private`selected = Part[VilTeX`Private`vertices, 
                    Span[1, 
                    Length[VilTeX`Private`vertices], VilTeX`Private`step]]; 
                  VilTeX`Private`selected], VilTeX`Private`vertices]; 
              VilTeX`Private`closedVertices = If[
                 And[
                 Length[VilTeX`Private`simplifiedVertices] >= 3, 
                  Part[VilTeX`Private`simplifiedVertices, -1] != 
                  Part[VilTeX`Private`simplifiedVertices, 1]], 
                 Append[VilTeX`Private`simplifiedVertices, 
                  Part[VilTeX`Private`simplifiedVertices, 1]], 
                 VilTeX`Private`simplifiedVertices]; VilTeX`Private`lines = {
                 Line[VilTeX`Private`closedVertices]}; Null]; 
            VilTeX`Private`lines]; VilTeX`Private`flattenElements[
            Pattern[VilTeX`Private`elementList, 
             Blank[]]] := Module[{VilTeX`Private`flattened = {}}, Do[
              
              Module[{VilTeX`Private`element = 
                Part[VilTeX`Private`elementList, VilTeX`Private`i]}, 
               Which[
               Head[VilTeX`Private`element] === Style, 
                VilTeX`Private`flattened = 
                Append[VilTeX`Private`flattened, VilTeX`Private`element], 
                ListQ[VilTeX`Private`element], VilTeX`Private`flattened = 
                Join[VilTeX`Private`flattened, 
                  VilTeX`Private`flattenElements[VilTeX`Private`element]], 
                True, VilTeX`Private`flattened = 
                Append[VilTeX`Private`flattened, VilTeX`Private`element]]], {
              VilTeX`Private`i, 
               Length[VilTeX`Private`elementList]}]; 
            VilTeX`Private`flattened]; 
         VilTeX`Private`allPrimitives = 
          If[Head[VilTeX`Private`graphics3DArgs] === Graphics3D, 
            Part[VilTeX`Private`graphics3DArgs, 1], {
            VilTeX`Private`graphics3DArgs}]; 
         VilTeX`Private`flatElements = 
          VilTeX`Private`flattenElements[VilTeX`Private`allPrimitives]; 
         VilTeX`Private`allValidData = {}; 
         VilTeX`Private`combinedTikzCode = ""; 
         VilTeX`Private`textTikzCode = ""; VilTeX`Private`addValidCoords[
            Pattern[VilTeX`Private`coords, 
             Blank[]]] := If[
            And[
             ListQ[VilTeX`Private`coords], Length[VilTeX`Private`coords] > 0], 
            If[
             And[Length[VilTeX`Private`coords] > 0, 
              ListQ[
               Part[VilTeX`Private`coords, 1]], Length[
                Part[VilTeX`Private`coords, 1]] == 3], 
             Do[
              If[
               And[
                ListQ[
                 Part[VilTeX`Private`coords, VilTeX`Private`i]], Length[
                  Part[VilTeX`Private`coords, VilTeX`Private`i]] == 3, 
                AllTrue[
                 Part[VilTeX`Private`coords, VilTeX`Private`i], NumericQ]], 
               VilTeX`Private`allValidData = 
               Append[VilTeX`Private`allValidData, 
                 Part[VilTeX`Private`coords, VilTeX`Private`i]]], {
              VilTeX`Private`i, 
               Length[VilTeX`Private`coords]}], 
             If[
              And[Length[VilTeX`Private`coords] == 3, 
               AllTrue[VilTeX`Private`coords, NumericQ]], 
              VilTeX`Private`allValidData = 
              Append[VilTeX`Private`allValidData, VilTeX`Private`coords]]]]; 
         Module[{VilTeX`Private`currentColor = "blue", 
            VilTeX`Private`currentPointSize = "1.0", 
            VilTeX`Private`currentThickness = "1.0", 
            VilTeX`Private`currentDashing = False}, Do[
             
             Module[{VilTeX`Private`element = 
               Part[VilTeX`Private`flatElements, VilTeX`Private`i]}, Which[
                Or[
                Head[VilTeX`Private`element] === RGBColor, 
                 Head[VilTeX`Private`element] === GrayLevel, 
                 Head[VilTeX`Private`element] === Hue, 
                 
                 MemberQ[{
                  Red, Blue, Green, Black, Orange, Gray, White, Yellow, 
                   Purple, Brown, Pink, Cyan, Magenta}, 
                  VilTeX`Private`element]], VilTeX`Private`currentColor = 
                VilTeX`Private`detectBasicColor[VilTeX`Private`element], 
                Head[VilTeX`Private`element] === PointSize, 
                VilTeX`Private`currentPointSize = ToString[
                  VilTeX`Private`pointSizeToNumber[
                   Part[VilTeX`Private`element, 1]]], 
                Head[VilTeX`Private`element] === Thickness, 
                VilTeX`Private`currentThickness = ToString[
                  VilTeX`Private`thicknessToNumber[
                   Part[VilTeX`Private`element, 1]]], 
                Or[
                VilTeX`Private`element === Dashed, 
                 Head[VilTeX`Private`element] === Dashing], 
                VilTeX`Private`currentDashing = True, 
                Head[VilTeX`Private`element] === Line, 
                
                Module[{
                 VilTeX`Private`linePoints = Part[VilTeX`Private`element, 1], 
                  VilTeX`Private`styleString}, 
                 VilTeX`Private`styleString = 
                  VilTeX`Private`currentColor <> 
                   ", no marks, mark=none, line width=" <> 
                   VilTeX`Private`currentThickness <> "pt"; 
                 If[
                  VilTeX`Private`currentDashing, VilTeX`Private`styleString = 
                   VilTeX`Private`styleString <> ", densely dashed"]; 
                 VilTeX`Private`combinedTikzCode = 
                  VilTeX`Private`combinedTikzCode <> "\\addplot3[" <> 
                   VilTeX`Private`styleString <> "] coordinates {\n" <> 
                   StringRiffle[
                    Table["  (" <> VilTeX`Private`formatNumber[
                    Part[VilTeX`Private`linePoints, VilTeX`Private`k, 1]] <> 
                    "," <> VilTeX`Private`formatNumber[
                    Part[VilTeX`Private`linePoints, VilTeX`Private`k, 2]] <> 
                    "," <> VilTeX`Private`formatNumber[
                    Part[VilTeX`Private`linePoints, VilTeX`Private`k, 3]] <> 
                    ")", {VilTeX`Private`k, 
                    Length[VilTeX`Private`linePoints]}], "\n"] <> "\n};\n"; 
                 VilTeX`Private`addValidCoords[VilTeX`Private`linePoints]; 
                 Null], Head[VilTeX`Private`element] === Point, 
                
                Module[{
                 VilTeX`Private`pointData = Part[VilTeX`Private`element, 1], 
                  VilTeX`Private`styleString}, 
                 VilTeX`Private`styleString = 
                  VilTeX`Private`currentColor <> 
                   ", only marks, mark=*, mark size=" <> 
                   VilTeX`Private`currentPointSize <> "pt"; If[
                   NumericQ[
                    Part[VilTeX`Private`pointData, 1]], 
                   VilTeX`Private`combinedTikzCode = 
                    VilTeX`Private`combinedTikzCode <> "\\addplot3[" <> 
                    VilTeX`Private`styleString <> "] coordinates {\n" <> 
                    "  (" <> VilTeX`Private`formatNumber[
                    Part[VilTeX`Private`pointData, 1]] <> "," <> 
                    VilTeX`Private`formatNumber[
                    Part[VilTeX`Private`pointData, 2]] <> "," <> 
                    VilTeX`Private`formatNumber[
                    Part[VilTeX`Private`pointData, 3]] <> ")\n};\n"; 
                   VilTeX`Private`addValidCoords[VilTeX`Private`pointData]; 
                   Null, VilTeX`Private`combinedTikzCode = 
                    VilTeX`Private`combinedTikzCode <> "\\addplot3[" <> 
                    VilTeX`Private`styleString <> "] coordinates {\n" <> 
                    StringRiffle[
                    Table["  (" <> VilTeX`Private`formatNumber[
                    Part[VilTeX`Private`pointData, VilTeX`Private`k, 1]] <> 
                    "," <> VilTeX`Private`formatNumber[
                    Part[VilTeX`Private`pointData, VilTeX`Private`k, 2]] <> 
                    "," <> VilTeX`Private`formatNumber[
                    Part[VilTeX`Private`pointData, VilTeX`Private`k, 3]] <> 
                    ")", {VilTeX`Private`k, 
                    Length[VilTeX`Private`pointData]}], "\n"] <> "\n};\n"; 
                   VilTeX`Private`addValidCoords[VilTeX`Private`pointData]; 
                   Null]; Null], Head[VilTeX`Private`element] === Arrow, 
                
                Module[{
                 VilTeX`Private`arrowPoints = Part[VilTeX`Private`element, 1],
                   VilTeX`Private`styleString}, 
                 VilTeX`Private`styleString = 
                  VilTeX`Private`currentColor <> ", -{Stealth}, line width=" <> 
                   VilTeX`Private`currentThickness <> 
                   "pt, no marks, mark=none"; 
                 If[VilTeX`Private`currentDashing, VilTeX`Private`styleString = 
                   VilTeX`Private`styleString <> ", densely dashed"]; 
                 VilTeX`Private`combinedTikzCode = 
                  VilTeX`Private`combinedTikzCode <> "\\addplot3[" <> 
                   VilTeX`Private`styleString <> "] coordinates {\n" <> 
                   StringRiffle[
                    Table["  (" <> VilTeX`Private`formatNumber[
                    Part[VilTeX`Private`arrowPoints, VilTeX`Private`k, 1]] <> 
                    "," <> VilTeX`Private`formatNumber[
                    Part[VilTeX`Private`arrowPoints, VilTeX`Private`k, 2]] <> 
                    "," <> VilTeX`Private`formatNumber[
                    Part[VilTeX`Private`arrowPoints, VilTeX`Private`k, 3]] <> 
                    ")", {VilTeX`Private`k, 
                    Length[VilTeX`Private`arrowPoints]}], "\n"] <> "\n};\n"; 
                 VilTeX`Private`addValidCoords[VilTeX`Private`arrowPoints]; 
                 Null], 
                And[
                Head[VilTeX`Private`element] === Sphere, 
                 Length[VilTeX`Private`element] >= 1], 
                
                Module[{
                 VilTeX`Private`center, VilTeX`Private`radius, 
                  VilTeX`Private`sphereLines}, 
                 VilTeX`Private`center = Part[VilTeX`Private`element, 1]; 
                 VilTeX`Private`radius = 
                  If[Length[VilTeX`Private`element] >= 2, 
                    Part[VilTeX`Private`element, 2], 1]; 
                 VilTeX`Private`sphereLines = 
                  VilTeX`Private`sphereToLines[
                   VilTeX`Private`center, VilTeX`Private`radius, 15]; Do[
                   Module[{VilTeX`Private`linePoints = Part[
                    Part[VilTeX`Private`sphereLines, VilTeX`Private`j], 1], 
                    VilTeX`Private`styleString}, 
                    VilTeX`Private`styleString = 
                    VilTeX`Private`currentColor <> 
                    ", no marks, mark=none, line width=" <> 
                    VilTeX`Private`currentThickness <> "pt"; 
                    If[VilTeX`Private`currentDashing, 
                    VilTeX`Private`styleString = 
                    VilTeX`Private`styleString <> ", densely dashed"]; 
                    VilTeX`Private`combinedTikzCode = 
                    VilTeX`Private`combinedTikzCode <> "\\addplot3[" <> 
                    VilTeX`Private`styleString <> "] coordinates {\n" <> 
                    StringRiffle[
                    Table["  (" <> VilTeX`Private`formatNumber[
                    Part[VilTeX`Private`linePoints, VilTeX`Private`k, 1]] <> 
                    "," <> VilTeX`Private`formatNumber[
                    Part[VilTeX`Private`linePoints, VilTeX`Private`k, 2]] <> 
                    "," <> VilTeX`Private`formatNumber[
                    Part[VilTeX`Private`linePoints, VilTeX`Private`k, 3]] <> 
                    ")", {VilTeX`Private`k, 
                    Length[VilTeX`Private`linePoints]}], "\n"] <> "\n};\n"; 
                    VilTeX`Private`addValidCoords[VilTeX`Private`linePoints]; 
                    Null], {VilTeX`Private`j, 
                    Length[VilTeX`Private`sphereLines]}]; Null], 
                And[
                Head[VilTeX`Private`element] === Ellipsoid, 
                 Length[VilTeX`Private`element] >= 2], 
                
                Module[{
                 VilTeX`Private`center, VilTeX`Private`semiAxes, 
                  VilTeX`Private`ellipsoidLines}, 
                 VilTeX`Private`center = Part[VilTeX`Private`element, 1]; 
                 VilTeX`Private`semiAxes = Part[VilTeX`Private`element, 2]; 
                 VilTeX`Private`ellipsoidLines = 
                  VilTeX`Private`ellipsoidToLines[
                   VilTeX`Private`center, VilTeX`Private`semiAxes, 15]; Do[
                   Module[{VilTeX`Private`linePoints = Part[
                    Part[VilTeX`Private`ellipsoidLines, VilTeX`Private`j], 1],
                     VilTeX`Private`styleString}, 
                    VilTeX`Private`styleString = 
                    VilTeX`Private`currentColor <> 
                    ", no marks, mark=none, line width=" <> 
                    VilTeX`Private`currentThickness <> "pt"; 
                    If[VilTeX`Private`currentDashing, 
                    VilTeX`Private`styleString = 
                    VilTeX`Private`styleString <> ", densely dashed"]; 
                    VilTeX`Private`combinedTikzCode = 
                    VilTeX`Private`combinedTikzCode <> "\\addplot3[" <> 
                    VilTeX`Private`styleString <> "] coordinates {\n" <> 
                    StringRiffle[
                    Table["  (" <> VilTeX`Private`formatNumber[
                    Part[VilTeX`Private`linePoints, VilTeX`Private`k, 1]] <> 
                    "," <> VilTeX`Private`formatNumber[
                    Part[VilTeX`Private`linePoints, VilTeX`Private`k, 2]] <> 
                    "," <> VilTeX`Private`formatNumber[
                    Part[VilTeX`Private`linePoints, VilTeX`Private`k, 3]] <> 
                    ")", {VilTeX`Private`k, 
                    Length[VilTeX`Private`linePoints]}], "\n"] <> "\n};\n"; 
                    VilTeX`Private`addValidCoords[VilTeX`Private`linePoints]; 
                    Null], {VilTeX`Private`j, 
                    Length[VilTeX`Private`ellipsoidLines]}]; Null], 
                Head[VilTeX`Private`element] === Cylinder, 
                
                Module[{
                 VilTeX`Private`center, VilTeX`Private`radius, 
                  VilTeX`Private`height, VilTeX`Private`cylinderLines}, 
                 VilTeX`Private`center = If[
                    And[Length[VilTeX`Private`element] >= 1, 
                    ListQ[
                    Part[VilTeX`Private`element, 1]], Length[
                    Part[VilTeX`Private`element, 1]] >= 2], (Part[
                    Part[VilTeX`Private`element, 1], 1] + Part[
                    Part[VilTeX`Private`element, 1], 2])/2, {0, 0, 0}]; 
                 VilTeX`Private`radius = 
                  If[Length[VilTeX`Private`element] >= 2, 
                    Part[VilTeX`Private`element, 2], 1]; 
                 VilTeX`Private`height = If[
                    And[Length[VilTeX`Private`element] >= 1, 
                    ListQ[
                    Part[VilTeX`Private`element, 1]], Length[
                    Part[VilTeX`Private`element, 1]] >= 2], 
                    Norm[Part[
                    Part[VilTeX`Private`element, 1], 2] - Part[
                    Part[VilTeX`Private`element, 1], 1]], 2]; 
                 VilTeX`Private`cylinderLines = 
                  VilTeX`Private`cylinderToLines[
                   VilTeX`Private`center, VilTeX`Private`radius, 
                    VilTeX`Private`height]; Do[
                   Module[{VilTeX`Private`linePoints = Part[
                    Part[VilTeX`Private`cylinderLines, VilTeX`Private`j], 1], 
                    VilTeX`Private`styleString}, 
                    VilTeX`Private`styleString = 
                    VilTeX`Private`currentColor <> 
                    ", no marks, mark=none, line width=" <> 
                    VilTeX`Private`currentThickness <> "pt"; 
                    If[VilTeX`Private`currentDashing, 
                    VilTeX`Private`styleString = 
                    VilTeX`Private`styleString <> ", densely dashed"]; 
                    VilTeX`Private`combinedTikzCode = 
                    VilTeX`Private`combinedTikzCode <> "\\addplot3[" <> 
                    VilTeX`Private`styleString <> "] coordinates {\n" <> 
                    StringRiffle[
                    Table["  (" <> VilTeX`Private`formatNumber[
                    Part[VilTeX`Private`linePoints, VilTeX`Private`k, 1]] <> 
                    "," <> VilTeX`Private`formatNumber[
                    Part[VilTeX`Private`linePoints, VilTeX`Private`k, 2]] <> 
                    "," <> VilTeX`Private`formatNumber[
                    Part[VilTeX`Private`linePoints, VilTeX`Private`k, 3]] <> 
                    ")", {VilTeX`Private`k, 
                    Length[VilTeX`Private`linePoints]}], "\n"] <> "\n};\n"; 
                    VilTeX`Private`addValidCoords[VilTeX`Private`linePoints]; 
                    Null], {VilTeX`Private`j, 
                    Length[VilTeX`Private`cylinderLines]}]; Null], 
                And[
                Head[VilTeX`Private`element] === Cone, 
                 Length[VilTeX`Private`element] >= 1], 
                
                Module[{
                 VilTeX`Private`apex, VilTeX`Private`base, 
                  VilTeX`Private`radius, VilTeX`Private`coneLines}, If[
                   And[Length[VilTeX`Private`element] >= 1, 
                    ListQ[
                    Part[VilTeX`Private`element, 1]], Length[
                    Part[VilTeX`Private`element, 1]] >= 2], 
                   VilTeX`Private`apex = Part[
                    Part[VilTeX`Private`element, 1], 2]; 
                   VilTeX`Private`base = Part[
                    Part[VilTeX`Private`element, 1], 1]; 
                   VilTeX`Private`radius = 
                    If[Length[VilTeX`Private`element] >= 2, 
                    Part[VilTeX`Private`element, 2], 1]; 
                   VilTeX`Private`coneLines = 
                    VilTeX`Private`coneToLines[
                    VilTeX`Private`apex, VilTeX`Private`base, 
                    VilTeX`Private`radius]; Do[
                    Module[{VilTeX`Private`linePoints = Part[
                    Part[VilTeX`Private`coneLines, VilTeX`Private`j], 1], 
                    VilTeX`Private`styleString}, 
                    VilTeX`Private`styleString = 
                    VilTeX`Private`currentColor <> 
                    ", no marks, mark=none, line width=" <> 
                    VilTeX`Private`currentThickness <> "pt"; 
                    If[VilTeX`Private`currentDashing, 
                    VilTeX`Private`styleString = 
                    VilTeX`Private`styleString <> ", densely dashed"]; 
                    VilTeX`Private`combinedTikzCode = 
                    VilTeX`Private`combinedTikzCode <> "\\addplot3[" <> 
                    VilTeX`Private`styleString <> "] coordinates {\n" <> 
                    StringRiffle[
                    Table["  (" <> VilTeX`Private`formatNumber[
                    Part[VilTeX`Private`linePoints, VilTeX`Private`k, 1]] <> 
                    "," <> VilTeX`Private`formatNumber[
                    Part[VilTeX`Private`linePoints, VilTeX`Private`k, 2]] <> 
                    "," <> VilTeX`Private`formatNumber[
                    Part[VilTeX`Private`linePoints, VilTeX`Private`k, 3]] <> 
                    ")", {VilTeX`Private`k, 
                    Length[VilTeX`Private`linePoints]}], "\n"] <> "\n};\n"; 
                    VilTeX`Private`addValidCoords[VilTeX`Private`linePoints]; 
                    Null], {VilTeX`Private`j, 
                    Length[VilTeX`Private`coneLines]}]; Null]; Null], 
                And[
                Head[VilTeX`Private`element] === Cuboid, 
                 Length[VilTeX`Private`element] >= 2], 
                
                Module[{
                 VilTeX`Private`min, VilTeX`Private`max, 
                  VilTeX`Private`cuboidLines}, 
                 VilTeX`Private`min = Part[VilTeX`Private`element, 1]; 
                 VilTeX`Private`max = Part[VilTeX`Private`element, 2]; 
                 VilTeX`Private`cuboidLines = 
                  VilTeX`Private`cuboidToLines[
                   VilTeX`Private`min, VilTeX`Private`max]; Do[
                   Module[{VilTeX`Private`linePoints = Part[
                    Part[VilTeX`Private`cuboidLines, VilTeX`Private`j], 1], 
                    VilTeX`Private`styleString}, 
                    VilTeX`Private`styleString = 
                    VilTeX`Private`currentColor <> 
                    ", no marks, mark=none, line width=" <> 
                    VilTeX`Private`currentThickness <> "pt"; 
                    If[VilTeX`Private`currentDashing, 
                    VilTeX`Private`styleString = 
                    VilTeX`Private`styleString <> ", densely dashed"]; 
                    VilTeX`Private`combinedTikzCode = 
                    VilTeX`Private`combinedTikzCode <> "\\addplot3[" <> 
                    VilTeX`Private`styleString <> "] coordinates {\n" <> 
                    StringRiffle[
                    Table["  (" <> VilTeX`Private`formatNumber[
                    Part[VilTeX`Private`linePoints, VilTeX`Private`k, 1]] <> 
                    "," <> VilTeX`Private`formatNumber[
                    Part[VilTeX`Private`linePoints, VilTeX`Private`k, 2]] <> 
                    "," <> VilTeX`Private`formatNumber[
                    Part[VilTeX`Private`linePoints, VilTeX`Private`k, 3]] <> 
                    ")", {VilTeX`Private`k, 
                    Length[VilTeX`Private`linePoints]}], "\n"] <> "\n};\n"; 
                    VilTeX`Private`addValidCoords[VilTeX`Private`linePoints]; 
                    Null], {VilTeX`Private`j, 
                    Length[VilTeX`Private`cuboidLines]}]; Null], 
                And[
                Head[VilTeX`Private`element] === Text, 
                 Length[VilTeX`Private`element] >= 2], 
                
                Module[{VilTeX`Private`text, VilTeX`Private`pos}, 
                 VilTeX`Private`text = ToString[
                    Part[VilTeX`Private`element, 1]]; 
                 VilTeX`Private`pos = Part[VilTeX`Private`element, 2]; If[
                   And[
                    ListQ[VilTeX`Private`pos], Length[VilTeX`Private`pos] == 
                    3, 
                    AllTrue[VilTeX`Private`pos, NumericQ]], 
                   VilTeX`Private`textTikzCode = 
                    VilTeX`Private`textTikzCode <> "\\node[text=" <> 
                    VilTeX`Private`currentColor <> "] at (axis cs:" <> 
                    VilTeX`Private`formatNumber[
                    Part[VilTeX`Private`pos, 1]] <> "," <> 
                    VilTeX`Private`formatNumber[
                    Part[VilTeX`Private`pos, 2]] <> "," <> 
                    VilTeX`Private`formatNumber[
                    Part[VilTeX`Private`pos, 3]] <> ") {" <> 
                    VilTeX`Private`text <> "};\n"; 
                   VilTeX`Private`addValidCoords[VilTeX`Private`pos]; Null]; 
                 Null], 
                And[
                Head[VilTeX`Private`element] === Tube, 
                 Length[VilTeX`Private`element] >= 1], 
                
                Module[{
                 VilTeX`Private`curve, VilTeX`Private`linePoints, 
                  VilTeX`Private`styleString}, 
                 VilTeX`Private`curve = Part[VilTeX`Private`element, 1]; If[
                   And[
                   Head[VilTeX`Private`curve] === Line, 
                    Length[VilTeX`Private`curve] >= 1], 
                   VilTeX`Private`linePoints = Part[VilTeX`Private`curve, 1]; 
                   VilTeX`Private`styleString = 
                    VilTeX`Private`currentColor <> 
                    ", no marks, mark=none, line width=" <> 
                    VilTeX`Private`currentThickness <> "pt"; 
                   If[VilTeX`Private`currentDashing, 
                    VilTeX`Private`styleString = 
                    VilTeX`Private`styleString <> ", densely dashed"]; 
                   VilTeX`Private`combinedTikzCode = 
                    VilTeX`Private`combinedTikzCode <> "\\addplot3[" <> 
                    VilTeX`Private`styleString <> "] coordinates {\n" <> 
                    StringRiffle[
                    Table["  (" <> VilTeX`Private`formatNumber[
                    Part[VilTeX`Private`linePoints, VilTeX`Private`k, 1]] <> 
                    "," <> VilTeX`Private`formatNumber[
                    Part[VilTeX`Private`linePoints, VilTeX`Private`k, 2]] <> 
                    "," <> VilTeX`Private`formatNumber[
                    Part[VilTeX`Private`linePoints, VilTeX`Private`k, 3]] <> 
                    ")", {VilTeX`Private`k, 
                    Length[VilTeX`Private`linePoints]}], "\n"] <> "\n};\n"; 
                   VilTeX`Private`addValidCoords[VilTeX`Private`linePoints]; 
                   Null]; Null], 
                And[
                Head[VilTeX`Private`element] === Polygon, 
                 Length[VilTeX`Private`element] >= 1], 
                
                Module[{VilTeX`Private`vertices, VilTeX`Private`polygonLines},
                  If[VilTeX`Private`polygonCount < VilTeX`Private`maxPolygons,
                    VilTeX`Private`vertices = Part[VilTeX`Private`element, 1]; 
                   VilTeX`Private`polygonLines = 
                    VilTeX`Private`polygonToLines[VilTeX`Private`vertices]; 
                   Increment[VilTeX`Private`polygonCount]; Do[
                    Module[{VilTeX`Private`linePoints = Part[
                    Part[VilTeX`Private`polygonLines, VilTeX`Private`j], 1], 
                    VilTeX`Private`styleString}, 
                    VilTeX`Private`styleString = 
                    VilTeX`Private`currentColor <> 
                    ", no marks, mark=none, line width=" <> 
                    VilTeX`Private`currentThickness <> "pt"; 
                    If[VilTeX`Private`currentDashing, 
                    VilTeX`Private`styleString = 
                    VilTeX`Private`styleString <> ", densely dashed"]; 
                    VilTeX`Private`combinedTikzCode = 
                    VilTeX`Private`combinedTikzCode <> "\\addplot3[" <> 
                    VilTeX`Private`styleString <> "] coordinates {\n" <> 
                    StringRiffle[
                    Table["  (" <> VilTeX`Private`formatNumber[
                    Part[VilTeX`Private`linePoints, VilTeX`Private`k, 1]] <> 
                    "," <> VilTeX`Private`formatNumber[
                    Part[VilTeX`Private`linePoints, VilTeX`Private`k, 2]] <> 
                    "," <> VilTeX`Private`formatNumber[
                    Part[VilTeX`Private`linePoints, VilTeX`Private`k, 3]] <> 
                    ")", {VilTeX`Private`k, 
                    Length[VilTeX`Private`linePoints]}], "\n"] <> "\n};\n"; 
                    VilTeX`Private`addValidCoords[VilTeX`Private`linePoints]; 
                    Null], {VilTeX`Private`j, 
                    Length[VilTeX`Private`polygonLines]}]; Null]; Null], 
                And[
                Head[VilTeX`Private`element] === Style, 
                 Length[VilTeX`Private`element] >= 2], 
                
                Module[{
                 VilTeX`Private`content, VilTeX`Private`styles, 
                  VilTeX`Private`tempColor = VilTeX`Private`currentColor, 
                  VilTeX`Private`tempPointSize = 
                  VilTeX`Private`currentPointSize, 
                  VilTeX`Private`tempThickness = 
                  VilTeX`Private`currentThickness, VilTeX`Private`tempDashing = 
                  VilTeX`Private`currentDashing}, 
                 VilTeX`Private`content = Part[VilTeX`Private`element, 1]; 
                 VilTeX`Private`styles = Drop[VilTeX`Private`element, 1]; Do[
                   Which[
                    Or[Head[
                    Part[VilTeX`Private`styles, VilTeX`Private`j]] === 
                    RGBColor, Head[
                    Part[VilTeX`Private`styles, VilTeX`Private`j]] === 
                    GrayLevel, Head[
                    Part[VilTeX`Private`styles, VilTeX`Private`j]] === Hue, 
                    
                    MemberQ[{
                    Red, Blue, Green, Black, Orange, Gray, White, Yellow, 
                    Purple, Brown, Pink, Cyan, Magenta}, 
                    Part[VilTeX`Private`styles, VilTeX`Private`j]]], 
                    VilTeX`Private`tempColor = VilTeX`Private`detectBasicColor[
                    Part[VilTeX`Private`styles, VilTeX`Private`j]], Head[
                    Part[VilTeX`Private`styles, VilTeX`Private`j]] === 
                    PointSize, VilTeX`Private`tempPointSize = ToString[
                    VilTeX`Private`pointSizeToNumber[
                    Part[
                    Part[VilTeX`Private`styles, VilTeX`Private`j], 1]]], 
                    Head[
                    Part[VilTeX`Private`styles, VilTeX`Private`j]] === 
                    Thickness, VilTeX`Private`tempThickness = ToString[
                    VilTeX`Private`thicknessToNumber[
                    Part[
                    Part[VilTeX`Private`styles, VilTeX`Private`j], 1]]], 
                    Or[
                    Part[VilTeX`Private`styles, VilTeX`Private`j] === Dashed, 
                    Head[
                    Part[VilTeX`Private`styles, VilTeX`Private`j]] === 
                    Dashing], VilTeX`Private`tempDashing = True], {
                   VilTeX`Private`j, 
                    Length[VilTeX`Private`styles]}]; Which[
                   And[
                   Head[VilTeX`Private`content] === Cuboid, 
                    Length[VilTeX`Private`content] >= 2], 
                   
                   Module[{
                    VilTeX`Private`min, VilTeX`Private`max, 
                    VilTeX`Private`cuboidLines}, 
                    VilTeX`Private`min = Part[VilTeX`Private`content, 1]; 
                    VilTeX`Private`max = Part[VilTeX`Private`content, 2]; 
                    VilTeX`Private`cuboidLines = 
                    VilTeX`Private`cuboidToLines[
                    VilTeX`Private`min, VilTeX`Private`max]; Do[
                    Module[{VilTeX`Private`linePoints = Part[
                    Part[VilTeX`Private`cuboidLines, VilTeX`Private`k], 1], 
                    VilTeX`Private`styleString}, 
                    VilTeX`Private`styleString = 
                    VilTeX`Private`tempColor <> 
                    ", no marks, mark=none, line width=" <> 
                    VilTeX`Private`tempThickness <> "pt"; 
                    If[VilTeX`Private`tempDashing, VilTeX`Private`styleString = 
                    VilTeX`Private`styleString <> ", densely dashed"]; 
                    VilTeX`Private`combinedTikzCode = 
                    VilTeX`Private`combinedTikzCode <> "\\addplot3[" <> 
                    VilTeX`Private`styleString <> "] coordinates {\n" <> 
                    StringRiffle[
                    Table["  (" <> VilTeX`Private`formatNumber[
                    Part[VilTeX`Private`linePoints, VilTeX`Private`l, 1]] <> 
                    "," <> VilTeX`Private`formatNumber[
                    Part[VilTeX`Private`linePoints, VilTeX`Private`l, 2]] <> 
                    "," <> VilTeX`Private`formatNumber[
                    Part[VilTeX`Private`linePoints, VilTeX`Private`l, 3]] <> 
                    ")", {VilTeX`Private`l, 
                    Length[VilTeX`Private`linePoints]}], "\n"] <> "\n};\n"; 
                    VilTeX`Private`addValidCoords[VilTeX`Private`linePoints]; 
                    Null], {VilTeX`Private`k, 
                    Length[VilTeX`Private`cuboidLines]}]; Null], 
                   And[
                   Head[VilTeX`Private`content] === Sphere, 
                    Length[VilTeX`Private`content] >= 1], 
                   
                   Module[{
                    VilTeX`Private`center, VilTeX`Private`radius, 
                    VilTeX`Private`sphereLines}, 
                    VilTeX`Private`center = Part[VilTeX`Private`content, 1]; 
                    VilTeX`Private`radius = 
                    If[Length[VilTeX`Private`content] >= 2, 
                    Part[VilTeX`Private`content, 2], 1]; 
                    VilTeX`Private`sphereLines = 
                    VilTeX`Private`sphereToLines[
                    VilTeX`Private`center, VilTeX`Private`radius, 15]; Do[
                    Module[{VilTeX`Private`linePoints = Part[
                    Part[VilTeX`Private`sphereLines, VilTeX`Private`k], 1], 
                    VilTeX`Private`styleString}, 
                    VilTeX`Private`styleString = 
                    VilTeX`Private`tempColor <> 
                    ", no marks, mark=none, line width=" <> 
                    VilTeX`Private`tempThickness <> "pt"; 
                    If[VilTeX`Private`tempDashing, VilTeX`Private`styleString = 
                    VilTeX`Private`styleString <> ", densely dashed"]; 
                    VilTeX`Private`combinedTikzCode = 
                    VilTeX`Private`combinedTikzCode <> "\\addplot3[" <> 
                    VilTeX`Private`styleString <> "] coordinates {\n" <> 
                    StringRiffle[
                    Table["  (" <> VilTeX`Private`formatNumber[
                    Part[VilTeX`Private`linePoints, VilTeX`Private`l, 1]] <> 
                    "," <> VilTeX`Private`formatNumber[
                    Part[VilTeX`Private`linePoints, VilTeX`Private`l, 2]] <> 
                    "," <> VilTeX`Private`formatNumber[
                    Part[VilTeX`Private`linePoints, VilTeX`Private`l, 3]] <> 
                    ")", {VilTeX`Private`l, 
                    Length[VilTeX`Private`linePoints]}], "\n"] <> "\n};\n"; 
                    VilTeX`Private`addValidCoords[VilTeX`Private`linePoints]; 
                    Null], {VilTeX`Private`k, 
                    Length[VilTeX`Private`sphereLines]}]; Null], 
                   And[
                   Head[VilTeX`Private`content] === Ellipsoid, 
                    Length[VilTeX`Private`content] >= 2], 
                   
                   Module[{
                    VilTeX`Private`center, VilTeX`Private`semiAxes, 
                    VilTeX`Private`ellipsoidLines}, 
                    VilTeX`Private`center = Part[VilTeX`Private`content, 1]; 
                    VilTeX`Private`semiAxes = Part[VilTeX`Private`content, 2]; 
                    VilTeX`Private`ellipsoidLines = 
                    VilTeX`Private`ellipsoidToLines[
                    VilTeX`Private`center, VilTeX`Private`semiAxes, 15]; Do[
                    Module[{VilTeX`Private`linePoints = Part[
                    Part[VilTeX`Private`ellipsoidLines, VilTeX`Private`k], 1],
                     VilTeX`Private`styleString}, 
                    VilTeX`Private`styleString = 
                    VilTeX`Private`tempColor <> 
                    ", no marks, mark=none, line width=" <> 
                    VilTeX`Private`tempThickness <> "pt"; 
                    If[VilTeX`Private`tempDashing, VilTeX`Private`styleString = 
                    VilTeX`Private`styleString <> ", densely dashed"]; 
                    VilTeX`Private`combinedTikzCode = 
                    VilTeX`Private`combinedTikzCode <> "\\addplot3[" <> 
                    VilTeX`Private`styleString <> "] coordinates {\n" <> 
                    StringRiffle[
                    Table["  (" <> VilTeX`Private`formatNumber[
                    Part[VilTeX`Private`linePoints, VilTeX`Private`l, 1]] <> 
                    "," <> VilTeX`Private`formatNumber[
                    Part[VilTeX`Private`linePoints, VilTeX`Private`l, 2]] <> 
                    "," <> VilTeX`Private`formatNumber[
                    Part[VilTeX`Private`linePoints, VilTeX`Private`l, 3]] <> 
                    ")", {VilTeX`Private`l, 
                    Length[VilTeX`Private`linePoints]}], "\n"] <> "\n};\n"; 
                    VilTeX`Private`addValidCoords[VilTeX`Private`linePoints]; 
                    Null], {VilTeX`Private`k, 
                    Length[VilTeX`Private`ellipsoidLines]}]; Null], 
                   Head[VilTeX`Private`content] === Cylinder, 
                   
                   Module[{
                    VilTeX`Private`center, VilTeX`Private`radius, 
                    VilTeX`Private`height, VilTeX`Private`cylinderLines}, 
                    VilTeX`Private`center = If[
                    And[Length[VilTeX`Private`content] >= 1, 
                    ListQ[
                    Part[VilTeX`Private`content, 1]], Length[
                    Part[VilTeX`Private`content, 1]] >= 2], (Part[
                    Part[VilTeX`Private`content, 1], 1] + Part[
                    Part[VilTeX`Private`content, 1], 2])/2, {0, 0, 0}]; 
                    VilTeX`Private`radius = 
                    If[Length[VilTeX`Private`content] >= 2, 
                    Part[VilTeX`Private`content, 2], 1]; 
                    VilTeX`Private`height = If[
                    And[Length[VilTeX`Private`content] >= 1, 
                    ListQ[
                    Part[VilTeX`Private`content, 1]], Length[
                    Part[VilTeX`Private`content, 1]] >= 2], 
                    Norm[Part[
                    Part[VilTeX`Private`content, 1], 2] - Part[
                    Part[VilTeX`Private`content, 1], 1]], 2]; 
                    VilTeX`Private`cylinderLines = 
                    VilTeX`Private`cylinderToLines[
                    VilTeX`Private`center, VilTeX`Private`radius, 
                    VilTeX`Private`height]; Do[
                    Module[{VilTeX`Private`linePoints = Part[
                    Part[VilTeX`Private`cylinderLines, VilTeX`Private`k], 1], 
                    VilTeX`Private`styleString}, 
                    VilTeX`Private`styleString = 
                    VilTeX`Private`tempColor <> 
                    ", no marks, mark=none, line width=" <> 
                    VilTeX`Private`tempThickness <> "pt"; 
                    If[VilTeX`Private`tempDashing, VilTeX`Private`styleString = 
                    VilTeX`Private`styleString <> ", densely dashed"]; 
                    VilTeX`Private`combinedTikzCode = 
                    VilTeX`Private`combinedTikzCode <> "\\addplot3[" <> 
                    VilTeX`Private`styleString <> "] coordinates {\n" <> 
                    StringRiffle[
                    Table["  (" <> VilTeX`Private`formatNumber[
                    Part[VilTeX`Private`linePoints, VilTeX`Private`l, 1]] <> 
                    "," <> VilTeX`Private`formatNumber[
                    Part[VilTeX`Private`linePoints, VilTeX`Private`l, 2]] <> 
                    "," <> VilTeX`Private`formatNumber[
                    Part[VilTeX`Private`linePoints, VilTeX`Private`l, 3]] <> 
                    ")", {VilTeX`Private`l, 
                    Length[VilTeX`Private`linePoints]}], "\n"] <> "\n};\n"; 
                    VilTeX`Private`addValidCoords[VilTeX`Private`linePoints]; 
                    Null], {VilTeX`Private`k, 
                    Length[VilTeX`Private`cylinderLines]}]; Null], 
                   And[
                   Head[VilTeX`Private`content] === Cone, 
                    Length[VilTeX`Private`content] >= 1], 
                   
                   Module[{
                    VilTeX`Private`apex, VilTeX`Private`base, 
                    VilTeX`Private`radius, VilTeX`Private`coneLines}, If[
                    And[Length[VilTeX`Private`content] >= 1, 
                    ListQ[
                    Part[VilTeX`Private`content, 1]], Length[
                    Part[VilTeX`Private`content, 1]] >= 2], 
                    VilTeX`Private`apex = Part[
                    Part[VilTeX`Private`content, 1], 2]; 
                    VilTeX`Private`base = Part[
                    Part[VilTeX`Private`content, 1], 1]; 
                    VilTeX`Private`radius = 
                    If[Length[VilTeX`Private`content] >= 2, 
                    Part[VilTeX`Private`content, 2], 1]; 
                    VilTeX`Private`coneLines = 
                    VilTeX`Private`coneToLines[
                    VilTeX`Private`apex, VilTeX`Private`base, 
                    VilTeX`Private`radius]; Do[
                    Module[{VilTeX`Private`linePoints = Part[
                    Part[VilTeX`Private`coneLines, VilTeX`Private`k], 1], 
                    VilTeX`Private`styleString}, 
                    VilTeX`Private`styleString = 
                    VilTeX`Private`tempColor <> 
                    ", no marks, mark=none, line width=" <> 
                    VilTeX`Private`tempThickness <> "pt"; 
                    If[VilTeX`Private`tempDashing, VilTeX`Private`styleString = 
                    VilTeX`Private`styleString <> ", densely dashed"]; 
                    VilTeX`Private`combinedTikzCode = 
                    VilTeX`Private`combinedTikzCode <> "\\addplot3[" <> 
                    VilTeX`Private`styleString <> "] coordinates {\n" <> 
                    StringRiffle[
                    Table["  (" <> VilTeX`Private`formatNumber[
                    Part[VilTeX`Private`linePoints, VilTeX`Private`l, 1]] <> 
                    "," <> VilTeX`Private`formatNumber[
                    Part[VilTeX`Private`linePoints, VilTeX`Private`l, 2]] <> 
                    "," <> VilTeX`Private`formatNumber[
                    Part[VilTeX`Private`linePoints, VilTeX`Private`l, 3]] <> 
                    ")", {VilTeX`Private`l, 
                    Length[VilTeX`Private`linePoints]}], "\n"] <> "\n};\n"; 
                    VilTeX`Private`addValidCoords[VilTeX`Private`linePoints]; 
                    Null], {VilTeX`Private`k, 
                    Length[VilTeX`Private`coneLines]}]; Null]; Null], 
                   And[
                   Head[VilTeX`Private`content] === Polygon, 
                    Length[VilTeX`Private`content] >= 1], 
                   
                   Module[{
                    VilTeX`Private`vertices, VilTeX`Private`polygonLines}, 
                    If[VilTeX`Private`polygonCount < 
                    VilTeX`Private`maxPolygons, 
                    VilTeX`Private`vertices = Part[VilTeX`Private`content, 1]; 
                    VilTeX`Private`polygonLines = 
                    VilTeX`Private`polygonToLines[VilTeX`Private`vertices]; 
                    Increment[VilTeX`Private`polygonCount]; Do[
                    Module[{VilTeX`Private`linePoints = Part[
                    Part[VilTeX`Private`polygonLines, VilTeX`Private`k], 1], 
                    VilTeX`Private`styleString}, 
                    VilTeX`Private`styleString = 
                    VilTeX`Private`tempColor <> 
                    ", no marks, mark=none, line width=" <> 
                    VilTeX`Private`tempThickness <> "pt"; 
                    If[VilTeX`Private`tempDashing, VilTeX`Private`styleString = 
                    VilTeX`Private`styleString <> ", densely dashed"]; 
                    VilTeX`Private`combinedTikzCode = 
                    VilTeX`Private`combinedTikzCode <> "\\addplot3[" <> 
                    VilTeX`Private`styleString <> "] coordinates {\n" <> 
                    StringRiffle[
                    Table["  (" <> VilTeX`Private`formatNumber[
                    Part[VilTeX`Private`linePoints, VilTeX`Private`l, 1]] <> 
                    "," <> VilTeX`Private`formatNumber[
                    Part[VilTeX`Private`linePoints, VilTeX`Private`l, 2]] <> 
                    "," <> VilTeX`Private`formatNumber[
                    Part[VilTeX`Private`linePoints, VilTeX`Private`l, 3]] <> 
                    ")", {VilTeX`Private`l, 
                    Length[VilTeX`Private`linePoints]}], "\n"] <> "\n};\n"; 
                    VilTeX`Private`addValidCoords[VilTeX`Private`linePoints]; 
                    Null], {VilTeX`Private`k, 
                    Length[VilTeX`Private`polygonLines]}]; Null]; Null]]; 
                 Null]]; Null], {VilTeX`Private`i, 
              Length[VilTeX`Private`flatElements]}]; Null]; 
         If[VilTeX`Private`polygonCount >= VilTeX`Private`maxPolygons, 
           Print["Se alcanz\[OAcute] el l\[IAcute]mite de ", 
             VilTeX`Private`maxPolygons, 
             " pol\[IAcute]gonos. Algunos elementos no se exportaron."]; 
           Print["   Para exportar todos los elementos, aumente el par\
\[AAcute]metro maxPolygons o reduzca la resoluci\[OAcute]n del \
gr\[AAcute]fico."]; Null]; 
         If[Length[VilTeX`Private`allValidData] == 0, 
           VilTeX`Private`allValidData = {{0, 0, 0}, {1, 1, 1}}; Null]; 
         Module[{VilTeX`Private`xDataMin, VilTeX`Private`xDataMax, 
            VilTeX`Private`yDataMin, VilTeX`Private`yDataMax, 
            VilTeX`Private`zDataMin, VilTeX`Private`zDataMax}, 
           If[Length[VilTeX`Private`allValidData] > 0, 
             VilTeX`Private`xDataMin = Min[
                Part[VilTeX`Private`allValidData, All, 1]]; 
             VilTeX`Private`xDataMax = Max[
                Part[VilTeX`Private`allValidData, All, 1]]; 
             VilTeX`Private`yDataMin = Min[
                Part[VilTeX`Private`allValidData, All, 2]]; 
             VilTeX`Private`yDataMax = Max[
                Part[VilTeX`Private`allValidData, All, 2]]; 
             VilTeX`Private`zDataMin = Min[
                Part[VilTeX`Private`allValidData, All, 3]]; 
             VilTeX`Private`zDataMax = Max[
                Part[VilTeX`Private`allValidData, All, 3]]; 
             Module[{VilTeX`Private`xRange, VilTeX`Private`yRange, 
                VilTeX`Private`zRange, VilTeX`Private`padding = 0.1}, 
               VilTeX`Private`xRange = 
                Max[VilTeX`Private`xDataMax - VilTeX`Private`xDataMin, 0.1]; 
               VilTeX`Private`yRange = 
                Max[VilTeX`Private`yDataMax - VilTeX`Private`yDataMin, 0.1]; 
               VilTeX`Private`zRange = 
                Max[VilTeX`Private`zDataMax - VilTeX`Private`zDataMin, 0.1]; 
               VilTeX`Private`xDataMin = 
                VilTeX`Private`xDataMin - VilTeX`Private`padding 
                 VilTeX`Private`xRange; 
               VilTeX`Private`xDataMax = 
                VilTeX`Private`xDataMax + 
                 VilTeX`Private`padding VilTeX`Private`xRange; 
               VilTeX`Private`yDataMin = 
                VilTeX`Private`yDataMin - VilTeX`Private`padding 
                 VilTeX`Private`yRange; 
               VilTeX`Private`yDataMax = 
                VilTeX`Private`yDataMax + 
                 VilTeX`Private`padding VilTeX`Private`yRange; 
               VilTeX`Private`zDataMin = 
                VilTeX`Private`zDataMin - VilTeX`Private`padding 
                 VilTeX`Private`zRange; 
               VilTeX`Private`zDataMax = 
                VilTeX`Private`zDataMax + 
                 VilTeX`Private`padding VilTeX`Private`zRange; Null]; If[
               And[
               VilTeX`Private`axisType == "center", 
                VilTeX`Private`axisExtension > 0], 
               Module[{
                 VilTeX`Private`xRange, VilTeX`Private`yRange, 
                  VilTeX`Private`zRange}, 
                 VilTeX`Private`xRange = 
                  VilTeX`Private`xDataMax - VilTeX`Private`xDataMin; 
                 VilTeX`Private`yRange = 
                  VilTeX`Private`yDataMax - VilTeX`Private`yDataMin; 
                 VilTeX`Private`zRange = 
                  VilTeX`Private`zDataMax - VilTeX`Private`zDataMin; 
                 VilTeX`Private`xDataMin = 
                  VilTeX`Private`xDataMin - VilTeX`Private`axisExtension 
                   VilTeX`Private`xRange; 
                 VilTeX`Private`xDataMax = 
                  VilTeX`Private`xDataMax + 
                   VilTeX`Private`axisExtension VilTeX`Private`xRange; 
                 VilTeX`Private`yDataMin = 
                  VilTeX`Private`yDataMin - VilTeX`Private`axisExtension 
                   VilTeX`Private`yRange; 
                 VilTeX`Private`yDataMax = 
                  VilTeX`Private`yDataMax + 
                   VilTeX`Private`axisExtension VilTeX`Private`yRange; 
                 VilTeX`Private`zDataMin = 
                  VilTeX`Private`zDataMin - VilTeX`Private`axisExtension 
                   VilTeX`Private`zRange; 
                 VilTeX`Private`zDataMax = 
                  VilTeX`Private`zDataMax + 
                   VilTeX`Private`axisExtension VilTeX`Private`zRange; Null]; 
               Null]; VilTeX`Private`globalLimits = {
               VilTeX`Private`xDataMin, VilTeX`Private`xDataMax, 
                VilTeX`Private`yDataMin, VilTeX`Private`yDataMax, 
                VilTeX`Private`zDataMin, VilTeX`Private`zDataMax}; Null, 
             VilTeX`Private`globalLimits = {-2, 2, -2, 2, -2, 2}; Null]; 
           Null]; If[Length[VilTeX`Private`textAnnotations] > 0, Do[
             
             Module[{VilTeX`Private`annotation, VilTeX`Private`text, 
               VilTeX`Private`coords, VilTeX`Private`options, 
               VilTeX`Private`xPos, VilTeX`Private`yPos, VilTeX`Private`zPos, 
               VilTeX`Private`textOptions, VilTeX`Private`validCoords}, 
              VilTeX`Private`annotation = 
               Part[VilTeX`Private`textAnnotations, VilTeX`Private`i]; 
              VilTeX`Private`text = ""; VilTeX`Private`textOptions = ""; 
              VilTeX`Private`validCoords = False; If[
                And[
                 ListQ[VilTeX`Private`annotation], 
                 Length[VilTeX`Private`annotation] >= 2], If[
                  StringQ[
                   Part[VilTeX`Private`annotation, 1]], 
                  VilTeX`Private`text = Part[VilTeX`Private`annotation, 1]; 
                  Null]; If[
                  And[
                   ListQ[
                    Part[VilTeX`Private`annotation, 2]], Length[
                    Part[VilTeX`Private`annotation, 2]] == 3], 
                  VilTeX`Private`coords = Part[VilTeX`Private`annotation, 2]; 
                  If[
                    AllTrue[
                    VilTeX`Private`coords, 
                    NumericQ], {
                    VilTeX`Private`xPos, VilTeX`Private`yPos, 
                    VilTeX`Private`zPos} = N[VilTeX`Private`coords]; 
                    VilTeX`Private`validCoords = True; Null]; Null]; If[
                  And[Length[VilTeX`Private`annotation] >= 3, 
                   ListQ[
                    Part[VilTeX`Private`annotation, 3]]], 
                  VilTeX`Private`options = Part[VilTeX`Private`annotation, 3]; 
                  Do[
                    If[
                    And[
                    ListQ[
                    Part[VilTeX`Private`options, VilTeX`Private`j]], Length[
                    Part[VilTeX`Private`options, VilTeX`Private`j]] >= 2], 
                    Module[{VilTeX`Private`key, VilTeX`Private`val}, 
                    VilTeX`Private`key = ToString[
                    Part[
                    Part[VilTeX`Private`options, VilTeX`Private`j], 1]]; 
                    VilTeX`Private`val = ToString[
                    Part[
                    Part[VilTeX`Private`options, VilTeX`Private`j], 2]]; 
                    Which[VilTeX`Private`key == "color", 
                    VilTeX`Private`textOptions = 
                    VilTeX`Private`textOptions <> "text=" <> 
                    VilTeX`Private`val <> ",", VilTeX`Private`key == "size", 
                    VilTeX`Private`textOptions = 
                    VilTeX`Private`textOptions <> "font=" <> 
                    VilTeX`Private`val <> ",", VilTeX`Private`key == "anchor",
                     VilTeX`Private`textOptions = 
                    VilTeX`Private`textOptions <> "anchor=" <> 
                    VilTeX`Private`val <> ",", VilTeX`Private`key == "rotate",
                     VilTeX`Private`textOptions = 
                    VilTeX`Private`textOptions <> "rotate=" <> 
                    VilTeX`Private`val <> ",", True, 
                    VilTeX`Private`textOptions = 
                    VilTeX`Private`textOptions <> VilTeX`Private`key <> "=" <> 
                    VilTeX`Private`val <> ","]; Null]; Null], {
                    VilTeX`Private`j, 
                    Length[VilTeX`Private`options]}]; Null]; Null]; If[
                And[
                 StringQ[VilTeX`Private`text], VilTeX`Private`text != "", 
                 VilTeX`Private`validCoords, 
                 
                 AllTrue[{
                  VilTeX`Private`xPos, VilTeX`Private`yPos, 
                   VilTeX`Private`zPos}, NumericQ]], If[
                  And[
                  StringLength[VilTeX`Private`textOptions] > 0, 
                   StringTake[VilTeX`Private`textOptions, -1] == ","], 
                  VilTeX`Private`textOptions = 
                   StringDrop[VilTeX`Private`textOptions, -1]; Null]; 
                VilTeX`Private`textTikzCode = 
                 VilTeX`Private`textTikzCode <> "\\node[" <> 
                  VilTeX`Private`textOptions <> "] at (axis cs:" <> 
                  VilTeX`Private`formatNumber[VilTeX`Private`xPos] <> "," <> 
                  VilTeX`Private`formatNumber[VilTeX`Private`yPos] <> "," <> 
                  VilTeX`Private`formatNumber[VilTeX`Private`zPos] <> ") {" <> 
                  VilTeX`Private`text <> "};\n"; Null]; Null], {
             VilTeX`Private`i, 
              Length[VilTeX`Private`textAnnotations]}]; Null]; 
         VilTeX`Private`folderName = FileBaseName[VilTeX`Private`filename]; 
         VilTeX`Private`folderPath = 
          FileNameJoin[{$HomeDirectory, "Downloads", 
             VilTeX`Private`folderName}]; If[
           Not[
            DirectoryQ[VilTeX`Private`folderPath]], 
           CreateDirectory[VilTeX`Private`folderPath]]; 
         VilTeX`Private`downloadPath = 
          FileNameJoin[{VilTeX`Private`folderPath, VilTeX`Private`filename}]; 
         VilTeX`Private`tikzCode = 
          "\\begin{tikzpicture}\n\\begin{axis}[\n" <> 
           "  xlabel={$x$},\n  ylabel={$y$},\n  zlabel={$z$},\n" <> "  xmin=" <> 
           VilTeX`Private`formatNumber[
             Part[VilTeX`Private`globalLimits, 1]] <> ", xmax=" <> 
           VilTeX`Private`formatNumber[
             Part[VilTeX`Private`globalLimits, 2]] <> ",\n" <> "  ymin=" <> 
           VilTeX`Private`formatNumber[
             Part[VilTeX`Private`globalLimits, 3]] <> ", ymax=" <> 
           VilTeX`Private`formatNumber[
             Part[VilTeX`Private`globalLimits, 4]] <> ",\n" <> "  zmin=" <> 
           VilTeX`Private`formatNumber[
             Part[VilTeX`Private`globalLimits, 5]] <> ", zmax=" <> 
           VilTeX`Private`formatNumber[
             Part[VilTeX`Private`globalLimits, 6]] <> ",\n" <> 
           If[VilTeX`Private`grid, "  grid=major,\n", ""] <> 
           "  view={60}{30},\n" <> "  " <> VilTeX`Private`axisConfiguration <> 
           ",\n" <> "  axis equal=false,\n" <> "  samples=50,\n" <> 
           "  point meta=z,\n" <> "  " <> VilTeX`Private`colormapStyle <> 
           "\n" <> "]\n" <> VilTeX`Private`combinedTikzCode <> 
           VilTeX`Private`textTikzCode <> "\\end{axis}\n\\end{tikzpicture}"; 
         VilTeX`Private`fullDocument = 
          "\\documentclass[border=5mm]{standalone}\n" <> 
           "\\usepackage{tikz}\n\\usepackage{pgfplots}\n" <> 
           "\\usepackage{amsmath}\n\\usepackage{amssymb}\n" <> 
           "\\usetikzlibrary{arrows.meta}\n\\pgfplotsset{compat=1.18}\n" <> 
           
           "\\usepgfplotslibrary{colorbrewer}\n\
\\usepgfplotslibrary{colormaps}\n\n" <> "\\begin{document}\n" <> 
           VilTeX`Private`tikzCode <> "\n\\end{document}"; 
         Export[VilTeX`Private`downloadPath, VilTeX`Private`fullDocument, 
           "Text"]; VilTeX`Private`downloadPath]}], "SubValues" -> None, 
    "DefaultValues" -> None, "NValues" -> None, "FormatValues" -> None, 
    "Options" -> None, "Attributes" -> {Protected}, "FullName" -> 
    "VilTeX`ExportToTikZGraphics3D"|>, False]]], "Output",
 CellChangeTimes->{3.967214506559408*^9, 3.96727951905407*^9, 
  3.967287151539906*^9},
 CellLabel->"Out[2]=",ExpressionUUID->"a8d6ed59-e9d8-4c33-8fd0-b0f046b2d12f"]
}, Open  ]],

Cell["Las figuras s\[OAcute]lidas las represente mediante l\[IAcute]neas.", \
"Text",
 CellChangeTimes->{{3.9672820607646303`*^9, 
  3.967282064872548*^9}},ExpressionUUID->"7826d6d1-d18d-4694-8001-\
36822fc96e5f"],

Cell[CellGroupData[{

Cell["Ejemplo 1: punto 3D y proyecciones", "Subsection",
 CellChangeTimes->{{3.967211284283127*^9, 3.9672112867661*^9}, {
  3.967211535098854*^9, 
  3.9672115423330326`*^9}},ExpressionUUID->"4bfb5c35-4bc0-ce46-8221-\
ddd5c51f772c"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"graphics3D1", "=", 
   RowBox[{"Graphics3D", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Red", ",", 
         RowBox[{"PointSize", "[", "Large", "]"}], ",", 
         RowBox[{"Point", "[", 
          RowBox[{"{", 
           RowBox[{"2", ",", "3", ",", "4"}], "}"}], "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Blue", ",", 
         RowBox[{"PointSize", "[", "Medium", "]"}], ",", 
         RowBox[{"Point", "[", 
          RowBox[{"{", 
           RowBox[{"2", ",", "3", ",", "0"}], "}"}], "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Dashed", ",", "Gray", ",", 
         RowBox[{"Line", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0", ",", "3", ",", "0"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"2", ",", "3", ",", "0"}], "}"}]}], "}"}], "]"}], ",", 
         RowBox[{"Line", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"2", ",", "0", ",", "0"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"2", ",", "3", ",", "0"}], "}"}]}], "}"}], "]"}]}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Dashed", ",", "Black", ",", 
         RowBox[{"Line", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"2", ",", "3", ",", "0"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"2", ",", "3", ",", "4"}], "}"}]}], "}"}], "]"}]}], 
        "}"}]}], "}"}], ",", 
     RowBox[{"Axes", "->", "True"}], ",", 
     RowBox[{"AxesOrigin", "->", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], ",", 
     RowBox[{"AxesLabel", "->", 
      RowBox[{"{", 
       RowBox[{"\"\<x\>\"", ",", "\"\<y\>\"", ",", "\"\<z\>\""}], "}"}]}], ",", 
     RowBox[{"PlotRange", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "4"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "4"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "5"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"Boxed", "->", "False"}], ",", 
     RowBox[{"ImageSize", "->", "400"}]}], "]"}]}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"colortexto", "[", "]"}], ":=", 
     RowBox[{"RandomChoice", "[", 
      RowBox[{"{", 
       RowBox[{"\"\<black\>\"", ",", "\"\<blue\>\"", ",", "\"\<brown\>\"", 
        ",", "\"\<cyan\>\"", ",", "\"\<darkgray\>\"", ",", "\"\<gray\>\"", 
        ",", "\"\<green\>\"", ",", "\"\<lightgray\>\"", ",", "\"\<lime\>\"", 
        ",", "\"\<magenta\>\"", ",", "\"\<olive\>\"", ",", "\"\<orange\>\"", 
        ",", "\"\<pink\>\"", ",", "\"\<purple\>\"", ",", "\"\<red\>\"", 
        ",", "\"\<teal\>\"", ",", "\"\<violet\>\"", ",", "\"\<yellow\>\""}], 
       "}"}], "]"}]}], ",", 
    RowBox[{"sizetexto", "=", 
     RowBox[{"RandomChoice", "[", 
      RowBox[{"{", 
       RowBox[{"\"\<\\\\tiny\>\"", ",", "\"\<\\\\scriptsize\>\"", 
        ",", "\"\<\\\\footnotesize\>\"", ",", "\"\<\\\\small\>\"", 
        ",", "\"\<\\\\normalsize\>\"", ",", "\"\<\\\\large\>\"", 
        ",", "\"\<\\\\Large\>\"", ",", "\"\<\\\\huge\>\"", 
        ",", "\"\<\\\\Huge\>\""}], "}"}], "]"}]}], ",", 
    RowBox[{"anclajetexto", "=", 
     RowBox[{"RandomChoice", "[", 
      RowBox[{"{", 
       RowBox[{"\"\<north\>\"", ",", "\"\<south\>\"", ",", "\"\<east\>\"", 
        ",", "\"\<west\>\"", ",", "\"\<north east\>\"", 
        ",", "\"\<north west\>\"", ",", "\"\<south east\>\"", 
        ",", "\"\<south west\>\"", ",", "\"\<center\>\""}], "}"}], "]"}]}], ",", 
    RowBox[{"rotatexto", "=", 
     RowBox[{"RandomReal", "[", 
      RowBox[{"{", 
       RowBox[{"0", ",", "360"}], "}"}], "]"}]}]}], "}"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<grid=\>\"", ",", 
      RowBox[{"grid", "=", 
       RowBox[{"RandomChoice", "[", 
        RowBox[{"{", 
         RowBox[{"True", ",", "False"}], "}"}], "]"}]}]}], "}"}], "]"}], ",", 
   
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<estiloejes=\>\"", ",", 
      RowBox[{"estiloejes", "=", 
       RowBox[{"RandomChoice", "[", 
        RowBox[{"{", 
         RowBox[{"\"\<box\>\"", ",", "\"\<center\>\"", ",", "\"\<none\>\""}], 
         "}"}], "]"}]}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<extensionejes=\>\"", ",", 
      RowBox[{"extensionejes", "=", 
       RowBox[{"RandomReal", "[", 
        RowBox[{"{", 
         RowBox[{"0.1", ",", "0.4"}], "}"}], "]"}]}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<resolucion=\>\"", ",", 
      RowBox[{"resolucion", "=", 
       RowBox[{"RandomInteger", "[", 
        RowBox[{"{", 
         RowBox[{"20", ",", "80"}], "}"}], "]"}]}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<texto=\>\"", ",", 
      RowBox[{"texto", "=", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"\"\<P\>\"", ",", 
          RowBox[{"{", 
           RowBox[{"1.8", ",", "2.8", ",", "4"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"\"\<color\>\"", ",", 
              RowBox[{"colortexto", "[", "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"\"\<size\>\"", ",", "sizetexto"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"\"\<anchor\>\"", ",", "anclajetexto"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"\"\<rotate\>\"", ",", "rotatexto"}], "}"}]}], "}"}]}], 
         "}"}], "}"}]}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<maxpoligonos=\>\"", ",", 
      RowBox[{"maxpoligonos", "=", 
       RowBox[{"RandomInteger", "[", 
        RowBox[{"{", 
         RowBox[{"500", ",", "700"}], "}"}], "]"}]}]}], "}"}], "]"}]}], 
  "}"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ExportToTikZGraphics3D", "[", 
   RowBox[{
   "graphics3D1", ",", "\"\<graphics3D1.tex\>\"", ",", "grid", ",", 
    "estiloejes", ",", "extensionejes", ",", "resolucion", ",", "texto", ",", 
    "maxpoligonos"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.96721139462743*^9, 3.967211406553005*^9}, {
   3.9672120272232456`*^9, 3.9672120485633755`*^9}, {3.967212389256727*^9, 
   3.9672123907402782`*^9}, {3.967212482097864*^9, 3.967212482608532*^9}, {
   3.9672146001268044`*^9, 3.967214692298914*^9}, {3.9672147973696804`*^9, 
   3.9672148005059834`*^9}, 3.967214846001137*^9, {3.9672149032475815`*^9, 
   3.9672149556620617`*^9}, 3.967215452870323*^9, {3.967215570423504*^9, 
   3.967215597462204*^9}, {3.967215676385666*^9, 3.9672157763343735`*^9}, {
   3.967215807742014*^9, 3.96721582501672*^9}, {3.9672160112895126`*^9, 
   3.96721601172386*^9}, {3.9672743412325687`*^9, 3.967274347847803*^9}, 
   3.967274490189226*^9, 3.967279030965496*^9, {3.9672791716168833`*^9, 
   3.967279254428782*^9}, {3.9672793290582943`*^9, 3.967279414692215*^9}, {
   3.967279588609632*^9, 3.9672796050063972`*^9}, {3.96728010695135*^9, 
   3.967280107285057*^9}, {3.967280400334735*^9, 3.967280400757156*^9}, {
   3.967280506954006*^9, 3.967280507341713*^9}, {3.967281374586307*^9, 
   3.967281374739551*^9}, {3.967284035725741*^9, 3.967284039143269*^9}, {
   3.967284519059051*^9, 3.967284553711761*^9}, 3.967287174251904*^9, {
   3.967287390711729*^9, 3.967287394614809*^9}},
 CellLabel->"In[99]:=",ExpressionUUID->"c5d729d2-13c9-4348-9b84-413957f86b2e"],

Cell[BoxData[
 Graphics3DBox[{
   {RGBColor[1, 0, 0], PointSize[Large], Point3DBox[{2, 3, 4}]}, 
   {RGBColor[0, 0, 1], PointSize[Medium], Point3DBox[{2, 3, 0}]}, 
   {GrayLevel[0.5], Dashing[{Small, Small}], 
    Line3DBox[{{0, 3, 0}, {2, 3, 0}}], Line3DBox[{{2, 0, 0}, {2, 3, 0}}]}, 
   {GrayLevel[0], Dashing[{Small, Small}], Line3DBox[{{2, 3, 0}, {2, 3, 4}}]}},
  Axes->True,
  AxesLabel->{
    FormBox["\"x\"", TraditionalForm], 
    FormBox["\"y\"", TraditionalForm], 
    FormBox["\"z\"", TraditionalForm]},
  AxesOrigin->{0, 0, 0},
  Boxed->False,
  ImageSize->400,
  PlotRange->{{0, 4}, {0, 4}, {0, 5}}]], "Output",
 CellChangeTimes->{
  3.967215552405243*^9, 3.9672155985062885`*^9, {3.96721599270343*^9, 
   3.9672160127771225`*^9}, {3.967274282395938*^9, 3.967274348898608*^9}, {
   3.967279690222804*^9, 3.967279716139185*^9}, 3.967279747520599*^9, 
   3.967280114714796*^9, {3.9672804187083483`*^9, 3.967280429311152*^9}, {
   3.967280566228813*^9, 3.967280588985607*^9}, 3.967282557138435*^9, {
   3.967284519553315*^9, 3.96728455552967*^9}, {3.967287170094839*^9, 
   3.9672871831447783`*^9}, {3.967287642020393*^9, 3.967287652268321*^9}},
 CellLabel->"Out[99]=",ExpressionUUID->"8d7042c4-8cde-4f11-8cec-2280c015e55c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TemplateBox[{"\"grid=\"", "True"},
    "RowDefault"], ",", 
   TemplateBox[{"\"estiloejes=\"", "\"box\""},
    "RowDefault"], ",", 
   TemplateBox[{"\"extensionejes=\"", "0.17387908513021424`"},
    "RowDefault"], ",", 
   TemplateBox[{"\"resolucion=\"", "20"},
    "RowDefault"], ",", 
   TemplateBox[{"\"texto=\"", 
     RowBox[{"{", 
       RowBox[{"{", 
         RowBox[{"\"P\"", ",", 
           RowBox[{"{", 
             RowBox[{"1.8`", ",", "2.8`", ",", "4"}], "}"}], ",", 
           RowBox[{"{", 
             RowBox[{
               RowBox[{"{", 
                 RowBox[{"\"color\"", ",", "\"cyan\""}], "}"}], ",", 
               RowBox[{"{", 
                 RowBox[{"\"size\"", ",", "\"\\\\Large\""}], "}"}], ",", 
               RowBox[{"{", 
                 RowBox[{"\"anchor\"", ",", "\"south west\""}], "}"}], ",", 
               RowBox[{"{", 
                 RowBox[{"\"rotate\"", ",", "205.70200358359043`"}], "}"}]}], 
             "}"}]}], "}"}], "}"}]},
    "RowDefault"], ",", 
   TemplateBox[{"\"maxpoligonos=\"", "583"},
    "RowDefault"]}], "}"}]], "Output",
 CellChangeTimes->{
  3.967215552405243*^9, 3.9672155985062885`*^9, {3.96721599270343*^9, 
   3.9672160127771225`*^9}, {3.967274282395938*^9, 3.967274348898608*^9}, {
   3.967279690222804*^9, 3.967279716139185*^9}, 3.967279747520599*^9, 
   3.967280114714796*^9, {3.9672804187083483`*^9, 3.967280429311152*^9}, {
   3.967280566228813*^9, 3.967280588985607*^9}, 3.967282557138435*^9, {
   3.967284519553315*^9, 3.96728455552967*^9}, {3.967287170094839*^9, 
   3.9672871831447783`*^9}, {3.967287642020393*^9, 3.967287652271758*^9}},
 CellLabel->
  "Out[101]=",ExpressionUUID->"b896d4c2-5a51-4e24-a3df-f78962b26fe2"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.967287175241199*^9, 3.9672871831492643`*^9}, {
  3.967287642024612*^9, 3.967287652272839*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[99]:=",ExpressionUUID->"6d52ab9a-74ad-414a-9104-ae10d91f14a3"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{{3.967287175241199*^9, 3.9672871831492643`*^9}, {
  3.967287642024612*^9, 3.967287652273347*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[99]:=",ExpressionUUID->"b42ae595-4fd8-49b3-bd51-450d3aa45438"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.967287175241199*^9, 3.9672871831492643`*^9}, {
  3.967287642024612*^9, 3.967287652273937*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[99]:=",ExpressionUUID->"c9383888-c594-43ed-b042-bb25de47449a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.967287175241199*^9, 3.9672871831492643`*^9}, {
  3.967287642024612*^9, 3.967287652274334*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[99]:=",ExpressionUUID->"25130a1a-711d-42c7-a4a6-a1b764778be5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.967287175241199*^9, 3.9672871831492643`*^9}, {
  3.967287642024612*^9, 3.9672876522747307`*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[99]:=",ExpressionUUID->"eab5e7ff-cdec-49a1-a54d-36f6021f5dd9"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{{3.967287175241199*^9, 3.9672871831492643`*^9}, {
  3.967287642024612*^9, 3.967287652356749*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[99]:=",ExpressionUUID->"1838ba31-c1e6-4d98-95e2-08cb2d9cd34b"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{{3.967287175241199*^9, 3.9672871831492643`*^9}, {
  3.967287642024612*^9, 3.967287653363933*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[99]:=",ExpressionUUID->"671e2fa0-fed9-4fe8-a2b6-c924397b7372"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/graphics3D1/\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", 
   "/Users/enriquevilchezquesada/Downloads/graphics3D1/"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.967287175241199*^9, 3.9672871831492643`*^9}, {
  3.967287642024612*^9, 3.967287653368374*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[99]:=",ExpressionUUID->"13ae444a-28ca-4529-b0e9-8dd9c49b9ffd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"graphics3D1\"\>"}],
  SequenceForm["Archivo: ", "graphics3D1"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.967287175241199*^9, 3.9672871831492643`*^9}, {
  3.967287642024612*^9, 3.967287653371179*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[99]:=",ExpressionUUID->"6bdb1e5e-e706-4417-ab4c-731672922d94"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{{3.967287175241199*^9, 3.9672871831492643`*^9}, {
  3.967287642024612*^9, 3.967287654083664*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[99]:=",ExpressionUUID->"74b0861f-dc83-4374-9d8d-879993821e34"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/graphics3D1/graphics3D1.pdf\"\>"}],
  SequenceForm[
  "PDF generado: ", 
   "/Users/enriquevilchezquesada/Downloads/graphics3D1/graphics3D1.pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.967287175241199*^9, 3.9672871831492643`*^9}, {
  3.967287642024612*^9, 3.967287654084326*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[99]:=",ExpressionUUID->"2bfb3f7a-49c9-486e-95fd-9ab450fbf488"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/graphics3D1/\
graphics3D1.pdf\"\>"], "Output",
 CellChangeTimes->{
  3.967215552405243*^9, 3.9672155985062885`*^9, {3.96721599270343*^9, 
   3.9672160127771225`*^9}, {3.967274282395938*^9, 3.967274348898608*^9}, {
   3.967279690222804*^9, 3.967279716139185*^9}, 3.967279747520599*^9, 
   3.967280114714796*^9, {3.9672804187083483`*^9, 3.967280429311152*^9}, {
   3.967280566228813*^9, 3.967280588985607*^9}, 3.967282557138435*^9, {
   3.967284519553315*^9, 3.96728455552967*^9}, {3.967287170094839*^9, 
   3.9672871831447783`*^9}, {3.967287642020393*^9, 3.967287654096949*^9}},
 CellLabel->
  "Out[103]=",ExpressionUUID->"c9afb4c2-dbf2-4720-a933-9b7715b77a4e"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejemplo 2: punto 3D y proyecciones", "Subsection",
 CellChangeTimes->{{3.967211284283127*^9, 3.9672112867661*^9}, 
   3.9672113289079113`*^9, {3.967211564210745*^9, 3.9672115653601*^9}, {
   3.967281587556677*^9, 3.9672815959400587`*^9}, {3.967281910263844*^9, 
   3.967281910635149*^9}},ExpressionUUID->"4580ff4c-ec6d-9a4c-96bb-\
c01048f5343a"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"graphics3D2", "=", 
   RowBox[{"Graphics3D", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Thick", ",", 
         RowBox[{"Arrow", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"1", ",", 
              RowBox[{"-", "1"}], ",", "4"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"2", ",", "3", ",", "4"}], "}"}]}], "}"}], "]"}]}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Red", ",", 
         RowBox[{"PointSize", "[", "Large", "]"}], ",", 
         RowBox[{"Point", "[", 
          RowBox[{"{", 
           RowBox[{"2", ",", "3", ",", "4"}], "}"}], "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Red", ",", 
         RowBox[{"PointSize", "[", "Large", "]"}], ",", 
         RowBox[{"Point", "[", 
          RowBox[{"{", 
           RowBox[{"1", ",", 
            RowBox[{"-", "1"}], ",", "4"}], "}"}], "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Blue", ",", 
         RowBox[{"PointSize", "[", "Medium", "]"}], ",", 
         RowBox[{"Point", "[", 
          RowBox[{"{", 
           RowBox[{"2", ",", "3", ",", "0"}], "}"}], "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Blue", ",", 
         RowBox[{"PointSize", "[", "Medium", "]"}], ",", 
         RowBox[{"Point", "[", 
          RowBox[{"{", 
           RowBox[{"1", ",", 
            RowBox[{"-", "1"}], ",", "0"}], "}"}], "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Dashed", ",", "Gray", ",", 
         RowBox[{"Line", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0", ",", "3", ",", "0"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"2", ",", "3", ",", "0"}], "}"}]}], "}"}], "]"}], ",", 
         RowBox[{"Line", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"2", ",", "0", ",", "0"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"2", ",", "3", ",", "0"}], "}"}]}], "}"}], "]"}]}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Dashed", ",", "Gray", ",", 
         RowBox[{"Line", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0", ",", 
              RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", 
              RowBox[{"-", "1"}], ",", "0"}], "}"}]}], "}"}], "]"}], ",", 
         RowBox[{"Line", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", 
              RowBox[{"-", "1"}], ",", "0"}], "}"}]}], "}"}], "]"}]}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{"Dashed", ",", "Black", ",", 
         RowBox[{"Line", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"2", ",", "3", ",", "0"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"2", ",", "3", ",", "4"}], "}"}]}], "}"}], "]"}]}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Dashed", ",", "Black", ",", 
         RowBox[{"Line", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"1", ",", 
              RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", 
              RowBox[{"-", "1"}], ",", "4"}], "}"}]}], "}"}], "]"}]}], 
        "}"}]}], "}"}], ",", 
     RowBox[{"Axes", "->", "True"}], ",", 
     RowBox[{"AxesOrigin", "->", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], ",", 
     RowBox[{"AxesLabel", "->", 
      RowBox[{"{", 
       RowBox[{"\"\<x\>\"", ",", "\"\<y\>\"", ",", "\"\<z\>\""}], "}"}]}], ",", 
     RowBox[{"PlotRange", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "4"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "4"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "5"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"Boxed", "->", "False"}], ",", 
     RowBox[{"ImageSize", "->", "450"}]}], "]"}]}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"colortexto", "[", "]"}], ":=", 
     RowBox[{"RandomChoice", "[", 
      RowBox[{"{", 
       RowBox[{"\"\<black\>\"", ",", "\"\<blue\>\"", ",", "\"\<brown\>\"", 
        ",", "\"\<cyan\>\"", ",", "\"\<darkgray\>\"", ",", "\"\<gray\>\"", 
        ",", "\"\<green\>\"", ",", "\"\<lightgray\>\"", ",", "\"\<lime\>\"", 
        ",", "\"\<magenta\>\"", ",", "\"\<olive\>\"", ",", "\"\<orange\>\"", 
        ",", "\"\<pink\>\"", ",", "\"\<purple\>\"", ",", "\"\<red\>\"", 
        ",", "\"\<teal\>\"", ",", "\"\<violet\>\"", ",", "\"\<yellow\>\""}], 
       "}"}], "]"}]}], ",", 
    RowBox[{"sizetexto", "=", 
     RowBox[{"RandomChoice", "[", 
      RowBox[{"{", 
       RowBox[{"\"\<\\\\tiny\>\"", ",", "\"\<\\\\scriptsize\>\"", 
        ",", "\"\<\\\\footnotesize\>\"", ",", "\"\<\\\\small\>\"", 
        ",", "\"\<\\\\normalsize\>\"", ",", "\"\<\\\\large\>\"", 
        ",", "\"\<\\\\Large\>\"", ",", "\"\<\\\\huge\>\"", 
        ",", "\"\<\\\\Huge\>\""}], "}"}], "]"}]}], ",", 
    RowBox[{"anclajetexto", "=", 
     RowBox[{"RandomChoice", "[", 
      RowBox[{"{", 
       RowBox[{"\"\<north\>\"", ",", "\"\<south\>\"", ",", "\"\<east\>\"", 
        ",", "\"\<west\>\"", ",", "\"\<north east\>\"", 
        ",", "\"\<north west\>\"", ",", "\"\<south east\>\"", 
        ",", "\"\<south west\>\"", ",", "\"\<center\>\""}], "}"}], "]"}]}], ",", 
    RowBox[{"rotatexto", "=", 
     RowBox[{"RandomReal", "[", 
      RowBox[{"{", 
       RowBox[{"0", ",", "360"}], "}"}], "]"}]}]}], "}"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<grid=\>\"", ",", 
      RowBox[{"grid", "=", 
       RowBox[{"RandomChoice", "[", 
        RowBox[{"{", 
         RowBox[{"True", ",", "False"}], "}"}], "]"}]}]}], "}"}], "]"}], ",", 
   
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<estiloejes=\>\"", ",", 
      RowBox[{"estiloejes", "=", 
       RowBox[{"RandomChoice", "[", 
        RowBox[{"{", 
         RowBox[{"\"\<box\>\"", ",", "\"\<center\>\"", ",", "\"\<none\>\""}], 
         "}"}], "]"}]}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<extensionejes=\>\"", ",", 
      RowBox[{"extensionejes", "=", 
       RowBox[{"RandomReal", "[", 
        RowBox[{"{", 
         RowBox[{"0.1", ",", "0.4"}], "}"}], "]"}]}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<resolucion=\>\"", ",", 
      RowBox[{"resolucion", "=", 
       RowBox[{"RandomInteger", "[", 
        RowBox[{"{", 
         RowBox[{"20", ",", "80"}], "}"}], "]"}]}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<texto=\>\"", ",", 
      RowBox[{"texto", "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\"\<P\>\"", ",", 
           RowBox[{"{", 
            RowBox[{"2", ",", "3", ",", "4.1"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"\"\<color\>\"", ",", 
               RowBox[{"colortexto", "[", "]"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"\"\<size\>\"", ",", "sizetexto"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"\"\<anchor\>\"", ",", "anclajetexto"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"\"\<rotate\>\"", ",", "rotatexto"}], "}"}]}], "}"}]}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\"\<Q\>\"", ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", 
             RowBox[{"-", "1"}], ",", "4.1"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"\"\<color\>\"", ",", 
               RowBox[{"colortexto", "[", "]"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"\"\<size\>\"", ",", "sizetexto"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"\"\<anchor\>\"", ",", "anclajetexto"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"\"\<rotate\>\"", ",", "rotatexto"}], "}"}]}], "}"}]}], 
          "}"}]}], "}"}]}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<maxpoligonos=\>\"", ",", 
      RowBox[{"maxpoligonos", "=", 
       RowBox[{"RandomInteger", "[", 
        RowBox[{"{", 
         RowBox[{"500", ",", "700"}], "}"}], "]"}]}]}], "}"}], "]"}]}], 
  "}"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ExportToTikZGraphics3D", "[", 
   RowBox[{
   "graphics3D2", ",", "\"\<graphics3D2.tex\>\"", ",", "grid", ",", 
    "estiloejes", ",", "extensionejes", ",", "resolucion", ",", "texto", ",", 
    "maxpoligonos"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.967211991362499*^9, 3.9672120140106354`*^9}, {
   3.9672123962386665`*^9, 3.9672123967482967`*^9}, {3.9672124874296055`*^9, 
   3.9672124878255672`*^9}, {3.9672150176821575`*^9, 3.9672150332693996`*^9}, 
   3.967215386115305*^9, 3.9672154594424057`*^9, {3.9672158539578285`*^9, 
   3.9672158548764343`*^9}, {3.967216037824951*^9, 3.967216038271801*^9}, 
   3.9672744998388863`*^9, {3.9672797811257887`*^9, 3.967279797934697*^9}, {
   3.967279937594502*^9, 3.967279970807044*^9}, {3.967280055667509*^9, 
   3.9672800560243397`*^9}, {3.9672803841733828`*^9, 3.967280384600472*^9}, {
   3.967280519560376*^9, 3.967280520735732*^9}, {3.967281365587994*^9, 
   3.9672813659298487`*^9}, {3.9672840491529617`*^9, 
   3.9672840547896852`*^9}, {3.96728450386901*^9, 3.967284504065652*^9}, 
   3.967287195531535*^9, 3.967287447329976*^9},
 CellLabel->
  "In[124]:=",ExpressionUUID->"5cd43e18-a68b-f149-b75b-b8f8378696d1"],

Cell[BoxData[
 Graphics3DBox[{
   {Thickness[Large], Arrow3DBox[{{1, -1, 4}, {2, 3, 4}}]}, 
   {RGBColor[1, 0, 0], PointSize[Large], Point3DBox[{2, 3, 4}]}, 
   {RGBColor[1, 0, 0], PointSize[Large], Point3DBox[{1, -1, 4}]}, 
   {RGBColor[0, 0, 1], PointSize[Medium], Point3DBox[{2, 3, 0}]}, 
   {RGBColor[0, 0, 1], PointSize[Medium], Point3DBox[{1, -1, 0}]}, 
   {GrayLevel[0.5], Dashing[{Small, Small}], 
    Line3DBox[{{0, 3, 0}, {2, 3, 0}}], Line3DBox[{{2, 0, 0}, {2, 3, 0}}]}, 
   {GrayLevel[0.5], Dashing[{Small, Small}], 
    Line3DBox[{{0, -1, 0}, {1, -1, 0}}], 
    Line3DBox[{{1, 0, 0}, {1, -1, 0}}]}, 
   {GrayLevel[0], Dashing[{Small, Small}], Line3DBox[{{2, 3, 0}, {2, 3, 4}}]}, 
   {GrayLevel[0], Dashing[{Small, Small}], 
    Line3DBox[{{1, -1, 0}, {1, -1, 4}}]}},
  Axes->True,
  AxesLabel->{
    FormBox["\"x\"", TraditionalForm], 
    FormBox["\"y\"", TraditionalForm], 
    FormBox["\"z\"", TraditionalForm]},
  AxesOrigin->{0, 0, 0},
  Boxed->False,
  ImageSize->450,
  PlotRange->{{0, 4}, {0, 4}, {0, 5}}]], "Output",
 CellChangeTimes->{
  3.967279803754101*^9, {3.9672799739827538`*^9, 3.967279994639979*^9}, {
   3.967280141795532*^9, 3.967280164844252*^9}, {3.967280602283057*^9, 
   3.967280626813622*^9}, 3.96728254709662*^9, 3.967284504385272*^9, {
   3.967287197224574*^9, 3.9672872112624493`*^9}, {3.967287662925346*^9, 
   3.967287686583912*^9}},
 CellLabel->
  "Out[124]=",ExpressionUUID->"0587606c-654c-486a-a136-f578a2f34043"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TemplateBox[{"\"grid=\"", "True"},
    "RowDefault"], ",", 
   TemplateBox[{"\"estiloejes=\"", "\"center\""},
    "RowDefault"], ",", 
   TemplateBox[{"\"extensionejes=\"", "0.3750247409615905`"},
    "RowDefault"], ",", 
   TemplateBox[{"\"resolucion=\"", "50"},
    "RowDefault"], ",", 
   TemplateBox[{"\"texto=\"", 
     RowBox[{"{", 
       RowBox[{
         RowBox[{"{", 
           RowBox[{"\"P\"", ",", 
             RowBox[{"{", 
               RowBox[{"2", ",", "3", ",", "4.1`"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"\"color\"", ",", "\"gray\""}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"\"size\"", ",", "\"\\\\large\""}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"\"anchor\"", ",", "\"north west\""}], "}"}], ",", 
                 
                 RowBox[{"{", 
                   RowBox[{"\"rotate\"", ",", "303.77503121306927`"}], 
                   "}"}]}], "}"}]}], "}"}], ",", 
         RowBox[{"{", 
           RowBox[{"\"Q\"", ",", 
             RowBox[{"{", 
               RowBox[{"1", ",", 
                 RowBox[{"-", "1"}], ",", "4.1`"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"\"color\"", ",", "\"violet\""}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"\"size\"", ",", "\"\\\\large\""}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"\"anchor\"", ",", "\"north west\""}], "}"}], ",", 
                 
                 RowBox[{"{", 
                   RowBox[{"\"rotate\"", ",", "303.77503121306927`"}], 
                   "}"}]}], "}"}]}], "}"}]}], "}"}]},
    "RowDefault"], ",", 
   TemplateBox[{"\"maxpoligonos=\"", "501"},
    "RowDefault"]}], "}"}]], "Output",
 CellChangeTimes->{
  3.967279803754101*^9, {3.9672799739827538`*^9, 3.967279994639979*^9}, {
   3.967280141795532*^9, 3.967280164844252*^9}, {3.967280602283057*^9, 
   3.967280626813622*^9}, 3.96728254709662*^9, 3.967284504385272*^9, {
   3.967287197224574*^9, 3.9672872112624493`*^9}, {3.967287662925346*^9, 
   3.967287686587759*^9}},
 CellLabel->
  "Out[126]=",ExpressionUUID->"b862fd3c-1578-4784-9474-028c848f0971"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967279803761465*^9, {3.967279973987245*^9, 3.967279994644557*^9}, {
   3.967280141800198*^9, 3.96728016484862*^9}, {3.9672806022877903`*^9, 
   3.9672806268182497`*^9}, 3.9672825471012583`*^9, 3.9672845044320498`*^9, {
   3.96728719722922*^9, 3.96728721126742*^9}, {3.967287662929553*^9, 
   3.967287686588958*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[124]:=",ExpressionUUID->"578077ac-d8b3-466b-8727-04a88665393b"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{
  3.967279803761465*^9, {3.967279973987245*^9, 3.967279994644557*^9}, {
   3.967280141800198*^9, 3.96728016484862*^9}, {3.9672806022877903`*^9, 
   3.9672806268182497`*^9}, 3.9672825471012583`*^9, 3.9672845044320498`*^9, {
   3.96728719722922*^9, 3.96728721126742*^9}, {3.967287662929553*^9, 
   3.967287686589446*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[124]:=",ExpressionUUID->"cdc1703a-91c5-4624-ad89-31e58840c847"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967279803761465*^9, {3.967279973987245*^9, 3.967279994644557*^9}, {
   3.967280141800198*^9, 3.96728016484862*^9}, {3.9672806022877903`*^9, 
   3.9672806268182497`*^9}, 3.9672825471012583`*^9, 3.9672845044320498`*^9, {
   3.96728719722922*^9, 3.96728721126742*^9}, {3.967287662929553*^9, 
   3.967287686590021*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[124]:=",ExpressionUUID->"74ce5ee2-e127-4619-94d0-e14aa3483b55"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967279803761465*^9, {3.967279973987245*^9, 3.967279994644557*^9}, {
   3.967280141800198*^9, 3.96728016484862*^9}, {3.9672806022877903`*^9, 
   3.9672806268182497`*^9}, 3.9672825471012583`*^9, 3.9672845044320498`*^9, {
   3.96728719722922*^9, 3.96728721126742*^9}, {3.967287662929553*^9, 
   3.9672876865903997`*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[124]:=",ExpressionUUID->"dfb9426d-83be-47cc-b244-4a72e4ed423d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967279803761465*^9, {3.967279973987245*^9, 3.967279994644557*^9}, {
   3.967280141800198*^9, 3.96728016484862*^9}, {3.9672806022877903`*^9, 
   3.9672806268182497`*^9}, 3.9672825471012583`*^9, 3.9672845044320498`*^9, {
   3.96728719722922*^9, 3.96728721126742*^9}, {3.967287662929553*^9, 
   3.9672876865907717`*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[124]:=",ExpressionUUID->"ecd66d8b-4a67-41c5-823a-b27c9742ba5d"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{
  3.967279803761465*^9, {3.967279973987245*^9, 3.967279994644557*^9}, {
   3.967280141800198*^9, 3.96728016484862*^9}, {3.9672806022877903`*^9, 
   3.9672806268182497`*^9}, 3.9672825471012583`*^9, 3.9672845044320498`*^9, {
   3.96728719722922*^9, 3.96728721126742*^9}, {3.967287662929553*^9, 
   3.9672876866755047`*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[124]:=",ExpressionUUID->"4bb98800-2f01-414d-b46f-e92654c916ac"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{
  3.967279803761465*^9, {3.967279973987245*^9, 3.967279994644557*^9}, {
   3.967280141800198*^9, 3.96728016484862*^9}, {3.9672806022877903`*^9, 
   3.9672806268182497`*^9}, 3.9672825471012583`*^9, 3.9672845044320498`*^9, {
   3.96728719722922*^9, 3.96728721126742*^9}, {3.967287662929553*^9, 
   3.967287687683036*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[124]:=",ExpressionUUID->"7934b843-4192-49d5-9add-e1eb17aea0b9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/graphics3D2/\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", 
   "/Users/enriquevilchezquesada/Downloads/graphics3D2/"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967279803761465*^9, {3.967279973987245*^9, 3.967279994644557*^9}, {
   3.967280141800198*^9, 3.96728016484862*^9}, {3.9672806022877903`*^9, 
   3.9672806268182497`*^9}, 3.9672825471012583`*^9, 3.9672845044320498`*^9, {
   3.96728719722922*^9, 3.96728721126742*^9}, {3.967287662929553*^9, 
   3.9672876876869593`*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[124]:=",ExpressionUUID->"d0f24973-7b79-4964-be3a-8478fcc7f2d9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"graphics3D2\"\>"}],
  SequenceForm["Archivo: ", "graphics3D2"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967279803761465*^9, {3.967279973987245*^9, 3.967279994644557*^9}, {
   3.967280141800198*^9, 3.96728016484862*^9}, {3.9672806022877903`*^9, 
   3.9672806268182497`*^9}, 3.9672825471012583`*^9, 3.9672845044320498`*^9, {
   3.96728719722922*^9, 3.96728721126742*^9}, {3.967287662929553*^9, 
   3.967287687689857*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[124]:=",ExpressionUUID->"98b731ed-5f24-4bee-b182-123ca135bb42"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{
  3.967279803761465*^9, {3.967279973987245*^9, 3.967279994644557*^9}, {
   3.967280141800198*^9, 3.96728016484862*^9}, {3.9672806022877903`*^9, 
   3.9672806268182497`*^9}, 3.9672825471012583`*^9, 3.9672845044320498`*^9, {
   3.96728719722922*^9, 3.96728721126742*^9}, {3.967287662929553*^9, 
   3.9672876884187326`*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[124]:=",ExpressionUUID->"be186814-12a4-4383-9cf5-7ee1e646d90e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/graphics3D2/graphics3D2.pdf\"\>"}],
  SequenceForm[
  "PDF generado: ", 
   "/Users/enriquevilchezquesada/Downloads/graphics3D2/graphics3D2.pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967279803761465*^9, {3.967279973987245*^9, 3.967279994644557*^9}, {
   3.967280141800198*^9, 3.96728016484862*^9}, {3.9672806022877903`*^9, 
   3.9672806268182497`*^9}, 3.9672825471012583`*^9, 3.9672845044320498`*^9, {
   3.96728719722922*^9, 3.96728721126742*^9}, {3.967287662929553*^9, 
   3.967287688419395*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[124]:=",ExpressionUUID->"10ecb6bf-35b1-4281-b215-0e18600e31b1"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/graphics3D2/\
graphics3D2.pdf\"\>"], "Output",
 CellChangeTimes->{
  3.967279803754101*^9, {3.9672799739827538`*^9, 3.967279994639979*^9}, {
   3.967280141795532*^9, 3.967280164844252*^9}, {3.967280602283057*^9, 
   3.967280626813622*^9}, 3.96728254709662*^9, 3.967284504385272*^9, {
   3.967287197224574*^9, 3.9672872112624493`*^9}, {3.967287662925346*^9, 
   3.967287688431958*^9}},
 CellLabel->
  "Out[128]=",ExpressionUUID->"91298b66-d227-4a5d-ba6d-abf13653779f"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejemplo 3: lista de puntos", "Subsection",
 CellChangeTimes->{{3.967211284283127*^9, 3.9672112867661*^9}, 
   3.9672113303947315`*^9, {3.967211579217535*^9, 3.967211585931217*^9}, {
   3.9672816060962257`*^9, 3.967281606922429*^9}, {3.9672818985347147`*^9, 
   3.967281898949917*^9}},ExpressionUUID->"abb7be94-5fe8-334d-a2a8-\
d2a4944b0ebd"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"puntos", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"graphics3D3", "=", 
   RowBox[{"Graphics3D", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Black", ",", 
       RowBox[{"PointSize", "[", "Large", "]"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"Point", "[", "#", "]"}], "&"}], "/@", "puntos"}]}], "}"}], ",", 
     RowBox[{"Axes", "->", "True"}], ",", 
     RowBox[{"AxesLabel", "->", 
      RowBox[{"{", 
       RowBox[{"\"\<x\>\"", ",", "\"\<y\>\"", ",", "\"\<z\>\""}], "}"}]}]}], 
    "]"}]}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"colortexto", "[", "]"}], ":=", 
     RowBox[{"RandomChoice", "[", 
      RowBox[{"{", 
       RowBox[{"\"\<black\>\"", ",", "\"\<blue\>\"", ",", "\"\<brown\>\"", 
        ",", "\"\<cyan\>\"", ",", "\"\<darkgray\>\"", ",", "\"\<gray\>\"", 
        ",", "\"\<green\>\"", ",", "\"\<lightgray\>\"", ",", "\"\<lime\>\"", 
        ",", "\"\<magenta\>\"", ",", "\"\<olive\>\"", ",", "\"\<orange\>\"", 
        ",", "\"\<pink\>\"", ",", "\"\<purple\>\"", ",", "\"\<red\>\"", 
        ",", "\"\<teal\>\"", ",", "\"\<violet\>\"", ",", "\"\<yellow\>\""}], 
       "}"}], "]"}]}], ",", 
    RowBox[{"sizetexto", "=", 
     RowBox[{"RandomChoice", "[", 
      RowBox[{"{", 
       RowBox[{"\"\<\\\\tiny\>\"", ",", "\"\<\\\\scriptsize\>\"", 
        ",", "\"\<\\\\footnotesize\>\"", ",", "\"\<\\\\small\>\"", 
        ",", "\"\<\\\\normalsize\>\"", ",", "\"\<\\\\large\>\"", 
        ",", "\"\<\\\\Large\>\"", ",", "\"\<\\\\huge\>\"", 
        ",", "\"\<\\\\Huge\>\""}], "}"}], "]"}]}], ",", 
    RowBox[{"anclajetexto", "=", 
     RowBox[{"RandomChoice", "[", 
      RowBox[{"{", 
       RowBox[{"\"\<north\>\"", ",", "\"\<south\>\"", ",", "\"\<east\>\"", 
        ",", "\"\<west\>\"", ",", "\"\<north east\>\"", 
        ",", "\"\<north west\>\"", ",", "\"\<south east\>\"", 
        ",", "\"\<south west\>\"", ",", "\"\<center\>\""}], "}"}], "]"}]}], ",", 
    RowBox[{"rotatexto", "=", 
     RowBox[{"RandomReal", "[", 
      RowBox[{"{", 
       RowBox[{"0", ",", "360"}], "}"}], "]"}]}]}], "}"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<grid=\>\"", ",", 
      RowBox[{"grid", "=", 
       RowBox[{"RandomChoice", "[", 
        RowBox[{"{", 
         RowBox[{"True", ",", "False"}], "}"}], "]"}]}]}], "}"}], "]"}], ",", 
   
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<estiloejes=\>\"", ",", 
      RowBox[{"estiloejes", "=", 
       RowBox[{"RandomChoice", "[", 
        RowBox[{"{", 
         RowBox[{"\"\<box\>\"", ",", "\"\<center\>\"", ",", "\"\<none\>\""}], 
         "}"}], "]"}]}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<extensionejes=\>\"", ",", 
      RowBox[{"extensionejes", "=", 
       RowBox[{"RandomReal", "[", 
        RowBox[{"{", 
         RowBox[{"0.1", ",", "0.4"}], "}"}], "]"}]}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<resolucion=\>\"", ",", 
      RowBox[{"resolucion", "=", 
       RowBox[{"RandomInteger", "[", 
        RowBox[{"{", 
         RowBox[{"20", ",", "80"}], "}"}], "]"}]}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<texto=\>\"", ",", 
      RowBox[{"texto", "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\"\<A\>\"", ",", 
           RowBox[{
            RowBox[{"puntos", "[", 
             RowBox[{"[", "1", "]"}], "]"}], "+", 
            RowBox[{
             RowBox[{"RandomChoice", "[", 
              RowBox[{"{", 
               RowBox[{"1", ",", 
                RowBox[{"-", "1"}]}], "}"}], "]"}], "0.01"}]}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"\"\<color\>\"", ",", 
               RowBox[{"colortexto", "[", "]"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"\"\<size\>\"", ",", "sizetexto"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"\"\<anchor\>\"", ",", "anclajetexto"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"\"\<rotate\>\"", ",", "rotatexto"}], "}"}]}], "}"}]}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\"\<B\>\"", ",", 
           RowBox[{
            RowBox[{"puntos", "[", 
             RowBox[{"[", "2", "]"}], "]"}], "+", 
            RowBox[{
             RowBox[{"RandomChoice", "[", 
              RowBox[{"{", 
               RowBox[{"1", ",", 
                RowBox[{"-", "1"}]}], "}"}], "]"}], "0.01"}]}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"\"\<color\>\"", ",", 
               RowBox[{"colortexto", "[", "]"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"\"\<size\>\"", ",", "sizetexto"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"\"\<anchor\>\"", ",", "anclajetexto"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"\"\<rotate\>\"", ",", "rotatexto"}], "}"}]}], "}"}]}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\"\<C\>\"", ",", 
           RowBox[{
            RowBox[{"puntos", "[", 
             RowBox[{"[", "3", "]"}], "]"}], "+", 
            RowBox[{
             RowBox[{"RandomChoice", "[", 
              RowBox[{"{", 
               RowBox[{"1", ",", 
                RowBox[{"-", "1"}]}], "}"}], "]"}], "0.01"}]}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"\"\<color\>\"", ",", 
               RowBox[{"colortexto", "[", "]"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"\"\<size\>\"", ",", "sizetexto"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"\"\<anchor\>\"", ",", "anclajetexto"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"\"\<rotate\>\"", ",", "rotatexto"}], "}"}]}], "}"}]}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\"\<D\>\"", ",", 
           RowBox[{
            RowBox[{"puntos", "[", 
             RowBox[{"[", "4", "]"}], "]"}], "+", 
            RowBox[{
             RowBox[{"RandomChoice", "[", 
              RowBox[{"{", 
               RowBox[{"1", ",", 
                RowBox[{"-", "1"}]}], "}"}], "]"}], "0.01"}]}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"\"\<color\>\"", ",", 
               RowBox[{"colortexto", "[", "]"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"\"\<size\>\"", ",", "sizetexto"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"\"\<anchor\>\"", ",", "anclajetexto"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"\"\<rotate\>\"", ",", "rotatexto"}], "}"}]}], "}"}]}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\"\<E\>\"", ",", 
           RowBox[{
            RowBox[{"puntos", "[", 
             RowBox[{"[", "5", "]"}], "]"}], "+", 
            RowBox[{
             RowBox[{"RandomChoice", "[", 
              RowBox[{"{", 
               RowBox[{"1", ",", 
                RowBox[{"-", "1"}]}], "}"}], "]"}], "0.01"}]}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"\"\<color\>\"", ",", 
               RowBox[{"colortexto", "[", "]"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"\"\<size\>\"", ",", "sizetexto"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"\"\<anchor\>\"", ",", "anclajetexto"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"\"\<rotate\>\"", ",", "rotatexto"}], "}"}]}], "}"}]}], 
          "}"}]}], "}"}]}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<maxpoligonos=\>\"", ",", 
      RowBox[{"maxpoligonos", "=", 
       RowBox[{"RandomInteger", "[", 
        RowBox[{"{", 
         RowBox[{"500", ",", "700"}], "}"}], "]"}]}]}], "}"}], "]"}]}], 
  "}"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ExportToTikZGraphics3D", "[", 
   RowBox[{
   "graphics3D3", ",", "\"\<graphics3D3.tex\>\"", ",", "grid", ",", 
    "estiloejes", ",", "extensionejes", ",", "resolucion", ",", "texto", ",", 
    "maxpoligonos"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.967211972311716*^9, 3.967211982417364*^9}, {
   3.96721240147287*^9, 3.967212402534252*^9}, {3.9672124942264614`*^9, 
   3.9672124945783615`*^9}, 3.9672150502232933`*^9, 3.9672150924303894`*^9, 
   3.9672153899999905`*^9, 3.9672154645575123`*^9, {3.9672158643243084`*^9, 
   3.9672158652836685`*^9}, {3.9672160492134953`*^9, 3.9672160495582466`*^9}, 
   3.967274507764784*^9, {3.967280198768531*^9, 3.967280199824513*^9}, {
   3.967280365642086*^9, 3.9672803660550613`*^9}, {3.967280529749798*^9, 
   3.9672805301745243`*^9}, {3.967280779213264*^9, 3.9672809088906918`*^9}, {
   3.967280948347851*^9, 3.967281002992962*^9}, {3.967281352053876*^9, 
   3.967281352337358*^9}, {3.967281545087121*^9, 3.967281547867146*^9}, {
   3.9672840640142107`*^9, 3.9672840670889874`*^9}, {3.967284481853732*^9, 
   3.967284482155991*^9}, 3.9672872226743517`*^9, 3.967287459090385*^9},
 CellLabel->
  "In[159]:=",ExpressionUUID->"34d8c70b-4ac2-374f-bae0-d21514806491"],

Cell[BoxData[
 Graphics3DBox[
  {GrayLevel[0], PointSize[Large], Point3DBox[{0, 0, 0}], 
   Point3DBox[{1, 0, 0}], Point3DBox[{0, 1, 0}], Point3DBox[{0, 0, 1}], 
   Point3DBox[{1, 1, 1}]},
  Axes->True,
  AxesLabel->{
    FormBox["\"x\"", TraditionalForm], 
    FormBox["\"y\"", TraditionalForm], 
    FormBox["\"z\"", TraditionalForm]}]], "Output",
 CellChangeTimes->{
  3.967280211212356*^9, {3.96728063893384*^9, 3.967280666833497*^9}, {
   3.967280909707457*^9, 3.9672809207026443`*^9}, {3.967281008806964*^9, 
   3.967281041952292*^9}, 3.9672815078036118`*^9, 3.967281548449987*^9, 
   3.967282532238825*^9, {3.9672844824844418`*^9, 3.9672844914160957`*^9}, {
   3.9672872198068533`*^9, 3.967287236168056*^9}, {3.967287698809752*^9, 
   3.9672877249527273`*^9}},
 CellLabel->
  "Out[160]=",ExpressionUUID->"58c951d1-dbef-4e6e-8db3-2b899dbadcc4"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TemplateBox[{"\"grid=\"", "True"},
    "RowDefault"], ",", 
   TemplateBox[{"\"estiloejes=\"", "\"center\""},
    "RowDefault"], ",", 
   TemplateBox[{"\"extensionejes=\"", "0.1379145111972195`"},
    "RowDefault"], ",", 
   TemplateBox[{"\"resolucion=\"", "66"},
    "RowDefault"], ",", 
   TemplateBox[{"\"texto=\"", 
     RowBox[{"{", 
       RowBox[{
         RowBox[{"{", 
           RowBox[{"\"A\"", ",", 
             RowBox[{"{", 
               RowBox[{"0.01`", ",", "0.01`", ",", "0.01`"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"\"color\"", ",", "\"cyan\""}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"\"size\"", ",", "\"\\\\normalsize\""}], "}"}], 
                 ",", 
                 RowBox[{"{", 
                   RowBox[{"\"anchor\"", ",", "\"north\""}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"\"rotate\"", ",", "165.19023157563356`"}], 
                   "}"}]}], "}"}]}], "}"}], ",", 
         RowBox[{"{", 
           RowBox[{"\"B\"", ",", 
             RowBox[{"{", 
               RowBox[{"0.99`", ",", 
                 RowBox[{"-", "0.01`"}], ",", 
                 RowBox[{"-", "0.01`"}]}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"\"color\"", ",", "\"black\""}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"\"size\"", ",", "\"\\\\normalsize\""}], "}"}], 
                 ",", 
                 RowBox[{"{", 
                   RowBox[{"\"anchor\"", ",", "\"north\""}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"\"rotate\"", ",", "165.19023157563356`"}], 
                   "}"}]}], "}"}]}], "}"}], ",", 
         RowBox[{"{", 
           RowBox[{"\"C\"", ",", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"-", "0.01`"}], ",", "0.99`", ",", 
                 RowBox[{"-", "0.01`"}]}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"\"color\"", ",", "\"orange\""}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"\"size\"", ",", "\"\\\\normalsize\""}], "}"}], 
                 ",", 
                 RowBox[{"{", 
                   RowBox[{"\"anchor\"", ",", "\"north\""}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"\"rotate\"", ",", "165.19023157563356`"}], 
                   "}"}]}], "}"}]}], "}"}], ",", 
         RowBox[{"{", 
           RowBox[{"\"D\"", ",", 
             RowBox[{"{", 
               RowBox[{"0.01`", ",", "0.01`", ",", "1.01`"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"\"color\"", ",", "\"orange\""}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"\"size\"", ",", "\"\\\\normalsize\""}], "}"}], 
                 ",", 
                 RowBox[{"{", 
                   RowBox[{"\"anchor\"", ",", "\"north\""}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"\"rotate\"", ",", "165.19023157563356`"}], 
                   "}"}]}], "}"}]}], "}"}], ",", 
         RowBox[{"{", 
           RowBox[{"\"E\"", ",", 
             RowBox[{"{", 
               RowBox[{"0.99`", ",", "0.99`", ",", "0.99`"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"\"color\"", ",", "\"black\""}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"\"size\"", ",", "\"\\\\normalsize\""}], "}"}], 
                 ",", 
                 RowBox[{"{", 
                   RowBox[{"\"anchor\"", ",", "\"north\""}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"\"rotate\"", ",", "165.19023157563356`"}], 
                   "}"}]}], "}"}]}], "}"}]}], "}"}]},
    "RowDefault"], ",", 
   TemplateBox[{"\"maxpoligonos=\"", "638"},
    "RowDefault"]}], "}"}]], "Output",
 CellChangeTimes->{
  3.967280211212356*^9, {3.96728063893384*^9, 3.967280666833497*^9}, {
   3.967280909707457*^9, 3.9672809207026443`*^9}, {3.967281008806964*^9, 
   3.967281041952292*^9}, 3.9672815078036118`*^9, 3.967281548449987*^9, 
   3.967282532238825*^9, {3.9672844824844418`*^9, 3.9672844914160957`*^9}, {
   3.9672872198068533`*^9, 3.967287236168056*^9}, {3.967287698809752*^9, 
   3.967287724956196*^9}},
 CellLabel->
  "Out[162]=",ExpressionUUID->"a994c531-4bc5-4b2a-a5fe-7c71b984cc19"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.96728722313945*^9, 3.9672872361733713`*^9}, {
  3.967287698814712*^9, 3.967287724957871*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[159]:=",ExpressionUUID->"51164633-c7b9-4e9b-8c6c-98dd50d8875b"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{{3.96728722313945*^9, 3.9672872361733713`*^9}, {
  3.967287698814712*^9, 3.9672877249584084`*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[159]:=",ExpressionUUID->"7fd074dd-c4a1-4ac9-ae02-7fcb274fd9cd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.96728722313945*^9, 3.9672872361733713`*^9}, {
  3.967287698814712*^9, 3.967287724959036*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[159]:=",ExpressionUUID->"7ec4d91a-13b3-4b37-8030-127eaa5acccf"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.96728722313945*^9, 3.9672872361733713`*^9}, {
  3.967287698814712*^9, 3.967287724959467*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[159]:=",ExpressionUUID->"ff22d4e0-0a30-418d-872b-64d29a27b8cf"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.96728722313945*^9, 3.9672872361733713`*^9}, {
  3.967287698814712*^9, 3.96728772495989*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[159]:=",ExpressionUUID->"6550f835-9516-40ce-b97c-52075743cd60"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{{3.96728722313945*^9, 3.9672872361733713`*^9}, {
  3.967287698814712*^9, 3.967287725049089*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[159]:=",ExpressionUUID->"72a4e785-f755-4bc6-b740-a14e59318141"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{{3.96728722313945*^9, 3.9672872361733713`*^9}, {
  3.967287698814712*^9, 3.967287726057572*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[159]:=",ExpressionUUID->"f3c8ab8f-8053-4046-9782-57c83fe64079"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/graphics3D3/\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", 
   "/Users/enriquevilchezquesada/Downloads/graphics3D3/"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.96728722313945*^9, 3.9672872361733713`*^9}, {
  3.967287698814712*^9, 3.967287726061289*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[159]:=",ExpressionUUID->"05b282e1-4b6c-4347-bc7c-5aa89d392cc6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"graphics3D3\"\>"}],
  SequenceForm["Archivo: ", "graphics3D3"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.96728722313945*^9, 3.9672872361733713`*^9}, {
  3.967287698814712*^9, 3.967287726063499*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[159]:=",ExpressionUUID->"2bd7ce4b-3415-487a-a60e-917257089152"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{{3.96728722313945*^9, 3.9672872361733713`*^9}, {
  3.967287698814712*^9, 3.9672877267675447`*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[159]:=",ExpressionUUID->"b5a68d42-12ed-400e-bb5b-25b2df57d5ce"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/graphics3D3/graphics3D3.pdf\"\>"}],
  SequenceForm[
  "PDF generado: ", 
   "/Users/enriquevilchezquesada/Downloads/graphics3D3/graphics3D3.pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.96728722313945*^9, 3.9672872361733713`*^9}, {
  3.967287698814712*^9, 3.967287726768196*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[159]:=",ExpressionUUID->"51b656c0-bff5-46af-a472-b22e1e612643"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/graphics3D3/\
graphics3D3.pdf\"\>"], "Output",
 CellChangeTimes->{
  3.967280211212356*^9, {3.96728063893384*^9, 3.967280666833497*^9}, {
   3.967280909707457*^9, 3.9672809207026443`*^9}, {3.967281008806964*^9, 
   3.967281041952292*^9}, 3.9672815078036118`*^9, 3.967281548449987*^9, 
   3.967282532238825*^9, {3.9672844824844418`*^9, 3.9672844914160957`*^9}, {
   3.9672872198068533`*^9, 3.967287236168056*^9}, {3.967287698809752*^9, 
   3.9672877267803907`*^9}},
 CellLabel->
  "Out[164]=",ExpressionUUID->"e3231b42-eac6-4215-822d-840c2458714a"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejemplo 4: varios vectores", "Subsection",
 CellChangeTimes->{{3.967211284283127*^9, 3.9672112867661*^9}, 
   3.9672113318210983`*^9, {3.9672115925701065`*^9, 3.9672115952908916`*^9}, {
   3.967281612729229*^9, 3.967281613495294*^9}, {3.967281891710013*^9, 
   3.967281892111726*^9}},ExpressionUUID->"bb97a4ce-251a-a840-a146-\
4d54d8515f4e"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"puntos", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "5"}], ",", "7", ",", 
       RowBox[{"-", "4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "5"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "7", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", 
       RowBox[{"-", "4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", 
       RowBox[{"-", "3"}]}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"graphics3D4", "=", 
   RowBox[{"Graphics3D", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Red", ",", 
       RowBox[{
        RowBox[{
         RowBox[{"Arrow", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", "#"}], "}"}], 
          "]"}], "&"}], "/@", "puntos"}]}], "}"}], ",", 
     RowBox[{"Axes", "->", "True"}], ",", 
     RowBox[{"AxesLabel", "->", 
      RowBox[{"{", 
       RowBox[{"\"\<x\>\"", ",", "\"\<y\>\"", ",", "\"\<z\>\""}], "}"}]}]}], 
    "]"}]}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"colortexto", "[", "]"}], ":=", 
     RowBox[{"RandomChoice", "[", 
      RowBox[{"{", 
       RowBox[{"\"\<black\>\"", ",", "\"\<blue\>\"", ",", "\"\<brown\>\"", 
        ",", "\"\<cyan\>\"", ",", "\"\<darkgray\>\"", ",", "\"\<gray\>\"", 
        ",", "\"\<green\>\"", ",", "\"\<lightgray\>\"", ",", "\"\<lime\>\"", 
        ",", "\"\<magenta\>\"", ",", "\"\<olive\>\"", ",", "\"\<orange\>\"", 
        ",", "\"\<pink\>\"", ",", "\"\<purple\>\"", ",", "\"\<red\>\"", 
        ",", "\"\<teal\>\"", ",", "\"\<violet\>\"", ",", "\"\<yellow\>\""}], 
       "}"}], "]"}]}], ",", 
    RowBox[{"sizetexto", "=", 
     RowBox[{"RandomChoice", "[", 
      RowBox[{"{", 
       RowBox[{"\"\<\\\\tiny\>\"", ",", "\"\<\\\\scriptsize\>\"", 
        ",", "\"\<\\\\footnotesize\>\"", ",", "\"\<\\\\small\>\"", 
        ",", "\"\<\\\\normalsize\>\"", ",", "\"\<\\\\large\>\"", 
        ",", "\"\<\\\\Large\>\"", ",", "\"\<\\\\huge\>\"", 
        ",", "\"\<\\\\Huge\>\""}], "}"}], "]"}]}], ",", 
    RowBox[{"anclajetexto", "=", 
     RowBox[{"RandomChoice", "[", 
      RowBox[{"{", 
       RowBox[{"\"\<north\>\"", ",", "\"\<south\>\"", ",", "\"\<east\>\"", 
        ",", "\"\<west\>\"", ",", "\"\<north east\>\"", 
        ",", "\"\<north west\>\"", ",", "\"\<south east\>\"", 
        ",", "\"\<south west\>\"", ",", "\"\<center\>\""}], "}"}], "]"}]}], ",", 
    RowBox[{"rotatexto", "=", 
     RowBox[{"RandomReal", "[", 
      RowBox[{"{", 
       RowBox[{"0", ",", "360"}], "}"}], "]"}]}]}], "}"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<grid=\>\"", ",", 
      RowBox[{"grid", "=", 
       RowBox[{"RandomChoice", "[", 
        RowBox[{"{", 
         RowBox[{"True", ",", "False"}], "}"}], "]"}]}]}], "}"}], "]"}], ",", 
   
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<estiloejes=\>\"", ",", 
      RowBox[{"estiloejes", "=", 
       RowBox[{"RandomChoice", "[", 
        RowBox[{"{", 
         RowBox[{"\"\<box\>\"", ",", "\"\<center\>\"", ",", "\"\<none\>\""}], 
         "}"}], "]"}]}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<extensionejes=\>\"", ",", 
      RowBox[{"extensionejes", "=", 
       RowBox[{"RandomReal", "[", 
        RowBox[{"{", 
         RowBox[{"0.1", ",", "0.4"}], "}"}], "]"}]}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<resolucion=\>\"", ",", 
      RowBox[{"resolucion", "=", 
       RowBox[{"RandomInteger", "[", 
        RowBox[{"{", 
         RowBox[{"20", ",", "80"}], "}"}], "]"}]}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<texto=\>\"", ",", 
      RowBox[{"texto", "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\"\<A\>\"", ",", 
           RowBox[{
            RowBox[{"puntos", "[", 
             RowBox[{"[", "1", "]"}], "]"}], "+", 
            RowBox[{
             RowBox[{"RandomChoice", "[", 
              RowBox[{"{", 
               RowBox[{"1", ",", 
                RowBox[{"-", "1"}]}], "}"}], "]"}], "0.01"}]}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"\"\<color\>\"", ",", 
               RowBox[{"colortexto", "[", "]"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"\"\<size\>\"", ",", "sizetexto"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"\"\<anchor\>\"", ",", "anclajetexto"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"\"\<rotate\>\"", ",", "rotatexto"}], "}"}]}], "}"}]}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\"\<B\>\"", ",", 
           RowBox[{
            RowBox[{"puntos", "[", 
             RowBox[{"[", "2", "]"}], "]"}], "+", 
            RowBox[{
             RowBox[{"RandomChoice", "[", 
              RowBox[{"{", 
               RowBox[{"1", ",", 
                RowBox[{"-", "1"}]}], "}"}], "]"}], "0.01"}]}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"\"\<color\>\"", ",", 
               RowBox[{"colortexto", "[", "]"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"\"\<size\>\"", ",", "sizetexto"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"\"\<anchor\>\"", ",", "anclajetexto"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"\"\<rotate\>\"", ",", "rotatexto"}], "}"}]}], "}"}]}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\"\<C\>\"", ",", 
           RowBox[{
            RowBox[{"puntos", "[", 
             RowBox[{"[", "3", "]"}], "]"}], "+", 
            RowBox[{
             RowBox[{"RandomChoice", "[", 
              RowBox[{"{", 
               RowBox[{"1", ",", 
                RowBox[{"-", "1"}]}], "}"}], "]"}], "0.01"}]}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"\"\<color\>\"", ",", 
               RowBox[{"colortexto", "[", "]"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"\"\<size\>\"", ",", "sizetexto"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"\"\<anchor\>\"", ",", "anclajetexto"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"\"\<rotate\>\"", ",", "rotatexto"}], "}"}]}], "}"}]}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\"\<D\>\"", ",", 
           RowBox[{
            RowBox[{"puntos", "[", 
             RowBox[{"[", "4", "]"}], "]"}], "+", 
            RowBox[{
             RowBox[{"RandomChoice", "[", 
              RowBox[{"{", 
               RowBox[{"1", ",", 
                RowBox[{"-", "1"}]}], "}"}], "]"}], "0.01"}]}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"\"\<color\>\"", ",", 
               RowBox[{"colortexto", "[", "]"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"\"\<size\>\"", ",", "sizetexto"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"\"\<anchor\>\"", ",", "anclajetexto"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"\"\<rotate\>\"", ",", "rotatexto"}], "}"}]}], "}"}]}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\"\<E\>\"", ",", 
           RowBox[{
            RowBox[{"puntos", "[", 
             RowBox[{"[", "5", "]"}], "]"}], "+", 
            RowBox[{
             RowBox[{"RandomChoice", "[", 
              RowBox[{"{", 
               RowBox[{"1", ",", 
                RowBox[{"-", "1"}]}], "}"}], "]"}], "0.01"}]}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"\"\<color\>\"", ",", 
               RowBox[{"colortexto", "[", "]"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"\"\<size\>\"", ",", "sizetexto"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"\"\<anchor\>\"", ",", "anclajetexto"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"\"\<rotate\>\"", ",", "rotatexto"}], "}"}]}], "}"}]}], 
          "}"}]}], "}"}]}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<maxpoligonos=\>\"", ",", 
      RowBox[{"maxpoligonos", "=", 
       RowBox[{"RandomInteger", "[", 
        RowBox[{"{", 
         RowBox[{"500", ",", "700"}], "}"}], "]"}]}]}], "}"}], "]"}]}], 
  "}"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ExportToTikZGraphics3D", "[", 
   RowBox[{
   "graphics3D4", ",", "\"\<graphics3D4.tex\>\"", ",", "grid", ",", 
    "estiloejes", ",", "extensionejes", ",", "resolucion", ",", "texto", ",", 
    "maxpoligonos"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.96721195801581*^9, 3.967211958845005*^9}, {
   3.9672124055750923`*^9, 3.9672124065700436`*^9}, {3.9672124992141266`*^9, 
   3.9672124996397305`*^9}, 3.967215100494358*^9, 3.9672153607679176`*^9, 
   3.967215392841646*^9, 3.9672154692928047`*^9, {3.9672160568125*^9, 
   3.9672160571704597`*^9}, 3.967274533148213*^9, {3.967280725539267*^9, 
   3.967280725934619*^9}, {3.967281195536057*^9, 3.967281196782565*^9}, {
   3.967281251772389*^9, 3.9672812820477*^9}, {3.967281328655407*^9, 
   3.967281329012783*^9}, {3.967281402093287*^9, 3.967281418535254*^9}, {
   3.967284077889677*^9, 3.9672840840562773`*^9}, {3.9672844624165382`*^9, 
   3.967284463139365*^9}, 3.967287249463587*^9, {3.9672873438501787`*^9, 
   3.967287355414894*^9}, 3.9672874709808397`*^9},
 CellLabel->
  "In[177]:=",ExpressionUUID->"4e83e0df-174c-194a-beb2-fa8fa5dbbfa0"],

Cell[BoxData[
 Graphics3DBox[
  {RGBColor[1, 0, 0], Arrow3DBox[{{0, 0, 0}, {-5, 7, -4}}], 
   Arrow3DBox[{{0, 0, 0}, {-5, 0, 0}}], Arrow3DBox[{{0, 0, 0}, {0, 7, 0}}], 
   Arrow3DBox[{{0, 0, 0}, {0, 0, -4}}], Arrow3DBox[{{0, 0, 0}, {1, 2, -3}}]},
  Axes->True,
  AxesLabel->{
    FormBox["\"x\"", TraditionalForm], 
    FormBox["\"y\"", TraditionalForm], 
    FormBox["\"z\"", TraditionalForm]}]], "Output",
 CellChangeTimes->{{3.9672812525922832`*^9, 3.967281291330389*^9}, {
   3.9672814354791117`*^9, 3.96728149286213*^9}, {3.967281940193962*^9, 
   3.967281953694707*^9}, 3.967282520523355*^9, {3.967284463706279*^9, 
   3.967284472169729*^9}, {3.967287250402361*^9, 3.9672872596656847`*^9}, {
   3.967287749648361*^9, 3.967287763057158*^9}},
 CellLabel->
  "Out[178]=",ExpressionUUID->"0b4d6a5f-bb21-4cc3-916c-59dc2aaa1acc"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TemplateBox[{"\"grid=\"", "False"},
    "RowDefault"], ",", 
   TemplateBox[{"\"estiloejes=\"", "\"box\""},
    "RowDefault"], ",", 
   TemplateBox[{"\"extensionejes=\"", "0.23913576709654658`"},
    "RowDefault"], ",", 
   TemplateBox[{"\"resolucion=\"", "30"},
    "RowDefault"], ",", 
   TemplateBox[{"\"texto=\"", 
     RowBox[{"{", 
       RowBox[{
         RowBox[{"{", 
           RowBox[{"\"A\"", ",", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"-", "5.01`"}], ",", "6.99`", ",", 
                 RowBox[{"-", "4.01`"}]}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"\"color\"", ",", "\"black\""}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"\"size\"", ",", "\"\\\\scriptsize\""}], "}"}], 
                 ",", 
                 RowBox[{"{", 
                   RowBox[{"\"anchor\"", ",", "\"south\""}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"\"rotate\"", ",", "66.29464883000757`"}], "}"}]}],
                "}"}]}], "}"}], ",", 
         RowBox[{"{", 
           RowBox[{"\"B\"", ",", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"-", "4.99`"}], ",", "0.01`", ",", "0.01`"}], "}"}], 
             ",", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"\"color\"", ",", "\"violet\""}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"\"size\"", ",", "\"\\\\scriptsize\""}], "}"}], 
                 ",", 
                 RowBox[{"{", 
                   RowBox[{"\"anchor\"", ",", "\"south\""}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"\"rotate\"", ",", "66.29464883000757`"}], "}"}]}],
                "}"}]}], "}"}], ",", 
         RowBox[{"{", 
           RowBox[{"\"C\"", ",", 
             RowBox[{"{", 
               RowBox[{"0.01`", ",", "7.01`", ",", "0.01`"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"\"color\"", ",", "\"green\""}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"\"size\"", ",", "\"\\\\scriptsize\""}], "}"}], 
                 ",", 
                 RowBox[{"{", 
                   RowBox[{"\"anchor\"", ",", "\"south\""}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"\"rotate\"", ",", "66.29464883000757`"}], "}"}]}],
                "}"}]}], "}"}], ",", 
         RowBox[{"{", 
           RowBox[{"\"D\"", ",", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"-", "0.01`"}], ",", 
                 RowBox[{"-", "0.01`"}], ",", 
                 RowBox[{"-", "4.01`"}]}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"\"color\"", ",", "\"olive\""}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"\"size\"", ",", "\"\\\\scriptsize\""}], "}"}], 
                 ",", 
                 RowBox[{"{", 
                   RowBox[{"\"anchor\"", ",", "\"south\""}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"\"rotate\"", ",", "66.29464883000757`"}], "}"}]}],
                "}"}]}], "}"}], ",", 
         RowBox[{"{", 
           RowBox[{"\"E\"", ",", 
             RowBox[{"{", 
               RowBox[{"0.99`", ",", "1.99`", ",", 
                 RowBox[{"-", "3.01`"}]}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"\"color\"", ",", "\"olive\""}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"\"size\"", ",", "\"\\\\scriptsize\""}], "}"}], 
                 ",", 
                 RowBox[{"{", 
                   RowBox[{"\"anchor\"", ",", "\"south\""}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"\"rotate\"", ",", "66.29464883000757`"}], "}"}]}],
                "}"}]}], "}"}]}], "}"}]},
    "RowDefault"], ",", 
   TemplateBox[{"\"maxpoligonos=\"", "622"},
    "RowDefault"]}], "}"}]], "Output",
 CellChangeTimes->{{3.9672812525922832`*^9, 3.967281291330389*^9}, {
   3.9672814354791117`*^9, 3.96728149286213*^9}, {3.967281940193962*^9, 
   3.967281953694707*^9}, 3.967282520523355*^9, {3.967284463706279*^9, 
   3.967284472169729*^9}, {3.967287250402361*^9, 3.9672872596656847`*^9}, {
   3.967287749648361*^9, 3.967287763061625*^9}},
 CellLabel->
  "Out[180]=",ExpressionUUID->"e0f1851f-8eac-4996-bf66-4dadf3c8f7c1"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.967281252599049*^9, 3.9672812913352413`*^9}, {
   3.967281435484777*^9, 3.967281492867537*^9}, {3.967281940199772*^9, 
   3.967281953700248*^9}, 3.967282520528916*^9, {3.9672844637142487`*^9, 
   3.96728447217568*^9}, {3.967287250407838*^9, 3.9672872596708717`*^9}, {
   3.9672877496531677`*^9, 3.967287763063447*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[177]:=",ExpressionUUID->"bad002e2-7611-4208-882e-ba34b8494503"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{{3.967281252599049*^9, 3.9672812913352413`*^9}, {
   3.967281435484777*^9, 3.967281492867537*^9}, {3.967281940199772*^9, 
   3.967281953700248*^9}, 3.967282520528916*^9, {3.9672844637142487`*^9, 
   3.96728447217568*^9}, {3.967287250407838*^9, 3.9672872596708717`*^9}, {
   3.9672877496531677`*^9, 3.9672877630639763`*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[177]:=",ExpressionUUID->"88e36457-100c-4f63-ab56-73c7dcf96971"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.967281252599049*^9, 3.9672812913352413`*^9}, {
   3.967281435484777*^9, 3.967281492867537*^9}, {3.967281940199772*^9, 
   3.967281953700248*^9}, 3.967282520528916*^9, {3.9672844637142487`*^9, 
   3.96728447217568*^9}, {3.967287250407838*^9, 3.9672872596708717`*^9}, {
   3.9672877496531677`*^9, 3.9672877630645742`*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[177]:=",ExpressionUUID->"94fed307-a0a1-4621-a743-55c5736fab25"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.967281252599049*^9, 3.9672812913352413`*^9}, {
   3.967281435484777*^9, 3.967281492867537*^9}, {3.967281940199772*^9, 
   3.967281953700248*^9}, 3.967282520528916*^9, {3.9672844637142487`*^9, 
   3.96728447217568*^9}, {3.967287250407838*^9, 3.9672872596708717`*^9}, {
   3.9672877496531677`*^9, 3.967287763064989*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[177]:=",ExpressionUUID->"b97e61ab-f009-485c-8894-cd98feb105bc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.967281252599049*^9, 3.9672812913352413`*^9}, {
   3.967281435484777*^9, 3.967281492867537*^9}, {3.967281940199772*^9, 
   3.967281953700248*^9}, 3.967282520528916*^9, {3.9672844637142487`*^9, 
   3.96728447217568*^9}, {3.967287250407838*^9, 3.9672872596708717`*^9}, {
   3.9672877496531677`*^9, 3.967287763065399*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[177]:=",ExpressionUUID->"e03c281d-a818-4914-a649-a85ad7905e5a"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{{3.967281252599049*^9, 3.9672812913352413`*^9}, {
   3.967281435484777*^9, 3.967281492867537*^9}, {3.967281940199772*^9, 
   3.967281953700248*^9}, 3.967282520528916*^9, {3.9672844637142487`*^9, 
   3.96728447217568*^9}, {3.967287250407838*^9, 3.9672872596708717`*^9}, {
   3.9672877496531677`*^9, 3.9672877631576853`*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[177]:=",ExpressionUUID->"174f76f3-1361-4ca8-944d-fe30532d8f59"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{{3.967281252599049*^9, 3.9672812913352413`*^9}, {
   3.967281435484777*^9, 3.967281492867537*^9}, {3.967281940199772*^9, 
   3.967281953700248*^9}, 3.967282520528916*^9, {3.9672844637142487`*^9, 
   3.96728447217568*^9}, {3.967287250407838*^9, 3.9672872596708717`*^9}, {
   3.9672877496531677`*^9, 3.9672877641642523`*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[177]:=",ExpressionUUID->"a15b4599-5275-4bcf-97dd-8e93a48dfa99"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/graphics3D4/\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", 
   "/Users/enriquevilchezquesada/Downloads/graphics3D4/"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.967281252599049*^9, 3.9672812913352413`*^9}, {
   3.967281435484777*^9, 3.967281492867537*^9}, {3.967281940199772*^9, 
   3.967281953700248*^9}, 3.967282520528916*^9, {3.9672844637142487`*^9, 
   3.96728447217568*^9}, {3.967287250407838*^9, 3.9672872596708717`*^9}, {
   3.9672877496531677`*^9, 3.967287764168973*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[177]:=",ExpressionUUID->"b2fc80ff-6798-4ae9-a3c8-2b1c38185854"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"graphics3D4\"\>"}],
  SequenceForm["Archivo: ", "graphics3D4"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.967281252599049*^9, 3.9672812913352413`*^9}, {
   3.967281435484777*^9, 3.967281492867537*^9}, {3.967281940199772*^9, 
   3.967281953700248*^9}, 3.967282520528916*^9, {3.9672844637142487`*^9, 
   3.96728447217568*^9}, {3.967287250407838*^9, 3.9672872596708717`*^9}, {
   3.9672877496531677`*^9, 3.96728776417181*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[177]:=",ExpressionUUID->"d4e69341-e30d-4676-9487-a0027da3957e"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{{3.967281252599049*^9, 3.9672812913352413`*^9}, {
   3.967281435484777*^9, 3.967281492867537*^9}, {3.967281940199772*^9, 
   3.967281953700248*^9}, 3.967282520528916*^9, {3.9672844637142487`*^9, 
   3.96728447217568*^9}, {3.967287250407838*^9, 3.9672872596708717`*^9}, {
   3.9672877496531677`*^9, 3.967287764885416*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[177]:=",ExpressionUUID->"8f85c279-19d4-4090-a1d8-b1dd480f3416"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/graphics3D4/graphics3D4.pdf\"\>"}],
  SequenceForm[
  "PDF generado: ", 
   "/Users/enriquevilchezquesada/Downloads/graphics3D4/graphics3D4.pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.967281252599049*^9, 3.9672812913352413`*^9}, {
   3.967281435484777*^9, 3.967281492867537*^9}, {3.967281940199772*^9, 
   3.967281953700248*^9}, 3.967282520528916*^9, {3.9672844637142487`*^9, 
   3.96728447217568*^9}, {3.967287250407838*^9, 3.9672872596708717`*^9}, {
   3.9672877496531677`*^9, 3.96728776488608*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[177]:=",ExpressionUUID->"03560fac-a81c-475b-8410-3feac0c274e0"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/graphics3D4/\
graphics3D4.pdf\"\>"], "Output",
 CellChangeTimes->{{3.9672812525922832`*^9, 3.967281291330389*^9}, {
   3.9672814354791117`*^9, 3.96728149286213*^9}, {3.967281940193962*^9, 
   3.967281953694707*^9}, 3.967282520523355*^9, {3.967284463706279*^9, 
   3.967284472169729*^9}, {3.967287250402361*^9, 3.9672872596656847`*^9}, {
   3.967287749648361*^9, 3.9672877648985558`*^9}},
 CellLabel->
  "Out[182]=",ExpressionUUID->"f7613893-1c00-4578-ad9b-c6999feff9af"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejemplo 5: varias figuras 3D", "Subsection",
 CellChangeTimes->{{3.967211284283127*^9, 3.9672112867661*^9}, 
   3.967211334700163*^9, {3.9672116317104855`*^9, 3.967211640237932*^9}, {
   3.967282020428974*^9, 
   3.967282039473712*^9}},ExpressionUUID->"f060248a-3cd4-6a40-8896-\
39895e0166a2"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"graphics3D5", "=", 
   RowBox[{"Graphics3D", "[", 
    RowBox[{"{", 
     RowBox[{"Blue", ",", 
      RowBox[{"Cylinder", "[", "]"}], ",", "Red", ",", 
      RowBox[{"Sphere", "[", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "2"}], "}"}], "]"}], ",", "Black", ",", 
      "Thick", ",", "Dashed", ",", 
      RowBox[{"Line", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "2"}], ",", "0", ",", "2"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "0", ",", "2"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "4"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "2"}], ",", "0", ",", "2"}], "}"}]}], "}"}], "]"}], ",",
       "Yellow", ",", 
      RowBox[{"Polygon", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "3"}], ",", 
           RowBox[{"-", "3"}], ",", 
           RowBox[{"-", "2"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "3"}], ",", "3", ",", 
           RowBox[{"-", "2"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", "3", ",", 
           RowBox[{"-", "2"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", 
           RowBox[{"-", "3"}], ",", 
           RowBox[{"-", "2"}]}], "}"}]}], "}"}], "]"}], ",", "Green", ",", 
      RowBox[{"Opacity", "[", ".3", "]"}], ",", 
      RowBox[{"Cuboid", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "2"}], ",", 
          RowBox[{"-", "2"}], ",", 
          RowBox[{"-", "2"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"2", ",", "2", ",", 
          RowBox[{"-", "1"}]}], "}"}]}], "]"}]}], "}"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\n", 
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"colortexto", "[", "]"}], ":=", 
     RowBox[{"RandomChoice", "[", 
      RowBox[{"{", 
       RowBox[{"\"\<black\>\"", ",", "\"\<blue\>\"", ",", "\"\<brown\>\"", 
        ",", "\"\<cyan\>\"", ",", "\"\<darkgray\>\"", ",", "\"\<gray\>\"", 
        ",", "\"\<green\>\"", ",", "\"\<lightgray\>\"", ",", "\"\<lime\>\"", 
        ",", "\"\<magenta\>\"", ",", "\"\<olive\>\"", ",", "\"\<orange\>\"", 
        ",", "\"\<pink\>\"", ",", "\"\<purple\>\"", ",", "\"\<red\>\"", 
        ",", "\"\<teal\>\"", ",", "\"\<violet\>\"", ",", "\"\<yellow\>\""}], 
       "}"}], "]"}]}], ",", 
    RowBox[{"sizetexto", "=", 
     RowBox[{"RandomChoice", "[", 
      RowBox[{"{", 
       RowBox[{"\"\<\\\\tiny\>\"", ",", "\"\<\\\\scriptsize\>\"", 
        ",", "\"\<\\\\footnotesize\>\"", ",", "\"\<\\\\small\>\"", 
        ",", "\"\<\\\\normalsize\>\"", ",", "\"\<\\\\large\>\"", 
        ",", "\"\<\\\\Large\>\"", ",", "\"\<\\\\huge\>\"", 
        ",", "\"\<\\\\Huge\>\""}], "}"}], "]"}]}], ",", 
    RowBox[{"anclajetexto", "=", 
     RowBox[{"RandomChoice", "[", 
      RowBox[{"{", 
       RowBox[{"\"\<north\>\"", ",", "\"\<south\>\"", ",", "\"\<east\>\"", 
        ",", "\"\<west\>\"", ",", "\"\<north east\>\"", 
        ",", "\"\<north west\>\"", ",", "\"\<south east\>\"", 
        ",", "\"\<south west\>\"", ",", "\"\<center\>\""}], "}"}], "]"}]}], ",", 
    RowBox[{"rotatexto", "=", 
     RowBox[{"RandomReal", "[", 
      RowBox[{"{", 
       RowBox[{"0", ",", "360"}], "}"}], "]"}]}]}], "}"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<grid=\>\"", ",", 
      RowBox[{"grid", "=", 
       RowBox[{"RandomChoice", "[", 
        RowBox[{"{", 
         RowBox[{"True", ",", "False"}], "}"}], "]"}]}]}], "}"}], "]"}], ",", 
   
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<estiloejes=\>\"", ",", 
      RowBox[{"estiloejes", "=", 
       RowBox[{"RandomChoice", "[", 
        RowBox[{"{", 
         RowBox[{"\"\<box\>\"", ",", "\"\<center\>\"", ",", "\"\<none\>\""}], 
         "}"}], "]"}]}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<extensionejes=\>\"", ",", 
      RowBox[{"extensionejes", "=", 
       RowBox[{"RandomReal", "[", 
        RowBox[{"{", 
         RowBox[{"0.1", ",", "0.4"}], "}"}], "]"}]}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<resolucion=\>\"", ",", 
      RowBox[{"resolucion", "=", 
       RowBox[{"RandomInteger", "[", 
        RowBox[{"{", 
         RowBox[{"20", ",", "80"}], "}"}], "]"}]}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<texto=\>\"", ",", 
      RowBox[{"texto", "=", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"\"\<Varias figuras 3D\>\"", ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "3"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"\"\<color\>\"", ",", 
              RowBox[{"colortexto", "[", "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"\"\<size\>\"", ",", "sizetexto"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"\"\<anchor\>\"", ",", "anclajetexto"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"\"\<rotate\>\"", ",", "rotatexto"}], "}"}]}], "}"}]}], 
         "}"}], "}"}]}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<maxpoligonos=\>\"", ",", 
      RowBox[{"maxpoligonos", "=", 
       RowBox[{"RandomInteger", "[", 
        RowBox[{"{", 
         RowBox[{"500", ",", "700"}], "}"}], "]"}]}]}], "}"}], "]"}]}], 
  "}"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ExportToTikZGraphics3D", "[", 
   RowBox[{
   "graphics3D5", ",", "\"\<graphics3D5.tex\>\"", ",", "grid", ",", 
    "estiloejes", ",", "extensionejes", ",", "resolucion", ",", "texto", ",", 
    "maxpoligonos"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.9672124102235374`*^9, 3.9672124110833073`*^9}, {
   3.9672125038303986`*^9, 3.96721250416094*^9}, 3.967215108902855*^9, 
   3.96721535614159*^9, 3.967215395765564*^9, 3.9672154751804066`*^9, {
   3.9672158835088825`*^9, 3.967215884067127*^9}, {3.96721606369792*^9, 
   3.9672160640375843`*^9}, 3.967274540274032*^9, 3.967281682333102*^9, {
   3.967281745500444*^9, 3.967281745942027*^9}, {3.967281976722088*^9, 
   3.967282009865985*^9}, {3.9672840918549957`*^9, 3.967284095531168*^9}, {
   3.9672844459925537`*^9, 3.967284446194623*^9}, 3.9672872733341618`*^9, 
   3.967287483285589*^9},
 CellLabel->
  "In[188]:=",ExpressionUUID->"0d6ee813-ed63-524c-b524-ad3b1599aa78"],

Cell[BoxData[
 Graphics3DBox[{
   {RGBColor[0, 0, 1], CylinderBox[{{0, 0, -1}, {0, 0, 1}}]}, 
   {RGBColor[1, 0, 0], SphereBox[{0, 0, 2}]}, 
   {GrayLevel[0], Thickness[Large], Dashing[{Small, Small}], 
    Line3DBox[{{-2, 0, 2}, {2, 0, 2}, {0, 0, 4}, {-2, 0, 2}}], 
    {RGBColor[1, 1, 0], 
     Polygon3DBox[{{-3, -3, -2}, {-3, 3, -2}, {3, 3, -2}, {3, -3, -2}}]}, 
    {RGBColor[0, 1, 0], Opacity[0.3], 
     CuboidBox[{-2, -2, -2}, {2, 2, -1}]}}}]], "Output",
 CellChangeTimes->{
  3.9672816882258797`*^9, {3.9672819865667543`*^9, 3.967282012006658*^9}, {
   3.967282252222752*^9, 3.967282260376515*^9}, 3.967282496220809*^9, 
   3.967284446586258*^9, 3.967287274160968*^9, {3.967287775734477*^9, 
   3.9672877848410254`*^9}},
 CellLabel->
  "Out[188]=",ExpressionUUID->"11e6178d-85a4-447b-b336-1b8a4945d8fc"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TemplateBox[{"\"grid=\"", "False"},
    "RowDefault"], ",", 
   TemplateBox[{"\"estiloejes=\"", "\"center\""},
    "RowDefault"], ",", 
   TemplateBox[{"\"extensionejes=\"", "0.39886022018898837`"},
    "RowDefault"], ",", 
   TemplateBox[{"\"resolucion=\"", "70"},
    "RowDefault"], ",", 
   TemplateBox[{"\"texto=\"", 
     RowBox[{"{", 
       RowBox[{"{", 
         RowBox[{"\"Varias figuras 3D\"", ",", 
           RowBox[{"{", 
             RowBox[{"0", ",", "0", ",", "3"}], "}"}], ",", 
           RowBox[{"{", 
             RowBox[{
               RowBox[{"{", 
                 RowBox[{"\"color\"", ",", "\"lime\""}], "}"}], ",", 
               RowBox[{"{", 
                 RowBox[{"\"size\"", ",", "\"\\\\scriptsize\""}], "}"}], ",", 
               
               RowBox[{"{", 
                 RowBox[{"\"anchor\"", ",", "\"west\""}], "}"}], ",", 
               RowBox[{"{", 
                 RowBox[{"\"rotate\"", ",", "297.8432555029636`"}], "}"}]}], 
             "}"}]}], "}"}], "}"}]},
    "RowDefault"], ",", 
   TemplateBox[{"\"maxpoligonos=\"", "610"},
    "RowDefault"]}], "}"}]], "Output",
 CellChangeTimes->{
  3.9672816882258797`*^9, {3.9672819865667543`*^9, 3.967282012006658*^9}, {
   3.967282252222752*^9, 3.967282260376515*^9}, 3.967282496220809*^9, 
   3.967284446586258*^9, 3.967287274160968*^9, {3.967287775734477*^9, 
   3.967287784842327*^9}},
 CellLabel->
  "Out[190]=",ExpressionUUID->"89051758-02ec-4759-a5c3-610dc0eb6464"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.9672816882660418`*^9, {3.9672819866129704`*^9, 3.9672820120475607`*^9}, {
   3.967282252267918*^9, 3.967282260423688*^9}, 3.967282496272554*^9, 
   3.9672844466348467`*^9, 3.967287274215351*^9, {3.967287775778685*^9, 
   3.967287784848229*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[188]:=",ExpressionUUID->"42eb4eae-71f0-497e-b61a-f0a0d6c1eb46"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{
  3.9672816882660418`*^9, {3.9672819866129704`*^9, 3.9672820120475607`*^9}, {
   3.967282252267918*^9, 3.967282260423688*^9}, 3.967282496272554*^9, 
   3.9672844466348467`*^9, 3.967287274215351*^9, {3.967287775778685*^9, 
   3.9672877848488903`*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[188]:=",ExpressionUUID->"c5690803-1470-4fe6-824e-01620dd718e2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.9672816882660418`*^9, {3.9672819866129704`*^9, 3.9672820120475607`*^9}, {
   3.967282252267918*^9, 3.967282260423688*^9}, 3.967282496272554*^9, 
   3.9672844466348467`*^9, 3.967287274215351*^9, {3.967287775778685*^9, 
   3.967287784849531*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[188]:=",ExpressionUUID->"ad490484-ee10-4c2b-a144-2aecae7df4f3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.9672816882660418`*^9, {3.9672819866129704`*^9, 3.9672820120475607`*^9}, {
   3.967282252267918*^9, 3.967282260423688*^9}, 3.967282496272554*^9, 
   3.9672844466348467`*^9, 3.967287274215351*^9, {3.967287775778685*^9, 
   3.967287784849955*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[188]:=",ExpressionUUID->"eacd0881-7c93-4ecb-9175-da4a4b196583"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.9672816882660418`*^9, {3.9672819866129704`*^9, 3.9672820120475607`*^9}, {
   3.967282252267918*^9, 3.967282260423688*^9}, 3.967282496272554*^9, 
   3.9672844466348467`*^9, 3.967287274215351*^9, {3.967287775778685*^9, 
   3.96728778485038*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[188]:=",ExpressionUUID->"5b572fe6-9f6e-4655-8ca6-935e10f9343a"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{
  3.9672816882660418`*^9, {3.9672819866129704`*^9, 3.9672820120475607`*^9}, {
   3.967282252267918*^9, 3.967282260423688*^9}, 3.967282496272554*^9, 
   3.9672844466348467`*^9, 3.967287274215351*^9, {3.967287775778685*^9, 
   3.967287784940489*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[188]:=",ExpressionUUID->"65dfaeb7-569c-481d-83ed-46c33663a079"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{
  3.9672816882660418`*^9, {3.9672819866129704`*^9, 3.9672820120475607`*^9}, {
   3.967282252267918*^9, 3.967282260423688*^9}, 3.967282496272554*^9, 
   3.9672844466348467`*^9, 3.967287274215351*^9, {3.967287775778685*^9, 
   3.967287785948225*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[188]:=",ExpressionUUID->"f43a8ea2-fe51-4c8c-b70b-dec741e36584"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/graphics3D5/\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", 
   "/Users/enriquevilchezquesada/Downloads/graphics3D5/"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.9672816882660418`*^9, {3.9672819866129704`*^9, 3.9672820120475607`*^9}, {
   3.967282252267918*^9, 3.967282260423688*^9}, 3.967282496272554*^9, 
   3.9672844466348467`*^9, 3.967287274215351*^9, {3.967287775778685*^9, 
   3.967287785952416*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[188]:=",ExpressionUUID->"8be666f1-0e85-4dea-8547-d5c508c56615"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"graphics3D5\"\>"}],
  SequenceForm["Archivo: ", "graphics3D5"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.9672816882660418`*^9, {3.9672819866129704`*^9, 3.9672820120475607`*^9}, {
   3.967282252267918*^9, 3.967282260423688*^9}, 3.967282496272554*^9, 
   3.9672844466348467`*^9, 3.967287274215351*^9, {3.967287775778685*^9, 
   3.967287785955278*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[188]:=",ExpressionUUID->"a5a7876a-2482-4d09-a718-8b00afb762ea"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{
  3.9672816882660418`*^9, {3.9672819866129704`*^9, 3.9672820120475607`*^9}, {
   3.967282252267918*^9, 3.967282260423688*^9}, 3.967282496272554*^9, 
   3.9672844466348467`*^9, 3.967287274215351*^9, {3.967287775778685*^9, 
   3.967287786865047*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[188]:=",ExpressionUUID->"21c28cdd-88e0-4dc5-90f1-cd7e5f8f14e1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/graphics3D5/graphics3D5.pdf\"\>"}],
  SequenceForm[
  "PDF generado: ", 
   "/Users/enriquevilchezquesada/Downloads/graphics3D5/graphics3D5.pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.9672816882660418`*^9, {3.9672819866129704`*^9, 3.9672820120475607`*^9}, {
   3.967282252267918*^9, 3.967282260423688*^9}, 3.967282496272554*^9, 
   3.9672844466348467`*^9, 3.967287274215351*^9, {3.967287775778685*^9, 
   3.96728778686569*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[188]:=",ExpressionUUID->"806821da-1c7c-4923-ad52-c7ad87692942"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/graphics3D5/\
graphics3D5.pdf\"\>"], "Output",
 CellChangeTimes->{
  3.9672816882258797`*^9, {3.9672819865667543`*^9, 3.967282012006658*^9}, {
   3.967282252222752*^9, 3.967282260376515*^9}, 3.967282496220809*^9, 
   3.967284446586258*^9, 3.967287274160968*^9, {3.967287775734477*^9, 
   3.9672877868785963`*^9}},
 CellLabel->
  "Out[192]=",ExpressionUUID->"0ced138e-2ce5-4157-aa4d-cc18fc747b60"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejemplo 6: varias figuras 3D", "Subsection",
 CellChangeTimes->{{3.967211284283127*^9, 3.9672112867661*^9}, 
   3.9672113362654724`*^9, {3.9672116832819004`*^9, 
   3.9672116842084484`*^9}},ExpressionUUID->"90aa8a89-3992-4c42-902f-\
e2c4808b29d1"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"graphics3D6", "=", 
   RowBox[{"Graphics3D", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Opacity", "[", "0.5", "]"}], ",", "Blue", ",", 
         RowBox[{"Sphere", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", "1.5"}], "]"}]}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Orange", ",", 
         RowBox[{"Opacity", "[", "0.6", "]"}], ",", 
         RowBox[{"Cylinder", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "3"}], ",", 
               RowBox[{"-", "1"}], ",", 
               RowBox[{"-", "1"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "3"}], ",", 
               RowBox[{"-", "1"}], ",", "2"}], "}"}]}], "}"}], ",", "0.6"}], 
          "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"GrayLevel", "[", "0.2", "]"}], ",", 
         RowBox[{"Specularity", "[", 
          RowBox[{"White", ",", "20"}], "]"}], ",", 
         RowBox[{"Cuboid", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"2", ",", 
             RowBox[{"-", "2"}], ",", 
             RowBox[{"-", "1"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"3.5", ",", 
             RowBox[{"-", "0.5"}], ",", "1"}], "}"}]}], "]"}]}], "}"}], ",", 
       RowBox[{"EdgeForm", "[", 
        RowBox[{"Directive", "[", 
         RowBox[{"Black", ",", "Thin"}], "]"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Lighter", "[", 
          RowBox[{"Red", ",", ".2"}], "]"}], ",", 
         RowBox[{"Opacity", "[", "0.8", "]"}], ",", 
         RowBox[{"Polygon", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0", ",", "3", ",", "0"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "2", ",", "0"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "1"}], ",", "2", ",", "0"}], "}"}]}], "}"}], "]"}],
          ",", 
         RowBox[{"Polygon", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0", ",", "4", ",", "1.5"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", "3", ",", "0"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "2", ",", "0"}], "}"}]}], "}"}], "]"}], ",", 
         RowBox[{"Polygon", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0", ",", "4", ",", "1.5"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "2", ",", "0"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "1"}], ",", "2", ",", "0"}], "}"}]}], "}"}], "]"}],
          ",", 
         RowBox[{"Polygon", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0", ",", "4", ",", "1.5"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "1"}], ",", "2", ",", "0"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", "3", ",", "0"}], "}"}]}], "}"}], "]"}]}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Thick", ",", 
         RowBox[{"Darker", "[", "Green", "]"}], ",", 
         RowBox[{"Tube", "[", 
          RowBox[{
           RowBox[{"Line", "[", 
            RowBox[{"Table", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{"Cos", "[", "t", "]"}], ",", 
                RowBox[{"Sin", "[", "t", "]"}], ",", 
                RowBox[{"t", "/", "6"}]}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"t", ",", "0", ",", 
                RowBox[{"10", " ", "Pi"}], ",", ".1"}], "}"}]}], "]"}], "]"}],
            ",", "0.07"}], "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"PointSize", "[", "Large", "]"}], ",", "Black", ",", 
         RowBox[{"Point", "[", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "0"}], "}"}], "]"}]}], "}"}], ",", 
       RowBox[{"Text", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{"\"\<Centro\>\"", ",", "14", ",", "Bold"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0.2"}], "}"}]}], "]"}], ",", 
       RowBox[{"Arrow", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "3"}], ",", 
            RowBox[{"-", "1"}], ",", "2.8"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1.2"}], ",", 
            RowBox[{"-", "0.4"}], ",", "1.6"}], "}"}]}], "}"}], "]"}]}], 
      "}"}], ",", 
     RowBox[{"Boxed", "->", "True"}], ",", 
     RowBox[{"Axes", "->", "True"}], ",", 
     RowBox[{"PlotRange", "->", "All"}], ",", 
     RowBox[{"Lighting", "->", "\"\<Neutral\>\""}], ",", 
     RowBox[{"SphericalRegion", "->", "True"}]}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"colortexto", "[", "]"}], ":=", 
     RowBox[{"RandomChoice", "[", 
      RowBox[{"{", 
       RowBox[{"\"\<black\>\"", ",", "\"\<blue\>\"", ",", "\"\<brown\>\"", 
        ",", "\"\<cyan\>\"", ",", "\"\<darkgray\>\"", ",", "\"\<gray\>\"", 
        ",", "\"\<green\>\"", ",", "\"\<lightgray\>\"", ",", "\"\<lime\>\"", 
        ",", "\"\<magenta\>\"", ",", "\"\<olive\>\"", ",", "\"\<orange\>\"", 
        ",", "\"\<pink\>\"", ",", "\"\<purple\>\"", ",", "\"\<red\>\"", 
        ",", "\"\<teal\>\"", ",", "\"\<violet\>\"", ",", "\"\<yellow\>\""}], 
       "}"}], "]"}]}], ",", 
    RowBox[{"sizetexto", "=", 
     RowBox[{"RandomChoice", "[", 
      RowBox[{"{", 
       RowBox[{"\"\<\\\\tiny\>\"", ",", "\"\<\\\\scriptsize\>\"", 
        ",", "\"\<\\\\footnotesize\>\"", ",", "\"\<\\\\small\>\"", 
        ",", "\"\<\\\\normalsize\>\"", ",", "\"\<\\\\large\>\"", 
        ",", "\"\<\\\\Large\>\"", ",", "\"\<\\\\huge\>\"", 
        ",", "\"\<\\\\Huge\>\""}], "}"}], "]"}]}], ",", 
    RowBox[{"anclajetexto", "=", 
     RowBox[{"RandomChoice", "[", 
      RowBox[{"{", 
       RowBox[{"\"\<north\>\"", ",", "\"\<south\>\"", ",", "\"\<east\>\"", 
        ",", "\"\<west\>\"", ",", "\"\<north east\>\"", 
        ",", "\"\<north west\>\"", ",", "\"\<south east\>\"", 
        ",", "\"\<south west\>\"", ",", "\"\<center\>\""}], "}"}], "]"}]}], ",", 
    RowBox[{"rotatexto", "=", 
     RowBox[{"RandomReal", "[", 
      RowBox[{"{", 
       RowBox[{"0", ",", "360"}], "}"}], "]"}]}]}], "}"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<grid=\>\"", ",", 
      RowBox[{"grid", "=", 
       RowBox[{"RandomChoice", "[", 
        RowBox[{"{", 
         RowBox[{"True", ",", "False"}], "}"}], "]"}]}]}], "}"}], "]"}], ",", 
   
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<estiloejes=\>\"", ",", 
      RowBox[{"estiloejes", "=", 
       RowBox[{"RandomChoice", "[", 
        RowBox[{"{", 
         RowBox[{"\"\<box\>\"", ",", "\"\<center\>\"", ",", "\"\<none\>\""}], 
         "}"}], "]"}]}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<extensionejes=\>\"", ",", 
      RowBox[{"extensionejes", "=", 
       RowBox[{"RandomReal", "[", 
        RowBox[{"{", 
         RowBox[{"0.1", ",", "0.4"}], "}"}], "]"}]}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<resolucion=\>\"", ",", 
      RowBox[{"resolucion", "=", 
       RowBox[{"RandomInteger", "[", 
        RowBox[{"{", 
         RowBox[{"20", ",", "80"}], "}"}], "]"}]}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<texto=\>\"", ",", 
      RowBox[{"texto", "=", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"\"\<Varias figuras 3D\>\"", ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "3"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"\"\<color\>\"", ",", 
              RowBox[{"colortexto", "[", "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"\"\<size\>\"", ",", "sizetexto"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"\"\<anchor\>\"", ",", "anclajetexto"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"\"\<rotate\>\"", ",", "rotatexto"}], "}"}]}], "}"}]}], 
         "}"}], "}"}]}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<maxpoligonos=\>\"", ",", 
      RowBox[{"maxpoligonos", "=", 
       RowBox[{"RandomInteger", "[", 
        RowBox[{"{", 
         RowBox[{"500", ",", "700"}], "}"}], "]"}]}]}], "}"}], "]"}]}], 
  "}"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ExportToTikZGraphics3D", "[", 
   RowBox[{
   "graphics3D6", ",", "\"\<graphics3D6.tex\>\"", ",", "grid", ",", 
    "estiloejes", ",", "extensionejes", ",", "resolucion", ",", "texto", ",", 
    "maxpoligonos"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.9672119087853737`*^9, 3.9672119379522266`*^9}, {
   3.9672124158047714`*^9, 3.9672124169920673`*^9}, {3.9672125091332073`*^9, 
   3.967212509516527*^9}, 3.967215118272312*^9, 3.9672153493759117`*^9, 
   3.967215399698557*^9, 3.9672154834242916`*^9, {3.967215894878084*^9, 
   3.96721589545516*^9}, {3.9672160731381874`*^9, 3.967216073402502*^9}, 
   3.967274548151237*^9, {3.967281756689152*^9, 3.9672817571213827`*^9}, 
   3.9672821011003933`*^9, {3.967284111264484*^9, 3.9672841146579933`*^9}, {
   3.9672844241838303`*^9, 3.967284424425992*^9}, 3.967287294123911*^9, 
   3.967287493530364*^9},
 CellLabel->
  "In[198]:=",ExpressionUUID->"6db1a34b-86a4-104b-98e8-0e90570a0acd"],

Cell[BoxData[
 Graphics3DBox[{
   {RGBColor[0, 0, 1], Opacity[0.5], SphereBox[{0, 0, 0}, 1.5]}, 
   {RGBColor[1, 0.5, 0], Opacity[0.6], 
    CylinderBox[{{-3, -1, -1}, {-3, -1, 2}}, 0.6]}, 
   {GrayLevel[0.2], Specularity[
     GrayLevel[1], 20], CuboidBox[{2, -2, -1}, {3.5, -0.5, 1}]}, 
   {EdgeForm[{GrayLevel[0], Thickness[Tiny]}], 
    {RGBColor[1., 0.2, 0.2], Opacity[0.8], 
     Polygon3DBox[{{0, 3, 0}, {1, 2, 0}, {-1, 2, 0}}], 
     Polygon3DBox[{{0, 4, 1.5}, {0, 3, 0}, {1, 2, 0}}], 
     Polygon3DBox[{{0, 4, 1.5}, {1, 2, 0}, {-1, 2, 0}}], 
     Polygon3DBox[{{0, 4, 1.5}, {-1, 2, 0}, {0, 3, 0}}]}, 
    {RGBColor[0, 
      NCache[
       Rational[2, 3], 0.6666666666666666], 0], Thickness[Large], 
     TubeBox[Line3DBox[CompressedData["
1:eJxd2Hc8Vf8fwHF7b1pIJVFGCqWh3h9KaSslpJSknYZvvpT27qsolZSMIqWM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      "]], 0.07]}, 
    {GrayLevel[0], PointSize[Large], Point3DBox[{0, 0, 0}]}, Text3DBox[
     StyleBox["\<\"Centro\"\>",
      StripOnInput->False,
      FontSize->14,
      FontWeight->Bold], {0, 0, 0.2}], 
    Arrow3DBox[{{-3, -1, 2.8}, {-1.2, -0.4, 1.6}}]}},
  Axes->True,
  Boxed->True,
  Lighting->"Neutral",
  PlotRange->All,
  SphericalRegion->True]], "Output",
 CellChangeTimes->{{3.967282280175211*^9, 3.967282298971485*^9}, 
   3.967282485975017*^9, 3.967284424805998*^9, {3.967287296030323*^9, 
   3.967287311477428*^9}, {3.967287796917276*^9, 3.967287816319523*^9}},
 CellLabel->
  "Out[198]=",ExpressionUUID->"f896f7d2-1a9a-4180-9f55-07e2f7addb59"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TemplateBox[{"\"grid=\"", "False"},
    "RowDefault"], ",", 
   TemplateBox[{"\"estiloejes=\"", "\"none\""},
    "RowDefault"], ",", 
   TemplateBox[{"\"extensionejes=\"", "0.32074905944228976`"},
    "RowDefault"], ",", 
   TemplateBox[{"\"resolucion=\"", "76"},
    "RowDefault"], ",", 
   TemplateBox[{"\"texto=\"", 
     RowBox[{"{", 
       RowBox[{"{", 
         RowBox[{"\"Varias figuras 3D\"", ",", 
           RowBox[{"{", 
             RowBox[{"0", ",", "0", ",", "3"}], "}"}], ",", 
           RowBox[{"{", 
             RowBox[{
               RowBox[{"{", 
                 RowBox[{"\"color\"", ",", "\"purple\""}], "}"}], ",", 
               RowBox[{"{", 
                 RowBox[{"\"size\"", ",", "\"\\\\large\""}], "}"}], ",", 
               RowBox[{"{", 
                 RowBox[{"\"anchor\"", ",", "\"south east\""}], "}"}], ",", 
               RowBox[{"{", 
                 RowBox[{"\"rotate\"", ",", "348.65060799273624`"}], "}"}]}], 
             "}"}]}], "}"}], "}"}]},
    "RowDefault"], ",", 
   TemplateBox[{"\"maxpoligonos=\"", "692"},
    "RowDefault"]}], "}"}]], "Output",
 CellChangeTimes->{{3.967282280175211*^9, 3.967282298971485*^9}, 
   3.967282485975017*^9, 3.967284424805998*^9, {3.967287296030323*^9, 
   3.967287311477428*^9}, {3.967287796917276*^9, 3.967287816322813*^9}},
 CellLabel->
  "Out[200]=",ExpressionUUID->"9d9a068a-88db-4675-acc7-b4d78f68f128"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.9672822802501593`*^9, 3.967282299030986*^9}, 
   3.9672824860380783`*^9, 3.967284424878407*^9, {3.967287296094688*^9, 
   3.967287311534402*^9}, {3.967287796978662*^9, 3.9672878163826923`*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[198]:=",ExpressionUUID->"2261a512-a7d5-4854-9760-5e2954bdfa6c"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{{3.9672822802501593`*^9, 3.967282299030986*^9}, 
   3.9672824860380783`*^9, 3.967284424878407*^9, {3.967287296094688*^9, 
   3.967287311534402*^9}, {3.967287796978662*^9, 3.967287816383376*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[198]:=",ExpressionUUID->"db164e7b-763a-4826-b8a4-0f79f2f7a611"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.9672822802501593`*^9, 3.967282299030986*^9}, 
   3.9672824860380783`*^9, 3.967284424878407*^9, {3.967287296094688*^9, 
   3.967287311534402*^9}, {3.967287796978662*^9, 3.967287816383946*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[198]:=",ExpressionUUID->"0dd77502-5678-4193-aecf-3d1c5e024a0b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.9672822802501593`*^9, 3.967282299030986*^9}, 
   3.9672824860380783`*^9, 3.967284424878407*^9, {3.967287296094688*^9, 
   3.967287311534402*^9}, {3.967287796978662*^9, 3.967287816384335*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[198]:=",ExpressionUUID->"041f6e8c-cd74-4f87-a0ca-f739b42ef2be"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.9672822802501593`*^9, 3.967282299030986*^9}, 
   3.9672824860380783`*^9, 3.967284424878407*^9, {3.967287296094688*^9, 
   3.967287311534402*^9}, {3.967287796978662*^9, 3.967287816384664*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[198]:=",ExpressionUUID->"d0d8060a-842c-431c-831d-6ab81abac72f"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{{3.9672822802501593`*^9, 3.967282299030986*^9}, 
   3.9672824860380783`*^9, 3.967284424878407*^9, {3.967287296094688*^9, 
   3.967287311534402*^9}, {3.967287796978662*^9, 3.967287816429688*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[198]:=",ExpressionUUID->"d02dcd2c-4292-4367-9e65-957aeae444a6"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{{3.9672822802501593`*^9, 3.967282299030986*^9}, 
   3.9672824860380783`*^9, 3.967284424878407*^9, {3.967287296094688*^9, 
   3.967287311534402*^9}, {3.967287796978662*^9, 3.9672878174472923`*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[198]:=",ExpressionUUID->"c161a936-1e3b-4254-b5f5-c33f9f4da583"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/graphics3D6/\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", 
   "/Users/enriquevilchezquesada/Downloads/graphics3D6/"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.9672822802501593`*^9, 3.967282299030986*^9}, 
   3.9672824860380783`*^9, 3.967284424878407*^9, {3.967287296094688*^9, 
   3.967287311534402*^9}, {3.967287796978662*^9, 3.967287817448164*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[198]:=",ExpressionUUID->"9dddf9d6-f695-4f92-ac1a-34687c377c1c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"graphics3D6\"\>"}],
  SequenceForm["Archivo: ", "graphics3D6"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.9672822802501593`*^9, 3.967282299030986*^9}, 
   3.9672824860380783`*^9, 3.967284424878407*^9, {3.967287296094688*^9, 
   3.967287311534402*^9}, {3.967287796978662*^9, 3.967287817448579*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[198]:=",ExpressionUUID->"3b96fee5-0fa4-4a5f-8f0f-410b573c985d"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{{3.9672822802501593`*^9, 3.967282299030986*^9}, 
   3.9672824860380783`*^9, 3.967284424878407*^9, {3.967287296094688*^9, 
   3.967287311534402*^9}, {3.967287796978662*^9, 3.967287818382972*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[198]:=",ExpressionUUID->"43f7ac2e-8963-48f3-8dd8-d2c16e50893d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/graphics3D6/graphics3D6.pdf\"\>"}],
  SequenceForm[
  "PDF generado: ", 
   "/Users/enriquevilchezquesada/Downloads/graphics3D6/graphics3D6.pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.9672822802501593`*^9, 3.967282299030986*^9}, 
   3.9672824860380783`*^9, 3.967284424878407*^9, {3.967287296094688*^9, 
   3.967287311534402*^9}, {3.967287796978662*^9, 3.9672878183836107`*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[198]:=",ExpressionUUID->"35b52018-e1a7-4c33-afb4-07db54709b07"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/graphics3D6/\
graphics3D6.pdf\"\>"], "Output",
 CellChangeTimes->{{3.967282280175211*^9, 3.967282298971485*^9}, 
   3.967282485975017*^9, 3.967284424805998*^9, {3.967287296030323*^9, 
   3.967287311477428*^9}, {3.967287796917276*^9, 3.967287818396234*^9}},
 CellLabel->
  "Out[202]=",ExpressionUUID->"48f57559-41df-40bf-8a98-86802f4b3d13"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Ejemplo 7: cilindro Graphics3D (no es capaz de dibujarlo completamente por la \
cantidad de puntos necesarios)\
\>", "Subsection",
 CellChangeTimes->{{3.967211284283127*^9, 3.9672112867661*^9}, 
   3.9672113376297913`*^9, {3.9672117098253307`*^9, 3.9672117192270164`*^9}, {
   3.967282337342526*^9, 
   3.967282359227757*^9}},ExpressionUUID->"f03bf92f-685c-7f41-8fc8-\
f2eae7d40ef0"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"graphics3D7", "=", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"m", "=", "40"}], ",", 
       RowBox[{"n", "=", "20"}], ",", 
       RowBox[{"f", "=", 
        RowBox[{"Function", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"u", ",", "v"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"2", " ", 
             RowBox[{"Cos", "[", "u", "]"}]}], ",", 
            RowBox[{"2", " ", 
             RowBox[{"Sin", "[", "u", "]"}]}], ",", "v"}], "}"}]}], "]"}]}]}],
       "}"}], ",", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"du", "=", 
          RowBox[{"2", " ", 
           RowBox[{"Pi", "/", "m"}]}]}], ",", 
         RowBox[{"dv", "=", 
          RowBox[{"6.", "/", "n"}]}], ",", "quads"}], "}"}], ",", 
       RowBox[{
        RowBox[{"quads", "=", 
         RowBox[{"Flatten", "@", 
          RowBox[{"Table", "[", 
           RowBox[{
            RowBox[{"Polygon", "@", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"f", "[", 
                RowBox[{"u", ",", "v"}], "]"}], ",", 
               RowBox[{"f", "[", 
                RowBox[{
                 RowBox[{"u", "+", "du"}], ",", "v"}], "]"}], ",", 
               RowBox[{"f", "[", 
                RowBox[{
                 RowBox[{"u", "+", "du"}], ",", 
                 RowBox[{"v", "+", "dv"}]}], "]"}], ",", 
               RowBox[{"f", "[", 
                RowBox[{"u", ",", 
                 RowBox[{"v", "+", "dv"}]}], "]"}]}], "}"}]}], ",", 
            RowBox[{"{", 
             RowBox[{"u", ",", "0", ",", 
              RowBox[{
               RowBox[{"2", " ", "Pi"}], "-", "du"}], ",", "du"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"v", ",", 
              RowBox[{"-", "3"}], ",", 
              RowBox[{"3", "-", "dv"}], ",", "dv"}], "}"}]}], "]"}]}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"Graphics3D", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Opacity", "[", ".7", "]"}], ",", 
            RowBox[{"EdgeForm", "[", 
             RowBox[{"Directive", "[", 
              RowBox[{"Gray", ",", "Thin"}], "]"}], "]"}], ",", "Gray", ",", 
            "quads"}], "}"}], ",", 
          RowBox[{"PlotRange", "->", "All"}], ",", 
          RowBox[{"Boxed", "->", "True"}], ",", 
          RowBox[{"Lighting", "->", "\"\<Neutral\>\""}]}], "]"}]}]}], "]"}]}],
     "]"}]}], "\[IndentingNewLine]"}], "\n", 
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"colortexto", "[", "]"}], ":=", 
     RowBox[{"RandomChoice", "[", 
      RowBox[{"{", 
       RowBox[{"\"\<black\>\"", ",", "\"\<blue\>\"", ",", "\"\<brown\>\"", 
        ",", "\"\<cyan\>\"", ",", "\"\<darkgray\>\"", ",", "\"\<gray\>\"", 
        ",", "\"\<green\>\"", ",", "\"\<lightgray\>\"", ",", "\"\<lime\>\"", 
        ",", "\"\<magenta\>\"", ",", "\"\<olive\>\"", ",", "\"\<orange\>\"", 
        ",", "\"\<pink\>\"", ",", "\"\<purple\>\"", ",", "\"\<red\>\"", 
        ",", "\"\<teal\>\"", ",", "\"\<violet\>\"", ",", "\"\<yellow\>\""}], 
       "}"}], "]"}]}], ",", 
    RowBox[{"sizetexto", "=", 
     RowBox[{"RandomChoice", "[", 
      RowBox[{"{", 
       RowBox[{"\"\<\\\\tiny\>\"", ",", "\"\<\\\\scriptsize\>\"", 
        ",", "\"\<\\\\footnotesize\>\"", ",", "\"\<\\\\small\>\"", 
        ",", "\"\<\\\\normalsize\>\"", ",", "\"\<\\\\large\>\"", 
        ",", "\"\<\\\\Large\>\"", ",", "\"\<\\\\huge\>\"", 
        ",", "\"\<\\\\Huge\>\""}], "}"}], "]"}]}], ",", 
    RowBox[{"anclajetexto", "=", 
     RowBox[{"RandomChoice", "[", 
      RowBox[{"{", 
       RowBox[{"\"\<north\>\"", ",", "\"\<south\>\"", ",", "\"\<east\>\"", 
        ",", "\"\<west\>\"", ",", "\"\<north east\>\"", 
        ",", "\"\<north west\>\"", ",", "\"\<south east\>\"", 
        ",", "\"\<south west\>\"", ",", "\"\<center\>\""}], "}"}], "]"}]}], ",", 
    RowBox[{"rotatexto", "=", 
     RowBox[{"RandomReal", "[", 
      RowBox[{"{", 
       RowBox[{"0", ",", "360"}], "}"}], "]"}]}]}], "}"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<grid=\>\"", ",", 
      RowBox[{"grid", "=", 
       RowBox[{"RandomChoice", "[", 
        RowBox[{"{", 
         RowBox[{"True", ",", "False"}], "}"}], "]"}]}]}], "}"}], "]"}], ",", 
   
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<estiloejes=\>\"", ",", 
      RowBox[{"estiloejes", "=", 
       RowBox[{"RandomChoice", "[", 
        RowBox[{"{", 
         RowBox[{"\"\<box\>\"", ",", "\"\<center\>\"", ",", "\"\<none\>\""}], 
         "}"}], "]"}]}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<extensionejes=\>\"", ",", 
      RowBox[{"extensionejes", "=", 
       RowBox[{"RandomReal", "[", 
        RowBox[{"{", 
         RowBox[{"0.1", ",", "0.4"}], "}"}], "]"}]}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<resolucion=\>\"", ",", 
      RowBox[{"resolucion", "=", 
       RowBox[{"RandomInteger", "[", 
        RowBox[{"{", 
         RowBox[{"20", ",", "80"}], "}"}], "]"}]}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<texto=\>\"", ",", 
      RowBox[{"texto", "=", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"\"\<Cilindro\>\"", ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "3"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"\"\<color\>\"", ",", 
              RowBox[{"colortexto", "[", "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"\"\<size\>\"", ",", "sizetexto"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"\"\<anchor\>\"", ",", "anclajetexto"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"\"\<rotate\>\"", ",", "rotatexto"}], "}"}]}], "}"}]}], 
         "}"}], "}"}]}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<maxpoligonos=\>\"", ",", 
      RowBox[{"maxpoligonos", "=", 
       RowBox[{"RandomInteger", "[", 
        RowBox[{"{", 
         RowBox[{"500", ",", "700"}], "}"}], "]"}]}]}], "}"}], "]"}]}], 
  "}"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ExportToTikZGraphics3D", "[", 
   RowBox[{
   "graphics3D7", ",", "\"\<graphics3D7.tex\>\"", ",", "grid", ",", 
    "estiloejes", ",", "extensionejes", ",", "resolucion", ",", "texto", ",", 
    "maxpoligonos"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.9672118959994125`*^9, 3.967211897063753*^9}, {
   3.9672124219916763`*^9, 3.967212422888378*^9}, {3.9672125141493893`*^9, 
   3.96721251449189*^9}, 3.9672151275237446`*^9, 3.967215219510689*^9, 
   3.9672154025839863`*^9, 3.9672154891509*^9, {3.9672159115088634`*^9, 
   3.967215912605566*^9}, {3.967216081122942*^9, 3.967216081441025*^9}, 
   3.9672745552163258`*^9, {3.967281764537737*^9, 3.9672817649280043`*^9}, {
   3.967282112828237*^9, 3.9672821223382483`*^9}, {3.967284126464716*^9, 
   3.967284134398529*^9}, {3.967284393406803*^9, 3.967284393560915*^9}, 
   3.9672875049727993`*^9, {3.967287591857283*^9, 3.9672875922109547`*^9}},
 CellLabel->
  "In[203]:=",ExpressionUUID->"e0b591af-0b19-3945-828b-76a4a61f87d9"],

Cell[BoxData[
 Graphics3DBox[
  {GrayLevel[0.5], Opacity[0.7], EdgeForm[{GrayLevel[0.5], Thickness[Tiny]}], 
   Polygon3DBox[
    NCache[{{2, 0, -3.}, {
      2 Cos[Rational[1, 20] Pi], 2 Sin[Rational[1, 20] Pi], -3.}, {
      2 Cos[Rational[1, 20] Pi], 2 Sin[Rational[1, 20] Pi], -2.7}, {
      2, 0, -2.7}}, {{2, 0, -3.}, {1.9753766811902755`, 
      0.31286893008046174`, -3.}, {1.9753766811902755`, 
      0.31286893008046174`, -2.7}, {2, 0, -2.7}}]], 
   Polygon3DBox[
    NCache[{{2, 0, -2.7}, {
      2 Cos[Rational[1, 20] Pi], 2 Sin[Rational[1, 20] Pi], -2.7}, {
      2 Cos[Rational[1, 20] Pi], 2 
       Sin[Rational[1, 20] Pi], -2.4000000000000004`}, {
      2, 0, -2.4000000000000004`}}, {{2, 0, -2.7}, {1.9753766811902755`, 
      0.31286893008046174`, -2.7}, {1.9753766811902755`, 
      0.31286893008046174`, -2.4000000000000004`}, {
      2, 0, -2.4000000000000004`}}]], 
   Polygon3DBox[
    NCache[{{2, 0, -2.4}, {
      2 Cos[Rational[1, 20] Pi], 2 Sin[Rational[1, 20] Pi], -2.4}, {
      2 Cos[Rational[1, 20] Pi], 2 
       Sin[Rational[1, 20] Pi], -2.0999999999999996`}, {
      2, 0, -2.0999999999999996`}}, {{2, 0, -2.4}, {1.9753766811902755`, 
      0.31286893008046174`, -2.4}, {1.9753766811902755`, 
      0.31286893008046174`, -2.0999999999999996`}, {
      2, 0, -2.0999999999999996`}}]], 
   Polygon3DBox[
    NCache[{{2, 0, -2.0999999999999996`}, {
      2 Cos[Rational[1, 20] Pi], 2 
       Sin[Rational[1, 20] Pi], -2.0999999999999996`}, {
      2 Cos[Rational[1, 20] Pi], 2 
       Sin[Rational[1, 20] Pi], -1.7999999999999996`}, {
      2, 0, -1.7999999999999996`}}, {{2, 0, -2.0999999999999996`}, {
      1.9753766811902755`, 0.31286893008046174`, -2.0999999999999996`}, {
      1.9753766811902755`, 0.31286893008046174`, -1.7999999999999996`}, {
      2, 0, -1.7999999999999996`}}]], 
   Polygon3DBox[
    NCache[{{2, 0, -1.7999999999999998`}, {
      2 Cos[Rational[1, 20] Pi], 2 
       Sin[Rational[1, 20] Pi], -1.7999999999999998`}, {
      2 Cos[Rational[1, 20] Pi], 2 
       Sin[Rational[1, 20] Pi], -1.4999999999999998`}, {
      2, 0, -1.4999999999999998`}}, {{2, 0, -1.7999999999999998`}, {
      1.9753766811902755`, 0.31286893008046174`, -1.7999999999999998`}, {
      1.9753766811902755`, 0.31286893008046174`, -1.4999999999999998`}, {
      2, 0, -1.4999999999999998`}}]], 
   Polygon3DBox[
    NCache[{{2, 0, -1.4999999999999998`}, {
      2 Cos[Rational[1, 20] Pi], 2 
       Sin[Rational[1, 20] Pi], -1.4999999999999998`}, {
      2 Cos[Rational[1, 20] Pi], 2 
       Sin[Rational[1, 20] Pi], -1.1999999999999997`}, {
      2, 0, -1.1999999999999997`}}, {{2, 0, -1.4999999999999998`}, {
      1.9753766811902755`, 0.31286893008046174`, -1.4999999999999998`}, {
      1.9753766811902755`, 0.31286893008046174`, -1.1999999999999997`}, {
      2, 0, -1.1999999999999997`}}]], 
   Polygon3DBox[
    NCache[{{2, 0, -1.1999999999999997`}, {
      2 Cos[Rational[1, 20] Pi], 2 
       Sin[Rational[1, 20] Pi], -1.1999999999999997`}, {
      2 Cos[Rational[1, 20] Pi], 2 
       Sin[Rational[1, 20] Pi], -0.8999999999999997}, {
      2, 0, -0.8999999999999997}}, {{2, 0, -1.1999999999999997`}, {
      1.9753766811902755`, 0.31286893008046174`, -1.1999999999999997`}, {
      1.9753766811902755`, 0.31286893008046174`, -0.8999999999999997}, {
      2, 0, -0.8999999999999997}}]], 
   Polygon3DBox[
    NCache[{{2, 0, -0.8999999999999997}, {
      2 Cos[Rational[1, 20] Pi], 2 
       Sin[Rational[1, 20] Pi], -0.8999999999999997}, {
      2 Cos[Rational[1, 20] Pi], 2 
       Sin[Rational[1, 20] Pi], -0.5999999999999996}, {
      2, 0, -0.5999999999999996}}, {{2, 0, -0.8999999999999997}, {
      1.9753766811902755`, 0.31286893008046174`, -0.8999999999999997}, {
      1.9753766811902755`, 0.31286893008046174`, -0.5999999999999996}, {
      2, 0, -0.5999999999999996}}]], 
   Polygon3DBox[
    NCache[{{2, 0, -0.5999999999999996}, {
      2 Cos[Rational[1, 20] Pi], 2 
       Sin[Rational[1, 20] Pi], -0.5999999999999996}, {
      2 Cos[Rational[1, 20] Pi], 2 
       Sin[Rational[1, 20] Pi], -0.2999999999999996}, {
      2, 0, -0.2999999999999996}}, {{2, 0, -0.5999999999999996}, {
      1.9753766811902755`, 0.31286893008046174`, -0.5999999999999996}, {
      1.9753766811902755`, 0.31286893008046174`, -0.2999999999999996}, {
      2, 0, -0.2999999999999996}}]], 
   Polygon3DBox[
    NCache[{{2, 0, -0.2999999999999996}, {
      2 Cos[Rational[1, 20] Pi], 2 
       Sin[Rational[1, 20] Pi], -0.2999999999999996}, {
      2 Cos[Rational[1, 20] Pi], 2 Sin[Rational[1, 20] Pi], 
       4.440892098500626*^-16}, {2, 0, 4.440892098500626*^-16}}, {{
      2, 0, -0.2999999999999996}, {1.9753766811902755`, 
      0.31286893008046174`, -0.2999999999999996}, {1.9753766811902755`, 
      0.31286893008046174`, 4.440892098500626*^-16}, {
      2, 0, 4.440892098500626*^-16}}]], 
   Polygon3DBox[
    NCache[{{2, 0, 4.440892098500626*^-16}, {
      2 Cos[Rational[1, 20] Pi], 2 Sin[Rational[1, 20] Pi], 
       4.440892098500626*^-16}, {
      2 Cos[Rational[1, 20] Pi], 2 Sin[Rational[1, 20] Pi], 
       0.3000000000000005}, {2, 0, 0.3000000000000005}}, {{
      2, 0, 4.440892098500626*^-16}, {1.9753766811902755`, 
      0.31286893008046174`, 4.440892098500626*^-16}, {1.9753766811902755`, 
      0.31286893008046174`, 0.3000000000000005}, {
      2, 0, 0.3000000000000005}}]], 
   Polygon3DBox[
    NCache[{{2, 0, 0.3000000000000005}, {
      2 Cos[Rational[1, 20] Pi], 2 Sin[Rational[1, 20] Pi], 
       0.3000000000000005}, {
      2 Cos[Rational[1, 20] Pi], 2 Sin[Rational[1, 20] Pi], 
       0.6000000000000005}, {2, 0, 0.6000000000000005}}, {{
      2, 0, 0.3000000000000005}, {1.9753766811902755`, 0.31286893008046174`, 
      0.3000000000000005}, {1.9753766811902755`, 0.31286893008046174`, 
      0.6000000000000005}, {2, 0, 0.6000000000000005}}]], 
   Polygon3DBox[
    NCache[{{2, 0, 0.6000000000000005}, {
      2 Cos[Rational[1, 20] Pi], 2 Sin[Rational[1, 20] Pi], 
       0.6000000000000005}, {
      2 Cos[Rational[1, 20] Pi], 2 Sin[Rational[1, 20] Pi], 
       0.9000000000000006}, {2, 0, 0.9000000000000006}}, {{
      2, 0, 0.6000000000000005}, {1.9753766811902755`, 0.31286893008046174`, 
      0.6000000000000005}, {1.9753766811902755`, 0.31286893008046174`, 
      0.9000000000000006}, {2, 0, 0.9000000000000006}}]], 
   Polygon3DBox[
    NCache[{{2, 0, 0.9000000000000006}, {
      2 Cos[Rational[1, 20] Pi], 2 Sin[Rational[1, 20] Pi], 
       0.9000000000000006}, {
      2 Cos[Rational[1, 20] Pi], 2 Sin[Rational[1, 20] Pi], 
       1.2000000000000006`}, {2, 0, 1.2000000000000006`}}, {{
      2, 0, 0.9000000000000006}, {1.9753766811902755`, 0.31286893008046174`, 
      0.9000000000000006}, {1.9753766811902755`, 0.31286893008046174`, 
      1.2000000000000006`}, {2, 0, 1.2000000000000006`}}]], 
   Polygon3DBox[
    NCache[{{2, 0, 1.2000000000000006`}, {
      2 Cos[Rational[1, 20] Pi], 2 Sin[Rational[1, 20] Pi], 
       1.2000000000000006`}, {
      2 Cos[Rational[1, 20] Pi], 2 Sin[Rational[1, 20] Pi], 
       1.5000000000000007`}, {2, 0, 1.5000000000000007`}}, {{
      2, 0, 1.2000000000000006`}, {1.9753766811902755`, 0.31286893008046174`, 
      1.2000000000000006`}, {1.9753766811902755`, 0.31286893008046174`, 
      1.5000000000000007`}, {2, 0, 1.5000000000000007`}}]], 
   Polygon3DBox[
    NCache[{{2, 0, 1.5000000000000007`}, {
      2 Cos[Rational[1, 20] Pi], 2 Sin[Rational[1, 20] Pi], 
       1.5000000000000007`}, {
      2 Cos[Rational[1, 20] Pi], 2 Sin[Rational[1, 20] Pi], 
       1.8000000000000007`}, {2, 0, 1.8000000000000007`}}, {{
      2, 0, 1.5000000000000007`}, {1.9753766811902755`, 0.31286893008046174`, 
      1.5000000000000007`}, {1.9753766811902755`, 0.31286893008046174`, 
      1.8000000000000007`}, {2, 0, 1.8000000000000007`}}]], 
   Polygon3DBox[
    NCache[{{2, 0, 1.8000000000000007`}, {
      2 Cos[Rational[1, 20] Pi], 2 Sin[Rational[1, 20] Pi], 
       1.8000000000000007`}, {
      2 Cos[Rational[1, 20] Pi], 2 Sin[Rational[1, 20] Pi], 
       2.1000000000000005`}, {2, 0, 2.1000000000000005`}}, {{
      2, 0, 1.8000000000000007`}, {1.9753766811902755`, 0.31286893008046174`, 
      1.8000000000000007`}, {1.9753766811902755`, 0.31286893008046174`, 
      2.1000000000000005`}, {2, 0, 2.1000000000000005`}}]], 
   Polygon3DBox[
    NCache[{{2, 0, 2.1000000000000005`}, {
      2 Cos[Rational[1, 20] Pi], 2 Sin[Rational[1, 20] Pi], 
       2.1000000000000005`}, {
      2 Cos[Rational[1, 20] Pi], 2 Sin[Rational[1, 20] Pi], 
       2.4000000000000004`}, {2, 0, 2.4000000000000004`}}, {{
      2, 0, 2.1000000000000005`}, {1.9753766811902755`, 0.31286893008046174`, 
      2.1000000000000005`}, {1.9753766811902755`, 0.31286893008046174`, 
      2.4000000000000004`}, {2, 0, 2.4000000000000004`}}]], 
   Polygon3DBox[
    NCache[{{2, 0, 2.400000000000001}, {
      2 Cos[Rational[1, 20] Pi], 2 Sin[Rational[1, 20] Pi], 
       2.400000000000001}, {
      2 Cos[Rational[1, 20] Pi], 2 Sin[Rational[1, 20] Pi], 
       2.700000000000001}, {2, 0, 2.700000000000001}}, {{
      2, 0, 2.400000000000001}, {1.9753766811902755`, 0.31286893008046174`, 
      2.400000000000001}, {1.9753766811902755`, 0.31286893008046174`, 
      2.700000000000001}, {2, 0, 2.700000000000001}}]], 
   Polygon3DBox[
    NCache[{{2, 0, 2.700000000000001}, {
      2 Cos[Rational[1, 20] Pi], 2 Sin[Rational[1, 20] Pi], 
       2.700000000000001}, {
      2 Cos[Rational[1, 20] Pi], 2 Sin[Rational[1, 20] Pi], 
       3.000000000000001}, {2, 0, 3.000000000000001}}, {{
      2, 0, 2.700000000000001}, {1.9753766811902755`, 0.31286893008046174`, 
      2.700000000000001}, {1.9753766811902755`, 0.31286893008046174`, 
      3.000000000000001}, {2, 0, 3.000000000000001}}]], 
   Polygon3DBox[
    NCache[{{2 Cos[Rational[1, 20] Pi], 2 Sin[Rational[1, 20] Pi], -3.}, {
      2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 + 5^Rational[1, 2]), -3.}, {
      2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 + 5^Rational[1, 2]), -2.7}, {
      2 Cos[Rational[1, 20] Pi], 2 Sin[Rational[1, 20] Pi], -2.7}}, {{
     1.9753766811902755`, 0.31286893008046174`, -3.}, {1.902113032590307, 
     0.6180339887498949, -3.}, {1.902113032590307, 
     0.6180339887498949, -2.7}, {1.9753766811902755`, 
     0.31286893008046174`, -2.7}}]], 
   Polygon3DBox[
    NCache[{{2 Cos[Rational[1, 20] Pi], 2 Sin[Rational[1, 20] Pi], -2.7}, {
      2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 + 5^Rational[1, 2]), -2.7}, {
      2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 + 5^Rational[1, 2]), -2.4000000000000004`}, {
      2 Cos[Rational[1, 20] Pi], 2 
       Sin[Rational[1, 20] Pi], -2.4000000000000004`}}, {{1.9753766811902755`,
      0.31286893008046174`, -2.7}, {1.902113032590307, 
     0.6180339887498949, -2.7}, {1.902113032590307, 
     0.6180339887498949, -2.4000000000000004`}, {1.9753766811902755`, 
     0.31286893008046174`, -2.4000000000000004`}}]], 
   Polygon3DBox[
    NCache[{{2 Cos[Rational[1, 20] Pi], 2 Sin[Rational[1, 20] Pi], -2.4}, {
      2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 + 5^Rational[1, 2]), -2.4}, {
      2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 + 5^Rational[1, 2]), -2.0999999999999996`}, {
      2 Cos[Rational[1, 20] Pi], 2 
       Sin[Rational[1, 20] Pi], -2.0999999999999996`}}, {{1.9753766811902755`,
      0.31286893008046174`, -2.4}, {1.902113032590307, 
     0.6180339887498949, -2.4}, {1.902113032590307, 
     0.6180339887498949, -2.0999999999999996`}, {1.9753766811902755`, 
     0.31286893008046174`, -2.0999999999999996`}}]], 
   Polygon3DBox[
    NCache[{{2 Cos[Rational[1, 20] Pi], 2 
       Sin[Rational[1, 20] Pi], -2.0999999999999996`}, {
      2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 + 5^Rational[1, 2]), -2.0999999999999996`}, {
      2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 + 5^Rational[1, 2]), -1.7999999999999996`}, {
      2 Cos[Rational[1, 20] Pi], 2 
       Sin[Rational[1, 20] Pi], -1.7999999999999996`}}, {{1.9753766811902755`,
      0.31286893008046174`, -2.0999999999999996`}, {1.902113032590307, 
     0.6180339887498949, -2.0999999999999996`}, {1.902113032590307, 
     0.6180339887498949, -1.7999999999999996`}, {1.9753766811902755`, 
     0.31286893008046174`, -1.7999999999999996`}}]], 
   Polygon3DBox[
    NCache[{{2 Cos[Rational[1, 20] Pi], 2 
       Sin[Rational[1, 20] Pi], -1.7999999999999998`}, {
      2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 + 5^Rational[1, 2]), -1.7999999999999998`}, {
      2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 + 5^Rational[1, 2]), -1.4999999999999998`}, {
      2 Cos[Rational[1, 20] Pi], 2 
       Sin[Rational[1, 20] Pi], -1.4999999999999998`}}, {{1.9753766811902755`,
      0.31286893008046174`, -1.7999999999999998`}, {1.902113032590307, 
     0.6180339887498949, -1.7999999999999998`}, {1.902113032590307, 
     0.6180339887498949, -1.4999999999999998`}, {1.9753766811902755`, 
     0.31286893008046174`, -1.4999999999999998`}}]], 
   Polygon3DBox[
    NCache[{{2 Cos[Rational[1, 20] Pi], 2 
       Sin[Rational[1, 20] Pi], -1.4999999999999998`}, {
      2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 + 5^Rational[1, 2]), -1.4999999999999998`}, {
      2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 + 5^Rational[1, 2]), -1.1999999999999997`}, {
      2 Cos[Rational[1, 20] Pi], 2 
       Sin[Rational[1, 20] Pi], -1.1999999999999997`}}, {{1.9753766811902755`,
      0.31286893008046174`, -1.4999999999999998`}, {1.902113032590307, 
     0.6180339887498949, -1.4999999999999998`}, {1.902113032590307, 
     0.6180339887498949, -1.1999999999999997`}, {1.9753766811902755`, 
     0.31286893008046174`, -1.1999999999999997`}}]], 
   Polygon3DBox[
    NCache[{{2 Cos[Rational[1, 20] Pi], 2 
       Sin[Rational[1, 20] Pi], -1.1999999999999997`}, {
      2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 + 5^Rational[1, 2]), -1.1999999999999997`}, {
      2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 + 5^Rational[1, 2]), -0.8999999999999997}, {
      2 Cos[Rational[1, 20] Pi], 2 
       Sin[Rational[1, 20] Pi], -0.8999999999999997}}, {{1.9753766811902755`, 
     0.31286893008046174`, -1.1999999999999997`}, {1.902113032590307, 
     0.6180339887498949, -1.1999999999999997`}, {1.902113032590307, 
     0.6180339887498949, -0.8999999999999997}, {1.9753766811902755`, 
     0.31286893008046174`, -0.8999999999999997}}]], 
   Polygon3DBox[
    NCache[{{2 Cos[Rational[1, 20] Pi], 2 
       Sin[Rational[1, 20] Pi], -0.8999999999999997}, {
      2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 + 5^Rational[1, 2]), -0.8999999999999997}, {
      2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 + 5^Rational[1, 2]), -0.5999999999999996}, {
      2 Cos[Rational[1, 20] Pi], 2 
       Sin[Rational[1, 20] Pi], -0.5999999999999996}}, {{1.9753766811902755`, 
     0.31286893008046174`, -0.8999999999999997}, {1.902113032590307, 
     0.6180339887498949, -0.8999999999999997}, {1.902113032590307, 
     0.6180339887498949, -0.5999999999999996}, {1.9753766811902755`, 
     0.31286893008046174`, -0.5999999999999996}}]], 
   Polygon3DBox[
    NCache[{{2 Cos[Rational[1, 20] Pi], 2 
       Sin[Rational[1, 20] Pi], -0.5999999999999996}, {
      2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 + 5^Rational[1, 2]), -0.5999999999999996}, {
      2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 + 5^Rational[1, 2]), -0.2999999999999996}, {
      2 Cos[Rational[1, 20] Pi], 2 
       Sin[Rational[1, 20] Pi], -0.2999999999999996}}, {{1.9753766811902755`, 
     0.31286893008046174`, -0.5999999999999996}, {1.902113032590307, 
     0.6180339887498949, -0.5999999999999996}, {1.902113032590307, 
     0.6180339887498949, -0.2999999999999996}, {1.9753766811902755`, 
     0.31286893008046174`, -0.2999999999999996}}]], 
   Polygon3DBox[
    NCache[{{2 Cos[Rational[1, 20] Pi], 2 
       Sin[Rational[1, 20] Pi], -0.2999999999999996}, {
      2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 + 5^Rational[1, 2]), -0.2999999999999996}, {
      2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 + 5^Rational[1, 2]), 4.440892098500626*^-16}, {
      2 Cos[Rational[1, 20] Pi], 2 Sin[Rational[1, 20] Pi], 
       4.440892098500626*^-16}}, {{1.9753766811902755`, 
     0.31286893008046174`, -0.2999999999999996}, {1.902113032590307, 
     0.6180339887498949, -0.2999999999999996}, {1.902113032590307, 
     0.6180339887498949, 4.440892098500626*^-16}, {1.9753766811902755`, 
     0.31286893008046174`, 4.440892098500626*^-16}}]], 
   Polygon3DBox[
    NCache[{{2 Cos[Rational[1, 20] Pi], 2 Sin[Rational[1, 20] Pi], 
       4.440892098500626*^-16}, {
      2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 + 5^Rational[1, 2]), 4.440892098500626*^-16}, {
      2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 + 5^Rational[1, 2]), 0.3000000000000005}, {
      2 Cos[Rational[1, 20] Pi], 2 Sin[Rational[1, 20] Pi], 
       0.3000000000000005}}, {{1.9753766811902755`, 0.31286893008046174`, 
     4.440892098500626*^-16}, {1.902113032590307, 0.6180339887498949, 
     4.440892098500626*^-16}, {1.902113032590307, 0.6180339887498949, 
     0.3000000000000005}, {1.9753766811902755`, 0.31286893008046174`, 
     0.3000000000000005}}]], 
   Polygon3DBox[
    NCache[{{2 Cos[Rational[1, 20] Pi], 2 Sin[Rational[1, 20] Pi], 
       0.3000000000000005}, {
      2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 + 5^Rational[1, 2]), 0.3000000000000005}, {
      2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 + 5^Rational[1, 2]), 0.6000000000000005}, {
      2 Cos[Rational[1, 20] Pi], 2 Sin[Rational[1, 20] Pi], 
       0.6000000000000005}}, {{1.9753766811902755`, 0.31286893008046174`, 
     0.3000000000000005}, {1.902113032590307, 0.6180339887498949, 
     0.3000000000000005}, {1.902113032590307, 0.6180339887498949, 
     0.6000000000000005}, {1.9753766811902755`, 0.31286893008046174`, 
     0.6000000000000005}}]], 
   Polygon3DBox[
    NCache[{{2 Cos[Rational[1, 20] Pi], 2 Sin[Rational[1, 20] Pi], 
       0.6000000000000005}, {
      2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 + 5^Rational[1, 2]), 0.6000000000000005}, {
      2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 + 5^Rational[1, 2]), 0.9000000000000006}, {
      2 Cos[Rational[1, 20] Pi], 2 Sin[Rational[1, 20] Pi], 
       0.9000000000000006}}, {{1.9753766811902755`, 0.31286893008046174`, 
     0.6000000000000005}, {1.902113032590307, 0.6180339887498949, 
     0.6000000000000005}, {1.902113032590307, 0.6180339887498949, 
     0.9000000000000006}, {1.9753766811902755`, 0.31286893008046174`, 
     0.9000000000000006}}]], 
   Polygon3DBox[
    NCache[{{2 Cos[Rational[1, 20] Pi], 2 Sin[Rational[1, 20] Pi], 
       0.9000000000000006}, {
      2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 + 5^Rational[1, 2]), 0.9000000000000006}, {
      2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 + 5^Rational[1, 2]), 1.2000000000000006`}, {
      2 Cos[Rational[1, 20] Pi], 2 Sin[Rational[1, 20] Pi], 
       1.2000000000000006`}}, {{1.9753766811902755`, 0.31286893008046174`, 
     0.9000000000000006}, {1.902113032590307, 0.6180339887498949, 
     0.9000000000000006}, {1.902113032590307, 0.6180339887498949, 
     1.2000000000000006`}, {1.9753766811902755`, 0.31286893008046174`, 
     1.2000000000000006`}}]], 
   Polygon3DBox[
    NCache[{{2 Cos[Rational[1, 20] Pi], 2 Sin[Rational[1, 20] Pi], 
       1.2000000000000006`}, {
      2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 + 5^Rational[1, 2]), 1.2000000000000006`}, {
      2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 + 5^Rational[1, 2]), 1.5000000000000007`}, {
      2 Cos[Rational[1, 20] Pi], 2 Sin[Rational[1, 20] Pi], 
       1.5000000000000007`}}, {{1.9753766811902755`, 0.31286893008046174`, 
     1.2000000000000006`}, {1.902113032590307, 0.6180339887498949, 
     1.2000000000000006`}, {1.902113032590307, 0.6180339887498949, 
     1.5000000000000007`}, {1.9753766811902755`, 0.31286893008046174`, 
     1.5000000000000007`}}]], 
   Polygon3DBox[
    NCache[{{2 Cos[Rational[1, 20] Pi], 2 Sin[Rational[1, 20] Pi], 
       1.5000000000000007`}, {
      2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 + 5^Rational[1, 2]), 1.5000000000000007`}, {
      2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 + 5^Rational[1, 2]), 1.8000000000000007`}, {
      2 Cos[Rational[1, 20] Pi], 2 Sin[Rational[1, 20] Pi], 
       1.8000000000000007`}}, {{1.9753766811902755`, 0.31286893008046174`, 
     1.5000000000000007`}, {1.902113032590307, 0.6180339887498949, 
     1.5000000000000007`}, {1.902113032590307, 0.6180339887498949, 
     1.8000000000000007`}, {1.9753766811902755`, 0.31286893008046174`, 
     1.8000000000000007`}}]], 
   Polygon3DBox[
    NCache[{{2 Cos[Rational[1, 20] Pi], 2 Sin[Rational[1, 20] Pi], 
       1.8000000000000007`}, {
      2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 + 5^Rational[1, 2]), 1.8000000000000007`}, {
      2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 + 5^Rational[1, 2]), 2.1000000000000005`}, {
      2 Cos[Rational[1, 20] Pi], 2 Sin[Rational[1, 20] Pi], 
       2.1000000000000005`}}, {{1.9753766811902755`, 0.31286893008046174`, 
     1.8000000000000007`}, {1.902113032590307, 0.6180339887498949, 
     1.8000000000000007`}, {1.902113032590307, 0.6180339887498949, 
     2.1000000000000005`}, {1.9753766811902755`, 0.31286893008046174`, 
     2.1000000000000005`}}]], 
   Polygon3DBox[
    NCache[{{2 Cos[Rational[1, 20] Pi], 2 Sin[Rational[1, 20] Pi], 
       2.1000000000000005`}, {
      2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 + 5^Rational[1, 2]), 2.1000000000000005`}, {
      2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 + 5^Rational[1, 2]), 2.4000000000000004`}, {
      2 Cos[Rational[1, 20] Pi], 2 Sin[Rational[1, 20] Pi], 
       2.4000000000000004`}}, {{1.9753766811902755`, 0.31286893008046174`, 
     2.1000000000000005`}, {1.902113032590307, 0.6180339887498949, 
     2.1000000000000005`}, {1.902113032590307, 0.6180339887498949, 
     2.4000000000000004`}, {1.9753766811902755`, 0.31286893008046174`, 
     2.4000000000000004`}}]], 
   Polygon3DBox[
    NCache[{{2 Cos[Rational[1, 20] Pi], 2 Sin[Rational[1, 20] Pi], 
       2.400000000000001}, {
      2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 + 5^Rational[1, 2]), 2.400000000000001}, {
      2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 + 5^Rational[1, 2]), 2.700000000000001}, {
      2 Cos[Rational[1, 20] Pi], 2 Sin[Rational[1, 20] Pi], 
       2.700000000000001}}, {{1.9753766811902755`, 0.31286893008046174`, 
     2.400000000000001}, {1.902113032590307, 0.6180339887498949, 
     2.400000000000001}, {1.902113032590307, 0.6180339887498949, 
     2.700000000000001}, {1.9753766811902755`, 0.31286893008046174`, 
     2.700000000000001}}]], 
   Polygon3DBox[
    NCache[{{2 Cos[Rational[1, 20] Pi], 2 Sin[Rational[1, 20] Pi], 
       2.700000000000001}, {
      2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 + 5^Rational[1, 2]), 2.700000000000001}, {
      2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 + 5^Rational[1, 2]), 3.000000000000001}, {
      2 Cos[Rational[1, 20] Pi], 2 Sin[Rational[1, 20] Pi], 
       3.000000000000001}}, {{1.9753766811902755`, 0.31286893008046174`, 
     2.700000000000001}, {1.902113032590307, 0.6180339887498949, 
     2.700000000000001}, {1.902113032590307, 0.6180339887498949, 
     3.000000000000001}, {1.9753766811902755`, 0.31286893008046174`, 
     3.000000000000001}}]], 
   Polygon3DBox[
    NCache[{{2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 2] (-1 + 5^Rational[1, 2]), -3.}, {
      2 Cos[Rational[3, 20] Pi], 2 Sin[Rational[3, 20] Pi], -3.}, {
      2 Cos[Rational[3, 20] Pi], 2 Sin[Rational[3, 20] Pi], -2.7}, {
      2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 + 5^Rational[1, 2]), -2.7}}, {{1.902113032590307, 
     0.6180339887498949, -3.}, {1.7820130483767358`, 
     0.9079809994790936, -3.}, {1.7820130483767358`, 
     0.9079809994790936, -2.7}, {1.902113032590307, 
     0.6180339887498949, -2.7}}]], 
   Polygon3DBox[
    NCache[{{2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 2] (-1 + 5^Rational[1, 2]), -2.7}, {
      2 Cos[Rational[3, 20] Pi], 2 Sin[Rational[3, 20] Pi], -2.7}, {
      2 Cos[Rational[3, 20] Pi], 2 
       Sin[Rational[3, 20] Pi], -2.4000000000000004`}, {
      2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 + 5^Rational[1, 2]), -2.4000000000000004`}}, {{
     1.902113032590307, 0.6180339887498949, -2.7}, {1.7820130483767358`, 
     0.9079809994790936, -2.7}, {1.7820130483767358`, 
     0.9079809994790936, -2.4000000000000004`}, {1.902113032590307, 
     0.6180339887498949, -2.4000000000000004`}}]], 
   Polygon3DBox[
    NCache[{{2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 2] (-1 + 5^Rational[1, 2]), -2.4}, {
      2 Cos[Rational[3, 20] Pi], 2 Sin[Rational[3, 20] Pi], -2.4}, {
      2 Cos[Rational[3, 20] Pi], 2 
       Sin[Rational[3, 20] Pi], -2.0999999999999996`}, {
      2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 + 5^Rational[1, 2]), -2.0999999999999996`}}, {{
     1.902113032590307, 0.6180339887498949, -2.4}, {1.7820130483767358`, 
     0.9079809994790936, -2.4}, {1.7820130483767358`, 
     0.9079809994790936, -2.0999999999999996`}, {1.902113032590307, 
     0.6180339887498949, -2.0999999999999996`}}]], 
   Polygon3DBox[
    NCache[{{2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], 
       Rational[1, 2] (-1 + 5^Rational[1, 2]), -2.0999999999999996`}, {
      2 Cos[Rational[3, 20] Pi], 2 
       Sin[Rational[3, 20] Pi], -2.0999999999999996`}, {
      2 Cos[Rational[3, 20] Pi], 2 
       Sin[Rational[3, 20] Pi], -1.7999999999999996`}, {
      2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 + 5^Rational[1, 2]), -1.7999999999999996`}}, {{
     1.902113032590307, 0.6180339887498949, -2.0999999999999996`}, {
     1.7820130483767358`, 0.9079809994790936, -2.0999999999999996`}, {
     1.7820130483767358`, 0.9079809994790936, -1.7999999999999996`}, {
     1.902113032590307, 0.6180339887498949, -1.7999999999999996`}}]], 
   Polygon3DBox[
    NCache[{{2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], 
       Rational[1, 2] (-1 + 5^Rational[1, 2]), -1.7999999999999998`}, {
      2 Cos[Rational[3, 20] Pi], 2 
       Sin[Rational[3, 20] Pi], -1.7999999999999998`}, {
      2 Cos[Rational[3, 20] Pi], 2 
       Sin[Rational[3, 20] Pi], -1.4999999999999998`}, {
      2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 + 5^Rational[1, 2]), -1.4999999999999998`}}, {{
     1.902113032590307, 0.6180339887498949, -1.7999999999999998`}, {
     1.7820130483767358`, 0.9079809994790936, -1.7999999999999998`}, {
     1.7820130483767358`, 0.9079809994790936, -1.4999999999999998`}, {
     1.902113032590307, 0.6180339887498949, -1.4999999999999998`}}]], 
   Polygon3DBox[
    NCache[{{2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], 
       Rational[1, 2] (-1 + 5^Rational[1, 2]), -1.4999999999999998`}, {
      2 Cos[Rational[3, 20] Pi], 2 
       Sin[Rational[3, 20] Pi], -1.4999999999999998`}, {
      2 Cos[Rational[3, 20] Pi], 2 
       Sin[Rational[3, 20] Pi], -1.1999999999999997`}, {
      2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 + 5^Rational[1, 2]), -1.1999999999999997`}}, {{
     1.902113032590307, 0.6180339887498949, -1.4999999999999998`}, {
     1.7820130483767358`, 0.9079809994790936, -1.4999999999999998`}, {
     1.7820130483767358`, 0.9079809994790936, -1.1999999999999997`}, {
     1.902113032590307, 0.6180339887498949, -1.1999999999999997`}}]], 
   Polygon3DBox[
    NCache[{{2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], 
       Rational[1, 2] (-1 + 5^Rational[1, 2]), -1.1999999999999997`}, {
      2 Cos[Rational[3, 20] Pi], 2 
       Sin[Rational[3, 20] Pi], -1.1999999999999997`}, {
      2 Cos[Rational[3, 20] Pi], 2 
       Sin[Rational[3, 20] Pi], -0.8999999999999997}, {
      2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 + 5^Rational[1, 2]), -0.8999999999999997}}, {{
     1.902113032590307, 0.6180339887498949, -1.1999999999999997`}, {
     1.7820130483767358`, 0.9079809994790936, -1.1999999999999997`}, {
     1.7820130483767358`, 0.9079809994790936, -0.8999999999999997}, {
     1.902113032590307, 0.6180339887498949, -0.8999999999999997}}]], 
   Polygon3DBox[
    NCache[{{2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], 
       Rational[1, 2] (-1 + 5^Rational[1, 2]), -0.8999999999999997}, {
      2 Cos[Rational[3, 20] Pi], 2 
       Sin[Rational[3, 20] Pi], -0.8999999999999997}, {
      2 Cos[Rational[3, 20] Pi], 2 
       Sin[Rational[3, 20] Pi], -0.5999999999999996}, {
      2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 + 5^Rational[1, 2]), -0.5999999999999996}}, {{
     1.902113032590307, 0.6180339887498949, -0.8999999999999997}, {
     1.7820130483767358`, 0.9079809994790936, -0.8999999999999997}, {
     1.7820130483767358`, 0.9079809994790936, -0.5999999999999996}, {
     1.902113032590307, 0.6180339887498949, -0.5999999999999996}}]], 
   Polygon3DBox[
    NCache[{{2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], 
       Rational[1, 2] (-1 + 5^Rational[1, 2]), -0.5999999999999996}, {
      2 Cos[Rational[3, 20] Pi], 2 
       Sin[Rational[3, 20] Pi], -0.5999999999999996}, {
      2 Cos[Rational[3, 20] Pi], 2 
       Sin[Rational[3, 20] Pi], -0.2999999999999996}, {
      2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 + 5^Rational[1, 2]), -0.2999999999999996}}, {{
     1.902113032590307, 0.6180339887498949, -0.5999999999999996}, {
     1.7820130483767358`, 0.9079809994790936, -0.5999999999999996}, {
     1.7820130483767358`, 0.9079809994790936, -0.2999999999999996}, {
     1.902113032590307, 0.6180339887498949, -0.2999999999999996}}]], 
   Polygon3DBox[
    NCache[{{2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], 
       Rational[1, 2] (-1 + 5^Rational[1, 2]), -0.2999999999999996}, {
      2 Cos[Rational[3, 20] Pi], 2 
       Sin[Rational[3, 20] Pi], -0.2999999999999996}, {
      2 Cos[Rational[3, 20] Pi], 2 Sin[Rational[3, 20] Pi], 
       4.440892098500626*^-16}, {
      2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 + 5^Rational[1, 2]), 4.440892098500626*^-16}}, {{
     1.902113032590307, 0.6180339887498949, -0.2999999999999996}, {
     1.7820130483767358`, 0.9079809994790936, -0.2999999999999996}, {
     1.7820130483767358`, 0.9079809994790936, 4.440892098500626*^-16}, {
     1.902113032590307, 0.6180339887498949, 4.440892098500626*^-16}}]], 
   Polygon3DBox[
    NCache[{{2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 2] (-1 + 5^Rational[1, 2]), 
       4.440892098500626*^-16}, {
      2 Cos[Rational[3, 20] Pi], 2 Sin[Rational[3, 20] Pi], 
       4.440892098500626*^-16}, {
      2 Cos[Rational[3, 20] Pi], 2 Sin[Rational[3, 20] Pi], 
       0.3000000000000005}, {
      2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 + 5^Rational[1, 2]), 0.3000000000000005}}, {{
     1.902113032590307, 0.6180339887498949, 4.440892098500626*^-16}, {
     1.7820130483767358`, 0.9079809994790936, 4.440892098500626*^-16}, {
     1.7820130483767358`, 0.9079809994790936, 0.3000000000000005}, {
     1.902113032590307, 0.6180339887498949, 0.3000000000000005}}]], 
   Polygon3DBox[
    NCache[{{2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 2] (-1 + 5^Rational[1, 2]), 
       0.3000000000000005}, {
      2 Cos[Rational[3, 20] Pi], 2 Sin[Rational[3, 20] Pi], 
       0.3000000000000005}, {
      2 Cos[Rational[3, 20] Pi], 2 Sin[Rational[3, 20] Pi], 
       0.6000000000000005}, {
      2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 + 5^Rational[1, 2]), 0.6000000000000005}}, {{
     1.902113032590307, 0.6180339887498949, 0.3000000000000005}, {
     1.7820130483767358`, 0.9079809994790936, 0.3000000000000005}, {
     1.7820130483767358`, 0.9079809994790936, 0.6000000000000005}, {
     1.902113032590307, 0.6180339887498949, 0.6000000000000005}}]], 
   Polygon3DBox[
    NCache[{{2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 2] (-1 + 5^Rational[1, 2]), 
       0.6000000000000005}, {
      2 Cos[Rational[3, 20] Pi], 2 Sin[Rational[3, 20] Pi], 
       0.6000000000000005}, {
      2 Cos[Rational[3, 20] Pi], 2 Sin[Rational[3, 20] Pi], 
       0.9000000000000006}, {
      2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 + 5^Rational[1, 2]), 0.9000000000000006}}, {{
     1.902113032590307, 0.6180339887498949, 0.6000000000000005}, {
     1.7820130483767358`, 0.9079809994790936, 0.6000000000000005}, {
     1.7820130483767358`, 0.9079809994790936, 0.9000000000000006}, {
     1.902113032590307, 0.6180339887498949, 0.9000000000000006}}]], 
   Polygon3DBox[
    NCache[{{2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 2] (-1 + 5^Rational[1, 2]), 
       0.9000000000000006}, {
      2 Cos[Rational[3, 20] Pi], 2 Sin[Rational[3, 20] Pi], 
       0.9000000000000006}, {
      2 Cos[Rational[3, 20] Pi], 2 Sin[Rational[3, 20] Pi], 
       1.2000000000000006`}, {
      2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 + 5^Rational[1, 2]), 1.2000000000000006`}}, {{
     1.902113032590307, 0.6180339887498949, 0.9000000000000006}, {
     1.7820130483767358`, 0.9079809994790936, 0.9000000000000006}, {
     1.7820130483767358`, 0.9079809994790936, 1.2000000000000006`}, {
     1.902113032590307, 0.6180339887498949, 1.2000000000000006`}}]], 
   Polygon3DBox[
    NCache[{{2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 2] (-1 + 5^Rational[1, 2]), 
       1.2000000000000006`}, {
      2 Cos[Rational[3, 20] Pi], 2 Sin[Rational[3, 20] Pi], 
       1.2000000000000006`}, {
      2 Cos[Rational[3, 20] Pi], 2 Sin[Rational[3, 20] Pi], 
       1.5000000000000007`}, {
      2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 + 5^Rational[1, 2]), 1.5000000000000007`}}, {{
     1.902113032590307, 0.6180339887498949, 1.2000000000000006`}, {
     1.7820130483767358`, 0.9079809994790936, 1.2000000000000006`}, {
     1.7820130483767358`, 0.9079809994790936, 1.5000000000000007`}, {
     1.902113032590307, 0.6180339887498949, 1.5000000000000007`}}]], 
   Polygon3DBox[
    NCache[{{2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 2] (-1 + 5^Rational[1, 2]), 
       1.5000000000000007`}, {
      2 Cos[Rational[3, 20] Pi], 2 Sin[Rational[3, 20] Pi], 
       1.5000000000000007`}, {
      2 Cos[Rational[3, 20] Pi], 2 Sin[Rational[3, 20] Pi], 
       1.8000000000000007`}, {
      2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 + 5^Rational[1, 2]), 1.8000000000000007`}}, {{
     1.902113032590307, 0.6180339887498949, 1.5000000000000007`}, {
     1.7820130483767358`, 0.9079809994790936, 1.5000000000000007`}, {
     1.7820130483767358`, 0.9079809994790936, 1.8000000000000007`}, {
     1.902113032590307, 0.6180339887498949, 1.8000000000000007`}}]], 
   Polygon3DBox[
    NCache[{{2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 2] (-1 + 5^Rational[1, 2]), 
       1.8000000000000007`}, {
      2 Cos[Rational[3, 20] Pi], 2 Sin[Rational[3, 20] Pi], 
       1.8000000000000007`}, {
      2 Cos[Rational[3, 20] Pi], 2 Sin[Rational[3, 20] Pi], 
       2.1000000000000005`}, {
      2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 + 5^Rational[1, 2]), 2.1000000000000005`}}, {{
     1.902113032590307, 0.6180339887498949, 1.8000000000000007`}, {
     1.7820130483767358`, 0.9079809994790936, 1.8000000000000007`}, {
     1.7820130483767358`, 0.9079809994790936, 2.1000000000000005`}, {
     1.902113032590307, 0.6180339887498949, 2.1000000000000005`}}]], 
   Polygon3DBox[
    NCache[{{2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 2] (-1 + 5^Rational[1, 2]), 
       2.1000000000000005`}, {
      2 Cos[Rational[3, 20] Pi], 2 Sin[Rational[3, 20] Pi], 
       2.1000000000000005`}, {
      2 Cos[Rational[3, 20] Pi], 2 Sin[Rational[3, 20] Pi], 
       2.4000000000000004`}, {
      2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 + 5^Rational[1, 2]), 2.4000000000000004`}}, {{
     1.902113032590307, 0.6180339887498949, 2.1000000000000005`}, {
     1.7820130483767358`, 0.9079809994790936, 2.1000000000000005`}, {
     1.7820130483767358`, 0.9079809994790936, 2.4000000000000004`}, {
     1.902113032590307, 0.6180339887498949, 2.4000000000000004`}}]], 
   Polygon3DBox[
    NCache[{{2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 2] (-1 + 5^Rational[1, 2]), 
       2.400000000000001}, {
      2 Cos[Rational[3, 20] Pi], 2 Sin[Rational[3, 20] Pi], 
       2.400000000000001}, {
      2 Cos[Rational[3, 20] Pi], 2 Sin[Rational[3, 20] Pi], 
       2.700000000000001}, {
      2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 + 5^Rational[1, 2]), 2.700000000000001}}, {{
     1.902113032590307, 0.6180339887498949, 2.400000000000001}, {
     1.7820130483767358`, 0.9079809994790936, 2.400000000000001}, {
     1.7820130483767358`, 0.9079809994790936, 2.700000000000001}, {
     1.902113032590307, 0.6180339887498949, 2.700000000000001}}]], 
   Polygon3DBox[
    NCache[{{2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 2] (-1 + 5^Rational[1, 2]), 
       2.700000000000001}, {
      2 Cos[Rational[3, 20] Pi], 2 Sin[Rational[3, 20] Pi], 
       2.700000000000001}, {
      2 Cos[Rational[3, 20] Pi], 2 Sin[Rational[3, 20] Pi], 
       3.000000000000001}, {
      2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 + 5^Rational[1, 2]), 3.000000000000001}}, {{
     1.902113032590307, 0.6180339887498949, 2.700000000000001}, {
     1.7820130483767358`, 0.9079809994790936, 2.700000000000001}, {
     1.7820130483767358`, 0.9079809994790936, 3.000000000000001}, {
     1.902113032590307, 0.6180339887498949, 3.000000000000001}}]], 
   Polygon3DBox[
    NCache[{{2 Cos[Rational[3, 20] Pi], 2 Sin[Rational[3, 20] Pi], -3.}, {
      Rational[1, 2] (1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -3.}, {
      Rational[1, 2] (1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -2.7}, {
      2 Cos[Rational[3, 20] Pi], 2 Sin[Rational[3, 20] Pi], -2.7}}, {{
     1.7820130483767358`, 0.9079809994790936, -3.}, {1.618033988749895, 
     1.1755705045849463`, -3.}, {1.618033988749895, 
     1.1755705045849463`, -2.7}, {1.7820130483767358`, 
     0.9079809994790936, -2.7}}]], 
   Polygon3DBox[
    NCache[{{2 Cos[Rational[3, 20] Pi], 2 Sin[Rational[3, 20] Pi], -2.7}, {
      Rational[1, 2] (1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -2.7}, {
      Rational[1, 2] (1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -2.4000000000000004`}, {
      2 Cos[Rational[3, 20] Pi], 2 
       Sin[Rational[3, 20] Pi], -2.4000000000000004`}}, {{1.7820130483767358`,
      0.9079809994790936, -2.7}, {1.618033988749895, 
     1.1755705045849463`, -2.7}, {1.618033988749895, 
     1.1755705045849463`, -2.4000000000000004`}, {1.7820130483767358`, 
     0.9079809994790936, -2.4000000000000004`}}]], 
   Polygon3DBox[
    NCache[{{2 Cos[Rational[3, 20] Pi], 2 Sin[Rational[3, 20] Pi], -2.4}, {
      Rational[1, 2] (1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -2.4}, {
      Rational[1, 2] (1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -2.0999999999999996`}, {
      2 Cos[Rational[3, 20] Pi], 2 
       Sin[Rational[3, 20] Pi], -2.0999999999999996`}}, {{1.7820130483767358`,
      0.9079809994790936, -2.4}, {1.618033988749895, 
     1.1755705045849463`, -2.4}, {1.618033988749895, 
     1.1755705045849463`, -2.0999999999999996`}, {1.7820130483767358`, 
     0.9079809994790936, -2.0999999999999996`}}]], 
   Polygon3DBox[
    NCache[{{2 Cos[Rational[3, 20] Pi], 2 
       Sin[Rational[3, 20] Pi], -2.0999999999999996`}, {
      Rational[1, 2] (1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -2.0999999999999996`}, {
      Rational[1, 2] (1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -1.7999999999999996`}, {
      2 Cos[Rational[3, 20] Pi], 2 
       Sin[Rational[3, 20] Pi], -1.7999999999999996`}}, {{1.7820130483767358`,
      0.9079809994790936, -2.0999999999999996`}, {1.618033988749895, 
     1.1755705045849463`, -2.0999999999999996`}, {1.618033988749895, 
     1.1755705045849463`, -1.7999999999999996`}, {1.7820130483767358`, 
     0.9079809994790936, -1.7999999999999996`}}]], 
   Polygon3DBox[
    NCache[{{2 Cos[Rational[3, 20] Pi], 2 
       Sin[Rational[3, 20] Pi], -1.7999999999999998`}, {
      Rational[1, 2] (1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -1.7999999999999998`}, {
      Rational[1, 2] (1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -1.4999999999999998`}, {
      2 Cos[Rational[3, 20] Pi], 2 
       Sin[Rational[3, 20] Pi], -1.4999999999999998`}}, {{1.7820130483767358`,
      0.9079809994790936, -1.7999999999999998`}, {1.618033988749895, 
     1.1755705045849463`, -1.7999999999999998`}, {1.618033988749895, 
     1.1755705045849463`, -1.4999999999999998`}, {1.7820130483767358`, 
     0.9079809994790936, -1.4999999999999998`}}]], 
   Polygon3DBox[
    NCache[{{2 Cos[Rational[3, 20] Pi], 2 
       Sin[Rational[3, 20] Pi], -1.4999999999999998`}, {
      Rational[1, 2] (1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -1.4999999999999998`}, {
      Rational[1, 2] (1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -1.1999999999999997`}, {
      2 Cos[Rational[3, 20] Pi], 2 
       Sin[Rational[3, 20] Pi], -1.1999999999999997`}}, {{1.7820130483767358`,
      0.9079809994790936, -1.4999999999999998`}, {1.618033988749895, 
     1.1755705045849463`, -1.4999999999999998`}, {1.618033988749895, 
     1.1755705045849463`, -1.1999999999999997`}, {1.7820130483767358`, 
     0.9079809994790936, -1.1999999999999997`}}]], 
   Polygon3DBox[
    NCache[{{2 Cos[Rational[3, 20] Pi], 2 
       Sin[Rational[3, 20] Pi], -1.1999999999999997`}, {
      Rational[1, 2] (1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -1.1999999999999997`}, {
      Rational[1, 2] (1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -0.8999999999999997}, {
      2 Cos[Rational[3, 20] Pi], 2 
       Sin[Rational[3, 20] Pi], -0.8999999999999997}}, {{1.7820130483767358`, 
     0.9079809994790936, -1.1999999999999997`}, {1.618033988749895, 
     1.1755705045849463`, -1.1999999999999997`}, {1.618033988749895, 
     1.1755705045849463`, -0.8999999999999997}, {1.7820130483767358`, 
     0.9079809994790936, -0.8999999999999997}}]], 
   Polygon3DBox[
    NCache[{{2 Cos[Rational[3, 20] Pi], 2 
       Sin[Rational[3, 20] Pi], -0.8999999999999997}, {
      Rational[1, 2] (1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -0.8999999999999997}, {
      Rational[1, 2] (1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -0.5999999999999996}, {
      2 Cos[Rational[3, 20] Pi], 2 
       Sin[Rational[3, 20] Pi], -0.5999999999999996}}, {{1.7820130483767358`, 
     0.9079809994790936, -0.8999999999999997}, {1.618033988749895, 
     1.1755705045849463`, -0.8999999999999997}, {1.618033988749895, 
     1.1755705045849463`, -0.5999999999999996}, {1.7820130483767358`, 
     0.9079809994790936, -0.5999999999999996}}]], 
   Polygon3DBox[
    NCache[{{2 Cos[Rational[3, 20] Pi], 2 
       Sin[Rational[3, 20] Pi], -0.5999999999999996}, {
      Rational[1, 2] (1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -0.5999999999999996}, {
      Rational[1, 2] (1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -0.2999999999999996}, {
      2 Cos[Rational[3, 20] Pi], 2 
       Sin[Rational[3, 20] Pi], -0.2999999999999996}}, {{1.7820130483767358`, 
     0.9079809994790936, -0.5999999999999996}, {1.618033988749895, 
     1.1755705045849463`, -0.5999999999999996}, {1.618033988749895, 
     1.1755705045849463`, -0.2999999999999996}, {1.7820130483767358`, 
     0.9079809994790936, -0.2999999999999996}}]], 
   Polygon3DBox[
    NCache[{{2 Cos[Rational[3, 20] Pi], 2 
       Sin[Rational[3, 20] Pi], -0.2999999999999996}, {
      Rational[1, 2] (1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -0.2999999999999996}, {
      Rational[1, 2] (1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       4.440892098500626*^-16}, {
      2 Cos[Rational[3, 20] Pi], 2 Sin[Rational[3, 20] Pi], 
       4.440892098500626*^-16}}, {{1.7820130483767358`, 
     0.9079809994790936, -0.2999999999999996}, {1.618033988749895, 
     1.1755705045849463`, -0.2999999999999996}, {1.618033988749895, 
     1.1755705045849463`, 4.440892098500626*^-16}, {1.7820130483767358`, 
     0.9079809994790936, 4.440892098500626*^-16}}]], 
   Polygon3DBox[
    NCache[{{2 Cos[Rational[3, 20] Pi], 2 Sin[Rational[3, 20] Pi], 
       4.440892098500626*^-16}, {
      Rational[1, 2] (1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       4.440892098500626*^-16}, {
      Rational[1, 2] (1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       0.3000000000000005}, {
      2 Cos[Rational[3, 20] Pi], 2 Sin[Rational[3, 20] Pi], 
       0.3000000000000005}}, {{1.7820130483767358`, 0.9079809994790936, 
     4.440892098500626*^-16}, {1.618033988749895, 1.1755705045849463`, 
     4.440892098500626*^-16}, {1.618033988749895, 1.1755705045849463`, 
     0.3000000000000005}, {1.7820130483767358`, 0.9079809994790936, 
     0.3000000000000005}}]], 
   Polygon3DBox[
    NCache[{{2 Cos[Rational[3, 20] Pi], 2 Sin[Rational[3, 20] Pi], 
       0.3000000000000005}, {
      Rational[1, 2] (1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       0.3000000000000005}, {
      Rational[1, 2] (1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       0.6000000000000005}, {
      2 Cos[Rational[3, 20] Pi], 2 Sin[Rational[3, 20] Pi], 
       0.6000000000000005}}, {{1.7820130483767358`, 0.9079809994790936, 
     0.3000000000000005}, {1.618033988749895, 1.1755705045849463`, 
     0.3000000000000005}, {1.618033988749895, 1.1755705045849463`, 
     0.6000000000000005}, {1.7820130483767358`, 0.9079809994790936, 
     0.6000000000000005}}]], 
   Polygon3DBox[
    NCache[{{2 Cos[Rational[3, 20] Pi], 2 Sin[Rational[3, 20] Pi], 
       0.6000000000000005}, {
      Rational[1, 2] (1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       0.6000000000000005}, {
      Rational[1, 2] (1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       0.9000000000000006}, {
      2 Cos[Rational[3, 20] Pi], 2 Sin[Rational[3, 20] Pi], 
       0.9000000000000006}}, {{1.7820130483767358`, 0.9079809994790936, 
     0.6000000000000005}, {1.618033988749895, 1.1755705045849463`, 
     0.6000000000000005}, {1.618033988749895, 1.1755705045849463`, 
     0.9000000000000006}, {1.7820130483767358`, 0.9079809994790936, 
     0.9000000000000006}}]], 
   Polygon3DBox[
    NCache[{{2 Cos[Rational[3, 20] Pi], 2 Sin[Rational[3, 20] Pi], 
       0.9000000000000006}, {
      Rational[1, 2] (1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       0.9000000000000006}, {
      Rational[1, 2] (1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       1.2000000000000006`}, {
      2 Cos[Rational[3, 20] Pi], 2 Sin[Rational[3, 20] Pi], 
       1.2000000000000006`}}, {{1.7820130483767358`, 0.9079809994790936, 
     0.9000000000000006}, {1.618033988749895, 1.1755705045849463`, 
     0.9000000000000006}, {1.618033988749895, 1.1755705045849463`, 
     1.2000000000000006`}, {1.7820130483767358`, 0.9079809994790936, 
     1.2000000000000006`}}]], 
   Polygon3DBox[
    NCache[{{2 Cos[Rational[3, 20] Pi], 2 Sin[Rational[3, 20] Pi], 
       1.2000000000000006`}, {
      Rational[1, 2] (1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       1.2000000000000006`}, {
      Rational[1, 2] (1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       1.5000000000000007`}, {
      2 Cos[Rational[3, 20] Pi], 2 Sin[Rational[3, 20] Pi], 
       1.5000000000000007`}}, {{1.7820130483767358`, 0.9079809994790936, 
     1.2000000000000006`}, {1.618033988749895, 1.1755705045849463`, 
     1.2000000000000006`}, {1.618033988749895, 1.1755705045849463`, 
     1.5000000000000007`}, {1.7820130483767358`, 0.9079809994790936, 
     1.5000000000000007`}}]], 
   Polygon3DBox[
    NCache[{{2 Cos[Rational[3, 20] Pi], 2 Sin[Rational[3, 20] Pi], 
       1.5000000000000007`}, {
      Rational[1, 2] (1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       1.5000000000000007`}, {
      Rational[1, 2] (1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       1.8000000000000007`}, {
      2 Cos[Rational[3, 20] Pi], 2 Sin[Rational[3, 20] Pi], 
       1.8000000000000007`}}, {{1.7820130483767358`, 0.9079809994790936, 
     1.5000000000000007`}, {1.618033988749895, 1.1755705045849463`, 
     1.5000000000000007`}, {1.618033988749895, 1.1755705045849463`, 
     1.8000000000000007`}, {1.7820130483767358`, 0.9079809994790936, 
     1.8000000000000007`}}]], 
   Polygon3DBox[
    NCache[{{2 Cos[Rational[3, 20] Pi], 2 Sin[Rational[3, 20] Pi], 
       1.8000000000000007`}, {
      Rational[1, 2] (1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       1.8000000000000007`}, {
      Rational[1, 2] (1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       2.1000000000000005`}, {
      2 Cos[Rational[3, 20] Pi], 2 Sin[Rational[3, 20] Pi], 
       2.1000000000000005`}}, {{1.7820130483767358`, 0.9079809994790936, 
     1.8000000000000007`}, {1.618033988749895, 1.1755705045849463`, 
     1.8000000000000007`}, {1.618033988749895, 1.1755705045849463`, 
     2.1000000000000005`}, {1.7820130483767358`, 0.9079809994790936, 
     2.1000000000000005`}}]], 
   Polygon3DBox[
    NCache[{{2 Cos[Rational[3, 20] Pi], 2 Sin[Rational[3, 20] Pi], 
       2.1000000000000005`}, {
      Rational[1, 2] (1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       2.1000000000000005`}, {
      Rational[1, 2] (1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       2.4000000000000004`}, {
      2 Cos[Rational[3, 20] Pi], 2 Sin[Rational[3, 20] Pi], 
       2.4000000000000004`}}, {{1.7820130483767358`, 0.9079809994790936, 
     2.1000000000000005`}, {1.618033988749895, 1.1755705045849463`, 
     2.1000000000000005`}, {1.618033988749895, 1.1755705045849463`, 
     2.4000000000000004`}, {1.7820130483767358`, 0.9079809994790936, 
     2.4000000000000004`}}]], 
   Polygon3DBox[
    NCache[{{2 Cos[Rational[3, 20] Pi], 2 Sin[Rational[3, 20] Pi], 
       2.400000000000001}, {
      Rational[1, 2] (1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       2.400000000000001}, {
      Rational[1, 2] (1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       2.700000000000001}, {
      2 Cos[Rational[3, 20] Pi], 2 Sin[Rational[3, 20] Pi], 
       2.700000000000001}}, {{1.7820130483767358`, 0.9079809994790936, 
     2.400000000000001}, {1.618033988749895, 1.1755705045849463`, 
     2.400000000000001}, {1.618033988749895, 1.1755705045849463`, 
     2.700000000000001}, {1.7820130483767358`, 0.9079809994790936, 
     2.700000000000001}}]], 
   Polygon3DBox[
    NCache[{{2 Cos[Rational[3, 20] Pi], 2 Sin[Rational[3, 20] Pi], 
       2.700000000000001}, {
      Rational[1, 2] (1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       2.700000000000001}, {
      Rational[1, 2] (1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       3.000000000000001}, {
      2 Cos[Rational[3, 20] Pi], 2 Sin[Rational[3, 20] Pi], 
       3.000000000000001}}, {{1.7820130483767358`, 0.9079809994790936, 
     2.700000000000001}, {1.618033988749895, 1.1755705045849463`, 
     2.700000000000001}, {1.618033988749895, 1.1755705045849463`, 
     3.000000000000001}, {1.7820130483767358`, 0.9079809994790936, 
     3.000000000000001}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -3.}, {2^Rational[1, 2], 2^Rational[1, 2], -3.}, {
      2^Rational[1, 2], 2^Rational[1, 2], -2.7}, {
      Rational[1, 2] (1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -2.7}}, {{1.618033988749895, 
     1.1755705045849463`, -3.}, {1.4142135623730951`, 
     1.4142135623730951`, -3.}, {1.4142135623730951`, 
     1.4142135623730951`, -2.7}, {1.618033988749895, 
     1.1755705045849463`, -2.7}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -2.7}, {2^Rational[1, 2], 2^Rational[1, 2], -2.7}, {
      2^Rational[1, 2], 2^Rational[1, 2], -2.4000000000000004`}, {
      Rational[1, 2] (1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -2.4000000000000004`}}, {{1.618033988749895, 
     1.1755705045849463`, -2.7}, {1.4142135623730951`, 
     1.4142135623730951`, -2.7}, {1.4142135623730951`, 
     1.4142135623730951`, -2.4000000000000004`}, {1.618033988749895, 
     1.1755705045849463`, -2.4000000000000004`}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -2.4}, {2^Rational[1, 2], 2^Rational[1, 2], -2.4}, {
      2^Rational[1, 2], 2^Rational[1, 2], -2.0999999999999996`}, {
      Rational[1, 2] (1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -2.0999999999999996`}}, {{1.618033988749895, 
     1.1755705045849463`, -2.4}, {1.4142135623730951`, 
     1.4142135623730951`, -2.4}, {1.4142135623730951`, 
     1.4142135623730951`, -2.0999999999999996`}, {1.618033988749895, 
     1.1755705045849463`, -2.0999999999999996`}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -2.0999999999999996`}, {
      2^Rational[1, 2], 2^Rational[1, 2], -2.0999999999999996`}, {
      2^Rational[1, 2], 2^Rational[1, 2], -1.7999999999999996`}, {
      Rational[1, 2] (1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -1.7999999999999996`}}, {{1.618033988749895, 
     1.1755705045849463`, -2.0999999999999996`}, {1.4142135623730951`, 
     1.4142135623730951`, -2.0999999999999996`}, {1.4142135623730951`, 
     1.4142135623730951`, -1.7999999999999996`}, {1.618033988749895, 
     1.1755705045849463`, -1.7999999999999996`}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -1.7999999999999998`}, {
      2^Rational[1, 2], 2^Rational[1, 2], -1.7999999999999998`}, {
      2^Rational[1, 2], 2^Rational[1, 2], -1.4999999999999998`}, {
      Rational[1, 2] (1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -1.4999999999999998`}}, {{1.618033988749895, 
     1.1755705045849463`, -1.7999999999999998`}, {1.4142135623730951`, 
     1.4142135623730951`, -1.7999999999999998`}, {1.4142135623730951`, 
     1.4142135623730951`, -1.4999999999999998`}, {1.618033988749895, 
     1.1755705045849463`, -1.4999999999999998`}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -1.4999999999999998`}, {
      2^Rational[1, 2], 2^Rational[1, 2], -1.4999999999999998`}, {
      2^Rational[1, 2], 2^Rational[1, 2], -1.1999999999999997`}, {
      Rational[1, 2] (1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -1.1999999999999997`}}, {{1.618033988749895, 
     1.1755705045849463`, -1.4999999999999998`}, {1.4142135623730951`, 
     1.4142135623730951`, -1.4999999999999998`}, {1.4142135623730951`, 
     1.4142135623730951`, -1.1999999999999997`}, {1.618033988749895, 
     1.1755705045849463`, -1.1999999999999997`}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -1.1999999999999997`}, {
      2^Rational[1, 2], 2^Rational[1, 2], -1.1999999999999997`}, {
      2^Rational[1, 2], 2^Rational[1, 2], -0.8999999999999997}, {
      Rational[1, 2] (1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -0.8999999999999997}}, {{1.618033988749895, 
     1.1755705045849463`, -1.1999999999999997`}, {1.4142135623730951`, 
     1.4142135623730951`, -1.1999999999999997`}, {1.4142135623730951`, 
     1.4142135623730951`, -0.8999999999999997}, {1.618033988749895, 
     1.1755705045849463`, -0.8999999999999997}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -0.8999999999999997}, {
      2^Rational[1, 2], 2^Rational[1, 2], -0.8999999999999997}, {
      2^Rational[1, 2], 2^Rational[1, 2], -0.5999999999999996}, {
      Rational[1, 2] (1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -0.5999999999999996}}, {{1.618033988749895, 
     1.1755705045849463`, -0.8999999999999997}, {1.4142135623730951`, 
     1.4142135623730951`, -0.8999999999999997}, {1.4142135623730951`, 
     1.4142135623730951`, -0.5999999999999996}, {1.618033988749895, 
     1.1755705045849463`, -0.5999999999999996}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -0.5999999999999996}, {
      2^Rational[1, 2], 2^Rational[1, 2], -0.5999999999999996}, {
      2^Rational[1, 2], 2^Rational[1, 2], -0.2999999999999996}, {
      Rational[1, 2] (1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -0.2999999999999996}}, {{1.618033988749895, 
     1.1755705045849463`, -0.5999999999999996}, {1.4142135623730951`, 
     1.4142135623730951`, -0.5999999999999996}, {1.4142135623730951`, 
     1.4142135623730951`, -0.2999999999999996}, {1.618033988749895, 
     1.1755705045849463`, -0.2999999999999996}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -0.2999999999999996}, {
      2^Rational[1, 2], 2^Rational[1, 2], -0.2999999999999996}, {
      2^Rational[1, 2], 2^Rational[1, 2], 4.440892098500626*^-16}, {
      Rational[1, 2] (1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       4.440892098500626*^-16}}, {{1.618033988749895, 
     1.1755705045849463`, -0.2999999999999996}, {1.4142135623730951`, 
     1.4142135623730951`, -0.2999999999999996}, {1.4142135623730951`, 
     1.4142135623730951`, 4.440892098500626*^-16}, {1.618033988749895, 
     1.1755705045849463`, 4.440892098500626*^-16}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       4.440892098500626*^-16}, {
      2^Rational[1, 2], 2^Rational[1, 2], 4.440892098500626*^-16}, {
      2^Rational[1, 2], 2^Rational[1, 2], 0.3000000000000005}, {
      Rational[1, 2] (1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       0.3000000000000005}}, {{1.618033988749895, 1.1755705045849463`, 
     4.440892098500626*^-16}, {1.4142135623730951`, 1.4142135623730951`, 
     4.440892098500626*^-16}, {1.4142135623730951`, 1.4142135623730951`, 
     0.3000000000000005}, {1.618033988749895, 1.1755705045849463`, 
     0.3000000000000005}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       0.3000000000000005}, {
      2^Rational[1, 2], 2^Rational[1, 2], 0.3000000000000005}, {
      2^Rational[1, 2], 2^Rational[1, 2], 0.6000000000000005}, {
      Rational[1, 2] (1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       0.6000000000000005}}, {{1.618033988749895, 1.1755705045849463`, 
     0.3000000000000005}, {1.4142135623730951`, 1.4142135623730951`, 
     0.3000000000000005}, {1.4142135623730951`, 1.4142135623730951`, 
     0.6000000000000005}, {1.618033988749895, 1.1755705045849463`, 
     0.6000000000000005}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       0.6000000000000005}, {
      2^Rational[1, 2], 2^Rational[1, 2], 0.6000000000000005}, {
      2^Rational[1, 2], 2^Rational[1, 2], 0.9000000000000006}, {
      Rational[1, 2] (1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       0.9000000000000006}}, {{1.618033988749895, 1.1755705045849463`, 
     0.6000000000000005}, {1.4142135623730951`, 1.4142135623730951`, 
     0.6000000000000005}, {1.4142135623730951`, 1.4142135623730951`, 
     0.9000000000000006}, {1.618033988749895, 1.1755705045849463`, 
     0.9000000000000006}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       0.9000000000000006}, {
      2^Rational[1, 2], 2^Rational[1, 2], 0.9000000000000006}, {
      2^Rational[1, 2], 2^Rational[1, 2], 1.2000000000000006`}, {
      Rational[1, 2] (1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       1.2000000000000006`}}, {{1.618033988749895, 1.1755705045849463`, 
     0.9000000000000006}, {1.4142135623730951`, 1.4142135623730951`, 
     0.9000000000000006}, {1.4142135623730951`, 1.4142135623730951`, 
     1.2000000000000006`}, {1.618033988749895, 1.1755705045849463`, 
     1.2000000000000006`}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       1.2000000000000006`}, {
      2^Rational[1, 2], 2^Rational[1, 2], 1.2000000000000006`}, {
      2^Rational[1, 2], 2^Rational[1, 2], 1.5000000000000007`}, {
      Rational[1, 2] (1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       1.5000000000000007`}}, {{1.618033988749895, 1.1755705045849463`, 
     1.2000000000000006`}, {1.4142135623730951`, 1.4142135623730951`, 
     1.2000000000000006`}, {1.4142135623730951`, 1.4142135623730951`, 
     1.5000000000000007`}, {1.618033988749895, 1.1755705045849463`, 
     1.5000000000000007`}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       1.5000000000000007`}, {
      2^Rational[1, 2], 2^Rational[1, 2], 1.5000000000000007`}, {
      2^Rational[1, 2], 2^Rational[1, 2], 1.8000000000000007`}, {
      Rational[1, 2] (1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       1.8000000000000007`}}, {{1.618033988749895, 1.1755705045849463`, 
     1.5000000000000007`}, {1.4142135623730951`, 1.4142135623730951`, 
     1.5000000000000007`}, {1.4142135623730951`, 1.4142135623730951`, 
     1.8000000000000007`}, {1.618033988749895, 1.1755705045849463`, 
     1.8000000000000007`}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       1.8000000000000007`}, {
      2^Rational[1, 2], 2^Rational[1, 2], 1.8000000000000007`}, {
      2^Rational[1, 2], 2^Rational[1, 2], 2.1000000000000005`}, {
      Rational[1, 2] (1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       2.1000000000000005`}}, {{1.618033988749895, 1.1755705045849463`, 
     1.8000000000000007`}, {1.4142135623730951`, 1.4142135623730951`, 
     1.8000000000000007`}, {1.4142135623730951`, 1.4142135623730951`, 
     2.1000000000000005`}, {1.618033988749895, 1.1755705045849463`, 
     2.1000000000000005`}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       2.1000000000000005`}, {
      2^Rational[1, 2], 2^Rational[1, 2], 2.1000000000000005`}, {
      2^Rational[1, 2], 2^Rational[1, 2], 2.4000000000000004`}, {
      Rational[1, 2] (1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       2.4000000000000004`}}, {{1.618033988749895, 1.1755705045849463`, 
     2.1000000000000005`}, {1.4142135623730951`, 1.4142135623730951`, 
     2.1000000000000005`}, {1.4142135623730951`, 1.4142135623730951`, 
     2.4000000000000004`}, {1.618033988749895, 1.1755705045849463`, 
     2.4000000000000004`}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       2.400000000000001}, {
      2^Rational[1, 2], 2^Rational[1, 2], 2.400000000000001}, {
      2^Rational[1, 2], 2^Rational[1, 2], 2.700000000000001}, {
      Rational[1, 2] (1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       2.700000000000001}}, {{1.618033988749895, 1.1755705045849463`, 
     2.400000000000001}, {1.4142135623730951`, 1.4142135623730951`, 
     2.400000000000001}, {1.4142135623730951`, 1.4142135623730951`, 
     2.700000000000001}, {1.618033988749895, 1.1755705045849463`, 
     2.700000000000001}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       2.700000000000001}, {
      2^Rational[1, 2], 2^Rational[1, 2], 2.700000000000001}, {
      2^Rational[1, 2], 2^Rational[1, 2], 3.000000000000001}, {
      Rational[1, 2] (1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       3.000000000000001}}, {{1.618033988749895, 1.1755705045849463`, 
     2.700000000000001}, {1.4142135623730951`, 1.4142135623730951`, 
     2.700000000000001}, {1.4142135623730951`, 1.4142135623730951`, 
     3.000000000000001}, {1.618033988749895, 1.1755705045849463`, 
     3.000000000000001}}]], 
   Polygon3DBox[
    NCache[{{2^Rational[1, 2], 2^Rational[1, 2], -3.}, {
      2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 + 5^Rational[1, 2]), -3.}, {
      2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 + 5^Rational[1, 2]), -2.7}, {
      2^Rational[1, 2], 2^Rational[1, 2], -2.7}}, {{1.4142135623730951`, 
     1.4142135623730951`, -3.}, {1.1755705045849463`, 
     1.618033988749895, -3.}, {1.1755705045849463`, 
     1.618033988749895, -2.7}, {1.4142135623730951`, 
     1.4142135623730951`, -2.7}}]], 
   Polygon3DBox[
    NCache[{{2^Rational[1, 2], 2^Rational[1, 2], -2.7}, {
      2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 + 5^Rational[1, 2]), -2.7}, {
      2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 + 5^Rational[1, 2]), -2.4000000000000004`}, {
      2^Rational[1, 2], 2^Rational[1, 2], -2.4000000000000004`}}, {{
     1.4142135623730951`, 1.4142135623730951`, -2.7}, {1.1755705045849463`, 
     1.618033988749895, -2.7}, {1.1755705045849463`, 
     1.618033988749895, -2.4000000000000004`}, {1.4142135623730951`, 
     1.4142135623730951`, -2.4000000000000004`}}]], 
   Polygon3DBox[
    NCache[{{2^Rational[1, 2], 2^Rational[1, 2], -2.4}, {
      2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 + 5^Rational[1, 2]), -2.4}, {
      2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 + 5^Rational[1, 2]), -2.0999999999999996`}, {
      2^Rational[1, 2], 2^Rational[1, 2], -2.0999999999999996`}}, {{
     1.4142135623730951`, 1.4142135623730951`, -2.4}, {1.1755705045849463`, 
     1.618033988749895, -2.4}, {1.1755705045849463`, 
     1.618033988749895, -2.0999999999999996`}, {1.4142135623730951`, 
     1.4142135623730951`, -2.0999999999999996`}}]], 
   Polygon3DBox[
    NCache[{{2^Rational[1, 2], 2^Rational[1, 2], -2.0999999999999996`}, {
      2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 + 5^Rational[1, 2]), -2.0999999999999996`}, {
      2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 + 5^Rational[1, 2]), -1.7999999999999996`}, {
      2^Rational[1, 2], 2^Rational[1, 2], -1.7999999999999996`}}, {{
     1.4142135623730951`, 1.4142135623730951`, -2.0999999999999996`}, {
     1.1755705045849463`, 1.618033988749895, -2.0999999999999996`}, {
     1.1755705045849463`, 1.618033988749895, -1.7999999999999996`}, {
     1.4142135623730951`, 1.4142135623730951`, -1.7999999999999996`}}]], 
   Polygon3DBox[
    NCache[{{2^Rational[1, 2], 2^Rational[1, 2], -1.7999999999999998`}, {
      2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 + 5^Rational[1, 2]), -1.7999999999999998`}, {
      2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 + 5^Rational[1, 2]), -1.4999999999999998`}, {
      2^Rational[1, 2], 2^Rational[1, 2], -1.4999999999999998`}}, {{
     1.4142135623730951`, 1.4142135623730951`, -1.7999999999999998`}, {
     1.1755705045849463`, 1.618033988749895, -1.7999999999999998`}, {
     1.1755705045849463`, 1.618033988749895, -1.4999999999999998`}, {
     1.4142135623730951`, 1.4142135623730951`, -1.4999999999999998`}}]], 
   Polygon3DBox[
    NCache[{{2^Rational[1, 2], 2^Rational[1, 2], -1.4999999999999998`}, {
      2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 + 5^Rational[1, 2]), -1.4999999999999998`}, {
      2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 + 5^Rational[1, 2]), -1.1999999999999997`}, {
      2^Rational[1, 2], 2^Rational[1, 2], -1.1999999999999997`}}, {{
     1.4142135623730951`, 1.4142135623730951`, -1.4999999999999998`}, {
     1.1755705045849463`, 1.618033988749895, -1.4999999999999998`}, {
     1.1755705045849463`, 1.618033988749895, -1.1999999999999997`}, {
     1.4142135623730951`, 1.4142135623730951`, -1.1999999999999997`}}]], 
   Polygon3DBox[
    NCache[{{2^Rational[1, 2], 2^Rational[1, 2], -1.1999999999999997`}, {
      2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 + 5^Rational[1, 2]), -1.1999999999999997`}, {
      2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 + 5^Rational[1, 2]), -0.8999999999999997}, {
      2^Rational[1, 2], 2^Rational[1, 2], -0.8999999999999997}}, {{
     1.4142135623730951`, 1.4142135623730951`, -1.1999999999999997`}, {
     1.1755705045849463`, 1.618033988749895, -1.1999999999999997`}, {
     1.1755705045849463`, 1.618033988749895, -0.8999999999999997}, {
     1.4142135623730951`, 1.4142135623730951`, -0.8999999999999997}}]], 
   Polygon3DBox[
    NCache[{{2^Rational[1, 2], 2^Rational[1, 2], -0.8999999999999997}, {
      2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 + 5^Rational[1, 2]), -0.8999999999999997}, {
      2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 + 5^Rational[1, 2]), -0.5999999999999996}, {
      2^Rational[1, 2], 2^Rational[1, 2], -0.5999999999999996}}, {{
     1.4142135623730951`, 1.4142135623730951`, -0.8999999999999997}, {
     1.1755705045849463`, 1.618033988749895, -0.8999999999999997}, {
     1.1755705045849463`, 1.618033988749895, -0.5999999999999996}, {
     1.4142135623730951`, 1.4142135623730951`, -0.5999999999999996}}]], 
   Polygon3DBox[
    NCache[{{2^Rational[1, 2], 2^Rational[1, 2], -0.5999999999999996}, {
      2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 + 5^Rational[1, 2]), -0.5999999999999996}, {
      2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 + 5^Rational[1, 2]), -0.2999999999999996}, {
      2^Rational[1, 2], 2^Rational[1, 2], -0.2999999999999996}}, {{
     1.4142135623730951`, 1.4142135623730951`, -0.5999999999999996}, {
     1.1755705045849463`, 1.618033988749895, -0.5999999999999996}, {
     1.1755705045849463`, 1.618033988749895, -0.2999999999999996}, {
     1.4142135623730951`, 1.4142135623730951`, -0.2999999999999996}}]], 
   Polygon3DBox[
    NCache[{{2^Rational[1, 2], 2^Rational[1, 2], -0.2999999999999996}, {
      2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 + 5^Rational[1, 2]), -0.2999999999999996}, {
      2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 + 5^Rational[1, 2]), 4.440892098500626*^-16}, {
      2^Rational[1, 2], 2^Rational[1, 2], 4.440892098500626*^-16}}, {{
     1.4142135623730951`, 1.4142135623730951`, -0.2999999999999996}, {
     1.1755705045849463`, 1.618033988749895, -0.2999999999999996}, {
     1.1755705045849463`, 1.618033988749895, 4.440892098500626*^-16}, {
     1.4142135623730951`, 1.4142135623730951`, 4.440892098500626*^-16}}]], 
   Polygon3DBox[
    NCache[{{2^Rational[1, 2], 2^Rational[1, 2], 4.440892098500626*^-16}, {
      2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 + 5^Rational[1, 2]), 4.440892098500626*^-16}, {
      2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 + 5^Rational[1, 2]), 0.3000000000000005}, {
      2^Rational[1, 2], 2^Rational[1, 2], 0.3000000000000005}}, {{
     1.4142135623730951`, 1.4142135623730951`, 4.440892098500626*^-16}, {
     1.1755705045849463`, 1.618033988749895, 4.440892098500626*^-16}, {
     1.1755705045849463`, 1.618033988749895, 0.3000000000000005}, {
     1.4142135623730951`, 1.4142135623730951`, 0.3000000000000005}}]], 
   Polygon3DBox[
    NCache[{{2^Rational[1, 2], 2^Rational[1, 2], 0.3000000000000005}, {
      2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 + 5^Rational[1, 2]), 0.3000000000000005}, {
      2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 + 5^Rational[1, 2]), 0.6000000000000005}, {
      2^Rational[1, 2], 2^Rational[1, 2], 0.6000000000000005}}, {{
     1.4142135623730951`, 1.4142135623730951`, 0.3000000000000005}, {
     1.1755705045849463`, 1.618033988749895, 0.3000000000000005}, {
     1.1755705045849463`, 1.618033988749895, 0.6000000000000005}, {
     1.4142135623730951`, 1.4142135623730951`, 0.6000000000000005}}]], 
   Polygon3DBox[
    NCache[{{2^Rational[1, 2], 2^Rational[1, 2], 0.6000000000000005}, {
      2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 + 5^Rational[1, 2]), 0.6000000000000005}, {
      2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 + 5^Rational[1, 2]), 0.9000000000000006}, {
      2^Rational[1, 2], 2^Rational[1, 2], 0.9000000000000006}}, {{
     1.4142135623730951`, 1.4142135623730951`, 0.6000000000000005}, {
     1.1755705045849463`, 1.618033988749895, 0.6000000000000005}, {
     1.1755705045849463`, 1.618033988749895, 0.9000000000000006}, {
     1.4142135623730951`, 1.4142135623730951`, 0.9000000000000006}}]], 
   Polygon3DBox[
    NCache[{{2^Rational[1, 2], 2^Rational[1, 2], 0.9000000000000006}, {
      2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 + 5^Rational[1, 2]), 0.9000000000000006}, {
      2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 + 5^Rational[1, 2]), 1.2000000000000006`}, {
      2^Rational[1, 2], 2^Rational[1, 2], 1.2000000000000006`}}, {{
     1.4142135623730951`, 1.4142135623730951`, 0.9000000000000006}, {
     1.1755705045849463`, 1.618033988749895, 0.9000000000000006}, {
     1.1755705045849463`, 1.618033988749895, 1.2000000000000006`}, {
     1.4142135623730951`, 1.4142135623730951`, 1.2000000000000006`}}]], 
   Polygon3DBox[
    NCache[{{2^Rational[1, 2], 2^Rational[1, 2], 1.2000000000000006`}, {
      2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 + 5^Rational[1, 2]), 1.2000000000000006`}, {
      2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 + 5^Rational[1, 2]), 1.5000000000000007`}, {
      2^Rational[1, 2], 2^Rational[1, 2], 1.5000000000000007`}}, {{
     1.4142135623730951`, 1.4142135623730951`, 1.2000000000000006`}, {
     1.1755705045849463`, 1.618033988749895, 1.2000000000000006`}, {
     1.1755705045849463`, 1.618033988749895, 1.5000000000000007`}, {
     1.4142135623730951`, 1.4142135623730951`, 1.5000000000000007`}}]], 
   Polygon3DBox[
    NCache[{{2^Rational[1, 2], 2^Rational[1, 2], 1.5000000000000007`}, {
      2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 + 5^Rational[1, 2]), 1.5000000000000007`}, {
      2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 + 5^Rational[1, 2]), 1.8000000000000007`}, {
      2^Rational[1, 2], 2^Rational[1, 2], 1.8000000000000007`}}, {{
     1.4142135623730951`, 1.4142135623730951`, 1.5000000000000007`}, {
     1.1755705045849463`, 1.618033988749895, 1.5000000000000007`}, {
     1.1755705045849463`, 1.618033988749895, 1.8000000000000007`}, {
     1.4142135623730951`, 1.4142135623730951`, 1.8000000000000007`}}]], 
   Polygon3DBox[
    NCache[{{2^Rational[1, 2], 2^Rational[1, 2], 1.8000000000000007`}, {
      2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 + 5^Rational[1, 2]), 1.8000000000000007`}, {
      2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 + 5^Rational[1, 2]), 2.1000000000000005`}, {
      2^Rational[1, 2], 2^Rational[1, 2], 2.1000000000000005`}}, {{
     1.4142135623730951`, 1.4142135623730951`, 1.8000000000000007`}, {
     1.1755705045849463`, 1.618033988749895, 1.8000000000000007`}, {
     1.1755705045849463`, 1.618033988749895, 2.1000000000000005`}, {
     1.4142135623730951`, 1.4142135623730951`, 2.1000000000000005`}}]], 
   Polygon3DBox[
    NCache[{{2^Rational[1, 2], 2^Rational[1, 2], 2.1000000000000005`}, {
      2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 + 5^Rational[1, 2]), 2.1000000000000005`}, {
      2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 + 5^Rational[1, 2]), 2.4000000000000004`}, {
      2^Rational[1, 2], 2^Rational[1, 2], 2.4000000000000004`}}, {{
     1.4142135623730951`, 1.4142135623730951`, 2.1000000000000005`}, {
     1.1755705045849463`, 1.618033988749895, 2.1000000000000005`}, {
     1.1755705045849463`, 1.618033988749895, 2.4000000000000004`}, {
     1.4142135623730951`, 1.4142135623730951`, 2.4000000000000004`}}]], 
   Polygon3DBox[
    NCache[{{2^Rational[1, 2], 2^Rational[1, 2], 2.400000000000001}, {
      2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 + 5^Rational[1, 2]), 2.400000000000001}, {
      2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 + 5^Rational[1, 2]), 2.700000000000001}, {
      2^Rational[1, 2], 2^Rational[1, 2], 2.700000000000001}}, {{
     1.4142135623730951`, 1.4142135623730951`, 2.400000000000001}, {
     1.1755705045849463`, 1.618033988749895, 2.400000000000001}, {
     1.1755705045849463`, 1.618033988749895, 2.700000000000001}, {
     1.4142135623730951`, 1.4142135623730951`, 2.700000000000001}}]], 
   Polygon3DBox[
    NCache[{{2^Rational[1, 2], 2^Rational[1, 2], 2.700000000000001}, {
      2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 + 5^Rational[1, 2]), 2.700000000000001}, {
      2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 + 5^Rational[1, 2]), 3.000000000000001}, {
      2^Rational[1, 2], 2^Rational[1, 2], 3.000000000000001}}, {{
     1.4142135623730951`, 1.4142135623730951`, 2.700000000000001}, {
     1.1755705045849463`, 1.618033988749895, 2.700000000000001}, {
     1.1755705045849463`, 1.618033988749895, 3.000000000000001}, {
     1.4142135623730951`, 1.4142135623730951`, 3.000000000000001}}]], 
   Polygon3DBox[
    NCache[{{2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 2] (1 + 5^Rational[1, 2]), -3.}, {
      2 Sin[Rational[3, 20] Pi], 2 Cos[Rational[3, 20] Pi], -3.}, {
      2 Sin[Rational[3, 20] Pi], 2 Cos[Rational[3, 20] Pi], -2.7}, {
      2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 + 5^Rational[1, 2]), -2.7}}, {{1.1755705045849463`, 
     1.618033988749895, -3.}, {0.9079809994790936, 
     1.7820130483767358`, -3.}, {0.9079809994790936, 
     1.7820130483767358`, -2.7}, {1.1755705045849463`, 
     1.618033988749895, -2.7}}]], 
   Polygon3DBox[
    NCache[{{2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 2] (1 + 5^Rational[1, 2]), -2.7}, {
      2 Sin[Rational[3, 20] Pi], 2 Cos[Rational[3, 20] Pi], -2.7}, {
      2 Sin[Rational[3, 20] Pi], 2 
       Cos[Rational[3, 20] Pi], -2.4000000000000004`}, {
      2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 + 5^Rational[1, 2]), -2.4000000000000004`}}, {{
     1.1755705045849463`, 1.618033988749895, -2.7}, {0.9079809994790936, 
     1.7820130483767358`, -2.7}, {0.9079809994790936, 
     1.7820130483767358`, -2.4000000000000004`}, {1.1755705045849463`, 
     1.618033988749895, -2.4000000000000004`}}]], 
   Polygon3DBox[
    NCache[{{2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 2] (1 + 5^Rational[1, 2]), -2.4}, {
      2 Sin[Rational[3, 20] Pi], 2 Cos[Rational[3, 20] Pi], -2.4}, {
      2 Sin[Rational[3, 20] Pi], 2 
       Cos[Rational[3, 20] Pi], -2.0999999999999996`}, {
      2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 + 5^Rational[1, 2]), -2.0999999999999996`}}, {{
     1.1755705045849463`, 1.618033988749895, -2.4}, {0.9079809994790936, 
     1.7820130483767358`, -2.4}, {0.9079809994790936, 
     1.7820130483767358`, -2.0999999999999996`}, {1.1755705045849463`, 
     1.618033988749895, -2.0999999999999996`}}]], 
   Polygon3DBox[
    NCache[{{2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], 
       Rational[1, 2] (1 + 5^Rational[1, 2]), -2.0999999999999996`}, {
      2 Sin[Rational[3, 20] Pi], 2 
       Cos[Rational[3, 20] Pi], -2.0999999999999996`}, {
      2 Sin[Rational[3, 20] Pi], 2 
       Cos[Rational[3, 20] Pi], -1.7999999999999996`}, {
      2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 + 5^Rational[1, 2]), -1.7999999999999996`}}, {{
     1.1755705045849463`, 1.618033988749895, -2.0999999999999996`}, {
     0.9079809994790936, 1.7820130483767358`, -2.0999999999999996`}, {
     0.9079809994790936, 1.7820130483767358`, -1.7999999999999996`}, {
     1.1755705045849463`, 1.618033988749895, -1.7999999999999996`}}]], 
   Polygon3DBox[
    NCache[{{2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], 
       Rational[1, 2] (1 + 5^Rational[1, 2]), -1.7999999999999998`}, {
      2 Sin[Rational[3, 20] Pi], 2 
       Cos[Rational[3, 20] Pi], -1.7999999999999998`}, {
      2 Sin[Rational[3, 20] Pi], 2 
       Cos[Rational[3, 20] Pi], -1.4999999999999998`}, {
      2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 + 5^Rational[1, 2]), -1.4999999999999998`}}, {{
     1.1755705045849463`, 1.618033988749895, -1.7999999999999998`}, {
     0.9079809994790936, 1.7820130483767358`, -1.7999999999999998`}, {
     0.9079809994790936, 1.7820130483767358`, -1.4999999999999998`}, {
     1.1755705045849463`, 1.618033988749895, -1.4999999999999998`}}]], 
   Polygon3DBox[
    NCache[{{2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], 
       Rational[1, 2] (1 + 5^Rational[1, 2]), -1.4999999999999998`}, {
      2 Sin[Rational[3, 20] Pi], 2 
       Cos[Rational[3, 20] Pi], -1.4999999999999998`}, {
      2 Sin[Rational[3, 20] Pi], 2 
       Cos[Rational[3, 20] Pi], -1.1999999999999997`}, {
      2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 + 5^Rational[1, 2]), -1.1999999999999997`}}, {{
     1.1755705045849463`, 1.618033988749895, -1.4999999999999998`}, {
     0.9079809994790936, 1.7820130483767358`, -1.4999999999999998`}, {
     0.9079809994790936, 1.7820130483767358`, -1.1999999999999997`}, {
     1.1755705045849463`, 1.618033988749895, -1.1999999999999997`}}]], 
   Polygon3DBox[
    NCache[{{2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], 
       Rational[1, 2] (1 + 5^Rational[1, 2]), -1.1999999999999997`}, {
      2 Sin[Rational[3, 20] Pi], 2 
       Cos[Rational[3, 20] Pi], -1.1999999999999997`}, {
      2 Sin[Rational[3, 20] Pi], 2 
       Cos[Rational[3, 20] Pi], -0.8999999999999997}, {
      2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 + 5^Rational[1, 2]), -0.8999999999999997}}, {{
     1.1755705045849463`, 1.618033988749895, -1.1999999999999997`}, {
     0.9079809994790936, 1.7820130483767358`, -1.1999999999999997`}, {
     0.9079809994790936, 1.7820130483767358`, -0.8999999999999997}, {
     1.1755705045849463`, 1.618033988749895, -0.8999999999999997}}]], 
   Polygon3DBox[
    NCache[{{2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], 
       Rational[1, 2] (1 + 5^Rational[1, 2]), -0.8999999999999997}, {
      2 Sin[Rational[3, 20] Pi], 2 
       Cos[Rational[3, 20] Pi], -0.8999999999999997}, {
      2 Sin[Rational[3, 20] Pi], 2 
       Cos[Rational[3, 20] Pi], -0.5999999999999996}, {
      2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 + 5^Rational[1, 2]), -0.5999999999999996}}, {{
     1.1755705045849463`, 1.618033988749895, -0.8999999999999997}, {
     0.9079809994790936, 1.7820130483767358`, -0.8999999999999997}, {
     0.9079809994790936, 1.7820130483767358`, -0.5999999999999996}, {
     1.1755705045849463`, 1.618033988749895, -0.5999999999999996}}]], 
   Polygon3DBox[
    NCache[{{2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], 
       Rational[1, 2] (1 + 5^Rational[1, 2]), -0.5999999999999996}, {
      2 Sin[Rational[3, 20] Pi], 2 
       Cos[Rational[3, 20] Pi], -0.5999999999999996}, {
      2 Sin[Rational[3, 20] Pi], 2 
       Cos[Rational[3, 20] Pi], -0.2999999999999996}, {
      2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 + 5^Rational[1, 2]), -0.2999999999999996}}, {{
     1.1755705045849463`, 1.618033988749895, -0.5999999999999996}, {
     0.9079809994790936, 1.7820130483767358`, -0.5999999999999996}, {
     0.9079809994790936, 1.7820130483767358`, -0.2999999999999996}, {
     1.1755705045849463`, 1.618033988749895, -0.2999999999999996}}]], 
   Polygon3DBox[
    NCache[{{2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], 
       Rational[1, 2] (1 + 5^Rational[1, 2]), -0.2999999999999996}, {
      2 Sin[Rational[3, 20] Pi], 2 
       Cos[Rational[3, 20] Pi], -0.2999999999999996}, {
      2 Sin[Rational[3, 20] Pi], 2 Cos[Rational[3, 20] Pi], 
       4.440892098500626*^-16}, {
      2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 + 5^Rational[1, 2]), 4.440892098500626*^-16}}, {{
     1.1755705045849463`, 1.618033988749895, -0.2999999999999996}, {
     0.9079809994790936, 1.7820130483767358`, -0.2999999999999996}, {
     0.9079809994790936, 1.7820130483767358`, 4.440892098500626*^-16}, {
     1.1755705045849463`, 1.618033988749895, 4.440892098500626*^-16}}]], 
   Polygon3DBox[
    NCache[{{2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 2] (1 + 5^Rational[1, 2]), 
       4.440892098500626*^-16}, {
      2 Sin[Rational[3, 20] Pi], 2 Cos[Rational[3, 20] Pi], 
       4.440892098500626*^-16}, {
      2 Sin[Rational[3, 20] Pi], 2 Cos[Rational[3, 20] Pi], 
       0.3000000000000005}, {
      2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 + 5^Rational[1, 2]), 0.3000000000000005}}, {{
     1.1755705045849463`, 1.618033988749895, 4.440892098500626*^-16}, {
     0.9079809994790936, 1.7820130483767358`, 4.440892098500626*^-16}, {
     0.9079809994790936, 1.7820130483767358`, 0.3000000000000005}, {
     1.1755705045849463`, 1.618033988749895, 0.3000000000000005}}]], 
   Polygon3DBox[
    NCache[{{2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 2] (1 + 5^Rational[1, 2]), 
       0.3000000000000005}, {
      2 Sin[Rational[3, 20] Pi], 2 Cos[Rational[3, 20] Pi], 
       0.3000000000000005}, {
      2 Sin[Rational[3, 20] Pi], 2 Cos[Rational[3, 20] Pi], 
       0.6000000000000005}, {
      2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 + 5^Rational[1, 2]), 0.6000000000000005}}, {{
     1.1755705045849463`, 1.618033988749895, 0.3000000000000005}, {
     0.9079809994790936, 1.7820130483767358`, 0.3000000000000005}, {
     0.9079809994790936, 1.7820130483767358`, 0.6000000000000005}, {
     1.1755705045849463`, 1.618033988749895, 0.6000000000000005}}]], 
   Polygon3DBox[
    NCache[{{2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 2] (1 + 5^Rational[1, 2]), 
       0.6000000000000005}, {
      2 Sin[Rational[3, 20] Pi], 2 Cos[Rational[3, 20] Pi], 
       0.6000000000000005}, {
      2 Sin[Rational[3, 20] Pi], 2 Cos[Rational[3, 20] Pi], 
       0.9000000000000006}, {
      2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 + 5^Rational[1, 2]), 0.9000000000000006}}, {{
     1.1755705045849463`, 1.618033988749895, 0.6000000000000005}, {
     0.9079809994790936, 1.7820130483767358`, 0.6000000000000005}, {
     0.9079809994790936, 1.7820130483767358`, 0.9000000000000006}, {
     1.1755705045849463`, 1.618033988749895, 0.9000000000000006}}]], 
   Polygon3DBox[
    NCache[{{2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 2] (1 + 5^Rational[1, 2]), 
       0.9000000000000006}, {
      2 Sin[Rational[3, 20] Pi], 2 Cos[Rational[3, 20] Pi], 
       0.9000000000000006}, {
      2 Sin[Rational[3, 20] Pi], 2 Cos[Rational[3, 20] Pi], 
       1.2000000000000006`}, {
      2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 + 5^Rational[1, 2]), 1.2000000000000006`}}, {{
     1.1755705045849463`, 1.618033988749895, 0.9000000000000006}, {
     0.9079809994790936, 1.7820130483767358`, 0.9000000000000006}, {
     0.9079809994790936, 1.7820130483767358`, 1.2000000000000006`}, {
     1.1755705045849463`, 1.618033988749895, 1.2000000000000006`}}]], 
   Polygon3DBox[
    NCache[{{2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 2] (1 + 5^Rational[1, 2]), 
       1.2000000000000006`}, {
      2 Sin[Rational[3, 20] Pi], 2 Cos[Rational[3, 20] Pi], 
       1.2000000000000006`}, {
      2 Sin[Rational[3, 20] Pi], 2 Cos[Rational[3, 20] Pi], 
       1.5000000000000007`}, {
      2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 + 5^Rational[1, 2]), 1.5000000000000007`}}, {{
     1.1755705045849463`, 1.618033988749895, 1.2000000000000006`}, {
     0.9079809994790936, 1.7820130483767358`, 1.2000000000000006`}, {
     0.9079809994790936, 1.7820130483767358`, 1.5000000000000007`}, {
     1.1755705045849463`, 1.618033988749895, 1.5000000000000007`}}]], 
   Polygon3DBox[
    NCache[{{2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 2] (1 + 5^Rational[1, 2]), 
       1.5000000000000007`}, {
      2 Sin[Rational[3, 20] Pi], 2 Cos[Rational[3, 20] Pi], 
       1.5000000000000007`}, {
      2 Sin[Rational[3, 20] Pi], 2 Cos[Rational[3, 20] Pi], 
       1.8000000000000007`}, {
      2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 + 5^Rational[1, 2]), 1.8000000000000007`}}, {{
     1.1755705045849463`, 1.618033988749895, 1.5000000000000007`}, {
     0.9079809994790936, 1.7820130483767358`, 1.5000000000000007`}, {
     0.9079809994790936, 1.7820130483767358`, 1.8000000000000007`}, {
     1.1755705045849463`, 1.618033988749895, 1.8000000000000007`}}]], 
   Polygon3DBox[
    NCache[{{2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 2] (1 + 5^Rational[1, 2]), 
       1.8000000000000007`}, {
      2 Sin[Rational[3, 20] Pi], 2 Cos[Rational[3, 20] Pi], 
       1.8000000000000007`}, {
      2 Sin[Rational[3, 20] Pi], 2 Cos[Rational[3, 20] Pi], 
       2.1000000000000005`}, {
      2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 + 5^Rational[1, 2]), 2.1000000000000005`}}, {{
     1.1755705045849463`, 1.618033988749895, 1.8000000000000007`}, {
     0.9079809994790936, 1.7820130483767358`, 1.8000000000000007`}, {
     0.9079809994790936, 1.7820130483767358`, 2.1000000000000005`}, {
     1.1755705045849463`, 1.618033988749895, 2.1000000000000005`}}]], 
   Polygon3DBox[
    NCache[{{2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 2] (1 + 5^Rational[1, 2]), 
       2.1000000000000005`}, {
      2 Sin[Rational[3, 20] Pi], 2 Cos[Rational[3, 20] Pi], 
       2.1000000000000005`}, {
      2 Sin[Rational[3, 20] Pi], 2 Cos[Rational[3, 20] Pi], 
       2.4000000000000004`}, {
      2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 + 5^Rational[1, 2]), 2.4000000000000004`}}, {{
     1.1755705045849463`, 1.618033988749895, 2.1000000000000005`}, {
     0.9079809994790936, 1.7820130483767358`, 2.1000000000000005`}, {
     0.9079809994790936, 1.7820130483767358`, 2.4000000000000004`}, {
     1.1755705045849463`, 1.618033988749895, 2.4000000000000004`}}]], 
   Polygon3DBox[
    NCache[{{2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 2] (1 + 5^Rational[1, 2]), 
       2.400000000000001}, {
      2 Sin[Rational[3, 20] Pi], 2 Cos[Rational[3, 20] Pi], 
       2.400000000000001}, {
      2 Sin[Rational[3, 20] Pi], 2 Cos[Rational[3, 20] Pi], 
       2.700000000000001}, {
      2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 + 5^Rational[1, 2]), 2.700000000000001}}, {{
     1.1755705045849463`, 1.618033988749895, 2.400000000000001}, {
     0.9079809994790936, 1.7820130483767358`, 2.400000000000001}, {
     0.9079809994790936, 1.7820130483767358`, 2.700000000000001}, {
     1.1755705045849463`, 1.618033988749895, 2.700000000000001}}]], 
   Polygon3DBox[
    NCache[{{2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 2] (1 + 5^Rational[1, 2]), 
       2.700000000000001}, {
      2 Sin[Rational[3, 20] Pi], 2 Cos[Rational[3, 20] Pi], 
       2.700000000000001}, {
      2 Sin[Rational[3, 20] Pi], 2 Cos[Rational[3, 20] Pi], 
       3.000000000000001}, {
      2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 + 5^Rational[1, 2]), 3.000000000000001}}, {{
     1.1755705045849463`, 1.618033988749895, 2.700000000000001}, {
     0.9079809994790936, 1.7820130483767358`, 2.700000000000001}, {
     0.9079809994790936, 1.7820130483767358`, 3.000000000000001}, {
     1.1755705045849463`, 1.618033988749895, 3.000000000000001}}]], 
   Polygon3DBox[
    NCache[{{2 Sin[Rational[3, 20] Pi], 2 Cos[Rational[3, 20] Pi], -3.}, {
      Rational[1, 2] (-1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -3.}, {
      Rational[1, 2] (-1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -2.7}, {
      2 Sin[Rational[3, 20] Pi], 2 Cos[Rational[3, 20] Pi], -2.7}}, {{
     0.9079809994790936, 1.7820130483767358`, -3.}, {0.6180339887498949, 
     1.902113032590307, -3.}, {0.6180339887498949, 1.902113032590307, -2.7}, {
     0.9079809994790936, 1.7820130483767358`, -2.7}}]], 
   Polygon3DBox[
    NCache[{{2 Sin[Rational[3, 20] Pi], 2 Cos[Rational[3, 20] Pi], -2.7}, {
      Rational[1, 2] (-1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -2.7}, {
      Rational[1, 2] (-1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -2.4000000000000004`}, {
      2 Sin[Rational[3, 20] Pi], 2 
       Cos[Rational[3, 20] Pi], -2.4000000000000004`}}, {{0.9079809994790936, 
     1.7820130483767358`, -2.7}, {0.6180339887498949, 
     1.902113032590307, -2.7}, {0.6180339887498949, 
     1.902113032590307, -2.4000000000000004`}, {0.9079809994790936, 
     1.7820130483767358`, -2.4000000000000004`}}]], 
   Polygon3DBox[
    NCache[{{2 Sin[Rational[3, 20] Pi], 2 Cos[Rational[3, 20] Pi], -2.4}, {
      Rational[1, 2] (-1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -2.4}, {
      Rational[1, 2] (-1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -2.0999999999999996`}, {
      2 Sin[Rational[3, 20] Pi], 2 
       Cos[Rational[3, 20] Pi], -2.0999999999999996`}}, {{0.9079809994790936, 
     1.7820130483767358`, -2.4}, {0.6180339887498949, 
     1.902113032590307, -2.4}, {0.6180339887498949, 
     1.902113032590307, -2.0999999999999996`}, {0.9079809994790936, 
     1.7820130483767358`, -2.0999999999999996`}}]], 
   Polygon3DBox[
    NCache[{{2 Sin[Rational[3, 20] Pi], 2 
       Cos[Rational[3, 20] Pi], -2.0999999999999996`}, {
      Rational[1, 2] (-1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -2.0999999999999996`}, {
      Rational[1, 2] (-1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -1.7999999999999996`}, {
      2 Sin[Rational[3, 20] Pi], 2 
       Cos[Rational[3, 20] Pi], -1.7999999999999996`}}, {{0.9079809994790936, 
     1.7820130483767358`, -2.0999999999999996`}, {0.6180339887498949, 
     1.902113032590307, -2.0999999999999996`}, {0.6180339887498949, 
     1.902113032590307, -1.7999999999999996`}, {0.9079809994790936, 
     1.7820130483767358`, -1.7999999999999996`}}]], 
   Polygon3DBox[
    NCache[{{2 Sin[Rational[3, 20] Pi], 2 
       Cos[Rational[3, 20] Pi], -1.7999999999999998`}, {
      Rational[1, 2] (-1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -1.7999999999999998`}, {
      Rational[1, 2] (-1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -1.4999999999999998`}, {
      2 Sin[Rational[3, 20] Pi], 2 
       Cos[Rational[3, 20] Pi], -1.4999999999999998`}}, {{0.9079809994790936, 
     1.7820130483767358`, -1.7999999999999998`}, {0.6180339887498949, 
     1.902113032590307, -1.7999999999999998`}, {0.6180339887498949, 
     1.902113032590307, -1.4999999999999998`}, {0.9079809994790936, 
     1.7820130483767358`, -1.4999999999999998`}}]], 
   Polygon3DBox[
    NCache[{{2 Sin[Rational[3, 20] Pi], 2 
       Cos[Rational[3, 20] Pi], -1.4999999999999998`}, {
      Rational[1, 2] (-1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -1.4999999999999998`}, {
      Rational[1, 2] (-1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -1.1999999999999997`}, {
      2 Sin[Rational[3, 20] Pi], 2 
       Cos[Rational[3, 20] Pi], -1.1999999999999997`}}, {{0.9079809994790936, 
     1.7820130483767358`, -1.4999999999999998`}, {0.6180339887498949, 
     1.902113032590307, -1.4999999999999998`}, {0.6180339887498949, 
     1.902113032590307, -1.1999999999999997`}, {0.9079809994790936, 
     1.7820130483767358`, -1.1999999999999997`}}]], 
   Polygon3DBox[
    NCache[{{2 Sin[Rational[3, 20] Pi], 2 
       Cos[Rational[3, 20] Pi], -1.1999999999999997`}, {
      Rational[1, 2] (-1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -1.1999999999999997`}, {
      Rational[1, 2] (-1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -0.8999999999999997}, {
      2 Sin[Rational[3, 20] Pi], 2 
       Cos[Rational[3, 20] Pi], -0.8999999999999997}}, {{0.9079809994790936, 
     1.7820130483767358`, -1.1999999999999997`}, {0.6180339887498949, 
     1.902113032590307, -1.1999999999999997`}, {0.6180339887498949, 
     1.902113032590307, -0.8999999999999997}, {0.9079809994790936, 
     1.7820130483767358`, -0.8999999999999997}}]], 
   Polygon3DBox[
    NCache[{{2 Sin[Rational[3, 20] Pi], 2 
       Cos[Rational[3, 20] Pi], -0.8999999999999997}, {
      Rational[1, 2] (-1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -0.8999999999999997}, {
      Rational[1, 2] (-1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -0.5999999999999996}, {
      2 Sin[Rational[3, 20] Pi], 2 
       Cos[Rational[3, 20] Pi], -0.5999999999999996}}, {{0.9079809994790936, 
     1.7820130483767358`, -0.8999999999999997}, {0.6180339887498949, 
     1.902113032590307, -0.8999999999999997}, {0.6180339887498949, 
     1.902113032590307, -0.5999999999999996}, {0.9079809994790936, 
     1.7820130483767358`, -0.5999999999999996}}]], 
   Polygon3DBox[
    NCache[{{2 Sin[Rational[3, 20] Pi], 2 
       Cos[Rational[3, 20] Pi], -0.5999999999999996}, {
      Rational[1, 2] (-1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -0.5999999999999996}, {
      Rational[1, 2] (-1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -0.2999999999999996}, {
      2 Sin[Rational[3, 20] Pi], 2 
       Cos[Rational[3, 20] Pi], -0.2999999999999996}}, {{0.9079809994790936, 
     1.7820130483767358`, -0.5999999999999996}, {0.6180339887498949, 
     1.902113032590307, -0.5999999999999996}, {0.6180339887498949, 
     1.902113032590307, -0.2999999999999996}, {0.9079809994790936, 
     1.7820130483767358`, -0.2999999999999996}}]], 
   Polygon3DBox[
    NCache[{{2 Sin[Rational[3, 20] Pi], 2 
       Cos[Rational[3, 20] Pi], -0.2999999999999996}, {
      Rational[1, 2] (-1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -0.2999999999999996}, {
      Rational[1, 2] (-1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       4.440892098500626*^-16}, {
      2 Sin[Rational[3, 20] Pi], 2 Cos[Rational[3, 20] Pi], 
       4.440892098500626*^-16}}, {{0.9079809994790936, 
     1.7820130483767358`, -0.2999999999999996}, {0.6180339887498949, 
     1.902113032590307, -0.2999999999999996}, {0.6180339887498949, 
     1.902113032590307, 4.440892098500626*^-16}, {0.9079809994790936, 
     1.7820130483767358`, 4.440892098500626*^-16}}]], 
   Polygon3DBox[
    NCache[{{2 Sin[Rational[3, 20] Pi], 2 Cos[Rational[3, 20] Pi], 
       4.440892098500626*^-16}, {
      Rational[1, 2] (-1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       4.440892098500626*^-16}, {
      Rational[1, 2] (-1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       0.3000000000000005}, {
      2 Sin[Rational[3, 20] Pi], 2 Cos[Rational[3, 20] Pi], 
       0.3000000000000005}}, {{0.9079809994790936, 1.7820130483767358`, 
     4.440892098500626*^-16}, {0.6180339887498949, 1.902113032590307, 
     4.440892098500626*^-16}, {0.6180339887498949, 1.902113032590307, 
     0.3000000000000005}, {0.9079809994790936, 1.7820130483767358`, 
     0.3000000000000005}}]], 
   Polygon3DBox[
    NCache[{{2 Sin[Rational[3, 20] Pi], 2 Cos[Rational[3, 20] Pi], 
       0.3000000000000005}, {
      Rational[1, 2] (-1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       0.3000000000000005}, {
      Rational[1, 2] (-1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       0.6000000000000005}, {
      2 Sin[Rational[3, 20] Pi], 2 Cos[Rational[3, 20] Pi], 
       0.6000000000000005}}, {{0.9079809994790936, 1.7820130483767358`, 
     0.3000000000000005}, {0.6180339887498949, 1.902113032590307, 
     0.3000000000000005}, {0.6180339887498949, 1.902113032590307, 
     0.6000000000000005}, {0.9079809994790936, 1.7820130483767358`, 
     0.6000000000000005}}]], 
   Polygon3DBox[
    NCache[{{2 Sin[Rational[3, 20] Pi], 2 Cos[Rational[3, 20] Pi], 
       0.6000000000000005}, {
      Rational[1, 2] (-1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       0.6000000000000005}, {
      Rational[1, 2] (-1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       0.9000000000000006}, {
      2 Sin[Rational[3, 20] Pi], 2 Cos[Rational[3, 20] Pi], 
       0.9000000000000006}}, {{0.9079809994790936, 1.7820130483767358`, 
     0.6000000000000005}, {0.6180339887498949, 1.902113032590307, 
     0.6000000000000005}, {0.6180339887498949, 1.902113032590307, 
     0.9000000000000006}, {0.9079809994790936, 1.7820130483767358`, 
     0.9000000000000006}}]], 
   Polygon3DBox[
    NCache[{{2 Sin[Rational[3, 20] Pi], 2 Cos[Rational[3, 20] Pi], 
       0.9000000000000006}, {
      Rational[1, 2] (-1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       0.9000000000000006}, {
      Rational[1, 2] (-1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       1.2000000000000006`}, {
      2 Sin[Rational[3, 20] Pi], 2 Cos[Rational[3, 20] Pi], 
       1.2000000000000006`}}, {{0.9079809994790936, 1.7820130483767358`, 
     0.9000000000000006}, {0.6180339887498949, 1.902113032590307, 
     0.9000000000000006}, {0.6180339887498949, 1.902113032590307, 
     1.2000000000000006`}, {0.9079809994790936, 1.7820130483767358`, 
     1.2000000000000006`}}]], 
   Polygon3DBox[
    NCache[{{2 Sin[Rational[3, 20] Pi], 2 Cos[Rational[3, 20] Pi], 
       1.2000000000000006`}, {
      Rational[1, 2] (-1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       1.2000000000000006`}, {
      Rational[1, 2] (-1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       1.5000000000000007`}, {
      2 Sin[Rational[3, 20] Pi], 2 Cos[Rational[3, 20] Pi], 
       1.5000000000000007`}}, {{0.9079809994790936, 1.7820130483767358`, 
     1.2000000000000006`}, {0.6180339887498949, 1.902113032590307, 
     1.2000000000000006`}, {0.6180339887498949, 1.902113032590307, 
     1.5000000000000007`}, {0.9079809994790936, 1.7820130483767358`, 
     1.5000000000000007`}}]], 
   Polygon3DBox[
    NCache[{{2 Sin[Rational[3, 20] Pi], 2 Cos[Rational[3, 20] Pi], 
       1.5000000000000007`}, {
      Rational[1, 2] (-1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       1.5000000000000007`}, {
      Rational[1, 2] (-1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       1.8000000000000007`}, {
      2 Sin[Rational[3, 20] Pi], 2 Cos[Rational[3, 20] Pi], 
       1.8000000000000007`}}, {{0.9079809994790936, 1.7820130483767358`, 
     1.5000000000000007`}, {0.6180339887498949, 1.902113032590307, 
     1.5000000000000007`}, {0.6180339887498949, 1.902113032590307, 
     1.8000000000000007`}, {0.9079809994790936, 1.7820130483767358`, 
     1.8000000000000007`}}]], 
   Polygon3DBox[
    NCache[{{
      2 Sin[Rational[3, 20] Pi], 2 Cos[Rational[3, 20] Pi], 
       1.8000000000000007`}, {
      Rational[1, 2] (-1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       1.8000000000000007`}, {
      Rational[1, 2] (-1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       2.1000000000000005`}, {
      2 Sin[Rational[3, 20] Pi], 2 Cos[Rational[3, 20] Pi], 
       2.1000000000000005`}}, {{0.9079809994790936, 1.7820130483767358`, 
     1.8000000000000007`}, {0.6180339887498949, 1.902113032590307, 
     1.8000000000000007`}, {0.6180339887498949, 1.902113032590307, 
     2.1000000000000005`}, {0.9079809994790936, 1.7820130483767358`, 
     2.1000000000000005`}}]], 
   Polygon3DBox[
    NCache[{{2 Sin[Rational[3, 20] Pi], 2 Cos[Rational[3, 20] Pi], 
       2.1000000000000005`}, {
      Rational[1, 2] (-1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       2.1000000000000005`}, {
      Rational[1, 2] (-1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       2.4000000000000004`}, {
      2 Sin[Rational[3, 20] Pi], 2 Cos[Rational[3, 20] Pi], 
       2.4000000000000004`}}, {{0.9079809994790936, 1.7820130483767358`, 
     2.1000000000000005`}, {0.6180339887498949, 1.902113032590307, 
     2.1000000000000005`}, {0.6180339887498949, 1.902113032590307, 
     2.4000000000000004`}, {0.9079809994790936, 1.7820130483767358`, 
     2.4000000000000004`}}]], 
   Polygon3DBox[
    NCache[{{2 Sin[Rational[3, 20] Pi], 2 Cos[Rational[3, 20] Pi], 
       2.400000000000001}, {
      Rational[1, 2] (-1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       2.400000000000001}, {
      Rational[1, 2] (-1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       2.700000000000001}, {
      2 Sin[Rational[3, 20] Pi], 2 Cos[Rational[3, 20] Pi], 
       2.700000000000001}}, {{0.9079809994790936, 1.7820130483767358`, 
     2.400000000000001}, {0.6180339887498949, 1.902113032590307, 
     2.400000000000001}, {0.6180339887498949, 1.902113032590307, 
     2.700000000000001}, {0.9079809994790936, 1.7820130483767358`, 
     2.700000000000001}}]], 
   Polygon3DBox[
    NCache[{{2 Sin[Rational[3, 20] Pi], 2 Cos[Rational[3, 20] Pi], 
       2.700000000000001}, {
      Rational[1, 2] (-1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       2.700000000000001}, {
      Rational[1, 2] (-1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       3.000000000000001}, {
      2 Sin[Rational[3, 20] Pi], 2 Cos[Rational[3, 20] Pi], 
       3.000000000000001}}, {{0.9079809994790936, 1.7820130483767358`, 
     2.700000000000001}, {0.6180339887498949, 1.902113032590307, 
     2.700000000000001}, {0.6180339887498949, 1.902113032590307, 
     3.000000000000001}, {0.9079809994790936, 1.7820130483767358`, 
     3.000000000000001}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (-1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -3.}, {
      2 Sin[Rational[1, 20] Pi], 2 Cos[Rational[1, 20] Pi], -3.}, {
      2 Sin[Rational[1, 20] Pi], 2 Cos[Rational[1, 20] Pi], -2.7}, {
      Rational[1, 2] (-1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -2.7}}, {{0.6180339887498949, 
     1.902113032590307, -3.}, {0.31286893008046174`, 
     1.9753766811902755`, -3.}, {0.31286893008046174`, 
     1.9753766811902755`, -2.7}, {0.6180339887498949, 
     1.902113032590307, -2.7}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (-1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -2.7}, {
      2 Sin[Rational[1, 20] Pi], 2 Cos[Rational[1, 20] Pi], -2.7}, {
      2 Sin[Rational[1, 20] Pi], 2 
       Cos[Rational[1, 20] Pi], -2.4000000000000004`}, {
      Rational[1, 2] (-1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -2.4000000000000004`}}, {{0.6180339887498949, 
     1.902113032590307, -2.7}, {0.31286893008046174`, 
     1.9753766811902755`, -2.7}, {0.31286893008046174`, 
     1.9753766811902755`, -2.4000000000000004`}, {0.6180339887498949, 
     1.902113032590307, -2.4000000000000004`}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (-1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -2.4}, {
      2 Sin[Rational[1, 20] Pi], 2 Cos[Rational[1, 20] Pi], -2.4}, {
      2 Sin[Rational[1, 20] Pi], 2 
       Cos[Rational[1, 20] Pi], -2.0999999999999996`}, {
      Rational[1, 2] (-1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -2.0999999999999996`}}, {{0.6180339887498949, 
     1.902113032590307, -2.4}, {0.31286893008046174`, 
     1.9753766811902755`, -2.4}, {0.31286893008046174`, 
     1.9753766811902755`, -2.0999999999999996`}, {0.6180339887498949, 
     1.902113032590307, -2.0999999999999996`}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (-1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -2.0999999999999996`}, {
      2 Sin[Rational[1, 20] Pi], 2 
       Cos[Rational[1, 20] Pi], -2.0999999999999996`}, {
      2 Sin[Rational[1, 20] Pi], 2 
       Cos[Rational[1, 20] Pi], -1.7999999999999996`}, {
      Rational[1, 2] (-1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -1.7999999999999996`}}, {{0.6180339887498949, 
     1.902113032590307, -2.0999999999999996`}, {0.31286893008046174`, 
     1.9753766811902755`, -2.0999999999999996`}, {0.31286893008046174`, 
     1.9753766811902755`, -1.7999999999999996`}, {0.6180339887498949, 
     1.902113032590307, -1.7999999999999996`}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (-1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -1.7999999999999998`}, {
      2 Sin[Rational[1, 20] Pi], 2 
       Cos[Rational[1, 20] Pi], -1.7999999999999998`}, {
      2 Sin[Rational[1, 20] Pi], 2 
       Cos[Rational[1, 20] Pi], -1.4999999999999998`}, {
      Rational[1, 2] (-1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -1.4999999999999998`}}, {{0.6180339887498949, 
     1.902113032590307, -1.7999999999999998`}, {0.31286893008046174`, 
     1.9753766811902755`, -1.7999999999999998`}, {0.31286893008046174`, 
     1.9753766811902755`, -1.4999999999999998`}, {0.6180339887498949, 
     1.902113032590307, -1.4999999999999998`}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (-1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -1.4999999999999998`}, {
      2 Sin[Rational[1, 20] Pi], 2 
       Cos[Rational[1, 20] Pi], -1.4999999999999998`}, {
      2 Sin[Rational[1, 20] Pi], 2 
       Cos[Rational[1, 20] Pi], -1.1999999999999997`}, {
      Rational[1, 2] (-1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -1.1999999999999997`}}, {{0.6180339887498949, 
     1.902113032590307, -1.4999999999999998`}, {0.31286893008046174`, 
     1.9753766811902755`, -1.4999999999999998`}, {0.31286893008046174`, 
     1.9753766811902755`, -1.1999999999999997`}, {0.6180339887498949, 
     1.902113032590307, -1.1999999999999997`}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (-1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -1.1999999999999997`}, {
      2 Sin[Rational[1, 20] Pi], 2 
       Cos[Rational[1, 20] Pi], -1.1999999999999997`}, {
      2 Sin[Rational[1, 20] Pi], 2 
       Cos[Rational[1, 20] Pi], -0.8999999999999997}, {
      Rational[1, 2] (-1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -0.8999999999999997}}, {{0.6180339887498949, 
     1.902113032590307, -1.1999999999999997`}, {0.31286893008046174`, 
     1.9753766811902755`, -1.1999999999999997`}, {0.31286893008046174`, 
     1.9753766811902755`, -0.8999999999999997}, {0.6180339887498949, 
     1.902113032590307, -0.8999999999999997}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (-1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -0.8999999999999997}, {
      2 Sin[Rational[1, 20] Pi], 2 
       Cos[Rational[1, 20] Pi], -0.8999999999999997}, {
      2 Sin[Rational[1, 20] Pi], 2 
       Cos[Rational[1, 20] Pi], -0.5999999999999996}, {
      Rational[1, 2] (-1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -0.5999999999999996}}, {{0.6180339887498949, 
     1.902113032590307, -0.8999999999999997}, {0.31286893008046174`, 
     1.9753766811902755`, -0.8999999999999997}, {0.31286893008046174`, 
     1.9753766811902755`, -0.5999999999999996}, {0.6180339887498949, 
     1.902113032590307, -0.5999999999999996}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (-1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -0.5999999999999996}, {
      2 Sin[Rational[1, 20] Pi], 2 
       Cos[Rational[1, 20] Pi], -0.5999999999999996}, {
      2 Sin[Rational[1, 20] Pi], 2 
       Cos[Rational[1, 20] Pi], -0.2999999999999996}, {
      Rational[1, 2] (-1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -0.2999999999999996}}, {{0.6180339887498949, 
     1.902113032590307, -0.5999999999999996}, {0.31286893008046174`, 
     1.9753766811902755`, -0.5999999999999996}, {0.31286893008046174`, 
     1.9753766811902755`, -0.2999999999999996}, {0.6180339887498949, 
     1.902113032590307, -0.2999999999999996}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (-1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -0.2999999999999996}, {
      2 Sin[Rational[1, 20] Pi], 2 
       Cos[Rational[1, 20] Pi], -0.2999999999999996}, {
      2 Sin[Rational[1, 20] Pi], 2 Cos[Rational[1, 20] Pi], 
       4.440892098500626*^-16}, {
      Rational[1, 2] (-1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       4.440892098500626*^-16}}, {{0.6180339887498949, 
     1.902113032590307, -0.2999999999999996}, {0.31286893008046174`, 
     1.9753766811902755`, -0.2999999999999996}, {0.31286893008046174`, 
     1.9753766811902755`, 4.440892098500626*^-16}, {0.6180339887498949, 
     1.902113032590307, 4.440892098500626*^-16}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (-1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       4.440892098500626*^-16}, {
      2 Sin[Rational[1, 20] Pi], 2 Cos[Rational[1, 20] Pi], 
       4.440892098500626*^-16}, {
      2 Sin[Rational[1, 20] Pi], 2 Cos[Rational[1, 20] Pi], 
       0.3000000000000005}, {
      Rational[1, 2] (-1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       0.3000000000000005}}, {{0.6180339887498949, 1.902113032590307, 
     4.440892098500626*^-16}, {0.31286893008046174`, 1.9753766811902755`, 
     4.440892098500626*^-16}, {0.31286893008046174`, 1.9753766811902755`, 
     0.3000000000000005}, {0.6180339887498949, 1.902113032590307, 
     0.3000000000000005}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (-1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       0.3000000000000005}, {
      2 Sin[Rational[1, 20] Pi], 2 Cos[Rational[1, 20] Pi], 
       0.3000000000000005}, {
      2 Sin[Rational[1, 20] Pi], 2 Cos[Rational[1, 20] Pi], 
       0.6000000000000005}, {
      Rational[1, 2] (-1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       0.6000000000000005}}, {{0.6180339887498949, 1.902113032590307, 
     0.3000000000000005}, {0.31286893008046174`, 1.9753766811902755`, 
     0.3000000000000005}, {0.31286893008046174`, 1.9753766811902755`, 
     0.6000000000000005}, {0.6180339887498949, 1.902113032590307, 
     0.6000000000000005}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (-1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       0.6000000000000005}, {
      2 Sin[Rational[1, 20] Pi], 2 Cos[Rational[1, 20] Pi], 
       0.6000000000000005}, {
      2 Sin[Rational[1, 20] Pi], 2 Cos[Rational[1, 20] Pi], 
       0.9000000000000006}, {
      Rational[1, 2] (-1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       0.9000000000000006}}, {{0.6180339887498949, 1.902113032590307, 
     0.6000000000000005}, {0.31286893008046174`, 1.9753766811902755`, 
     0.6000000000000005}, {0.31286893008046174`, 1.9753766811902755`, 
     0.9000000000000006}, {0.6180339887498949, 1.902113032590307, 
     0.9000000000000006}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (-1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       0.9000000000000006}, {
      2 Sin[Rational[1, 20] Pi], 2 Cos[Rational[1, 20] Pi], 
       0.9000000000000006}, {
      2 Sin[Rational[1, 20] Pi], 2 Cos[Rational[1, 20] Pi], 
       1.2000000000000006`}, {
      Rational[1, 2] (-1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       1.2000000000000006`}}, {{0.6180339887498949, 1.902113032590307, 
     0.9000000000000006}, {0.31286893008046174`, 1.9753766811902755`, 
     0.9000000000000006}, {0.31286893008046174`, 1.9753766811902755`, 
     1.2000000000000006`}, {0.6180339887498949, 1.902113032590307, 
     1.2000000000000006`}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (-1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       1.2000000000000006`}, {
      2 Sin[Rational[1, 20] Pi], 2 Cos[Rational[1, 20] Pi], 
       1.2000000000000006`}, {
      2 Sin[Rational[1, 20] Pi], 2 Cos[Rational[1, 20] Pi], 
       1.5000000000000007`}, {
      Rational[1, 2] (-1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       1.5000000000000007`}}, {{0.6180339887498949, 1.902113032590307, 
     1.2000000000000006`}, {0.31286893008046174`, 1.9753766811902755`, 
     1.2000000000000006`}, {0.31286893008046174`, 1.9753766811902755`, 
     1.5000000000000007`}, {0.6180339887498949, 1.902113032590307, 
     1.5000000000000007`}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (-1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       1.5000000000000007`}, {
      2 Sin[Rational[1, 20] Pi], 2 Cos[Rational[1, 20] Pi], 
       1.5000000000000007`}, {
      2 Sin[Rational[1, 20] Pi], 2 Cos[Rational[1, 20] Pi], 
       1.8000000000000007`}, {
      Rational[1, 2] (-1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       1.8000000000000007`}}, {{0.6180339887498949, 1.902113032590307, 
     1.5000000000000007`}, {0.31286893008046174`, 1.9753766811902755`, 
     1.5000000000000007`}, {0.31286893008046174`, 1.9753766811902755`, 
     1.8000000000000007`}, {0.6180339887498949, 1.902113032590307, 
     1.8000000000000007`}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (-1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       1.8000000000000007`}, {
      2 Sin[Rational[1, 20] Pi], 2 Cos[Rational[1, 20] Pi], 
       1.8000000000000007`}, {
      2 Sin[Rational[1, 20] Pi], 2 Cos[Rational[1, 20] Pi], 
       2.1000000000000005`}, {
      Rational[1, 2] (-1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       2.1000000000000005`}}, {{0.6180339887498949, 1.902113032590307, 
     1.8000000000000007`}, {0.31286893008046174`, 1.9753766811902755`, 
     1.8000000000000007`}, {0.31286893008046174`, 1.9753766811902755`, 
     2.1000000000000005`}, {0.6180339887498949, 1.902113032590307, 
     2.1000000000000005`}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (-1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       2.1000000000000005`}, {
      2 Sin[Rational[1, 20] Pi], 2 Cos[Rational[1, 20] Pi], 
       2.1000000000000005`}, {
      2 Sin[Rational[1, 20] Pi], 2 Cos[Rational[1, 20] Pi], 
       2.4000000000000004`}, {
      Rational[1, 2] (-1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       2.4000000000000004`}}, {{0.6180339887498949, 1.902113032590307, 
     2.1000000000000005`}, {0.31286893008046174`, 1.9753766811902755`, 
     2.1000000000000005`}, {0.31286893008046174`, 1.9753766811902755`, 
     2.4000000000000004`}, {0.6180339887498949, 1.902113032590307, 
     2.4000000000000004`}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (-1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       2.400000000000001}, {
      2 Sin[Rational[1, 20] Pi], 2 Cos[Rational[1, 20] Pi], 
       2.400000000000001}, {
      2 Sin[Rational[1, 20] Pi], 2 Cos[Rational[1, 20] Pi], 
       2.700000000000001}, {
      Rational[1, 2] (-1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       2.700000000000001}}, {{0.6180339887498949, 1.902113032590307, 
     2.400000000000001}, {0.31286893008046174`, 1.9753766811902755`, 
     2.400000000000001}, {0.31286893008046174`, 1.9753766811902755`, 
     2.700000000000001}, {0.6180339887498949, 1.902113032590307, 
     2.700000000000001}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (-1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       2.700000000000001}, {
      2 Sin[Rational[1, 20] Pi], 2 Cos[Rational[1, 20] Pi], 
       2.700000000000001}, {
      2 Sin[Rational[1, 20] Pi], 2 Cos[Rational[1, 20] Pi], 
       3.000000000000001}, {
      Rational[1, 2] (-1 + 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       3.000000000000001}}, {{0.6180339887498949, 1.902113032590307, 
     2.700000000000001}, {0.31286893008046174`, 1.9753766811902755`, 
     2.700000000000001}, {0.31286893008046174`, 1.9753766811902755`, 
     3.000000000000001}, {0.6180339887498949, 1.902113032590307, 
     3.000000000000001}}]], 
   Polygon3DBox[
    NCache[{{2 Sin[Rational[1, 20] Pi], 2 Cos[Rational[1, 20] Pi], -3.}, {
      0, 2, -3.}, {0, 2, -2.7}, {
      2 Sin[Rational[1, 20] Pi], 2 Cos[Rational[1, 20] Pi], -2.7}}, {{
      0.31286893008046174`, 1.9753766811902755`, -3.}, {0, 2, -3.}, {
      0, 2, -2.7}, {0.31286893008046174`, 1.9753766811902755`, -2.7}}]], 
   Polygon3DBox[
    NCache[{{2 Sin[Rational[1, 20] Pi], 2 Cos[Rational[1, 20] Pi], -2.7}, {
      0, 2, -2.7}, {0, 2, -2.4000000000000004`}, {
      2 Sin[Rational[1, 20] Pi], 2 
       Cos[Rational[1, 20] Pi], -2.4000000000000004`}}, {{
      0.31286893008046174`, 1.9753766811902755`, -2.7}, {0, 2, -2.7}, {
      0, 2, -2.4000000000000004`}, {0.31286893008046174`, 
      1.9753766811902755`, -2.4000000000000004`}}]], 
   Polygon3DBox[
    NCache[{{2 Sin[Rational[1, 20] Pi], 2 Cos[Rational[1, 20] Pi], -2.4}, {
      0, 2, -2.4}, {0, 2, -2.0999999999999996`}, {
      2 Sin[Rational[1, 20] Pi], 2 
       Cos[Rational[1, 20] Pi], -2.0999999999999996`}}, {{
      0.31286893008046174`, 1.9753766811902755`, -2.4}, {0, 2, -2.4}, {
      0, 2, -2.0999999999999996`}, {0.31286893008046174`, 
      1.9753766811902755`, -2.0999999999999996`}}]], 
   Polygon3DBox[
    NCache[{{2 Sin[Rational[1, 20] Pi], 2 
       Cos[Rational[1, 20] Pi], -2.0999999999999996`}, {
      0, 2, -2.0999999999999996`}, {0, 2, -1.7999999999999996`}, {
      2 Sin[Rational[1, 20] Pi], 2 
       Cos[Rational[1, 20] Pi], -1.7999999999999996`}}, {{
      0.31286893008046174`, 1.9753766811902755`, -2.0999999999999996`}, {
      0, 2, -2.0999999999999996`}, {0, 2, -1.7999999999999996`}, {
      0.31286893008046174`, 1.9753766811902755`, -1.7999999999999996`}}]], 
   Polygon3DBox[
    NCache[{{2 Sin[Rational[1, 20] Pi], 2 
       Cos[Rational[1, 20] Pi], -1.7999999999999998`}, {
      0, 2, -1.7999999999999998`}, {0, 2, -1.4999999999999998`}, {
      2 Sin[Rational[1, 20] Pi], 2 
       Cos[Rational[1, 20] Pi], -1.4999999999999998`}}, {{
      0.31286893008046174`, 1.9753766811902755`, -1.7999999999999998`}, {
      0, 2, -1.7999999999999998`}, {0, 2, -1.4999999999999998`}, {
      0.31286893008046174`, 1.9753766811902755`, -1.4999999999999998`}}]], 
   Polygon3DBox[
    NCache[{{2 Sin[Rational[1, 20] Pi], 2 
       Cos[Rational[1, 20] Pi], -1.4999999999999998`}, {
      0, 2, -1.4999999999999998`}, {0, 2, -1.1999999999999997`}, {
      2 Sin[Rational[1, 20] Pi], 2 
       Cos[Rational[1, 20] Pi], -1.1999999999999997`}}, {{
      0.31286893008046174`, 1.9753766811902755`, -1.4999999999999998`}, {
      0, 2, -1.4999999999999998`}, {0, 2, -1.1999999999999997`}, {
      0.31286893008046174`, 1.9753766811902755`, -1.1999999999999997`}}]], 
   Polygon3DBox[
    NCache[{{2 Sin[Rational[1, 20] Pi], 2 
       Cos[Rational[1, 20] Pi], -1.1999999999999997`}, {
      0, 2, -1.1999999999999997`}, {0, 2, -0.8999999999999997}, {
      2 Sin[Rational[1, 20] Pi], 2 
       Cos[Rational[1, 20] Pi], -0.8999999999999997}}, {{0.31286893008046174`,
       1.9753766811902755`, -1.1999999999999997`}, {
      0, 2, -1.1999999999999997`}, {0, 2, -0.8999999999999997}, {
      0.31286893008046174`, 1.9753766811902755`, -0.8999999999999997}}]], 
   Polygon3DBox[
    NCache[{{2 Sin[Rational[1, 20] Pi], 2 
       Cos[Rational[1, 20] Pi], -0.8999999999999997}, {
      0, 2, -0.8999999999999997}, {0, 2, -0.5999999999999996}, {
      2 Sin[Rational[1, 20] Pi], 2 
       Cos[Rational[1, 20] Pi], -0.5999999999999996}}, {{0.31286893008046174`,
       1.9753766811902755`, -0.8999999999999997}, {
      0, 2, -0.8999999999999997}, {0, 2, -0.5999999999999996}, {
      0.31286893008046174`, 1.9753766811902755`, -0.5999999999999996}}]], 
   Polygon3DBox[
    NCache[{{2 Sin[Rational[1, 20] Pi], 2 
       Cos[Rational[1, 20] Pi], -0.5999999999999996}, {
      0, 2, -0.5999999999999996}, {0, 2, -0.2999999999999996}, {
      2 Sin[Rational[1, 20] Pi], 2 
       Cos[Rational[1, 20] Pi], -0.2999999999999996}}, {{0.31286893008046174`,
       1.9753766811902755`, -0.5999999999999996}, {
      0, 2, -0.5999999999999996}, {0, 2, -0.2999999999999996}, {
      0.31286893008046174`, 1.9753766811902755`, -0.2999999999999996}}]], 
   Polygon3DBox[
    NCache[{{2 Sin[Rational[1, 20] Pi], 2 
       Cos[Rational[1, 20] Pi], -0.2999999999999996}, {
      0, 2, -0.2999999999999996}, {0, 2, 4.440892098500626*^-16}, {
      2 Sin[Rational[1, 20] Pi], 2 Cos[Rational[1, 20] Pi], 
       4.440892098500626*^-16}}, {{0.31286893008046174`, 
      1.9753766811902755`, -0.2999999999999996}, {
      0, 2, -0.2999999999999996}, {0, 2, 4.440892098500626*^-16}, {
      0.31286893008046174`, 1.9753766811902755`, 4.440892098500626*^-16}}]], 
   Polygon3DBox[
    NCache[{{2 Sin[Rational[1, 20] Pi], 2 Cos[Rational[1, 20] Pi], 
       4.440892098500626*^-16}, {0, 2, 4.440892098500626*^-16}, {
      0, 2, 0.3000000000000005}, {
      2 Sin[Rational[1, 20] Pi], 2 Cos[Rational[1, 20] Pi], 
       0.3000000000000005}}, {{0.31286893008046174`, 1.9753766811902755`, 
      4.440892098500626*^-16}, {0, 2, 4.440892098500626*^-16}, {
      0, 2, 0.3000000000000005}, {0.31286893008046174`, 1.9753766811902755`, 
      0.3000000000000005}}]], 
   Polygon3DBox[
    NCache[{{2 Sin[Rational[1, 20] Pi], 2 Cos[Rational[1, 20] Pi], 
       0.3000000000000005}, {0, 2, 0.3000000000000005}, {
      0, 2, 0.6000000000000005}, {
      2 Sin[Rational[1, 20] Pi], 2 Cos[Rational[1, 20] Pi], 
       0.6000000000000005}}, {{0.31286893008046174`, 1.9753766811902755`, 
      0.3000000000000005}, {0, 2, 0.3000000000000005}, {
      0, 2, 0.6000000000000005}, {0.31286893008046174`, 1.9753766811902755`, 
      0.6000000000000005}}]], 
   Polygon3DBox[
    NCache[{{2 Sin[Rational[1, 20] Pi], 2 Cos[Rational[1, 20] Pi], 
       0.6000000000000005}, {0, 2, 0.6000000000000005}, {
      0, 2, 0.9000000000000006}, {
      2 Sin[Rational[1, 20] Pi], 2 Cos[Rational[1, 20] Pi], 
       0.9000000000000006}}, {{0.31286893008046174`, 1.9753766811902755`, 
      0.6000000000000005}, {0, 2, 0.6000000000000005}, {
      0, 2, 0.9000000000000006}, {0.31286893008046174`, 1.9753766811902755`, 
      0.9000000000000006}}]], 
   Polygon3DBox[
    NCache[{{2 Sin[Rational[1, 20] Pi], 2 Cos[Rational[1, 20] Pi], 
       0.9000000000000006}, {0, 2, 0.9000000000000006}, {
      0, 2, 1.2000000000000006`}, {
      2 Sin[Rational[1, 20] Pi], 2 Cos[Rational[1, 20] Pi], 
       1.2000000000000006`}}, {{0.31286893008046174`, 1.9753766811902755`, 
      0.9000000000000006}, {0, 2, 0.9000000000000006}, {
      0, 2, 1.2000000000000006`}, {0.31286893008046174`, 1.9753766811902755`, 
      1.2000000000000006`}}]], 
   Polygon3DBox[
    NCache[{{2 Sin[Rational[1, 20] Pi], 2 Cos[Rational[1, 20] Pi], 
       1.2000000000000006`}, {0, 2, 1.2000000000000006`}, {
      0, 2, 1.5000000000000007`}, {
      2 Sin[Rational[1, 20] Pi], 2 Cos[Rational[1, 20] Pi], 
       1.5000000000000007`}}, {{0.31286893008046174`, 1.9753766811902755`, 
      1.2000000000000006`}, {0, 2, 1.2000000000000006`}, {
      0, 2, 1.5000000000000007`}, {0.31286893008046174`, 1.9753766811902755`, 
      1.5000000000000007`}}]], 
   Polygon3DBox[
    NCache[{{2 Sin[Rational[1, 20] Pi], 2 Cos[Rational[1, 20] Pi], 
       1.5000000000000007`}, {0, 2, 1.5000000000000007`}, {
      0, 2, 1.8000000000000007`}, {
      2 Sin[Rational[1, 20] Pi], 2 Cos[Rational[1, 20] Pi], 
       1.8000000000000007`}}, {{0.31286893008046174`, 1.9753766811902755`, 
      1.5000000000000007`}, {0, 2, 1.5000000000000007`}, {
      0, 2, 1.8000000000000007`}, {0.31286893008046174`, 1.9753766811902755`, 
      1.8000000000000007`}}]], 
   Polygon3DBox[
    NCache[{{2 Sin[Rational[1, 20] Pi], 2 Cos[Rational[1, 20] Pi], 
       1.8000000000000007`}, {0, 2, 1.8000000000000007`}, {
      0, 2, 2.1000000000000005`}, {
      2 Sin[Rational[1, 20] Pi], 2 Cos[Rational[1, 20] Pi], 
       2.1000000000000005`}}, {{0.31286893008046174`, 1.9753766811902755`, 
      1.8000000000000007`}, {0, 2, 1.8000000000000007`}, {
      0, 2, 2.1000000000000005`}, {0.31286893008046174`, 1.9753766811902755`, 
      2.1000000000000005`}}]], 
   Polygon3DBox[
    NCache[{{2 Sin[Rational[1, 20] Pi], 2 Cos[Rational[1, 20] Pi], 
       2.1000000000000005`}, {0, 2, 2.1000000000000005`}, {
      0, 2, 2.4000000000000004`}, {
      2 Sin[Rational[1, 20] Pi], 2 Cos[Rational[1, 20] Pi], 
       2.4000000000000004`}}, {{0.31286893008046174`, 1.9753766811902755`, 
      2.1000000000000005`}, {0, 2, 2.1000000000000005`}, {
      0, 2, 2.4000000000000004`}, {0.31286893008046174`, 1.9753766811902755`, 
      2.4000000000000004`}}]], 
   Polygon3DBox[
    NCache[{{2 Sin[Rational[1, 20] Pi], 2 Cos[Rational[1, 20] Pi], 
       2.400000000000001}, {0, 2, 2.400000000000001}, {
      0, 2, 2.700000000000001}, {
      2 Sin[Rational[1, 20] Pi], 2 Cos[Rational[1, 20] Pi], 
       2.700000000000001}}, {{0.31286893008046174`, 1.9753766811902755`, 
      2.400000000000001}, {0, 2, 2.400000000000001}, {
      0, 2, 2.700000000000001}, {0.31286893008046174`, 1.9753766811902755`, 
      2.700000000000001}}]], 
   Polygon3DBox[
    NCache[{{2 Sin[Rational[1, 20] Pi], 2 Cos[Rational[1, 20] Pi], 
       2.700000000000001}, {0, 2, 2.700000000000001}, {
      0, 2, 3.000000000000001}, {
      2 Sin[Rational[1, 20] Pi], 2 Cos[Rational[1, 20] Pi], 
       3.000000000000001}}, {{0.31286893008046174`, 1.9753766811902755`, 
      2.700000000000001}, {0, 2, 2.700000000000001}, {
      0, 2, 3.000000000000001}, {0.31286893008046174`, 1.9753766811902755`, 
      3.000000000000001}}]], 
   Polygon3DBox[
    NCache[{{0, 2, -3.}, {(-2) Sin[Rational[1, 20] Pi], 2 
       Cos[Rational[1, 20] Pi], -3.}, {(-2) Sin[Rational[1, 20] Pi], 2 
       Cos[Rational[1, 20] Pi], -2.7}, {0, 2, -2.7}}, {{
      0, 2, -3.}, {-0.31286893008046174`, 
      1.9753766811902755`, -3.}, {-0.31286893008046174`, 
      1.9753766811902755`, -2.7}, {0, 2, -2.7}}]], 
   Polygon3DBox[
    NCache[{{0, 2, -2.7}, {(-2) Sin[Rational[1, 20] Pi], 2 
       Cos[Rational[1, 20] Pi], -2.7}, {(-2) Sin[Rational[1, 20] Pi], 2 
       Cos[Rational[1, 20] Pi], -2.4000000000000004`}, {
      0, 2, -2.4000000000000004`}}, {{0, 2, -2.7}, {-0.31286893008046174`, 
      1.9753766811902755`, -2.7}, {-0.31286893008046174`, 
      1.9753766811902755`, -2.4000000000000004`}, {
      0, 2, -2.4000000000000004`}}]], 
   Polygon3DBox[
    NCache[{{0, 2, -2.4}, {(-2) Sin[Rational[1, 20] Pi], 2 
       Cos[Rational[1, 20] Pi], -2.4}, {(-2) Sin[Rational[1, 20] Pi], 2 
       Cos[Rational[1, 20] Pi], -2.0999999999999996`}, {
      0, 2, -2.0999999999999996`}}, {{0, 2, -2.4}, {-0.31286893008046174`, 
      1.9753766811902755`, -2.4}, {-0.31286893008046174`, 
      1.9753766811902755`, -2.0999999999999996`}, {
      0, 2, -2.0999999999999996`}}]], 
   Polygon3DBox[
    NCache[{{0, 2, -2.0999999999999996`}, {(-2) Sin[Rational[1, 20] Pi], 2 
       Cos[Rational[1, 20] Pi], -2.0999999999999996`}, {(-2) 
       Sin[Rational[1, 20] Pi], 2 
       Cos[Rational[1, 20] Pi], -1.7999999999999996`}, {
      0, 2, -1.7999999999999996`}}, {{
      0, 2, -2.0999999999999996`}, {-0.31286893008046174`, 
      1.9753766811902755`, -2.0999999999999996`}, {-0.31286893008046174`, 
      1.9753766811902755`, -1.7999999999999996`}, {
      0, 2, -1.7999999999999996`}}]], 
   Polygon3DBox[
    NCache[{{0, 2, -1.7999999999999998`}, {(-2) Sin[Rational[1, 20] Pi], 2 
       Cos[Rational[1, 20] Pi], -1.7999999999999998`}, {(-2) 
       Sin[Rational[1, 20] Pi], 2 
       Cos[Rational[1, 20] Pi], -1.4999999999999998`}, {
      0, 2, -1.4999999999999998`}}, {{
      0, 2, -1.7999999999999998`}, {-0.31286893008046174`, 
      1.9753766811902755`, -1.7999999999999998`}, {-0.31286893008046174`, 
      1.9753766811902755`, -1.4999999999999998`}, {
      0, 2, -1.4999999999999998`}}]], 
   Polygon3DBox[
    NCache[{{0, 2, -1.4999999999999998`}, {(-2) Sin[Rational[1, 20] Pi], 2 
       Cos[Rational[1, 20] Pi], -1.4999999999999998`}, {(-2) 
       Sin[Rational[1, 20] Pi], 2 
       Cos[Rational[1, 20] Pi], -1.1999999999999997`}, {
      0, 2, -1.1999999999999997`}}, {{
      0, 2, -1.4999999999999998`}, {-0.31286893008046174`, 
      1.9753766811902755`, -1.4999999999999998`}, {-0.31286893008046174`, 
      1.9753766811902755`, -1.1999999999999997`}, {
      0, 2, -1.1999999999999997`}}]], 
   Polygon3DBox[
    NCache[{{0, 2, -1.1999999999999997`}, {(-2) Sin[Rational[1, 20] Pi], 2 
       Cos[Rational[1, 20] Pi], -1.1999999999999997`}, {(-2) 
       Sin[Rational[1, 20] Pi], 2 
       Cos[Rational[1, 20] Pi], -0.8999999999999997}, {
      0, 2, -0.8999999999999997}}, {{
      0, 2, -1.1999999999999997`}, {-0.31286893008046174`, 
      1.9753766811902755`, -1.1999999999999997`}, {-0.31286893008046174`, 
      1.9753766811902755`, -0.8999999999999997}, {
      0, 2, -0.8999999999999997}}]], 
   Polygon3DBox[
    NCache[{{0, 2, -0.8999999999999997}, {(-2) Sin[Rational[1, 20] Pi], 2 
       Cos[Rational[1, 20] Pi], -0.8999999999999997}, {(-2) 
       Sin[Rational[1, 20] Pi], 2 
       Cos[Rational[1, 20] Pi], -0.5999999999999996}, {
      0, 2, -0.5999999999999996}}, {{
      0, 2, -0.8999999999999997}, {-0.31286893008046174`, 
      1.9753766811902755`, -0.8999999999999997}, {-0.31286893008046174`, 
      1.9753766811902755`, -0.5999999999999996}, {
      0, 2, -0.5999999999999996}}]], 
   Polygon3DBox[
    NCache[{{0, 2, -0.5999999999999996}, {(-2) Sin[Rational[1, 20] Pi], 2 
       Cos[Rational[1, 20] Pi], -0.5999999999999996}, {(-2) 
       Sin[Rational[1, 20] Pi], 2 
       Cos[Rational[1, 20] Pi], -0.2999999999999996}, {
      0, 2, -0.2999999999999996}}, {{
      0, 2, -0.5999999999999996}, {-0.31286893008046174`, 
      1.9753766811902755`, -0.5999999999999996}, {-0.31286893008046174`, 
      1.9753766811902755`, -0.2999999999999996}, {
      0, 2, -0.2999999999999996}}]], 
   Polygon3DBox[
    NCache[{{0, 2, -0.2999999999999996}, {(-2) Sin[Rational[1, 20] Pi], 2 
       Cos[Rational[1, 20] Pi], -0.2999999999999996}, {(-2) 
       Sin[Rational[1, 20] Pi], 2 Cos[Rational[1, 20] Pi], 
       4.440892098500626*^-16}, {0, 2, 4.440892098500626*^-16}}, {{
      0, 2, -0.2999999999999996}, {-0.31286893008046174`, 
      1.9753766811902755`, -0.2999999999999996}, {-0.31286893008046174`, 
      1.9753766811902755`, 4.440892098500626*^-16}, {
      0, 2, 4.440892098500626*^-16}}]], 
   Polygon3DBox[
    NCache[{{0, 2, 4.440892098500626*^-16}, {(-2) Sin[Rational[1, 20] Pi], 2 
       Cos[Rational[1, 20] Pi], 4.440892098500626*^-16}, {(-2) 
       Sin[Rational[1, 20] Pi], 2 Cos[Rational[1, 20] Pi], 
       0.3000000000000005}, {0, 2, 0.3000000000000005}}, {{
      0, 2, 4.440892098500626*^-16}, {-0.31286893008046174`, 
      1.9753766811902755`, 4.440892098500626*^-16}, {-0.31286893008046174`, 
      1.9753766811902755`, 0.3000000000000005}, {0, 2, 0.3000000000000005}}]],
    Polygon3DBox[
    NCache[{{0, 2, 0.3000000000000005}, {(-2) Sin[Rational[1, 20] Pi], 2 
       Cos[Rational[1, 20] Pi], 0.3000000000000005}, {(-2) 
       Sin[Rational[1, 20] Pi], 2 Cos[Rational[1, 20] Pi], 
       0.6000000000000005}, {0, 2, 0.6000000000000005}}, {{
      0, 2, 0.3000000000000005}, {-0.31286893008046174`, 1.9753766811902755`, 
      0.3000000000000005}, {-0.31286893008046174`, 1.9753766811902755`, 
      0.6000000000000005}, {0, 2, 0.6000000000000005}}]], 
   Polygon3DBox[
    NCache[{{0, 2, 0.6000000000000005}, {(-2) Sin[Rational[1, 20] Pi], 2 
       Cos[Rational[1, 20] Pi], 0.6000000000000005}, {(-2) 
       Sin[Rational[1, 20] Pi], 2 Cos[Rational[1, 20] Pi], 
       0.9000000000000006}, {0, 2, 0.9000000000000006}}, {{
      0, 2, 0.6000000000000005}, {-0.31286893008046174`, 1.9753766811902755`, 
      0.6000000000000005}, {-0.31286893008046174`, 1.9753766811902755`, 
      0.9000000000000006}, {0, 2, 0.9000000000000006}}]], 
   Polygon3DBox[
    NCache[{{0, 2, 0.9000000000000006}, {(-2) Sin[Rational[1, 20] Pi], 2 
       Cos[Rational[1, 20] Pi], 0.9000000000000006}, {(-2) 
       Sin[Rational[1, 20] Pi], 2 Cos[Rational[1, 20] Pi], 
       1.2000000000000006`}, {0, 2, 1.2000000000000006`}}, {{
      0, 2, 0.9000000000000006}, {-0.31286893008046174`, 1.9753766811902755`, 
      0.9000000000000006}, {-0.31286893008046174`, 1.9753766811902755`, 
      1.2000000000000006`}, {0, 2, 1.2000000000000006`}}]], 
   Polygon3DBox[
    NCache[{{0, 2, 1.2000000000000006`}, {(-2) Sin[Rational[1, 20] Pi], 2 
       Cos[Rational[1, 20] Pi], 1.2000000000000006`}, {(-2) 
       Sin[Rational[1, 20] Pi], 2 Cos[Rational[1, 20] Pi], 
       1.5000000000000007`}, {0, 2, 1.5000000000000007`}}, {{
      0, 2, 1.2000000000000006`}, {-0.31286893008046174`, 1.9753766811902755`,
       1.2000000000000006`}, {-0.31286893008046174`, 1.9753766811902755`, 
      1.5000000000000007`}, {0, 2, 1.5000000000000007`}}]], 
   Polygon3DBox[
    NCache[{{0, 2, 1.5000000000000007`}, {(-2) Sin[Rational[1, 20] Pi], 2 
       Cos[Rational[1, 20] Pi], 1.5000000000000007`}, {(-2) 
       Sin[Rational[1, 20] Pi], 2 Cos[Rational[1, 20] Pi], 
       1.8000000000000007`}, {0, 2, 1.8000000000000007`}}, {{
      0, 2, 1.5000000000000007`}, {-0.31286893008046174`, 1.9753766811902755`,
       1.5000000000000007`}, {-0.31286893008046174`, 1.9753766811902755`, 
      1.8000000000000007`}, {0, 2, 1.8000000000000007`}}]], 
   Polygon3DBox[
    NCache[{{0, 2, 1.8000000000000007`}, {(-2) Sin[Rational[1, 20] Pi], 2 
       Cos[Rational[1, 20] Pi], 1.8000000000000007`}, {(-2) 
       Sin[Rational[1, 20] Pi], 2 Cos[Rational[1, 20] Pi], 
       2.1000000000000005`}, {0, 2, 2.1000000000000005`}}, {{
      0, 2, 1.8000000000000007`}, {-0.31286893008046174`, 1.9753766811902755`,
       1.8000000000000007`}, {-0.31286893008046174`, 1.9753766811902755`, 
      2.1000000000000005`}, {0, 2, 2.1000000000000005`}}]], 
   Polygon3DBox[
    NCache[{{0, 2, 2.1000000000000005`}, {(-2) Sin[Rational[1, 20] Pi], 2 
       Cos[Rational[1, 20] Pi], 2.1000000000000005`}, {(-2) 
       Sin[Rational[1, 20] Pi], 2 Cos[Rational[1, 20] Pi], 
       2.4000000000000004`}, {0, 2, 2.4000000000000004`}}, {{
      0, 2, 2.1000000000000005`}, {-0.31286893008046174`, 1.9753766811902755`,
       2.1000000000000005`}, {-0.31286893008046174`, 1.9753766811902755`, 
      2.4000000000000004`}, {0, 2, 2.4000000000000004`}}]], 
   Polygon3DBox[
    NCache[{{0, 2, 2.400000000000001}, {(-2) Sin[Rational[1, 20] Pi], 2 
       Cos[Rational[1, 20] Pi], 2.400000000000001}, {(-2) 
       Sin[Rational[1, 20] Pi], 2 Cos[Rational[1, 20] Pi], 
       2.700000000000001}, {0, 2, 2.700000000000001}}, {{
      0, 2, 2.400000000000001}, {-0.31286893008046174`, 1.9753766811902755`, 
      2.400000000000001}, {-0.31286893008046174`, 1.9753766811902755`, 
      2.700000000000001}, {0, 2, 2.700000000000001}}]], 
   Polygon3DBox[
    NCache[{{0, 2, 2.700000000000001}, {(-2) Sin[Rational[1, 20] Pi], 2 
       Cos[Rational[1, 20] Pi], 2.700000000000001}, {(-2) 
       Sin[Rational[1, 20] Pi], 2 Cos[Rational[1, 20] Pi], 
       3.000000000000001}, {0, 2, 3.000000000000001}}, {{
      0, 2, 2.700000000000001}, {-0.31286893008046174`, 1.9753766811902755`, 
      2.700000000000001}, {-0.31286893008046174`, 1.9753766811902755`, 
      3.000000000000001}, {0, 2, 3.000000000000001}}]], 
   Polygon3DBox[
    NCache[{{(-2) Sin[Rational[1, 20] Pi], 2 Cos[Rational[1, 20] Pi], -3.}, {
      Rational[1, 2] (1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -3.}, {
      Rational[1, 2] (1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -2.7}, {(-2) Sin[Rational[1, 20] Pi], 2 
       Cos[Rational[1, 20] Pi], -2.7}}, {{-0.31286893008046174`, 
     1.9753766811902755`, -3.}, {-0.6180339887498949, 
     1.902113032590307, -3.}, {-0.6180339887498949, 
     1.902113032590307, -2.7}, {-0.31286893008046174`, 
     1.9753766811902755`, -2.7}}]], 
   Polygon3DBox[
    NCache[{{(-2) Sin[Rational[1, 20] Pi], 2 Cos[Rational[1, 20] Pi], -2.7}, {
      Rational[1, 2] (1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -2.7}, {
      Rational[1, 2] (1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -2.4000000000000004`}, {(-2) Sin[Rational[1, 20] Pi], 
       2 Cos[Rational[1, 20] 
         Pi], -2.4000000000000004`}}, {{-0.31286893008046174`, 
     1.9753766811902755`, -2.7}, {-0.6180339887498949, 
     1.902113032590307, -2.7}, {-0.6180339887498949, 
     1.902113032590307, -2.4000000000000004`}, {-0.31286893008046174`, 
     1.9753766811902755`, -2.4000000000000004`}}]], 
   Polygon3DBox[
    NCache[{{(-2) Sin[Rational[1, 20] Pi], 2 Cos[Rational[1, 20] Pi], -2.4}, {
      Rational[1, 2] (1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -2.4}, {
      Rational[1, 2] (1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -2.0999999999999996`}, {(-2) Sin[Rational[1, 20] Pi], 
       2 Cos[Rational[1, 20] 
         Pi], -2.0999999999999996`}}, {{-0.31286893008046174`, 
     1.9753766811902755`, -2.4}, {-0.6180339887498949, 
     1.902113032590307, -2.4}, {-0.6180339887498949, 
     1.902113032590307, -2.0999999999999996`}, {-0.31286893008046174`, 
     1.9753766811902755`, -2.0999999999999996`}}]], 
   Polygon3DBox[
    NCache[{{(-2) Sin[Rational[1, 20] Pi], 2 
       Cos[Rational[1, 20] Pi], -2.0999999999999996`}, {
      Rational[1, 2] (1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -2.0999999999999996`}, {
      Rational[1, 2] (1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -1.7999999999999996`}, {(-2) Sin[Rational[1, 20] Pi], 
       2 Cos[Rational[1, 20] 
         Pi], -1.7999999999999996`}}, {{-0.31286893008046174`, 
     1.9753766811902755`, -2.0999999999999996`}, {-0.6180339887498949, 
     1.902113032590307, -2.0999999999999996`}, {-0.6180339887498949, 
     1.902113032590307, -1.7999999999999996`}, {-0.31286893008046174`, 
     1.9753766811902755`, -1.7999999999999996`}}]], 
   Polygon3DBox[
    NCache[{{(-2) Sin[Rational[1, 20] Pi], 2 
       Cos[Rational[1, 20] Pi], -1.7999999999999998`}, {
      Rational[1, 2] (1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -1.7999999999999998`}, {
      Rational[1, 2] (1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -1.4999999999999998`}, {(-2) Sin[Rational[1, 20] Pi], 
       2 Cos[Rational[1, 20] 
         Pi], -1.4999999999999998`}}, {{-0.31286893008046174`, 
     1.9753766811902755`, -1.7999999999999998`}, {-0.6180339887498949, 
     1.902113032590307, -1.7999999999999998`}, {-0.6180339887498949, 
     1.902113032590307, -1.4999999999999998`}, {-0.31286893008046174`, 
     1.9753766811902755`, -1.4999999999999998`}}]], 
   Polygon3DBox[
    NCache[{{(-2) Sin[Rational[1, 20] Pi], 2 
       Cos[Rational[1, 20] Pi], -1.4999999999999998`}, {
      Rational[1, 2] (1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -1.4999999999999998`}, {
      Rational[1, 2] (1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -1.1999999999999997`}, {(-2) Sin[Rational[1, 20] Pi], 
       2 Cos[Rational[1, 20] 
         Pi], -1.1999999999999997`}}, {{-0.31286893008046174`, 
     1.9753766811902755`, -1.4999999999999998`}, {-0.6180339887498949, 
     1.902113032590307, -1.4999999999999998`}, {-0.6180339887498949, 
     1.902113032590307, -1.1999999999999997`}, {-0.31286893008046174`, 
     1.9753766811902755`, -1.1999999999999997`}}]], 
   Polygon3DBox[
    NCache[{{(-2) Sin[Rational[1, 20] Pi], 2 
       Cos[Rational[1, 20] Pi], -1.1999999999999997`}, {
      Rational[1, 2] (1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -1.1999999999999997`}, {
      Rational[1, 2] (1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -0.8999999999999997}, {(-2) Sin[Rational[1, 20] Pi], 
       2 Cos[Rational[1, 20] 
         Pi], -0.8999999999999997}}, {{-0.31286893008046174`, 
     1.9753766811902755`, -1.1999999999999997`}, {-0.6180339887498949, 
     1.902113032590307, -1.1999999999999997`}, {-0.6180339887498949, 
     1.902113032590307, -0.8999999999999997}, {-0.31286893008046174`, 
     1.9753766811902755`, -0.8999999999999997}}]], 
   Polygon3DBox[
    NCache[{{(-2) Sin[Rational[1, 20] Pi], 2 
       Cos[Rational[1, 20] Pi], -0.8999999999999997}, {
      Rational[1, 2] (1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -0.8999999999999997}, {
      Rational[1, 2] (1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -0.5999999999999996}, {(-2) Sin[Rational[1, 20] Pi], 
       2 Cos[Rational[1, 20] 
         Pi], -0.5999999999999996}}, {{-0.31286893008046174`, 
     1.9753766811902755`, -0.8999999999999997}, {-0.6180339887498949, 
     1.902113032590307, -0.8999999999999997}, {-0.6180339887498949, 
     1.902113032590307, -0.5999999999999996}, {-0.31286893008046174`, 
     1.9753766811902755`, -0.5999999999999996}}]], 
   Polygon3DBox[
    NCache[{{(-2) Sin[Rational[1, 20] Pi], 2 
       Cos[Rational[1, 20] Pi], -0.5999999999999996}, {
      Rational[1, 2] (1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -0.5999999999999996}, {
      Rational[1, 2] (1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -0.2999999999999996}, {(-2) Sin[Rational[1, 20] Pi], 
       2 Cos[Rational[1, 20] 
         Pi], -0.2999999999999996}}, {{-0.31286893008046174`, 
     1.9753766811902755`, -0.5999999999999996}, {-0.6180339887498949, 
     1.902113032590307, -0.5999999999999996}, {-0.6180339887498949, 
     1.902113032590307, -0.2999999999999996}, {-0.31286893008046174`, 
     1.9753766811902755`, -0.2999999999999996}}]], 
   Polygon3DBox[
    NCache[{{(-2) Sin[Rational[1, 20] Pi], 2 
       Cos[Rational[1, 20] Pi], -0.2999999999999996}, {
      Rational[1, 2] (1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -0.2999999999999996}, {
      Rational[1, 2] (1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       4.440892098500626*^-16}, {(-2) Sin[Rational[1, 20] Pi], 2 
       Cos[Rational[1, 20] Pi], 
       4.440892098500626*^-16}}, {{-0.31286893008046174`, 
     1.9753766811902755`, -0.2999999999999996}, {-0.6180339887498949, 
     1.902113032590307, -0.2999999999999996}, {-0.6180339887498949, 
     1.902113032590307, 4.440892098500626*^-16}, {-0.31286893008046174`, 
     1.9753766811902755`, 4.440892098500626*^-16}}]], 
   Polygon3DBox[
    NCache[{{(-2) Sin[Rational[1, 20] Pi], 2 Cos[Rational[1, 20] Pi], 
       4.440892098500626*^-16}, {
      Rational[1, 2] (1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       4.440892098500626*^-16}, {
      Rational[1, 2] (1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       0.3000000000000005}, {(-2) Sin[Rational[1, 20] Pi], 2 
       Cos[Rational[1, 20] Pi], 0.3000000000000005}}, {{-0.31286893008046174`,
      1.9753766811902755`, 4.440892098500626*^-16}, {-0.6180339887498949, 
     1.902113032590307, 4.440892098500626*^-16}, {-0.6180339887498949, 
     1.902113032590307, 0.3000000000000005}, {-0.31286893008046174`, 
     1.9753766811902755`, 0.3000000000000005}}]], 
   Polygon3DBox[
    NCache[{{(-2) Sin[Rational[1, 20] Pi], 2 Cos[Rational[1, 20] Pi], 
       0.3000000000000005}, {
      Rational[1, 2] (1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       0.3000000000000005}, {
      Rational[1, 2] (1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       0.6000000000000005}, {(-2) Sin[Rational[1, 20] Pi], 2 
       Cos[Rational[1, 20] Pi], 0.6000000000000005}}, {{-0.31286893008046174`,
      1.9753766811902755`, 0.3000000000000005}, {-0.6180339887498949, 
     1.902113032590307, 0.3000000000000005}, {-0.6180339887498949, 
     1.902113032590307, 0.6000000000000005}, {-0.31286893008046174`, 
     1.9753766811902755`, 0.6000000000000005}}]], 
   Polygon3DBox[
    NCache[{{(-2) Sin[Rational[1, 20] Pi], 2 Cos[Rational[1, 20] Pi], 
       0.6000000000000005}, {
      Rational[1, 2] (1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       0.6000000000000005}, {
      Rational[1, 2] (1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       0.9000000000000006}, {(-2) Sin[Rational[1, 20] Pi], 2 
       Cos[Rational[1, 20] Pi], 0.9000000000000006}}, {{-0.31286893008046174`,
      1.9753766811902755`, 0.6000000000000005}, {-0.6180339887498949, 
     1.902113032590307, 0.6000000000000005}, {-0.6180339887498949, 
     1.902113032590307, 0.9000000000000006}, {-0.31286893008046174`, 
     1.9753766811902755`, 0.9000000000000006}}]], 
   Polygon3DBox[
    NCache[{{(-2) Sin[Rational[1, 20] Pi], 2 Cos[Rational[1, 20] Pi], 
       0.9000000000000006}, {
      Rational[1, 2] (1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       0.9000000000000006}, {
      Rational[1, 2] (1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       1.2000000000000006`}, {(-2) Sin[Rational[1, 20] Pi], 2 
       Cos[Rational[1, 20] Pi], 
       1.2000000000000006`}}, {{-0.31286893008046174`, 1.9753766811902755`, 
     0.9000000000000006}, {-0.6180339887498949, 1.902113032590307, 
     0.9000000000000006}, {-0.6180339887498949, 1.902113032590307, 
     1.2000000000000006`}, {-0.31286893008046174`, 1.9753766811902755`, 
     1.2000000000000006`}}]], 
   Polygon3DBox[
    NCache[{{(-2) Sin[Rational[1, 20] Pi], 2 Cos[Rational[1, 20] Pi], 
       1.2000000000000006`}, {
      Rational[1, 2] (1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       1.2000000000000006`}, {
      Rational[1, 2] (1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       1.5000000000000007`}, {(-2) Sin[Rational[1, 20] Pi], 2 
       Cos[Rational[1, 20] Pi], 
       1.5000000000000007`}}, {{-0.31286893008046174`, 1.9753766811902755`, 
     1.2000000000000006`}, {-0.6180339887498949, 1.902113032590307, 
     1.2000000000000006`}, {-0.6180339887498949, 1.902113032590307, 
     1.5000000000000007`}, {-0.31286893008046174`, 1.9753766811902755`, 
     1.5000000000000007`}}]], 
   Polygon3DBox[
    NCache[{{(-2) Sin[Rational[1, 20] Pi], 2 Cos[Rational[1, 20] Pi], 
       1.5000000000000007`}, {
      Rational[1, 2] (1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       1.5000000000000007`}, {
      Rational[1, 2] (1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       1.8000000000000007`}, {(-2) Sin[Rational[1, 20] Pi], 2 
       Cos[Rational[1, 20] Pi], 
       1.8000000000000007`}}, {{-0.31286893008046174`, 1.9753766811902755`, 
     1.5000000000000007`}, {-0.6180339887498949, 1.902113032590307, 
     1.5000000000000007`}, {-0.6180339887498949, 1.902113032590307, 
     1.8000000000000007`}, {-0.31286893008046174`, 1.9753766811902755`, 
     1.8000000000000007`}}]], 
   Polygon3DBox[
    NCache[{{(-2) Sin[Rational[1, 20] Pi], 2 Cos[Rational[1, 20] Pi], 
       1.8000000000000007`}, {
      Rational[1, 2] (1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       1.8000000000000007`}, {
      Rational[1, 2] (1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       2.1000000000000005`}, {(-2) Sin[Rational[1, 20] Pi], 2 
       Cos[Rational[1, 20] Pi], 
       2.1000000000000005`}}, {{-0.31286893008046174`, 1.9753766811902755`, 
     1.8000000000000007`}, {-0.6180339887498949, 1.902113032590307, 
     1.8000000000000007`}, {-0.6180339887498949, 1.902113032590307, 
     2.1000000000000005`}, {-0.31286893008046174`, 1.9753766811902755`, 
     2.1000000000000005`}}]], 
   Polygon3DBox[
    NCache[{{(-2) Sin[Rational[1, 20] Pi], 2 Cos[Rational[1, 20] Pi], 
       2.1000000000000005`}, {
      Rational[1, 2] (1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       2.1000000000000005`}, {
      Rational[1, 2] (1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       2.4000000000000004`}, {(-2) Sin[Rational[1, 20] Pi], 2 
       Cos[Rational[1, 20] Pi], 
       2.4000000000000004`}}, {{-0.31286893008046174`, 1.9753766811902755`, 
     2.1000000000000005`}, {-0.6180339887498949, 1.902113032590307, 
     2.1000000000000005`}, {-0.6180339887498949, 1.902113032590307, 
     2.4000000000000004`}, {-0.31286893008046174`, 1.9753766811902755`, 
     2.4000000000000004`}}]], 
   Polygon3DBox[
    NCache[{{(-2) Sin[Rational[1, 20] Pi], 2 Cos[Rational[1, 20] Pi], 
       2.400000000000001}, {
      Rational[1, 2] (1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       2.400000000000001}, {
      Rational[1, 2] (1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       2.700000000000001}, {(-2) Sin[Rational[1, 20] Pi], 2 
       Cos[Rational[1, 20] Pi], 2.700000000000001}}, {{-0.31286893008046174`, 
     1.9753766811902755`, 2.400000000000001}, {-0.6180339887498949, 
     1.902113032590307, 2.400000000000001}, {-0.6180339887498949, 
     1.902113032590307, 2.700000000000001}, {-0.31286893008046174`, 
     1.9753766811902755`, 2.700000000000001}}]], 
   Polygon3DBox[
    NCache[{{(-2) Sin[Rational[1, 20] Pi], 2 Cos[Rational[1, 20] Pi], 
       2.700000000000001}, {
      Rational[1, 2] (1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       2.700000000000001}, {
      Rational[1, 2] (1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       3.000000000000001}, {(-2) Sin[Rational[1, 20] Pi], 2 
       Cos[Rational[1, 20] Pi], 3.000000000000001}}, {{-0.31286893008046174`, 
     1.9753766811902755`, 2.700000000000001}, {-0.6180339887498949, 
     1.902113032590307, 2.700000000000001}, {-0.6180339887498949, 
     1.902113032590307, 3.000000000000001}, {-0.31286893008046174`, 
     1.9753766811902755`, 3.000000000000001}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -3.}, {(-2) Sin[Rational[3, 20] Pi], 2 
       Cos[Rational[3, 20] Pi], -3.}, {(-2) Sin[Rational[3, 20] Pi], 2 
       Cos[Rational[3, 20] Pi], -2.7}, {
      Rational[1, 2] (1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -2.7}}, {{-0.6180339887498949, 
     1.902113032590307, -3.}, {-0.9079809994790936, 
     1.7820130483767358`, -3.}, {-0.9079809994790936, 
     1.7820130483767358`, -2.7}, {-0.6180339887498949, 
     1.902113032590307, -2.7}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -2.7}, {(-2) Sin[Rational[3, 20] Pi], 2 
       Cos[Rational[3, 20] Pi], -2.7}, {(-2) Sin[Rational[3, 20] Pi], 2 
       Cos[Rational[3, 20] Pi], -2.4000000000000004`}, {
      Rational[1, 2] (1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -2.4000000000000004`}}, {{-0.6180339887498949, 
     1.902113032590307, -2.7}, {-0.9079809994790936, 
     1.7820130483767358`, -2.7}, {-0.9079809994790936, 
     1.7820130483767358`, -2.4000000000000004`}, {-0.6180339887498949, 
     1.902113032590307, -2.4000000000000004`}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -2.4}, {(-2) Sin[Rational[3, 20] Pi], 2 
       Cos[Rational[3, 20] Pi], -2.4}, {(-2) Sin[Rational[3, 20] Pi], 2 
       Cos[Rational[3, 20] Pi], -2.0999999999999996`}, {
      Rational[1, 2] (1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -2.0999999999999996`}}, {{-0.6180339887498949, 
     1.902113032590307, -2.4}, {-0.9079809994790936, 
     1.7820130483767358`, -2.4}, {-0.9079809994790936, 
     1.7820130483767358`, -2.0999999999999996`}, {-0.6180339887498949, 
     1.902113032590307, -2.0999999999999996`}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -2.0999999999999996`}, {(-2) Sin[Rational[3, 20] Pi], 
       2 Cos[Rational[3, 20] Pi], -2.0999999999999996`}, {(-2) 
       Sin[Rational[3, 20] Pi], 2 
       Cos[Rational[3, 20] Pi], -1.7999999999999996`}, {
      Rational[1, 2] (1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -1.7999999999999996`}}, {{-0.6180339887498949, 
     1.902113032590307, -2.0999999999999996`}, {-0.9079809994790936, 
     1.7820130483767358`, -2.0999999999999996`}, {-0.9079809994790936, 
     1.7820130483767358`, -1.7999999999999996`}, {-0.6180339887498949, 
     1.902113032590307, -1.7999999999999996`}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -1.7999999999999998`}, {(-2) Sin[Rational[3, 20] Pi], 
       2 Cos[Rational[3, 20] Pi], -1.7999999999999998`}, {(-2) 
       Sin[Rational[3, 20] Pi], 2 
       Cos[Rational[3, 20] Pi], -1.4999999999999998`}, {
      Rational[1, 2] (1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -1.4999999999999998`}}, {{-0.6180339887498949, 
     1.902113032590307, -1.7999999999999998`}, {-0.9079809994790936, 
     1.7820130483767358`, -1.7999999999999998`}, {-0.9079809994790936, 
     1.7820130483767358`, -1.4999999999999998`}, {-0.6180339887498949, 
     1.902113032590307, -1.4999999999999998`}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -1.4999999999999998`}, {(-2) Sin[Rational[3, 20] Pi], 
       2 Cos[Rational[3, 20] Pi], -1.4999999999999998`}, {(-2) 
       Sin[Rational[3, 20] Pi], 2 
       Cos[Rational[3, 20] Pi], -1.1999999999999997`}, {
      Rational[1, 2] (1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -1.1999999999999997`}}, {{-0.6180339887498949, 
     1.902113032590307, -1.4999999999999998`}, {-0.9079809994790936, 
     1.7820130483767358`, -1.4999999999999998`}, {-0.9079809994790936, 
     1.7820130483767358`, -1.1999999999999997`}, {-0.6180339887498949, 
     1.902113032590307, -1.1999999999999997`}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -1.1999999999999997`}, {(-2) Sin[Rational[3, 20] Pi], 
       2 Cos[Rational[3, 20] Pi], -1.1999999999999997`}, {(-2) 
       Sin[Rational[3, 20] Pi], 2 
       Cos[Rational[3, 20] Pi], -0.8999999999999997}, {
      Rational[1, 2] (1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -0.8999999999999997}}, {{-0.6180339887498949, 
     1.902113032590307, -1.1999999999999997`}, {-0.9079809994790936, 
     1.7820130483767358`, -1.1999999999999997`}, {-0.9079809994790936, 
     1.7820130483767358`, -0.8999999999999997}, {-0.6180339887498949, 
     1.902113032590307, -0.8999999999999997}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -0.8999999999999997}, {(-2) Sin[Rational[3, 20] Pi], 
       2 Cos[Rational[3, 20] Pi], -0.8999999999999997}, {(-2) 
       Sin[Rational[3, 20] Pi], 2 
       Cos[Rational[3, 20] Pi], -0.5999999999999996}, {
      Rational[1, 2] (1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -0.5999999999999996}}, {{-0.6180339887498949, 
     1.902113032590307, -0.8999999999999997}, {-0.9079809994790936, 
     1.7820130483767358`, -0.8999999999999997}, {-0.9079809994790936, 
     1.7820130483767358`, -0.5999999999999996}, {-0.6180339887498949, 
     1.902113032590307, -0.5999999999999996}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -0.5999999999999996}, {(-2) Sin[Rational[3, 20] Pi], 
       2 Cos[Rational[3, 20] Pi], -0.5999999999999996}, {(-2) 
       Sin[Rational[3, 20] Pi], 2 
       Cos[Rational[3, 20] Pi], -0.2999999999999996}, {
      Rational[1, 2] (1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -0.2999999999999996}}, {{-0.6180339887498949, 
     1.902113032590307, -0.5999999999999996}, {-0.9079809994790936, 
     1.7820130483767358`, -0.5999999999999996}, {-0.9079809994790936, 
     1.7820130483767358`, -0.2999999999999996}, {-0.6180339887498949, 
     1.902113032590307, -0.2999999999999996}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -0.2999999999999996}, {(-2) Sin[Rational[3, 20] Pi], 
       2 Cos[Rational[3, 20] Pi], -0.2999999999999996}, {(-2) 
       Sin[Rational[3, 20] Pi], 2 Cos[Rational[3, 20] Pi], 
       4.440892098500626*^-16}, {
      Rational[1, 2] (1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       4.440892098500626*^-16}}, {{-0.6180339887498949, 
     1.902113032590307, -0.2999999999999996}, {-0.9079809994790936, 
     1.7820130483767358`, -0.2999999999999996}, {-0.9079809994790936, 
     1.7820130483767358`, 4.440892098500626*^-16}, {-0.6180339887498949, 
     1.902113032590307, 4.440892098500626*^-16}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       4.440892098500626*^-16}, {(-2) Sin[Rational[3, 20] Pi], 2 
       Cos[Rational[3, 20] Pi], 4.440892098500626*^-16}, {(-2) 
       Sin[Rational[3, 20] Pi], 2 Cos[Rational[3, 20] Pi], 
       0.3000000000000005}, {
      Rational[1, 2] (1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       0.3000000000000005}}, {{-0.6180339887498949, 1.902113032590307, 
     4.440892098500626*^-16}, {-0.9079809994790936, 1.7820130483767358`, 
     4.440892098500626*^-16}, {-0.9079809994790936, 1.7820130483767358`, 
     0.3000000000000005}, {-0.6180339887498949, 1.902113032590307, 
     0.3000000000000005}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       0.3000000000000005}, {(-2) Sin[Rational[3, 20] Pi], 2 
       Cos[Rational[3, 20] Pi], 0.3000000000000005}, {(-2) 
       Sin[Rational[3, 20] Pi], 2 Cos[Rational[3, 20] Pi], 
       0.6000000000000005}, {
      Rational[1, 2] (1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       0.6000000000000005}}, {{-0.6180339887498949, 1.902113032590307, 
     0.3000000000000005}, {-0.9079809994790936, 1.7820130483767358`, 
     0.3000000000000005}, {-0.9079809994790936, 1.7820130483767358`, 
     0.6000000000000005}, {-0.6180339887498949, 1.902113032590307, 
     0.6000000000000005}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       0.6000000000000005}, {(-2) Sin[Rational[3, 20] Pi], 2 
       Cos[Rational[3, 20] Pi], 0.6000000000000005}, {(-2) 
       Sin[Rational[3, 20] Pi], 2 Cos[Rational[3, 20] Pi], 
       0.9000000000000006}, {
      Rational[1, 2] (1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       0.9000000000000006}}, {{-0.6180339887498949, 1.902113032590307, 
     0.6000000000000005}, {-0.9079809994790936, 1.7820130483767358`, 
     0.6000000000000005}, {-0.9079809994790936, 1.7820130483767358`, 
     0.9000000000000006}, {-0.6180339887498949, 1.902113032590307, 
     0.9000000000000006}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       0.9000000000000006}, {(-2) Sin[Rational[3, 20] Pi], 2 
       Cos[Rational[3, 20] Pi], 0.9000000000000006}, {(-2) 
       Sin[Rational[3, 20] Pi], 2 Cos[Rational[3, 20] Pi], 
       1.2000000000000006`}, {
      Rational[1, 2] (1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       1.2000000000000006`}}, {{-0.6180339887498949, 1.902113032590307, 
     0.9000000000000006}, {-0.9079809994790936, 1.7820130483767358`, 
     0.9000000000000006}, {-0.9079809994790936, 1.7820130483767358`, 
     1.2000000000000006`}, {-0.6180339887498949, 1.902113032590307, 
     1.2000000000000006`}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       1.2000000000000006`}, {(-2) Sin[Rational[3, 20] Pi], 2 
       Cos[Rational[3, 20] Pi], 1.2000000000000006`}, {(-2) 
       Sin[Rational[3, 20] Pi], 2 Cos[Rational[3, 20] Pi], 
       1.5000000000000007`}, {
      Rational[1, 2] (1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       1.5000000000000007`}}, {{-0.6180339887498949, 1.902113032590307, 
     1.2000000000000006`}, {-0.9079809994790936, 1.7820130483767358`, 
     1.2000000000000006`}, {-0.9079809994790936, 1.7820130483767358`, 
     1.5000000000000007`}, {-0.6180339887498949, 1.902113032590307, 
     1.5000000000000007`}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       1.5000000000000007`}, {(-2) Sin[Rational[3, 20] Pi], 2 
       Cos[Rational[3, 20] Pi], 1.5000000000000007`}, {(-2) 
       Sin[Rational[3, 20] Pi], 2 Cos[Rational[3, 20] Pi], 
       1.8000000000000007`}, {
      Rational[1, 2] (1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       1.8000000000000007`}}, {{-0.6180339887498949, 1.902113032590307, 
     1.5000000000000007`}, {-0.9079809994790936, 1.7820130483767358`, 
     1.5000000000000007`}, {-0.9079809994790936, 1.7820130483767358`, 
     1.8000000000000007`}, {-0.6180339887498949, 1.902113032590307, 
     1.8000000000000007`}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       1.8000000000000007`}, {(-2) Sin[Rational[3, 20] Pi], 2 
       Cos[Rational[3, 20] Pi], 1.8000000000000007`}, {(-2) 
       Sin[Rational[3, 20] Pi], 2 Cos[Rational[3, 20] Pi], 
       2.1000000000000005`}, {
      Rational[1, 2] (1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       2.1000000000000005`}}, {{-0.6180339887498949, 1.902113032590307, 
     1.8000000000000007`}, {-0.9079809994790936, 1.7820130483767358`, 
     1.8000000000000007`}, {-0.9079809994790936, 1.7820130483767358`, 
     2.1000000000000005`}, {-0.6180339887498949, 1.902113032590307, 
     2.1000000000000005`}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       2.1000000000000005`}, {(-2) Sin[Rational[3, 20] Pi], 2 
       Cos[Rational[3, 20] Pi], 2.1000000000000005`}, {(-2) 
       Sin[Rational[3, 20] Pi], 2 Cos[Rational[3, 20] Pi], 
       2.4000000000000004`}, {
      Rational[1, 2] (1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       2.4000000000000004`}}, {{-0.6180339887498949, 1.902113032590307, 
     2.1000000000000005`}, {-0.9079809994790936, 1.7820130483767358`, 
     2.1000000000000005`}, {-0.9079809994790936, 1.7820130483767358`, 
     2.4000000000000004`}, {-0.6180339887498949, 1.902113032590307, 
     2.4000000000000004`}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       2.400000000000001}, {(-2) Sin[Rational[3, 20] Pi], 2 
       Cos[Rational[3, 20] Pi], 2.400000000000001}, {(-2) 
       Sin[Rational[3, 20] Pi], 2 Cos[Rational[3, 20] Pi], 
       2.700000000000001}, {
      Rational[1, 2] (1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       2.700000000000001}}, {{-0.6180339887498949, 1.902113032590307, 
     2.400000000000001}, {-0.9079809994790936, 1.7820130483767358`, 
     2.400000000000001}, {-0.9079809994790936, 1.7820130483767358`, 
     2.700000000000001}, {-0.6180339887498949, 1.902113032590307, 
     2.700000000000001}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       2.700000000000001}, {(-2) Sin[Rational[3, 20] Pi], 2 
       Cos[Rational[3, 20] Pi], 2.700000000000001}, {(-2) 
       Sin[Rational[3, 20] Pi], 2 Cos[Rational[3, 20] Pi], 
       3.000000000000001}, {
      Rational[1, 2] (1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       3.000000000000001}}, {{-0.6180339887498949, 1.902113032590307, 
     2.700000000000001}, {-0.9079809994790936, 1.7820130483767358`, 
     2.700000000000001}, {-0.9079809994790936, 1.7820130483767358`, 
     3.000000000000001}, {-0.6180339887498949, 1.902113032590307, 
     3.000000000000001}}]], 
   Polygon3DBox[
    NCache[{{(-2) Sin[Rational[3, 20] Pi], 2 
       Cos[Rational[3, 20] Pi], -3.}, {(-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 + 
        5^Rational[1, 2]), -3.}, {(-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 + 5^Rational[1, 2]), -2.7}, {(-2) 
       Sin[Rational[3, 20] Pi], 2 
       Cos[Rational[3, 20] Pi], -2.7}}, {{-0.9079809994790936, 
     1.7820130483767358`, -3.}, {-1.1755705045849463`, 
     1.618033988749895, -3.}, {-1.1755705045849463`, 
     1.618033988749895, -2.7}, {-0.9079809994790936, 
     1.7820130483767358`, -2.7}}]], 
   Polygon3DBox[
    NCache[{{(-2) Sin[Rational[3, 20] Pi], 2 
       Cos[
        Rational[3, 20] Pi], -2.7}, {(-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 + 
        5^Rational[1, 2]), -2.7}, {(-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 + 5^Rational[1, 2]), -2.4000000000000004`}, {(-2) 
       Sin[Rational[3, 20] Pi], 2 
       Cos[Rational[3, 20] Pi], -2.4000000000000004`}}, {{-0.9079809994790936,
      1.7820130483767358`, -2.7}, {-1.1755705045849463`, 
     1.618033988749895, -2.7}, {-1.1755705045849463`, 
     1.618033988749895, -2.4000000000000004`}, {-0.9079809994790936, 
     1.7820130483767358`, -2.4000000000000004`}}]], 
   Polygon3DBox[
    NCache[{{(-2) Sin[Rational[3, 20] Pi], 2 
       Cos[Rational[3, 20] Pi], -2.4}, {(-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 + 
        5^Rational[1, 2]), -2.4}, {(-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 + 5^Rational[1, 2]), -2.0999999999999996`}, {(-2) 
       Sin[Rational[3, 20] Pi], 2 
       Cos[Rational[3, 20] Pi], -2.0999999999999996`}}, {{-0.9079809994790936,
      1.7820130483767358`, -2.4}, {-1.1755705045849463`, 
     1.618033988749895, -2.4}, {-1.1755705045849463`, 
     1.618033988749895, -2.0999999999999996`}, {-0.9079809994790936, 
     1.7820130483767358`, -2.0999999999999996`}}]], 
   Polygon3DBox[
    NCache[{{(-2) Sin[Rational[3, 20] Pi], 2 
       Cos[Rational[3, 20] Pi], -2.0999999999999996`}, {(-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 + 
        5^Rational[1, 2]), -2.0999999999999996`}, {(-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 + 5^Rational[1, 2]), -1.7999999999999996`}, {(-2) 
       Sin[Rational[3, 20] Pi], 2 
       Cos[Rational[3, 20] Pi], -1.7999999999999996`}}, {{-0.9079809994790936,
      1.7820130483767358`, -2.0999999999999996`}, {-1.1755705045849463`, 
     1.618033988749895, -2.0999999999999996`}, {-1.1755705045849463`, 
     1.618033988749895, -1.7999999999999996`}, {-0.9079809994790936, 
     1.7820130483767358`, -1.7999999999999996`}}]], 
   Polygon3DBox[
    NCache[{{(-2) Sin[Rational[3, 20] Pi], 2 
       Cos[Rational[3, 20] Pi], -1.7999999999999998`}, {(-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 + 
        5^Rational[1, 2]), -1.7999999999999998`}, {(-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 + 5^Rational[1, 2]), -1.4999999999999998`}, {(-2) 
       Sin[Rational[3, 20] Pi], 2 
       Cos[Rational[3, 20] Pi], -1.4999999999999998`}}, {{-0.9079809994790936,
      1.7820130483767358`, -1.7999999999999998`}, {-1.1755705045849463`, 
     1.618033988749895, -1.7999999999999998`}, {-1.1755705045849463`, 
     1.618033988749895, -1.4999999999999998`}, {-0.9079809994790936, 
     1.7820130483767358`, -1.4999999999999998`}}]], 
   Polygon3DBox[
    NCache[{{(-2) Sin[Rational[3, 20] Pi], 2 
       Cos[Rational[3, 20] Pi], -1.4999999999999998`}, {(-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 + 
        5^Rational[1, 2]), -1.4999999999999998`}, {(-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 + 5^Rational[1, 2]), -1.1999999999999997`}, {(-2) 
       Sin[Rational[3, 20] Pi], 2 
       Cos[Rational[3, 20] Pi], -1.1999999999999997`}}, {{-0.9079809994790936,
      1.7820130483767358`, -1.4999999999999998`}, {-1.1755705045849463`, 
     1.618033988749895, -1.4999999999999998`}, {-1.1755705045849463`, 
     1.618033988749895, -1.1999999999999997`}, {-0.9079809994790936, 
     1.7820130483767358`, -1.1999999999999997`}}]], 
   Polygon3DBox[
    NCache[{{(-2) Sin[Rational[3, 20] Pi], 2 
       Cos[Rational[3, 20] Pi], -1.1999999999999997`}, {(-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 + 
        5^Rational[1, 2]), -1.1999999999999997`}, {(-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 + 5^Rational[1, 2]), -0.8999999999999997}, {(-2) 
       Sin[Rational[3, 20] Pi], 2 
       Cos[Rational[3, 20] Pi], -0.8999999999999997}}, {{-0.9079809994790936, 
     1.7820130483767358`, -1.1999999999999997`}, {-1.1755705045849463`, 
     1.618033988749895, -1.1999999999999997`}, {-1.1755705045849463`, 
     1.618033988749895, -0.8999999999999997}, {-0.9079809994790936, 
     1.7820130483767358`, -0.8999999999999997}}]], 
   Polygon3DBox[
    NCache[{{(-2) Sin[Rational[3, 20] Pi], 2 
       Cos[Rational[3, 20] Pi], -0.8999999999999997}, {(-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 + 
        5^Rational[1, 2]), -0.8999999999999997}, {(-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 + 5^Rational[1, 2]), -0.5999999999999996}, {(-2) 
       Sin[Rational[3, 20] Pi], 2 
       Cos[Rational[3, 20] Pi], -0.5999999999999996}}, {{-0.9079809994790936, 
     1.7820130483767358`, -0.8999999999999997}, {-1.1755705045849463`, 
     1.618033988749895, -0.8999999999999997}, {-1.1755705045849463`, 
     1.618033988749895, -0.5999999999999996}, {-0.9079809994790936, 
     1.7820130483767358`, -0.5999999999999996}}]], 
   Polygon3DBox[
    NCache[{{(-2) Sin[Rational[3, 20] Pi], 2 
       Cos[Rational[3, 20] Pi], -0.5999999999999996}, {(-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 + 
        5^Rational[1, 2]), -0.5999999999999996}, {(-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 + 5^Rational[1, 2]), -0.2999999999999996}, {(-2) 
       Sin[Rational[3, 20] Pi], 2 
       Cos[Rational[3, 20] Pi], -0.2999999999999996}}, {{-0.9079809994790936, 
     1.7820130483767358`, -0.5999999999999996}, {-1.1755705045849463`, 
     1.618033988749895, -0.5999999999999996}, {-1.1755705045849463`, 
     1.618033988749895, -0.2999999999999996}, {-0.9079809994790936, 
     1.7820130483767358`, -0.2999999999999996}}]], 
   Polygon3DBox[
    NCache[{{(-2) Sin[Rational[3, 20] Pi], 2 
       Cos[Rational[3, 20] Pi], -0.2999999999999996}, {(-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 + 
        5^Rational[1, 2]), -0.2999999999999996}, {(-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 + 5^Rational[1, 2]), 4.440892098500626*^-16}, {(-2) 
       Sin[Rational[3, 20] Pi], 2 Cos[Rational[3, 20] Pi], 
       4.440892098500626*^-16}}, {{-0.9079809994790936, 
     1.7820130483767358`, -0.2999999999999996}, {-1.1755705045849463`, 
     1.618033988749895, -0.2999999999999996}, {-1.1755705045849463`, 
     1.618033988749895, 4.440892098500626*^-16}, {-0.9079809994790936, 
     1.7820130483767358`, 4.440892098500626*^-16}}]], 
   Polygon3DBox[
    NCache[{{(-2) Sin[Rational[3, 20] Pi], 2 Cos[Rational[3, 20] Pi], 
       4.440892098500626*^-16}, {(-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 + 5^Rational[1, 2]), 
       4.440892098500626*^-16}, {(-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 + 5^Rational[1, 2]), 0.3000000000000005}, {(-2) 
       Sin[Rational[3, 20] Pi], 2 Cos[Rational[3, 20] Pi], 
       0.3000000000000005}}, {{-0.9079809994790936, 1.7820130483767358`, 
     4.440892098500626*^-16}, {-1.1755705045849463`, 1.618033988749895, 
     4.440892098500626*^-16}, {-1.1755705045849463`, 1.618033988749895, 
     0.3000000000000005}, {-0.9079809994790936, 1.7820130483767358`, 
     0.3000000000000005}}]], 
   Polygon3DBox[
    NCache[{{(-2) Sin[Rational[3, 20] Pi], 2 Cos[Rational[3, 20] Pi], 
       0.3000000000000005}, {(-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 + 5^Rational[1, 2]), 
       0.3000000000000005}, {(-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 + 5^Rational[1, 2]), 0.6000000000000005}, {(-2) 
       Sin[Rational[3, 20] Pi], 2 Cos[Rational[3, 20] Pi], 
       0.6000000000000005}}, {{-0.9079809994790936, 1.7820130483767358`, 
     0.3000000000000005}, {-1.1755705045849463`, 1.618033988749895, 
     0.3000000000000005}, {-1.1755705045849463`, 1.618033988749895, 
     0.6000000000000005}, {-0.9079809994790936, 1.7820130483767358`, 
     0.6000000000000005}}]], 
   Polygon3DBox[
    NCache[{{(-2) Sin[Rational[3, 20] Pi], 2 Cos[Rational[3, 20] Pi], 
       0.6000000000000005}, {(-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 + 5^Rational[1, 2]), 
       0.6000000000000005}, {(-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 + 5^Rational[1, 2]), 0.9000000000000006}, {(-2) 
       Sin[Rational[3, 20] Pi], 2 Cos[Rational[3, 20] Pi], 
       0.9000000000000006}}, {{-0.9079809994790936, 1.7820130483767358`, 
     0.6000000000000005}, {-1.1755705045849463`, 1.618033988749895, 
     0.6000000000000005}, {-1.1755705045849463`, 1.618033988749895, 
     0.9000000000000006}, {-0.9079809994790936, 1.7820130483767358`, 
     0.9000000000000006}}]], 
   Polygon3DBox[
    NCache[{{(-2) Sin[Rational[3, 20] Pi], 2 Cos[Rational[3, 20] Pi], 
       0.9000000000000006}, {(-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 + 5^Rational[1, 2]), 
       0.9000000000000006}, {(-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 + 5^Rational[1, 2]), 1.2000000000000006`}, {(-2) 
       Sin[Rational[3, 20] Pi], 2 Cos[Rational[3, 20] Pi], 
       1.2000000000000006`}}, {{-0.9079809994790936, 1.7820130483767358`, 
     0.9000000000000006}, {-1.1755705045849463`, 1.618033988749895, 
     0.9000000000000006}, {-1.1755705045849463`, 1.618033988749895, 
     1.2000000000000006`}, {-0.9079809994790936, 1.7820130483767358`, 
     1.2000000000000006`}}]], 
   Polygon3DBox[
    NCache[{{(-2) Sin[Rational[3, 20] Pi], 2 Cos[Rational[3, 20] Pi], 
       1.2000000000000006`}, {(-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 + 5^Rational[1, 2]), 
       1.2000000000000006`}, {(-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 + 5^Rational[1, 2]), 1.5000000000000007`}, {(-2) 
       Sin[Rational[3, 20] Pi], 2 Cos[Rational[3, 20] Pi], 
       1.5000000000000007`}}, {{-0.9079809994790936, 1.7820130483767358`, 
     1.2000000000000006`}, {-1.1755705045849463`, 1.618033988749895, 
     1.2000000000000006`}, {-1.1755705045849463`, 1.618033988749895, 
     1.5000000000000007`}, {-0.9079809994790936, 1.7820130483767358`, 
     1.5000000000000007`}}]], 
   Polygon3DBox[
    NCache[{{(-2) Sin[Rational[3, 20] Pi], 2 Cos[Rational[3, 20] Pi], 
       1.5000000000000007`}, {(-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 + 5^Rational[1, 2]), 
       1.5000000000000007`}, {(-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 + 5^Rational[1, 2]), 1.8000000000000007`}, {(-2) 
       Sin[Rational[3, 20] Pi], 2 Cos[Rational[3, 20] Pi], 
       1.8000000000000007`}}, {{-0.9079809994790936, 1.7820130483767358`, 
     1.5000000000000007`}, {-1.1755705045849463`, 1.618033988749895, 
     1.5000000000000007`}, {-1.1755705045849463`, 1.618033988749895, 
     1.8000000000000007`}, {-0.9079809994790936, 1.7820130483767358`, 
     1.8000000000000007`}}]], 
   Polygon3DBox[
    NCache[{{(-2) Sin[Rational[3, 20] Pi], 2 Cos[Rational[3, 20] Pi], 
       1.8000000000000007`}, {(-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 + 5^Rational[1, 2]), 
       1.8000000000000007`}, {(-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 + 5^Rational[1, 2]), 2.1000000000000005`}, {(-2) 
       Sin[Rational[3, 20] Pi], 2 Cos[Rational[3, 20] Pi], 
       2.1000000000000005`}}, {{-0.9079809994790936, 1.7820130483767358`, 
     1.8000000000000007`}, {-1.1755705045849463`, 1.618033988749895, 
     1.8000000000000007`}, {-1.1755705045849463`, 1.618033988749895, 
     2.1000000000000005`}, {-0.9079809994790936, 1.7820130483767358`, 
     2.1000000000000005`}}]], 
   Polygon3DBox[
    NCache[{{(-2) Sin[Rational[3, 20] Pi], 2 Cos[Rational[3, 20] Pi], 
       2.1000000000000005`}, {(-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 + 5^Rational[1, 2]), 
       2.1000000000000005`}, {(-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 + 5^Rational[1, 2]), 2.4000000000000004`}, {(-2) 
       Sin[Rational[3, 20] Pi], 2 Cos[Rational[3, 20] Pi], 
       2.4000000000000004`}}, {{-0.9079809994790936, 1.7820130483767358`, 
     2.1000000000000005`}, {-1.1755705045849463`, 1.618033988749895, 
     2.1000000000000005`}, {-1.1755705045849463`, 1.618033988749895, 
     2.4000000000000004`}, {-0.9079809994790936, 1.7820130483767358`, 
     2.4000000000000004`}}]], 
   Polygon3DBox[
    NCache[{{(-2) Sin[Rational[3, 20] Pi], 2 Cos[Rational[3, 20] Pi], 
       2.400000000000001}, {(-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 + 5^Rational[1, 2]), 
       2.400000000000001}, {(-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 + 5^Rational[1, 2]), 2.700000000000001}, {(-2) 
       Sin[Rational[3, 20] Pi], 2 Cos[Rational[3, 20] Pi], 
       2.700000000000001}}, {{-0.9079809994790936, 1.7820130483767358`, 
     2.400000000000001}, {-1.1755705045849463`, 1.618033988749895, 
     2.400000000000001}, {-1.1755705045849463`, 1.618033988749895, 
     2.700000000000001}, {-0.9079809994790936, 1.7820130483767358`, 
     2.700000000000001}}]], 
   Polygon3DBox[
    NCache[{{(-2) Sin[Rational[3, 20] Pi], 2 Cos[Rational[3, 20] Pi], 
       2.700000000000001}, {(-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 + 5^Rational[1, 2]), 
       2.700000000000001}, {(-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 + 5^Rational[1, 2]), 3.000000000000001}, {(-2) 
       Sin[Rational[3, 20] Pi], 2 Cos[Rational[3, 20] Pi], 
       3.000000000000001}}, {{-0.9079809994790936, 1.7820130483767358`, 
     2.700000000000001}, {-1.1755705045849463`, 1.618033988749895, 
     2.700000000000001}, {-1.1755705045849463`, 1.618033988749895, 
     3.000000000000001}, {-0.9079809994790936, 1.7820130483767358`, 
     3.000000000000001}}]], 
   Polygon3DBox[
    NCache[{{(-2) (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], 
       Rational[1, 2] (1 + 5^Rational[1, 2]), -3.}, {-2^Rational[1, 2], 2^
       Rational[1, 2], -3.}, {-2^Rational[1, 2], 2^
       Rational[
        1, 2], -2.7}, {(-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 + 5^Rational[1, 2]), -2.7}}, {{-1.1755705045849463`, 
     1.618033988749895, -3.}, {-1.4142135623730951`, 
     1.4142135623730951`, -3.}, {-1.4142135623730951`, 
     1.4142135623730951`, -2.7}, {-1.1755705045849463`, 
     1.618033988749895, -2.7}}]], 
   Polygon3DBox[
    NCache[{{(-2) (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], 
       Rational[1, 2] (1 + 5^Rational[1, 2]), -2.7}, {-2^Rational[1, 2], 2^
       Rational[1, 2], -2.7}, {-2^Rational[1, 2], 2^
       Rational[
        1, 2], -2.4000000000000004`}, {(-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 + 
        5^Rational[1, 2]), -2.4000000000000004`}}, {{-1.1755705045849463`, 
     1.618033988749895, -2.7}, {-1.4142135623730951`, 
     1.4142135623730951`, -2.7}, {-1.4142135623730951`, 
     1.4142135623730951`, -2.4000000000000004`}, {-1.1755705045849463`, 
     1.618033988749895, -2.4000000000000004`}}]], 
   Polygon3DBox[
    NCache[{{(-2) (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], 
       Rational[1, 2] (1 + 5^Rational[1, 2]), -2.4}, {-2^Rational[1, 2], 2^
       Rational[1, 2], -2.4}, {-2^Rational[1, 2], 2^
       Rational[
        1, 2], -2.0999999999999996`}, {(-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 + 
        5^Rational[1, 2]), -2.0999999999999996`}}, {{-1.1755705045849463`, 
     1.618033988749895, -2.4}, {-1.4142135623730951`, 
     1.4142135623730951`, -2.4}, {-1.4142135623730951`, 
     1.4142135623730951`, -2.0999999999999996`}, {-1.1755705045849463`, 
     1.618033988749895, -2.0999999999999996`}}]], 
   Polygon3DBox[
    NCache[{{(-2) (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], 
       Rational[1, 2] (1 + 5^Rational[1, 2]), -2.0999999999999996`}, {-2^
        Rational[1, 2], 2^
       Rational[1, 2], -2.0999999999999996`}, {-2^Rational[1, 2], 2^
       Rational[
        1, 2], -1.7999999999999996`}, {(-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 + 
        5^Rational[1, 2]), -1.7999999999999996`}}, {{-1.1755705045849463`, 
     1.618033988749895, -2.0999999999999996`}, {-1.4142135623730951`, 
     1.4142135623730951`, -2.0999999999999996`}, {-1.4142135623730951`, 
     1.4142135623730951`, -1.7999999999999996`}, {-1.1755705045849463`, 
     1.618033988749895, -1.7999999999999996`}}]], 
   Polygon3DBox[
    NCache[{{(-2) (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], 
       Rational[1, 2] (1 + 5^Rational[1, 2]), -1.7999999999999998`}, {-2^
        Rational[1, 2], 2^
       Rational[1, 2], -1.7999999999999998`}, {-2^Rational[1, 2], 2^
       Rational[
        1, 2], -1.4999999999999998`}, {(-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 + 
        5^Rational[1, 2]), -1.4999999999999998`}}, {{-1.1755705045849463`, 
     1.618033988749895, -1.7999999999999998`}, {-1.4142135623730951`, 
     1.4142135623730951`, -1.7999999999999998`}, {-1.4142135623730951`, 
     1.4142135623730951`, -1.4999999999999998`}, {-1.1755705045849463`, 
     1.618033988749895, -1.4999999999999998`}}]], 
   Polygon3DBox[
    NCache[{{(-2) (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], 
       Rational[1, 2] (1 + 5^Rational[1, 2]), -1.4999999999999998`}, {-2^
        Rational[1, 2], 2^
       Rational[1, 2], -1.4999999999999998`}, {-2^Rational[1, 2], 2^
       Rational[
        1, 2], -1.1999999999999997`}, {(-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 + 
        5^Rational[1, 2]), -1.1999999999999997`}}, {{-1.1755705045849463`, 
     1.618033988749895, -1.4999999999999998`}, {-1.4142135623730951`, 
     1.4142135623730951`, -1.4999999999999998`}, {-1.4142135623730951`, 
     1.4142135623730951`, -1.1999999999999997`}, {-1.1755705045849463`, 
     1.618033988749895, -1.1999999999999997`}}]], 
   Polygon3DBox[
    NCache[{{(-2) (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], 
       Rational[1, 2] (1 + 5^Rational[1, 2]), -1.1999999999999997`}, {-2^
        Rational[1, 2], 2^
       Rational[1, 2], -1.1999999999999997`}, {-2^Rational[1, 2], 2^
       Rational[
        1, 2], -0.8999999999999997}, {(-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 + 
        5^Rational[1, 2]), -0.8999999999999997}}, {{-1.1755705045849463`, 
     1.618033988749895, -1.1999999999999997`}, {-1.4142135623730951`, 
     1.4142135623730951`, -1.1999999999999997`}, {-1.4142135623730951`, 
     1.4142135623730951`, -0.8999999999999997}, {-1.1755705045849463`, 
     1.618033988749895, -0.8999999999999997}}]], 
   Polygon3DBox[
    NCache[{{(-2) (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], 
       Rational[1, 2] (1 + 5^Rational[1, 2]), -0.8999999999999997}, {-2^
        Rational[1, 2], 2^
       Rational[1, 2], -0.8999999999999997}, {-2^Rational[1, 2], 2^
       Rational[
        1, 2], -0.5999999999999996}, {(-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 + 
        5^Rational[1, 2]), -0.5999999999999996}}, {{-1.1755705045849463`, 
     1.618033988749895, -0.8999999999999997}, {-1.4142135623730951`, 
     1.4142135623730951`, -0.8999999999999997}, {-1.4142135623730951`, 
     1.4142135623730951`, -0.5999999999999996}, {-1.1755705045849463`, 
     1.618033988749895, -0.5999999999999996}}]], 
   Polygon3DBox[
    NCache[{{(-2) (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], 
       Rational[1, 2] (1 + 5^Rational[1, 2]), -0.5999999999999996}, {-2^
        Rational[1, 2], 2^
       Rational[1, 2], -0.5999999999999996}, {-2^Rational[1, 2], 2^
       Rational[
        1, 2], -0.2999999999999996}, {(-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 + 
        5^Rational[1, 2]), -0.2999999999999996}}, {{-1.1755705045849463`, 
     1.618033988749895, -0.5999999999999996}, {-1.4142135623730951`, 
     1.4142135623730951`, -0.5999999999999996}, {-1.4142135623730951`, 
     1.4142135623730951`, -0.2999999999999996}, {-1.1755705045849463`, 
     1.618033988749895, -0.2999999999999996}}]], 
   Polygon3DBox[
    NCache[{{(-2) (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], 
       Rational[1, 2] (1 + 5^Rational[1, 2]), -0.2999999999999996}, {-2^
        Rational[1, 2], 2^
       Rational[1, 2], -0.2999999999999996}, {-2^Rational[1, 2], 2^
       Rational[1, 2], 
       4.440892098500626*^-16}, {(-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 + 5^Rational[1, 2]), 
       4.440892098500626*^-16}}, {{-1.1755705045849463`, 
     1.618033988749895, -0.2999999999999996}, {-1.4142135623730951`, 
     1.4142135623730951`, -0.2999999999999996}, {-1.4142135623730951`, 
     1.4142135623730951`, 4.440892098500626*^-16}, {-1.1755705045849463`, 
     1.618033988749895, 4.440892098500626*^-16}}]], 
   Polygon3DBox[
    NCache[{{(-2) (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 2] (1 + 5^Rational[1, 2]), 
       4.440892098500626*^-16}, {-2^Rational[1, 2], 2^Rational[1, 2], 
       4.440892098500626*^-16}, {-2^Rational[1, 2], 2^Rational[1, 2], 
       0.3000000000000005}, {(-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 + 5^Rational[1, 2]), 
       0.3000000000000005}}, {{-1.1755705045849463`, 1.618033988749895, 
     4.440892098500626*^-16}, {-1.4142135623730951`, 1.4142135623730951`, 
     4.440892098500626*^-16}, {-1.4142135623730951`, 1.4142135623730951`, 
     0.3000000000000005}, {-1.1755705045849463`, 1.618033988749895, 
     0.3000000000000005}}]], 
   Polygon3DBox[
    NCache[{{(-2) (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 2] (1 + 5^Rational[1, 2]), 
       0.3000000000000005}, {-2^Rational[1, 2], 2^Rational[1, 2], 
       0.3000000000000005}, {-2^Rational[1, 2], 2^Rational[1, 2], 
       0.6000000000000005}, {(-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 + 5^Rational[1, 2]), 
       0.6000000000000005}}, {{-1.1755705045849463`, 1.618033988749895, 
     0.3000000000000005}, {-1.4142135623730951`, 1.4142135623730951`, 
     0.3000000000000005}, {-1.4142135623730951`, 1.4142135623730951`, 
     0.6000000000000005}, {-1.1755705045849463`, 1.618033988749895, 
     0.6000000000000005}}]], 
   Polygon3DBox[
    NCache[{{(-2) (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 2] (1 + 5^Rational[1, 2]), 
       0.6000000000000005}, {-2^Rational[1, 2], 2^Rational[1, 2], 
       0.6000000000000005}, {-2^Rational[1, 2], 2^Rational[1, 2], 
       0.9000000000000006}, {(-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 + 5^Rational[1, 2]), 
       0.9000000000000006}}, {{-1.1755705045849463`, 1.618033988749895, 
     0.6000000000000005}, {-1.4142135623730951`, 1.4142135623730951`, 
     0.6000000000000005}, {-1.4142135623730951`, 1.4142135623730951`, 
     0.9000000000000006}, {-1.1755705045849463`, 1.618033988749895, 
     0.9000000000000006}}]], 
   Polygon3DBox[
    NCache[{{(-2) (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 2] (1 + 5^Rational[1, 2]), 
       0.9000000000000006}, {-2^Rational[1, 2], 2^Rational[1, 2], 
       0.9000000000000006}, {-2^Rational[1, 2], 2^Rational[1, 2], 
       1.2000000000000006`}, {(-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 + 5^Rational[1, 2]), 
       1.2000000000000006`}}, {{-1.1755705045849463`, 1.618033988749895, 
     0.9000000000000006}, {-1.4142135623730951`, 1.4142135623730951`, 
     0.9000000000000006}, {-1.4142135623730951`, 1.4142135623730951`, 
     1.2000000000000006`}, {-1.1755705045849463`, 1.618033988749895, 
     1.2000000000000006`}}]], 
   Polygon3DBox[
    NCache[{{(-2) (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 2] (1 + 5^Rational[1, 2]), 
       1.2000000000000006`}, {-2^Rational[1, 2], 2^Rational[1, 2], 
       1.2000000000000006`}, {-2^Rational[1, 2], 2^Rational[1, 2], 
       1.5000000000000007`}, {(-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 + 5^Rational[1, 2]), 
       1.5000000000000007`}}, {{-1.1755705045849463`, 1.618033988749895, 
     1.2000000000000006`}, {-1.4142135623730951`, 1.4142135623730951`, 
     1.2000000000000006`}, {-1.4142135623730951`, 1.4142135623730951`, 
     1.5000000000000007`}, {-1.1755705045849463`, 1.618033988749895, 
     1.5000000000000007`}}]], 
   Polygon3DBox[
    NCache[{{(-2) (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 2] (1 + 5^Rational[1, 2]), 
       1.5000000000000007`}, {-2^Rational[1, 2], 2^Rational[1, 2], 
       1.5000000000000007`}, {-2^Rational[1, 2], 2^Rational[1, 2], 
       1.8000000000000007`}, {(-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 + 5^Rational[1, 2]), 
       1.8000000000000007`}}, {{-1.1755705045849463`, 1.618033988749895, 
     1.5000000000000007`}, {-1.4142135623730951`, 1.4142135623730951`, 
     1.5000000000000007`}, {-1.4142135623730951`, 1.4142135623730951`, 
     1.8000000000000007`}, {-1.1755705045849463`, 1.618033988749895, 
     1.8000000000000007`}}]], 
   Polygon3DBox[
    NCache[{{(-2) (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 2] (1 + 5^Rational[1, 2]), 
       1.8000000000000007`}, {-2^Rational[1, 2], 2^Rational[1, 2], 
       1.8000000000000007`}, {-2^Rational[1, 2], 2^Rational[1, 2], 
       2.1000000000000005`}, {(-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 + 5^Rational[1, 2]), 
       2.1000000000000005`}}, {{-1.1755705045849463`, 1.618033988749895, 
     1.8000000000000007`}, {-1.4142135623730951`, 1.4142135623730951`, 
     1.8000000000000007`}, {-1.4142135623730951`, 1.4142135623730951`, 
     2.1000000000000005`}, {-1.1755705045849463`, 1.618033988749895, 
     2.1000000000000005`}}]], 
   Polygon3DBox[
    NCache[{{(-2) (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 2] (1 + 5^Rational[1, 2]), 
       2.1000000000000005`}, {-2^Rational[1, 2], 2^Rational[1, 2], 
       2.1000000000000005`}, {-2^Rational[1, 2], 2^Rational[1, 2], 
       2.4000000000000004`}, {(-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 + 5^Rational[1, 2]), 
       2.4000000000000004`}}, {{-1.1755705045849463`, 1.618033988749895, 
     2.1000000000000005`}, {-1.4142135623730951`, 1.4142135623730951`, 
     2.1000000000000005`}, {-1.4142135623730951`, 1.4142135623730951`, 
     2.4000000000000004`}, {-1.1755705045849463`, 1.618033988749895, 
     2.4000000000000004`}}]], 
   Polygon3DBox[
    NCache[{{(-2) (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 2] (1 + 5^Rational[1, 2]), 
       2.400000000000001}, {-2^Rational[1, 2], 2^Rational[1, 2], 
       2.400000000000001}, {-2^Rational[1, 2], 2^Rational[1, 2], 
       2.700000000000001}, {(-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 + 5^Rational[1, 2]), 
       2.700000000000001}}, {{-1.1755705045849463`, 1.618033988749895, 
     2.400000000000001}, {-1.4142135623730951`, 1.4142135623730951`, 
     2.400000000000001}, {-1.4142135623730951`, 1.4142135623730951`, 
     2.700000000000001}, {-1.1755705045849463`, 1.618033988749895, 
     2.700000000000001}}]], 
   Polygon3DBox[
    NCache[{{(-2) (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 2] (1 + 5^Rational[1, 2]), 
       2.700000000000001}, {-2^Rational[1, 2], 2^Rational[1, 2], 
       2.700000000000001}, {-2^Rational[1, 2], 2^Rational[1, 2], 
       3.000000000000001}, {(-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 + 5^Rational[1, 2]), 
       3.000000000000001}}, {{-1.1755705045849463`, 1.618033988749895, 
     2.700000000000001}, {-1.4142135623730951`, 1.4142135623730951`, 
     2.700000000000001}, {-1.4142135623730951`, 1.4142135623730951`, 
     3.000000000000001}, {-1.1755705045849463`, 1.618033988749895, 
     3.000000000000001}}]], 
   Polygon3DBox[
    NCache[{{-2^Rational[1, 2], 2^Rational[1, 2], -3.}, {
      Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -3.}, {
      Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -2.7}, {-2^Rational[1, 2], 2^
       Rational[1, 2], -2.7}}, {{-1.4142135623730951`, 
     1.4142135623730951`, -3.}, {-1.618033988749895, 
     1.1755705045849463`, -3.}, {-1.618033988749895, 
     1.1755705045849463`, -2.7}, {-1.4142135623730951`, 
     1.4142135623730951`, -2.7}}]], 
   Polygon3DBox[
    NCache[{{-2^Rational[1, 2], 2^Rational[1, 2], -2.7}, {
      Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -2.7}, {
      Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -2.4000000000000004`}, {-2^Rational[1, 2], 2^
       Rational[1, 2], -2.4000000000000004`}}, {{-1.4142135623730951`, 
     1.4142135623730951`, -2.7}, {-1.618033988749895, 
     1.1755705045849463`, -2.7}, {-1.618033988749895, 
     1.1755705045849463`, -2.4000000000000004`}, {-1.4142135623730951`, 
     1.4142135623730951`, -2.4000000000000004`}}]], 
   Polygon3DBox[
    NCache[{{-2^Rational[1, 2], 2^Rational[1, 2], -2.4}, {
      Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -2.4}, {
      Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -2.0999999999999996`}, {-2^Rational[1, 2], 2^
       Rational[1, 2], -2.0999999999999996`}}, {{-1.4142135623730951`, 
     1.4142135623730951`, -2.4}, {-1.618033988749895, 
     1.1755705045849463`, -2.4}, {-1.618033988749895, 
     1.1755705045849463`, -2.0999999999999996`}, {-1.4142135623730951`, 
     1.4142135623730951`, -2.0999999999999996`}}]], 
   Polygon3DBox[
    NCache[{{-2^Rational[1, 2], 2^Rational[1, 2], -2.0999999999999996`}, {
      Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -2.0999999999999996`}, {
      Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -1.7999999999999996`}, {-2^Rational[1, 2], 2^
       Rational[1, 2], -1.7999999999999996`}}, {{-1.4142135623730951`, 
     1.4142135623730951`, -2.0999999999999996`}, {-1.618033988749895, 
     1.1755705045849463`, -2.0999999999999996`}, {-1.618033988749895, 
     1.1755705045849463`, -1.7999999999999996`}, {-1.4142135623730951`, 
     1.4142135623730951`, -1.7999999999999996`}}]], 
   Polygon3DBox[
    NCache[{{-2^Rational[1, 2], 2^Rational[1, 2], -1.7999999999999998`}, {
      Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -1.7999999999999998`}, {
      Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -1.4999999999999998`}, {-2^Rational[1, 2], 2^
       Rational[1, 2], -1.4999999999999998`}}, {{-1.4142135623730951`, 
     1.4142135623730951`, -1.7999999999999998`}, {-1.618033988749895, 
     1.1755705045849463`, -1.7999999999999998`}, {-1.618033988749895, 
     1.1755705045849463`, -1.4999999999999998`}, {-1.4142135623730951`, 
     1.4142135623730951`, -1.4999999999999998`}}]], 
   Polygon3DBox[
    NCache[{{-2^Rational[1, 2], 2^Rational[1, 2], -1.4999999999999998`}, {
      Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -1.4999999999999998`}, {
      Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -1.1999999999999997`}, {-2^Rational[1, 2], 2^
       Rational[1, 2], -1.1999999999999997`}}, {{-1.4142135623730951`, 
     1.4142135623730951`, -1.4999999999999998`}, {-1.618033988749895, 
     1.1755705045849463`, -1.4999999999999998`}, {-1.618033988749895, 
     1.1755705045849463`, -1.1999999999999997`}, {-1.4142135623730951`, 
     1.4142135623730951`, -1.1999999999999997`}}]], 
   Polygon3DBox[
    NCache[{{-2^Rational[1, 2], 2^Rational[1, 2], -1.1999999999999997`}, {
      Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -1.1999999999999997`}, {
      Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -0.8999999999999997}, {-2^Rational[1, 2], 2^
       Rational[1, 2], -0.8999999999999997}}, {{-1.4142135623730951`, 
     1.4142135623730951`, -1.1999999999999997`}, {-1.618033988749895, 
     1.1755705045849463`, -1.1999999999999997`}, {-1.618033988749895, 
     1.1755705045849463`, -0.8999999999999997}, {-1.4142135623730951`, 
     1.4142135623730951`, -0.8999999999999997}}]], 
   Polygon3DBox[
    NCache[{{-2^Rational[1, 2], 2^Rational[1, 2], -0.8999999999999997}, {
      Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -0.8999999999999997}, {
      Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -0.5999999999999996}, {-2^Rational[1, 2], 2^
       Rational[1, 2], -0.5999999999999996}}, {{-1.4142135623730951`, 
     1.4142135623730951`, -0.8999999999999997}, {-1.618033988749895, 
     1.1755705045849463`, -0.8999999999999997}, {-1.618033988749895, 
     1.1755705045849463`, -0.5999999999999996}, {-1.4142135623730951`, 
     1.4142135623730951`, -0.5999999999999996}}]], 
   Polygon3DBox[
    NCache[{{-2^Rational[1, 2], 2^Rational[1, 2], -0.5999999999999996}, {
      Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -0.5999999999999996}, {
      Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -0.2999999999999996}, {-2^Rational[1, 2], 2^
       Rational[1, 2], -0.2999999999999996}}, {{-1.4142135623730951`, 
     1.4142135623730951`, -0.5999999999999996}, {-1.618033988749895, 
     1.1755705045849463`, -0.5999999999999996}, {-1.618033988749895, 
     1.1755705045849463`, -0.2999999999999996}, {-1.4142135623730951`, 
     1.4142135623730951`, -0.2999999999999996}}]], 
   Polygon3DBox[
    NCache[{{-2^Rational[1, 2], 2^Rational[1, 2], -0.2999999999999996}, {
      Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -0.2999999999999996}, {
      Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       4.440892098500626*^-16}, {-2^Rational[1, 2], 2^Rational[1, 2], 
       4.440892098500626*^-16}}, {{-1.4142135623730951`, 
     1.4142135623730951`, -0.2999999999999996}, {-1.618033988749895, 
     1.1755705045849463`, -0.2999999999999996}, {-1.618033988749895, 
     1.1755705045849463`, 4.440892098500626*^-16}, {-1.4142135623730951`, 
     1.4142135623730951`, 4.440892098500626*^-16}}]], 
   Polygon3DBox[
    NCache[{{-2^Rational[1, 2], 2^Rational[1, 2], 4.440892098500626*^-16}, {
      Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       4.440892098500626*^-16}, {
      Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       0.3000000000000005}, {-2^Rational[1, 2], 2^Rational[1, 2], 
       0.3000000000000005}}, {{-1.4142135623730951`, 1.4142135623730951`, 
     4.440892098500626*^-16}, {-1.618033988749895, 1.1755705045849463`, 
     4.440892098500626*^-16}, {-1.618033988749895, 1.1755705045849463`, 
     0.3000000000000005}, {-1.4142135623730951`, 1.4142135623730951`, 
     0.3000000000000005}}]], 
   Polygon3DBox[
    NCache[{{-2^Rational[1, 2], 2^Rational[1, 2], 0.3000000000000005}, {
      Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       0.3000000000000005}, {
      Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       0.6000000000000005}, {-2^Rational[1, 2], 2^Rational[1, 2], 
       0.6000000000000005}}, {{-1.4142135623730951`, 1.4142135623730951`, 
     0.3000000000000005}, {-1.618033988749895, 1.1755705045849463`, 
     0.3000000000000005}, {-1.618033988749895, 1.1755705045849463`, 
     0.6000000000000005}, {-1.4142135623730951`, 1.4142135623730951`, 
     0.6000000000000005}}]], 
   Polygon3DBox[
    NCache[{{-2^Rational[1, 2], 2^Rational[1, 2], 0.6000000000000005}, {
      Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       0.6000000000000005}, {
      Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       0.9000000000000006}, {-2^Rational[1, 2], 2^Rational[1, 2], 
       0.9000000000000006}}, {{-1.4142135623730951`, 1.4142135623730951`, 
     0.6000000000000005}, {-1.618033988749895, 1.1755705045849463`, 
     0.6000000000000005}, {-1.618033988749895, 1.1755705045849463`, 
     0.9000000000000006}, {-1.4142135623730951`, 1.4142135623730951`, 
     0.9000000000000006}}]], 
   Polygon3DBox[
    NCache[{{-2^Rational[1, 2], 2^Rational[1, 2], 0.9000000000000006}, {
      Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       0.9000000000000006}, {
      Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       1.2000000000000006`}, {-2^Rational[1, 2], 2^Rational[1, 2], 
       1.2000000000000006`}}, {{-1.4142135623730951`, 1.4142135623730951`, 
     0.9000000000000006}, {-1.618033988749895, 1.1755705045849463`, 
     0.9000000000000006}, {-1.618033988749895, 1.1755705045849463`, 
     1.2000000000000006`}, {-1.4142135623730951`, 1.4142135623730951`, 
     1.2000000000000006`}}]], 
   Polygon3DBox[
    NCache[{{-2^Rational[1, 2], 2^Rational[1, 2], 1.2000000000000006`}, {
      Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       1.2000000000000006`}, {
      Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       1.5000000000000007`}, {-2^Rational[1, 2], 2^Rational[1, 2], 
       1.5000000000000007`}}, {{-1.4142135623730951`, 1.4142135623730951`, 
     1.2000000000000006`}, {-1.618033988749895, 1.1755705045849463`, 
     1.2000000000000006`}, {-1.618033988749895, 1.1755705045849463`, 
     1.5000000000000007`}, {-1.4142135623730951`, 1.4142135623730951`, 
     1.5000000000000007`}}]], 
   Polygon3DBox[
    NCache[{{-2^Rational[1, 2], 2^Rational[1, 2], 1.5000000000000007`}, {
      Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       1.5000000000000007`}, {
      Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       1.8000000000000007`}, {-2^Rational[1, 2], 2^Rational[1, 2], 
       1.8000000000000007`}}, {{-1.4142135623730951`, 1.4142135623730951`, 
     1.5000000000000007`}, {-1.618033988749895, 1.1755705045849463`, 
     1.5000000000000007`}, {-1.618033988749895, 1.1755705045849463`, 
     1.8000000000000007`}, {-1.4142135623730951`, 1.4142135623730951`, 
     1.8000000000000007`}}]], 
   Polygon3DBox[
    NCache[{{-2^Rational[1, 2], 2^Rational[1, 2], 1.8000000000000007`}, {
      Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       1.8000000000000007`}, {
      Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       2.1000000000000005`}, {-2^Rational[1, 2], 2^Rational[1, 2], 
       2.1000000000000005`}}, {{-1.4142135623730951`, 1.4142135623730951`, 
     1.8000000000000007`}, {-1.618033988749895, 1.1755705045849463`, 
     1.8000000000000007`}, {-1.618033988749895, 1.1755705045849463`, 
     2.1000000000000005`}, {-1.4142135623730951`, 1.4142135623730951`, 
     2.1000000000000005`}}]], 
   Polygon3DBox[
    NCache[{{-2^Rational[1, 2], 2^Rational[1, 2], 2.1000000000000005`}, {
      Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       2.1000000000000005`}, {
      Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       2.4000000000000004`}, {-2^Rational[1, 2], 2^Rational[1, 2], 
       2.4000000000000004`}}, {{-1.4142135623730951`, 1.4142135623730951`, 
     2.1000000000000005`}, {-1.618033988749895, 1.1755705045849463`, 
     2.1000000000000005`}, {-1.618033988749895, 1.1755705045849463`, 
     2.4000000000000004`}, {-1.4142135623730951`, 1.4142135623730951`, 
     2.4000000000000004`}}]], 
   Polygon3DBox[
    NCache[{{-2^Rational[1, 2], 2^Rational[1, 2], 2.400000000000001}, {
      Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       2.400000000000001}, {
      Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       2.700000000000001}, {-2^Rational[1, 2], 2^Rational[1, 2], 
       2.700000000000001}}, {{-1.4142135623730951`, 1.4142135623730951`, 
     2.400000000000001}, {-1.618033988749895, 1.1755705045849463`, 
     2.400000000000001}, {-1.618033988749895, 1.1755705045849463`, 
     2.700000000000001}, {-1.4142135623730951`, 1.4142135623730951`, 
     2.700000000000001}}]], 
   Polygon3DBox[
    NCache[{{-2^Rational[1, 2], 2^Rational[1, 2], 2.700000000000001}, {
      Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       2.700000000000001}, {
      Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       3.000000000000001}, {-2^Rational[1, 2], 2^Rational[1, 2], 
       3.000000000000001}}, {{-1.4142135623730951`, 1.4142135623730951`, 
     2.700000000000001}, {-1.618033988749895, 1.1755705045849463`, 
     2.700000000000001}, {-1.618033988749895, 1.1755705045849463`, 
     3.000000000000001}, {-1.4142135623730951`, 1.4142135623730951`, 
     3.000000000000001}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -3.}, {(-2) Cos[Rational[3, 20] Pi], 2 
       Sin[Rational[3, 20] Pi], -3.}, {(-2) Cos[Rational[3, 20] Pi], 2 
       Sin[Rational[3, 20] Pi], -2.7}, {
      Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -2.7}}, {{-1.618033988749895, 
     1.1755705045849463`, -3.}, {-1.7820130483767358`, 
     0.9079809994790936, -3.}, {-1.7820130483767358`, 
     0.9079809994790936, -2.7}, {-1.618033988749895, 
     1.1755705045849463`, -2.7}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -2.7}, {(-2) Cos[Rational[3, 20] Pi], 2 
       Sin[Rational[3, 20] Pi], -2.7}, {(-2) Cos[Rational[3, 20] Pi], 2 
       Sin[Rational[3, 20] Pi], -2.4000000000000004`}, {
      Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -2.4000000000000004`}}, {{-1.618033988749895, 
     1.1755705045849463`, -2.7}, {-1.7820130483767358`, 
     0.9079809994790936, -2.7}, {-1.7820130483767358`, 
     0.9079809994790936, -2.4000000000000004`}, {-1.618033988749895, 
     1.1755705045849463`, -2.4000000000000004`}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -2.4}, {(-2) Cos[Rational[3, 20] Pi], 2 
       Sin[Rational[3, 20] Pi], -2.4}, {(-2) Cos[Rational[3, 20] Pi], 2 
       Sin[Rational[3, 20] Pi], -2.0999999999999996`}, {
      Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -2.0999999999999996`}}, {{-1.618033988749895, 
     1.1755705045849463`, -2.4}, {-1.7820130483767358`, 
     0.9079809994790936, -2.4}, {-1.7820130483767358`, 
     0.9079809994790936, -2.0999999999999996`}, {-1.618033988749895, 
     1.1755705045849463`, -2.0999999999999996`}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -2.0999999999999996`}, {(-2) Cos[Rational[3, 20] Pi], 
       2 Sin[Rational[3, 20] Pi], -2.0999999999999996`}, {(-2) 
       Cos[Rational[3, 20] Pi], 2 
       Sin[Rational[3, 20] Pi], -1.7999999999999996`}, {
      Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -1.7999999999999996`}}, {{-1.618033988749895, 
     1.1755705045849463`, -2.0999999999999996`}, {-1.7820130483767358`, 
     0.9079809994790936, -2.0999999999999996`}, {-1.7820130483767358`, 
     0.9079809994790936, -1.7999999999999996`}, {-1.618033988749895, 
     1.1755705045849463`, -1.7999999999999996`}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -1.7999999999999998`}, {(-2) Cos[Rational[3, 20] Pi], 
       2 Sin[Rational[3, 20] Pi], -1.7999999999999998`}, {(-2) 
       Cos[Rational[3, 20] Pi], 2 
       Sin[Rational[3, 20] Pi], -1.4999999999999998`}, {
      Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -1.4999999999999998`}}, {{-1.618033988749895, 
     1.1755705045849463`, -1.7999999999999998`}, {-1.7820130483767358`, 
     0.9079809994790936, -1.7999999999999998`}, {-1.7820130483767358`, 
     0.9079809994790936, -1.4999999999999998`}, {-1.618033988749895, 
     1.1755705045849463`, -1.4999999999999998`}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -1.4999999999999998`}, {(-2) Cos[Rational[3, 20] Pi], 
       2 Sin[Rational[3, 20] Pi], -1.4999999999999998`}, {(-2) 
       Cos[Rational[3, 20] Pi], 2 
       Sin[Rational[3, 20] Pi], -1.1999999999999997`}, {
      Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -1.1999999999999997`}}, {{-1.618033988749895, 
     1.1755705045849463`, -1.4999999999999998`}, {-1.7820130483767358`, 
     0.9079809994790936, -1.4999999999999998`}, {-1.7820130483767358`, 
     0.9079809994790936, -1.1999999999999997`}, {-1.618033988749895, 
     1.1755705045849463`, -1.1999999999999997`}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -1.1999999999999997`}, {(-2) Cos[Rational[3, 20] Pi], 
       2 Sin[Rational[3, 20] Pi], -1.1999999999999997`}, {(-2) 
       Cos[Rational[3, 20] Pi], 2 
       Sin[Rational[3, 20] Pi], -0.8999999999999997}, {
      Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -0.8999999999999997}}, {{-1.618033988749895, 
     1.1755705045849463`, -1.1999999999999997`}, {-1.7820130483767358`, 
     0.9079809994790936, -1.1999999999999997`}, {-1.7820130483767358`, 
     0.9079809994790936, -0.8999999999999997}, {-1.618033988749895, 
     1.1755705045849463`, -0.8999999999999997}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -0.8999999999999997}, {(-2) Cos[Rational[3, 20] Pi], 
       2 Sin[Rational[3, 20] Pi], -0.8999999999999997}, {(-2) 
       Cos[Rational[3, 20] Pi], 2 
       Sin[Rational[3, 20] Pi], -0.5999999999999996}, {
      Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -0.5999999999999996}}, {{-1.618033988749895, 
     1.1755705045849463`, -0.8999999999999997}, {-1.7820130483767358`, 
     0.9079809994790936, -0.8999999999999997}, {-1.7820130483767358`, 
     0.9079809994790936, -0.5999999999999996}, {-1.618033988749895, 
     1.1755705045849463`, -0.5999999999999996}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -0.5999999999999996}, {(-2) Cos[Rational[3, 20] Pi], 
       2 Sin[Rational[3, 20] Pi], -0.5999999999999996}, {(-2) 
       Cos[Rational[3, 20] Pi], 2 
       Sin[Rational[3, 20] Pi], -0.2999999999999996}, {
      Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -0.2999999999999996}}, {{-1.618033988749895, 
     1.1755705045849463`, -0.5999999999999996}, {-1.7820130483767358`, 
     0.9079809994790936, -0.5999999999999996}, {-1.7820130483767358`, 
     0.9079809994790936, -0.2999999999999996}, {-1.618033988749895, 
     1.1755705045849463`, -0.2999999999999996}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -0.2999999999999996}, {(-2) Cos[Rational[3, 20] Pi], 
       2 Sin[Rational[3, 20] Pi], -0.2999999999999996}, {(-2) 
       Cos[Rational[3, 20] Pi], 2 Sin[Rational[3, 20] Pi], 
       4.440892098500626*^-16}, {
      Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       4.440892098500626*^-16}}, {{-1.618033988749895, 
     1.1755705045849463`, -0.2999999999999996}, {-1.7820130483767358`, 
     0.9079809994790936, -0.2999999999999996}, {-1.7820130483767358`, 
     0.9079809994790936, 4.440892098500626*^-16}, {-1.618033988749895, 
     1.1755705045849463`, 4.440892098500626*^-16}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       4.440892098500626*^-16}, {(-2) Cos[Rational[3, 20] Pi], 2 
       Sin[Rational[3, 20] Pi], 4.440892098500626*^-16}, {(-2) 
       Cos[Rational[3, 20] Pi], 2 Sin[Rational[3, 20] Pi], 
       0.3000000000000005}, {
      Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       0.3000000000000005}}, {{-1.618033988749895, 1.1755705045849463`, 
     4.440892098500626*^-16}, {-1.7820130483767358`, 0.9079809994790936, 
     4.440892098500626*^-16}, {-1.7820130483767358`, 0.9079809994790936, 
     0.3000000000000005}, {-1.618033988749895, 1.1755705045849463`, 
     0.3000000000000005}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       0.3000000000000005}, {(-2) Cos[Rational[3, 20] Pi], 2 
       Sin[Rational[3, 20] Pi], 0.3000000000000005}, {(-2) 
       Cos[Rational[3, 20] Pi], 2 Sin[Rational[3, 20] Pi], 
       0.6000000000000005}, {
      Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       0.6000000000000005}}, {{-1.618033988749895, 1.1755705045849463`, 
     0.3000000000000005}, {-1.7820130483767358`, 0.9079809994790936, 
     0.3000000000000005}, {-1.7820130483767358`, 0.9079809994790936, 
     0.6000000000000005}, {-1.618033988749895, 1.1755705045849463`, 
     0.6000000000000005}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       0.6000000000000005}, {(-2) Cos[Rational[3, 20] Pi], 2 
       Sin[Rational[3, 20] Pi], 0.6000000000000005}, {(-2) 
       Cos[Rational[3, 20] Pi], 2 Sin[Rational[3, 20] Pi], 
       0.9000000000000006}, {
      Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       0.9000000000000006}}, {{-1.618033988749895, 1.1755705045849463`, 
     0.6000000000000005}, {-1.7820130483767358`, 0.9079809994790936, 
     0.6000000000000005}, {-1.7820130483767358`, 0.9079809994790936, 
     0.9000000000000006}, {-1.618033988749895, 1.1755705045849463`, 
     0.9000000000000006}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       0.9000000000000006}, {(-2) Cos[Rational[3, 20] Pi], 2 
       Sin[Rational[3, 20] Pi], 0.9000000000000006}, {(-2) 
       Cos[Rational[3, 20] Pi], 2 Sin[Rational[3, 20] Pi], 
       1.2000000000000006`}, {
      Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       1.2000000000000006`}}, {{-1.618033988749895, 1.1755705045849463`, 
     0.9000000000000006}, {-1.7820130483767358`, 0.9079809994790936, 
     0.9000000000000006}, {-1.7820130483767358`, 0.9079809994790936, 
     1.2000000000000006`}, {-1.618033988749895, 1.1755705045849463`, 
     1.2000000000000006`}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       1.2000000000000006`}, {(-2) Cos[Rational[3, 20] Pi], 2 
       Sin[Rational[3, 20] Pi], 1.2000000000000006`}, {(-2) 
       Cos[Rational[3, 20] Pi], 2 Sin[Rational[3, 20] Pi], 
       1.5000000000000007`}, {
      Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       1.5000000000000007`}}, {{-1.618033988749895, 1.1755705045849463`, 
     1.2000000000000006`}, {-1.7820130483767358`, 0.9079809994790936, 
     1.2000000000000006`}, {-1.7820130483767358`, 0.9079809994790936, 
     1.5000000000000007`}, {-1.618033988749895, 1.1755705045849463`, 
     1.5000000000000007`}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       1.5000000000000007`}, {(-2) Cos[Rational[3, 20] Pi], 2 
       Sin[Rational[3, 20] Pi], 1.5000000000000007`}, {(-2) 
       Cos[Rational[3, 20] Pi], 2 Sin[Rational[3, 20] Pi], 
       1.8000000000000007`}, {
      Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       1.8000000000000007`}}, {{-1.618033988749895, 1.1755705045849463`, 
     1.5000000000000007`}, {-1.7820130483767358`, 0.9079809994790936, 
     1.5000000000000007`}, {-1.7820130483767358`, 0.9079809994790936, 
     1.8000000000000007`}, {-1.618033988749895, 1.1755705045849463`, 
     1.8000000000000007`}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       1.8000000000000007`}, {(-2) Cos[Rational[3, 20] Pi], 2 
       Sin[Rational[3, 20] Pi], 1.8000000000000007`}, {(-2) 
       Cos[Rational[3, 20] Pi], 2 Sin[Rational[3, 20] Pi], 
       2.1000000000000005`}, {
      Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       2.1000000000000005`}}, {{-1.618033988749895, 1.1755705045849463`, 
     1.8000000000000007`}, {-1.7820130483767358`, 0.9079809994790936, 
     1.8000000000000007`}, {-1.7820130483767358`, 0.9079809994790936, 
     2.1000000000000005`}, {-1.618033988749895, 1.1755705045849463`, 
     2.1000000000000005`}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       2.1000000000000005`}, {(-2) Cos[Rational[3, 20] Pi], 2 
       Sin[Rational[3, 20] Pi], 2.1000000000000005`}, {(-2) 
       Cos[Rational[3, 20] Pi], 2 Sin[Rational[3, 20] Pi], 
       2.4000000000000004`}, {
      Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       2.4000000000000004`}}, {{-1.618033988749895, 1.1755705045849463`, 
     2.1000000000000005`}, {-1.7820130483767358`, 0.9079809994790936, 
     2.1000000000000005`}, {-1.7820130483767358`, 0.9079809994790936, 
     2.4000000000000004`}, {-1.618033988749895, 1.1755705045849463`, 
     2.4000000000000004`}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       2.400000000000001}, {(-2) Cos[Rational[3, 20] Pi], 2 
       Sin[Rational[3, 20] Pi], 2.400000000000001}, {(-2) 
       Cos[Rational[3, 20] Pi], 2 Sin[Rational[3, 20] Pi], 
       2.700000000000001}, {
      Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       2.700000000000001}}, {{-1.618033988749895, 1.1755705045849463`, 
     2.400000000000001}, {-1.7820130483767358`, 0.9079809994790936, 
     2.400000000000001}, {-1.7820130483767358`, 0.9079809994790936, 
     2.700000000000001}, {-1.618033988749895, 1.1755705045849463`, 
     2.700000000000001}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       2.700000000000001}, {(-2) Cos[Rational[3, 20] Pi], 2 
       Sin[Rational[3, 20] Pi], 2.700000000000001}, {(-2) 
       Cos[Rational[3, 20] Pi], 2 Sin[Rational[3, 20] Pi], 
       3.000000000000001}, {
      Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       3.000000000000001}}, {{-1.618033988749895, 1.1755705045849463`, 
     2.700000000000001}, {-1.7820130483767358`, 0.9079809994790936, 
     2.700000000000001}, {-1.7820130483767358`, 0.9079809994790936, 
     3.000000000000001}, {-1.618033988749895, 1.1755705045849463`, 
     3.000000000000001}}]], 
   Polygon3DBox[
    NCache[{{(-2) Cos[Rational[3, 20] Pi], 2 
       Sin[Rational[3, 20] Pi], -3.}, {(-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 + 
        5^Rational[1, 2]), -3.}, {(-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 + 5^Rational[1, 2]), -2.7}, {(-2) 
       Cos[Rational[3, 20] Pi], 2 
       Sin[Rational[3, 20] Pi], -2.7}}, {{-1.7820130483767358`, 
     0.9079809994790936, -3.}, {-1.902113032590307, 
     0.6180339887498949, -3.}, {-1.902113032590307, 
     0.6180339887498949, -2.7}, {-1.7820130483767358`, 
     0.9079809994790936, -2.7}}]], 
   Polygon3DBox[
    NCache[{{(-2) Cos[Rational[3, 20] Pi], 2 
       Sin[Rational[3, 20] Pi], -2.7}, {(-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 + 
        5^Rational[1, 2]), -2.7}, {(-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 + 5^Rational[1, 2]), -2.4000000000000004`}, {(-2) 
       Cos[Rational[3, 20] Pi], 2 
       Sin[Rational[3, 20] 
         Pi], -2.4000000000000004`}}, {{-1.7820130483767358`, 
     0.9079809994790936, -2.7}, {-1.902113032590307, 
     0.6180339887498949, -2.7}, {-1.902113032590307, 
     0.6180339887498949, -2.4000000000000004`}, {-1.7820130483767358`, 
     0.9079809994790936, -2.4000000000000004`}}]], 
   Polygon3DBox[
    NCache[{{(-2) Cos[Rational[3, 20] Pi], 2 
       Sin[Rational[3, 20] Pi], -2.4}, {(-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 + 
        5^Rational[1, 2]), -2.4}, {(-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 + 5^Rational[1, 2]), -2.0999999999999996`}, {(-2) 
       Cos[Rational[3, 20] Pi], 2 
       Sin[Rational[3, 20] 
         Pi], -2.0999999999999996`}}, {{-1.7820130483767358`, 
     0.9079809994790936, -2.4}, {-1.902113032590307, 
     0.6180339887498949, -2.4}, {-1.902113032590307, 
     0.6180339887498949, -2.0999999999999996`}, {-1.7820130483767358`, 
     0.9079809994790936, -2.0999999999999996`}}]], 
   Polygon3DBox[
    NCache[{{(-2) Cos[Rational[3, 20] Pi], 2 
       Sin[Rational[3, 20] Pi], -2.0999999999999996`}, {(-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 + 
        5^Rational[1, 2]), -2.0999999999999996`}, {(-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 + 5^Rational[1, 2]), -1.7999999999999996`}, {(-2) 
       Cos[Rational[3, 20] Pi], 2 
       Sin[Rational[3, 20] 
         Pi], -1.7999999999999996`}}, {{-1.7820130483767358`, 
     0.9079809994790936, -2.0999999999999996`}, {-1.902113032590307, 
     0.6180339887498949, -2.0999999999999996`}, {-1.902113032590307, 
     0.6180339887498949, -1.7999999999999996`}, {-1.7820130483767358`, 
     0.9079809994790936, -1.7999999999999996`}}]], 
   Polygon3DBox[
    NCache[{{(-2) Cos[Rational[3, 20] Pi], 2 
       Sin[Rational[3, 20] Pi], -1.7999999999999998`}, {(-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 + 
        5^Rational[1, 2]), -1.7999999999999998`}, {(-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 + 5^Rational[1, 2]), -1.4999999999999998`}, {(-2) 
       Cos[Rational[3, 20] Pi], 2 
       Sin[Rational[3, 20] 
         Pi], -1.4999999999999998`}}, {{-1.7820130483767358`, 
     0.9079809994790936, -1.7999999999999998`}, {-1.902113032590307, 
     0.6180339887498949, -1.7999999999999998`}, {-1.902113032590307, 
     0.6180339887498949, -1.4999999999999998`}, {-1.7820130483767358`, 
     0.9079809994790936, -1.4999999999999998`}}]], 
   Polygon3DBox[
    NCache[{{(-2) Cos[Rational[3, 20] Pi], 2 
       Sin[Rational[3, 20] Pi], -1.4999999999999998`}, {(-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 + 
        5^Rational[1, 2]), -1.4999999999999998`}, {(-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 + 5^Rational[1, 2]), -1.1999999999999997`}, {(-2) 
       Cos[Rational[3, 20] Pi], 2 
       Sin[Rational[3, 20] 
         Pi], -1.1999999999999997`}}, {{-1.7820130483767358`, 
     0.9079809994790936, -1.4999999999999998`}, {-1.902113032590307, 
     0.6180339887498949, -1.4999999999999998`}, {-1.902113032590307, 
     0.6180339887498949, -1.1999999999999997`}, {-1.7820130483767358`, 
     0.9079809994790936, -1.1999999999999997`}}]], 
   Polygon3DBox[
    NCache[{{(-2) Cos[Rational[3, 20] Pi], 2 
       Sin[Rational[3, 20] Pi], -1.1999999999999997`}, {(-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 + 
        5^Rational[1, 2]), -1.1999999999999997`}, {(-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 + 5^Rational[1, 2]), -0.8999999999999997}, {(-2) 
       Cos[Rational[3, 20] Pi], 2 
       Sin[Rational[3, 20] Pi], -0.8999999999999997}}, {{-1.7820130483767358`,
      0.9079809994790936, -1.1999999999999997`}, {-1.902113032590307, 
     0.6180339887498949, -1.1999999999999997`}, {-1.902113032590307, 
     0.6180339887498949, -0.8999999999999997}, {-1.7820130483767358`, 
     0.9079809994790936, -0.8999999999999997}}]], 
   Polygon3DBox[
    NCache[{{(-2) Cos[Rational[3, 20] Pi], 2 
       Sin[Rational[3, 20] Pi], -0.8999999999999997}, {(-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 + 
        5^Rational[1, 2]), -0.8999999999999997}, {(-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 + 5^Rational[1, 2]), -0.5999999999999996}, {(-2) 
       Cos[Rational[3, 20] Pi], 2 
       Sin[Rational[3, 20] Pi], -0.5999999999999996}}, {{-1.7820130483767358`,
      0.9079809994790936, -0.8999999999999997}, {-1.902113032590307, 
     0.6180339887498949, -0.8999999999999997}, {-1.902113032590307, 
     0.6180339887498949, -0.5999999999999996}, {-1.7820130483767358`, 
     0.9079809994790936, -0.5999999999999996}}]], 
   Polygon3DBox[
    NCache[{{(-2) Cos[Rational[3, 20] Pi], 2 
       Sin[Rational[3, 20] Pi], -0.5999999999999996}, {(-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 + 
        5^Rational[1, 2]), -0.5999999999999996}, {(-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 + 5^Rational[1, 2]), -0.2999999999999996}, {(-2) 
       Cos[Rational[3, 20] Pi], 2 
       Sin[Rational[3, 20] Pi], -0.2999999999999996}}, {{-1.7820130483767358`,
      0.9079809994790936, -0.5999999999999996}, {-1.902113032590307, 
     0.6180339887498949, -0.5999999999999996}, {-1.902113032590307, 
     0.6180339887498949, -0.2999999999999996}, {-1.7820130483767358`, 
     0.9079809994790936, -0.2999999999999996}}]], 
   Polygon3DBox[
    NCache[{{(-2) Cos[Rational[3, 20] Pi], 2 
       Sin[Rational[3, 20] Pi], -0.2999999999999996}, {(-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 + 
        5^Rational[1, 2]), -0.2999999999999996}, {(-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 + 5^Rational[1, 2]), 4.440892098500626*^-16}, {(-2) 
       Cos[Rational[3, 20] Pi], 2 Sin[Rational[3, 20] Pi], 
       4.440892098500626*^-16}}, {{-1.7820130483767358`, 
     0.9079809994790936, -0.2999999999999996}, {-1.902113032590307, 
     0.6180339887498949, -0.2999999999999996}, {-1.902113032590307, 
     0.6180339887498949, 4.440892098500626*^-16}, {-1.7820130483767358`, 
     0.9079809994790936, 4.440892098500626*^-16}}]], 
   Polygon3DBox[
    NCache[{{(-2) Cos[Rational[3, 20] Pi], 2 Sin[Rational[3, 20] Pi], 
       4.440892098500626*^-16}, {(-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 + 5^Rational[1, 2]), 
       4.440892098500626*^-16}, {(-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 + 5^Rational[1, 2]), 0.3000000000000005}, {(-2) 
       Cos[Rational[3, 20] Pi], 2 Sin[Rational[3, 20] Pi], 
       0.3000000000000005}}, {{-1.7820130483767358`, 0.9079809994790936, 
     4.440892098500626*^-16}, {-1.902113032590307, 0.6180339887498949, 
     4.440892098500626*^-16}, {-1.902113032590307, 0.6180339887498949, 
     0.3000000000000005}, {-1.7820130483767358`, 0.9079809994790936, 
     0.3000000000000005}}]], 
   Polygon3DBox[
    NCache[{{(-2) Cos[Rational[3, 20] Pi], 2 Sin[Rational[3, 20] Pi], 
       0.3000000000000005}, {(-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 + 5^Rational[1, 2]), 
       0.3000000000000005}, {(-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 + 5^Rational[1, 2]), 0.6000000000000005}, {(-2) 
       Cos[Rational[3, 20] Pi], 2 Sin[Rational[3, 20] Pi], 
       0.6000000000000005}}, {{-1.7820130483767358`, 0.9079809994790936, 
     0.3000000000000005}, {-1.902113032590307, 0.6180339887498949, 
     0.3000000000000005}, {-1.902113032590307, 0.6180339887498949, 
     0.6000000000000005}, {-1.7820130483767358`, 0.9079809994790936, 
     0.6000000000000005}}]], 
   Polygon3DBox[
    NCache[{{(-2) Cos[Rational[3, 20] Pi], 2 Sin[Rational[3, 20] Pi], 
       0.6000000000000005}, {(-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 + 5^Rational[1, 2]), 
       0.6000000000000005}, {(-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 + 5^Rational[1, 2]), 0.9000000000000006}, {(-2) 
       Cos[Rational[3, 20] Pi], 2 Sin[Rational[3, 20] Pi], 
       0.9000000000000006}}, {{-1.7820130483767358`, 0.9079809994790936, 
     0.6000000000000005}, {-1.902113032590307, 0.6180339887498949, 
     0.6000000000000005}, {-1.902113032590307, 0.6180339887498949, 
     0.9000000000000006}, {-1.7820130483767358`, 0.9079809994790936, 
     0.9000000000000006}}]], 
   Polygon3DBox[
    NCache[{{(-2) Cos[Rational[3, 20] Pi], 2 Sin[Rational[3, 20] Pi], 
       0.9000000000000006}, {(-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 + 5^Rational[1, 2]), 
       0.9000000000000006}, {(-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 + 5^Rational[1, 2]), 1.2000000000000006`}, {(-2) 
       Cos[Rational[3, 20] Pi], 2 Sin[Rational[3, 20] Pi], 
       1.2000000000000006`}}, {{-1.7820130483767358`, 0.9079809994790936, 
     0.9000000000000006}, {-1.902113032590307, 0.6180339887498949, 
     0.9000000000000006}, {-1.902113032590307, 0.6180339887498949, 
     1.2000000000000006`}, {-1.7820130483767358`, 0.9079809994790936, 
     1.2000000000000006`}}]], 
   Polygon3DBox[
    NCache[{{(-2) Cos[Rational[3, 20] Pi], 2 Sin[Rational[3, 20] Pi], 
       1.2000000000000006`}, {(-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 + 5^Rational[1, 2]), 
       1.2000000000000006`}, {(-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 + 5^Rational[1, 2]), 1.5000000000000007`}, {(-2) 
       Cos[Rational[3, 20] Pi], 2 Sin[Rational[3, 20] Pi], 
       1.5000000000000007`}}, {{-1.7820130483767358`, 0.9079809994790936, 
     1.2000000000000006`}, {-1.902113032590307, 0.6180339887498949, 
     1.2000000000000006`}, {-1.902113032590307, 0.6180339887498949, 
     1.5000000000000007`}, {-1.7820130483767358`, 0.9079809994790936, 
     1.5000000000000007`}}]], 
   Polygon3DBox[
    NCache[{{(-2) Cos[Rational[3, 20] Pi], 2 Sin[Rational[3, 20] Pi], 
       1.5000000000000007`}, {(-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 + 5^Rational[1, 2]), 
       1.5000000000000007`}, {(-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 + 5^Rational[1, 2]), 1.8000000000000007`}, {(-2) 
       Cos[Rational[3, 20] Pi], 2 Sin[Rational[3, 20] Pi], 
       1.8000000000000007`}}, {{-1.7820130483767358`, 0.9079809994790936, 
     1.5000000000000007`}, {-1.902113032590307, 0.6180339887498949, 
     1.5000000000000007`}, {-1.902113032590307, 0.6180339887498949, 
     1.8000000000000007`}, {-1.7820130483767358`, 0.9079809994790936, 
     1.8000000000000007`}}]], 
   Polygon3DBox[
    NCache[{{(-2) Cos[Rational[3, 20] Pi], 2 Sin[Rational[3, 20] Pi], 
       1.8000000000000007`}, {(-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 + 5^Rational[1, 2]), 
       1.8000000000000007`}, {(-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 + 5^Rational[1, 2]), 2.1000000000000005`}, {(-2) 
       Cos[Rational[3, 20] Pi], 2 Sin[Rational[3, 20] Pi], 
       2.1000000000000005`}}, {{-1.7820130483767358`, 0.9079809994790936, 
     1.8000000000000007`}, {-1.902113032590307, 0.6180339887498949, 
     1.8000000000000007`}, {-1.902113032590307, 0.6180339887498949, 
     2.1000000000000005`}, {-1.7820130483767358`, 0.9079809994790936, 
     2.1000000000000005`}}]], 
   Polygon3DBox[
    NCache[{{(-2) Cos[Rational[3, 20] Pi], 2 Sin[Rational[3, 20] Pi], 
       2.1000000000000005`}, {(-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 + 5^Rational[1, 2]), 
       2.1000000000000005`}, {(-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 + 5^Rational[1, 2]), 2.4000000000000004`}, {(-2) 
       Cos[Rational[3, 20] Pi], 2 Sin[Rational[3, 20] Pi], 
       2.4000000000000004`}}, {{-1.7820130483767358`, 0.9079809994790936, 
     2.1000000000000005`}, {-1.902113032590307, 0.6180339887498949, 
     2.1000000000000005`}, {-1.902113032590307, 0.6180339887498949, 
     2.4000000000000004`}, {-1.7820130483767358`, 0.9079809994790936, 
     2.4000000000000004`}}]], 
   Polygon3DBox[
    NCache[{{(-2) Cos[Rational[3, 20] Pi], 2 Sin[Rational[3, 20] Pi], 
       2.400000000000001}, {(-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 + 5^Rational[1, 2]), 
       2.400000000000001}, {(-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 + 5^Rational[1, 2]), 2.700000000000001}, {(-2) 
       Cos[Rational[3, 20] Pi], 2 Sin[Rational[3, 20] Pi], 
       2.700000000000001}}, {{-1.7820130483767358`, 0.9079809994790936, 
     2.400000000000001}, {-1.902113032590307, 0.6180339887498949, 
     2.400000000000001}, {-1.902113032590307, 0.6180339887498949, 
     2.700000000000001}, {-1.7820130483767358`, 0.9079809994790936, 
     2.700000000000001}}]], 
   Polygon3DBox[
    NCache[{{(-2) Cos[Rational[3, 20] Pi], 2 Sin[Rational[3, 20] Pi], 
       2.700000000000001}, {(-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 + 5^Rational[1, 2]), 
       2.700000000000001}, {(-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 + 5^Rational[1, 2]), 3.000000000000001}, {(-2) 
       Cos[Rational[3, 20] Pi], 2 Sin[Rational[3, 20] Pi], 
       3.000000000000001}}, {{-1.7820130483767358`, 0.9079809994790936, 
     2.700000000000001}, {-1.902113032590307, 0.6180339887498949, 
     2.700000000000001}, {-1.902113032590307, 0.6180339887498949, 
     3.000000000000001}, {-1.7820130483767358`, 0.9079809994790936, 
     3.000000000000001}}]], 
   Polygon3DBox[
    NCache[{{(-2) (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 2] (-1 + 5^Rational[1, 2]), -3.}, {(-2) 
       Cos[Rational[1, 20] Pi], 2 Sin[Rational[1, 20] Pi], -3.}, {(-2) 
       Cos[Rational[1, 20] Pi], 2 
       Sin[Rational[1, 20] Pi], -2.7}, {(-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 + 5^Rational[1, 2]), -2.7}}, {{-1.902113032590307, 
     0.6180339887498949, -3.}, {-1.9753766811902755`, 
     0.31286893008046174`, -3.}, {-1.9753766811902755`, 
     0.31286893008046174`, -2.7}, {-1.902113032590307, 
     0.6180339887498949, -2.7}}]], 
   Polygon3DBox[
    NCache[{{(-2) (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 2] (-1 + 5^Rational[1, 2]), -2.7}, {(-2) 
       Cos[Rational[1, 20] Pi], 2 Sin[Rational[1, 20] Pi], -2.7}, {(-2) 
       Cos[Rational[1, 20] Pi], 2 
       Sin[Rational[1, 20] Pi], -2.4000000000000004`}, {(-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 + 
        5^Rational[1, 2]), -2.4000000000000004`}}, {{-1.902113032590307, 
     0.6180339887498949, -2.7}, {-1.9753766811902755`, 
     0.31286893008046174`, -2.7}, {-1.9753766811902755`, 
     0.31286893008046174`, -2.4000000000000004`}, {-1.902113032590307, 
     0.6180339887498949, -2.4000000000000004`}}]], 
   Polygon3DBox[
    NCache[{{(-2) (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 2] (-1 + 5^Rational[1, 2]), -2.4}, {(-2) 
       Cos[Rational[1, 20] Pi], 2 Sin[Rational[1, 20] Pi], -2.4}, {(-2) 
       Cos[Rational[1, 20] Pi], 2 
       Sin[Rational[1, 20] Pi], -2.0999999999999996`}, {(-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 + 
        5^Rational[1, 2]), -2.0999999999999996`}}, {{-1.902113032590307, 
     0.6180339887498949, -2.4}, {-1.9753766811902755`, 
     0.31286893008046174`, -2.4}, {-1.9753766811902755`, 
     0.31286893008046174`, -2.0999999999999996`}, {-1.902113032590307, 
     0.6180339887498949, -2.0999999999999996`}}]], 
   Polygon3DBox[
    NCache[{{(-2) (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], 
       Rational[1, 2] (-1 + 5^Rational[1, 2]), -2.0999999999999996`}, {(-2) 
       Cos[Rational[1, 20] Pi], 2 
       Sin[Rational[1, 20] Pi], -2.0999999999999996`}, {(-2) 
       Cos[Rational[1, 20] Pi], 2 
       Sin[Rational[1, 20] Pi], -1.7999999999999996`}, {(-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 + 
        5^Rational[1, 2]), -1.7999999999999996`}}, {{-1.902113032590307, 
     0.6180339887498949, -2.0999999999999996`}, {-1.9753766811902755`, 
     0.31286893008046174`, -2.0999999999999996`}, {-1.9753766811902755`, 
     0.31286893008046174`, -1.7999999999999996`}, {-1.902113032590307, 
     0.6180339887498949, -1.7999999999999996`}}]], 
   Polygon3DBox[
    NCache[{{(-2) (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], 
       Rational[1, 2] (-1 + 5^Rational[1, 2]), -1.7999999999999998`}, {(-2) 
       Cos[Rational[1, 20] Pi], 2 
       Sin[Rational[1, 20] Pi], -1.7999999999999998`}, {(-2) 
       Cos[Rational[1, 20] Pi], 2 
       Sin[Rational[1, 20] Pi], -1.4999999999999998`}, {(-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 + 
        5^Rational[1, 2]), -1.4999999999999998`}}, {{-1.902113032590307, 
     0.6180339887498949, -1.7999999999999998`}, {-1.9753766811902755`, 
     0.31286893008046174`, -1.7999999999999998`}, {-1.9753766811902755`, 
     0.31286893008046174`, -1.4999999999999998`}, {-1.902113032590307, 
     0.6180339887498949, -1.4999999999999998`}}]], 
   Polygon3DBox[
    NCache[{{(-2) (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], 
       Rational[1, 2] (-1 + 5^Rational[1, 2]), -1.4999999999999998`}, {(-2) 
       Cos[Rational[1, 20] Pi], 2 
       Sin[Rational[1, 20] Pi], -1.4999999999999998`}, {(-2) 
       Cos[Rational[1, 20] Pi], 2 
       Sin[Rational[1, 20] Pi], -1.1999999999999997`}, {(-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 + 
        5^Rational[1, 2]), -1.1999999999999997`}}, {{-1.902113032590307, 
     0.6180339887498949, -1.4999999999999998`}, {-1.9753766811902755`, 
     0.31286893008046174`, -1.4999999999999998`}, {-1.9753766811902755`, 
     0.31286893008046174`, -1.1999999999999997`}, {-1.902113032590307, 
     0.6180339887498949, -1.1999999999999997`}}]], 
   Polygon3DBox[
    NCache[{{(-2) (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], 
       Rational[1, 2] (-1 + 5^Rational[1, 2]), -1.1999999999999997`}, {(-2) 
       Cos[Rational[1, 20] Pi], 2 
       Sin[Rational[1, 20] Pi], -1.1999999999999997`}, {(-2) 
       Cos[Rational[1, 20] Pi], 2 
       Sin[Rational[1, 20] Pi], -0.8999999999999997}, {(-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 + 
        5^Rational[1, 2]), -0.8999999999999997}}, {{-1.902113032590307, 
     0.6180339887498949, -1.1999999999999997`}, {-1.9753766811902755`, 
     0.31286893008046174`, -1.1999999999999997`}, {-1.9753766811902755`, 
     0.31286893008046174`, -0.8999999999999997}, {-1.902113032590307, 
     0.6180339887498949, -0.8999999999999997}}]], 
   Polygon3DBox[
    NCache[{{(-2) (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], 
       Rational[1, 2] (-1 + 5^Rational[1, 2]), -0.8999999999999997}, {(-2) 
       Cos[Rational[1, 20] Pi], 2 
       Sin[Rational[1, 20] Pi], -0.8999999999999997}, {(-2) 
       Cos[Rational[1, 20] Pi], 2 
       Sin[Rational[1, 20] Pi], -0.5999999999999996}, {(-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 + 
        5^Rational[1, 2]), -0.5999999999999996}}, {{-1.902113032590307, 
     0.6180339887498949, -0.8999999999999997}, {-1.9753766811902755`, 
     0.31286893008046174`, -0.8999999999999997}, {-1.9753766811902755`, 
     0.31286893008046174`, -0.5999999999999996}, {-1.902113032590307, 
     0.6180339887498949, -0.5999999999999996}}]], 
   Polygon3DBox[
    NCache[{{(-2) (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], 
       Rational[1, 2] (-1 + 5^Rational[1, 2]), -0.5999999999999996}, {(-2) 
       Cos[Rational[1, 20] Pi], 2 
       Sin[Rational[1, 20] Pi], -0.5999999999999996}, {(-2) 
       Cos[Rational[1, 20] Pi], 2 
       Sin[Rational[1, 20] Pi], -0.2999999999999996}, {(-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 + 
        5^Rational[1, 2]), -0.2999999999999996}}, {{-1.902113032590307, 
     0.6180339887498949, -0.5999999999999996}, {-1.9753766811902755`, 
     0.31286893008046174`, -0.5999999999999996}, {-1.9753766811902755`, 
     0.31286893008046174`, -0.2999999999999996}, {-1.902113032590307, 
     0.6180339887498949, -0.2999999999999996}}]], 
   Polygon3DBox[
    NCache[{{(-2) (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], 
       Rational[1, 2] (-1 + 5^Rational[1, 2]), -0.2999999999999996}, {(-2) 
       Cos[Rational[1, 20] Pi], 2 
       Sin[Rational[1, 20] Pi], -0.2999999999999996}, {(-2) 
       Cos[Rational[1, 20] Pi], 2 Sin[Rational[1, 20] Pi], 
       4.440892098500626*^-16}, {(-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 + 5^Rational[1, 2]), 
       4.440892098500626*^-16}}, {{-1.902113032590307, 
     0.6180339887498949, -0.2999999999999996}, {-1.9753766811902755`, 
     0.31286893008046174`, -0.2999999999999996}, {-1.9753766811902755`, 
     0.31286893008046174`, 4.440892098500626*^-16}, {-1.902113032590307, 
     0.6180339887498949, 4.440892098500626*^-16}}]], 
   Polygon3DBox[
    NCache[{{(-2) (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 2] (-1 + 5^Rational[1, 2]), 
       4.440892098500626*^-16}, {(-2) Cos[Rational[1, 20] Pi], 2 
       Sin[Rational[1, 20] Pi], 4.440892098500626*^-16}, {(-2) 
       Cos[Rational[1, 20] Pi], 2 Sin[Rational[1, 20] Pi], 
       0.3000000000000005}, {(-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 + 5^Rational[1, 2]), 
       0.3000000000000005}}, {{-1.902113032590307, 0.6180339887498949, 
     4.440892098500626*^-16}, {-1.9753766811902755`, 0.31286893008046174`, 
     4.440892098500626*^-16}, {-1.9753766811902755`, 0.31286893008046174`, 
     0.3000000000000005}, {-1.902113032590307, 0.6180339887498949, 
     0.3000000000000005}}]], 
   Polygon3DBox[
    NCache[{{(-2) (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 2] (-1 + 5^Rational[1, 2]), 
       0.3000000000000005}, {(-2) Cos[Rational[1, 20] Pi], 2 
       Sin[Rational[1, 20] Pi], 0.3000000000000005}, {(-2) 
       Cos[Rational[1, 20] Pi], 2 Sin[Rational[1, 20] Pi], 
       0.6000000000000005}, {(-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 + 5^Rational[1, 2]), 
       0.6000000000000005}}, {{-1.902113032590307, 0.6180339887498949, 
     0.3000000000000005}, {-1.9753766811902755`, 0.31286893008046174`, 
     0.3000000000000005}, {-1.9753766811902755`, 0.31286893008046174`, 
     0.6000000000000005}, {-1.902113032590307, 0.6180339887498949, 
     0.6000000000000005}}]], 
   Polygon3DBox[
    NCache[{{(-2) (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 2] (-1 + 5^Rational[1, 2]), 
       0.6000000000000005}, {(-2) Cos[Rational[1, 20] Pi], 2 
       Sin[Rational[1, 20] Pi], 0.6000000000000005}, {(-2) 
       Cos[Rational[1, 20] Pi], 2 Sin[Rational[1, 20] Pi], 
       0.9000000000000006}, {(-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 + 5^Rational[1, 2]), 
       0.9000000000000006}}, {{-1.902113032590307, 0.6180339887498949, 
     0.6000000000000005}, {-1.9753766811902755`, 0.31286893008046174`, 
     0.6000000000000005}, {-1.9753766811902755`, 0.31286893008046174`, 
     0.9000000000000006}, {-1.902113032590307, 0.6180339887498949, 
     0.9000000000000006}}]], 
   Polygon3DBox[
    NCache[{{(-2) (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 2] (-1 + 5^Rational[1, 2]), 
       0.9000000000000006}, {(-2) Cos[Rational[1, 20] Pi], 2 
       Sin[Rational[1, 20] Pi], 0.9000000000000006}, {(-2) 
       Cos[Rational[1, 20] Pi], 2 Sin[Rational[1, 20] Pi], 
       1.2000000000000006`}, {(-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 + 5^Rational[1, 2]), 
       1.2000000000000006`}}, {{-1.902113032590307, 0.6180339887498949, 
     0.9000000000000006}, {-1.9753766811902755`, 0.31286893008046174`, 
     0.9000000000000006}, {-1.9753766811902755`, 0.31286893008046174`, 
     1.2000000000000006`}, {-1.902113032590307, 0.6180339887498949, 
     1.2000000000000006`}}]], 
   Polygon3DBox[
    NCache[{{(-2) (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 2] (-1 + 5^Rational[1, 2]), 
       1.2000000000000006`}, {(-2) Cos[Rational[1, 20] Pi], 2 
       Sin[Rational[1, 20] Pi], 1.2000000000000006`}, {(-2) 
       Cos[Rational[1, 20] Pi], 2 Sin[Rational[1, 20] Pi], 
       1.5000000000000007`}, {(-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 + 5^Rational[1, 2]), 
       1.5000000000000007`}}, {{-1.902113032590307, 0.6180339887498949, 
     1.2000000000000006`}, {-1.9753766811902755`, 0.31286893008046174`, 
     1.2000000000000006`}, {-1.9753766811902755`, 0.31286893008046174`, 
     1.5000000000000007`}, {-1.902113032590307, 0.6180339887498949, 
     1.5000000000000007`}}]], 
   Polygon3DBox[
    NCache[{{(-2) (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 2] (-1 + 5^Rational[1, 2]), 
       1.5000000000000007`}, {(-2) Cos[Rational[1, 20] Pi], 2 
       Sin[Rational[1, 20] Pi], 1.5000000000000007`}, {(-2) 
       Cos[Rational[1, 20] Pi], 2 Sin[Rational[1, 20] Pi], 
       1.8000000000000007`}, {(-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 + 5^Rational[1, 2]), 
       1.8000000000000007`}}, {{-1.902113032590307, 0.6180339887498949, 
     1.5000000000000007`}, {-1.9753766811902755`, 0.31286893008046174`, 
     1.5000000000000007`}, {-1.9753766811902755`, 0.31286893008046174`, 
     1.8000000000000007`}, {-1.902113032590307, 0.6180339887498949, 
     1.8000000000000007`}}]], 
   Polygon3DBox[
    NCache[{{(-2) (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 2] (-1 + 5^Rational[1, 2]), 
       1.8000000000000007`}, {(-2) Cos[Rational[1, 20] Pi], 2 
       Sin[Rational[1, 20] Pi], 1.8000000000000007`}, {(-2) 
       Cos[Rational[1, 20] Pi], 2 Sin[Rational[1, 20] Pi], 
       2.1000000000000005`}, {(-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 + 5^Rational[1, 2]), 
       2.1000000000000005`}}, {{-1.902113032590307, 0.6180339887498949, 
     1.8000000000000007`}, {-1.9753766811902755`, 0.31286893008046174`, 
     1.8000000000000007`}, {-1.9753766811902755`, 0.31286893008046174`, 
     2.1000000000000005`}, {-1.902113032590307, 0.6180339887498949, 
     2.1000000000000005`}}]], 
   Polygon3DBox[
    NCache[{{(-2) (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 2] (-1 + 5^Rational[1, 2]), 
       2.1000000000000005`}, {(-2) Cos[Rational[1, 20] Pi], 2 
       Sin[Rational[1, 20] Pi], 2.1000000000000005`}, {(-2) 
       Cos[Rational[1, 20] Pi], 2 Sin[Rational[1, 20] Pi], 
       2.4000000000000004`}, {(-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 + 5^Rational[1, 2]), 
       2.4000000000000004`}}, {{-1.902113032590307, 0.6180339887498949, 
     2.1000000000000005`}, {-1.9753766811902755`, 0.31286893008046174`, 
     2.1000000000000005`}, {-1.9753766811902755`, 0.31286893008046174`, 
     2.4000000000000004`}, {-1.902113032590307, 0.6180339887498949, 
     2.4000000000000004`}}]], 
   Polygon3DBox[
    NCache[{{(-2) (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 2] (-1 + 5^Rational[1, 2]), 
       2.400000000000001}, {(-2) Cos[Rational[1, 20] Pi], 2 
       Sin[Rational[1, 20] Pi], 2.400000000000001}, {(-2) 
       Cos[Rational[1, 20] Pi], 2 Sin[Rational[1, 20] Pi], 
       2.700000000000001}, {(-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 + 5^Rational[1, 2]), 
       2.700000000000001}}, {{-1.902113032590307, 0.6180339887498949, 
     2.400000000000001}, {-1.9753766811902755`, 0.31286893008046174`, 
     2.400000000000001}, {-1.9753766811902755`, 0.31286893008046174`, 
     2.700000000000001}, {-1.902113032590307, 0.6180339887498949, 
     2.700000000000001}}]], 
   Polygon3DBox[
    NCache[{{(-2) (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 2] (-1 + 5^Rational[1, 2]), 
       2.700000000000001}, {(-2) Cos[Rational[1, 20] Pi], 2 
       Sin[Rational[1, 20] Pi], 2.700000000000001}, {(-2) 
       Cos[Rational[1, 20] Pi], 2 Sin[Rational[1, 20] Pi], 
       3.000000000000001}, {(-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 + 5^Rational[1, 2]), 
       3.000000000000001}}, {{-1.902113032590307, 0.6180339887498949, 
     2.700000000000001}, {-1.9753766811902755`, 0.31286893008046174`, 
     2.700000000000001}, {-1.9753766811902755`, 0.31286893008046174`, 
     3.000000000000001}, {-1.902113032590307, 0.6180339887498949, 
     3.000000000000001}}]], 
   Polygon3DBox[
    NCache[{{(-2) Cos[Rational[1, 20] Pi], 2 
       Sin[Rational[1, 20] Pi], -3.}, {-2, 0, -3.}, {-2, 0, -2.7}, {(-2) 
       Cos[Rational[1, 20] Pi], 2 
       Sin[Rational[1, 20] Pi], -2.7}}, {{-1.9753766811902755`, 
      0.31286893008046174`, -3.}, {-2, 0, -3.}, {-2, 
       0, -2.7}, {-1.9753766811902755`, 0.31286893008046174`, -2.7}}]], 
   Polygon3DBox[
    NCache[{{(-2) Cos[Rational[1, 20] Pi], 2 
       Sin[Rational[1, 20] Pi], -2.7}, {-2, 0, -2.7}, {-2, 
       0, -2.4000000000000004`}, {(-2) Cos[Rational[1, 20] Pi], 2 
       Sin[Rational[1, 20] 
         Pi], -2.4000000000000004`}}, {{-1.9753766811902755`, 
      0.31286893008046174`, -2.7}, {-2, 0, -2.7}, {-2, 
       0, -2.4000000000000004`}, {-1.9753766811902755`, 
      0.31286893008046174`, -2.4000000000000004`}}]], 
   Polygon3DBox[
    NCache[{{(-2) Cos[Rational[1, 20] Pi], 2 
       Sin[Rational[1, 20] Pi], -2.4}, {-2, 0, -2.4}, {-2, 
       0, -2.0999999999999996`}, {(-2) Cos[Rational[1, 20] Pi], 2 
       Sin[Rational[1, 20] 
         Pi], -2.0999999999999996`}}, {{-1.9753766811902755`, 
      0.31286893008046174`, -2.4}, {-2, 0, -2.4}, {-2, 
       0, -2.0999999999999996`}, {-1.9753766811902755`, 
      0.31286893008046174`, -2.0999999999999996`}}]], 
   Polygon3DBox[
    NCache[{{(-2) Cos[Rational[1, 20] Pi], 2 
       Sin[Rational[1, 20] Pi], -2.0999999999999996`}, {-2, 
       0, -2.0999999999999996`}, {-2, 0, -1.7999999999999996`}, {(-2) 
       Cos[Rational[1, 20] Pi], 2 
       Sin[Rational[1, 20] 
         Pi], -1.7999999999999996`}}, {{-1.9753766811902755`, 
      0.31286893008046174`, -2.0999999999999996`}, {-2, 
       0, -2.0999999999999996`}, {-2, 
       0, -1.7999999999999996`}, {-1.9753766811902755`, 
      0.31286893008046174`, -1.7999999999999996`}}]], 
   Polygon3DBox[
    NCache[{{(-2) Cos[Rational[1, 20] Pi], 2 
       Sin[Rational[1, 20] Pi], -1.7999999999999998`}, {-2, 
       0, -1.7999999999999998`}, {-2, 0, -1.4999999999999998`}, {(-2) 
       Cos[Rational[1, 20] Pi], 2 
       Sin[Rational[1, 20] 
         Pi], -1.4999999999999998`}}, {{-1.9753766811902755`, 
      0.31286893008046174`, -1.7999999999999998`}, {-2, 
       0, -1.7999999999999998`}, {-2, 
       0, -1.4999999999999998`}, {-1.9753766811902755`, 
      0.31286893008046174`, -1.4999999999999998`}}]], 
   Polygon3DBox[
    NCache[{{(-2) Cos[Rational[1, 20] Pi], 2 
       Sin[Rational[1, 20] Pi], -1.4999999999999998`}, {-2, 
       0, -1.4999999999999998`}, {-2, 0, -1.1999999999999997`}, {(-2) 
       Cos[Rational[1, 20] Pi], 2 
       Sin[Rational[1, 20] 
         Pi], -1.1999999999999997`}}, {{-1.9753766811902755`, 
      0.31286893008046174`, -1.4999999999999998`}, {-2, 
       0, -1.4999999999999998`}, {-2, 
       0, -1.1999999999999997`}, {-1.9753766811902755`, 
      0.31286893008046174`, -1.1999999999999997`}}]], 
   Polygon3DBox[
    NCache[{{(-2) Cos[Rational[1, 20] Pi], 2 
       Sin[Rational[1, 20] Pi], -1.1999999999999997`}, {-2, 
       0, -1.1999999999999997`}, {-2, 0, -0.8999999999999997}, {(-2) 
       Cos[Rational[1, 20] Pi], 2 
       Sin[Rational[1, 20] Pi], -0.8999999999999997}}, {{-1.9753766811902755`,
       0.31286893008046174`, -1.1999999999999997`}, {-2, 
       0, -1.1999999999999997`}, {-2, 
       0, -0.8999999999999997}, {-1.9753766811902755`, 
      0.31286893008046174`, -0.8999999999999997}}]], 
   Polygon3DBox[
    NCache[{{(-2) Cos[Rational[1, 20] Pi], 2 
       Sin[Rational[1, 20] Pi], -0.8999999999999997}, {-2, 
       0, -0.8999999999999997}, {-2, 0, -0.5999999999999996}, {(-2) 
       Cos[Rational[1, 20] Pi], 2 
       Sin[Rational[1, 20] Pi], -0.5999999999999996}}, {{-1.9753766811902755`,
       0.31286893008046174`, -0.8999999999999997}, {-2, 
       0, -0.8999999999999997}, {-2, 
       0, -0.5999999999999996}, {-1.9753766811902755`, 
      0.31286893008046174`, -0.5999999999999996}}]], 
   Polygon3DBox[
    NCache[{{(-2) Cos[Rational[1, 20] Pi], 2 
       Sin[Rational[1, 20] Pi], -0.5999999999999996}, {-2, 
       0, -0.5999999999999996}, {-2, 0, -0.2999999999999996}, {(-2) 
       Cos[Rational[1, 20] Pi], 2 
       Sin[Rational[1, 20] Pi], -0.2999999999999996}}, {{-1.9753766811902755`,
       0.31286893008046174`, -0.5999999999999996}, {-2, 
       0, -0.5999999999999996}, {-2, 
       0, -0.2999999999999996}, {-1.9753766811902755`, 
      0.31286893008046174`, -0.2999999999999996}}]], 
   Polygon3DBox[
    NCache[{{(-2) Cos[Rational[1, 20] Pi], 2 
       Sin[Rational[1, 20] Pi], -0.2999999999999996}, {-2, 
       0, -0.2999999999999996}, {-2, 0, 4.440892098500626*^-16}, {(-2) 
       Cos[Rational[1, 20] Pi], 2 Sin[Rational[1, 20] Pi], 
       4.440892098500626*^-16}}, {{-1.9753766811902755`, 
      0.31286893008046174`, -0.2999999999999996}, {-2, 
       0, -0.2999999999999996}, {-2, 0, 
       4.440892098500626*^-16}, {-1.9753766811902755`, 0.31286893008046174`, 
      4.440892098500626*^-16}}]], 
   Polygon3DBox[
    NCache[{{(-2) Cos[Rational[1, 20] Pi], 2 Sin[Rational[1, 20] Pi], 
       4.440892098500626*^-16}, {-2, 0, 4.440892098500626*^-16}, {-2, 0, 
       0.3000000000000005}, {(-2) Cos[Rational[1, 20] Pi], 2 
       Sin[Rational[1, 20] Pi], 0.3000000000000005}}, {{-1.9753766811902755`, 
      0.31286893008046174`, 
      4.440892098500626*^-16}, {-2, 0, 4.440892098500626*^-16}, {-2, 0, 
       0.3000000000000005}, {-1.9753766811902755`, 0.31286893008046174`, 
      0.3000000000000005}}]], 
   Polygon3DBox[
    NCache[{{(-2) Cos[Rational[1, 20] Pi], 2 Sin[Rational[1, 20] Pi], 
       0.3000000000000005}, {-2, 0, 0.3000000000000005}, {-2, 0, 
       0.6000000000000005}, {(-2) Cos[Rational[1, 20] Pi], 2 
       Sin[Rational[1, 20] Pi], 0.6000000000000005}}, {{-1.9753766811902755`, 
      0.31286893008046174`, 
      0.3000000000000005}, {-2, 0, 0.3000000000000005}, {-2, 0, 
       0.6000000000000005}, {-1.9753766811902755`, 0.31286893008046174`, 
      0.6000000000000005}}]], 
   Polygon3DBox[
    NCache[{{(-2) Cos[Rational[1, 20] Pi], 2 Sin[Rational[1, 20] Pi], 
       0.6000000000000005}, {-2, 0, 0.6000000000000005}, {-2, 0, 
       0.9000000000000006}, {(-2) Cos[Rational[1, 20] Pi], 2 
       Sin[Rational[1, 20] Pi], 0.9000000000000006}}, {{-1.9753766811902755`, 
      0.31286893008046174`, 
      0.6000000000000005}, {-2, 0, 0.6000000000000005}, {-2, 0, 
       0.9000000000000006}, {-1.9753766811902755`, 0.31286893008046174`, 
      0.9000000000000006}}]], 
   Polygon3DBox[
    NCache[{{(-2) Cos[Rational[1, 20] Pi], 2 Sin[Rational[1, 20] Pi], 
       0.9000000000000006}, {-2, 0, 0.9000000000000006}, {-2, 0, 
       1.2000000000000006`}, {(-2) Cos[Rational[1, 20] Pi], 2 
       Sin[Rational[1, 20] Pi], 1.2000000000000006`}}, {{-1.9753766811902755`,
       0.31286893008046174`, 
      0.9000000000000006}, {-2, 0, 0.9000000000000006}, {-2, 0, 
       1.2000000000000006`}, {-1.9753766811902755`, 0.31286893008046174`, 
      1.2000000000000006`}}]], 
   Polygon3DBox[
    NCache[{{(-2) Cos[Rational[1, 20] Pi], 2 Sin[Rational[1, 20] Pi], 
       1.2000000000000006`}, {-2, 0, 1.2000000000000006`}, {-2, 0, 
       1.5000000000000007`}, {(-2) Cos[Rational[1, 20] Pi], 2 
       Sin[Rational[1, 20] Pi], 1.5000000000000007`}}, {{-1.9753766811902755`,
       0.31286893008046174`, 
      1.2000000000000006`}, {-2, 0, 1.2000000000000006`}, {-2, 0, 
       1.5000000000000007`}, {-1.9753766811902755`, 0.31286893008046174`, 
      1.5000000000000007`}}]], 
   Polygon3DBox[
    NCache[{{(-2) Cos[Rational[1, 20] Pi], 2 Sin[Rational[1, 20] Pi], 
       1.5000000000000007`}, {-2, 0, 1.5000000000000007`}, {-2, 0, 
       1.8000000000000007`}, {(-2) Cos[Rational[1, 20] Pi], 2 
       Sin[Rational[1, 20] Pi], 1.8000000000000007`}}, {{-1.9753766811902755`,
       0.31286893008046174`, 
      1.5000000000000007`}, {-2, 0, 1.5000000000000007`}, {-2, 0, 
       1.8000000000000007`}, {-1.9753766811902755`, 0.31286893008046174`, 
      1.8000000000000007`}}]], 
   Polygon3DBox[
    NCache[{{(-2) Cos[Rational[1, 20] Pi], 2 Sin[Rational[1, 20] Pi], 
       1.8000000000000007`}, {-2, 0, 1.8000000000000007`}, {-2, 0, 
       2.1000000000000005`}, {(-2) Cos[Rational[1, 20] Pi], 2 
       Sin[Rational[1, 20] Pi], 2.1000000000000005`}}, {{-1.9753766811902755`,
       0.31286893008046174`, 
      1.8000000000000007`}, {-2, 0, 1.8000000000000007`}, {-2, 0, 
       2.1000000000000005`}, {-1.9753766811902755`, 0.31286893008046174`, 
      2.1000000000000005`}}]], 
   Polygon3DBox[
    NCache[{{(-2) Cos[Rational[1, 20] Pi], 2 Sin[Rational[1, 20] Pi], 
       2.1000000000000005`}, {-2, 0, 2.1000000000000005`}, {-2, 0, 
       2.4000000000000004`}, {(-2) Cos[Rational[1, 20] Pi], 2 
       Sin[Rational[1, 20] Pi], 2.4000000000000004`}}, {{-1.9753766811902755`,
       0.31286893008046174`, 
      2.1000000000000005`}, {-2, 0, 2.1000000000000005`}, {-2, 0, 
       2.4000000000000004`}, {-1.9753766811902755`, 0.31286893008046174`, 
      2.4000000000000004`}}]], 
   Polygon3DBox[
    NCache[{{(-2) Cos[Rational[1, 20] Pi], 2 Sin[Rational[1, 20] Pi], 
       2.400000000000001}, {-2, 0, 2.400000000000001}, {-2, 0, 
       2.700000000000001}, {(-2) Cos[Rational[1, 20] Pi], 2 
       Sin[Rational[1, 20] Pi], 2.700000000000001}}, {{-1.9753766811902755`, 
      0.31286893008046174`, 
      2.400000000000001}, {-2, 0, 2.400000000000001}, {-2, 0, 
       2.700000000000001}, {-1.9753766811902755`, 0.31286893008046174`, 
      2.700000000000001}}]], 
   Polygon3DBox[
    NCache[{{(-2) Cos[Rational[1, 20] Pi], 2 Sin[Rational[1, 20] Pi], 
       2.700000000000001}, {-2, 0, 2.700000000000001}, {-2, 0, 
       3.000000000000001}, {(-2) Cos[Rational[1, 20] Pi], 2 
       Sin[Rational[1, 20] Pi], 3.000000000000001}}, {{-1.9753766811902755`, 
      0.31286893008046174`, 
      2.700000000000001}, {-2, 0, 2.700000000000001}, {-2, 0, 
       3.000000000000001}, {-1.9753766811902755`, 0.31286893008046174`, 
      3.000000000000001}}]], 
   Polygon3DBox[
    NCache[{{-2, 0, -3.}, {(-2) Cos[Rational[1, 20] Pi], (-2) 
       Sin[Rational[1, 20] Pi], -3.}, {(-2) Cos[Rational[1, 20] Pi], (-2) 
       Sin[Rational[1, 20] Pi], -2.7}, {-2, 0, -2.7}}, {{-2, 
       0, -3.}, {-1.9753766811902755`, -0.31286893008046174`, -3.}, \
{-1.9753766811902755`, -0.31286893008046174`, -2.7}, {-2, 0, -2.7}}]], 
   Polygon3DBox[
    NCache[{{-2, 0, -2.7}, {(-2) Cos[Rational[1, 20] Pi], (-2) 
       Sin[Rational[1, 20] Pi], -2.7}, {(-2) Cos[Rational[1, 20] Pi], (-2) 
       Sin[Rational[1, 20] Pi], -2.4000000000000004`}, {-2, 
       0, -2.4000000000000004`}}, {{-2, 
       0, -2.7}, {-1.9753766811902755`, -0.31286893008046174`, -2.7}, \
{-1.9753766811902755`, -0.31286893008046174`, -2.4000000000000004`}, {-2, 
       0, -2.4000000000000004`}}]], 
   Polygon3DBox[
    NCache[{{-2, 0, -2.4}, {(-2) Cos[Rational[1, 20] Pi], (-2) 
       Sin[Rational[1, 20] Pi], -2.4}, {(-2) Cos[Rational[1, 20] Pi], (-2) 
       Sin[Rational[1, 20] Pi], -2.0999999999999996`}, {-2, 
       0, -2.0999999999999996`}}, {{-2, 
       0, -2.4}, {-1.9753766811902755`, -0.31286893008046174`, -2.4}, \
{-1.9753766811902755`, -0.31286893008046174`, -2.0999999999999996`}, {-2, 
       0, -2.0999999999999996`}}]], 
   Polygon3DBox[
    NCache[{{-2, 0, -2.0999999999999996`}, {(-2) 
       Cos[Rational[1, 20] Pi], (-2) 
       Sin[Rational[1, 20] Pi], -2.0999999999999996`}, {(-2) 
       Cos[Rational[1, 20] Pi], (-2) 
       Sin[Rational[1, 20] Pi], -1.7999999999999996`}, {-2, 
       0, -1.7999999999999996`}}, {{-2, 
       0, -2.0999999999999996`}, {-1.9753766811902755`, \
-0.31286893008046174`, -2.0999999999999996`}, {-1.9753766811902755`, \
-0.31286893008046174`, -1.7999999999999996`}, {-2, 
       0, -1.7999999999999996`}}]], 
   Polygon3DBox[
    NCache[{{-2, 0, -1.7999999999999998`}, {(-2) 
       Cos[Rational[1, 20] Pi], (-2) 
       Sin[Rational[1, 20] Pi], -1.7999999999999998`}, {(-2) 
       Cos[Rational[1, 20] Pi], (-2) 
       Sin[Rational[1, 20] Pi], -1.4999999999999998`}, {-2, 
       0, -1.4999999999999998`}}, {{-2, 
       0, -1.7999999999999998`}, {-1.9753766811902755`, \
-0.31286893008046174`, -1.7999999999999998`}, {-1.9753766811902755`, \
-0.31286893008046174`, -1.4999999999999998`}, {-2, 
       0, -1.4999999999999998`}}]], 
   Polygon3DBox[
    NCache[{{-2, 0, -1.4999999999999998`}, {(-2) 
       Cos[Rational[1, 20] Pi], (-2) 
       Sin[Rational[1, 20] Pi], -1.4999999999999998`}, {(-2) 
       Cos[Rational[1, 20] Pi], (-2) 
       Sin[Rational[1, 20] Pi], -1.1999999999999997`}, {-2, 
       0, -1.1999999999999997`}}, {{-2, 
       0, -1.4999999999999998`}, {-1.9753766811902755`, \
-0.31286893008046174`, -1.4999999999999998`}, {-1.9753766811902755`, \
-0.31286893008046174`, -1.1999999999999997`}, {-2, 
       0, -1.1999999999999997`}}]], 
   Polygon3DBox[
    NCache[{{-2, 0, -1.1999999999999997`}, {(-2) 
       Cos[Rational[1, 20] Pi], (-2) 
       Sin[Rational[1, 20] Pi], -1.1999999999999997`}, {(-2) 
       Cos[Rational[1, 20] Pi], (-2) 
       Sin[Rational[1, 20] Pi], -0.8999999999999997}, {-2, 
       0, -0.8999999999999997}}, {{-2, 
       0, -1.1999999999999997`}, {-1.9753766811902755`, \
-0.31286893008046174`, -1.1999999999999997`}, {-1.9753766811902755`, \
-0.31286893008046174`, -0.8999999999999997}, {-2, 0, -0.8999999999999997}}]], 
   Polygon3DBox[
    NCache[{{-2, 0, -0.8999999999999997}, {(-2) Cos[Rational[1, 20] Pi], (-2) 
       Sin[Rational[1, 20] Pi], -0.8999999999999997}, {(-2) 
       Cos[Rational[1, 20] Pi], (-2) 
       Sin[Rational[1, 20] Pi], -0.5999999999999996}, {-2, 
       0, -0.5999999999999996}}, {{-2, 
       0, -0.8999999999999997}, {-1.9753766811902755`, -0.31286893008046174`, \
-0.8999999999999997}, {-1.9753766811902755`, -0.31286893008046174`, \
-0.5999999999999996}, {-2, 0, -0.5999999999999996}}]], 
   Polygon3DBox[
    NCache[{{-2, 0, -0.5999999999999996}, {(-2) Cos[Rational[1, 20] Pi], (-2) 
       Sin[Rational[1, 20] Pi], -0.5999999999999996}, {(-2) 
       Cos[Rational[1, 20] Pi], (-2) 
       Sin[Rational[1, 20] Pi], -0.2999999999999996}, {-2, 
       0, -0.2999999999999996}}, {{-2, 
       0, -0.5999999999999996}, {-1.9753766811902755`, -0.31286893008046174`, \
-0.5999999999999996}, {-1.9753766811902755`, -0.31286893008046174`, \
-0.2999999999999996}, {-2, 0, -0.2999999999999996}}]], 
   Polygon3DBox[
    NCache[{{-2, 0, -0.2999999999999996}, {(-2) Cos[Rational[1, 20] Pi], (-2) 
       Sin[Rational[1, 20] Pi], -0.2999999999999996}, {(-2) 
       Cos[Rational[1, 20] Pi], (-2) Sin[Rational[1, 20] Pi], 
       4.440892098500626*^-16}, {-2, 0, 4.440892098500626*^-16}}, {{-2, 
       0, -0.2999999999999996}, {-1.9753766811902755`, -0.31286893008046174`, \
-0.2999999999999996}, {-1.9753766811902755`, -0.31286893008046174`, 
      4.440892098500626*^-16}, {-2, 0, 4.440892098500626*^-16}}]], 
   Polygon3DBox[
    NCache[{{-2, 0, 4.440892098500626*^-16}, {(-2) 
       Cos[Rational[1, 20] Pi], (-2) Sin[Rational[1, 20] Pi], 
       4.440892098500626*^-16}, {(-2) Cos[Rational[1, 20] Pi], (-2) 
       Sin[Rational[1, 20] Pi], 0.3000000000000005}, {-2, 0, 
       0.3000000000000005}}, {{-2, 0, 
       4.440892098500626*^-16}, {-1.9753766811902755`, -0.31286893008046174`, 
      4.440892098500626*^-16}, {-1.9753766811902755`, -0.31286893008046174`, 
      0.3000000000000005}, {-2, 0, 0.3000000000000005}}]], 
   Polygon3DBox[
    NCache[{{-2, 0, 0.3000000000000005}, {(-2) Cos[Rational[1, 20] Pi], (-2) 
       Sin[Rational[1, 20] Pi], 0.3000000000000005}, {(-2) 
       Cos[Rational[1, 20] Pi], (-2) Sin[Rational[1, 20] Pi], 
       0.6000000000000005}, {-2, 0, 0.6000000000000005}}, {{-2, 0, 
       0.3000000000000005}, {-1.9753766811902755`, -0.31286893008046174`, 
      0.3000000000000005}, {-1.9753766811902755`, -0.31286893008046174`, 
      0.6000000000000005}, {-2, 0, 0.6000000000000005}}]], 
   Polygon3DBox[
    NCache[{{-2, 0, 0.6000000000000005}, {(-2) Cos[Rational[1, 20] Pi], (-2) 
       Sin[Rational[1, 20] Pi], 0.6000000000000005}, {(-2) 
       Cos[Rational[1, 20] Pi], (-2) Sin[Rational[1, 20] Pi], 
       0.9000000000000006}, {-2, 0, 0.9000000000000006}}, {{-2, 0, 
       0.6000000000000005}, {-1.9753766811902755`, -0.31286893008046174`, 
      0.6000000000000005}, {-1.9753766811902755`, -0.31286893008046174`, 
      0.9000000000000006}, {-2, 0, 0.9000000000000006}}]], 
   Polygon3DBox[
    NCache[{{-2, 0, 0.9000000000000006}, {(-2) Cos[Rational[1, 20] Pi], (-2) 
       Sin[Rational[1, 20] Pi], 0.9000000000000006}, {(-2) 
       Cos[Rational[1, 20] Pi], (-2) Sin[Rational[1, 20] Pi], 
       1.2000000000000006`}, {-2, 0, 1.2000000000000006`}}, {{-2, 0, 
       0.9000000000000006}, {-1.9753766811902755`, -0.31286893008046174`, 
      0.9000000000000006}, {-1.9753766811902755`, -0.31286893008046174`, 
      1.2000000000000006`}, {-2, 0, 1.2000000000000006`}}]], 
   Polygon3DBox[
    NCache[{{-2, 0, 1.2000000000000006`}, {(-2) Cos[Rational[1, 20] Pi], (-2) 
       Sin[Rational[1, 20] Pi], 1.2000000000000006`}, {(-2) 
       Cos[Rational[1, 20] Pi], (-2) Sin[Rational[1, 20] Pi], 
       1.5000000000000007`}, {-2, 0, 1.5000000000000007`}}, {{-2, 0, 
       1.2000000000000006`}, {-1.9753766811902755`, -0.31286893008046174`, 
      1.2000000000000006`}, {-1.9753766811902755`, -0.31286893008046174`, 
      1.5000000000000007`}, {-2, 0, 1.5000000000000007`}}]], 
   Polygon3DBox[
    NCache[{{-2, 0, 1.5000000000000007`}, {(-2) Cos[Rational[1, 20] Pi], (-2) 
       Sin[Rational[1, 20] Pi], 1.5000000000000007`}, {(-2) 
       Cos[Rational[1, 20] Pi], (-2) Sin[Rational[1, 20] Pi], 
       1.8000000000000007`}, {-2, 0, 1.8000000000000007`}}, {{-2, 0, 
       1.5000000000000007`}, {-1.9753766811902755`, -0.31286893008046174`, 
      1.5000000000000007`}, {-1.9753766811902755`, -0.31286893008046174`, 
      1.8000000000000007`}, {-2, 0, 1.8000000000000007`}}]], 
   Polygon3DBox[
    NCache[{{-2, 0, 1.8000000000000007`}, {(-2) Cos[Rational[1, 20] Pi], (-2) 
       Sin[Rational[1, 20] Pi], 1.8000000000000007`}, {(-2) 
       Cos[Rational[1, 20] Pi], (-2) Sin[Rational[1, 20] Pi], 
       2.1000000000000005`}, {-2, 0, 2.1000000000000005`}}, {{-2, 0, 
       1.8000000000000007`}, {-1.9753766811902755`, -0.31286893008046174`, 
      1.8000000000000007`}, {-1.9753766811902755`, -0.31286893008046174`, 
      2.1000000000000005`}, {-2, 0, 2.1000000000000005`}}]], 
   Polygon3DBox[
    NCache[{{-2, 0, 2.1000000000000005`}, {(-2) Cos[Rational[1, 20] Pi], (-2) 
       Sin[Rational[1, 20] Pi], 2.1000000000000005`}, {(-2) 
       Cos[Rational[1, 20] Pi], (-2) Sin[Rational[1, 20] Pi], 
       2.4000000000000004`}, {-2, 0, 2.4000000000000004`}}, {{-2, 0, 
       2.1000000000000005`}, {-1.9753766811902755`, -0.31286893008046174`, 
      2.1000000000000005`}, {-1.9753766811902755`, -0.31286893008046174`, 
      2.4000000000000004`}, {-2, 0, 2.4000000000000004`}}]], 
   Polygon3DBox[
    NCache[{{-2, 0, 2.400000000000001}, {(-2) Cos[Rational[1, 20] Pi], (-2) 
       Sin[Rational[1, 20] Pi], 2.400000000000001}, {(-2) 
       Cos[Rational[1, 20] Pi], (-2) Sin[Rational[1, 20] Pi], 
       2.700000000000001}, {-2, 0, 2.700000000000001}}, {{-2, 0, 
       2.400000000000001}, {-1.9753766811902755`, -0.31286893008046174`, 
      2.400000000000001}, {-1.9753766811902755`, -0.31286893008046174`, 
      2.700000000000001}, {-2, 0, 2.700000000000001}}]], 
   Polygon3DBox[
    NCache[{{-2, 0, 2.700000000000001}, {(-2) Cos[Rational[1, 20] Pi], (-2) 
       Sin[Rational[1, 20] Pi], 2.700000000000001}, {(-2) 
       Cos[Rational[1, 20] Pi], (-2) Sin[Rational[1, 20] Pi], 
       3.000000000000001}, {-2, 0, 3.000000000000001}}, {{-2, 0, 
       2.700000000000001}, {-1.9753766811902755`, -0.31286893008046174`, 
      2.700000000000001}, {-1.9753766811902755`, -0.31286893008046174`, 
      3.000000000000001}, {-2, 0, 3.000000000000001}}]], 
   Polygon3DBox[
    NCache[{{(-2) Cos[Rational[1, 20] Pi], (-2) 
       Sin[Rational[1, 20] Pi], -3.}, {(-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 - 5^
        Rational[1, 2]), -3.}, {(-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 - 5^Rational[1, 2]), -2.7}, {(-2) 
       Cos[Rational[1, 20] Pi], (-2) 
       Sin[Rational[1, 20] 
         Pi], -2.7}}, {{-1.9753766811902755`, -0.31286893008046174`, -3.}, \
{-1.902113032590307, -0.6180339887498949, -3.}, {-1.902113032590307, \
-0.6180339887498949, -2.7}, {-1.9753766811902755`, -0.31286893008046174`, \
-2.7}}]], 
   Polygon3DBox[
    NCache[{{(-2) Cos[Rational[1, 20] Pi], (-2) 
       Sin[Rational[1, 20] Pi], -2.7}, {(-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 - 5^
        Rational[1, 2]), -2.7}, {(-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 - 5^Rational[1, 2]), -2.4000000000000004`}, {(-2) 
       Cos[Rational[1, 20] Pi], (-2) 
       Sin[Rational[1, 20] 
         Pi], -2.4000000000000004`}}, {{-1.9753766811902755`, \
-0.31286893008046174`, -2.7}, {-1.902113032590307, -0.6180339887498949, \
-2.7}, {-1.902113032590307, -0.6180339887498949, -2.4000000000000004`}, \
{-1.9753766811902755`, -0.31286893008046174`, -2.4000000000000004`}}]], 
   Polygon3DBox[
    NCache[{{(-2) Cos[Rational[1, 20] Pi], (-2) 
       Sin[Rational[1, 20] Pi], -2.4}, {(-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 - 5^
        Rational[1, 2]), -2.4}, {(-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 - 5^Rational[1, 2]), -2.0999999999999996`}, {(-2) 
       Cos[Rational[1, 20] Pi], (-2) 
       Sin[Rational[1, 20] 
         Pi], -2.0999999999999996`}}, {{-1.9753766811902755`, \
-0.31286893008046174`, -2.4}, {-1.902113032590307, -0.6180339887498949, \
-2.4}, {-1.902113032590307, -0.6180339887498949, -2.0999999999999996`}, \
{-1.9753766811902755`, -0.31286893008046174`, -2.0999999999999996`}}]], 
   Polygon3DBox[
    NCache[{{(-2) Cos[Rational[1, 20] Pi], (-2) 
       Sin[Rational[1, 20] Pi], -2.0999999999999996`}, {(-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 - 5^
        Rational[1, 2]), -2.0999999999999996`}, {(-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 - 5^Rational[1, 2]), -1.7999999999999996`}, {(-2) 
       Cos[Rational[1, 20] Pi], (-2) 
       Sin[Rational[1, 20] 
         Pi], -1.7999999999999996`}}, {{-1.9753766811902755`, \
-0.31286893008046174`, -2.0999999999999996`}, {-1.902113032590307, \
-0.6180339887498949, -2.0999999999999996`}, {-1.902113032590307, \
-0.6180339887498949, -1.7999999999999996`}, {-1.9753766811902755`, \
-0.31286893008046174`, -1.7999999999999996`}}]], 
   Polygon3DBox[
    NCache[{{(-2) Cos[Rational[1, 20] Pi], (-2) 
       Sin[Rational[1, 20] Pi], -1.7999999999999998`}, {(-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 - 5^
        Rational[1, 2]), -1.7999999999999998`}, {(-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 - 5^Rational[1, 2]), -1.4999999999999998`}, {(-2) 
       Cos[Rational[1, 20] Pi], (-2) 
       Sin[Rational[1, 20] 
         Pi], -1.4999999999999998`}}, {{-1.9753766811902755`, \
-0.31286893008046174`, -1.7999999999999998`}, {-1.902113032590307, \
-0.6180339887498949, -1.7999999999999998`}, {-1.902113032590307, \
-0.6180339887498949, -1.4999999999999998`}, {-1.9753766811902755`, \
-0.31286893008046174`, -1.4999999999999998`}}]], 
   Polygon3DBox[
    NCache[{{(-2) Cos[Rational[1, 20] Pi], (-2) 
       Sin[Rational[1, 20] Pi], -1.4999999999999998`}, {(-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 - 5^
        Rational[1, 2]), -1.4999999999999998`}, {(-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 - 5^Rational[1, 2]), -1.1999999999999997`}, {(-2) 
       Cos[Rational[1, 20] Pi], (-2) 
       Sin[Rational[1, 20] 
         Pi], -1.1999999999999997`}}, {{-1.9753766811902755`, \
-0.31286893008046174`, -1.4999999999999998`}, {-1.902113032590307, \
-0.6180339887498949, -1.4999999999999998`}, {-1.902113032590307, \
-0.6180339887498949, -1.1999999999999997`}, {-1.9753766811902755`, \
-0.31286893008046174`, -1.1999999999999997`}}]], 
   Polygon3DBox[
    NCache[{{(-2) Cos[Rational[1, 20] Pi], (-2) 
       Sin[Rational[1, 20] Pi], -1.1999999999999997`}, {(-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 - 5^
        Rational[1, 2]), -1.1999999999999997`}, {(-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 - 5^Rational[1, 2]), -0.8999999999999997}, {(-2) 
       Cos[Rational[1, 20] Pi], (-2) 
       Sin[Rational[1, 20] 
         Pi], -0.8999999999999997}}, {{-1.9753766811902755`, \
-0.31286893008046174`, -1.1999999999999997`}, {-1.902113032590307, \
-0.6180339887498949, -1.1999999999999997`}, {-1.902113032590307, \
-0.6180339887498949, -0.8999999999999997}, {-1.9753766811902755`, \
-0.31286893008046174`, -0.8999999999999997}}]], 
   Polygon3DBox[
    NCache[{{(-2) Cos[Rational[1, 20] Pi], (-2) 
       Sin[
        Rational[1, 20] Pi], -0.8999999999999997}, {(-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 - 5^
        Rational[1, 2]), -0.8999999999999997}, {(-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 - 5^Rational[1, 2]), -0.5999999999999996}, {(-2) 
       Cos[Rational[1, 20] Pi], (-2) 
       Sin[Rational[1, 20] 
         Pi], -0.5999999999999996}}, {{-1.9753766811902755`, \
-0.31286893008046174`, -0.8999999999999997}, {-1.902113032590307, \
-0.6180339887498949, -0.8999999999999997}, {-1.902113032590307, \
-0.6180339887498949, -0.5999999999999996}, {-1.9753766811902755`, \
-0.31286893008046174`, -0.5999999999999996}}]], 
   Polygon3DBox[
    NCache[{{(-2) Cos[Rational[1, 20] Pi], (-2) 
       Sin[Rational[1, 20] Pi], -0.5999999999999996}, {(-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 - 5^
        Rational[1, 2]), -0.5999999999999996}, {(-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 - 5^Rational[1, 2]), -0.2999999999999996}, {(-2) 
       Cos[Rational[1, 20] Pi], (-2) 
       Sin[Rational[1, 20] 
         Pi], -0.2999999999999996}}, {{-1.9753766811902755`, \
-0.31286893008046174`, -0.5999999999999996}, {-1.902113032590307, \
-0.6180339887498949, -0.5999999999999996}, {-1.902113032590307, \
-0.6180339887498949, -0.2999999999999996}, {-1.9753766811902755`, \
-0.31286893008046174`, -0.2999999999999996}}]], 
   Polygon3DBox[
    NCache[{{(-2) Cos[Rational[1, 20] Pi], (-2) 
       Sin[Rational[1, 20] Pi], -0.2999999999999996}, {(-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 - 5^
        Rational[1, 2]), -0.2999999999999996}, {(-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 - 5^Rational[1, 2]), 4.440892098500626*^-16}, {(-2) 
       Cos[Rational[1, 20] Pi], (-2) Sin[Rational[1, 20] Pi], 
       4.440892098500626*^-16}}, {{-1.9753766811902755`, \
-0.31286893008046174`, -0.2999999999999996}, {-1.902113032590307, \
-0.6180339887498949, -0.2999999999999996}, {-1.902113032590307, \
-0.6180339887498949, 
     4.440892098500626*^-16}, {-1.9753766811902755`, -0.31286893008046174`, 
     4.440892098500626*^-16}}]], 
   Polygon3DBox[
    NCache[{{(-2) Cos[Rational[1, 20] Pi], (-2) Sin[Rational[1, 20] Pi], 
       4.440892098500626*^-16}, {(-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 - 5^Rational[1, 2]), 
       4.440892098500626*^-16}, {(-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 - 5^Rational[1, 2]), 0.3000000000000005}, {(-2) 
       Cos[Rational[1, 20] Pi], (-2) Sin[Rational[1, 20] Pi], 
       0.3000000000000005}}, {{-1.9753766811902755`, -0.31286893008046174`, 
     4.440892098500626*^-16}, {-1.902113032590307, -0.6180339887498949, 
     4.440892098500626*^-16}, {-1.902113032590307, -0.6180339887498949, 
     0.3000000000000005}, {-1.9753766811902755`, -0.31286893008046174`, 
     0.3000000000000005}}]], 
   Polygon3DBox[
    NCache[{{(-2) Cos[Rational[1, 20] Pi], (-2) Sin[Rational[1, 20] Pi], 
       0.3000000000000005}, {(-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 - 5^Rational[1, 2]), 
       0.3000000000000005}, {(-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 - 5^Rational[1, 2]), 0.6000000000000005}, {(-2) 
       Cos[Rational[1, 20] Pi], (-2) Sin[Rational[1, 20] Pi], 
       0.6000000000000005}}, {{-1.9753766811902755`, -0.31286893008046174`, 
     0.3000000000000005}, {-1.902113032590307, -0.6180339887498949, 
     0.3000000000000005}, {-1.902113032590307, -0.6180339887498949, 
     0.6000000000000005}, {-1.9753766811902755`, -0.31286893008046174`, 
     0.6000000000000005}}]], 
   Polygon3DBox[
    NCache[{{(-2) Cos[Rational[1, 20] Pi], (-2) Sin[Rational[1, 20] Pi], 
       0.6000000000000005}, {(-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 - 5^Rational[1, 2]), 
       0.6000000000000005}, {(-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 - 5^Rational[1, 2]), 0.9000000000000006}, {(-2) 
       Cos[Rational[1, 20] Pi], (-2) Sin[Rational[1, 20] Pi], 
       0.9000000000000006}}, {{-1.9753766811902755`, -0.31286893008046174`, 
     0.6000000000000005}, {-1.902113032590307, -0.6180339887498949, 
     0.6000000000000005}, {-1.902113032590307, -0.6180339887498949, 
     0.9000000000000006}, {-1.9753766811902755`, -0.31286893008046174`, 
     0.9000000000000006}}]], 
   Polygon3DBox[
    NCache[{{(-2) Cos[Rational[1, 20] Pi], (-2) Sin[Rational[1, 20] Pi], 
       0.9000000000000006}, {(-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 - 5^Rational[1, 2]), 
       0.9000000000000006}, {(-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 - 5^Rational[1, 2]), 1.2000000000000006`}, {(-2) 
       Cos[Rational[1, 20] Pi], (-2) Sin[Rational[1, 20] Pi], 
       1.2000000000000006`}}, {{-1.9753766811902755`, -0.31286893008046174`, 
     0.9000000000000006}, {-1.902113032590307, -0.6180339887498949, 
     0.9000000000000006}, {-1.902113032590307, -0.6180339887498949, 
     1.2000000000000006`}, {-1.9753766811902755`, -0.31286893008046174`, 
     1.2000000000000006`}}]], 
   Polygon3DBox[
    NCache[{{(-2) Cos[Rational[1, 20] Pi], (-2) Sin[Rational[1, 20] Pi], 
       1.2000000000000006`}, {(-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 - 5^Rational[1, 2]), 
       1.2000000000000006`}, {(-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 - 5^Rational[1, 2]), 1.5000000000000007`}, {(-2) 
       Cos[Rational[1, 20] Pi], (-2) Sin[Rational[1, 20] Pi], 
       1.5000000000000007`}}, {{-1.9753766811902755`, -0.31286893008046174`, 
     1.2000000000000006`}, {-1.902113032590307, -0.6180339887498949, 
     1.2000000000000006`}, {-1.902113032590307, -0.6180339887498949, 
     1.5000000000000007`}, {-1.9753766811902755`, -0.31286893008046174`, 
     1.5000000000000007`}}]], 
   Polygon3DBox[
    NCache[{{(-2) Cos[Rational[1, 20] Pi], (-2) Sin[Rational[1, 20] Pi], 
       1.5000000000000007`}, {(-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 - 5^Rational[1, 2]), 
       1.5000000000000007`}, {(-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 - 5^Rational[1, 2]), 1.8000000000000007`}, {(-2) 
       Cos[Rational[1, 20] Pi], (-2) Sin[Rational[1, 20] Pi], 
       1.8000000000000007`}}, {{-1.9753766811902755`, -0.31286893008046174`, 
     1.5000000000000007`}, {-1.902113032590307, -0.6180339887498949, 
     1.5000000000000007`}, {-1.902113032590307, -0.6180339887498949, 
     1.8000000000000007`}, {-1.9753766811902755`, -0.31286893008046174`, 
     1.8000000000000007`}}]], 
   Polygon3DBox[
    NCache[{{(-2) Cos[Rational[1, 20] Pi], (-2) Sin[Rational[1, 20] Pi], 
       1.8000000000000007`}, {(-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 - 5^Rational[1, 2]), 
       1.8000000000000007`}, {(-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 - 5^Rational[1, 2]), 2.1000000000000005`}, {(-2) 
       Cos[Rational[1, 20] Pi], (-2) Sin[Rational[1, 20] Pi], 
       2.1000000000000005`}}, {{-1.9753766811902755`, -0.31286893008046174`, 
     1.8000000000000007`}, {-1.902113032590307, -0.6180339887498949, 
     1.8000000000000007`}, {-1.902113032590307, -0.6180339887498949, 
     2.1000000000000005`}, {-1.9753766811902755`, -0.31286893008046174`, 
     2.1000000000000005`}}]], 
   Polygon3DBox[
    NCache[{{(-2) Cos[Rational[1, 20] Pi], (-2) Sin[Rational[1, 20] Pi], 
       2.1000000000000005`}, {(-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 - 5^Rational[1, 2]), 
       2.1000000000000005`}, {(-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 - 5^Rational[1, 2]), 2.4000000000000004`}, {(-2) 
       Cos[Rational[1, 20] Pi], (-2) Sin[Rational[1, 20] Pi], 
       2.4000000000000004`}}, {{-1.9753766811902755`, -0.31286893008046174`, 
     2.1000000000000005`}, {-1.902113032590307, -0.6180339887498949, 
     2.1000000000000005`}, {-1.902113032590307, -0.6180339887498949, 
     2.4000000000000004`}, {-1.9753766811902755`, -0.31286893008046174`, 
     2.4000000000000004`}}]], 
   Polygon3DBox[
    NCache[{{(-2) Cos[Rational[1, 20] Pi], (-2) Sin[Rational[1, 20] Pi], 
       2.400000000000001}, {(-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 - 5^Rational[1, 2]), 
       2.400000000000001}, {(-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 - 5^Rational[1, 2]), 2.700000000000001}, {(-2) 
       Cos[Rational[1, 20] Pi], (-2) Sin[Rational[1, 20] Pi], 
       2.700000000000001}}, {{-1.9753766811902755`, -0.31286893008046174`, 
     2.400000000000001}, {-1.902113032590307, -0.6180339887498949, 
     2.400000000000001}, {-1.902113032590307, -0.6180339887498949, 
     2.700000000000001}, {-1.9753766811902755`, -0.31286893008046174`, 
     2.700000000000001}}]], 
   Polygon3DBox[
    NCache[{{(-2) Cos[Rational[1, 20] Pi], (-2) Sin[Rational[1, 20] Pi], 
       2.700000000000001}, {(-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 - 5^Rational[1, 2]), 
       2.700000000000001}, {(-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 - 5^Rational[1, 2]), 3.000000000000001}, {(-2) 
       Cos[Rational[1, 20] Pi], (-2) Sin[Rational[1, 20] Pi], 
       3.000000000000001}}, {{-1.9753766811902755`, -0.31286893008046174`, 
     2.700000000000001}, {-1.902113032590307, -0.6180339887498949, 
     2.700000000000001}, {-1.902113032590307, -0.6180339887498949, 
     3.000000000000001}, {-1.9753766811902755`, -0.31286893008046174`, 
     3.000000000000001}}]], 
   Polygon3DBox[
    NCache[{{(-2) (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 2] (1 - 5^Rational[1, 2]), -3.}, {(-2) 
       Cos[Rational[3, 20] Pi], (-2) Sin[Rational[3, 20] Pi], -3.}, {(-2) 
       Cos[Rational[3, 20] Pi], (-2) 
       Sin[Rational[3, 20] Pi], -2.7}, {(-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 - 5^
        Rational[
         1, 2]), -2.7}}, {{-1.902113032590307, -0.6180339887498949, -3.}, \
{-1.7820130483767358`, -0.9079809994790936, -3.}, {-1.7820130483767358`, \
-0.9079809994790936, -2.7}, {-1.902113032590307, -0.6180339887498949, \
-2.7}}]], 
   Polygon3DBox[
    NCache[{{(-2) (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 2] (1 - 5^Rational[1, 2]), -2.7}, {(-2) 
       Cos[Rational[3, 20] Pi], (-2) Sin[Rational[3, 20] Pi], -2.7}, {(-2) 
       Cos[Rational[3, 20] Pi], (-2) 
       Sin[Rational[3, 20] Pi], -2.4000000000000004`}, {(-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 - 5^
        Rational[
         1, 2]), -2.4000000000000004`}}, {{-1.902113032590307, \
-0.6180339887498949, -2.7}, {-1.7820130483767358`, -0.9079809994790936, \
-2.7}, {-1.7820130483767358`, -0.9079809994790936, -2.4000000000000004`}, \
{-1.902113032590307, -0.6180339887498949, -2.4000000000000004`}}]], 
   Polygon3DBox[
    NCache[{{(-2) (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 2] (1 - 5^Rational[1, 2]), -2.4}, {(-2) 
       Cos[Rational[3, 20] Pi], (-2) Sin[Rational[3, 20] Pi], -2.4}, {(-2) 
       Cos[Rational[3, 20] Pi], (-2) 
       Sin[Rational[3, 20] Pi], -2.0999999999999996`}, {(-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 - 5^
        Rational[
         1, 2]), -2.0999999999999996`}}, {{-1.902113032590307, \
-0.6180339887498949, -2.4}, {-1.7820130483767358`, -0.9079809994790936, \
-2.4}, {-1.7820130483767358`, -0.9079809994790936, -2.0999999999999996`}, \
{-1.902113032590307, -0.6180339887498949, -2.0999999999999996`}}]], 
   Polygon3DBox[
    NCache[{{(-2) (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], 
       Rational[1, 2] (1 - 5^Rational[1, 2]), -2.0999999999999996`}, {(-2) 
       Cos[Rational[3, 20] Pi], (-2) 
       Sin[Rational[3, 20] Pi], -2.0999999999999996`}, {(-2) 
       Cos[Rational[3, 20] Pi], (-2) 
       Sin[
        Rational[3, 20] Pi], -1.7999999999999996`}, {(-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 - 5^
        Rational[
         1, 2]), -1.7999999999999996`}}, {{-1.902113032590307, \
-0.6180339887498949, -2.0999999999999996`}, {-1.7820130483767358`, \
-0.9079809994790936, -2.0999999999999996`}, {-1.7820130483767358`, \
-0.9079809994790936, -1.7999999999999996`}, {-1.902113032590307, \
-0.6180339887498949, -1.7999999999999996`}}]], 
   Polygon3DBox[
    NCache[{{(-2) (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], 
       Rational[1, 2] (1 - 5^Rational[1, 2]), -1.7999999999999998`}, {(-2) 
       Cos[Rational[3, 20] Pi], (-2) 
       Sin[Rational[3, 20] Pi], -1.7999999999999998`}, {(-2) 
       Cos[Rational[3, 20] Pi], (-2) 
       Sin[Rational[3, 20] Pi], -1.4999999999999998`}, {(-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 - 5^
        Rational[
         1, 2]), -1.4999999999999998`}}, {{-1.902113032590307, \
-0.6180339887498949, -1.7999999999999998`}, {-1.7820130483767358`, \
-0.9079809994790936, -1.7999999999999998`}, {-1.7820130483767358`, \
-0.9079809994790936, -1.4999999999999998`}, {-1.902113032590307, \
-0.6180339887498949, -1.4999999999999998`}}]], 
   Polygon3DBox[
    NCache[{{(-2) (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], 
       Rational[1, 2] (1 - 5^Rational[1, 2]), -1.4999999999999998`}, {(-2) 
       Cos[Rational[3, 20] Pi], (-2) 
       Sin[Rational[3, 20] Pi], -1.4999999999999998`}, {(-2) 
       Cos[Rational[3, 20] Pi], (-2) 
       Sin[Rational[3, 20] Pi], -1.1999999999999997`}, {(-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 - 5^
        Rational[
         1, 2]), -1.1999999999999997`}}, {{-1.902113032590307, \
-0.6180339887498949, -1.4999999999999998`}, {-1.7820130483767358`, \
-0.9079809994790936, -1.4999999999999998`}, {-1.7820130483767358`, \
-0.9079809994790936, -1.1999999999999997`}, {-1.902113032590307, \
-0.6180339887498949, -1.1999999999999997`}}]], 
   Polygon3DBox[
    NCache[{{(-2) (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], 
       Rational[1, 2] (1 - 5^Rational[1, 2]), -1.1999999999999997`}, {(-2) 
       Cos[Rational[3, 20] Pi], (-2) 
       Sin[Rational[3, 20] Pi], -1.1999999999999997`}, {(-2) 
       Cos[Rational[3, 20] Pi], (-2) 
       Sin[Rational[3, 20] Pi], -0.8999999999999997}, {(-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 - 5^
        Rational[
         1, 2]), -0.8999999999999997}}, {{-1.902113032590307, \
-0.6180339887498949, -1.1999999999999997`}, {-1.7820130483767358`, \
-0.9079809994790936, -1.1999999999999997`}, {-1.7820130483767358`, \
-0.9079809994790936, -0.8999999999999997}, {-1.902113032590307, \
-0.6180339887498949, -0.8999999999999997}}]], 
   Polygon3DBox[
    NCache[{{(-2) (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], 
       Rational[1, 2] (1 - 5^Rational[1, 2]), -0.8999999999999997}, {(-2) 
       Cos[Rational[3, 20] Pi], (-2) 
       Sin[Rational[3, 20] Pi], -0.8999999999999997}, {(-2) 
       Cos[Rational[3, 20] Pi], (-2) 
       Sin[Rational[3, 20] Pi], -0.5999999999999996}, {(-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 - 5^
        Rational[
         1, 2]), -0.5999999999999996}}, {{-1.902113032590307, \
-0.6180339887498949, -0.8999999999999997}, {-1.7820130483767358`, \
-0.9079809994790936, -0.8999999999999997}, {-1.7820130483767358`, \
-0.9079809994790936, -0.5999999999999996}, {-1.902113032590307, \
-0.6180339887498949, -0.5999999999999996}}]], 
   Polygon3DBox[
    NCache[{{(-2) (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], 
       Rational[1, 2] (1 - 5^Rational[1, 2]), -0.5999999999999996}, {(-2) 
       Cos[Rational[3, 20] Pi], (-2) 
       Sin[Rational[3, 20] Pi], -0.5999999999999996}, {(-2) 
       Cos[Rational[3, 20] Pi], (-2) 
       Sin[Rational[3, 20] Pi], -0.2999999999999996}, {(-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 - 5^
        Rational[
         1, 2]), -0.2999999999999996}}, {{-1.902113032590307, \
-0.6180339887498949, -0.5999999999999996}, {-1.7820130483767358`, \
-0.9079809994790936, -0.5999999999999996}, {-1.7820130483767358`, \
-0.9079809994790936, -0.2999999999999996}, {-1.902113032590307, \
-0.6180339887498949, -0.2999999999999996}}]], 
   Polygon3DBox[
    NCache[{{(-2) (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], 
       Rational[1, 2] (1 - 5^Rational[1, 2]), -0.2999999999999996}, {(-2) 
       Cos[Rational[3, 20] Pi], (-2) 
       Sin[Rational[3, 20] Pi], -0.2999999999999996}, {(-2) 
       Cos[Rational[3, 20] Pi], (-2) Sin[Rational[3, 20] Pi], 
       4.440892098500626*^-16}, {(-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 - 5^Rational[1, 2]), 
       4.440892098500626*^-16}}, {{-1.902113032590307, -0.6180339887498949, \
-0.2999999999999996}, {-1.7820130483767358`, -0.9079809994790936, \
-0.2999999999999996}, {-1.7820130483767358`, -0.9079809994790936, 
     4.440892098500626*^-16}, {-1.902113032590307, -0.6180339887498949, 
     4.440892098500626*^-16}}]], 
   Polygon3DBox[
    NCache[{{(-2) (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 2] (1 - 5^Rational[1, 2]), 
       4.440892098500626*^-16}, {(-2) Cos[Rational[3, 20] Pi], (-2) 
       Sin[Rational[3, 20] Pi], 4.440892098500626*^-16}, {(-2) 
       Cos[Rational[3, 20] Pi], (-2) Sin[Rational[3, 20] Pi], 
       0.3000000000000005}, {(-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 - 5^Rational[1, 2]), 
       0.3000000000000005}}, {{-1.902113032590307, -0.6180339887498949, 
     4.440892098500626*^-16}, {-1.7820130483767358`, -0.9079809994790936, 
     4.440892098500626*^-16}, {-1.7820130483767358`, -0.9079809994790936, 
     0.3000000000000005}, {-1.902113032590307, -0.6180339887498949, 
     0.3000000000000005}}]], 
   Polygon3DBox[
    NCache[{{(-2) (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 2] (1 - 5^Rational[1, 2]), 
       0.3000000000000005}, {(-2) Cos[Rational[3, 20] Pi], (-2) 
       Sin[Rational[3, 20] Pi], 0.3000000000000005}, {(-2) 
       Cos[Rational[3, 20] Pi], (-2) Sin[Rational[3, 20] Pi], 
       0.6000000000000005}, {(-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 - 5^Rational[1, 2]), 
       0.6000000000000005}}, {{-1.902113032590307, -0.6180339887498949, 
     0.3000000000000005}, {-1.7820130483767358`, -0.9079809994790936, 
     0.3000000000000005}, {-1.7820130483767358`, -0.9079809994790936, 
     0.6000000000000005}, {-1.902113032590307, -0.6180339887498949, 
     0.6000000000000005}}]], 
   Polygon3DBox[
    NCache[{{(-2) (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 2] (1 - 5^Rational[1, 2]), 
       0.6000000000000005}, {(-2) Cos[Rational[3, 20] Pi], (-2) 
       Sin[Rational[3, 20] Pi], 0.6000000000000005}, {(-2) 
       Cos[Rational[3, 20] Pi], (-2) Sin[Rational[3, 20] Pi], 
       0.9000000000000006}, {(-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 - 5^Rational[1, 2]), 
       0.9000000000000006}}, {{-1.902113032590307, -0.6180339887498949, 
     0.6000000000000005}, {-1.7820130483767358`, -0.9079809994790936, 
     0.6000000000000005}, {-1.7820130483767358`, -0.9079809994790936, 
     0.9000000000000006}, {-1.902113032590307, -0.6180339887498949, 
     0.9000000000000006}}]], 
   Polygon3DBox[
    NCache[{{(-2) (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 2] (1 - 5^Rational[1, 2]), 
       0.9000000000000006}, {(-2) Cos[Rational[3, 20] Pi], (-2) 
       Sin[Rational[3, 20] Pi], 0.9000000000000006}, {(-2) 
       Cos[Rational[3, 20] Pi], (-2) Sin[Rational[3, 20] Pi], 
       1.2000000000000006`}, {(-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 - 5^Rational[1, 2]), 
       1.2000000000000006`}}, {{-1.902113032590307, -0.6180339887498949, 
     0.9000000000000006}, {-1.7820130483767358`, -0.9079809994790936, 
     0.9000000000000006}, {-1.7820130483767358`, -0.9079809994790936, 
     1.2000000000000006`}, {-1.902113032590307, -0.6180339887498949, 
     1.2000000000000006`}}]], 
   Polygon3DBox[
    NCache[{{(-2) (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 2] (1 - 5^Rational[1, 2]), 
       1.2000000000000006`}, {(-2) Cos[Rational[3, 20] Pi], (-2) 
       Sin[Rational[3, 20] Pi], 1.2000000000000006`}, {(-2) 
       Cos[Rational[3, 20] Pi], (-2) Sin[Rational[3, 20] Pi], 
       1.5000000000000007`}, {(-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 - 5^Rational[1, 2]), 
       1.5000000000000007`}}, {{-1.902113032590307, -0.6180339887498949, 
     1.2000000000000006`}, {-1.7820130483767358`, -0.9079809994790936, 
     1.2000000000000006`}, {-1.7820130483767358`, -0.9079809994790936, 
     1.5000000000000007`}, {-1.902113032590307, -0.6180339887498949, 
     1.5000000000000007`}}]], 
   Polygon3DBox[
    NCache[{{(-2) (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 2] (1 - 5^Rational[1, 2]), 
       1.5000000000000007`}, {(-2) Cos[Rational[3, 20] Pi], (-2) 
       Sin[Rational[3, 20] Pi], 1.5000000000000007`}, {(-2) 
       Cos[Rational[3, 20] Pi], (-2) Sin[Rational[3, 20] Pi], 
       1.8000000000000007`}, {(-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 - 5^Rational[1, 2]), 
       1.8000000000000007`}}, {{-1.902113032590307, -0.6180339887498949, 
     1.5000000000000007`}, {-1.7820130483767358`, -0.9079809994790936, 
     1.5000000000000007`}, {-1.7820130483767358`, -0.9079809994790936, 
     1.8000000000000007`}, {-1.902113032590307, -0.6180339887498949, 
     1.8000000000000007`}}]], 
   Polygon3DBox[
    NCache[{{(-2) (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 2] (1 - 5^Rational[1, 2]), 
       1.8000000000000007`}, {(-2) Cos[Rational[3, 20] Pi], (-2) 
       Sin[Rational[3, 20] Pi], 1.8000000000000007`}, {(-2) 
       Cos[Rational[3, 20] Pi], (-2) Sin[Rational[3, 20] Pi], 
       2.1000000000000005`}, {(-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 - 5^Rational[1, 2]), 
       2.1000000000000005`}}, {{-1.902113032590307, -0.6180339887498949, 
     1.8000000000000007`}, {-1.7820130483767358`, -0.9079809994790936, 
     1.8000000000000007`}, {-1.7820130483767358`, -0.9079809994790936, 
     2.1000000000000005`}, {-1.902113032590307, -0.6180339887498949, 
     2.1000000000000005`}}]], 
   Polygon3DBox[
    NCache[{{(-2) (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 2] (1 - 5^Rational[1, 2]), 
       2.1000000000000005`}, {(-2) Cos[Rational[3, 20] Pi], (-2) 
       Sin[Rational[3, 20] Pi], 2.1000000000000005`}, {(-2) 
       Cos[Rational[3, 20] Pi], (-2) Sin[Rational[3, 20] Pi], 
       2.4000000000000004`}, {(-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 - 5^Rational[1, 2]), 
       2.4000000000000004`}}, {{-1.902113032590307, -0.6180339887498949, 
     2.1000000000000005`}, {-1.7820130483767358`, -0.9079809994790936, 
     2.1000000000000005`}, {-1.7820130483767358`, -0.9079809994790936, 
     2.4000000000000004`}, {-1.902113032590307, -0.6180339887498949, 
     2.4000000000000004`}}]], 
   Polygon3DBox[
    NCache[{{(-2) (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 2] (1 - 5^Rational[1, 2]), 
       2.400000000000001}, {(-2) Cos[Rational[3, 20] Pi], (-2) 
       Sin[Rational[3, 20] Pi], 2.400000000000001}, {(-2) 
       Cos[Rational[3, 20] Pi], (-2) Sin[Rational[3, 20] Pi], 
       2.700000000000001}, {(-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 - 5^Rational[1, 2]), 
       2.700000000000001}}, {{-1.902113032590307, -0.6180339887498949, 
     2.400000000000001}, {-1.7820130483767358`, -0.9079809994790936, 
     2.400000000000001}, {-1.7820130483767358`, -0.9079809994790936, 
     2.700000000000001}, {-1.902113032590307, -0.6180339887498949, 
     2.700000000000001}}]], 
   Polygon3DBox[
    NCache[{{(-2) (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 2] (1 - 5^Rational[1, 2]), 
       2.700000000000001}, {(-2) Cos[Rational[3, 20] Pi], (-2) 
       Sin[Rational[3, 20] Pi], 2.700000000000001}, {(-2) 
       Cos[Rational[3, 20] Pi], (-2) Sin[Rational[3, 20] Pi], 
       3.000000000000001}, {(-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (1 - 5^Rational[1, 2]), 
       3.000000000000001}}, {{-1.902113032590307, -0.6180339887498949, 
     2.700000000000001}, {-1.7820130483767358`, -0.9079809994790936, 
     2.700000000000001}, {-1.7820130483767358`, -0.9079809994790936, 
     3.000000000000001}, {-1.902113032590307, -0.6180339887498949, 
     3.000000000000001}}]], 
   Polygon3DBox[
    NCache[{{(-2) Cos[Rational[3, 20] Pi], (-2) 
       Sin[Rational[3, 20] Pi], -3.}, {
      Rational[1, 2] (-1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], -3.}, {
      Rational[1, 2] (-1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], -2.7}, {(-2) 
       Cos[Rational[3, 20] Pi], (-2) 
       Sin[Rational[3, 20] 
         Pi], -2.7}}, {{-1.7820130483767358`, -0.9079809994790936, -3.}, \
{-1.618033988749895, -1.1755705045849463`, -3.}, {-1.618033988749895, \
-1.1755705045849463`, -2.7}, {-1.7820130483767358`, -0.9079809994790936, \
-2.7}}]], 
   Polygon3DBox[
    NCache[{{(-2) Cos[Rational[3, 20] Pi], (-2) 
       Sin[Rational[3, 20] Pi], -2.7}, {
      Rational[1, 2] (-1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], -2.7}, {
      Rational[1, 2] (-1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -2.4000000000000004`}, {(-2) 
       Cos[Rational[3, 20] Pi], (-2) 
       Sin[Rational[3, 20] 
         Pi], -2.4000000000000004`}}, {{-1.7820130483767358`, \
-0.9079809994790936, -2.7}, {-1.618033988749895, -1.1755705045849463`, -2.7}, \
{-1.618033988749895, -1.1755705045849463`, -2.4000000000000004`}, \
{-1.7820130483767358`, -0.9079809994790936, -2.4000000000000004`}}]], 
   Polygon3DBox[
    NCache[{{(-2) Cos[Rational[3, 20] Pi], (-2) 
       Sin[Rational[3, 20] Pi], -2.4}, {
      Rational[1, 2] (-1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], -2.4}, {
      Rational[1, 2] (-1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -2.0999999999999996`}, {(-2) 
       Cos[Rational[3, 20] Pi], (-2) 
       Sin[Rational[3, 20] 
         Pi], -2.0999999999999996`}}, {{-1.7820130483767358`, \
-0.9079809994790936, -2.4}, {-1.618033988749895, -1.1755705045849463`, -2.4}, \
{-1.618033988749895, -1.1755705045849463`, -2.0999999999999996`}, \
{-1.7820130483767358`, -0.9079809994790936, -2.0999999999999996`}}]], 
   Polygon3DBox[
    NCache[{{(-2) Cos[Rational[3, 20] Pi], (-2) 
       Sin[Rational[3, 20] Pi], -2.0999999999999996`}, {
      Rational[1, 2] (-1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -2.0999999999999996`}, {
      Rational[1, 2] (-1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -1.7999999999999996`}, {(-2) 
       Cos[Rational[3, 20] Pi], (-2) 
       Sin[Rational[3, 20] 
         Pi], -1.7999999999999996`}}, {{-1.7820130483767358`, \
-0.9079809994790936, -2.0999999999999996`}, {-1.618033988749895, \
-1.1755705045849463`, -2.0999999999999996`}, {-1.618033988749895, \
-1.1755705045849463`, -1.7999999999999996`}, {-1.7820130483767358`, \
-0.9079809994790936, -1.7999999999999996`}}]], 
   Polygon3DBox[
    NCache[{{(-2) Cos[Rational[3, 20] Pi], (-2) 
       Sin[Rational[3, 20] Pi], -1.7999999999999998`}, {
      Rational[1, 2] (-1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -1.7999999999999998`}, {
      Rational[1, 2] (-1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -1.4999999999999998`}, {(-2) 
       Cos[Rational[3, 20] Pi], (-2) 
       Sin[Rational[3, 20] 
         Pi], -1.4999999999999998`}}, {{-1.7820130483767358`, \
-0.9079809994790936, -1.7999999999999998`}, {-1.618033988749895, \
-1.1755705045849463`, -1.7999999999999998`}, {-1.618033988749895, \
-1.1755705045849463`, -1.4999999999999998`}, {-1.7820130483767358`, \
-0.9079809994790936, -1.4999999999999998`}}]], 
   Polygon3DBox[
    NCache[{{(-2) Cos[Rational[3, 20] Pi], (-2) 
       Sin[Rational[3, 20] Pi], -1.4999999999999998`}, {
      Rational[1, 2] (-1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -1.4999999999999998`}, {
      Rational[1, 2] (-1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -1.1999999999999997`}, {(-2) 
       Cos[Rational[3, 20] Pi], (-2) 
       Sin[Rational[3, 20] 
         Pi], -1.1999999999999997`}}, {{-1.7820130483767358`, \
-0.9079809994790936, -1.4999999999999998`}, {-1.618033988749895, \
-1.1755705045849463`, -1.4999999999999998`}, {-1.618033988749895, \
-1.1755705045849463`, -1.1999999999999997`}, {-1.7820130483767358`, \
-0.9079809994790936, -1.1999999999999997`}}]], 
   Polygon3DBox[
    NCache[{{(-2) Cos[Rational[3, 20] Pi], (-2) 
       Sin[Rational[3, 20] Pi], -1.1999999999999997`}, {
      Rational[1, 2] (-1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -1.1999999999999997`}, {
      Rational[1, 2] (-1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -0.8999999999999997}, {(-2) 
       Cos[Rational[3, 20] Pi], (-2) 
       Sin[Rational[3, 20] 
         Pi], -0.8999999999999997}}, {{-1.7820130483767358`, \
-0.9079809994790936, -1.1999999999999997`}, {-1.618033988749895, \
-1.1755705045849463`, -1.1999999999999997`}, {-1.618033988749895, \
-1.1755705045849463`, -0.8999999999999997}, {-1.7820130483767358`, \
-0.9079809994790936, -0.8999999999999997}}]], 
   Polygon3DBox[
    NCache[{{(-2) Cos[Rational[3, 20] Pi], (-2) 
       Sin[Rational[3, 20] Pi], -0.8999999999999997}, {
      Rational[1, 2] (-1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -0.8999999999999997}, {
      Rational[1, 2] (-1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -0.5999999999999996}, {(-2) 
       Cos[Rational[3, 20] Pi], (-2) 
       Sin[Rational[3, 20] 
         Pi], -0.5999999999999996}}, {{-1.7820130483767358`, \
-0.9079809994790936, -0.8999999999999997}, {-1.618033988749895, \
-1.1755705045849463`, -0.8999999999999997}, {-1.618033988749895, \
-1.1755705045849463`, -0.5999999999999996}, {-1.7820130483767358`, \
-0.9079809994790936, -0.5999999999999996}}]], 
   Polygon3DBox[
    NCache[{{(-2) Cos[Rational[3, 20] Pi], (-2) 
       Sin[Rational[3, 20] Pi], -0.5999999999999996}, {
      Rational[1, 2] (-1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -0.5999999999999996}, {
      Rational[1, 2] (-1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -0.2999999999999996}, {(-2) 
       Cos[Rational[3, 20] Pi], (-2) 
       Sin[Rational[3, 20] 
         Pi], -0.2999999999999996}}, {{-1.7820130483767358`, \
-0.9079809994790936, -0.5999999999999996}, {-1.618033988749895, \
-1.1755705045849463`, -0.5999999999999996}, {-1.618033988749895, \
-1.1755705045849463`, -0.2999999999999996}, {-1.7820130483767358`, \
-0.9079809994790936, -0.2999999999999996}}]], 
   Polygon3DBox[
    NCache[{{(-2) Cos[Rational[3, 20] Pi], (-2) 
       Sin[Rational[3, 20] Pi], -0.2999999999999996}, {
      Rational[1, 2] (-1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -0.2999999999999996}, {
      Rational[1, 2] (-1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       4.440892098500626*^-16}, {(-2) Cos[Rational[3, 20] Pi], (-2) 
       Sin[Rational[3, 20] Pi], 
       4.440892098500626*^-16}}, {{-1.7820130483767358`, -0.9079809994790936, \
-0.2999999999999996}, {-1.618033988749895, -1.1755705045849463`, \
-0.2999999999999996}, {-1.618033988749895, -1.1755705045849463`, 
     4.440892098500626*^-16}, {-1.7820130483767358`, -0.9079809994790936, 
     4.440892098500626*^-16}}]], 
   Polygon3DBox[
    NCache[{{(-2) Cos[Rational[3, 20] Pi], (-2) Sin[Rational[3, 20] Pi], 
       4.440892098500626*^-16}, {
      Rational[1, 2] (-1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       4.440892098500626*^-16}, {
      Rational[1, 2] (-1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       0.3000000000000005}, {(-2) Cos[Rational[3, 20] Pi], (-2) 
       Sin[Rational[3, 20] Pi], 
       0.3000000000000005}}, {{-1.7820130483767358`, -0.9079809994790936, 
     4.440892098500626*^-16}, {-1.618033988749895, -1.1755705045849463`, 
     4.440892098500626*^-16}, {-1.618033988749895, -1.1755705045849463`, 
     0.3000000000000005}, {-1.7820130483767358`, -0.9079809994790936, 
     0.3000000000000005}}]], 
   Polygon3DBox[
    NCache[{{(-2) Cos[Rational[3, 20] Pi], (-2) Sin[Rational[3, 20] Pi], 
       0.3000000000000005}, {
      Rational[1, 2] (-1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       0.3000000000000005}, {
      Rational[1, 2] (-1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       0.6000000000000005}, {(-2) Cos[Rational[3, 20] Pi], (-2) 
       Sin[Rational[3, 20] Pi], 
       0.6000000000000005}}, {{-1.7820130483767358`, -0.9079809994790936, 
     0.3000000000000005}, {-1.618033988749895, -1.1755705045849463`, 
     0.3000000000000005}, {-1.618033988749895, -1.1755705045849463`, 
     0.6000000000000005}, {-1.7820130483767358`, -0.9079809994790936, 
     0.6000000000000005}}]], 
   Polygon3DBox[
    NCache[{{(-2) Cos[Rational[3, 20] Pi], (-2) Sin[Rational[3, 20] Pi], 
       0.6000000000000005}, {
      Rational[1, 2] (-1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       0.6000000000000005}, {
      Rational[1, 2] (-1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       0.9000000000000006}, {(-2) Cos[Rational[3, 20] Pi], (-2) 
       Sin[Rational[3, 20] Pi], 
       0.9000000000000006}}, {{-1.7820130483767358`, -0.9079809994790936, 
     0.6000000000000005}, {-1.618033988749895, -1.1755705045849463`, 
     0.6000000000000005}, {-1.618033988749895, -1.1755705045849463`, 
     0.9000000000000006}, {-1.7820130483767358`, -0.9079809994790936, 
     0.9000000000000006}}]], 
   Polygon3DBox[
    NCache[{{(-2) Cos[Rational[3, 20] Pi], (-2) Sin[Rational[3, 20] Pi], 
       0.9000000000000006}, {
      Rational[1, 2] (-1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       0.9000000000000006}, {
      Rational[1, 2] (-1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       1.2000000000000006`}, {(-2) Cos[Rational[3, 20] Pi], (-2) 
       Sin[Rational[3, 20] Pi], 
       1.2000000000000006`}}, {{-1.7820130483767358`, -0.9079809994790936, 
     0.9000000000000006}, {-1.618033988749895, -1.1755705045849463`, 
     0.9000000000000006}, {-1.618033988749895, -1.1755705045849463`, 
     1.2000000000000006`}, {-1.7820130483767358`, -0.9079809994790936, 
     1.2000000000000006`}}]], 
   Polygon3DBox[
    NCache[{{(-2) Cos[Rational[3, 20] Pi], (-2) Sin[Rational[3, 20] Pi], 
       1.2000000000000006`}, {
      Rational[1, 2] (-1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       1.2000000000000006`}, {
      Rational[1, 2] (-1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       1.5000000000000007`}, {(-2) Cos[Rational[3, 20] Pi], (-2) 
       Sin[Rational[3, 20] Pi], 
       1.5000000000000007`}}, {{-1.7820130483767358`, -0.9079809994790936, 
     1.2000000000000006`}, {-1.618033988749895, -1.1755705045849463`, 
     1.2000000000000006`}, {-1.618033988749895, -1.1755705045849463`, 
     1.5000000000000007`}, {-1.7820130483767358`, -0.9079809994790936, 
     1.5000000000000007`}}]], 
   Polygon3DBox[
    NCache[{{(-2) Cos[Rational[3, 20] Pi], (-2) Sin[Rational[3, 20] Pi], 
       1.5000000000000007`}, {
      Rational[1, 2] (-1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       1.5000000000000007`}, {
      Rational[1, 2] (-1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       1.8000000000000007`}, {(-2) Cos[Rational[3, 20] Pi], (-2) 
       Sin[Rational[3, 20] Pi], 
       1.8000000000000007`}}, {{-1.7820130483767358`, -0.9079809994790936, 
     1.5000000000000007`}, {-1.618033988749895, -1.1755705045849463`, 
     1.5000000000000007`}, {-1.618033988749895, -1.1755705045849463`, 
     1.8000000000000007`}, {-1.7820130483767358`, -0.9079809994790936, 
     1.8000000000000007`}}]], 
   Polygon3DBox[
    NCache[{{(-2) Cos[Rational[3, 20] Pi], (-2) Sin[Rational[3, 20] Pi], 
       1.8000000000000007`}, {
      Rational[1, 2] (-1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       1.8000000000000007`}, {
      Rational[1, 2] (-1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       2.1000000000000005`}, {(-2) Cos[Rational[3, 20] Pi], (-2) 
       Sin[Rational[3, 20] Pi], 
       2.1000000000000005`}}, {{-1.7820130483767358`, -0.9079809994790936, 
     1.8000000000000007`}, {-1.618033988749895, -1.1755705045849463`, 
     1.8000000000000007`}, {-1.618033988749895, -1.1755705045849463`, 
     2.1000000000000005`}, {-1.7820130483767358`, -0.9079809994790936, 
     2.1000000000000005`}}]], 
   Polygon3DBox[
    NCache[{{(-2) Cos[Rational[3, 20] Pi], (-2) Sin[Rational[3, 20] Pi], 
       2.1000000000000005`}, {
      Rational[1, 2] (-1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       2.1000000000000005`}, {
      Rational[1, 2] (-1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       2.4000000000000004`}, {(-2) Cos[Rational[3, 20] Pi], (-2) 
       Sin[Rational[3, 20] Pi], 
       2.4000000000000004`}}, {{-1.7820130483767358`, -0.9079809994790936, 
     2.1000000000000005`}, {-1.618033988749895, -1.1755705045849463`, 
     2.1000000000000005`}, {-1.618033988749895, -1.1755705045849463`, 
     2.4000000000000004`}, {-1.7820130483767358`, -0.9079809994790936, 
     2.4000000000000004`}}]], 
   Polygon3DBox[
    NCache[{{(-2) Cos[Rational[3, 20] Pi], (-2) Sin[Rational[3, 20] Pi], 
       2.400000000000001}, {
      Rational[1, 2] (-1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       2.400000000000001}, {
      Rational[1, 2] (-1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       2.700000000000001}, {(-2) Cos[Rational[3, 20] Pi], (-2) 
       Sin[Rational[3, 20] Pi], 
       2.700000000000001}}, {{-1.7820130483767358`, -0.9079809994790936, 
     2.400000000000001}, {-1.618033988749895, -1.1755705045849463`, 
     2.400000000000001}, {-1.618033988749895, -1.1755705045849463`, 
     2.700000000000001}, {-1.7820130483767358`, -0.9079809994790936, 
     2.700000000000001}}]], 
   Polygon3DBox[
    NCache[{{(-2) Cos[Rational[3, 20] Pi], (-2) Sin[Rational[3, 20] Pi], 
       2.700000000000001}, {
      Rational[1, 2] (-1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       2.700000000000001}, {
      Rational[1, 2] (-1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       3.000000000000001}, {(-2) Cos[Rational[3, 20] Pi], (-2) 
       Sin[Rational[3, 20] Pi], 
       3.000000000000001}}, {{-1.7820130483767358`, -0.9079809994790936, 
     2.700000000000001}, {-1.618033988749895, -1.1755705045849463`, 
     2.700000000000001}, {-1.618033988749895, -1.1755705045849463`, 
     3.000000000000001}, {-1.7820130483767358`, -0.9079809994790936, 
     3.000000000000001}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (-1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], -3.}, {-2^
        Rational[1, 2], -2^Rational[1, 2], -3.}, {-2^Rational[1, 2], -2^
        Rational[1, 2], -2.7}, {
      Rational[1, 2] (-1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^
        Rational[
         1, 2], -2.7}}, {{-1.618033988749895, -1.1755705045849463`, -3.}, \
{-1.4142135623730951`, -1.4142135623730951`, -3.}, {-1.4142135623730951`, \
-1.4142135623730951`, -2.7}, {-1.618033988749895, -1.1755705045849463`, \
-2.7}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (-1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], -2.7}, {-2^
        Rational[1, 2], -2^Rational[1, 2], -2.7}, {-2^Rational[1, 2], -2^
        Rational[1, 2], -2.4000000000000004`}, {
      Rational[1, 2] (-1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^
        Rational[
         1, 2], -2.4000000000000004`}}, {{-1.618033988749895, \
-1.1755705045849463`, -2.7}, {-1.4142135623730951`, -1.4142135623730951`, \
-2.7}, {-1.4142135623730951`, -1.4142135623730951`, -2.4000000000000004`}, \
{-1.618033988749895, -1.1755705045849463`, -2.4000000000000004`}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (-1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], -2.4}, {-2^
        Rational[1, 2], -2^Rational[1, 2], -2.4}, {-2^Rational[1, 2], -2^
        Rational[1, 2], -2.0999999999999996`}, {
      Rational[1, 2] (-1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^
        Rational[
         1, 2], -2.0999999999999996`}}, {{-1.618033988749895, \
-1.1755705045849463`, -2.4}, {-1.4142135623730951`, -1.4142135623730951`, \
-2.4}, {-1.4142135623730951`, -1.4142135623730951`, -2.0999999999999996`}, \
{-1.618033988749895, -1.1755705045849463`, -2.0999999999999996`}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (-1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -2.0999999999999996`}, {-2^Rational[1, 2], -2^
        Rational[1, 2], -2.0999999999999996`}, {-2^Rational[1, 2], -2^
        Rational[1, 2], -1.7999999999999996`}, {
      Rational[1, 2] (-1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^
        Rational[
         1, 2], -1.7999999999999996`}}, {{-1.618033988749895, \
-1.1755705045849463`, -2.0999999999999996`}, {-1.4142135623730951`, \
-1.4142135623730951`, -2.0999999999999996`}, {-1.4142135623730951`, \
-1.4142135623730951`, -1.7999999999999996`}, {-1.618033988749895, \
-1.1755705045849463`, -1.7999999999999996`}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (-1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -1.7999999999999998`}, {-2^Rational[1, 2], -2^
        Rational[1, 2], -1.7999999999999998`}, {-2^Rational[1, 2], -2^
        Rational[1, 2], -1.4999999999999998`}, {
      Rational[1, 2] (-1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^
        Rational[
         1, 2], -1.4999999999999998`}}, {{-1.618033988749895, \
-1.1755705045849463`, -1.7999999999999998`}, {-1.4142135623730951`, \
-1.4142135623730951`, -1.7999999999999998`}, {-1.4142135623730951`, \
-1.4142135623730951`, -1.4999999999999998`}, {-1.618033988749895, \
-1.1755705045849463`, -1.4999999999999998`}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (-1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -1.4999999999999998`}, {-2^Rational[1, 2], -2^
        Rational[1, 2], -1.4999999999999998`}, {-2^Rational[1, 2], -2^
        Rational[1, 2], -1.1999999999999997`}, {
      Rational[1, 2] (-1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^
        Rational[
         1, 2], -1.1999999999999997`}}, {{-1.618033988749895, \
-1.1755705045849463`, -1.4999999999999998`}, {-1.4142135623730951`, \
-1.4142135623730951`, -1.4999999999999998`}, {-1.4142135623730951`, \
-1.4142135623730951`, -1.1999999999999997`}, {-1.618033988749895, \
-1.1755705045849463`, -1.1999999999999997`}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (-1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -1.1999999999999997`}, {-2^Rational[1, 2], -2^
        Rational[1, 2], -1.1999999999999997`}, {-2^Rational[1, 2], -2^
        Rational[1, 2], -0.8999999999999997}, {
      Rational[1, 2] (-1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^
        Rational[
         1, 2], -0.8999999999999997}}, {{-1.618033988749895, \
-1.1755705045849463`, -1.1999999999999997`}, {-1.4142135623730951`, \
-1.4142135623730951`, -1.1999999999999997`}, {-1.4142135623730951`, \
-1.4142135623730951`, -0.8999999999999997}, {-1.618033988749895, \
-1.1755705045849463`, -0.8999999999999997}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (-1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -0.8999999999999997}, {-2^Rational[1, 2], -2^
        Rational[1, 2], -0.8999999999999997}, {-2^Rational[1, 2], -2^
        Rational[1, 2], -0.5999999999999996}, {
      Rational[1, 2] (-1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^
        Rational[
         1, 2], -0.5999999999999996}}, {{-1.618033988749895, \
-1.1755705045849463`, -0.8999999999999997}, {-1.4142135623730951`, \
-1.4142135623730951`, -0.8999999999999997}, {-1.4142135623730951`, \
-1.4142135623730951`, -0.5999999999999996}, {-1.618033988749895, \
-1.1755705045849463`, -0.5999999999999996}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (-1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -0.5999999999999996}, {-2^Rational[1, 2], -2^
        Rational[1, 2], -0.5999999999999996}, {-2^Rational[1, 2], -2^
        Rational[1, 2], -0.2999999999999996}, {
      Rational[1, 2] (-1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^
        Rational[
         1, 2], -0.2999999999999996}}, {{-1.618033988749895, \
-1.1755705045849463`, -0.5999999999999996}, {-1.4142135623730951`, \
-1.4142135623730951`, -0.5999999999999996}, {-1.4142135623730951`, \
-1.4142135623730951`, -0.2999999999999996}, {-1.618033988749895, \
-1.1755705045849463`, -0.2999999999999996}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (-1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -0.2999999999999996}, {-2^Rational[1, 2], -2^
        Rational[1, 2], -0.2999999999999996}, {-2^Rational[1, 2], -2^
        Rational[1, 2], 4.440892098500626*^-16}, {
      Rational[1, 2] (-1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       4.440892098500626*^-16}}, {{-1.618033988749895, -1.1755705045849463`, \
-0.2999999999999996}, {-1.4142135623730951`, -1.4142135623730951`, \
-0.2999999999999996}, {-1.4142135623730951`, -1.4142135623730951`, 
     4.440892098500626*^-16}, {-1.618033988749895, -1.1755705045849463`, 
     4.440892098500626*^-16}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (-1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       4.440892098500626*^-16}, {-2^Rational[1, 2], -2^Rational[1, 2], 
       4.440892098500626*^-16}, {-2^Rational[1, 2], -2^Rational[1, 2], 
       0.3000000000000005}, {
      Rational[1, 2] (-1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       0.3000000000000005}}, {{-1.618033988749895, -1.1755705045849463`, 
     4.440892098500626*^-16}, {-1.4142135623730951`, -1.4142135623730951`, 
     4.440892098500626*^-16}, {-1.4142135623730951`, -1.4142135623730951`, 
     0.3000000000000005}, {-1.618033988749895, -1.1755705045849463`, 
     0.3000000000000005}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (-1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       0.3000000000000005}, {-2^Rational[1, 2], -2^Rational[1, 2], 
       0.3000000000000005}, {-2^Rational[1, 2], -2^Rational[1, 2], 
       0.6000000000000005}, {
      Rational[1, 2] (-1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       0.6000000000000005}}, {{-1.618033988749895, -1.1755705045849463`, 
     0.3000000000000005}, {-1.4142135623730951`, -1.4142135623730951`, 
     0.3000000000000005}, {-1.4142135623730951`, -1.4142135623730951`, 
     0.6000000000000005}, {-1.618033988749895, -1.1755705045849463`, 
     0.6000000000000005}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (-1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       0.6000000000000005}, {-2^Rational[1, 2], -2^Rational[1, 2], 
       0.6000000000000005}, {-2^Rational[1, 2], -2^Rational[1, 2], 
       0.9000000000000006}, {
      Rational[1, 2] (-1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       0.9000000000000006}}, {{-1.618033988749895, -1.1755705045849463`, 
     0.6000000000000005}, {-1.4142135623730951`, -1.4142135623730951`, 
     0.6000000000000005}, {-1.4142135623730951`, -1.4142135623730951`, 
     0.9000000000000006}, {-1.618033988749895, -1.1755705045849463`, 
     0.9000000000000006}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (-1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       0.9000000000000006}, {-2^Rational[1, 2], -2^Rational[1, 2], 
       0.9000000000000006}, {-2^Rational[1, 2], -2^Rational[1, 2], 
       1.2000000000000006`}, {
      Rational[1, 2] (-1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       1.2000000000000006`}}, {{-1.618033988749895, -1.1755705045849463`, 
     0.9000000000000006}, {-1.4142135623730951`, -1.4142135623730951`, 
     0.9000000000000006}, {-1.4142135623730951`, -1.4142135623730951`, 
     1.2000000000000006`}, {-1.618033988749895, -1.1755705045849463`, 
     1.2000000000000006`}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (-1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       1.2000000000000006`}, {-2^Rational[1, 2], -2^Rational[1, 2], 
       1.2000000000000006`}, {-2^Rational[1, 2], -2^Rational[1, 2], 
       1.5000000000000007`}, {
      Rational[1, 2] (-1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       1.5000000000000007`}}, {{-1.618033988749895, -1.1755705045849463`, 
     1.2000000000000006`}, {-1.4142135623730951`, -1.4142135623730951`, 
     1.2000000000000006`}, {-1.4142135623730951`, -1.4142135623730951`, 
     1.5000000000000007`}, {-1.618033988749895, -1.1755705045849463`, 
     1.5000000000000007`}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (-1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       1.5000000000000007`}, {-2^Rational[1, 2], -2^Rational[1, 2], 
       1.5000000000000007`}, {-2^Rational[1, 2], -2^Rational[1, 2], 
       1.8000000000000007`}, {
      Rational[1, 2] (-1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       1.8000000000000007`}}, {{-1.618033988749895, -1.1755705045849463`, 
     1.5000000000000007`}, {-1.4142135623730951`, -1.4142135623730951`, 
     1.5000000000000007`}, {-1.4142135623730951`, -1.4142135623730951`, 
     1.8000000000000007`}, {-1.618033988749895, -1.1755705045849463`, 
     1.8000000000000007`}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (-1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       1.8000000000000007`}, {-2^Rational[1, 2], -2^Rational[1, 2], 
       1.8000000000000007`}, {-2^Rational[1, 2], -2^Rational[1, 2], 
       2.1000000000000005`}, {
      Rational[1, 2] (-1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       2.1000000000000005`}}, {{-1.618033988749895, -1.1755705045849463`, 
     1.8000000000000007`}, {-1.4142135623730951`, -1.4142135623730951`, 
     1.8000000000000007`}, {-1.4142135623730951`, -1.4142135623730951`, 
     2.1000000000000005`}, {-1.618033988749895, -1.1755705045849463`, 
     2.1000000000000005`}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (-1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       2.1000000000000005`}, {-2^Rational[1, 2], -2^Rational[1, 2], 
       2.1000000000000005`}, {-2^Rational[1, 2], -2^Rational[1, 2], 
       2.4000000000000004`}, {
      Rational[1, 2] (-1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       2.4000000000000004`}}, {{-1.618033988749895, -1.1755705045849463`, 
     2.1000000000000005`}, {-1.4142135623730951`, -1.4142135623730951`, 
     2.1000000000000005`}, {-1.4142135623730951`, -1.4142135623730951`, 
     2.4000000000000004`}, {-1.618033988749895, -1.1755705045849463`, 
     2.4000000000000004`}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (-1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       2.400000000000001}, {-2^Rational[1, 2], -2^Rational[1, 2], 
       2.400000000000001}, {-2^Rational[1, 2], -2^Rational[1, 2], 
       2.700000000000001}, {
      Rational[1, 2] (-1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       2.700000000000001}}, {{-1.618033988749895, -1.1755705045849463`, 
     2.400000000000001}, {-1.4142135623730951`, -1.4142135623730951`, 
     2.400000000000001}, {-1.4142135623730951`, -1.4142135623730951`, 
     2.700000000000001}, {-1.618033988749895, -1.1755705045849463`, 
     2.700000000000001}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (-1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       2.700000000000001}, {-2^Rational[1, 2], -2^Rational[1, 2], 
       2.700000000000001}, {-2^Rational[1, 2], -2^Rational[1, 2], 
       3.000000000000001}, {
      Rational[1, 2] (-1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       3.000000000000001}}, {{-1.618033988749895, -1.1755705045849463`, 
     2.700000000000001}, {-1.4142135623730951`, -1.4142135623730951`, 
     2.700000000000001}, {-1.4142135623730951`, -1.4142135623730951`, 
     3.000000000000001}, {-1.618033988749895, -1.1755705045849463`, 
     3.000000000000001}}]], 
   Polygon3DBox[
    NCache[{{-2^Rational[1, 2], -2^
        Rational[1, 2], -3.}, {(-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 - 5^
        Rational[1, 2]), -3.}, {(-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 - 5^Rational[1, 2]), -2.7}, {-2^Rational[1, 2], -2^
        Rational[
         1, 2], -2.7}}, {{-1.4142135623730951`, -1.4142135623730951`, -3.}, \
{-1.1755705045849463`, -1.618033988749895, -3.}, {-1.1755705045849463`, \
-1.618033988749895, -2.7}, {-1.4142135623730951`, -1.4142135623730951`, \
-2.7}}]], 
   Polygon3DBox[
    NCache[{{-2^Rational[1, 2], -2^
        Rational[1, 2], -2.7}, {(-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 - 5^
        Rational[1, 2]), -2.7}, {(-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 - 5^Rational[1, 2]), -2.4000000000000004`}, {-2^
        Rational[1, 2], -2^
        Rational[
         1, 2], -2.4000000000000004`}}, {{-1.4142135623730951`, \
-1.4142135623730951`, -2.7}, {-1.1755705045849463`, -1.618033988749895, \
-2.7}, {-1.1755705045849463`, -1.618033988749895, -2.4000000000000004`}, \
{-1.4142135623730951`, -1.4142135623730951`, -2.4000000000000004`}}]], 
   Polygon3DBox[
    NCache[{{-2^Rational[1, 2], -2^
        Rational[1, 2], -2.4}, {(-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 - 5^
        Rational[1, 2]), -2.4}, {(-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 - 5^Rational[1, 2]), -2.0999999999999996`}, {-2^
        Rational[1, 2], -2^
        Rational[
         1, 2], -2.0999999999999996`}}, {{-1.4142135623730951`, \
-1.4142135623730951`, -2.4}, {-1.1755705045849463`, -1.618033988749895, \
-2.4}, {-1.1755705045849463`, -1.618033988749895, -2.0999999999999996`}, \
{-1.4142135623730951`, -1.4142135623730951`, -2.0999999999999996`}}]], 
   Polygon3DBox[
    NCache[{{-2^Rational[1, 2], -2^
        Rational[1, 2], -2.0999999999999996`}, {(-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 - 5^
        Rational[1, 2]), -2.0999999999999996`}, {(-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 - 5^Rational[1, 2]), -1.7999999999999996`}, {-2^
        Rational[1, 2], -2^
        Rational[
         1, 2], -1.7999999999999996`}}, {{-1.4142135623730951`, \
-1.4142135623730951`, -2.0999999999999996`}, {-1.1755705045849463`, \
-1.618033988749895, -2.0999999999999996`}, {-1.1755705045849463`, \
-1.618033988749895, -1.7999999999999996`}, {-1.4142135623730951`, \
-1.4142135623730951`, -1.7999999999999996`}}]], 
   Polygon3DBox[
    NCache[{{-2^Rational[1, 2], -2^
        Rational[1, 2], -1.7999999999999998`}, {(-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 - 5^
        Rational[1, 2]), -1.7999999999999998`}, {(-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 - 5^Rational[1, 2]), -1.4999999999999998`}, {-2^
        Rational[1, 2], -2^
        Rational[
         1, 2], -1.4999999999999998`}}, {{-1.4142135623730951`, \
-1.4142135623730951`, -1.7999999999999998`}, {-1.1755705045849463`, \
-1.618033988749895, -1.7999999999999998`}, {-1.1755705045849463`, \
-1.618033988749895, -1.4999999999999998`}, {-1.4142135623730951`, \
-1.4142135623730951`, -1.4999999999999998`}}]], 
   Polygon3DBox[
    NCache[{{-2^Rational[1, 2], -2^
        Rational[1, 2], -1.4999999999999998`}, {(-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 - 5^
        Rational[1, 2]), -1.4999999999999998`}, {(-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 - 5^Rational[1, 2]), -1.1999999999999997`}, {-2^
        Rational[1, 2], -2^
        Rational[
         1, 2], -1.1999999999999997`}}, {{-1.4142135623730951`, \
-1.4142135623730951`, -1.4999999999999998`}, {-1.1755705045849463`, \
-1.618033988749895, -1.4999999999999998`}, {-1.1755705045849463`, \
-1.618033988749895, -1.1999999999999997`}, {-1.4142135623730951`, \
-1.4142135623730951`, -1.1999999999999997`}}]], 
   Polygon3DBox[
    NCache[{{-2^Rational[1, 2], -2^
        Rational[1, 2], -1.1999999999999997`}, {(-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 - 5^
        Rational[1, 2]), -1.1999999999999997`}, {(-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 - 5^Rational[1, 2]), -0.8999999999999997}, {-2^
        Rational[1, 2], -2^
        Rational[
         1, 2], -0.8999999999999997}}, {{-1.4142135623730951`, \
-1.4142135623730951`, -1.1999999999999997`}, {-1.1755705045849463`, \
-1.618033988749895, -1.1999999999999997`}, {-1.1755705045849463`, \
-1.618033988749895, -0.8999999999999997}, {-1.4142135623730951`, \
-1.4142135623730951`, -0.8999999999999997}}]], 
   Polygon3DBox[
    NCache[{{-2^Rational[1, 2], -2^
        Rational[1, 2], -0.8999999999999997}, {(-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 - 5^
        Rational[1, 2]), -0.8999999999999997}, {(-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 - 5^Rational[1, 2]), -0.5999999999999996}, {-2^
        Rational[1, 2], -2^
        Rational[
         1, 2], -0.5999999999999996}}, {{-1.4142135623730951`, \
-1.4142135623730951`, -0.8999999999999997}, {-1.1755705045849463`, \
-1.618033988749895, -0.8999999999999997}, {-1.1755705045849463`, \
-1.618033988749895, -0.5999999999999996}, {-1.4142135623730951`, \
-1.4142135623730951`, -0.5999999999999996}}]], 
   Polygon3DBox[
    NCache[{{-2^Rational[1, 2], -2^
        Rational[1, 2], -0.5999999999999996}, {(-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 - 5^
        Rational[1, 2]), -0.5999999999999996}, {(-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 - 5^Rational[1, 2]), -0.2999999999999996}, {-2^
        Rational[1, 2], -2^
        Rational[
         1, 2], -0.2999999999999996}}, {{-1.4142135623730951`, \
-1.4142135623730951`, -0.5999999999999996}, {-1.1755705045849463`, \
-1.618033988749895, -0.5999999999999996}, {-1.1755705045849463`, \
-1.618033988749895, -0.2999999999999996}, {-1.4142135623730951`, \
-1.4142135623730951`, -0.2999999999999996}}]], 
   Polygon3DBox[
    NCache[{{-2^Rational[1, 2], -2^
        Rational[1, 2], -0.2999999999999996}, {(-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 - 5^
        Rational[1, 2]), -0.2999999999999996}, {(-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       4.440892098500626*^-16}, {-2^Rational[1, 2], -2^Rational[1, 2], 
       4.440892098500626*^-16}}, {{-1.4142135623730951`, \
-1.4142135623730951`, -0.2999999999999996}, {-1.1755705045849463`, \
-1.618033988749895, -0.2999999999999996}, {-1.1755705045849463`, \
-1.618033988749895, 
     4.440892098500626*^-16}, {-1.4142135623730951`, -1.4142135623730951`, 
     4.440892098500626*^-16}}]], 
   Polygon3DBox[
    NCache[{{-2^Rational[1, 2], -2^Rational[1, 2], 
       4.440892098500626*^-16}, {(-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       4.440892098500626*^-16}, {(-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       0.3000000000000005}, {-2^Rational[1, 2], -2^Rational[1, 2], 
       0.3000000000000005}}, {{-1.4142135623730951`, -1.4142135623730951`, 
     4.440892098500626*^-16}, {-1.1755705045849463`, -1.618033988749895, 
     4.440892098500626*^-16}, {-1.1755705045849463`, -1.618033988749895, 
     0.3000000000000005}, {-1.4142135623730951`, -1.4142135623730951`, 
     0.3000000000000005}}]], 
   Polygon3DBox[
    NCache[{{-2^Rational[1, 2], -2^Rational[1, 2], 
       0.3000000000000005}, {(-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       0.3000000000000005}, {(-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       0.6000000000000005}, {-2^Rational[1, 2], -2^Rational[1, 2], 
       0.6000000000000005}}, {{-1.4142135623730951`, -1.4142135623730951`, 
     0.3000000000000005}, {-1.1755705045849463`, -1.618033988749895, 
     0.3000000000000005}, {-1.1755705045849463`, -1.618033988749895, 
     0.6000000000000005}, {-1.4142135623730951`, -1.4142135623730951`, 
     0.6000000000000005}}]], 
   Polygon3DBox[
    NCache[{{-2^Rational[1, 2], -2^Rational[1, 2], 
       0.6000000000000005}, {(-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       0.6000000000000005}, {(-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       0.9000000000000006}, {-2^Rational[1, 2], -2^Rational[1, 2], 
       0.9000000000000006}}, {{-1.4142135623730951`, -1.4142135623730951`, 
     0.6000000000000005}, {-1.1755705045849463`, -1.618033988749895, 
     0.6000000000000005}, {-1.1755705045849463`, -1.618033988749895, 
     0.9000000000000006}, {-1.4142135623730951`, -1.4142135623730951`, 
     0.9000000000000006}}]], 
   Polygon3DBox[
    NCache[{{-2^Rational[1, 2], -2^Rational[1, 2], 
       0.9000000000000006}, {(-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       0.9000000000000006}, {(-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       1.2000000000000006`}, {-2^Rational[1, 2], -2^Rational[1, 2], 
       1.2000000000000006`}}, {{-1.4142135623730951`, -1.4142135623730951`, 
     0.9000000000000006}, {-1.1755705045849463`, -1.618033988749895, 
     0.9000000000000006}, {-1.1755705045849463`, -1.618033988749895, 
     1.2000000000000006`}, {-1.4142135623730951`, -1.4142135623730951`, 
     1.2000000000000006`}}]], 
   Polygon3DBox[
    NCache[{{-2^Rational[1, 2], -2^Rational[1, 2], 
       1.2000000000000006`}, {(-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       1.2000000000000006`}, {(-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       1.5000000000000007`}, {-2^Rational[1, 2], -2^Rational[1, 2], 
       1.5000000000000007`}}, {{-1.4142135623730951`, -1.4142135623730951`, 
     1.2000000000000006`}, {-1.1755705045849463`, -1.618033988749895, 
     1.2000000000000006`}, {-1.1755705045849463`, -1.618033988749895, 
     1.5000000000000007`}, {-1.4142135623730951`, -1.4142135623730951`, 
     1.5000000000000007`}}]], 
   Polygon3DBox[
    NCache[{{-2^Rational[1, 2], -2^Rational[1, 2], 
       1.5000000000000007`}, {(-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       1.5000000000000007`}, {(-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       1.8000000000000007`}, {-2^Rational[1, 2], -2^Rational[1, 2], 
       1.8000000000000007`}}, {{-1.4142135623730951`, -1.4142135623730951`, 
     1.5000000000000007`}, {-1.1755705045849463`, -1.618033988749895, 
     1.5000000000000007`}, {-1.1755705045849463`, -1.618033988749895, 
     1.8000000000000007`}, {-1.4142135623730951`, -1.4142135623730951`, 
     1.8000000000000007`}}]], 
   Polygon3DBox[
    NCache[{{-2^Rational[1, 2], -2^Rational[1, 2], 
       1.8000000000000007`}, {(-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       1.8000000000000007`}, {(-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       2.1000000000000005`}, {-2^Rational[1, 2], -2^Rational[1, 2], 
       2.1000000000000005`}}, {{-1.4142135623730951`, -1.4142135623730951`, 
     1.8000000000000007`}, {-1.1755705045849463`, -1.618033988749895, 
     1.8000000000000007`}, {-1.1755705045849463`, -1.618033988749895, 
     2.1000000000000005`}, {-1.4142135623730951`, -1.4142135623730951`, 
     2.1000000000000005`}}]], 
   Polygon3DBox[
    NCache[{{-2^Rational[1, 2], -2^Rational[1, 2], 
       2.1000000000000005`}, {(-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       2.1000000000000005`}, {(-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       2.4000000000000004`}, {-2^Rational[1, 2], -2^Rational[1, 2], 
       2.4000000000000004`}}, {{-1.4142135623730951`, -1.4142135623730951`, 
     2.1000000000000005`}, {-1.1755705045849463`, -1.618033988749895, 
     2.1000000000000005`}, {-1.1755705045849463`, -1.618033988749895, 
     2.4000000000000004`}, {-1.4142135623730951`, -1.4142135623730951`, 
     2.4000000000000004`}}]], 
   Polygon3DBox[
    NCache[{{-2^Rational[1, 2], -2^Rational[1, 2], 
       2.400000000000001}, {(-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       2.400000000000001}, {(-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       2.700000000000001}, {-2^Rational[1, 2], -2^Rational[1, 2], 
       2.700000000000001}}, {{-1.4142135623730951`, -1.4142135623730951`, 
     2.400000000000001}, {-1.1755705045849463`, -1.618033988749895, 
     2.400000000000001}, {-1.1755705045849463`, -1.618033988749895, 
     2.700000000000001}, {-1.4142135623730951`, -1.4142135623730951`, 
     2.700000000000001}}]], 
   Polygon3DBox[
    NCache[{{-2^Rational[1, 2], -2^Rational[1, 2], 
       2.700000000000001}, {(-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       2.700000000000001}, {(-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       3.000000000000001}, {-2^Rational[1, 2], -2^Rational[1, 2], 
       3.000000000000001}}, {{-1.4142135623730951`, -1.4142135623730951`, 
     2.700000000000001}, {-1.1755705045849463`, -1.618033988749895, 
     2.700000000000001}, {-1.1755705045849463`, -1.618033988749895, 
     3.000000000000001}, {-1.4142135623730951`, -1.4142135623730951`, 
     3.000000000000001}}]], 
   Polygon3DBox[
    NCache[{{(-2) (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 2] (-1 - 5^Rational[1, 2]), -3.}, {(-2) 
       Sin[Rational[3, 20] Pi], (-2) Cos[Rational[3, 20] Pi], -3.}, {(-2) 
       Sin[Rational[3, 20] Pi], (-2) 
       Cos[Rational[3, 20] Pi], -2.7}, {(-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 - 5^
        Rational[
         1, 2]), -2.7}}, {{-1.1755705045849463`, -1.618033988749895, -3.}, \
{-0.9079809994790936, -1.7820130483767358`, -3.}, {-0.9079809994790936, \
-1.7820130483767358`, -2.7}, {-1.1755705045849463`, -1.618033988749895, \
-2.7}}]], 
   Polygon3DBox[
    NCache[{{(-2) (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 2] (-1 - 5^Rational[1, 2]), -2.7}, {(-2) 
       Sin[Rational[3, 20] Pi], (-2) Cos[Rational[3, 20] Pi], -2.7}, {(-2) 
       Sin[Rational[3, 20] Pi], (-2) 
       Cos[Rational[3, 20] Pi], -2.4000000000000004`}, {(-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 - 5^
        Rational[
         1, 2]), -2.4000000000000004`}}, {{-1.1755705045849463`, \
-1.618033988749895, -2.7}, {-0.9079809994790936, -1.7820130483767358`, -2.7}, \
{-0.9079809994790936, -1.7820130483767358`, -2.4000000000000004`}, \
{-1.1755705045849463`, -1.618033988749895, -2.4000000000000004`}}]], 
   Polygon3DBox[
    NCache[{{(-2) (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 2] (-1 - 5^Rational[1, 2]), -2.4}, {(-2) 
       Sin[Rational[3, 20] Pi], (-2) Cos[Rational[3, 20] Pi], -2.4}, {(-2) 
       Sin[Rational[3, 20] Pi], (-2) 
       Cos[Rational[3, 20] Pi], -2.0999999999999996`}, {(-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 - 5^
        Rational[
         1, 2]), -2.0999999999999996`}}, {{-1.1755705045849463`, \
-1.618033988749895, -2.4}, {-0.9079809994790936, -1.7820130483767358`, -2.4}, \
{-0.9079809994790936, -1.7820130483767358`, -2.0999999999999996`}, \
{-1.1755705045849463`, -1.618033988749895, -2.0999999999999996`}}]], 
   Polygon3DBox[
    NCache[{{(-2) (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], 
       Rational[1, 2] (-1 - 5^Rational[1, 2]), -2.0999999999999996`}, {(-2) 
       Sin[Rational[3, 20] Pi], (-2) 
       Cos[Rational[3, 20] Pi], -2.0999999999999996`}, {(-2) 
       Sin[Rational[3, 20] Pi], (-2) 
       Cos[Rational[3, 20] Pi], -1.7999999999999996`}, {(-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 - 5^
        Rational[
         1, 2]), -1.7999999999999996`}}, {{-1.1755705045849463`, \
-1.618033988749895, -2.0999999999999996`}, {-0.9079809994790936, \
-1.7820130483767358`, -2.0999999999999996`}, {-0.9079809994790936, \
-1.7820130483767358`, -1.7999999999999996`}, {-1.1755705045849463`, \
-1.618033988749895, -1.7999999999999996`}}]], 
   Polygon3DBox[
    NCache[{{(-2) (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], 
       Rational[1, 2] (-1 - 5^Rational[1, 2]), -1.7999999999999998`}, {(-2) 
       Sin[Rational[3, 20] Pi], (-2) 
       Cos[Rational[3, 20] Pi], -1.7999999999999998`}, {(-2) 
       Sin[Rational[3, 20] Pi], (-2) 
       Cos[Rational[3, 20] Pi], -1.4999999999999998`}, {(-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 - 5^
        Rational[
         1, 2]), -1.4999999999999998`}}, {{-1.1755705045849463`, \
-1.618033988749895, -1.7999999999999998`}, {-0.9079809994790936, \
-1.7820130483767358`, -1.7999999999999998`}, {-0.9079809994790936, \
-1.7820130483767358`, -1.4999999999999998`}, {-1.1755705045849463`, \
-1.618033988749895, -1.4999999999999998`}}]], 
   Polygon3DBox[
    NCache[{{(-2) (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], 
       Rational[1, 2] (-1 - 5^Rational[1, 2]), -1.4999999999999998`}, {(-2) 
       Sin[Rational[3, 20] Pi], (-2) 
       Cos[Rational[3, 20] Pi], -1.4999999999999998`}, {(-2) 
       Sin[Rational[3, 20] Pi], (-2) 
       Cos[Rational[3, 20] Pi], -1.1999999999999997`}, {(-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 - 5^
        Rational[
         1, 2]), -1.1999999999999997`}}, {{-1.1755705045849463`, \
-1.618033988749895, -1.4999999999999998`}, {-0.9079809994790936, \
-1.7820130483767358`, -1.4999999999999998`}, {-0.9079809994790936, \
-1.7820130483767358`, -1.1999999999999997`}, {-1.1755705045849463`, \
-1.618033988749895, -1.1999999999999997`}}]], 
   Polygon3DBox[
    NCache[{{(-2) (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], 
       Rational[1, 2] (-1 - 5^Rational[1, 2]), -1.1999999999999997`}, {(-2) 
       Sin[Rational[3, 20] Pi], (-2) 
       Cos[Rational[3, 20] Pi], -1.1999999999999997`}, {(-2) 
       Sin[Rational[3, 20] Pi], (-2) 
       Cos[Rational[3, 20] Pi], -0.8999999999999997}, {(-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 - 5^
        Rational[
         1, 2]), -0.8999999999999997}}, {{-1.1755705045849463`, \
-1.618033988749895, -1.1999999999999997`}, {-0.9079809994790936, \
-1.7820130483767358`, -1.1999999999999997`}, {-0.9079809994790936, \
-1.7820130483767358`, -0.8999999999999997}, {-1.1755705045849463`, \
-1.618033988749895, -0.8999999999999997}}]], 
   Polygon3DBox[
    NCache[{{(-2) (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], 
       Rational[1, 2] (-1 - 5^Rational[1, 2]), -0.8999999999999997}, {(-2) 
       Sin[Rational[3, 20] Pi], (-2) 
       Cos[Rational[3, 20] Pi], -0.8999999999999997}, {(-2) 
       Sin[Rational[3, 20] Pi], (-2) 
       Cos[Rational[3, 20] Pi], -0.5999999999999996}, {(-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 - 5^
        Rational[
         1, 2]), -0.5999999999999996}}, {{-1.1755705045849463`, \
-1.618033988749895, -0.8999999999999997}, {-0.9079809994790936, \
-1.7820130483767358`, -0.8999999999999997}, {-0.9079809994790936, \
-1.7820130483767358`, -0.5999999999999996}, {-1.1755705045849463`, \
-1.618033988749895, -0.5999999999999996}}]], 
   Polygon3DBox[
    NCache[{{(-2) (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], 
       Rational[1, 2] (-1 - 5^Rational[1, 2]), -0.5999999999999996}, {(-2) 
       Sin[Rational[3, 20] Pi], (-2) 
       Cos[Rational[3, 20] Pi], -0.5999999999999996}, {(-2) 
       Sin[Rational[3, 20] Pi], (-2) 
       Cos[Rational[3, 20] Pi], -0.2999999999999996}, {(-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 - 5^
        Rational[
         1, 2]), -0.2999999999999996}}, {{-1.1755705045849463`, \
-1.618033988749895, -0.5999999999999996}, {-0.9079809994790936, \
-1.7820130483767358`, -0.5999999999999996}, {-0.9079809994790936, \
-1.7820130483767358`, -0.2999999999999996}, {-1.1755705045849463`, \
-1.618033988749895, -0.2999999999999996}}]], 
   Polygon3DBox[
    NCache[{{(-2) (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], 
       Rational[1, 2] (-1 - 5^Rational[1, 2]), -0.2999999999999996}, {(-2) 
       Sin[Rational[3, 20] Pi], (-2) 
       Cos[Rational[3, 20] Pi], -0.2999999999999996}, {(-2) 
       Sin[Rational[3, 20] Pi], (-2) Cos[Rational[3, 20] Pi], 
       4.440892098500626*^-16}, {(-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       4.440892098500626*^-16}}, {{-1.1755705045849463`, -1.618033988749895, \
-0.2999999999999996}, {-0.9079809994790936, -1.7820130483767358`, \
-0.2999999999999996}, {-0.9079809994790936, -1.7820130483767358`, 
     4.440892098500626*^-16}, {-1.1755705045849463`, -1.618033988749895, 
     4.440892098500626*^-16}}]], 
   Polygon3DBox[
    NCache[{{(-2) (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       4.440892098500626*^-16}, {(-2) Sin[Rational[3, 20] Pi], (-2) 
       Cos[Rational[3, 20] Pi], 4.440892098500626*^-16}, {(-2) 
       Sin[Rational[3, 20] Pi], (-2) Cos[Rational[3, 20] Pi], 
       0.3000000000000005}, {(-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       0.3000000000000005}}, {{-1.1755705045849463`, -1.618033988749895, 
     4.440892098500626*^-16}, {-0.9079809994790936, -1.7820130483767358`, 
     4.440892098500626*^-16}, {-0.9079809994790936, -1.7820130483767358`, 
     0.3000000000000005}, {-1.1755705045849463`, -1.618033988749895, 
     0.3000000000000005}}]], 
   Polygon3DBox[
    NCache[{{(-2) (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       0.3000000000000005}, {(-2) Sin[Rational[3, 20] Pi], (-2) 
       Cos[Rational[3, 20] Pi], 0.3000000000000005}, {(-2) 
       Sin[Rational[3, 20] Pi], (-2) Cos[Rational[3, 20] Pi], 
       0.6000000000000005}, {(-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       0.6000000000000005}}, {{-1.1755705045849463`, -1.618033988749895, 
     0.3000000000000005}, {-0.9079809994790936, -1.7820130483767358`, 
     0.3000000000000005}, {-0.9079809994790936, -1.7820130483767358`, 
     0.6000000000000005}, {-1.1755705045849463`, -1.618033988749895, 
     0.6000000000000005}}]], 
   Polygon3DBox[
    NCache[{{(-2) (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       0.6000000000000005}, {(-2) Sin[Rational[3, 20] Pi], (-2) 
       Cos[Rational[3, 20] Pi], 0.6000000000000005}, {(-2) 
       Sin[Rational[3, 20] Pi], (-2) Cos[Rational[3, 20] Pi], 
       0.9000000000000006}, {(-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       0.9000000000000006}}, {{-1.1755705045849463`, -1.618033988749895, 
     0.6000000000000005}, {-0.9079809994790936, -1.7820130483767358`, 
     0.6000000000000005}, {-0.9079809994790936, -1.7820130483767358`, 
     0.9000000000000006}, {-1.1755705045849463`, -1.618033988749895, 
     0.9000000000000006}}]], 
   Polygon3DBox[
    NCache[{{(-2) (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       0.9000000000000006}, {(-2) Sin[Rational[3, 20] Pi], (-2) 
       Cos[Rational[3, 20] Pi], 0.9000000000000006}, {(-2) 
       Sin[Rational[3, 20] Pi], (-2) Cos[Rational[3, 20] Pi], 
       1.2000000000000006`}, {(-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       1.2000000000000006`}}, {{-1.1755705045849463`, -1.618033988749895, 
     0.9000000000000006}, {-0.9079809994790936, -1.7820130483767358`, 
     0.9000000000000006}, {-0.9079809994790936, -1.7820130483767358`, 
     1.2000000000000006`}, {-1.1755705045849463`, -1.618033988749895, 
     1.2000000000000006`}}]], 
   Polygon3DBox[
    NCache[{{(-2) (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       1.2000000000000006`}, {(-2) Sin[Rational[3, 20] Pi], (-2) 
       Cos[Rational[3, 20] Pi], 1.2000000000000006`}, {(-2) 
       Sin[Rational[3, 20] Pi], (-2) Cos[Rational[3, 20] Pi], 
       1.5000000000000007`}, {(-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       1.5000000000000007`}}, {{-1.1755705045849463`, -1.618033988749895, 
     1.2000000000000006`}, {-0.9079809994790936, -1.7820130483767358`, 
     1.2000000000000006`}, {-0.9079809994790936, -1.7820130483767358`, 
     1.5000000000000007`}, {-1.1755705045849463`, -1.618033988749895, 
     1.5000000000000007`}}]], 
   Polygon3DBox[
    NCache[{{(-2) (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       1.5000000000000007`}, {(-2) Sin[Rational[3, 20] Pi], (-2) 
       Cos[Rational[3, 20] Pi], 1.5000000000000007`}, {(-2) 
       Sin[Rational[3, 20] Pi], (-2) Cos[Rational[3, 20] Pi], 
       1.8000000000000007`}, {(-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       1.8000000000000007`}}, {{-1.1755705045849463`, -1.618033988749895, 
     1.5000000000000007`}, {-0.9079809994790936, -1.7820130483767358`, 
     1.5000000000000007`}, {-0.9079809994790936, -1.7820130483767358`, 
     1.8000000000000007`}, {-1.1755705045849463`, -1.618033988749895, 
     1.8000000000000007`}}]], 
   Polygon3DBox[
    NCache[{{(-2) (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       1.8000000000000007`}, {(-2) Sin[Rational[3, 20] Pi], (-2) 
       Cos[Rational[3, 20] Pi], 1.8000000000000007`}, {(-2) 
       Sin[Rational[3, 20] Pi], (-2) Cos[Rational[3, 20] Pi], 
       2.1000000000000005`}, {(-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       2.1000000000000005`}}, {{-1.1755705045849463`, -1.618033988749895, 
     1.8000000000000007`}, {-0.9079809994790936, -1.7820130483767358`, 
     1.8000000000000007`}, {-0.9079809994790936, -1.7820130483767358`, 
     2.1000000000000005`}, {-1.1755705045849463`, -1.618033988749895, 
     2.1000000000000005`}}]], 
   Polygon3DBox[
    NCache[{{(-2) (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       2.1000000000000005`}, {(-2) Sin[Rational[3, 20] Pi], (-2) 
       Cos[Rational[3, 20] Pi], 2.1000000000000005`}, {(-2) 
       Sin[Rational[3, 20] Pi], (-2) Cos[Rational[3, 20] Pi], 
       2.4000000000000004`}, {(-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       2.4000000000000004`}}, {{-1.1755705045849463`, -1.618033988749895, 
     2.1000000000000005`}, {-0.9079809994790936, -1.7820130483767358`, 
     2.1000000000000005`}, {-0.9079809994790936, -1.7820130483767358`, 
     2.4000000000000004`}, {-1.1755705045849463`, -1.618033988749895, 
     2.4000000000000004`}}]], 
   Polygon3DBox[
    NCache[{{(-2) (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       2.400000000000001}, {(-2) Sin[Rational[3, 20] Pi], (-2) 
       Cos[Rational[3, 20] Pi], 2.400000000000001}, {(-2) 
       Sin[Rational[3, 20] Pi], (-2) Cos[Rational[3, 20] Pi], 
       2.700000000000001}, {(-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       2.700000000000001}}, {{-1.1755705045849463`, -1.618033988749895, 
     2.400000000000001}, {-0.9079809994790936, -1.7820130483767358`, 
     2.400000000000001}, {-0.9079809994790936, -1.7820130483767358`, 
     2.700000000000001}, {-1.1755705045849463`, -1.618033988749895, 
     2.700000000000001}}]], 
   Polygon3DBox[
    NCache[{{(-2) (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       2.700000000000001}, {(-2) Sin[Rational[3, 20] Pi], (-2) 
       Cos[Rational[3, 20] Pi], 2.700000000000001}, {(-2) 
       Sin[Rational[3, 20] Pi], (-2) Cos[Rational[3, 20] Pi], 
       3.000000000000001}, {(-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       3.000000000000001}}, {{-1.1755705045849463`, -1.618033988749895, 
     2.700000000000001}, {-0.9079809994790936, -1.7820130483767358`, 
     2.700000000000001}, {-0.9079809994790936, -1.7820130483767358`, 
     3.000000000000001}, {-1.1755705045849463`, -1.618033988749895, 
     3.000000000000001}}]], 
   Polygon3DBox[
    NCache[{{(-2) Sin[Rational[3, 20] Pi], (-2) 
       Cos[Rational[3, 20] Pi], -3.}, {
      Rational[1, 2] (1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], -3.}, {
      Rational[1, 2] (1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], -2.7}, {(-2) 
       Sin[Rational[3, 20] Pi], (-2) 
       Cos[Rational[3, 20] 
         Pi], -2.7}}, {{-0.9079809994790936, -1.7820130483767358`, -3.}, \
{-0.6180339887498949, -1.902113032590307, -3.}, {-0.6180339887498949, \
-1.902113032590307, -2.7}, {-0.9079809994790936, -1.7820130483767358`, \
-2.7}}]], 
   Polygon3DBox[
    NCache[{{(-2) Sin[Rational[3, 20] Pi], (-2) 
       Cos[Rational[3, 20] Pi], -2.7}, {
      Rational[1, 2] (1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], -2.7}, {
      Rational[1, 2] (1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -2.4000000000000004`}, {(-2) 
       Sin[Rational[3, 20] Pi], (-2) 
       Cos[Rational[3, 20] 
         Pi], -2.4000000000000004`}}, {{-0.9079809994790936, \
-1.7820130483767358`, -2.7}, {-0.6180339887498949, -1.902113032590307, -2.7}, \
{-0.6180339887498949, -1.902113032590307, -2.4000000000000004`}, \
{-0.9079809994790936, -1.7820130483767358`, -2.4000000000000004`}}]], 
   Polygon3DBox[
    NCache[{{(-2) Sin[Rational[3, 20] Pi], (-2) 
       Cos[Rational[3, 20] Pi], -2.4}, {
      Rational[1, 2] (1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], -2.4}, {
      Rational[1, 2] (1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -2.0999999999999996`}, {(-2) 
       Sin[Rational[3, 20] Pi], (-2) 
       Cos[Rational[3, 20] 
         Pi], -2.0999999999999996`}}, {{-0.9079809994790936, \
-1.7820130483767358`, -2.4}, {-0.6180339887498949, -1.902113032590307, -2.4}, \
{-0.6180339887498949, -1.902113032590307, -2.0999999999999996`}, \
{-0.9079809994790936, -1.7820130483767358`, -2.0999999999999996`}}]], 
   Polygon3DBox[
    NCache[{{(-2) Sin[Rational[3, 20] Pi], (-2) 
       Cos[Rational[3, 20] Pi], -2.0999999999999996`}, {
      Rational[1, 2] (1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -2.0999999999999996`}, {
      Rational[1, 2] (1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -1.7999999999999996`}, {(-2) 
       Sin[Rational[3, 20] Pi], (-2) 
       Cos[Rational[3, 20] 
         Pi], -1.7999999999999996`}}, {{-0.9079809994790936, \
-1.7820130483767358`, -2.0999999999999996`}, {-0.6180339887498949, \
-1.902113032590307, -2.0999999999999996`}, {-0.6180339887498949, \
-1.902113032590307, -1.7999999999999996`}, {-0.9079809994790936, \
-1.7820130483767358`, -1.7999999999999996`}}]], 
   Polygon3DBox[
    NCache[{{(-2) Sin[Rational[3, 20] Pi], (-2) 
       Cos[Rational[3, 20] Pi], -1.7999999999999998`}, {
      Rational[1, 2] (1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -1.7999999999999998`}, {
      Rational[1, 2] (1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -1.4999999999999998`}, {(-2) 
       Sin[Rational[3, 20] Pi], (-2) 
       Cos[Rational[3, 20] 
         Pi], -1.4999999999999998`}}, {{-0.9079809994790936, \
-1.7820130483767358`, -1.7999999999999998`}, {-0.6180339887498949, \
-1.902113032590307, -1.7999999999999998`}, {-0.6180339887498949, \
-1.902113032590307, -1.4999999999999998`}, {-0.9079809994790936, \
-1.7820130483767358`, -1.4999999999999998`}}]], 
   Polygon3DBox[
    NCache[{{(-2) Sin[Rational[3, 20] Pi], (-2) 
       Cos[Rational[3, 20] Pi], -1.4999999999999998`}, {
      Rational[1, 2] (1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -1.4999999999999998`}, {
      Rational[1, 2] (1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -1.1999999999999997`}, {(-2) 
       Sin[Rational[3, 20] Pi], (-2) 
       Cos[Rational[3, 20] 
         Pi], -1.1999999999999997`}}, {{-0.9079809994790936, \
-1.7820130483767358`, -1.4999999999999998`}, {-0.6180339887498949, \
-1.902113032590307, -1.4999999999999998`}, {-0.6180339887498949, \
-1.902113032590307, -1.1999999999999997`}, {-0.9079809994790936, \
-1.7820130483767358`, -1.1999999999999997`}}]], 
   Polygon3DBox[
    NCache[{{(-2) Sin[Rational[3, 20] Pi], (-2) 
       Cos[Rational[3, 20] Pi], -1.1999999999999997`}, {
      Rational[1, 2] (1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -1.1999999999999997`}, {
      Rational[1, 2] (1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -0.8999999999999997}, {(-2) 
       Sin[Rational[3, 20] Pi], (-2) 
       Cos[Rational[3, 20] 
         Pi], -0.8999999999999997}}, {{-0.9079809994790936, \
-1.7820130483767358`, -1.1999999999999997`}, {-0.6180339887498949, \
-1.902113032590307, -1.1999999999999997`}, {-0.6180339887498949, \
-1.902113032590307, -0.8999999999999997}, {-0.9079809994790936, \
-1.7820130483767358`, -0.8999999999999997}}]], 
   Polygon3DBox[
    NCache[{{(-2) Sin[Rational[3, 20] Pi], (-2) 
       Cos[Rational[3, 20] Pi], -0.8999999999999997}, {
      Rational[1, 2] (1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -0.8999999999999997}, {
      Rational[1, 2] (1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -0.5999999999999996}, {(-2) 
       Sin[Rational[3, 20] Pi], (-2) 
       Cos[Rational[3, 20] 
         Pi], -0.5999999999999996}}, {{-0.9079809994790936, \
-1.7820130483767358`, -0.8999999999999997}, {-0.6180339887498949, \
-1.902113032590307, -0.8999999999999997}, {-0.6180339887498949, \
-1.902113032590307, -0.5999999999999996}, {-0.9079809994790936, \
-1.7820130483767358`, -0.5999999999999996}}]], 
   Polygon3DBox[
    NCache[{{(-2) Sin[Rational[3, 20] Pi], (-2) 
       Cos[Rational[3, 20] Pi], -0.5999999999999996}, {
      Rational[1, 2] (1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -0.5999999999999996}, {
      Rational[1, 2] (1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -0.2999999999999996}, {(-2) 
       Sin[Rational[3, 20] Pi], (-2) 
       Cos[Rational[3, 20] 
         Pi], -0.2999999999999996}}, {{-0.9079809994790936, \
-1.7820130483767358`, -0.5999999999999996}, {-0.6180339887498949, \
-1.902113032590307, -0.5999999999999996}, {-0.6180339887498949, \
-1.902113032590307, -0.2999999999999996}, {-0.9079809994790936, \
-1.7820130483767358`, -0.2999999999999996}}]], 
   Polygon3DBox[
    NCache[{{(-2) Sin[Rational[3, 20] Pi], (-2) 
       Cos[Rational[3, 20] Pi], -0.2999999999999996}, {
      Rational[1, 2] (1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -0.2999999999999996}, {
      Rational[1, 2] (1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       4.440892098500626*^-16}, {(-2) Sin[Rational[3, 20] Pi], (-2) 
       Cos[Rational[3, 20] Pi], 
       4.440892098500626*^-16}}, {{-0.9079809994790936, -1.7820130483767358`, \
-0.2999999999999996}, {-0.6180339887498949, -1.902113032590307, \
-0.2999999999999996}, {-0.6180339887498949, -1.902113032590307, 
     4.440892098500626*^-16}, {-0.9079809994790936, -1.7820130483767358`, 
     4.440892098500626*^-16}}]], 
   Polygon3DBox[
    NCache[{{(-2) Sin[Rational[3, 20] Pi], (-2) Cos[Rational[3, 20] Pi], 
       4.440892098500626*^-16}, {
      Rational[1, 2] (1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       4.440892098500626*^-16}, {
      Rational[1, 2] (1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       0.3000000000000005}, {(-2) Sin[Rational[3, 20] Pi], (-2) 
       Cos[Rational[3, 20] Pi], 
       0.3000000000000005}}, {{-0.9079809994790936, -1.7820130483767358`, 
     4.440892098500626*^-16}, {-0.6180339887498949, -1.902113032590307, 
     4.440892098500626*^-16}, {-0.6180339887498949, -1.902113032590307, 
     0.3000000000000005}, {-0.9079809994790936, -1.7820130483767358`, 
     0.3000000000000005}}]], 
   Polygon3DBox[
    NCache[{{(-2) Sin[Rational[3, 20] Pi], (-2) Cos[Rational[3, 20] Pi], 
       0.3000000000000005}, {
      Rational[1, 2] (1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       0.3000000000000005}, {
      Rational[1, 2] (1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       0.6000000000000005}, {(-2) Sin[Rational[3, 20] Pi], (-2) 
       Cos[Rational[3, 20] Pi], 
       0.6000000000000005}}, {{-0.9079809994790936, -1.7820130483767358`, 
     0.3000000000000005}, {-0.6180339887498949, -1.902113032590307, 
     0.3000000000000005}, {-0.6180339887498949, -1.902113032590307, 
     0.6000000000000005}, {-0.9079809994790936, -1.7820130483767358`, 
     0.6000000000000005}}]], 
   Polygon3DBox[
    NCache[{{(-2) Sin[Rational[3, 20] Pi], (-2) Cos[Rational[3, 20] Pi], 
       0.6000000000000005}, {
      Rational[1, 2] (1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       0.6000000000000005}, {
      Rational[1, 2] (1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       0.9000000000000006}, {(-2) Sin[Rational[3, 20] Pi], (-2) 
       Cos[Rational[3, 20] Pi], 
       0.9000000000000006}}, {{-0.9079809994790936, -1.7820130483767358`, 
     0.6000000000000005}, {-0.6180339887498949, -1.902113032590307, 
     0.6000000000000005}, {-0.6180339887498949, -1.902113032590307, 
     0.9000000000000006}, {-0.9079809994790936, -1.7820130483767358`, 
     0.9000000000000006}}]], 
   Polygon3DBox[
    NCache[{{(-2) Sin[Rational[3, 20] Pi], (-2) Cos[Rational[3, 20] Pi], 
       0.9000000000000006}, {
      Rational[1, 2] (1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       0.9000000000000006}, {
      Rational[1, 2] (1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       1.2000000000000006`}, {(-2) Sin[Rational[3, 20] Pi], (-2) 
       Cos[Rational[3, 20] Pi], 
       1.2000000000000006`}}, {{-0.9079809994790936, -1.7820130483767358`, 
     0.9000000000000006}, {-0.6180339887498949, -1.902113032590307, 
     0.9000000000000006}, {-0.6180339887498949, -1.902113032590307, 
     1.2000000000000006`}, {-0.9079809994790936, -1.7820130483767358`, 
     1.2000000000000006`}}]], 
   Polygon3DBox[
    NCache[{{(-2) Sin[Rational[3, 20] Pi], (-2) Cos[Rational[3, 20] Pi], 
       1.2000000000000006`}, {
      Rational[1, 2] (1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       1.2000000000000006`}, {
      Rational[1, 2] (1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       1.5000000000000007`}, {(-2) Sin[Rational[3, 20] Pi], (-2) 
       Cos[Rational[3, 20] Pi], 
       1.5000000000000007`}}, {{-0.9079809994790936, -1.7820130483767358`, 
     1.2000000000000006`}, {-0.6180339887498949, -1.902113032590307, 
     1.2000000000000006`}, {-0.6180339887498949, -1.902113032590307, 
     1.5000000000000007`}, {-0.9079809994790936, -1.7820130483767358`, 
     1.5000000000000007`}}]], 
   Polygon3DBox[
    NCache[{{(-2) Sin[Rational[3, 20] Pi], (-2) Cos[Rational[3, 20] Pi], 
       1.5000000000000007`}, {
      Rational[1, 2] (1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       1.5000000000000007`}, {
      Rational[1, 2] (1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       1.8000000000000007`}, {(-2) Sin[Rational[3, 20] Pi], (-2) 
       Cos[Rational[3, 20] Pi], 
       1.8000000000000007`}}, {{-0.9079809994790936, -1.7820130483767358`, 
     1.5000000000000007`}, {-0.6180339887498949, -1.902113032590307, 
     1.5000000000000007`}, {-0.6180339887498949, -1.902113032590307, 
     1.8000000000000007`}, {-0.9079809994790936, -1.7820130483767358`, 
     1.8000000000000007`}}]], 
   Polygon3DBox[
    NCache[{{(-2) Sin[Rational[3, 20] Pi], (-2) Cos[Rational[3, 20] Pi], 
       1.8000000000000007`}, {
      Rational[1, 2] (1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       1.8000000000000007`}, {
      Rational[1, 2] (1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       2.1000000000000005`}, {(-2) Sin[Rational[3, 20] Pi], (-2) 
       Cos[Rational[3, 20] Pi], 
       2.1000000000000005`}}, {{-0.9079809994790936, -1.7820130483767358`, 
     1.8000000000000007`}, {-0.6180339887498949, -1.902113032590307, 
     1.8000000000000007`}, {-0.6180339887498949, -1.902113032590307, 
     2.1000000000000005`}, {-0.9079809994790936, -1.7820130483767358`, 
     2.1000000000000005`}}]], 
   Polygon3DBox[
    NCache[{{(-2) Sin[Rational[3, 20] Pi], (-2) Cos[Rational[3, 20] Pi], 
       2.1000000000000005`}, {
      Rational[1, 2] (1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       2.1000000000000005`}, {
      Rational[1, 2] (1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       2.4000000000000004`}, {(-2) Sin[Rational[3, 20] Pi], (-2) 
       Cos[Rational[3, 20] Pi], 
       2.4000000000000004`}}, {{-0.9079809994790936, -1.7820130483767358`, 
     2.1000000000000005`}, {-0.6180339887498949, -1.902113032590307, 
     2.1000000000000005`}, {-0.6180339887498949, -1.902113032590307, 
     2.4000000000000004`}, {-0.9079809994790936, -1.7820130483767358`, 
     2.4000000000000004`}}]], 
   Polygon3DBox[
    NCache[{{(-2) Sin[Rational[3, 20] Pi], (-2) Cos[Rational[3, 20] Pi], 
       2.400000000000001}, {
      Rational[1, 2] (1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       2.400000000000001}, {
      Rational[1, 2] (1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       2.700000000000001}, {(-2) Sin[Rational[3, 20] Pi], (-2) 
       Cos[Rational[3, 20] Pi], 
       2.700000000000001}}, {{-0.9079809994790936, -1.7820130483767358`, 
     2.400000000000001}, {-0.6180339887498949, -1.902113032590307, 
     2.400000000000001}, {-0.6180339887498949, -1.902113032590307, 
     2.700000000000001}, {-0.9079809994790936, -1.7820130483767358`, 
     2.700000000000001}}]], 
   Polygon3DBox[
    NCache[{{(-2) Sin[Rational[3, 20] Pi], (-2) Cos[Rational[3, 20] Pi], 
       2.700000000000001}, {
      Rational[1, 2] (1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       2.700000000000001}, {
      Rational[1, 2] (1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       3.000000000000001}, {(-2) Sin[Rational[3, 20] Pi], (-2) 
       Cos[Rational[3, 20] Pi], 
       3.000000000000001}}, {{-0.9079809994790936, -1.7820130483767358`, 
     2.700000000000001}, {-0.6180339887498949, -1.902113032590307, 
     2.700000000000001}, {-0.6180339887498949, -1.902113032590307, 
     3.000000000000001}, {-0.9079809994790936, -1.7820130483767358`, 
     3.000000000000001}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], -3.}, {(-2) 
       Sin[Rational[1, 20] Pi], (-2) Cos[Rational[1, 20] Pi], -3.}, {(-2) 
       Sin[Rational[1, 20] Pi], (-2) Cos[Rational[1, 20] Pi], -2.7}, {
      Rational[1, 2] (1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^
        Rational[
         1, 2], -2.7}}, {{-0.6180339887498949, -1.902113032590307, -3.}, \
{-0.31286893008046174`, -1.9753766811902755`, -3.}, {-0.31286893008046174`, \
-1.9753766811902755`, -2.7}, {-0.6180339887498949, -1.902113032590307, \
-2.7}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], -2.7}, {(-2) 
       Sin[Rational[1, 20] Pi], (-2) Cos[Rational[1, 20] Pi], -2.7}, {(-2) 
       Sin[Rational[1, 20] Pi], (-2) 
       Cos[Rational[1, 20] Pi], -2.4000000000000004`}, {
      Rational[1, 2] (1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^
        Rational[
         1, 2], -2.4000000000000004`}}, {{-0.6180339887498949, \
-1.902113032590307, -2.7}, {-0.31286893008046174`, -1.9753766811902755`, \
-2.7}, {-0.31286893008046174`, -1.9753766811902755`, -2.4000000000000004`}, \
{-0.6180339887498949, -1.902113032590307, -2.4000000000000004`}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], -2.4}, {(-2) 
       Sin[Rational[1, 20] Pi], (-2) Cos[Rational[1, 20] Pi], -2.4}, {(-2) 
       Sin[Rational[1, 20] Pi], (-2) 
       Cos[Rational[1, 20] Pi], -2.0999999999999996`}, {
      Rational[1, 2] (1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^
        Rational[
         1, 2], -2.0999999999999996`}}, {{-0.6180339887498949, \
-1.902113032590307, -2.4}, {-0.31286893008046174`, -1.9753766811902755`, \
-2.4}, {-0.31286893008046174`, -1.9753766811902755`, -2.0999999999999996`}, \
{-0.6180339887498949, -1.902113032590307, -2.0999999999999996`}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -2.0999999999999996`}, {(-2) 
       Sin[Rational[1, 20] Pi], (-2) 
       Cos[Rational[1, 20] Pi], -2.0999999999999996`}, {(-2) 
       Sin[Rational[1, 20] Pi], (-2) 
       Cos[Rational[1, 20] Pi], -1.7999999999999996`}, {
      Rational[1, 2] (1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^
        Rational[
         1, 2], -1.7999999999999996`}}, {{-0.6180339887498949, \
-1.902113032590307, -2.0999999999999996`}, {-0.31286893008046174`, \
-1.9753766811902755`, -2.0999999999999996`}, {-0.31286893008046174`, \
-1.9753766811902755`, -1.7999999999999996`}, {-0.6180339887498949, \
-1.902113032590307, -1.7999999999999996`}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -1.7999999999999998`}, {(-2) 
       Sin[Rational[1, 20] Pi], (-2) 
       Cos[Rational[1, 20] Pi], -1.7999999999999998`}, {(-2) 
       Sin[Rational[1, 20] Pi], (-2) 
       Cos[Rational[1, 20] Pi], -1.4999999999999998`}, {
      Rational[1, 2] (1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^
        Rational[
         1, 2], -1.4999999999999998`}}, {{-0.6180339887498949, \
-1.902113032590307, -1.7999999999999998`}, {-0.31286893008046174`, \
-1.9753766811902755`, -1.7999999999999998`}, {-0.31286893008046174`, \
-1.9753766811902755`, -1.4999999999999998`}, {-0.6180339887498949, \
-1.902113032590307, -1.4999999999999998`}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -1.4999999999999998`}, {(-2) 
       Sin[Rational[1, 20] Pi], (-2) 
       Cos[Rational[1, 20] Pi], -1.4999999999999998`}, {(-2) 
       Sin[Rational[1, 20] Pi], (-2) 
       Cos[Rational[1, 20] Pi], -1.1999999999999997`}, {
      Rational[1, 2] (1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^
        Rational[
         1, 2], -1.1999999999999997`}}, {{-0.6180339887498949, \
-1.902113032590307, -1.4999999999999998`}, {-0.31286893008046174`, \
-1.9753766811902755`, -1.4999999999999998`}, {-0.31286893008046174`, \
-1.9753766811902755`, -1.1999999999999997`}, {-0.6180339887498949, \
-1.902113032590307, -1.1999999999999997`}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -1.1999999999999997`}, {(-2) 
       Sin[Rational[1, 20] Pi], (-2) 
       Cos[Rational[1, 20] Pi], -1.1999999999999997`}, {(-2) 
       Sin[Rational[1, 20] Pi], (-2) 
       Cos[Rational[1, 20] Pi], -0.8999999999999997}, {
      Rational[1, 2] (1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^
        Rational[
         1, 2], -0.8999999999999997}}, {{-0.6180339887498949, \
-1.902113032590307, -1.1999999999999997`}, {-0.31286893008046174`, \
-1.9753766811902755`, -1.1999999999999997`}, {-0.31286893008046174`, \
-1.9753766811902755`, -0.8999999999999997}, {-0.6180339887498949, \
-1.902113032590307, -0.8999999999999997}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -0.8999999999999997}, {(-2) 
       Sin[Rational[1, 20] Pi], (-2) 
       Cos[Rational[1, 20] Pi], -0.8999999999999997}, {(-2) 
       Sin[Rational[1, 20] Pi], (-2) 
       Cos[Rational[1, 20] Pi], -0.5999999999999996}, {
      Rational[1, 2] (1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^
        Rational[
         1, 2], -0.5999999999999996}}, {{-0.6180339887498949, \
-1.902113032590307, -0.8999999999999997}, {-0.31286893008046174`, \
-1.9753766811902755`, -0.8999999999999997}, {-0.31286893008046174`, \
-1.9753766811902755`, -0.5999999999999996}, {-0.6180339887498949, \
-1.902113032590307, -0.5999999999999996}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -0.5999999999999996}, {(-2) 
       Sin[Rational[1, 20] Pi], (-2) 
       Cos[Rational[1, 20] Pi], -0.5999999999999996}, {(-2) 
       Sin[Rational[1, 20] Pi], (-2) 
       Cos[Rational[1, 20] Pi], -0.2999999999999996}, {
      Rational[1, 2] (1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^
        Rational[
         1, 2], -0.2999999999999996}}, {{-0.6180339887498949, \
-1.902113032590307, -0.5999999999999996}, {-0.31286893008046174`, \
-1.9753766811902755`, -0.5999999999999996}, {-0.31286893008046174`, \
-1.9753766811902755`, -0.2999999999999996}, {-0.6180339887498949, \
-1.902113032590307, -0.2999999999999996}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -0.2999999999999996}, {(-2) 
       Sin[Rational[1, 20] Pi], (-2) 
       Cos[Rational[1, 20] Pi], -0.2999999999999996}, {(-2) 
       Sin[Rational[1, 20] Pi], (-2) Cos[Rational[1, 20] Pi], 
       4.440892098500626*^-16}, {
      Rational[1, 2] (1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       4.440892098500626*^-16}}, {{-0.6180339887498949, -1.902113032590307, \
-0.2999999999999996}, {-0.31286893008046174`, -1.9753766811902755`, \
-0.2999999999999996}, {-0.31286893008046174`, -1.9753766811902755`, 
     4.440892098500626*^-16}, {-0.6180339887498949, -1.902113032590307, 
     4.440892098500626*^-16}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       4.440892098500626*^-16}, {(-2) Sin[Rational[1, 20] Pi], (-2) 
       Cos[Rational[1, 20] Pi], 4.440892098500626*^-16}, {(-2) 
       Sin[Rational[1, 20] Pi], (-2) Cos[Rational[1, 20] Pi], 
       0.3000000000000005}, {
      Rational[1, 2] (1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       0.3000000000000005}}, {{-0.6180339887498949, -1.902113032590307, 
     4.440892098500626*^-16}, {-0.31286893008046174`, -1.9753766811902755`, 
     4.440892098500626*^-16}, {-0.31286893008046174`, -1.9753766811902755`, 
     0.3000000000000005}, {-0.6180339887498949, -1.902113032590307, 
     0.3000000000000005}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       0.3000000000000005}, {(-2) Sin[Rational[1, 20] Pi], (-2) 
       Cos[Rational[1, 20] Pi], 0.3000000000000005}, {(-2) 
       Sin[Rational[1, 20] Pi], (-2) Cos[Rational[1, 20] Pi], 
       0.6000000000000005}, {
      Rational[1, 2] (1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       0.6000000000000005}}, {{-0.6180339887498949, -1.902113032590307, 
     0.3000000000000005}, {-0.31286893008046174`, -1.9753766811902755`, 
     0.3000000000000005}, {-0.31286893008046174`, -1.9753766811902755`, 
     0.6000000000000005}, {-0.6180339887498949, -1.902113032590307, 
     0.6000000000000005}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       0.6000000000000005}, {(-2) Sin[Rational[1, 20] Pi], (-2) 
       Cos[Rational[1, 20] Pi], 0.6000000000000005}, {(-2) 
       Sin[Rational[1, 20] Pi], (-2) Cos[Rational[1, 20] Pi], 
       0.9000000000000006}, {
      Rational[1, 2] (1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       0.9000000000000006}}, {{-0.6180339887498949, -1.902113032590307, 
     0.6000000000000005}, {-0.31286893008046174`, -1.9753766811902755`, 
     0.6000000000000005}, {-0.31286893008046174`, -1.9753766811902755`, 
     0.9000000000000006}, {-0.6180339887498949, -1.902113032590307, 
     0.9000000000000006}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       0.9000000000000006}, {(-2) Sin[Rational[1, 20] Pi], (-2) 
       Cos[Rational[1, 20] Pi], 0.9000000000000006}, {(-2) 
       Sin[Rational[1, 20] Pi], (-2) Cos[Rational[1, 20] Pi], 
       1.2000000000000006`}, {
      Rational[1, 2] (1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       1.2000000000000006`}}, {{-0.6180339887498949, -1.902113032590307, 
     0.9000000000000006}, {-0.31286893008046174`, -1.9753766811902755`, 
     0.9000000000000006}, {-0.31286893008046174`, -1.9753766811902755`, 
     1.2000000000000006`}, {-0.6180339887498949, -1.902113032590307, 
     1.2000000000000006`}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       1.2000000000000006`}, {(-2) Sin[Rational[1, 20] Pi], (-2) 
       Cos[Rational[1, 20] Pi], 1.2000000000000006`}, {(-2) 
       Sin[Rational[1, 20] Pi], (-2) Cos[Rational[1, 20] Pi], 
       1.5000000000000007`}, {
      Rational[1, 2] (1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       1.5000000000000007`}}, {{-0.6180339887498949, -1.902113032590307, 
     1.2000000000000006`}, {-0.31286893008046174`, -1.9753766811902755`, 
     1.2000000000000006`}, {-0.31286893008046174`, -1.9753766811902755`, 
     1.5000000000000007`}, {-0.6180339887498949, -1.902113032590307, 
     1.5000000000000007`}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       1.5000000000000007`}, {(-2) Sin[Rational[1, 20] Pi], (-2) 
       Cos[Rational[1, 20] Pi], 1.5000000000000007`}, {(-2) 
       Sin[Rational[1, 20] Pi], (-2) Cos[Rational[1, 20] Pi], 
       1.8000000000000007`}, {
      Rational[1, 2] (1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       1.8000000000000007`}}, {{-0.6180339887498949, -1.902113032590307, 
     1.5000000000000007`}, {-0.31286893008046174`, -1.9753766811902755`, 
     1.5000000000000007`}, {-0.31286893008046174`, -1.9753766811902755`, 
     1.8000000000000007`}, {-0.6180339887498949, -1.902113032590307, 
     1.8000000000000007`}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       1.8000000000000007`}, {(-2) Sin[Rational[1, 20] Pi], (-2) 
       Cos[Rational[1, 20] Pi], 1.8000000000000007`}, {(-2) 
       Sin[Rational[1, 20] Pi], (-2) Cos[Rational[1, 20] Pi], 
       2.1000000000000005`}, {
      Rational[1, 2] (1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       2.1000000000000005`}}, {{-0.6180339887498949, -1.902113032590307, 
     1.8000000000000007`}, {-0.31286893008046174`, -1.9753766811902755`, 
     1.8000000000000007`}, {-0.31286893008046174`, -1.9753766811902755`, 
     2.1000000000000005`}, {-0.6180339887498949, -1.902113032590307, 
     2.1000000000000005`}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       2.1000000000000005`}, {(-2) Sin[Rational[1, 20] Pi], (-2) 
       Cos[Rational[1, 20] Pi], 2.1000000000000005`}, {(-2) 
       Sin[Rational[1, 20] Pi], (-2) Cos[Rational[1, 20] Pi], 
       2.4000000000000004`}, {
      Rational[1, 2] (1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       2.4000000000000004`}}, {{-0.6180339887498949, -1.902113032590307, 
     2.1000000000000005`}, {-0.31286893008046174`, -1.9753766811902755`, 
     2.1000000000000005`}, {-0.31286893008046174`, -1.9753766811902755`, 
     2.4000000000000004`}, {-0.6180339887498949, -1.902113032590307, 
     2.4000000000000004`}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       2.400000000000001}, {(-2) Sin[Rational[1, 20] Pi], (-2) 
       Cos[Rational[1, 20] Pi], 2.400000000000001}, {(-2) 
       Sin[Rational[1, 20] Pi], (-2) Cos[Rational[1, 20] Pi], 
       2.700000000000001}, {
      Rational[1, 2] (1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       2.700000000000001}}, {{-0.6180339887498949, -1.902113032590307, 
     2.400000000000001}, {-0.31286893008046174`, -1.9753766811902755`, 
     2.400000000000001}, {-0.31286893008046174`, -1.9753766811902755`, 
     2.700000000000001}, {-0.6180339887498949, -1.902113032590307, 
     2.700000000000001}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       2.700000000000001}, {(-2) Sin[Rational[1, 20] Pi], (-2) 
       Cos[Rational[1, 20] Pi], 2.700000000000001}, {(-2) 
       Sin[Rational[1, 20] Pi], (-2) Cos[Rational[1, 20] Pi], 
       3.000000000000001}, {
      Rational[1, 2] (1 - 5^
        Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       3.000000000000001}}, {{-0.6180339887498949, -1.902113032590307, 
     2.700000000000001}, {-0.31286893008046174`, -1.9753766811902755`, 
     2.700000000000001}, {-0.31286893008046174`, -1.9753766811902755`, 
     3.000000000000001}, {-0.6180339887498949, -1.902113032590307, 
     3.000000000000001}}]], 
   Polygon3DBox[
    NCache[{{(-2) Sin[Rational[1, 20] Pi], (-2) 
       Cos[Rational[1, 20] Pi], -3.}, {0, -2, -3.}, {
      0, -2, -2.7}, {(-2) Sin[Rational[1, 20] Pi], (-2) 
       Cos[Rational[1, 20] 
         Pi], -2.7}}, {{-0.31286893008046174`, -1.9753766811902755`, -3.}, {
      0, -2, -3.}, {
      0, -2, -2.7}, {-0.31286893008046174`, -1.9753766811902755`, -2.7}}]], 
   Polygon3DBox[
    NCache[{{(-2) Sin[Rational[1, 20] Pi], (-2) 
       Cos[Rational[1, 20] Pi], -2.7}, {0, -2, -2.7}, {
      0, -2, -2.4000000000000004`}, {(-2) Sin[Rational[1, 20] Pi], (-2) 
       Cos[Rational[1, 20] 
         Pi], -2.4000000000000004`}}, {{-0.31286893008046174`, \
-1.9753766811902755`, -2.7}, {0, -2, -2.7}, {
      0, -2, -2.4000000000000004`}, {-0.31286893008046174`, \
-1.9753766811902755`, -2.4000000000000004`}}]], 
   Polygon3DBox[
    NCache[{{(-2) Sin[Rational[1, 20] Pi], (-2) 
       Cos[Rational[1, 20] Pi], -2.4}, {0, -2, -2.4}, {
      0, -2, -2.0999999999999996`}, {(-2) Sin[Rational[1, 20] Pi], (-2) 
       Cos[Rational[1, 20] 
         Pi], -2.0999999999999996`}}, {{-0.31286893008046174`, \
-1.9753766811902755`, -2.4}, {0, -2, -2.4}, {
      0, -2, -2.0999999999999996`}, {-0.31286893008046174`, \
-1.9753766811902755`, -2.0999999999999996`}}]], 
   Polygon3DBox[
    NCache[{{(-2) Sin[Rational[1, 20] Pi], (-2) 
       Cos[Rational[1, 20] Pi], -2.0999999999999996`}, {
      0, -2, -2.0999999999999996`}, {
      0, -2, -1.7999999999999996`}, {(-2) Sin[Rational[1, 20] Pi], (-2) 
       Cos[Rational[1, 20] 
         Pi], -1.7999999999999996`}}, {{-0.31286893008046174`, \
-1.9753766811902755`, -2.0999999999999996`}, {0, -2, -2.0999999999999996`}, {
      0, -2, -1.7999999999999996`}, {-0.31286893008046174`, \
-1.9753766811902755`, -1.7999999999999996`}}]], 
   Polygon3DBox[
    NCache[{{(-2) Sin[Rational[1, 20] Pi], (-2) 
       Cos[Rational[1, 20] Pi], -1.7999999999999998`}, {
      0, -2, -1.7999999999999998`}, {
      0, -2, -1.4999999999999998`}, {(-2) Sin[Rational[1, 20] Pi], (-2) 
       Cos[Rational[1, 20] 
         Pi], -1.4999999999999998`}}, {{-0.31286893008046174`, \
-1.9753766811902755`, -1.7999999999999998`}, {0, -2, -1.7999999999999998`}, {
      0, -2, -1.4999999999999998`}, {-0.31286893008046174`, \
-1.9753766811902755`, -1.4999999999999998`}}]], 
   Polygon3DBox[
    NCache[{{(-2) Sin[Rational[1, 20] Pi], (-2) 
       Cos[Rational[1, 20] Pi], -1.4999999999999998`}, {
      0, -2, -1.4999999999999998`}, {
      0, -2, -1.1999999999999997`}, {(-2) Sin[Rational[1, 20] Pi], (-2) 
       Cos[Rational[1, 20] 
         Pi], -1.1999999999999997`}}, {{-0.31286893008046174`, \
-1.9753766811902755`, -1.4999999999999998`}, {0, -2, -1.4999999999999998`}, {
      0, -2, -1.1999999999999997`}, {-0.31286893008046174`, \
-1.9753766811902755`, -1.1999999999999997`}}]], 
   Polygon3DBox[
    NCache[{{(-2) Sin[Rational[1, 20] Pi], (-2) 
       Cos[Rational[1, 20] Pi], -1.1999999999999997`}, {
      0, -2, -1.1999999999999997`}, {
      0, -2, -0.8999999999999997}, {(-2) Sin[Rational[1, 20] Pi], (-2) 
       Cos[Rational[1, 20] 
         Pi], -0.8999999999999997}}, {{-0.31286893008046174`, \
-1.9753766811902755`, -1.1999999999999997`}, {0, -2, -1.1999999999999997`}, {
      0, -2, -0.8999999999999997}, {-0.31286893008046174`, \
-1.9753766811902755`, -0.8999999999999997}}]], 
   Polygon3DBox[
    NCache[{{(-2) Sin[Rational[1, 20] Pi], (-2) 
       Cos[Rational[1, 20] Pi], -0.8999999999999997}, {
      0, -2, -0.8999999999999997}, {
      0, -2, -0.5999999999999996}, {(-2) Sin[Rational[1, 20] Pi], (-2) 
       Cos[Rational[1, 20] 
         Pi], -0.5999999999999996}}, {{-0.31286893008046174`, \
-1.9753766811902755`, -0.8999999999999997}, {0, -2, -0.8999999999999997}, {
      0, -2, -0.5999999999999996}, {-0.31286893008046174`, \
-1.9753766811902755`, -0.5999999999999996}}]], 
   Polygon3DBox[
    NCache[{{(-2) Sin[Rational[1, 20] Pi], (-2) 
       Cos[Rational[1, 20] Pi], -0.5999999999999996}, {
      0, -2, -0.5999999999999996}, {
      0, -2, -0.2999999999999996}, {(-2) Sin[Rational[1, 20] Pi], (-2) 
       Cos[Rational[1, 20] 
         Pi], -0.2999999999999996}}, {{-0.31286893008046174`, \
-1.9753766811902755`, -0.5999999999999996}, {0, -2, -0.5999999999999996}, {
      0, -2, -0.2999999999999996}, {-0.31286893008046174`, \
-1.9753766811902755`, -0.2999999999999996}}]], 
   Polygon3DBox[
    NCache[{{(-2) Sin[Rational[1, 20] Pi], (-2) 
       Cos[Rational[1, 20] Pi], -0.2999999999999996}, {
      0, -2, -0.2999999999999996}, {
      0, -2, 4.440892098500626*^-16}, {(-2) Sin[Rational[1, 20] Pi], (-2) 
       Cos[Rational[1, 20] Pi], 
       4.440892098500626*^-16}}, {{-0.31286893008046174`, \
-1.9753766811902755`, -0.2999999999999996}, {0, -2, -0.2999999999999996}, {
      0, -2, 4.440892098500626*^-16}, {-0.31286893008046174`, \
-1.9753766811902755`, 4.440892098500626*^-16}}]], 
   Polygon3DBox[
    NCache[{{(-2) Sin[Rational[1, 20] Pi], (-2) Cos[Rational[1, 20] Pi], 
       4.440892098500626*^-16}, {0, -2, 4.440892098500626*^-16}, {
      0, -2, 0.3000000000000005}, {(-2) Sin[Rational[1, 20] Pi], (-2) 
       Cos[Rational[1, 20] Pi], 
       0.3000000000000005}}, {{-0.31286893008046174`, -1.9753766811902755`, 
      4.440892098500626*^-16}, {0, -2, 4.440892098500626*^-16}, {
      0, -2, 0.3000000000000005}, {-0.31286893008046174`, \
-1.9753766811902755`, 0.3000000000000005}}]], 
   Polygon3DBox[
    NCache[{{(-2) Sin[Rational[1, 20] Pi], (-2) Cos[Rational[1, 20] Pi], 
       0.3000000000000005}, {0, -2, 0.3000000000000005}, {
      0, -2, 0.6000000000000005}, {(-2) Sin[Rational[1, 20] Pi], (-2) 
       Cos[Rational[1, 20] Pi], 
       0.6000000000000005}}, {{-0.31286893008046174`, -1.9753766811902755`, 
      0.3000000000000005}, {0, -2, 0.3000000000000005}, {
      0, -2, 0.6000000000000005}, {-0.31286893008046174`, \
-1.9753766811902755`, 0.6000000000000005}}]], 
   Polygon3DBox[
    NCache[{{(-2) Sin[Rational[1, 20] Pi], (-2) Cos[Rational[1, 20] Pi], 
       0.6000000000000005}, {0, -2, 0.6000000000000005}, {
      0, -2, 0.9000000000000006}, {(-2) Sin[Rational[1, 20] Pi], (-2) 
       Cos[Rational[1, 20] Pi], 
       0.9000000000000006}}, {{-0.31286893008046174`, -1.9753766811902755`, 
      0.6000000000000005}, {0, -2, 0.6000000000000005}, {
      0, -2, 0.9000000000000006}, {-0.31286893008046174`, \
-1.9753766811902755`, 0.9000000000000006}}]], 
   Polygon3DBox[
    NCache[{{(-2) Sin[Rational[1, 20] Pi], (-2) Cos[Rational[1, 20] Pi], 
       0.9000000000000006}, {0, -2, 0.9000000000000006}, {
      0, -2, 1.2000000000000006`}, {(-2) Sin[Rational[1, 20] Pi], (-2) 
       Cos[Rational[1, 20] Pi], 
       1.2000000000000006`}}, {{-0.31286893008046174`, -1.9753766811902755`, 
      0.9000000000000006}, {0, -2, 0.9000000000000006}, {
      0, -2, 1.2000000000000006`}, {-0.31286893008046174`, \
-1.9753766811902755`, 1.2000000000000006`}}]], 
   Polygon3DBox[
    NCache[{{(-2) Sin[Rational[1, 20] Pi], (-2) Cos[Rational[1, 20] Pi], 
       1.2000000000000006`}, {0, -2, 1.2000000000000006`}, {
      0, -2, 1.5000000000000007`}, {(-2) Sin[Rational[1, 20] Pi], (-2) 
       Cos[Rational[1, 20] Pi], 
       1.5000000000000007`}}, {{-0.31286893008046174`, -1.9753766811902755`, 
      1.2000000000000006`}, {0, -2, 1.2000000000000006`}, {
      0, -2, 1.5000000000000007`}, {-0.31286893008046174`, \
-1.9753766811902755`, 1.5000000000000007`}}]], 
   Polygon3DBox[
    NCache[{{(-2) Sin[Rational[1, 20] Pi], (-2) Cos[Rational[1, 20] Pi], 
       1.5000000000000007`}, {0, -2, 1.5000000000000007`}, {
      0, -2, 1.8000000000000007`}, {(-2) Sin[Rational[1, 20] Pi], (-2) 
       Cos[Rational[1, 20] Pi], 
       1.8000000000000007`}}, {{-0.31286893008046174`, -1.9753766811902755`, 
      1.5000000000000007`}, {0, -2, 1.5000000000000007`}, {
      0, -2, 1.8000000000000007`}, {-0.31286893008046174`, \
-1.9753766811902755`, 1.8000000000000007`}}]], 
   Polygon3DBox[
    NCache[{{(-2) Sin[Rational[1, 20] Pi], (-2) Cos[Rational[1, 20] Pi], 
       1.8000000000000007`}, {0, -2, 1.8000000000000007`}, {
      0, -2, 2.1000000000000005`}, {(-2) Sin[Rational[1, 20] Pi], (-2) 
       Cos[Rational[1, 20] Pi], 
       2.1000000000000005`}}, {{-0.31286893008046174`, -1.9753766811902755`, 
      1.8000000000000007`}, {0, -2, 1.8000000000000007`}, {
      0, -2, 2.1000000000000005`}, {-0.31286893008046174`, \
-1.9753766811902755`, 2.1000000000000005`}}]], 
   Polygon3DBox[
    NCache[{{(-2) Sin[Rational[1, 20] Pi], (-2) Cos[Rational[1, 20] Pi], 
       2.1000000000000005`}, {0, -2, 2.1000000000000005`}, {
      0, -2, 2.4000000000000004`}, {(-2) Sin[Rational[1, 20] Pi], (-2) 
       Cos[Rational[1, 20] Pi], 
       2.4000000000000004`}}, {{-0.31286893008046174`, -1.9753766811902755`, 
      2.1000000000000005`}, {0, -2, 2.1000000000000005`}, {
      0, -2, 2.4000000000000004`}, {-0.31286893008046174`, \
-1.9753766811902755`, 2.4000000000000004`}}]], 
   Polygon3DBox[
    NCache[{{(-2) Sin[Rational[1, 20] Pi], (-2) Cos[Rational[1, 20] Pi], 
       2.400000000000001}, {0, -2, 2.400000000000001}, {
      0, -2, 2.700000000000001}, {(-2) Sin[Rational[1, 20] Pi], (-2) 
       Cos[Rational[1, 20] Pi], 
       2.700000000000001}}, {{-0.31286893008046174`, -1.9753766811902755`, 
      2.400000000000001}, {0, -2, 2.400000000000001}, {
      0, -2, 2.700000000000001}, {-0.31286893008046174`, -1.9753766811902755`,
       2.700000000000001}}]], 
   Polygon3DBox[
    NCache[{{(-2) Sin[Rational[1, 20] Pi], (-2) Cos[Rational[1, 20] Pi], 
       2.700000000000001}, {0, -2, 2.700000000000001}, {
      0, -2, 3.000000000000001}, {(-2) Sin[Rational[1, 20] Pi], (-2) 
       Cos[Rational[1, 20] Pi], 
       3.000000000000001}}, {{-0.31286893008046174`, -1.9753766811902755`, 
      2.700000000000001}, {0, -2, 2.700000000000001}, {
      0, -2, 3.000000000000001}, {-0.31286893008046174`, -1.9753766811902755`,
       3.000000000000001}}]], 
   Polygon3DBox[
    NCache[{{0, -2, -3.}, {
      2 Sin[Rational[1, 20] Pi], (-2) Cos[Rational[1, 20] Pi], -3.}, {
      2 Sin[Rational[1, 20] Pi], (-2) Cos[Rational[1, 20] Pi], -2.7}, {
      0, -2, -2.7}}, {{0, -2, -3.}, {
      0.31286893008046174`, -1.9753766811902755`, -3.}, {
      0.31286893008046174`, -1.9753766811902755`, -2.7}, {0, -2, -2.7}}]], 
   Polygon3DBox[
    NCache[{{0, -2, -2.7}, {
      2 Sin[Rational[1, 20] Pi], (-2) Cos[Rational[1, 20] Pi], -2.7}, {
      2 Sin[Rational[1, 20] Pi], (-2) 
       Cos[Rational[1, 20] Pi], -2.4000000000000004`}, {
      0, -2, -2.4000000000000004`}}, {{0, -2, -2.7}, {
      0.31286893008046174`, -1.9753766811902755`, -2.7}, {
      0.31286893008046174`, -1.9753766811902755`, -2.4000000000000004`}, {
      0, -2, -2.4000000000000004`}}]], 
   Polygon3DBox[
    NCache[{{0, -2, -2.4}, {
      2 Sin[Rational[1, 20] Pi], (-2) Cos[Rational[1, 20] Pi], -2.4}, {
      2 Sin[Rational[1, 20] Pi], (-2) 
       Cos[Rational[1, 20] Pi], -2.0999999999999996`}, {
      0, -2, -2.0999999999999996`}}, {{0, -2, -2.4}, {
      0.31286893008046174`, -1.9753766811902755`, -2.4}, {
      0.31286893008046174`, -1.9753766811902755`, -2.0999999999999996`}, {
      0, -2, -2.0999999999999996`}}]], 
   Polygon3DBox[
    NCache[{{0, -2, -2.0999999999999996`}, {
      2 Sin[Rational[1, 20] Pi], (-2) 
       Cos[Rational[1, 20] Pi], -2.0999999999999996`}, {
      2 Sin[Rational[1, 20] Pi], (-2) 
       Cos[Rational[1, 20] Pi], -1.7999999999999996`}, {
      0, -2, -1.7999999999999996`}}, {{0, -2, -2.0999999999999996`}, {
      0.31286893008046174`, -1.9753766811902755`, -2.0999999999999996`}, {
      0.31286893008046174`, -1.9753766811902755`, -1.7999999999999996`}, {
      0, -2, -1.7999999999999996`}}]], 
   Polygon3DBox[
    NCache[{{0, -2, -1.7999999999999998`}, {
      2 Sin[Rational[1, 20] Pi], (-2) 
       Cos[Rational[1, 20] Pi], -1.7999999999999998`}, {
      2 Sin[Rational[1, 20] Pi], (-2) 
       Cos[Rational[1, 20] Pi], -1.4999999999999998`}, {
      0, -2, -1.4999999999999998`}}, {{0, -2, -1.7999999999999998`}, {
      0.31286893008046174`, -1.9753766811902755`, -1.7999999999999998`}, {
      0.31286893008046174`, -1.9753766811902755`, -1.4999999999999998`}, {
      0, -2, -1.4999999999999998`}}]], 
   Polygon3DBox[
    NCache[{{0, -2, -1.4999999999999998`}, {
      2 Sin[Rational[1, 20] Pi], (-2) 
       Cos[Rational[1, 20] Pi], -1.4999999999999998`}, {
      2 Sin[Rational[1, 20] Pi], (-2) 
       Cos[Rational[1, 20] Pi], -1.1999999999999997`}, {
      0, -2, -1.1999999999999997`}}, {{0, -2, -1.4999999999999998`}, {
      0.31286893008046174`, -1.9753766811902755`, -1.4999999999999998`}, {
      0.31286893008046174`, -1.9753766811902755`, -1.1999999999999997`}, {
      0, -2, -1.1999999999999997`}}]], 
   Polygon3DBox[
    NCache[{{0, -2, -1.1999999999999997`}, {
      2 Sin[Rational[1, 20] Pi], (-2) 
       Cos[Rational[1, 20] Pi], -1.1999999999999997`}, {
      2 Sin[Rational[1, 20] Pi], (-2) 
       Cos[Rational[1, 20] Pi], -0.8999999999999997}, {
      0, -2, -0.8999999999999997}}, {{0, -2, -1.1999999999999997`}, {
      0.31286893008046174`, -1.9753766811902755`, -1.1999999999999997`}, {
      0.31286893008046174`, -1.9753766811902755`, -0.8999999999999997}, {
      0, -2, -0.8999999999999997}}]], 
   Polygon3DBox[
    NCache[{{0, -2, -0.8999999999999997}, {
      2 Sin[Rational[1, 20] Pi], (-2) 
       Cos[Rational[1, 20] Pi], -0.8999999999999997}, {
      2 Sin[Rational[1, 20] Pi], (-2) 
       Cos[Rational[1, 20] Pi], -0.5999999999999996}, {
      0, -2, -0.5999999999999996}}, {{0, -2, -0.8999999999999997}, {
      0.31286893008046174`, -1.9753766811902755`, -0.8999999999999997}, {
      0.31286893008046174`, -1.9753766811902755`, -0.5999999999999996}, {
      0, -2, -0.5999999999999996}}]], 
   Polygon3DBox[
    NCache[{{0, -2, -0.5999999999999996}, {
      2 Sin[Rational[1, 20] Pi], (-2) 
       Cos[Rational[1, 20] Pi], -0.5999999999999996}, {
      2 Sin[Rational[1, 20] Pi], (-2) 
       Cos[Rational[1, 20] Pi], -0.2999999999999996}, {
      0, -2, -0.2999999999999996}}, {{0, -2, -0.5999999999999996}, {
      0.31286893008046174`, -1.9753766811902755`, -0.5999999999999996}, {
      0.31286893008046174`, -1.9753766811902755`, -0.2999999999999996}, {
      0, -2, -0.2999999999999996}}]], 
   Polygon3DBox[
    NCache[{{0, -2, -0.2999999999999996}, {
      2 Sin[Rational[1, 20] Pi], (-2) 
       Cos[Rational[1, 20] Pi], -0.2999999999999996}, {
      2 Sin[Rational[1, 20] Pi], (-2) Cos[Rational[1, 20] Pi], 
       4.440892098500626*^-16}, {0, -2, 4.440892098500626*^-16}}, {{
      0, -2, -0.2999999999999996}, {
      0.31286893008046174`, -1.9753766811902755`, -0.2999999999999996}, {
      0.31286893008046174`, -1.9753766811902755`, 4.440892098500626*^-16}, {
      0, -2, 4.440892098500626*^-16}}]], 
   Polygon3DBox[
    NCache[{{0, -2, 4.440892098500626*^-16}, {
      2 Sin[Rational[1, 20] Pi], (-2) Cos[Rational[1, 20] Pi], 
       4.440892098500626*^-16}, {
      2 Sin[Rational[1, 20] Pi], (-2) Cos[Rational[1, 20] Pi], 
       0.3000000000000005}, {0, -2, 0.3000000000000005}}, {{
      0, -2, 4.440892098500626*^-16}, {
      0.31286893008046174`, -1.9753766811902755`, 4.440892098500626*^-16}, {
      0.31286893008046174`, -1.9753766811902755`, 0.3000000000000005}, {
      0, -2, 0.3000000000000005}}]], 
   Polygon3DBox[
    NCache[{{0, -2, 0.3000000000000005}, {
      2 Sin[Rational[1, 20] Pi], (-2) Cos[Rational[1, 20] Pi], 
       0.3000000000000005}, {
      2 Sin[Rational[1, 20] Pi], (-2) Cos[Rational[1, 20] Pi], 
       0.6000000000000005}, {0, -2, 0.6000000000000005}}, {{
      0, -2, 0.3000000000000005}, {0.31286893008046174`, -1.9753766811902755`,
       0.3000000000000005}, {0.31286893008046174`, -1.9753766811902755`, 
      0.6000000000000005}, {0, -2, 0.6000000000000005}}]], 
   Polygon3DBox[
    NCache[{{0, -2, 0.6000000000000005}, {
      2 Sin[Rational[1, 20] Pi], (-2) Cos[Rational[1, 20] Pi], 
       0.6000000000000005}, {
      2 Sin[Rational[1, 20] Pi], (-2) Cos[Rational[1, 20] Pi], 
       0.9000000000000006}, {0, -2, 0.9000000000000006}}, {{
      0, -2, 0.6000000000000005}, {0.31286893008046174`, -1.9753766811902755`,
       0.6000000000000005}, {0.31286893008046174`, -1.9753766811902755`, 
      0.9000000000000006}, {0, -2, 0.9000000000000006}}]], 
   Polygon3DBox[
    NCache[{{0, -2, 0.9000000000000006}, {
      2 Sin[Rational[1, 20] Pi], (-2) Cos[Rational[1, 20] Pi], 
       0.9000000000000006}, {
      2 Sin[Rational[1, 20] Pi], (-2) Cos[Rational[1, 20] Pi], 
       1.2000000000000006`}, {0, -2, 1.2000000000000006`}}, {{
      0, -2, 0.9000000000000006}, {0.31286893008046174`, -1.9753766811902755`,
       0.9000000000000006}, {0.31286893008046174`, -1.9753766811902755`, 
      1.2000000000000006`}, {0, -2, 1.2000000000000006`}}]], 
   Polygon3DBox[
    NCache[{{0, -2, 1.2000000000000006`}, {
      2 Sin[Rational[1, 20] Pi], (-2) Cos[Rational[1, 20] Pi], 
       1.2000000000000006`}, {
      2 Sin[Rational[1, 20] Pi], (-2) Cos[Rational[1, 20] Pi], 
       1.5000000000000007`}, {0, -2, 1.5000000000000007`}}, {{
      0, -2, 1.2000000000000006`}, {
      0.31286893008046174`, -1.9753766811902755`, 1.2000000000000006`}, {
      0.31286893008046174`, -1.9753766811902755`, 1.5000000000000007`}, {
      0, -2, 1.5000000000000007`}}]], 
   Polygon3DBox[
    NCache[{{0, -2, 1.5000000000000007`}, {
      2 Sin[Rational[1, 20] Pi], (-2) Cos[Rational[1, 20] Pi], 
       1.5000000000000007`}, {
      2 Sin[Rational[1, 20] Pi], (-2) Cos[Rational[1, 20] Pi], 
       1.8000000000000007`}, {0, -2, 1.8000000000000007`}}, {{
      0, -2, 1.5000000000000007`}, {
      0.31286893008046174`, -1.9753766811902755`, 1.5000000000000007`}, {
      0.31286893008046174`, -1.9753766811902755`, 1.8000000000000007`}, {
      0, -2, 1.8000000000000007`}}]], 
   Polygon3DBox[
    NCache[{{0, -2, 1.8000000000000007`}, {
      2 Sin[Rational[1, 20] Pi], (-2) Cos[Rational[1, 20] Pi], 
       1.8000000000000007`}, {
      2 Sin[Rational[1, 20] Pi], (-2) Cos[Rational[1, 20] Pi], 
       2.1000000000000005`}, {0, -2, 2.1000000000000005`}}, {{
      0, -2, 1.8000000000000007`}, {
      0.31286893008046174`, -1.9753766811902755`, 1.8000000000000007`}, {
      0.31286893008046174`, -1.9753766811902755`, 2.1000000000000005`}, {
      0, -2, 2.1000000000000005`}}]], 
   Polygon3DBox[
    NCache[{{0, -2, 2.1000000000000005`}, {
      2 Sin[Rational[1, 20] Pi], (-2) Cos[Rational[1, 20] Pi], 
       2.1000000000000005`}, {
      2 Sin[Rational[1, 20] Pi], (-2) Cos[Rational[1, 20] Pi], 
       2.4000000000000004`}, {0, -2, 2.4000000000000004`}}, {{
      0, -2, 2.1000000000000005`}, {
      0.31286893008046174`, -1.9753766811902755`, 2.1000000000000005`}, {
      0.31286893008046174`, -1.9753766811902755`, 2.4000000000000004`}, {
      0, -2, 2.4000000000000004`}}]], 
   Polygon3DBox[
    NCache[{{0, -2, 2.400000000000001}, {
      2 Sin[Rational[1, 20] Pi], (-2) Cos[Rational[1, 20] Pi], 
       2.400000000000001}, {
      2 Sin[Rational[1, 20] Pi], (-2) Cos[Rational[1, 20] Pi], 
       2.700000000000001}, {0, -2, 2.700000000000001}}, {{
      0, -2, 2.400000000000001}, {0.31286893008046174`, -1.9753766811902755`, 
      2.400000000000001}, {0.31286893008046174`, -1.9753766811902755`, 
      2.700000000000001}, {0, -2, 2.700000000000001}}]], 
   Polygon3DBox[
    NCache[{{0, -2, 2.700000000000001}, {
      2 Sin[Rational[1, 20] Pi], (-2) Cos[Rational[1, 20] Pi], 
       2.700000000000001}, {
      2 Sin[Rational[1, 20] Pi], (-2) Cos[Rational[1, 20] Pi], 
       3.000000000000001}, {0, -2, 3.000000000000001}}, {{
      0, -2, 2.700000000000001}, {0.31286893008046174`, -1.9753766811902755`, 
      2.700000000000001}, {0.31286893008046174`, -1.9753766811902755`, 
      3.000000000000001}, {0, -2, 3.000000000000001}}]], 
   Polygon3DBox[
    NCache[{{2 Sin[Rational[1, 20] Pi], (-2) Cos[Rational[1, 20] Pi], -3.}, {
      Rational[1, 2] (-1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], -3.}, {
      Rational[1, 2] (-1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], -2.7}, {
      2 Sin[Rational[1, 20] Pi], (-2) Cos[Rational[1, 20] Pi], -2.7}}, {{
     0.31286893008046174`, -1.9753766811902755`, -3.}, {
     0.6180339887498949, -1.902113032590307, -3.}, {
     0.6180339887498949, -1.902113032590307, -2.7}, {
     0.31286893008046174`, -1.9753766811902755`, -2.7}}]], 
   Polygon3DBox[
    NCache[{{2 Sin[Rational[1, 20] Pi], (-2) Cos[Rational[1, 20] Pi], -2.7}, {
      Rational[1, 2] (-1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], -2.7}, {
      Rational[1, 2] (-1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -2.4000000000000004`}, {
      2 Sin[Rational[1, 20] Pi], (-2) 
       Cos[Rational[1, 20] Pi], -2.4000000000000004`}}, {{
     0.31286893008046174`, -1.9753766811902755`, -2.7}, {
     0.6180339887498949, -1.902113032590307, -2.7}, {
     0.6180339887498949, -1.902113032590307, -2.4000000000000004`}, {
     0.31286893008046174`, -1.9753766811902755`, -2.4000000000000004`}}]], 
   Polygon3DBox[
    NCache[{{2 Sin[Rational[1, 20] Pi], (-2) Cos[Rational[1, 20] Pi], -2.4}, {
      Rational[1, 2] (-1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], -2.4}, {
      Rational[1, 2] (-1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -2.0999999999999996`}, {
      2 Sin[Rational[1, 20] Pi], (-2) 
       Cos[Rational[1, 20] Pi], -2.0999999999999996`}}, {{
     0.31286893008046174`, -1.9753766811902755`, -2.4}, {
     0.6180339887498949, -1.902113032590307, -2.4}, {
     0.6180339887498949, -1.902113032590307, -2.0999999999999996`}, {
     0.31286893008046174`, -1.9753766811902755`, -2.0999999999999996`}}]], 
   Polygon3DBox[
    NCache[{{2 Sin[Rational[1, 20] Pi], (-2) 
       Cos[Rational[1, 20] Pi], -2.0999999999999996`}, {
      Rational[1, 2] (-1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -2.0999999999999996`}, {
      Rational[1, 2] (-1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -1.7999999999999996`}, {
      2 Sin[Rational[1, 20] Pi], (-2) 
       Cos[Rational[1, 20] Pi], -1.7999999999999996`}}, {{
     0.31286893008046174`, -1.9753766811902755`, -2.0999999999999996`}, {
     0.6180339887498949, -1.902113032590307, -2.0999999999999996`}, {
     0.6180339887498949, -1.902113032590307, -1.7999999999999996`}, {
     0.31286893008046174`, -1.9753766811902755`, -1.7999999999999996`}}]], 
   Polygon3DBox[
    NCache[{{2 Sin[Rational[1, 20] Pi], (-2) 
       Cos[Rational[1, 20] Pi], -1.7999999999999998`}, {
      Rational[1, 2] (-1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -1.7999999999999998`}, {
      Rational[1, 2] (-1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -1.4999999999999998`}, {
      2 Sin[Rational[1, 20] Pi], (-2) 
       Cos[Rational[1, 20] Pi], -1.4999999999999998`}}, {{
     0.31286893008046174`, -1.9753766811902755`, -1.7999999999999998`}, {
     0.6180339887498949, -1.902113032590307, -1.7999999999999998`}, {
     0.6180339887498949, -1.902113032590307, -1.4999999999999998`}, {
     0.31286893008046174`, -1.9753766811902755`, -1.4999999999999998`}}]], 
   Polygon3DBox[
    NCache[{{2 Sin[Rational[1, 20] Pi], (-2) 
       Cos[Rational[1, 20] Pi], -1.4999999999999998`}, {
      Rational[1, 2] (-1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -1.4999999999999998`}, {
      Rational[1, 2] (-1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -1.1999999999999997`}, {
      2 Sin[Rational[1, 20] Pi], (-2) 
       Cos[Rational[1, 20] Pi], -1.1999999999999997`}}, {{
     0.31286893008046174`, -1.9753766811902755`, -1.4999999999999998`}, {
     0.6180339887498949, -1.902113032590307, -1.4999999999999998`}, {
     0.6180339887498949, -1.902113032590307, -1.1999999999999997`}, {
     0.31286893008046174`, -1.9753766811902755`, -1.1999999999999997`}}]], 
   Polygon3DBox[
    NCache[{{2 Sin[Rational[1, 20] Pi], (-2) 
       Cos[Rational[1, 20] Pi], -1.1999999999999997`}, {
      Rational[1, 2] (-1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -1.1999999999999997`}, {
      Rational[1, 2] (-1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -0.8999999999999997}, {
      2 Sin[Rational[1, 20] Pi], (-2) 
       Cos[Rational[1, 20] Pi], -0.8999999999999997}}, {{
     0.31286893008046174`, -1.9753766811902755`, -1.1999999999999997`}, {
     0.6180339887498949, -1.902113032590307, -1.1999999999999997`}, {
     0.6180339887498949, -1.902113032590307, -0.8999999999999997}, {
     0.31286893008046174`, -1.9753766811902755`, -0.8999999999999997}}]], 
   Polygon3DBox[
    NCache[{{2 Sin[Rational[1, 20] Pi], (-2) 
       Cos[Rational[1, 20] Pi], -0.8999999999999997}, {
      Rational[1, 2] (-1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -0.8999999999999997}, {
      Rational[1, 2] (-1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -0.5999999999999996}, {
      2 Sin[Rational[1, 20] Pi], (-2) 
       Cos[Rational[1, 20] Pi], -0.5999999999999996}}, {{
     0.31286893008046174`, -1.9753766811902755`, -0.8999999999999997}, {
     0.6180339887498949, -1.902113032590307, -0.8999999999999997}, {
     0.6180339887498949, -1.902113032590307, -0.5999999999999996}, {
     0.31286893008046174`, -1.9753766811902755`, -0.5999999999999996}}]], 
   Polygon3DBox[
    NCache[{{2 Sin[Rational[1, 20] Pi], (-2) 
       Cos[Rational[1, 20] Pi], -0.5999999999999996}, {
      Rational[1, 2] (-1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -0.5999999999999996}, {
      Rational[1, 2] (-1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -0.2999999999999996}, {
      2 Sin[Rational[1, 20] Pi], (-2) 
       Cos[Rational[1, 20] Pi], -0.2999999999999996}}, {{
     0.31286893008046174`, -1.9753766811902755`, -0.5999999999999996}, {
     0.6180339887498949, -1.902113032590307, -0.5999999999999996}, {
     0.6180339887498949, -1.902113032590307, -0.2999999999999996}, {
     0.31286893008046174`, -1.9753766811902755`, -0.2999999999999996}}]], 
   Polygon3DBox[
    NCache[{{2 Sin[Rational[1, 20] Pi], (-2) 
       Cos[Rational[1, 20] Pi], -0.2999999999999996}, {
      Rational[1, 2] (-1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], -0.2999999999999996}
      , {Rational[1, 2] (-1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       4.440892098500626*^-16}, {
      2 Sin[Rational[1, 20] Pi], (-2) Cos[Rational[1, 20] Pi], 
       4.440892098500626*^-16}}, {{
     0.31286893008046174`, -1.9753766811902755`, -0.2999999999999996}, {
     0.6180339887498949, -1.902113032590307, -0.2999999999999996}, {
     0.6180339887498949, -1.902113032590307, 4.440892098500626*^-16}, {
     0.31286893008046174`, -1.9753766811902755`, 4.440892098500626*^-16}}]], 
   Polygon3DBox[
    NCache[{{2 Sin[Rational[1, 20] Pi], (-2) Cos[Rational[1, 20] Pi], 
       4.440892098500626*^-16}, {
      Rational[1, 2] (-1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       4.440892098500626*^-16}, {
      Rational[1, 2] (-1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       0.3000000000000005}, {
      2 Sin[Rational[1, 20] Pi], (-2) Cos[Rational[1, 20] Pi], 
       0.3000000000000005}}, {{0.31286893008046174`, -1.9753766811902755`, 
     4.440892098500626*^-16}, {0.6180339887498949, -1.902113032590307, 
     4.440892098500626*^-16}, {0.6180339887498949, -1.902113032590307, 
     0.3000000000000005}, {0.31286893008046174`, -1.9753766811902755`, 
     0.3000000000000005}}]], 
   Polygon3DBox[
    NCache[{{2 Sin[Rational[1, 20] Pi], (-2) Cos[Rational[1, 20] Pi], 
       0.3000000000000005}, {
      Rational[1, 2] (-1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       0.3000000000000005}, {
      Rational[1, 2] (-1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       0.6000000000000005}, {
      2 Sin[Rational[1, 20] Pi], (-2) Cos[Rational[1, 20] Pi], 
       0.6000000000000005}}, {{0.31286893008046174`, -1.9753766811902755`, 
     0.3000000000000005}, {0.6180339887498949, -1.902113032590307, 
     0.3000000000000005}, {0.6180339887498949, -1.902113032590307, 
     0.6000000000000005}, {0.31286893008046174`, -1.9753766811902755`, 
     0.6000000000000005}}]], 
   Polygon3DBox[
    NCache[{{2 Sin[Rational[1, 20] Pi], (-2) Cos[Rational[1, 20] Pi], 
       0.6000000000000005}, {
      Rational[1, 2] (-1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       0.6000000000000005}, {
      Rational[1, 2] (-1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       0.9000000000000006}, {
      2 Sin[Rational[1, 20] Pi], (-2) Cos[Rational[1, 20] Pi], 
       0.9000000000000006}}, {{0.31286893008046174`, -1.9753766811902755`, 
     0.6000000000000005}, {0.6180339887498949, -1.902113032590307, 
     0.6000000000000005}, {0.6180339887498949, -1.902113032590307, 
     0.9000000000000006}, {0.31286893008046174`, -1.9753766811902755`, 
     0.9000000000000006}}]], 
   Polygon3DBox[
    NCache[{{2 Sin[Rational[1, 20] Pi], (-2) Cos[Rational[1, 20] Pi], 
       0.9000000000000006}, {
      Rational[1, 2] (-1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       0.9000000000000006}, {
      Rational[1, 2] (-1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       1.2000000000000006`}, {
      2 Sin[Rational[1, 20] Pi], (-2) Cos[Rational[1, 20] Pi], 
       1.2000000000000006`}}, {{0.31286893008046174`, -1.9753766811902755`, 
     0.9000000000000006}, {0.6180339887498949, -1.902113032590307, 
     0.9000000000000006}, {0.6180339887498949, -1.902113032590307, 
     1.2000000000000006`}, {0.31286893008046174`, -1.9753766811902755`, 
     1.2000000000000006`}}]], 
   Polygon3DBox[
    NCache[{{2 Sin[Rational[1, 20] Pi], (-2) Cos[Rational[1, 20] Pi], 
       1.2000000000000006`}, {
      Rational[1, 2] (-1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       1.2000000000000006`}, {
      Rational[1, 2] (-1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       1.5000000000000007`}, {
      2 Sin[Rational[1, 20] Pi], (-2) Cos[Rational[1, 20] Pi], 
       1.5000000000000007`}}, {{0.31286893008046174`, -1.9753766811902755`, 
     1.2000000000000006`}, {0.6180339887498949, -1.902113032590307, 
     1.2000000000000006`}, {0.6180339887498949, -1.902113032590307, 
     1.5000000000000007`}, {0.31286893008046174`, -1.9753766811902755`, 
     1.5000000000000007`}}]], 
   Polygon3DBox[
    NCache[{{2 Sin[Rational[1, 20] Pi], (-2) Cos[Rational[1, 20] Pi], 
       1.5000000000000007`}, {
      Rational[1, 2] (-1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       1.5000000000000007`}, {
      Rational[1, 2] (-1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       1.8000000000000007`}, {
      2 Sin[Rational[1, 20] Pi], (-2) Cos[Rational[1, 20] Pi], 
       1.8000000000000007`}}, {{0.31286893008046174`, -1.9753766811902755`, 
     1.5000000000000007`}, {0.6180339887498949, -1.902113032590307, 
     1.5000000000000007`}, {0.6180339887498949, -1.902113032590307, 
     1.8000000000000007`}, {0.31286893008046174`, -1.9753766811902755`, 
     1.8000000000000007`}}]], 
   Polygon3DBox[
    NCache[{{2 Sin[Rational[1, 20] Pi], (-2) Cos[Rational[1, 20] Pi], 
       1.8000000000000007`}, {
      Rational[1, 2] (-1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       1.8000000000000007`}, {
      Rational[1, 2] (-1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       2.1000000000000005`}, {
      2 Sin[Rational[1, 20] Pi], (-2) Cos[Rational[1, 20] Pi], 
       2.1000000000000005`}}, {{0.31286893008046174`, -1.9753766811902755`, 
     1.8000000000000007`}, {0.6180339887498949, -1.902113032590307, 
     1.8000000000000007`}, {0.6180339887498949, -1.902113032590307, 
     2.1000000000000005`}, {0.31286893008046174`, -1.9753766811902755`, 
     2.1000000000000005`}}]], 
   Polygon3DBox[
    NCache[{{2 Sin[Rational[1, 20] Pi], (-2) Cos[Rational[1, 20] Pi], 
       2.1000000000000005`}, {
      Rational[1, 2] (-1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       2.1000000000000005`}, {
      Rational[1, 2] (-1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       2.4000000000000004`}, {
      2 Sin[Rational[1, 20] Pi], (-2) Cos[Rational[1, 20] Pi], 
       2.4000000000000004`}}, {{0.31286893008046174`, -1.9753766811902755`, 
     2.1000000000000005`}, {0.6180339887498949, -1.902113032590307, 
     2.1000000000000005`}, {0.6180339887498949, -1.902113032590307, 
     2.4000000000000004`}, {0.31286893008046174`, -1.9753766811902755`, 
     2.4000000000000004`}}]], 
   Polygon3DBox[
    NCache[{{2 Sin[Rational[1, 20] Pi], (-2) Cos[Rational[1, 20] Pi], 
       2.400000000000001}, {
      Rational[1, 2] (-1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       2.400000000000001}, {
      Rational[1, 2] (-1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       2.700000000000001}, {
      2 Sin[Rational[1, 20] Pi], (-2) Cos[Rational[1, 20] Pi], 
       2.700000000000001}}, {{0.31286893008046174`, -1.9753766811902755`, 
     2.400000000000001}, {0.6180339887498949, -1.902113032590307, 
     2.400000000000001}, {0.6180339887498949, -1.902113032590307, 
     2.700000000000001}, {0.31286893008046174`, -1.9753766811902755`, 
     2.700000000000001}}]], 
   Polygon3DBox[
    NCache[{{2 Sin[Rational[1, 20] Pi], (-2) Cos[Rational[1, 20] Pi], 
       2.700000000000001}, {
      Rational[1, 2] (-1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       2.700000000000001}, {
      Rational[1, 2] (-1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       3.000000000000001}, {
      2 Sin[Rational[1, 20] Pi], (-2) Cos[Rational[1, 20] Pi], 
       3.000000000000001}}, {{0.31286893008046174`, -1.9753766811902755`, 
     2.700000000000001}, {0.6180339887498949, -1.902113032590307, 
     2.700000000000001}, {0.6180339887498949, -1.902113032590307, 
     3.000000000000001}, {0.31286893008046174`, -1.9753766811902755`, 
     3.000000000000001}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (-1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], -3.}, {
      2 Sin[Rational[3, 20] Pi], (-2) Cos[Rational[3, 20] Pi], -3.}, {
      2 Sin[Rational[3, 20] Pi], (-2) Cos[Rational[3, 20] Pi], -2.7}, {
      Rational[1, 2] (-1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], -2.7}}, {{
     0.6180339887498949, -1.902113032590307, -3.}, {
     0.9079809994790936, -1.7820130483767358`, -3.}, {
     0.9079809994790936, -1.7820130483767358`, -2.7}, {
     0.6180339887498949, -1.902113032590307, -2.7}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (-1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], -2.7}, {
      2 Sin[Rational[3, 20] Pi], (-2) Cos[Rational[3, 20] Pi], -2.7}, {
      2 Sin[Rational[3, 20] Pi], (-2) 
       Cos[Rational[3, 20] Pi], -2.4000000000000004`}, {
      Rational[1, 2] (-1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -2.4000000000000004`}}, {{
     0.6180339887498949, -1.902113032590307, -2.7}, {
     0.9079809994790936, -1.7820130483767358`, -2.7}, {
     0.9079809994790936, -1.7820130483767358`, -2.4000000000000004`}, {
     0.6180339887498949, -1.902113032590307, -2.4000000000000004`}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (-1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], -2.4}, {
      2 Sin[Rational[3, 20] Pi], (-2) Cos[Rational[3, 20] Pi], -2.4}, {
      2 Sin[Rational[3, 20] Pi], (-2) 
       Cos[Rational[3, 20] Pi], -2.0999999999999996`}, {
      Rational[1, 2] (-1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -2.0999999999999996`}}, {{
     0.6180339887498949, -1.902113032590307, -2.4}, {
     0.9079809994790936, -1.7820130483767358`, -2.4}, {
     0.9079809994790936, -1.7820130483767358`, -2.0999999999999996`}, {
     0.6180339887498949, -1.902113032590307, -2.0999999999999996`}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (-1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -2.0999999999999996`}, {
      2 Sin[Rational[3, 20] Pi], (-2) 
       Cos[Rational[3, 20] Pi], -2.0999999999999996`}, {
      2 Sin[Rational[3, 20] Pi], (-2) 
       Cos[Rational[3, 20] Pi], -1.7999999999999996`}, {
      Rational[1, 2] (-1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -1.7999999999999996`}}, {{
     0.6180339887498949, -1.902113032590307, -2.0999999999999996`}, {
     0.9079809994790936, -1.7820130483767358`, -2.0999999999999996`}, {
     0.9079809994790936, -1.7820130483767358`, -1.7999999999999996`}, {
     0.6180339887498949, -1.902113032590307, -1.7999999999999996`}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (-1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -1.7999999999999998`}, {
      2 Sin[Rational[3, 20] Pi], (-2) 
       Cos[Rational[3, 20] Pi], -1.7999999999999998`}, {
      2 Sin[Rational[3, 20] Pi], (-2) 
       Cos[Rational[3, 20] Pi], -1.4999999999999998`}, {
      Rational[1, 2] (-1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -1.4999999999999998`}}, {{
     0.6180339887498949, -1.902113032590307, -1.7999999999999998`}, {
     0.9079809994790936, -1.7820130483767358`, -1.7999999999999998`}, {
     0.9079809994790936, -1.7820130483767358`, -1.4999999999999998`}, {
     0.6180339887498949, -1.902113032590307, -1.4999999999999998`}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (-1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -1.4999999999999998`}, {
      2 Sin[Rational[3, 20] Pi], (-2) 
       Cos[Rational[3, 20] Pi], -1.4999999999999998`}, {
      2 Sin[Rational[3, 20] Pi], (-2) 
       Cos[Rational[3, 20] Pi], -1.1999999999999997`}, {
      Rational[1, 2] (-1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -1.1999999999999997`}}, {{
     0.6180339887498949, -1.902113032590307, -1.4999999999999998`}, {
     0.9079809994790936, -1.7820130483767358`, -1.4999999999999998`}, {
     0.9079809994790936, -1.7820130483767358`, -1.1999999999999997`}, {
     0.6180339887498949, -1.902113032590307, -1.1999999999999997`}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (-1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -1.1999999999999997`}, {
      2 Sin[Rational[3, 20] Pi], (-2) 
       Cos[Rational[3, 20] Pi], -1.1999999999999997`}, {
      2 Sin[Rational[3, 20] Pi], (-2) 
       Cos[Rational[3, 20] Pi], -0.8999999999999997}, {
      Rational[1, 2] (-1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -0.8999999999999997}}, {{
     0.6180339887498949, -1.902113032590307, -1.1999999999999997`}, {
     0.9079809994790936, -1.7820130483767358`, -1.1999999999999997`}, {
     0.9079809994790936, -1.7820130483767358`, -0.8999999999999997}, {
     0.6180339887498949, -1.902113032590307, -0.8999999999999997}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (-1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -0.8999999999999997}, {
      2 Sin[Rational[3, 20] Pi], (-2) 
       Cos[Rational[3, 20] Pi], -0.8999999999999997}, {
      2 Sin[Rational[3, 20] Pi], (-2) 
       Cos[Rational[3, 20] Pi], -0.5999999999999996}, {
      Rational[1, 2] (-1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -0.5999999999999996}}, {{
     0.6180339887498949, -1.902113032590307, -0.8999999999999997}, {
     0.9079809994790936, -1.7820130483767358`, -0.8999999999999997}, {
     0.9079809994790936, -1.7820130483767358`, -0.5999999999999996}, {
     0.6180339887498949, -1.902113032590307, -0.5999999999999996}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (-1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -0.5999999999999996}, {
      2 Sin[Rational[3, 20] Pi], (-2) 
       Cos[Rational[3, 20] Pi], -0.5999999999999996}, {
      2 Sin[Rational[3, 20] Pi], (-2) 
       Cos[Rational[3, 20] Pi], -0.2999999999999996}, {
      Rational[1, 2] (-1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -0.2999999999999996}}, {{
     0.6180339887498949, -1.902113032590307, -0.5999999999999996}, {
     0.9079809994790936, -1.7820130483767358`, -0.5999999999999996}, {
     0.9079809994790936, -1.7820130483767358`, -0.2999999999999996}, {
     0.6180339887498949, -1.902113032590307, -0.2999999999999996}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (-1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -0.2999999999999996}, {
      2 Sin[Rational[3, 20] Pi], (-2) 
       Cos[Rational[3, 20] Pi], -0.2999999999999996}, {
      2 Sin[Rational[3, 20] Pi], (-2) Cos[Rational[3, 20] Pi], 
       4.440892098500626*^-16}, {
      Rational[1, 2] (-1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       4.440892098500626*^-16}}, {{
     0.6180339887498949, -1.902113032590307, -0.2999999999999996}, {
     0.9079809994790936, -1.7820130483767358`, -0.2999999999999996}, {
     0.9079809994790936, -1.7820130483767358`, 4.440892098500626*^-16}, {
     0.6180339887498949, -1.902113032590307, 4.440892098500626*^-16}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (-1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       4.440892098500626*^-16}, {
      2 Sin[Rational[3, 20] Pi], (-2) Cos[Rational[3, 20] Pi], 
       4.440892098500626*^-16}, {
      2 Sin[Rational[3, 20] Pi], (-2) Cos[Rational[3, 20] Pi], 
       0.3000000000000005}, {
      Rational[1, 2] (-1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       0.3000000000000005}}, {{0.6180339887498949, -1.902113032590307, 
     4.440892098500626*^-16}, {0.9079809994790936, -1.7820130483767358`, 
     4.440892098500626*^-16}, {0.9079809994790936, -1.7820130483767358`, 
     0.3000000000000005}, {0.6180339887498949, -1.902113032590307, 
     0.3000000000000005}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (-1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       0.3000000000000005}, {
      2 Sin[Rational[3, 20] Pi], (-2) Cos[Rational[3, 20] Pi], 
       0.3000000000000005}, {
      2 Sin[Rational[3, 20] Pi], (-2) Cos[Rational[3, 20] Pi], 
       0.6000000000000005}, {
      Rational[1, 2] (-1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       0.6000000000000005}}, {{0.6180339887498949, -1.902113032590307, 
     0.3000000000000005}, {0.9079809994790936, -1.7820130483767358`, 
     0.3000000000000005}, {0.9079809994790936, -1.7820130483767358`, 
     0.6000000000000005}, {0.6180339887498949, -1.902113032590307, 
     0.6000000000000005}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (-1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       0.6000000000000005}, {
      2 Sin[Rational[3, 20] Pi], (-2) Cos[Rational[3, 20] Pi], 
       0.6000000000000005}, {
      2 Sin[Rational[3, 20] Pi], (-2) Cos[Rational[3, 20] Pi], 
       0.9000000000000006}, {
      Rational[1, 2] (-1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       0.9000000000000006}}, {{0.6180339887498949, -1.902113032590307, 
     0.6000000000000005}, {0.9079809994790936, -1.7820130483767358`, 
     0.6000000000000005}, {0.9079809994790936, -1.7820130483767358`, 
     0.9000000000000006}, {0.6180339887498949, -1.902113032590307, 
     0.9000000000000006}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (-1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       0.9000000000000006}, {
      2 Sin[Rational[3, 20] Pi], (-2) Cos[Rational[3, 20] Pi], 
       0.9000000000000006}, {
      2 Sin[Rational[3, 20] Pi], (-2) Cos[Rational[3, 20] Pi], 
       1.2000000000000006`}, {
      Rational[1, 2] (-1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       1.2000000000000006`}}, {{0.6180339887498949, -1.902113032590307, 
     0.9000000000000006}, {0.9079809994790936, -1.7820130483767358`, 
     0.9000000000000006}, {0.9079809994790936, -1.7820130483767358`, 
     1.2000000000000006`}, {0.6180339887498949, -1.902113032590307, 
     1.2000000000000006`}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (-1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       1.2000000000000006`}, {
      2 Sin[Rational[3, 20] Pi], (-2) Cos[Rational[3, 20] Pi], 
       1.2000000000000006`}, {
      2 Sin[Rational[3, 20] Pi], (-2) Cos[Rational[3, 20] Pi], 
       1.5000000000000007`}, {
      Rational[1, 2] (-1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       1.5000000000000007`}}, {{0.6180339887498949, -1.902113032590307, 
     1.2000000000000006`}, {0.9079809994790936, -1.7820130483767358`, 
     1.2000000000000006`}, {0.9079809994790936, -1.7820130483767358`, 
     1.5000000000000007`}, {0.6180339887498949, -1.902113032590307, 
     1.5000000000000007`}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (-1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       1.5000000000000007`}, {
      2 Sin[Rational[3, 20] Pi], (-2) Cos[Rational[3, 20] Pi], 
       1.5000000000000007`}, {
      2 Sin[Rational[3, 20] Pi], (-2) Cos[Rational[3, 20] Pi], 
       1.8000000000000007`}, {
      Rational[1, 2] (-1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       1.8000000000000007`}}, {{0.6180339887498949, -1.902113032590307, 
     1.5000000000000007`}, {0.9079809994790936, -1.7820130483767358`, 
     1.5000000000000007`}, {0.9079809994790936, -1.7820130483767358`, 
     1.8000000000000007`}, {0.6180339887498949, -1.902113032590307, 
     1.8000000000000007`}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (-1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       1.8000000000000007`}, {
      2 Sin[Rational[3, 20] Pi], (-2) Cos[Rational[3, 20] Pi], 
       1.8000000000000007`}, {
      2 Sin[Rational[3, 20] Pi], (-2) Cos[Rational[3, 20] Pi], 
       2.1000000000000005`}, {
      Rational[1, 2] (-1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       2.1000000000000005`}}, {{0.6180339887498949, -1.902113032590307, 
     1.8000000000000007`}, {0.9079809994790936, -1.7820130483767358`, 
     1.8000000000000007`}, {0.9079809994790936, -1.7820130483767358`, 
     2.1000000000000005`}, {0.6180339887498949, -1.902113032590307, 
     2.1000000000000005`}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (-1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       2.1000000000000005`}, {
      2 Sin[Rational[3, 20] Pi], (-2) Cos[Rational[3, 20] Pi], 
       2.1000000000000005`}, {
      2 Sin[Rational[3, 20] Pi], (-2) Cos[Rational[3, 20] Pi], 
       2.4000000000000004`}, {
      Rational[1, 2] (-1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       2.4000000000000004`}}, {{0.6180339887498949, -1.902113032590307, 
     2.1000000000000005`}, {0.9079809994790936, -1.7820130483767358`, 
     2.1000000000000005`}, {0.9079809994790936, -1.7820130483767358`, 
     2.4000000000000004`}, {0.6180339887498949, -1.902113032590307, 
     2.4000000000000004`}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (-1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       2.400000000000001}, {
      2 Sin[Rational[3, 20] Pi], (-2) Cos[Rational[3, 20] Pi], 
       2.400000000000001}, {
      2 Sin[Rational[3, 20] Pi], (-2) Cos[Rational[3, 20] Pi], 
       2.700000000000001}, {
      Rational[1, 2] (-1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       2.700000000000001}}, {{0.6180339887498949, -1.902113032590307, 
     2.400000000000001}, {0.9079809994790936, -1.7820130483767358`, 
     2.400000000000001}, {0.9079809994790936, -1.7820130483767358`, 
     2.700000000000001}, {0.6180339887498949, -1.902113032590307, 
     2.700000000000001}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (-1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       2.700000000000001}, {
      2 Sin[Rational[3, 20] Pi], (-2) Cos[Rational[3, 20] Pi], 
       2.700000000000001}, {
      2 Sin[Rational[3, 20] Pi], (-2) Cos[Rational[3, 20] Pi], 
       3.000000000000001}, {
      Rational[1, 2] (-1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       3.000000000000001}}, {{0.6180339887498949, -1.902113032590307, 
     2.700000000000001}, {0.9079809994790936, -1.7820130483767358`, 
     2.700000000000001}, {0.9079809994790936, -1.7820130483767358`, 
     3.000000000000001}, {0.6180339887498949, -1.902113032590307, 
     3.000000000000001}}]], 
   Polygon3DBox[
    NCache[{{2 Sin[Rational[3, 20] Pi], (-2) Cos[Rational[3, 20] Pi], -3.}, {
      2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 - 5^Rational[1, 2]), -3.}, {
      2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 - 5^Rational[1, 2]), -2.7}, {
      2 Sin[Rational[3, 20] Pi], (-2) Cos[Rational[3, 20] Pi], -2.7}}, {{
     0.9079809994790936, -1.7820130483767358`, -3.}, {
     1.1755705045849463`, -1.618033988749895, -3.}, {
     1.1755705045849463`, -1.618033988749895, -2.7}, {
     0.9079809994790936, -1.7820130483767358`, -2.7}}]], 
   Polygon3DBox[
    NCache[{{2 Sin[Rational[3, 20] Pi], (-2) Cos[Rational[3, 20] Pi], -2.7}, {
      2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 - 5^Rational[1, 2]), -2.7}, {
      2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 - 5^Rational[1, 2]), -2.4000000000000004`}, {
      2 Sin[Rational[3, 20] Pi], (-2) 
       Cos[Rational[3, 20] Pi], -2.4000000000000004`}}, {{
     0.9079809994790936, -1.7820130483767358`, -2.7}, {
     1.1755705045849463`, -1.618033988749895, -2.7}, {
     1.1755705045849463`, -1.618033988749895, -2.4000000000000004`}, {
     0.9079809994790936, -1.7820130483767358`, -2.4000000000000004`}}]], 
   Polygon3DBox[
    NCache[{{2 Sin[Rational[3, 20] Pi], (-2) Cos[Rational[3, 20] Pi], -2.4}, {
      2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 - 5^Rational[1, 2]), -2.4}, {
      2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 - 5^Rational[1, 2]), -2.0999999999999996`}, {
      2 Sin[Rational[3, 20] Pi], (-2) 
       Cos[Rational[3, 20] Pi], -2.0999999999999996`}}, {{
     0.9079809994790936, -1.7820130483767358`, -2.4}, {
     1.1755705045849463`, -1.618033988749895, -2.4}, {
     1.1755705045849463`, -1.618033988749895, -2.0999999999999996`}, {
     0.9079809994790936, -1.7820130483767358`, -2.0999999999999996`}}]], 
   Polygon3DBox[
    NCache[{{2 Sin[Rational[3, 20] Pi], (-2) 
       Cos[Rational[3, 20] Pi], -2.0999999999999996`}, {
      2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 - 5^Rational[1, 2]), -2.0999999999999996`}, {
      2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 - 5^Rational[1, 2]), -1.7999999999999996`}, {
      2 Sin[Rational[3, 20] Pi], (-2) 
       Cos[Rational[3, 20] Pi], -1.7999999999999996`}}, {{
     0.9079809994790936, -1.7820130483767358`, -2.0999999999999996`}, {
     1.1755705045849463`, -1.618033988749895, -2.0999999999999996`}, {
     1.1755705045849463`, -1.618033988749895, -1.7999999999999996`}, {
     0.9079809994790936, -1.7820130483767358`, -1.7999999999999996`}}]], 
   Polygon3DBox[
    NCache[{{2 Sin[Rational[3, 20] Pi], (-2) 
       Cos[Rational[3, 20] Pi], -1.7999999999999998`}, {
      2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 - 5^Rational[1, 2]), -1.7999999999999998`}, {
      2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 - 5^Rational[1, 2]), -1.4999999999999998`}, {
      2 Sin[Rational[3, 20] Pi], (-2) 
       Cos[Rational[3, 20] Pi], -1.4999999999999998`}}, {{
     0.9079809994790936, -1.7820130483767358`, -1.7999999999999998`}, {
     1.1755705045849463`, -1.618033988749895, -1.7999999999999998`}, {
     1.1755705045849463`, -1.618033988749895, -1.4999999999999998`}, {
     0.9079809994790936, -1.7820130483767358`, -1.4999999999999998`}}]], 
   Polygon3DBox[
    NCache[{{2 Sin[Rational[3, 20] Pi], (-2) 
       Cos[Rational[3, 20] Pi], -1.4999999999999998`}, {
      2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 - 5^Rational[1, 2]), -1.4999999999999998`}, {
      2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 - 5^Rational[1, 2]), -1.1999999999999997`}, {
      2 Sin[Rational[3, 20] Pi], (-2) 
       Cos[Rational[3, 20] Pi], -1.1999999999999997`}}, {{
     0.9079809994790936, -1.7820130483767358`, -1.4999999999999998`}, {
     1.1755705045849463`, -1.618033988749895, -1.4999999999999998`}, {
     1.1755705045849463`, -1.618033988749895, -1.1999999999999997`}, {
     0.9079809994790936, -1.7820130483767358`, -1.1999999999999997`}}]], 
   Polygon3DBox[
    NCache[{{2 Sin[Rational[3, 20] Pi], (-2) 
       Cos[Rational[3, 20] Pi], -1.1999999999999997`}, {
      2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 - 5^Rational[1, 2]), -1.1999999999999997`}, {
      2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 - 5^Rational[1, 2]), -0.8999999999999997}, {
      2 Sin[Rational[3, 20] Pi], (-2) 
       Cos[Rational[3, 20] Pi], -0.8999999999999997}}, {{
     0.9079809994790936, -1.7820130483767358`, -1.1999999999999997`}, {
     1.1755705045849463`, -1.618033988749895, -1.1999999999999997`}, {
     1.1755705045849463`, -1.618033988749895, -0.8999999999999997}, {
     0.9079809994790936, -1.7820130483767358`, -0.8999999999999997}}]], 
   Polygon3DBox[
    NCache[{{2 Sin[Rational[3, 20] Pi], (-2) 
       Cos[Rational[3, 20] Pi], -0.8999999999999997}, {
      2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 - 5^Rational[1, 2]), -0.8999999999999997}, {
      2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 - 5^Rational[1, 2]), -0.5999999999999996}, {
      2 Sin[Rational[3, 20] Pi], (-2) 
       Cos[Rational[3, 20] Pi], -0.5999999999999996}}, {{
     0.9079809994790936, -1.7820130483767358`, -0.8999999999999997}, {
     1.1755705045849463`, -1.618033988749895, -0.8999999999999997}, {
     1.1755705045849463`, -1.618033988749895, -0.5999999999999996}, {
     0.9079809994790936, -1.7820130483767358`, -0.5999999999999996}}]], 
   Polygon3DBox[
    NCache[{{2 Sin[Rational[3, 20] Pi], (-2) 
       Cos[Rational[3, 20] Pi], -0.5999999999999996}, {
      2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 - 5^Rational[1, 2]), -0.5999999999999996}, {
      2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 - 5^Rational[1, 2]), -0.2999999999999996}, {
      2 Sin[Rational[3, 20] Pi], (-2) 
       Cos[Rational[3, 20] Pi], -0.2999999999999996}}, {{
     0.9079809994790936, -1.7820130483767358`, -0.5999999999999996}, {
     1.1755705045849463`, -1.618033988749895, -0.5999999999999996}, {
     1.1755705045849463`, -1.618033988749895, -0.2999999999999996}, {
     0.9079809994790936, -1.7820130483767358`, -0.2999999999999996}}]], 
   Polygon3DBox[
    NCache[{{2 Sin[Rational[3, 20] Pi], (-2) 
       Cos[Rational[3, 20] Pi], -0.2999999999999996}, {
      2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 - 5^Rational[1, 2]), -0.2999999999999996}, {
      2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 - 5^Rational[1, 2]), 4.440892098500626*^-16}, {
      2 Sin[Rational[3, 20] Pi], (-2) Cos[Rational[3, 20] Pi], 
       4.440892098500626*^-16}}, {{
     0.9079809994790936, -1.7820130483767358`, -0.2999999999999996}, {
     1.1755705045849463`, -1.618033988749895, -0.2999999999999996}, {
     1.1755705045849463`, -1.618033988749895, 4.440892098500626*^-16}, {
     0.9079809994790936, -1.7820130483767358`, 4.440892098500626*^-16}}]], 
   Polygon3DBox[
    NCache[{{2 Sin[Rational[3, 20] Pi], (-2) Cos[Rational[3, 20] Pi], 
       4.440892098500626*^-16}, {
      2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 - 5^Rational[1, 2]), 4.440892098500626*^-16}, {
      2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 - 5^Rational[1, 2]), 0.3000000000000005}, {
      2 Sin[Rational[3, 20] Pi], (-2) Cos[Rational[3, 20] Pi], 
       0.3000000000000005}}, {{0.9079809994790936, -1.7820130483767358`, 
     4.440892098500626*^-16}, {1.1755705045849463`, -1.618033988749895, 
     4.440892098500626*^-16}, {1.1755705045849463`, -1.618033988749895, 
     0.3000000000000005}, {0.9079809994790936, -1.7820130483767358`, 
     0.3000000000000005}}]], 
   Polygon3DBox[
    NCache[{{2 Sin[Rational[3, 20] Pi], (-2) Cos[Rational[3, 20] Pi], 
       0.3000000000000005}, {
      2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 - 5^Rational[1, 2]), 0.3000000000000005}, {
      2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 - 5^Rational[1, 2]), 0.6000000000000005}, {
      2 Sin[Rational[3, 20] Pi], (-2) Cos[Rational[3, 20] Pi], 
       0.6000000000000005}}, {{0.9079809994790936, -1.7820130483767358`, 
     0.3000000000000005}, {1.1755705045849463`, -1.618033988749895, 
     0.3000000000000005}, {1.1755705045849463`, -1.618033988749895, 
     0.6000000000000005}, {0.9079809994790936, -1.7820130483767358`, 
     0.6000000000000005}}]], 
   Polygon3DBox[
    NCache[{{2 Sin[Rational[3, 20] Pi], (-2) Cos[Rational[3, 20] Pi], 
       0.6000000000000005}, {
      2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 - 5^Rational[1, 2]), 0.6000000000000005}, {
      2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 - 5^Rational[1, 2]), 0.9000000000000006}, {
      2 Sin[Rational[3, 20] Pi], (-2) Cos[Rational[3, 20] Pi], 
       0.9000000000000006}}, {{0.9079809994790936, -1.7820130483767358`, 
     0.6000000000000005}, {1.1755705045849463`, -1.618033988749895, 
     0.6000000000000005}, {1.1755705045849463`, -1.618033988749895, 
     0.9000000000000006}, {0.9079809994790936, -1.7820130483767358`, 
     0.9000000000000006}}]], 
   Polygon3DBox[
    NCache[{{2 Sin[Rational[3, 20] Pi], (-2) Cos[Rational[3, 20] Pi], 
       0.9000000000000006}, {
      2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 - 5^Rational[1, 2]), 0.9000000000000006}, {
      2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 - 5^Rational[1, 2]), 1.2000000000000006`}, {
      2 Sin[Rational[3, 20] Pi], (-2) Cos[Rational[3, 20] Pi], 
       1.2000000000000006`}}, {{0.9079809994790936, -1.7820130483767358`, 
     0.9000000000000006}, {1.1755705045849463`, -1.618033988749895, 
     0.9000000000000006}, {1.1755705045849463`, -1.618033988749895, 
     1.2000000000000006`}, {0.9079809994790936, -1.7820130483767358`, 
     1.2000000000000006`}}]], 
   Polygon3DBox[
    NCache[{{2 Sin[Rational[3, 20] Pi], (-2) Cos[Rational[3, 20] Pi], 
       1.2000000000000006`}, {
      2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 - 5^Rational[1, 2]), 1.2000000000000006`}, {
      2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 - 5^Rational[1, 2]), 1.5000000000000007`}, {
      2 Sin[Rational[3, 20] Pi], (-2) Cos[Rational[3, 20] Pi], 
       1.5000000000000007`}}, {{0.9079809994790936, -1.7820130483767358`, 
     1.2000000000000006`}, {1.1755705045849463`, -1.618033988749895, 
     1.2000000000000006`}, {1.1755705045849463`, -1.618033988749895, 
     1.5000000000000007`}, {0.9079809994790936, -1.7820130483767358`, 
     1.5000000000000007`}}]], 
   Polygon3DBox[
    NCache[{{2 Sin[Rational[3, 20] Pi], (-2) Cos[Rational[3, 20] Pi], 
       1.5000000000000007`}, {
      2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 - 5^Rational[1, 2]), 1.5000000000000007`}, {
      2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 - 5^Rational[1, 2]), 1.8000000000000007`}, {
      2 Sin[Rational[3, 20] Pi], (-2) Cos[Rational[3, 20] Pi], 
       1.8000000000000007`}}, {{0.9079809994790936, -1.7820130483767358`, 
     1.5000000000000007`}, {1.1755705045849463`, -1.618033988749895, 
     1.5000000000000007`}, {1.1755705045849463`, -1.618033988749895, 
     1.8000000000000007`}, {0.9079809994790936, -1.7820130483767358`, 
     1.8000000000000007`}}]], 
   Polygon3DBox[
    NCache[{{2 Sin[Rational[3, 20] Pi], (-2) Cos[Rational[3, 20] Pi], 
       1.8000000000000007`}, {
      2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 - 5^Rational[1, 2]), 1.8000000000000007`}, {
      2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 - 5^Rational[1, 2]), 2.1000000000000005`}, {
      2 Sin[Rational[3, 20] Pi], (-2) Cos[Rational[3, 20] Pi], 
       2.1000000000000005`}}, {{0.9079809994790936, -1.7820130483767358`, 
     1.8000000000000007`}, {1.1755705045849463`, -1.618033988749895, 
     1.8000000000000007`}, {1.1755705045849463`, -1.618033988749895, 
     2.1000000000000005`}, {0.9079809994790936, -1.7820130483767358`, 
     2.1000000000000005`}}]], 
   Polygon3DBox[
    NCache[{{2 Sin[Rational[3, 20] Pi], (-2) Cos[Rational[3, 20] Pi], 
       2.1000000000000005`}, {
      2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 - 5^Rational[1, 2]), 2.1000000000000005`}, {
      2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 - 5^Rational[1, 2]), 2.4000000000000004`}, {
      2 Sin[Rational[3, 20] Pi], (-2) Cos[Rational[3, 20] Pi], 
       2.4000000000000004`}}, {{0.9079809994790936, -1.7820130483767358`, 
     2.1000000000000005`}, {1.1755705045849463`, -1.618033988749895, 
     2.1000000000000005`}, {1.1755705045849463`, -1.618033988749895, 
     2.4000000000000004`}, {0.9079809994790936, -1.7820130483767358`, 
     2.4000000000000004`}}]], 
   Polygon3DBox[
    NCache[{{2 Sin[Rational[3, 20] Pi], (-2) Cos[Rational[3, 20] Pi], 
       2.400000000000001}, {
      2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 - 5^Rational[1, 2]), 2.400000000000001}, {
      2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 - 5^Rational[1, 2]), 2.700000000000001}, {
      2 Sin[Rational[3, 20] Pi], (-2) Cos[Rational[3, 20] Pi], 
       2.700000000000001}}, {{0.9079809994790936, -1.7820130483767358`, 
     2.400000000000001}, {1.1755705045849463`, -1.618033988749895, 
     2.400000000000001}, {1.1755705045849463`, -1.618033988749895, 
     2.700000000000001}, {0.9079809994790936, -1.7820130483767358`, 
     2.700000000000001}}]], 
   Polygon3DBox[
    NCache[{{2 Sin[Rational[3, 20] Pi], (-2) Cos[Rational[3, 20] Pi], 
       2.700000000000001}, {
      2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 - 5^Rational[1, 2]), 2.700000000000001}, {
      2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 - 5^Rational[1, 2]), 3.000000000000001}, {
      2 Sin[Rational[3, 20] Pi], (-2) Cos[Rational[3, 20] Pi], 
       3.000000000000001}}, {{0.9079809994790936, -1.7820130483767358`, 
     2.700000000000001}, {1.1755705045849463`, -1.618033988749895, 
     2.700000000000001}, {1.1755705045849463`, -1.618033988749895, 
     3.000000000000001}, {0.9079809994790936, -1.7820130483767358`, 
     3.000000000000001}}]], 
   Polygon3DBox[
    NCache[{{2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 2] (-1 - 5^Rational[1, 2]), -3.}, {
      2^Rational[1, 2], -2^Rational[1, 2], -3.}, {
      2^Rational[1, 2], -2^Rational[1, 2], -2.7}, {
      2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 - 5^Rational[1, 2]), -2.7}}, {{
     1.1755705045849463`, -1.618033988749895, -3.}, {
     1.4142135623730951`, -1.4142135623730951`, -3.}, {
     1.4142135623730951`, -1.4142135623730951`, -2.7}, {
     1.1755705045849463`, -1.618033988749895, -2.7}}]], 
   Polygon3DBox[
    NCache[{{2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 2] (-1 - 5^Rational[1, 2]), -2.7}, {
      2^Rational[1, 2], -2^Rational[1, 2], -2.7}, {
      2^Rational[1, 2], -2^Rational[1, 2], -2.4000000000000004`}, {
      2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 - 5^Rational[1, 2]), -2.4000000000000004`}}, {{
     1.1755705045849463`, -1.618033988749895, -2.7}, {
     1.4142135623730951`, -1.4142135623730951`, -2.7}, {
     1.4142135623730951`, -1.4142135623730951`, -2.4000000000000004`}, {
     1.1755705045849463`, -1.618033988749895, -2.4000000000000004`}}]], 
   Polygon3DBox[
    NCache[{{2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 2] (-1 - 5^Rational[1, 2]), -2.4}, {
      2^Rational[1, 2], -2^Rational[1, 2], -2.4}, {
      2^Rational[1, 2], -2^Rational[1, 2], -2.0999999999999996`}, {
      2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 - 5^Rational[1, 2]), -2.0999999999999996`}}, {{
     1.1755705045849463`, -1.618033988749895, -2.4}, {
     1.4142135623730951`, -1.4142135623730951`, -2.4}, {
     1.4142135623730951`, -1.4142135623730951`, -2.0999999999999996`}, {
     1.1755705045849463`, -1.618033988749895, -2.0999999999999996`}}]], 
   Polygon3DBox[
    NCache[{{2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], 
       Rational[1, 2] (-1 - 5^Rational[1, 2]), -2.0999999999999996`}, {
      2^Rational[1, 2], -2^Rational[1, 2], -2.0999999999999996`}, {
      2^Rational[1, 2], -2^Rational[1, 2], -1.7999999999999996`}, {
      2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 - 5^Rational[1, 2]), -1.7999999999999996`}}, {{
     1.1755705045849463`, -1.618033988749895, -2.0999999999999996`}, {
     1.4142135623730951`, -1.4142135623730951`, -2.0999999999999996`}, {
     1.4142135623730951`, -1.4142135623730951`, -1.7999999999999996`}, {
     1.1755705045849463`, -1.618033988749895, -1.7999999999999996`}}]], 
   Polygon3DBox[
    NCache[{{2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], 
       Rational[1, 2] (-1 - 5^Rational[1, 2]), -1.7999999999999998`}, {
      2^Rational[1, 2], -2^Rational[1, 2], -1.7999999999999998`}, {
      2^Rational[1, 2], -2^Rational[1, 2], -1.4999999999999998`}, {
      2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 - 5^Rational[1, 2]), -1.4999999999999998`}}, {{
     1.1755705045849463`, -1.618033988749895, -1.7999999999999998`}, {
     1.4142135623730951`, -1.4142135623730951`, -1.7999999999999998`}, {
     1.4142135623730951`, -1.4142135623730951`, -1.4999999999999998`}, {
     1.1755705045849463`, -1.618033988749895, -1.4999999999999998`}}]], 
   Polygon3DBox[
    NCache[{{2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], 
       Rational[1, 2] (-1 - 5^Rational[1, 2]), -1.4999999999999998`}, {
      2^Rational[1, 2], -2^Rational[1, 2], -1.4999999999999998`}, {
      2^Rational[1, 2], -2^Rational[1, 2], -1.1999999999999997`}, {
      2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 - 5^Rational[1, 2]), -1.1999999999999997`}}, {{
     1.1755705045849463`, -1.618033988749895, -1.4999999999999998`}, {
     1.4142135623730951`, -1.4142135623730951`, -1.4999999999999998`}, {
     1.4142135623730951`, -1.4142135623730951`, -1.1999999999999997`}, {
     1.1755705045849463`, -1.618033988749895, -1.1999999999999997`}}]], 
   Polygon3DBox[
    NCache[{{2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], 
       Rational[1, 2] (-1 - 5^Rational[1, 2]), -1.1999999999999997`}, {
      2^Rational[1, 2], -2^Rational[1, 2], -1.1999999999999997`}, {
      2^Rational[1, 2], -2^Rational[1, 2], -0.8999999999999997}, {
      2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 - 5^Rational[1, 2]), -0.8999999999999997}}, {{
     1.1755705045849463`, -1.618033988749895, -1.1999999999999997`}, {
     1.4142135623730951`, -1.4142135623730951`, -1.1999999999999997`}, {
     1.4142135623730951`, -1.4142135623730951`, -0.8999999999999997}, {
     1.1755705045849463`, -1.618033988749895, -0.8999999999999997}}]], 
   Polygon3DBox[
    NCache[{{2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], 
       Rational[1, 2] (-1 - 5^Rational[1, 2]), -0.8999999999999997}, {
      2^Rational[1, 2], -2^Rational[1, 2], -0.8999999999999997}, {
      2^Rational[1, 2], -2^Rational[1, 2], -0.5999999999999996}, {
      2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 - 5^Rational[1, 2]), -0.5999999999999996}}, {{
     1.1755705045849463`, -1.618033988749895, -0.8999999999999997}, {
     1.4142135623730951`, -1.4142135623730951`, -0.8999999999999997}, {
     1.4142135623730951`, -1.4142135623730951`, -0.5999999999999996}, {
     1.1755705045849463`, -1.618033988749895, -0.5999999999999996}}]], 
   Polygon3DBox[
    NCache[{{2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], 
       Rational[1, 2] (-1 - 5^Rational[1, 2]), -0.5999999999999996}, {
      2^Rational[1, 2], -2^Rational[1, 2], -0.5999999999999996}, {
      2^Rational[1, 2], -2^Rational[1, 2], -0.2999999999999996}, {
      2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 - 5^Rational[1, 2]), -0.2999999999999996}}, {{
     1.1755705045849463`, -1.618033988749895, -0.5999999999999996}, {
     1.4142135623730951`, -1.4142135623730951`, -0.5999999999999996}, {
     1.4142135623730951`, -1.4142135623730951`, -0.2999999999999996}, {
     1.1755705045849463`, -1.618033988749895, -0.2999999999999996}}]], 
   Polygon3DBox[
    NCache[{{2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], 
       Rational[1, 2] (-1 - 5^Rational[1, 2]), -0.2999999999999996}, {
      2^Rational[1, 2], -2^Rational[1, 2], -0.2999999999999996}, {
      2^Rational[1, 2], -2^Rational[1, 2], 4.440892098500626*^-16}, {
      2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 - 5^Rational[1, 2]), 4.440892098500626*^-16}}, {{
     1.1755705045849463`, -1.618033988749895, -0.2999999999999996}, {
     1.4142135623730951`, -1.4142135623730951`, -0.2999999999999996}, {
     1.4142135623730951`, -1.4142135623730951`, 4.440892098500626*^-16}, {
     1.1755705045849463`, -1.618033988749895, 4.440892098500626*^-16}}]], 
   Polygon3DBox[
    NCache[{{2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       4.440892098500626*^-16}, {
      2^Rational[1, 2], -2^Rational[1, 2], 4.440892098500626*^-16}, {
      2^Rational[1, 2], -2^Rational[1, 2], 0.3000000000000005}, {
      2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 - 5^Rational[1, 2]), 0.3000000000000005}}, {{
     1.1755705045849463`, -1.618033988749895, 4.440892098500626*^-16}, {
     1.4142135623730951`, -1.4142135623730951`, 4.440892098500626*^-16}, {
     1.4142135623730951`, -1.4142135623730951`, 0.3000000000000005}, {
     1.1755705045849463`, -1.618033988749895, 0.3000000000000005}}]], 
   Polygon3DBox[
    NCache[{{2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       0.3000000000000005}, {
      2^Rational[1, 2], -2^Rational[1, 2], 0.3000000000000005}, {
      2^Rational[1, 2], -2^Rational[1, 2], 0.6000000000000005}, {
      2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 - 5^Rational[1, 2]), 0.6000000000000005}}, {{
     1.1755705045849463`, -1.618033988749895, 0.3000000000000005}, {
     1.4142135623730951`, -1.4142135623730951`, 0.3000000000000005}, {
     1.4142135623730951`, -1.4142135623730951`, 0.6000000000000005}, {
     1.1755705045849463`, -1.618033988749895, 0.6000000000000005}}]], 
   Polygon3DBox[
    NCache[{{2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       0.6000000000000005}, {
      2^Rational[1, 2], -2^Rational[1, 2], 0.6000000000000005}, {
      2^Rational[1, 2], -2^Rational[1, 2], 0.9000000000000006}, {
      2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 - 5^Rational[1, 2]), 0.9000000000000006}}, {{
     1.1755705045849463`, -1.618033988749895, 0.6000000000000005}, {
     1.4142135623730951`, -1.4142135623730951`, 0.6000000000000005}, {
     1.4142135623730951`, -1.4142135623730951`, 0.9000000000000006}, {
     1.1755705045849463`, -1.618033988749895, 0.9000000000000006}}]], 
   Polygon3DBox[
    NCache[{{2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       0.9000000000000006}, {
      2^Rational[1, 2], -2^Rational[1, 2], 0.9000000000000006}, {
      2^Rational[1, 2], -2^Rational[1, 2], 1.2000000000000006`}, {
      2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 - 5^Rational[1, 2]), 1.2000000000000006`}}, {{
     1.1755705045849463`, -1.618033988749895, 0.9000000000000006}, {
     1.4142135623730951`, -1.4142135623730951`, 0.9000000000000006}, {
     1.4142135623730951`, -1.4142135623730951`, 1.2000000000000006`}, {
     1.1755705045849463`, -1.618033988749895, 1.2000000000000006`}}]], 
   Polygon3DBox[
    NCache[{{2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       1.2000000000000006`}, {
      2^Rational[1, 2], -2^Rational[1, 2], 1.2000000000000006`}, {
      2^Rational[1, 2], -2^Rational[1, 2], 1.5000000000000007`}, {
      2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 - 5^Rational[1, 2]), 1.5000000000000007`}}, {{
     1.1755705045849463`, -1.618033988749895, 1.2000000000000006`}, {
     1.4142135623730951`, -1.4142135623730951`, 1.2000000000000006`}, {
     1.4142135623730951`, -1.4142135623730951`, 1.5000000000000007`}, {
     1.1755705045849463`, -1.618033988749895, 1.5000000000000007`}}]], 
   Polygon3DBox[
    NCache[{{2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       1.5000000000000007`}, {
      2^Rational[1, 2], -2^Rational[1, 2], 1.5000000000000007`}, {
      2^Rational[1, 2], -2^Rational[1, 2], 1.8000000000000007`}, {
      2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 - 5^Rational[1, 2]), 1.8000000000000007`}}, {{
     1.1755705045849463`, -1.618033988749895, 1.5000000000000007`}, {
     1.4142135623730951`, -1.4142135623730951`, 1.5000000000000007`}, {
     1.4142135623730951`, -1.4142135623730951`, 1.8000000000000007`}, {
     1.1755705045849463`, -1.618033988749895, 1.8000000000000007`}}]], 
   Polygon3DBox[
    NCache[{{2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       1.8000000000000007`}, {
      2^Rational[1, 2], -2^Rational[1, 2], 1.8000000000000007`}, {
      2^Rational[1, 2], -2^Rational[1, 2], 2.1000000000000005`}, {
      2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 - 5^Rational[1, 2]), 2.1000000000000005`}}, {{
     1.1755705045849463`, -1.618033988749895, 1.8000000000000007`}, {
     1.4142135623730951`, -1.4142135623730951`, 1.8000000000000007`}, {
     1.4142135623730951`, -1.4142135623730951`, 2.1000000000000005`}, {
     1.1755705045849463`, -1.618033988749895, 2.1000000000000005`}}]], 
   Polygon3DBox[
    NCache[{{2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       2.1000000000000005`}, {
      2^Rational[1, 2], -2^Rational[1, 2], 2.1000000000000005`}, {
      2^Rational[1, 2], -2^Rational[1, 2], 2.4000000000000004`}, {
      2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 - 5^Rational[1, 2]), 2.4000000000000004`}}, {{
     1.1755705045849463`, -1.618033988749895, 2.1000000000000005`}, {
     1.4142135623730951`, -1.4142135623730951`, 2.1000000000000005`}, {
     1.4142135623730951`, -1.4142135623730951`, 2.4000000000000004`}, {
     1.1755705045849463`, -1.618033988749895, 2.4000000000000004`}}]], 
   Polygon3DBox[
    NCache[{{2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       2.400000000000001}, {
      2^Rational[1, 2], -2^Rational[1, 2], 2.400000000000001}, {
      2^Rational[1, 2], -2^Rational[1, 2], 2.700000000000001}, {
      2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 - 5^Rational[1, 2]), 2.700000000000001}}, {{
     1.1755705045849463`, -1.618033988749895, 2.400000000000001}, {
     1.4142135623730951`, -1.4142135623730951`, 2.400000000000001}, {
     1.4142135623730951`, -1.4142135623730951`, 2.700000000000001}, {
     1.1755705045849463`, -1.618033988749895, 2.700000000000001}}]], 
   Polygon3DBox[
    NCache[{{2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 2] (-1 - 5^Rational[1, 2]), 
       2.700000000000001}, {
      2^Rational[1, 2], -2^Rational[1, 2], 2.700000000000001}, {
      2^Rational[1, 2], -2^Rational[1, 2], 3.000000000000001}, {
      2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 2] (-1 - 5^Rational[1, 2]), 3.000000000000001}}, {{
     1.1755705045849463`, -1.618033988749895, 2.700000000000001}, {
     1.4142135623730951`, -1.4142135623730951`, 2.700000000000001}, {
     1.4142135623730951`, -1.4142135623730951`, 3.000000000000001}, {
     1.1755705045849463`, -1.618033988749895, 3.000000000000001}}]], 
   Polygon3DBox[
    NCache[{{2^Rational[1, 2], -2^Rational[1, 2], -3.}, {
      Rational[1, 2] (1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], -3.}, {
      Rational[1, 2] (1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], -2.7}, {
      2^Rational[1, 2], -2^Rational[1, 2], -2.7}}, {{
     1.4142135623730951`, -1.4142135623730951`, -3.}, {
     1.618033988749895, -1.1755705045849463`, -3.}, {
     1.618033988749895, -1.1755705045849463`, -2.7}, {
     1.4142135623730951`, -1.4142135623730951`, -2.7}}]], 
   Polygon3DBox[
    NCache[{{2^Rational[1, 2], -2^Rational[1, 2], -2.7}, {
      Rational[1, 2] (1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], -2.7}, {
      Rational[1, 2] (1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -2.4000000000000004`}, {
      2^Rational[1, 2], -2^Rational[1, 2], -2.4000000000000004`}}, {{
     1.4142135623730951`, -1.4142135623730951`, -2.7}, {
     1.618033988749895, -1.1755705045849463`, -2.7}, {
     1.618033988749895, -1.1755705045849463`, -2.4000000000000004`}, {
     1.4142135623730951`, -1.4142135623730951`, -2.4000000000000004`}}]], 
   Polygon3DBox[
    NCache[{{2^Rational[1, 2], -2^Rational[1, 2], -2.4}, {
      Rational[1, 2] (1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], -2.4}, {
      Rational[1, 2] (1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -2.0999999999999996`}, {
      2^Rational[1, 2], -2^Rational[1, 2], -2.0999999999999996`}}, {{
     1.4142135623730951`, -1.4142135623730951`, -2.4}, {
     1.618033988749895, -1.1755705045849463`, -2.4}, {
     1.618033988749895, -1.1755705045849463`, -2.0999999999999996`}, {
     1.4142135623730951`, -1.4142135623730951`, -2.0999999999999996`}}]], 
   Polygon3DBox[
    NCache[{{2^Rational[1, 2], -2^Rational[1, 2], -2.0999999999999996`}, {
      Rational[1, 2] (1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -2.0999999999999996`}, {
      Rational[1, 2] (1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -1.7999999999999996`}, {
      2^Rational[1, 2], -2^Rational[1, 2], -1.7999999999999996`}}, {{
     1.4142135623730951`, -1.4142135623730951`, -2.0999999999999996`}, {
     1.618033988749895, -1.1755705045849463`, -2.0999999999999996`}, {
     1.618033988749895, -1.1755705045849463`, -1.7999999999999996`}, {
     1.4142135623730951`, -1.4142135623730951`, -1.7999999999999996`}}]], 
   Polygon3DBox[
    NCache[{{2^Rational[1, 2], -2^Rational[1, 2], -1.7999999999999998`}, {
      Rational[1, 2] (1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -1.7999999999999998`}, {
      Rational[1, 2] (1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -1.4999999999999998`}, {
      2^Rational[1, 2], -2^Rational[1, 2], -1.4999999999999998`}}, {{
     1.4142135623730951`, -1.4142135623730951`, -1.7999999999999998`}, {
     1.618033988749895, -1.1755705045849463`, -1.7999999999999998`}, {
     1.618033988749895, -1.1755705045849463`, -1.4999999999999998`}, {
     1.4142135623730951`, -1.4142135623730951`, -1.4999999999999998`}}]], 
   Polygon3DBox[
    NCache[{{2^Rational[1, 2], -2^Rational[1, 2], -1.4999999999999998`}, {
      Rational[1, 2] (1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -1.4999999999999998`}, {
      Rational[1, 2] (1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -1.1999999999999997`}, {
      2^Rational[1, 2], -2^Rational[1, 2], -1.1999999999999997`}}, {{
     1.4142135623730951`, -1.4142135623730951`, -1.4999999999999998`}, {
     1.618033988749895, -1.1755705045849463`, -1.4999999999999998`}, {
     1.618033988749895, -1.1755705045849463`, -1.1999999999999997`}, {
     1.4142135623730951`, -1.4142135623730951`, -1.1999999999999997`}}]], 
   Polygon3DBox[
    NCache[{{2^Rational[1, 2], -2^Rational[1, 2], -1.1999999999999997`}, {
      Rational[1, 2] (1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -1.1999999999999997`}, {
      Rational[1, 2] (1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -0.8999999999999997}, {
      2^Rational[1, 2], -2^Rational[1, 2], -0.8999999999999997}}, {{
     1.4142135623730951`, -1.4142135623730951`, -1.1999999999999997`}, {
     1.618033988749895, -1.1755705045849463`, -1.1999999999999997`}, {
     1.618033988749895, -1.1755705045849463`, -0.8999999999999997}, {
     1.4142135623730951`, -1.4142135623730951`, -0.8999999999999997}}]], 
   Polygon3DBox[
    NCache[{{2^Rational[1, 2], -2^Rational[1, 2], -0.8999999999999997}, {
      Rational[1, 2] (1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -0.8999999999999997}, {
      Rational[1, 2] (1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -0.5999999999999996}, {
      2^Rational[1, 2], -2^Rational[1, 2], -0.5999999999999996}}, {{
     1.4142135623730951`, -1.4142135623730951`, -0.8999999999999997}, {
     1.618033988749895, -1.1755705045849463`, -0.8999999999999997}, {
     1.618033988749895, -1.1755705045849463`, -0.5999999999999996}, {
     1.4142135623730951`, -1.4142135623730951`, -0.5999999999999996}}]], 
   Polygon3DBox[
    NCache[{{2^Rational[1, 2], -2^Rational[1, 2], -0.5999999999999996}, {
      Rational[1, 2] (1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -0.5999999999999996}, {
      Rational[1, 2] (1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -0.2999999999999996}, {
      2^Rational[1, 2], -2^Rational[1, 2], -0.2999999999999996}}, {{
     1.4142135623730951`, -1.4142135623730951`, -0.5999999999999996}, {
     1.618033988749895, -1.1755705045849463`, -0.5999999999999996}, {
     1.618033988749895, -1.1755705045849463`, -0.2999999999999996}, {
     1.4142135623730951`, -1.4142135623730951`, -0.2999999999999996}}]], 
   Polygon3DBox[
    NCache[{{2^Rational[1, 2], -2^Rational[1, 2], -0.2999999999999996}, {
      Rational[1, 2] (1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -0.2999999999999996}, {
      Rational[1, 2] (1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       4.440892098500626*^-16}, {
      2^Rational[1, 2], -2^Rational[1, 2], 4.440892098500626*^-16}}, {{
     1.4142135623730951`, -1.4142135623730951`, -0.2999999999999996}, {
     1.618033988749895, -1.1755705045849463`, -0.2999999999999996}, {
     1.618033988749895, -1.1755705045849463`, 4.440892098500626*^-16}, {
     1.4142135623730951`, -1.4142135623730951`, 4.440892098500626*^-16}}]], 
   Polygon3DBox[
    NCache[{{2^Rational[1, 2], -2^Rational[1, 2], 4.440892098500626*^-16}, {
      Rational[1, 2] (1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       4.440892098500626*^-16}, {
      Rational[1, 2] (1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       0.3000000000000005}, {
      2^Rational[1, 2], -2^Rational[1, 2], 0.3000000000000005}}, {{
     1.4142135623730951`, -1.4142135623730951`, 4.440892098500626*^-16}, {
     1.618033988749895, -1.1755705045849463`, 4.440892098500626*^-16}, {
     1.618033988749895, -1.1755705045849463`, 0.3000000000000005}, {
     1.4142135623730951`, -1.4142135623730951`, 0.3000000000000005}}]], 
   Polygon3DBox[
    NCache[{{2^Rational[1, 2], -2^Rational[1, 2], 0.3000000000000005}, {
      Rational[1, 2] (1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       0.3000000000000005}, {
      Rational[1, 2] (1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       0.6000000000000005}, {
      2^Rational[1, 2], -2^Rational[1, 2], 0.6000000000000005}}, {{
     1.4142135623730951`, -1.4142135623730951`, 0.3000000000000005}, {
     1.618033988749895, -1.1755705045849463`, 0.3000000000000005}, {
     1.618033988749895, -1.1755705045849463`, 0.6000000000000005}, {
     1.4142135623730951`, -1.4142135623730951`, 0.6000000000000005}}]], 
   Polygon3DBox[
    NCache[{{2^Rational[1, 2], -2^Rational[1, 2], 0.6000000000000005}, {
      Rational[1, 2] (1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       0.6000000000000005}, {
      Rational[1, 2] (1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       0.9000000000000006}, {
      2^Rational[1, 2], -2^Rational[1, 2], 0.9000000000000006}}, {{
     1.4142135623730951`, -1.4142135623730951`, 0.6000000000000005}, {
     1.618033988749895, -1.1755705045849463`, 0.6000000000000005}, {
     1.618033988749895, -1.1755705045849463`, 0.9000000000000006}, {
     1.4142135623730951`, -1.4142135623730951`, 0.9000000000000006}}]], 
   Polygon3DBox[
    NCache[{{2^Rational[1, 2], -2^Rational[1, 2], 0.9000000000000006}, {
      Rational[1, 2] (1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       0.9000000000000006}, {
      Rational[1, 2] (1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       1.2000000000000006`}, {
      2^Rational[1, 2], -2^Rational[1, 2], 1.2000000000000006`}}, {{
     1.4142135623730951`, -1.4142135623730951`, 0.9000000000000006}, {
     1.618033988749895, -1.1755705045849463`, 0.9000000000000006}, {
     1.618033988749895, -1.1755705045849463`, 1.2000000000000006`}, {
     1.4142135623730951`, -1.4142135623730951`, 1.2000000000000006`}}]], 
   Polygon3DBox[
    NCache[{{2^Rational[1, 2], -2^Rational[1, 2], 1.2000000000000006`}, {
      Rational[1, 2] (1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       1.2000000000000006`}, {
      Rational[1, 2] (1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       1.5000000000000007`}, {
      2^Rational[1, 2], -2^Rational[1, 2], 1.5000000000000007`}}, {{
     1.4142135623730951`, -1.4142135623730951`, 1.2000000000000006`}, {
     1.618033988749895, -1.1755705045849463`, 1.2000000000000006`}, {
     1.618033988749895, -1.1755705045849463`, 1.5000000000000007`}, {
     1.4142135623730951`, -1.4142135623730951`, 1.5000000000000007`}}]], 
   Polygon3DBox[
    NCache[{{2^Rational[1, 2], -2^Rational[1, 2], 1.5000000000000007`}, {
      Rational[1, 2] (1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       1.5000000000000007`}, {
      Rational[1, 2] (1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       1.8000000000000007`}, {
      2^Rational[1, 2], -2^Rational[1, 2], 1.8000000000000007`}}, {{
     1.4142135623730951`, -1.4142135623730951`, 1.5000000000000007`}, {
     1.618033988749895, -1.1755705045849463`, 1.5000000000000007`}, {
     1.618033988749895, -1.1755705045849463`, 1.8000000000000007`}, {
     1.4142135623730951`, -1.4142135623730951`, 1.8000000000000007`}}]], 
   Polygon3DBox[
    NCache[{{2^Rational[1, 2], -2^Rational[1, 2], 1.8000000000000007`}, {
      Rational[1, 2] (1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       1.8000000000000007`}, {
      Rational[1, 2] (1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       2.1000000000000005`}, {
      2^Rational[1, 2], -2^Rational[1, 2], 2.1000000000000005`}}, {{
     1.4142135623730951`, -1.4142135623730951`, 1.8000000000000007`}, {
     1.618033988749895, -1.1755705045849463`, 1.8000000000000007`}, {
     1.618033988749895, -1.1755705045849463`, 2.1000000000000005`}, {
     1.4142135623730951`, -1.4142135623730951`, 2.1000000000000005`}}]], 
   Polygon3DBox[
    NCache[{{2^Rational[1, 2], -2^Rational[1, 2], 2.1000000000000005`}, {
      Rational[1, 2] (1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       2.1000000000000005`}, {
      Rational[1, 2] (1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       2.4000000000000004`}, {
      2^Rational[1, 2], -2^Rational[1, 2], 2.4000000000000004`}}, {{
     1.4142135623730951`, -1.4142135623730951`, 2.1000000000000005`}, {
     1.618033988749895, -1.1755705045849463`, 2.1000000000000005`}, {
     1.618033988749895, -1.1755705045849463`, 2.4000000000000004`}, {
     1.4142135623730951`, -1.4142135623730951`, 2.4000000000000004`}}]], 
   Polygon3DBox[
    NCache[{{2^Rational[1, 2], -2^Rational[1, 2], 2.400000000000001}, {
      Rational[1, 2] (1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       2.400000000000001}, {
      Rational[1, 2] (1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       2.700000000000001}, {
      2^Rational[1, 2], -2^Rational[1, 2], 2.700000000000001}}, {{
     1.4142135623730951`, -1.4142135623730951`, 2.400000000000001}, {
     1.618033988749895, -1.1755705045849463`, 2.400000000000001}, {
     1.618033988749895, -1.1755705045849463`, 2.700000000000001}, {
     1.4142135623730951`, -1.4142135623730951`, 2.700000000000001}}]], 
   Polygon3DBox[
    NCache[{{2^Rational[1, 2], -2^Rational[1, 2], 2.700000000000001}, {
      Rational[1, 2] (1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       2.700000000000001}, {
      Rational[1, 2] (1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       3.000000000000001}, {
      2^Rational[1, 2], -2^Rational[1, 2], 3.000000000000001}}, {{
     1.4142135623730951`, -1.4142135623730951`, 2.700000000000001}, {
     1.618033988749895, -1.1755705045849463`, 2.700000000000001}, {
     1.618033988749895, -1.1755705045849463`, 3.000000000000001}, {
     1.4142135623730951`, -1.4142135623730951`, 3.000000000000001}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], -3.}, {
      2 Cos[Rational[3, 20] Pi], (-2) Sin[Rational[3, 20] Pi], -3.}, {
      2 Cos[Rational[3, 20] Pi], (-2) Sin[Rational[3, 20] Pi], -2.7}, {
      Rational[1, 2] (1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], -2.7}}, {{
     1.618033988749895, -1.1755705045849463`, -3.}, {
     1.7820130483767358`, -0.9079809994790936, -3.}, {
     1.7820130483767358`, -0.9079809994790936, -2.7}, {
     1.618033988749895, -1.1755705045849463`, -2.7}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], -2.7}, {
      2 Cos[Rational[3, 20] Pi], (-2) Sin[Rational[3, 20] Pi], -2.7}, {
      2 Cos[Rational[3, 20] Pi], (-2) 
       Sin[Rational[3, 20] Pi], -2.4000000000000004`}, {
      Rational[1, 2] (1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -2.4000000000000004`}}, {{
     1.618033988749895, -1.1755705045849463`, -2.7}, {
     1.7820130483767358`, -0.9079809994790936, -2.7}, {
     1.7820130483767358`, -0.9079809994790936, -2.4000000000000004`}, {
     1.618033988749895, -1.1755705045849463`, -2.4000000000000004`}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], -2.4}, {
      2 Cos[Rational[3, 20] Pi], (-2) Sin[Rational[3, 20] Pi], -2.4}, {
      2 Cos[Rational[3, 20] Pi], (-2) 
       Sin[Rational[3, 20] Pi], -2.0999999999999996`}, {
      Rational[1, 2] (1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -2.0999999999999996`}}, {{
     1.618033988749895, -1.1755705045849463`, -2.4}, {
     1.7820130483767358`, -0.9079809994790936, -2.4}, {
     1.7820130483767358`, -0.9079809994790936, -2.0999999999999996`}, {
     1.618033988749895, -1.1755705045849463`, -2.0999999999999996`}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -2.0999999999999996`}, {
      2 Cos[Rational[3, 20] Pi], (-2) 
       Sin[Rational[3, 20] Pi], -2.0999999999999996`}, {
      2 Cos[Rational[3, 20] Pi], (-2) 
       Sin[Rational[3, 20] Pi], -1.7999999999999996`}, {
      Rational[1, 2] (1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -1.7999999999999996`}}, {{
     1.618033988749895, -1.1755705045849463`, -2.0999999999999996`}, {
     1.7820130483767358`, -0.9079809994790936, -2.0999999999999996`}, {
     1.7820130483767358`, -0.9079809994790936, -1.7999999999999996`}, {
     1.618033988749895, -1.1755705045849463`, -1.7999999999999996`}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -1.7999999999999998`}, {
      2 Cos[Rational[3, 20] Pi], (-2) 
       Sin[Rational[3, 20] Pi], -1.7999999999999998`}, {
      2 Cos[Rational[3, 20] Pi], (-2) 
       Sin[Rational[3, 20] Pi], -1.4999999999999998`}, {
      Rational[1, 2] (1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -1.4999999999999998`}}, {{
     1.618033988749895, -1.1755705045849463`, -1.7999999999999998`}, {
     1.7820130483767358`, -0.9079809994790936, -1.7999999999999998`}, {
     1.7820130483767358`, -0.9079809994790936, -1.4999999999999998`}, {
     1.618033988749895, -1.1755705045849463`, -1.4999999999999998`}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -1.4999999999999998`}, {
      2 Cos[Rational[3, 20] Pi], (-2) 
       Sin[Rational[3, 20] Pi], -1.4999999999999998`}, {
      2 Cos[Rational[3, 20] Pi], (-2) 
       Sin[Rational[3, 20] Pi], -1.1999999999999997`}, {
      Rational[1, 2] (1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -1.1999999999999997`}}, {{
     1.618033988749895, -1.1755705045849463`, -1.4999999999999998`}, {
     1.7820130483767358`, -0.9079809994790936, -1.4999999999999998`}, {
     1.7820130483767358`, -0.9079809994790936, -1.1999999999999997`}, {
     1.618033988749895, -1.1755705045849463`, -1.1999999999999997`}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -1.1999999999999997`}, {
      2 Cos[Rational[3, 20] Pi], (-2) 
       Sin[Rational[3, 20] Pi], -1.1999999999999997`}, {
      2 Cos[Rational[3, 20] Pi], (-2) 
       Sin[Rational[3, 20] Pi], -0.8999999999999997}, {
      Rational[1, 2] (1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -0.8999999999999997}}, {{
     1.618033988749895, -1.1755705045849463`, -1.1999999999999997`}, {
     1.7820130483767358`, -0.9079809994790936, -1.1999999999999997`}, {
     1.7820130483767358`, -0.9079809994790936, -0.8999999999999997}, {
     1.618033988749895, -1.1755705045849463`, -0.8999999999999997}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2] (1 + 
        5^Rational[1, 2]), (-2) (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], -0.8999999999999997}, {
      2 Cos[Ration